#ifndef __CAN_HW_CONFIG_H
#define __CAN_HW_CONFIG_H

#include "system_config.h"

#ifdef __cplusplus
extern "C" {
#endif

#define HW_CAN_COUNT               MAX_CAN_INTERFACES //  CAN 

#define MAX_HW_FILTER_BANK_PER_CAN 14 //      CAN
#define MAX_FILTER_TABLE_SIZE      (MAX_HW_FILTER_BANK_PER_CAN*sizeof(can_filter_t))

#define CAN_DRIVERS_PWR_PIN        GPIO_Pin_14        
#define CAN_DRIVERS_PWR_PORT       GPIOG

#if (DEVICE_TYPE == DEVICE_TYPE_VEGA_MT_25K || DEVICE_TYPE == DEVICE_TYPE_VEGA_MT_32K_LTE)
#define CAN_DRIVERS_PWR_OTYPE      GPIO_OType_OD
#define __CAN_DRIVERS_PWR_DIS()    (GPIO_SetBits(CAN_DRIVERS_PWR_PORT, CAN_DRIVERS_PWR_PIN))
#define __CAN_DRIVERS_PWR_EN()     (GPIO_ResetBits(CAN_DRIVERS_PWR_PORT, CAN_DRIVERS_PWR_PIN))
#endif //(DEVICE_TYPE == DEVICE_TYPE_VEGA_MT_25K || DEVICE_TYPE == DEVICE_TYPE_VEGA_MT_32K_LTE)

#if (DEVICE_TYPE == DEVICE_TYPE_VEGA_MT_32K_LTE_V2 || DEVICE_TYPE == DEVICE_TYPE_VEGA_MT_32K_LTE_V3)
#define CAN_DRIVERS_PWR_OTYPE      GPIO_OType_PP
#define __CAN_DRIVERS_PWR_DIS()    (GPIO_ResetBits(CAN_DRIVERS_PWR_PORT, CAN_DRIVERS_PWR_PIN))
#define __CAN_DRIVERS_PWR_EN()     (GPIO_SetBits(CAN_DRIVERS_PWR_PORT, CAN_DRIVERS_PWR_PIN))
#endif //(DEVICE_TYPE == DEVICE_TYPE_VEGA_MT_32K_LTE_V2 || DEVICE_TYPE == DEVICE_TYPE_VEGA_MT_32K_LTE_V3)

#define CAN_ID_UNKNOWN             0xFF

//CAN1
#define CAN1_ID                    0

#define CAN1_RX_PIN                GPIO_Pin_8
#define CAN1_RX_PORT               GPIOB

#define CAN1_TX_PIN                GPIO_Pin_9
#define CAN1_TX_PORT               GPIOB

#define __CAN1_REMAP()             {GPIO_PinAFConfig(CAN1_RX_PORT , GPIO_PinSource8, GPIO_AF8_CAN1); GPIO_PinAFConfig(CAN1_TX_PORT , GPIO_PinSource9, GPIO_AF8_CAN1);}

#define CAN1_RXE_PIN               GPIO_Pin_1
#define CAN1_RXE_PORT              GPIOF
#define CAN1_RXE_OTYPE             GPIO_OType_PP

#define __CAN1_NORMAL_MODE()       (GPIO_ResetBits(CAN1_RXE_PORT, CAN1_RXE_PIN))
#define __CAN1_STANDBY_MODE()      (GPIO_SetBits(CAN1_RXE_PORT, CAN1_RXE_PIN))

//CAN1    FIFO0
#define CAN1_FIFO                  CAN_FIFO0
#define CAN1_IRQn                  CAN1_RX0_IRQn
#define CAN1_RX_IRQHandler         CAN1_RX0_IRQHandler
#define CAN1_RX_IRQn_PRIO          15
#define CAN1_IT_FMP                CAN_IT_FMP0
#define CAN1_SCE_IRQn_PRIO         14

//CAN2
#define CAN2_ID                    (CAN1_ID+1)
#if (HW_CAN_COUNT > 1)
#define CAN2_RX_PIN                GPIO_Pin_5
#define CAN2_RX_PORT               GPIOB

#define CAN2_TX_PIN                GPIO_Pin_12
#define CAN2_TX_PORT               GPIOG

#define __CAN2_REMAP()             {GPIO_PinAFConfig(CAN2_RX_PORT , GPIO_PinSource5, GPIO_AF_CAN2); GPIO_PinAFConfig(CAN2_TX_PORT , GPIO_PinSource12, GPIO_AF_CAN2);}

#define CAN2_RXE_PIN               GPIO_Pin_15
#define CAN2_RXE_PORT              GPIOG
#define CAN2_RXE_OTYPE             GPIO_OType_PP

#define __CAN2_NORMAL_MODE()       (GPIO_ResetBits(CAN2_RXE_PORT, CAN2_RXE_PIN))
#define __CAN2_STANDBY_MODE()      (GPIO_SetBits(CAN2_RXE_PORT, CAN2_RXE_PIN))

//CAN2    FIFO0
#define CAN2_FIFO                  CAN_FIFO0
#define CAN2_IRQn                  CAN2_RX0_IRQn
#define CAN2_RX_IRQHandler         CAN2_RX0_IRQHandler
#define CAN2_RX_IRQn_PRIO          15
#define CAN2_IT_FMP                CAN_IT_FMP0
#define CAN2_SCE_IRQn_PRIO         14
#endif //(HW_CAN_COUNT > 1)

//CAN3
#define CAN3_ID                    (CAN1_ID+2)
#if (HW_CAN_COUNT > 2)
#define CAN3_RX_PIN                GPIO_Pin_3
#define CAN3_RX_PORT               GPIOB

#define CAN3_TX_PIN                GPIO_Pin_4
#define CAN3_TX_PORT               GPIOB

#define __CAN3_REMAP()             {GPIO_PinAFConfig(CAN3_RX_PORT , GPIO_PinSource3, GPIO_AF11_CAN3); GPIO_PinAFConfig(CAN3_TX_PORT , GPIO_PinSource4, GPIO_AF11_CAN3);}

#define CAN3_RXE_PIN               GPIO_Pin_6
#define CAN3_RXE_PORT              GPIOB
#define CAN3_RXE_OTYPE             GPIO_OType_PP

#define __CAN3_NORMAL_MODE()       (GPIO_ResetBits(CAN3_RXE_PORT, CAN3_RXE_PIN))
#define __CAN3_STANDBY_MODE()      (GPIO_SetBits(CAN3_RXE_PORT, CAN3_RXE_PIN))

//CAN3    FIFO1
#define CAN3_FIFO                  CAN_FIFO1
#define CAN3_IRQn                  CAN3_RX1_IRQn
#define CAN3_RX_IRQHandler         CAN3_RX1_IRQHandler
#define CAN3_RX_IRQn_PRIO          15
#define CAN3_IT_FMP                CAN_IT_FMP1
#define CAN3_SCE_IRQn_PRIO         14
#endif //(HW_CAN_COUNT > 2)

//  FIFO   CAN 
#define CAN_RX_QUEUE_LEN           64

#ifdef __cplusplus
}
#endif

#endif //__CAN_HW_CONFIG_H