#ifndef __SERVER_MAN_CONFIG_H
#define __SERVER_MAN_CONFIG_H

#include "system_config.h"
#if (DEVICE_TYPE == DEVICE_TYPE_VEGA_MT_32K_LTE || DEVICE_TYPE == DEVICE_TYPE_VEGA_MT_32K_LTE_V2)
#define USE_QUECTEL_MODEM_LIB
#elif (DEVICE_TYPE == DEVICE_TYPE_VEGA_MT_32K_LTE_V3)
#define USE_SIMCOM_MODEM_LIB
#else
#error
#endif

//#define DISABLE_CONFIGURATOR_TASK
//#define GSM_USB_FORWARDING

#if (defined(GSM_USB_FORWARDING) && !defined(DISABLE_CONFIGURATOR_TASK))
#error GSM_USB_FORWARDING err
#endif

#define MODEM_REBOOT_TIMEOUT_S                        (12*60*60)
#define NO_RX_DATA_SIM_CHANGE_OR_REBOOT_TIMEOUT_S     (5*60) //0 -  
#define USE_APN_CHANGE_WITHOUT_REBOOT                 //   APN   

#define SERVER_TCP_CNT                                MAX_SERVERS_COUNT //количество tcp-серверов
#define SERVER_MAX_ADDR_LEN                           (GSM_MAX_SERVER_ADDR_LEN+1)

#define SERVER_TCP_1_CONN_ID                          (SERVER_TCP_CNT-4)
#define SERVER_TCP_2_CONN_ID                          (SERVER_TCP_CNT-3)
#define SERVER_TCP_3_CONN_ID                          (SERVER_TCP_CNT-2)
#define SERVER_TCP_4_CONN_ID                          (SERVER_TCP_CNT-1)
#define SERVER_LAST_TCP_CONN_ID                       (SERVER_TCP_4_CONN_ID)
#define SERVER_USB_CONN_ID                            4
#define SERVER_LAST_COMMON_CONN_ID                    (SERVER_USB_CONN_ID)
#if defined(EXTERNAL_BLE_BOARD_PRESENT)
#define SERVER_BLE_CONN_ID                            5
#undef  SERVER_LAST_COMMON_CONN_ID
#define SERVER_LAST_COMMON_CONN_ID                    (SERVER_BLE_CONN_ID)
#endif //defined(EXTERNAL_BLE_BOARD_PRESENT)

#define MAX_SEND_AT_ATTEMPT                           4 //  AT ,   K
#define WDT_AND_RSSI_TIMEOUT_MS                       5000

/*----------------------------------------------------------------------------*/
#if (DEVICE_TYPE == DEVICE_TYPE_VEGA_MT_32K_LTE || DEVICE_TYPE == DEVICE_TYPE_VEGA_MT_32K_LTE_V2)
/*----------------------------------------------------------------------------*/
#define MAX_CONN_FAIL_COUNT_FOR_SIM_CHANGE_OR_REBOOT  10

#define QUECTEL_STATUS_PIN                            GPIO_Pin_11
#define QUECTEL_STATUS_PORT                           GPIOG
#define __GET_QUECTEL_STATUS_PIN_STATE()              (!GPIO_ReadInputDataBit(QUECTEL_STATUS_PORT, QUECTEL_STATUS_PIN))

#define QUECTEL_PWRKEY_PIN                            GPIO_Pin_7
#define QUECTEL_PWRKEY_PORT                           GPIOD
#define QUECTEL_PWRKEY_PIN_MODE                       GPIO_OType_PP
#define __QUECTEL_PWRKEY_PIN_HI()                     (GPIO_SetBits(QUECTEL_PWRKEY_PORT, QUECTEL_PWRKEY_PIN))
#define __QUECTEL_PWRKEY_PIN_LOW()                    (GPIO_ResetBits(QUECTEL_PWRKEY_PORT, QUECTEL_PWRKEY_PIN))

#if MAX_SIM_COUNT > 1
#define MAIN_SIM_ID                                   (0)
#define USE_FAST_SIM_CHANGE                           //     
#define NO_NETWORK_TIME_MS_FOR_CHANGE_SIM             (5*60*1000) //    ,       
#define CHECK_MAINT_SIM_TIMEOUT_MS                    (0)//   ,     ,       (0 -  )
#define PEREODIC_SIM_CHANGE_TIMEOUT_MS                (0)//      SIM (0 -  )
#define MODEM_SIM_SEL_PIN                             GPIO_Pin_10
#define MODEM_SIM_SEL_PORT                            GPIOG
#define MODEM_SIM_SEL_PIN_MODE                        GPIO_OType_PP
#define __MODEM_SEL_SIM_0()                           (GPIO_SetBits(MODEM_SIM_SEL_PORT, MODEM_SIM_SEL_PIN))
#define __MODEM_SEL_SIM_1()                           (GPIO_ResetBits(MODEM_SIM_SEL_PORT, MODEM_SIM_SEL_PIN))
#define __MODEM_SEL_SIM_NO_PHANTOM_POWER()            (__MODEM_SEL_SIM_1())
#endif //MAX_SIM_COUNT > 1
/*----------------------------------------------------------------------------*/
#elif (DEVICE_TYPE == DEVICE_TYPE_VEGA_MT_32K_LTE_V3)
/*----------------------------------------------------------------------------*/
#define MAX_CONN_FAIL_COUNT_FOR_SIM_CHANGE_OR_REBOOT  16
#define SIMCOM_STATUS_PIN                             GPIO_Pin_11
#define SIMCOM_STATUS_PORT                            GPIOG
#define __GET_SIMCOM_STATUS_PIN_STATE()               (!GPIO_ReadInputDataBit(SIMCOM_STATUS_PORT, SIMCOM_STATUS_PIN))

#define SIMCOM_PWRKEY_PIN                             GPIO_Pin_7
#define SIMCOM_PWRKEY_PORT                            GPIOD
#define SIMCOM_PWRKEY_PIN_MODE                        GPIO_OType_PP
#define __SIMCOM_PWRKEY_PIN_HI()                      (GPIO_SetBits(SIMCOM_PWRKEY_PORT, SIMCOM_PWRKEY_PIN))
#define __SIMCOM_PWRKEY_PIN_LOW()                     (GPIO_ResetBits(SIMCOM_PWRKEY_PORT, SIMCOM_PWRKEY_PIN))

#if MAX_SIM_COUNT > 1
#define MAIN_SIM_ID                                   (0)
//#define USE_FAST_SIM_CHANGE                         //     
#define NO_NETWORK_TIME_MS_FOR_CHANGE_SIM             (5*60*1000) //    ,       
#define CHECK_MAINT_SIM_TIMEOUT_MS                    (0)//   ,     ,       (0 -  )
#define PEREODIC_SIM_CHANGE_TIMEOUT_MS                (0)//      SIM (0 -  )
#define MODEM_SIM_SEL_PIN                             GPIO_Pin_10
#define MODEM_SIM_SEL_PORT                            GPIOG
#define MODEM_SIM_SEL_PIN_MODE                        GPIO_OType_PP
#define __MODEM_SEL_SIM_0()                           (GPIO_SetBits(MODEM_SIM_SEL_PORT, MODEM_SIM_SEL_PIN))
#define __MODEM_SEL_SIM_1()                           (GPIO_ResetBits(MODEM_SIM_SEL_PORT, MODEM_SIM_SEL_PIN))
#define __MODEM_SEL_SIM_NO_PHANTOM_POWER()            (__MODEM_SEL_SIM_1())
#endif //MAX_SIM_COUNT > 1
/*----------------------------------------------------------------------------*/
#else
/*----------------------------------------------------------------------------*/
#error
/*----------------------------------------------------------------------------*/
#endif //

#define MODEM_POWER_EN_PIN                            GPIO_Pin_12
#define MODEM_POWER_EN_PORT                           GPIOF
#define MODEM_POWER_EN_PIN_MODE                       GPIO_OType_PP
#define __MODEM_POWER_EN()                            (GPIO_SetBits(MODEM_POWER_EN_PORT, MODEM_POWER_EN_PIN))
#define __MODEM_POWER_DIS()                           (GPIO_ResetBits(MODEM_POWER_EN_PORT, MODEM_POWER_EN_PIN))

#define USE_PRECHARGE_MODEM_POWER
#if defined(USE_PRECHARGE_MODEM_POWER)
#define PRECHARGE_MODEM_POWER_PIN                     GPIO_Pin_11
#define PRECHARGE_MODEM_POWER_PORT                    GPIOF
#define PRECHARGE_MODEM_POWER_PIN_MODE                GPIO_OType_OD
#define __PRECHARGE_MODEM_POWER_ON()                  (GPIO_ResetBits(PRECHARGE_MODEM_POWER_PORT, PRECHARGE_MODEM_POWER_PIN))
#define __PRECHARGE_MODEM_POWER_OFF()                 (GPIO_SetBits(PRECHARGE_MODEM_POWER_PORT, PRECHARGE_MODEM_POWER_PIN))
#endif //defined(USE_PRECHARGE_MODEM_POWER)

#define USE_DISCHARGE_MODEM_POWER
#if defined(USE_DISCHARGE_MODEM_POWER)
#define DISCHARGE_MODEM_POWER_PIN                     GPIO_Pin_8
#define DISCHARGE_MODEM_POWER_PORT                    GPIOC
#define DISCHARGE_MODEM_POWER_PIN_MODE                GPIO_OType_PP
#define __DISCHARGE_MODEM_POWER_ON()                  (GPIO_SetBits(DISCHARGE_MODEM_POWER_PORT, DISCHARGE_MODEM_POWER_PIN))
#define __DISCHARGE_MODEM_POWER_OFF()                 (GPIO_ResetBits(DISCHARGE_MODEM_POWER_PORT, DISCHARGE_MODEM_POWER_PIN))
#endif //defined(USE_DISCHARGE_MODEM_POWER)

//#define USE_PULSED_MODEM_POWER_ON
#if defined(USE_PULSED_MODEM_POWER_ON)
#define MODEM_PWR_TIM_CLOCK_MHZ                       (TARGET_CPU_FREQ_HZ/1000000)
#define MODEM_PWR_TIM                                 TIM2
#define MODEM_PWR_TIM_IRQn                            TIM2_IRQn
#define MODEM_PWR_TIM_IRQHandler                      TIM2_IRQHandler
#define MODEM_PWR_TIM_IRQ_PRIORITY                    12//highest-2 priority with use FreeRTOS API
#define __MODEM_PWR_TIM_CLOCK_CMD(DISABLE_OR_DISABLE) (RCC_APB1PeriphClockCmd(RCC_APB1Periph_TIM2, DISABLE_OR_DISABLE))
#endif //defined(USE_PULSED_MODEM_POWER_ON)

#define MODEM_DTR_PIN                                 GPIO_Pin_5
#define MODEM_DTR_PORT                                GPIOG
#define MODEM_DTR_PIN_MODE                            GPIO_OType_PP
#define __MODEM_DTR_PIN_HI()                          (GPIO_SetBits(MODEM_DTR_PORT, MODEM_DTR_PIN))  //sleep
#define __MODEM_DTR_PIN_LOW()                         (GPIO_ResetBits(MODEM_DTR_PORT, MODEM_DTR_PIN)) //nosleep
#define __MODEM_DTR_PIN_IS_SLEEP()                    (GPIO_ReadOutputDataBit(MODEM_DTR_PORT, MODEM_DTR_PIN))

#if defined(VOICE_CALL_PRESENT)
//#define MIC_PWR_PIN                                 GPIO_Pin_13
#define MIC_PWR_PORT                                  GPIOD
#define MIC_PWR_PIN_MODE                              GPIO_Mode_Out_PP
#define __MIC_PWR_EN()                                (GPIO_SetBits(MIC_PWR_PORT, MIC_PWR_PIN))
#define __MIC_PWR_DIS()                               (GPIO_ResetBits(MIC_PWR_PORT, MIC_PWR_PIN))

//#define AMP_PWR_PIN                                 GPIO_Pin_12
#define AMP_PWR_PORT                                  GPIOE
#define AMP_PWR_PIN_MODE                              GPIO_Mode_Out_PP
#define __AMP_PWR_EN()                                (GPIO_SetBits(AMP_PWR_PORT, AMP_PWR_PIN))
#define __AMP_PWR_DIS()                               (GPIO_ResetBits(AMP_PWR_PORT, AMP_PWR_PIN))
#endif //VOICE_CALL_PRESENT
#endif //__SERVER_MAN_CONFIG_H