#ifndef __SIGNAL_MAN_CONFIG_H
#define __SIGNAL_MAN_CONFIG_H

#include "system_config.h"

#define ADC_ONBOARD_PIN                 GPIO_Pin_0
#define ADC_ONBOARD_PORT                GPIOC
#define ADC_ONBOARD_CHANEL              ADC_Channel_10

#if defined(INTERNAL_AKB_PRESENT)
#define ADC_LIPO_PIN                    GPIO_Pin_1
#define ADC_LIPO_PORT                   GPIOC
#define ADC_LIPO_CHANEL                 ADC_Channel_11

#define LIPO_CHARGE_PIN                 GPIO_Pin_2         
#define LIPO_CHARGE_PORT                GPIOB
#define LIPO_CHARGE_RCC                 RCC_AHB1Periph_GPIOB

#if defined(INTERNAL_AKB_ON_OFF_CONTROL_PRESENT)
#define LIPO_ON_PIN                     GPIO_Pin_13         
#define LIPO_ON_PORT                    GPIOF
#define LIPO_ON_RCC                     RCC_AHB1Periph_GPIOF
#endif //INTERNAL_AKB_ON_OFF_CONTROL_PRESENT
#endif //INTERNAL_AKB_PRESENT

#define VBAT_IN_DETECT_PIN              GPIO_Pin_0         
#define VBAT_IN_DETECT_PORT             GPIOF
#define VBAT_IN_DETECT_RCC              RCC_AHB1Periph_GPIOF

#if (defined(RS485_PRESENT) || defined(RS232_PRESENT))
#define RS232_RS485_PWR_PIN             GPIO_Pin_13         
#define RS232_RS485_PWR_PORT            GPIOG
#endif

#if defined(IGNITION_PRESENT)
#define IGN_PIN                         GPIO_Pin_1        
#define IGN_PORT                        GPIOB
#define IGN_RCC                         RCC_AHB1Periph_GPIOB
#endif //IGNITION_PRESENT

#if defined(TAMPERS_PRESENT)
#define TAMPER1_PIN                     GPIO_Pin_13        
#define TAMPER1_PORT                    GPIOC
#define TAMPER1_RCC                     RCC_AHB1Periph_GPIOC

#define TAMPER2_PIN                     GPIO_Pin_14        
#define TAMPER2_PORT                    GPIOF
#define TAMPER2_RCC                     RCC_AHB1Periph_GPIOF
#endif //TAMPERS_PRESENT

#if defined(INTERNAL_AKB_PRESENT)
// BQ24090DGQR   
#define __CHARGE_LIPO_DIS()             (GPIO_ResetBits(LIPO_CHARGE_PORT, LIPO_CHARGE_PIN))
#define __CHARGE_LIPO_EN()              (GPIO_SetBits(LIPO_CHARGE_PORT, LIPO_CHARGE_PIN))

#if defined(INTERNAL_AKB_ON_OFF_CONTROL_PRESENT)
#define __LIPO_ON_DIS()                 (GPIO_ResetBits(LIPO_ON_PORT, LIPO_ON_PIN))
#define __LIPO_ON_EN()                  (GPIO_SetBits(LIPO_ON_PORT, LIPO_ON_PIN))
#endif //INTERNAL_AKB_ON_OFF_CONTROL_PRESENT
#endif //INTERNAL_AKB_PRESENT

#if (defined(RS485_PRESENT) || defined(RS232_PRESENT))
#define __RS232_RS485_PWR_DIS()         (GPIO_ResetBits(RS232_RS485_PWR_PORT, RS232_RS485_PWR_PIN))
#define __RS232_RS485_PWR_EN()          (GPIO_SetBits(RS232_RS485_PWR_PORT, RS232_RS485_PWR_PIN))
#else
#define __RS232_RS485_PWR_DIS()         //
#define __RS232_RS485_PWR_EN()          //
#endif

#if defined(IGNITION_PRESENT)
#define __GET_IGN_STATE()               (GPIO_ReadInputDataBit(IGN_PORT, IGN_PIN))
#endif //IGNITION_PRESENT

#if defined(TAMPERS_PRESENT)
#define __GET_TAMPER1_STATE()           (!GPIO_ReadInputDataBit(TAMPER1_PORT, TAMPER1_PIN))
#define __GET_TAMPER2_STATE()           (!GPIO_ReadInputDataBit(TAMPER2_PORT, TAMPER2_PIN))
#endif //TAMPERS_PRESENT

#define __GET_VBAT_IN_DETECT_STATE()    (GPIO_ReadInputDataBit(VBAT_IN_DETECT_PORT, VBAT_IN_DETECT_PIN))

#define EXT_BT_PWR_PRESENT
#if defined(EXT_BT_PWR_PRESENT)  
#define EXT_BT_PWR_PIN                  GPIO_Pin_9         
#define EXT_BT_PWR_PORT                 GPIOC
#define EXT_BT_PWR_PORT_MODE            GPIO_OType_OD

#define  __EXT_BT_PWR_DIS()             (GPIO_SetBits(EXT_BT_PWR_PORT, EXT_BT_PWR_PIN))
#define  __EXT_BT_PWR_EN()              (GPIO_ResetBits(EXT_BT_PWR_PORT, EXT_BT_PWR_PIN))
#endif // EXT_BT_PWR_PRESENT

#endif //__SIGNAL_MAN_CONFIG_H