/**
  ******************************************************************************
  * File Name          : System_config.h
  * Description        : Настройки системы
  *
  *
  ******************************************************************************
*/

/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef SYSTEM_CONFIG_H
#define SYSTEM_CONFIG_H

/* Includes  -----------------------------------------------------------------*/
#include "build_info/revision.h"
#include "System/vega_device_types.h"

/* Defines  ------------------------------------------------------------------*/
#if defined(IS_DEBUG_BUILD)
//#define IS_HW_VERSION_1
//#define IS_HW_VERSION_2

//#define IS_RIO_2017_BUILD
//#define IS_KAPTUR_2016_BUILD
//#define IS_GENESIS_2017_BUILD
//#define IS_AUDI_A3_2018_BUILD
//#define IS_AUDI_Q3_2018_BUILD
//#define IS_PORSCHE_MACAN_2018_BUILD
//#define IS_PORSCHE_911_2018_BUILD
//#define IS_SKODA_OCTAVIA_2018_BUILD
//#define IS_SKODA_RAPID_2018_BUILD
//#define IS_VW_POLO_2018_BUILD
//#define IS_VW_CADDY_2018_BUILD
//#define IS_BMW_520I_2018_BUILD
//#define IS_MB_E200_2018_BUILD
//#define IS_HYUNDAI_SOLARIS_2017_TAXI_BUILD
//#define IS_FORD_TRANSIT_2017_BUILD
//#define IS_CITROEN_JUMPY_2018_BUILD
//#define IS_LADA_LARGUS_2017_BUILD
//#define IS_VOLVO_XC60_2018_BUILD
//#define IS_VOLVO_XC40_2018_BUILD
//#define IS_RANGE_ROVER_VELAR_2018_BUILD
//#define IS_VW_TRANSPORTER_2018_BUILD
//#define IS_HYUNDAI_CRETA_2019_BUILD
//#define IS_BMW_X1_2019_BUILD
//#define IS_FORD_MUSTANG_1965_BUILD
//#define IS_FORD_MUSTANG_1969_BUILD
#endif //IS_DEBUG_BUILD

#if defined(BOOTLOADER)
#define CUSTOM_CODE ""
#elif defined(IS_RIO_2017_BUILD)
#define CUSTOM_CODE " 'Rio'"
#elif defined(IS_KAPTUR_2016_BUILD)
#define CUSTOM_CODE " 'Kaptur'"
#elif defined(IS_GENESIS_2017_BUILD)
#define CUSTOM_CODE " 'Genesis'"
#elif defined(IS_AUDI_A3_2018_BUILD)
#define CUSTOM_CODE " 'A3'"
#elif defined(IS_AUDI_Q3_2018_BUILD)
#define CUSTOM_CODE " 'Q3'"
#elif defined(IS_PORSCHE_911_2018_BUILD)
#define CUSTOM_CODE " '911'"
#elif defined(IS_PORSCHE_MACAN_2018_BUILD)
#define CUSTOM_CODE " 'Macan'"
#elif defined(IS_SKODA_OCTAVIA_2018_BUILD)
#define CUSTOM_CODE " 'Octavia'"
#elif defined(IS_SKODA_RAPID_2018_BUILD)
#define CUSTOM_CODE " 'Rapid'"
#elif defined(IS_SKODA_RAPID_2013_BUILD)
#define CUSTOM_CODE " 'Rapid 2013'"
#elif defined(IS_VW_POLO_2018_BUILD)
#define CUSTOM_CODE " 'Polo'"
#elif defined(IS_VW_CADDY_2018_BUILD)
#define CUSTOM_CODE " 'Caddy'"
#elif defined(IS_BMW_520I_2018_BUILD)
#define CUSTOM_CODE " '520i'"
#elif defined(IS_MB_E200_2018_BUILD)
#define CUSTOM_CODE " 'E200'"
#elif defined(IS_TOYOTA_RAV4_2019_BUILD)
#define CUSTOM_CODE " 'RAV4'"
#elif defined(IS_FORD_TRANSIT_2017_BUILD)
#define CUSTOM_CODE " 'Transit'"
#elif defined(IS_CITROEN_JUMPY_2018_BUILD)
#define CUSTOM_CODE " 'Jumpy'"
#elif defined(IS_RENAULT_DOKKER_2018_BUILD)
#define CUSTOM_CODE " 'Dokker'"
#elif defined(IS_LADA_LARGUS_2017_BUILD)
#define CUSTOM_CODE " 'Largus'"
#elif defined(IS_HYUNDAI_SOLARIS_2017_TAXI_BUILD)
#define CUSTOM_CODE " 'Solaris Taxi'"
#elif defined(IS_SKODA_OCTAVIA_2018_TAXI_BUILD)
#define CUSTOM_CODE " 'Octavia Taxi'"
#elif defined(IS_VW_POLO_2018_TAXI_BUILD)
#define CUSTOM_CODE " 'Polo Taxi'"
#elif defined(IS_RENAULT_LOGAN_2018_TAXI_BUILD)
#define CUSTOM_CODE " 'Logan Taxi'"
#elif defined(IS_VOLVO_XC60_2018_BUILD)
#define CUSTOM_CODE " 'XC60'"
#elif defined(IS_VOLVO_XC40_2018_BUILD)
#define CUSTOM_CODE " 'XC40'"
#elif defined(IS_RANGE_ROVER_VELAR_2018_BUILD)
#define CUSTOM_CODE " 'Velar'"
#elif defined(IS_NISSAN_QASHQAI_2018_BUILD)
#define CUSTOM_CODE " 'Qashqai'"
#elif defined(IS_VW_TRANSPORTER_2018_BUILD)
#define CUSTOM_CODE " 'Transp'"
#elif defined(IS_HYUNDAI_CRETA_2019_BUILD)
#define CUSTOM_CODE " 'Creta'"
#elif defined(IS_BMW_X1_2019_BUILD)
#define CUSTOM_CODE " 'X1'"
#elif defined(IS_FORD_MUSTANG_1965_BUILD)
#define CUSTOM_CODE " 'Mustang65'"
#elif defined(IS_FORD_MUSTANG_1969_BUILD)
#define CUSTOM_CODE " 'Mustang69'"
#elif defined(IS_NISSAN_LEAF_2019_BUILD)
#define CUSTOM_CODE " 'Leaf'"
#elif defined(IS_PORSCHE_PANAMERA_2019_BUILD)
#define CUSTOM_CODE " 'Panamera'"
#elif defined(IS_HYUNDAI_SONATA_SD_2020_BUILD)
#define CUSTOM_CODE " 'Sonata SD'"
#elif defined(IS_RENAULT_LOGAN_2013_BUILD)
#define CUSTOM_CODE " 'Logan 2'"
#elif defined(IS_LADA_LARGUS_2020_BUILD)
#define CUSTOM_CODE " 'Largus 20'"
#elif defined(IS_RENAULT_DUSTER_2021_BUILD)
#define CUSTOM_CODE " 'Duster'"
#elif defined(IS_JEEP_WRANGLER_2018_BUILD)
#define CUSTOM_CODE " 'Wrangler'"
#elif defined(IS_AUDI_A6_2018_BUILD)
#define CUSTOM_CODE " 'A6 2018'"
#elif defined(IS_RENAULT_ARKANA_2018_BUILD)
#define CUSTOM_CODE " 'Arkana 18'"
#else
#error unknown build
#endif //

#if !defined(BOOTLOADER)
#if ( (defined(IS_RIO_2017_BUILD)+defined(IS_KAPTUR_2016_BUILD)+defined(IS_GENESIS_2017_BUILD)+defined(IS_AUDI_A3_2018_BUILD)+defined(IS_AUDI_Q3_2018_BUILD)+\
       defined(IS_PORSCHE_911_2018_BUILD)+defined(IS_PORSCHE_MACAN_2018_BUILD)+defined(IS_SKODA_OCTAVIA_2018_BUILD)+defined(IS_SKODA_RAPID_2018_BUILD)+\
       defined(IS_VW_POLO_2018_BUILD)+ defined(IS_VW_CADDY_2018_BUILD)+defined(IS_BMW_520I_2018_BUILD)+defined(IS_MB_E200_2018_BUILD)+defined(IS_TOYOTA_RAV4_2019_BUILD)+\
       defined(IS_FORD_TRANSIT_2017_BUILD)+defined(IS_CITROEN_JUMPY_2018_BUILD)+defined(IS_RENAULT_DOKKER_2018_BUILD)+defined(IS_LADA_LARGUS_2017_BUILD)+\
       defined(IS_HYUNDAI_SOLARIS_2017_TAXI_BUILD)+defined(IS_SKODA_OCTAVIA_2018_TAXI_BUILD)+defined(IS_VW_POLO_2018_TAXI_BUILD)+defined(IS_RENAULT_LOGAN_2018_TAXI_BUILD)+\
       defined(IS_VOLVO_XC60_2018_BUILD)+defined(IS_VOLVO_XC40_2018_BUILD)+defined(IS_RANGE_ROVER_VELAR_2018_BUILD)+defined(IS_NISSAN_QASHQAI_2018_BUILD)+defined(IS_VW_TRANSPORTER_2018_BUILD)+\
       defined(IS_HYUNDAI_CRETA_2019_BUILD)+defined(IS_BMW_X1_2019_BUILD)+defined(IS_FORD_MUSTANG_1965_BUILD)+defined(IS_FORD_MUSTANG_1969_BUILD)+defined(IS_NISSAN_LEAF_2019_BUILD)+\
       defined(IS_PORSCHE_PANAMERA_2019_BUILD)+defined(IS_HYUNDAI_SONATA_SD_2020_BUILD)+defined(IS_RENAULT_LOGAN_2013_BUILD)+defined(IS_RENAULT_DUSTER_2021_BUILD)+\
       defined(IS_JEEP_WRANGLER_2018_BUILD)+defined(IS_SKODA_RAPID_2013_BUILD)+defined(IS_LADA_LARGUS_2020_BUILD)+\
       defined(IS_AUDI_A6_2018_BUILD)+defined(IS_RENAULT_ARKANA_2018_BUILD) )!=1)
#error define IS_RIO_2017_BUILD or IS_KAPTUR_2016_BUILD or IS_GENESIS_2017_BUILD or IS_AUDI_A3_2018_BUILD or IS_AUDI_Q3_2018_BUILD or IS_PORSCHE_911_2018_BUILD or IS_PORSCHE_MACAN_2018_BUILD \
or IS_SKODA_OCTAVIA_2018_BUILD orIS_SKODA_RAPID_2018_BUILD or IS_VW_POLO_2018_BUILD or IS_VW_CADDY_2018_BUILD or IS_BMW_520I_2018_BUILD or IS_MB_E200_2018_BUILD or IS_TOYOTA_RAV4_2019_BUILD or IS_FORD_TRANSIT_2017_BUILD \
or IS_CITROEN_JUMPY_2018_BUILD or IS_RENAULT_DOKKER_2018_BUILD or IS_LADA_LARGUS_2017_BUILD \
or IS_HYUNDAI_SOLARIS_2017_TAXI_BUILD or IS_SKODA_OCTAVIA_2018_TAXI_BUILD or IS_VW_POLO_2018_TAXI_BUILD or IS_RENAULT_LOGAN_2018_TAXI_BUILD \
or IS_VOLVO_XC60_2018_BUILD or IS_VOLVO_XC40_2018_BUILD or IS_RANGE_ROVER_VELAR_2018_BUILD or IS_NISSAN_QASHQAI_2018_BUILD or IS_VW_TRANSPORTER_2018_BUILD \
or IS_HYUNDAI_CRETA_2019_BUILD or IS_BMW_X1_2019_BUILD or IS_FORD_MUSTANG_1965_BUILD or IS_FORD_MUSTANG_1969_BUILD or IS_NISSAN_LEAF_2019_BUILD \
or IS_PORSCHE_PANAMERA_2019_BUILD or IS_HYUNDAI_SONATA_SD_2020_BUILD or IS_RENAULT_LOGAN_2013_BUILD or IS_RENAULT_DUSTER_2021_BUILD \
or IS_JEEP_WRANGLER_2018_BUILD or IS_SKODA_RAPID_2013_BUILD or IS_LADA_LARGUS_2020_BUILD\
or IS_AUDI_A6_2018_BUILD or IS_RENAULT_ARKANA_2018_BUILD
#endif //
#endif //!defined(BOOTLOADER)

//// Тип устройства/////////////////////////////////////////////////////////////
#if defined(IS_HW_VERSION_1)
#define DEVICE_TYPE                      DEVICE_TYPE_VEGA_MT_32K_LTE // Тип устройства (VEGA MT-32K LTE)
#define DEV_TYPE_STRING                  "VEGA MT-32K LTE"
#define HW_VERSION_STRING                ""
#elif defined(IS_HW_VERSION_2)
#define DEVICE_TYPE                      DEVICE_TYPE_VEGA_MT_32K_LTE_V2 // Тип устройства (VEGA MT-32K LTE V2)
#define DEV_TYPE_STRING                  "VEGA MT-32K LTE V2"
#define HW_VERSION_STRING                "V2 "
#elif defined(IS_HW_VERSION_3)
#define DEVICE_TYPE                      DEVICE_TYPE_VEGA_MT_32K_LTE_V3 // Тип устройства (VEGA MT-32K LTE V3)
#define DEV_TYPE_STRING                  "VEGA MT-32K LTE V3"
#define HW_VERSION_STRING                "V3 "
#else
#error unknown hw version
#endif

////Версия прошивки/////////////////////////////////////////////////////////////
#define APLICATION_VERSION_STRING        "VEGA MT-32K LTE " HW_VERSION_STRING "rc" RC_REVISION CUSTOM_CODE " " VCS_REVISION " " TOOLCHAIN_REVISION

#define CURRENT_SETTINGS_VERSION         3 // Текущая версия модели хранения настроек

#define TARGET_CPU_FREQ_HZ               (60000000)
#define TARGET_CPU_FREQ_IN_SLEEP_HZ      (16000000)

// IWDG/////////////////////////////////////////////////////////////////////////
#define IWDG_ENABLE                       1
#if IWDG_ENABLE > 0
#define IWDG_RELOAD_TIMEOUT_S             (12)
#define IWDG_RCC_HZ                       (40000)
#define IWDG_RELOAD_VAL                   ((IWDG_RELOAD_TIMEOUT_S*IWDG_RCC_HZ)/256)
#if IWDG_RELOAD_VAL > 0x0FFF
#error wrong IWDG_RELOAD_VAL
#endif
#endif

//#define FORCED_LTE_MODE_ONLY //режим с принудительныи LTE и отключенными смс
#define UBXLOX_NMEA_RECEIVER_PRESENT
#define GPS_MANAGER_MODEL_2_PRESENT
#define INTERNAL_ACC_MINIMAL_VOLTAGE  (3.35f)
#define IGNITION_PRESENT
#define GSENSOR_PRESENT
#define ALARM_BUTTON_PRESENT
//#define AUTORIZATION_PRESENT
#define MOTOHOURS_PRESENT
//#define CAMERA_PRESENT
//#define DUTS_PRESENT
#define INTERNAL_AKB_PRESENT
#define INTERNAL_AKB_ON_OFF_CONTROL_PRESENT
//#define INTERNAL_AKB_CHARGE_LEVEL_PRESENT
//#define EXT_ACC_DISCHARGE_PRESENT
//#define ONEWIRE_PRESENT
#define CANPRO_PRESENT
#define MFI_PRESENT
//#define AIN_PRESENT
//#define DIN_PRESENT
#define DIGITAL_OUTPUTS_PRESENT
#define TAMPERS_PRESENT
//#define VOICE_CALL_PRESENT
//#define INERTIAL_NAVIGATION_PRESENT
//#define FRIDGE_PRESENT
//#define ATOM_PRESENT
//#define LORA_SENSORS_PRESENT
//#define NRF_BEACONS_SCANNER_PRESENT
//#define TENZO_M_WEIGHER_PRESENT
#define PROD_TESTING_PRESENT
//#define EXT_GSENSOR_PRESENT
#define VEGA_CAN_PRESENT
#define VEGA_HARD_PASS_PRESENT
#define TRACK_POINT_GEN_FOR_VEGA_PROTOCOL_PRESENT
#define YANDEX_EXTENDED_SENSORS_PRESENT
#define INTERNAL_NRF_PRESENT
#define ITF_TRANSPORT_PRESENT
#define YANDEX_GUARD_MODE_PRESENT
//#define YANDEX_ANTITHEFT_PRESENT
#define YANDEX_ANTITHEFT2_PRESENT
#define EXTERNAL_BLE_BOARD_PRESENT
#define CAN_VEGA_FWD_PRESENT
#define YANDEX_OBD_PRESENT
#define CHANGE_SIM_BY_NO_VALID_VEGA_PACKET_PRESENT
#define FASTDATA_PRESENT
#define YANDEX_AUTO_HOOD_UNLOCK_PRESENT
#define MODEM_PSAVE_PRESENT
//#define GNSS_PSAVE_PRESENT //аналогичный режим захардкожен

#if (DEVICE_TYPE != DEVICE_TYPE_VEGA_MT_32K_LTE_V3)
#define BACKUP_SETTINGS_TO_MODEM_MEMORY_PRESENT
#define UBLOX_GNSS_EXTERNAL_RTC_QUARTZ_PRESENT
#endif //(DEVICE_TYPE != DEVICE_TYPE_VEGA_MT_32K_LTE_V3)

#if defined(EXTERNAL_BLE_BOARD_PRESENT)
#define VEGA_ESECURE_PRESENT
#endif //defined(EXTERNAL_BLE_BOARD_PRESENT)

#if defined(IS_RENAULT_LOGAN_2013_BUILD)
#define SAVER2021_PRESENT
#define RS_UART_PRESENT
#endif //defined(IS_RENAULT_LOGAN_2013_BUILD)

#if defined(IS_LADA_LARGUS_2020_BUILD)
#define SAVER2021_PRESENT
#define RS_UART_PRESENT
#endif //defined(IS_LADA_LARGUS_2020_BUILD)

#if (defined(IS_FORD_MUSTANG_1965_BUILD) || defined(IS_FORD_MUSTANG_1969_BUILD))
#define JQ6500_AUDUO_PRESENT
#endif //(defined(IS_FORD_MUSTANG_1965_BUILD) || defined(IS_FORD_MUSTANG_1969_BUILD))

#if defined(IS_TAXI)
#undef YANDEX_GUARD_MODE_PRESENT
#undef YANDEX_ANTITHEFT_PRESENT
#endif //defined(IS_TAXI)

//#define RS232_PRESENT
#if (DEVICE_TYPE==DEVICE_TYPE_VEGA_MT_32K_LTE)
#define RS485_PRESENT
#define DUTS_PRESENT
#endif //(DEVICE_TYPE==DEVICE_TYPE_VEGA_MT_32K_LTE)
#define BR_PRESENT //оставляем, чтобы в логе небыло ошибок настроек

#if defined(RS232_PRESENT)

#endif //RS232_PRESENT

#if defined(RS485_PRESENT)

#endif //RS485_PRESENT

#if defined(FRIDGE_PRESENT)
#define MAX_FRIDGE_AIN         6
#define MAX_FRIDGE_DIN         4
#define MAX_FRIDGE_MAINTENANCE 5
#define MAX_FRIDGE_COMPARTMENT 3
#define MAX_FRIDGE_ALARM_CODES 16
#endif //FRIDGE_PRESENT

#if defined(LORA_SENSORS_PRESENT)
#define MAX_LORA_SENSORS_COUNT 10
#endif //LORA_SENSORS_PRESENT

#if defined(NRF_BEACONS_SCANNER_PRESENT)
#define MAX_NRF_BEACONS_COUNT 50           //количество маяков видимых за раз сканнером
#define MAX_NRF_AUTORIZED_BEACONS_COUNT 160 //должно быть кратно 32м
#endif //NRF_BEACONS_SCANNER_PRESENT

#if defined(INTERNAL_NRF_PRESENT)
#define MAX_INTERNAL_NRF_MARKS_COUNT    10
#endif //INTERNAL_NRF_PRESENT

#if defined(EXTERNAL_BLE_BOARD_PRESENT)
#define MAX_EXTERNAL_BOARD_BLE_BEACONS_INFO_COUNT    10
#endif //defined(EXTERNAL_BLE_BOARD_PRESENT)

//если есть блок расширения портов
#if defined(BR_PRESENT)
#define MAX_EXT_MF_INPUTS       15                  // Количество расширенных мультфункциональных входов
#define MAX_EXT_ANALOG_INPUTS   MAX_EXT_MF_INPUTS   // Количество расширенных аналоговых входов
#define MAX_EXT_DIGITAL_INPUTS  MAX_EXT_MF_INPUTS   // Количество расширенных цифровых входов
#define MAX_EXT_PULSE_INPUTS    MAX_EXT_MF_INPUTS   // Количество расширенных импульсных входов
#define MAX_EXT_FREQ_INPUTS     MAX_EXT_MF_INPUTS   // Количество расширенных частотных входов
#define MAX_EXT_DIGITAL_OUTPUTS 15                  // Количество расширенных цифровых выходов
#endif //BR_PRESENT

#define MAX_MF_INPUTS       5                   // Максимальное количество мультфункциональных входов
#define MAX_ANALOG_INPUTS   MAX_MF_INPUTS       // Максимальное количество аналоговых входов
#define MAX_ANALOG_OUTPUTS  0                   // Максимальное количество аналоговых выходов
#define MAX_DIGITAL_INPUTS  MAX_MF_INPUTS       // Максимальное количество цифровых входов
#define MAX_DIGITAL_OUTPUTS 12                  // Максимальное количество цифровых выходов
#define MAX_PULSE_INPUTS    MAX_MF_INPUTS       // Максимальное количество импульсных входов
#define MAX_FREQ_INPUTS     MAX_MF_INPUTS       // Максимальное количество частотных входов
#define MAX_FREQ_OUTPUTS    1                   // Максимальное количество частотных выходов
#define MAX_DUTS            4                   // Максимальное количество ДУТов для устройства
#define MAX_DALLAS_TEMP_SENSORS   0             // Максимальное количество температурных датчиков на интерфейсе 1-wire
#define MAX_TAMPERS         2                   // Количество тамперов в устройстве
#define MAX_GEOZONES        50                  // Максимальное количество геозон на устройстве
#define MAX_SERVERS_COUNT   4                   // Количество серверов с которыми может работать устройство
#define MAX_SIM_COUNT       2                   // Количество SIM-карт в устройстве
#define PROTOCOL_VERSION    1                   // Версия протокола Вега
#define MAX_AUTORIZED_PHONES 10                 // Максимальное количество авторизованых телефонов
#define MAX_AUTORIZED_KEYS  0                   // Максимальное количество авторизованных ключей
#define MAX_SCENARIES       25                  // Максимальное количество сценариев на устройстве
#define MODEM_VER_SIZE      36                  // Длина массива под информацию о версии модема
#define GSM_MAX_SERVER_ADDR_LEN  32             // Максимальный размер массива под адрес, формат addr:port\0
#define GPS_MAX_SAT_VISIBLE 20                  // Максимальное количество видимых спутников для GLONASS и GPS в отдельности
#define GPS_MAX_SAT_USED    24                  // Максимальное количество используемых спутников
#define GPS_RECV_VER_SIZE   50                  // Размер буфера под хранение версии ПО приемника
#define MAX_SENSOR_COUNT    (450)               // Количество датчиков в системе
#define MAX_CAMERAS         0                   // Количество камер в системе

#if (DEVICE_TYPE == DEVICE_TYPE_VEGA_MT_32K_LTE)
#define MAX_CAN_INTERFACES  2                   // Количество CAN итерфейсов
#elif (DEVICE_TYPE == DEVICE_TYPE_VEGA_MT_32K_LTE_V2 || DEVICE_TYPE == DEVICE_TYPE_VEGA_MT_32K_LTE_V3)
#define MAX_CAN_INTERFACES  3                   // Количество CAN итерфейсов
#endif //

#endif /* SYSTEM_SETTINGS_H */
