/**
******************************************************************************
* File Name          : usb_pins.h
* Description        : USB PINs
*                      
*                      
******************************************************************************
*/

/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __USB_CDC_CONFIG_H
#define __USB_CDC_CONFIG_H
#ifdef __cplusplus
 extern "C" {
#endif

/* Includes ------------------------------------------------------------------*/
//#include "SPL_platform_config.h"
   
/* Defines -------------------------------------------------------------------*/  

/* Uncomment the following define to use an external pull up instead of the 
    integrated STM32L15xx internal pull up. In this case make sure to set up
    correctly the external required hardware and the GPIO defines below.
*/

//-   USB_Detect (   ,   USB_CDC_Deinit())   
#define USB_DETECT_RCC                                  RCC_AHB1Periph_GPIOA     
#define USB_DETECT_PORT                                 GPIOA 
#define USB_DETECT_PIN                                  GPIO_Pin_9
#define USB_DETECT_PIN_STATE()                          GPIO_ReadInputDataBit(USB_DETECT_PORT, USB_DETECT_PIN)

#define USB_DETECT_INIT(GPIO_STRUCT)                    \
{                                                       \
  GPIO_STRUCT.GPIO_Speed = GPIO_Speed_2MHz;             \
  GPIO_STRUCT.GPIO_Mode = GPIO_Mode_IN;                 \
  GPIO_STRUCT.GPIO_PuPd = GPIO_PuPd_NOPULL;             \
  GPIO_STRUCT.GPIO_Pin = USB_DETECT_PIN;                \
  GPIO_Init(USB_DETECT_PORT, &GPIO_STRUCT);             \
}      

//- USB NVIC Priority
#define USB_LP_CAN1_RX0_IRQn_PRIO                       13  
#define USBWAKEUP_IRQn_PRIO                             12


//- USB ID
#define  USE_FIXED_USB_UNIQUE_ID                        1

#if USE_FIXED_USB_UNIQUE_ID > 0 
#define USB_FIXED_48BIT_UID                             0x0000d143fe44f166Ull
#endif

   
#ifdef __cplusplus
 }
#endif
#endif // __USB_CDC_CONFIG_H
