/**
******************************************************************************
* File Name          : 
* Description        : 
*                      
******************************************************************************
*/

/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __BLE_NFC_EXT_BOARD_MASTER_H
#define __BLE_NFC_EXT_BOARD_MASTER_H

#ifdef __cplusplus
extern "C" {
#endif

#include <stdint.h>
#include <stdio.h>
#include <stdbool.h>

#include "ble_nfc_ext_board_lib/ble_nfc_ext_board_protocol.h"

typedef int16_t (*interface_txrx_t)(const void* const tx, const uint16_t tx_size, void* const rx, const uint16_t rx_size, const uint32_t timeout);
typedef void (*rand_func_t)(void* dst, uint16_t size);

int16_t ext_board_init(uint8_t* const heap, const uint16_t heap_size, 
                       const interface_txrx_t pinterface_txrx, const rand_func_t prand_func, 
                       const uint8_t* crypt_key);
int16_t ext_board_get_pointer_for_cmd_firmware_file_payload(uint8_t** const payload, uint16_t* max_payload_size);
int16_t ext_board_get_pointer_for_cmd_ble_send_data_payload(uint8_t** const payload, uint16_t* max_payload_size);
uint16_t ext_board_get_ble_max_receive_data_len(void);
int16_t ext_board_txrx(const ext_board_mess_type_t req_mess_type, const void* const req_arg, const void** ans_arg);
const char* ext_board_get_verbose_mess_type(const ext_board_mess_type_t mess_type);
int16_t ext_board_decrypt_check_packet(void* const packet, const uint16_t data_size, const char** verbose);
int16_t __cmd_get_fw_vers_verbose(const char** device_marker, const char** bootloader_version, const char** application_version);

static inline int16_t cmd_get_fw_vers(const ext_board_fw_vers_t** ans)
{
  return ext_board_txrx(CMD_GET_FW_VERS, NULL, (const void**)ans);
}

static inline int16_t cmd_get_fw_vers_verbose(const char** ans)
{
  return ext_board_txrx(CMD_GET_FW_VERS_VERBOSE, NULL, (const void**)ans);
}

static inline int16_t cmd_get_dfu_result(const ext_board_dfu_result_t** ans)
{
  return ext_board_txrx(CMD_DFU_RESULT, NULL, (const void**)ans);
}

static inline int16_t cmd_reboot(const ext_board_cmd_result_t** ans)
{
  return ext_board_txrx(CMD_REBOOT, NULL, (const void**)ans);
}

static inline int16_t cmd_set_nfc_scan_period(const ext_board_nfc_scan_period_t req, const ext_board_cmd_result_t** ans)
{
  return ext_board_txrx(CMD_SET_NFC_SCAN_PERIOD, &req, (const void**)ans);
}

static inline int16_t cmd_firmware_file(const ext_board_mess_firmware_upd_cmd_aux_t req, const ext_board_file_load_result_t** ans)
{
  //req->data==NULL,     (  ext_board_get_pointer_for_cmd_firmware_file_payload())
  return ext_board_txrx(CMD_FIRMWARE_FILE, &req, (const void**)ans);
}

static inline int16_t cmd_ble_init(const ext_board_ble_init_t req, const ext_board_cmd_result_t** ans)
{
  return ext_board_txrx(CMD_BLE_INIT, &req, (const void**)ans);
}

static inline int16_t get_ble_status(const ext_board_ble_init_t** ans)
{
  return ext_board_txrx(CMD_BLE_STATUS, NULL, (const void**)ans);
}

static inline int16_t cmd_ble_connection_count(const ext_board_ble_connection_count_t** ans)
{
  return ext_board_txrx(CMD_BLE_CONNECTION_COUNT, NULL, (const void**)ans);
}

static inline int16_t cmd_ble_connection_status(const ext_board_ble_connection_id_t req, const ext_board_ble_info_t** ans)
{
  return ext_board_txrx(CMD_BLE_CONNECTION_STATUS, &req, (const void**)ans);
}

static inline int16_t cmd_ble_connect(const ext_board_ble_connection_id_t req, const ext_board_ble_ans_conn_cmd_t** ans)
{
  return ext_board_txrx(CMD_BLE_CONNECT, &req, (const void**)ans);
}

static inline int16_t cmd_ble_disconnect(const ext_board_ble_connection_id_t req, const ext_board_ble_ans_conn_cmd_t** ans)
{
  return ext_board_txrx(CMD_BLE_DISCONNECT, &req, (const void**)ans);
}

static inline int16_t cmd_ble_send_data(const ext_board_ble_send_data_aux_t req, const ext_board_ble_ans_send_data_t** ans)
{
  //req->data==NULL,     (  ext_board_get_pointer_for_cmd_ble_send_data_payload())
  return ext_board_txrx(CMD_BLE_SEND_DATA, &req, (const void**)ans);
}

static inline int16_t cmd_ble_receive_data(const ext_board_ble_receive_data_t req, const ext_board_ble_ans_receive_data_aux_t** ans)
{
  return ext_board_txrx(CMD_BLE_RECEIVE_DATA, &req, (const void**)ans);
}

static inline int16_t cmd_ble_beacon_visible(const ext_board_ans_ble_beacon_visible_aux_t** ans)
{
  return ext_board_txrx(CMD_BLE_BEACON_VISIBLE, NULL, (const void**)ans);
}

static inline int16_t cmd_nfc_visible(const ext_board_ans_ble_beacon_visible_aux_t** ans)
{
  return ext_board_txrx(CMD_NFC_VISIBLE, NULL, (const void**)ans);
}

static inline int16_t cmd_set_ble_name(const char* req, const ext_board_cmd_result_t** ans)
{
  return ext_board_txrx(CMD_SET_BLE_NAME, req, (const void**)ans);
}

static inline int16_t cmd_get_ble_name(const ext_board_ble_name_t** ans)
{
  return ext_board_txrx(CMD_GET_BLE_NAME, NULL, (const void**)ans);
}

static inline int16_t cmd_set_ble_pass_key(const char* req, const ext_board_cmd_result_t** ans)
{
  return ext_board_txrx(CMD_SET_PASS_KEY, req, (const void**)ans);
}

static inline int16_t cmd_get_ble_passkey(const ext_board_ble_passkey_t** ans)
{
  return ext_board_txrx(CMD_GET_PASS_KEY, NULL, (const void**)ans);
}

static inline int16_t cmd_get_ble_board_mac(const ext_board_ble_mac_t** ans)
{
  return ext_board_txrx(CMD_GET_BLE_BOARD_MAC, NULL, (const void**)ans);
}

static inline int16_t cmd_approtect_enable(const ext_board_cmd_result_t** ans)
{
  return ext_board_txrx(CMD_APPROTECT_ENABLE, NULL, (const void**)ans);
}

#ifdef __cplusplus
}
#endif

#endif // __BLE_NFC_EXT_BOARD_MASTER_H
