/**
******************************************************************************
* File Name          : 
* Description        : 
*                      
******************************************************************************
*/

/* Define to prevent recursive inclusion -------------------------------------*/
#include "Uart.h"
#include "platform.h"
#include "ble_nfc_ext_board_lib/ble_nfc_ext_board_protocol.h"
#include "crc_lib/crc_lib.h"

static struct
{
  uint8_t  tx_buff[4];//160;
  uint8_t  rx_buff[512];//BLE_NFC_EXT_BOARD_PACKET_LEN(sizeof(si_mess_settings_file_header_t)+SETTINGS_FILE_MAX_SIZE)];
  uint16_t rx_pos;
}ctx;

static void mem_move_to_head(uint8_t* dst, uint8_t* src, uint16_t len) 
{
  if(!len) return;
  
  while (len--)
  {
    *dst = *src;
    dst++; src++;
  }
}

void uart_send_buf(uint8_t* buf, uint8_t length)
{
  UartWrite(buf, length);
}

ext_board_mess_crc_t get_ext_board_crc(const uint8_t* data, const uint16_t len)
{
  return (ext_board_mess_crc_t)crc16_fast(data, len);
}

/*
 buff,  buff_len,  .
return:
ret < 0  
     ,     , 
   crc     
:
  
*/
int16_t ble_nfc_ext_board_rx_processing(uint8_t* parse_buff, uint16_t parse_len, uint16_t rx_mem_size)
{
  int16_t processed_len=0;
  int16_t total_processed_len=0;
  
  for(;;)
  {
    parse_buff+=processed_len;
    parse_len-=processed_len;
    processed_len=ble_nfc_ext_board_parse_single_packet(parse_buff, parse_len, rx_mem_size);
    
    if(processed_len<0) return processed_len;
    else if(processed_len==0) return total_processed_len;
    else total_processed_len+=processed_len;
  }
}

__weak void ble_nfc_ext_board_parser(uint8_t* parse_buff)
{
}

/*
 parse_buff,  parse_len.
return:
ret < 0  
     ,     , 
   crc,    
:
  
*/
int16_t ble_nfc_ext_board_parse_single_packet(uint8_t* parse_buff, uint16_t parse_len, uint16_t rx_mem_size)
{
  
  //platformLedToogle(LED_A_GPIO_Port, LED_A_Pin);/////////
  
  if(!parse_len) return 0;
  
  ext_board_mess_header_t* req_header=(ext_board_mess_header_t*)&parse_buff[0];
  //ext_board_mess_header_t* ans_header=(ext_board_mess_header_t*)&ctx.tx_buff[0];
  
  if(parse_len>=sizeof(uint8_t))
  {
    uint16_t drop_cnt=0;
    for(uint16_t i=0; i<parse_len; i++)
    {
      if(parse_buff[i]!=BLE_BOARD_SYNC_BYTE) drop_cnt++;
      else                                   break;
    }
    
    if(drop_cnt)
    {
      //ble_nfc_ext_board_send_dbg_mess("%s: sync err, drop %hu byte(s)\n", pheader, drop_cnt);
      return drop_cnt;
    }
  }
  NRF_LOG_DEBUG("%i %x\r\n", parse_len, parse_buff[parse_len-1]);
  if(parse_len>=sizeof(ext_board_mess_header_t))
  {
    //  
    if(rx_mem_size<BLE_NFC_EXT_BOARD_PACKET_LEN(req_header->len))
    {
      //platformLedToogle(LED_A_GPIO_Port, LED_A_Pin);/////////
      //ble_nfc_ext_board_send_dbg_mess("%s: rx_mem_size is too small for packet reception\n", pheader);     
      return -1;
    }
    
    if(parse_len>=BLE_NFC_EXT_BOARD_PACKET_LEN(req_header->len))
    {
      //platformLedToogle(LED_A_GPIO_Port, LED_A_Pin);
      
      //  
      ext_board_mess_crc_t* crc=(ext_board_mess_crc_t*)&parse_buff[BLE_NFC_EXT_BOARD_PACKET_CRC_OFFSET(req_header->len)];
      
      if(crc[0]==get_ext_board_crc(&parse_buff[0], BLE_NFC_EXT_BOARD_PACKET_CRC_CALC_LEN(req_header->len)))
      {
        //  
        NRF_LOG_DEBUG("ParseLen %d ReqHeaderLen %d CRC OK\r\n", parse_len, req_header->len);
        //ble_nfc_ext_board_send_dbg_mess("%s: got packet, type: %hhu, payload len: %hhu\n", pheader, req_header->type, req_header->len);
        
        ble_nfc_ext_board_parser(parse_buff);
        
        //platformLedToogle(LED_A_GPIO_Port, LED_A_Pin);/////////
      }
      else
      {
        //crc  ,  
        //ble_nfc_ext_board_send_dbg_mess("%s: recv packet with wrong crc, drop it...\n", pheader);
      }
    }
    else
    {
      //  
      return 0;
    }
  }
  else
  {
    //  
    return 0;
  }
  
  //   
  return BLE_NFC_EXT_BOARD_PACKET_LEN(req_header->len);
}

void ble_nfc_ext_board_rx_reset_sate(void)
{
  ctx.rx_pos=0;
  reset_ble_nfc_ext_board_rx_length();
}

void ble_nfc_ext_board_rx_handle(void)
{
  int16_t recv_len;
  int i=0;
  
  recv_len=get_ble_nfc_ext_board_rx_length();
  
  for(i=0; i<get_ble_nfc_ext_board_rx_length(); i++) 
  {
    //ctx.rx_buff[i]=nrf_rx_buf[i];
    ctx.rx_buff[i+ctx.rx_pos]=*(get_ble_nfc_ext_board_rx_buff()+i);
  }
//  reset_ble_nfc_ext_board_rx_length();
  
  if(recv_len<0)
  {
    //error
    ctx.rx_pos=0;
  }
  else if(recv_len==0)
  {
    //none
  }
  else
  {
    //if(recv_len==6) platformLedToogle(LED_A_GPIO_Port, LED_A_Pin);/////////
    
    //got new data
    uint16_t filled_len;
    int16_t processed_len;
    
    filled_len=recv_len+ctx.rx_pos;
    
    processed_len=ble_nfc_ext_board_rx_processing(ctx.rx_buff, filled_len, sizeof(ctx.rx_buff));
    
    if(processed_len<0)
    {
      ctx.rx_pos=0;
      return;
    }
    else 
    {
      filled_len-=processed_len;
    }
    
    if(filled_len>=sizeof(ctx.rx_buff))
    {        
      //rx is full
      ctx.rx_pos=0;
    }
    else if(processed_len>0 && filled_len>0)
    {           
      mem_move_to_head(ctx.rx_buff, ctx.rx_buff+processed_len, filled_len);
      ctx.rx_pos=filled_len;
    }
    else if(filled_len>0)
    {
      ctx.rx_pos=filled_len;
    }
    else
    {
      ctx.rx_pos=0;
    }
  }
}

