/**
******************************************************************************
* File Name          : 
* Description        : 
*                      
******************************************************************************
*/

/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __BLE_NFC_EXT_BOARD_PROTOCOL_H
#define __BLE_NFC_EXT_BOARD_PROTOCOL_H

#ifdef __cplusplus
extern "C" {
#endif

#include <stdint.h>

#if (!defined(UINT16_MAX))
#define UINT16_MAX      __UINT16_T_MAX__
#endif //(!defined(UINT16_MAX))

#define BLE_BOARD_SYNC_BYTE       (0xAA)

#define TOKEN_SIZE                (10)

#pragma pack(1)

#ifdef __ICCARM__
typedef enum
#else 
typedef enum : uint8_t
#endif
{
  CMD_GET_FW_VERS = 0,                  //     
  CMD_ANS_GET_FW_VERS = 1,              //     
  
  CMD_GET_FW_VERS_VERBOSE = 2,          //     
  CMD_ANS_GET_FW_VERS_VERBOSE = 3,      //     
  
  CMD_REBOOT = 4,                       //  
  CMD_ANS_REBOOT = 5,                   //   
  
  CMD_SET_NFC_SCAN_PERIOD = 6,          //   NFC
  CMD_ANS_SET_NFC_SCAN_PERIOD = 7,      //      NFC
  
  CMD_FIRMWARE_FILE = 9,                //  
  CMD_ANS_FIRMWARE_FILE = 10,           //    
    
  CMD_BLE_INIT = 12,                    /// BlueTooth
  CMD_ANS_BLE_INIT = 13,                //  / BlueTooth
  
  CMD_BLE_STATUS = 14,                  // BlueTooth
  CMD_ANS_BLE_STATUS = 15,              //   BlueTooth
  
  CMD_BLE_CONNECTION_COUNT = 16,        //    bluetoth 
  CMD_ANS_BLE_CONNECTION_COUNT = 17,    //      bluetoth 
      
  CMD_BLE_CONNECTION_STATUS = 18,       //  
  CMD_ANS_BLE_CONNECTION_STATUS = 19,   //    
  
  CMD_BLE_CONNECT = 20,                 // 
  CMD_ANS_BLE_CONNECT = 21,             //   
  
  CMD_BLE_SEND_DATA = 22,               // 
  CMD_ANS_BLE_SEND_DATA = 23,           //   
 
  CMD_BLE_RECEIVE_DATA = 24,            // 
  CMD_ANS_BLE_RECEIVE_DATA = 25,        //   
  
  CMD_BLE_DISCONNECT = 26,              // 
  CMD_ANS_BLE_DISCONNECT = 27,          //   
  
  CMD_BLE_BEACON_VISIBLE = 28,          //  bluetoth beacons
  CMD_ANS_BLE_BEACON_VISIBLE = 29,      //    bluetoth beacons
  
  CMD_NFC_VISIBLE = 30,                 //  
  CMD_ANS_NFC_VISIBLE = 31,             //    
  
  CMD_DFU_RESULT = 32,                  //  
  CMD_ANS_DFU_RESULT = 33,              //    
  
  CMD_SET_BLE_NAME = 34,                // bluetoth  
  CMD_ANS_SET_BLE_NAME = 35,            //   bluetoth  
  
  CMD_GET_BLE_NAME = 36,                // bluetoth  
  CMD_ANS_GET_BLE_NAME = 37,            //   bluetoth  
  
  CMD_SET_PASS_KEY = 38,                //   bluetoth 
  CMD_ANS_SET_PASS_KEY = 39,            //     bluetoth 
  
  CMD_GET_PASS_KEY = 40,                //   bluetoth 
  CMD_ANS_GET_PASS_KEY = 41,            //     bluetoth 
  
  CMD_GET_BLE_BOARD_MAC = 42,           // bluetoth mac  
  CMD_ANS_GET_BLE_BOARD_MAC = 43,       //   bluetoth mac  
  
  CMD_APPROTECT_ENABLE = 44,            //     
  CMD_ANS_APPROTECT_ENABLE = 45,        //       
  
  CMD_STOKEN_REQUEST = 46,              //   slave'.
  CMD_ANS_STOKEN_REQUEST = 47,          //  . Slave     CMD_ANS_STOKEN_REQUEST   ,    stoken  .
  
  CMD_SET_TIMEOUT = 48,					// APP_ADV_FAST_TIMEOUT  APP_CFG_NON_CONN_ADV_TIMEOUT
  CMD_ANS_SET_TIMEOUT = 49,				//   APP_ADV_FAST_TIMEOUT  APP_CFG_NON_CONN_ADV_TIMEOUT
  
  CMD_GET_TIMEOUT = 50,					// APP_ADV_FAST_TIMEOUT  APP_CFG_NON_CONN_ADV_TIMEOUT
  CMD_ANS_GET_TIMEOUT = 51,				//  APP_ADV_FAST_TIMEOUT  APP_CFG_NON_CONN_ADV_TIMEOUT
}ext_board_mess_type_t;

// 
typedef struct
{
  uint8_t               sync_byte;   //BLE_BOARD_SYNC_BYTE
  ext_board_mess_type_t type;        // 
  uint32_t              uid;         //UID
  uint16_t              len;         //  
}ext_board_mess_header_legacy_t;

// 
typedef struct
{
  uint8_t               sync_byte;          //BLE_BOARD_SYNC_BYTE
  uint8_t               nonce[12];          //nonce,  
  uint32_t              counter;            // 
  uint16_t              len;                //  
  uint8_t               mtoken[TOKEN_SIZE]; //  master', .
  uint8_t               stoken[TOKEN_SIZE]; //  slave', .  stoken  , slave  CMD_ANS_STOKEN_REQUEST   .
  ext_board_mess_type_t type;               // , 
}ext_board_mess_header_t;

//type=CMD_ANS_FIRMWARE_FILE
#ifdef __ICCARM__
typedef enum
#else 
typedef enum : uint8_t
#endif
{
  FILE_LOAD_IN_PROGRESS = 0,
  FILE_LOAD_DONE = 1, 
  FILE_LOAD_ERR_FLASH_CORRUPT = 2,
}ext_board_file_load_result_t;

//type=CMD_ANS_GET_FW_VERS
typedef struct
{
  uint8_t ext_board_type;
  uint8_t application_version_major;
  uint8_t application_version_minor;
  uint8_t bootoader_version_major;
  uint8_t bootoader_version_minor;
}ext_board_fw_vers_t;

//type=CMD_ANS_GET_FW_VERS_VERBOSE
/*
typedef struct
{
  char device_marker[48];
  char bootloader_version[48];
  char application_version[48];
}ext_board_fw_vers_verbose_t;
*/

//type=CMD_SET_NFC_SCAN_PERIOD
typedef struct
{
  uint16_t scan_step; // ,  100 , 0 -  
}ext_board_nfc_scan_period_t;

//type=CMD_ANS_REBOOT
//type=CMD_ANS_SET_NFC_SCAN_PERIOD
#ifdef __ICCARM__
typedef enum
#else 
typedef enum : uint8_t
#endif
{
 CMD_SUCCESS = 0,
 CMD_INPROGRESS = 1,
 CMD_ERROR = 255,
}ext_board_cmd_result_t;

//type=CMD_BLE_INIT
//type=CMD_ANS_BLE_STATUS
#ifdef __ICCARM__
typedef enum
#else 
typedef enum : uint8_t
#endif
{
  BLE_DEINIT = 0,
  BLE_INIT = 1,
}ext_board_ble_init_t;

//type=FIRMWARE_UPD_STATE_MESS_T
/*
typedef struct
{
  uint32_t recv_len;
  uint32_t tot_len;
  ext_board_firmware_file_result_t  state;
}ext_board_mess_firmware_upd_state_t;
*/

//type=CMD_FIRMWARE_FILE
typedef struct
{
  uint32_t offset;
  uint16_t length;
  //uint8_t data[length];
}ext_board_mess_firmware_upd_cmd_t;

typedef struct
{
  uint32_t offset;
  uint16_t length;
  const uint8_t* data;
}ext_board_mess_firmware_upd_cmd_aux_t;

//type=CMD_ANS_BLE_CONNECTION_COUNT
typedef struct
{
  uint8_t max_count;
  uint8_t count;
}ext_board_ble_connection_count_t;

//type=CMD_BLE_CONNECTION_STATUS
//type=CMD_BLE_CONNECT
//type=CMD_BLE_DISCONNECT
typedef struct
{
  uint8_t conn_id;
}ext_board_ble_connection_id_t;

//type=CMD_ANS_BLE_CONNECT
//type=CMD_ANS_BLE_DISCONNECT
typedef struct
{
  uint8_t conn_id;
  ext_board_cmd_result_t result;
}ext_board_ble_ans_conn_cmd_t;

//none
#ifdef __ICCARM__
typedef enum
#else 
typedef enum : uint8_t
#endif
{
 BLE_STATE_DISCONNECTED = 0x00,
 BLE_STATE_CONNECTING = 0x01,
 BLE_STATE_SHUTDOWN = 0x02,
 BLE_STATE_CONNECTED_FLAG = 0x10,
 BLE_STATE_CONNECTED_NO_ENC = 0x11,             //No protection, open link
 BLE_STATE_CONNECTED_ENC_NO_MITM = 0x12,        //Encryption, but no MITM protection
 BLE_STATE_CONNECTED_ENC_W_MITM = 0x13,         //Encryption and MITM protection
 BLE_STATE_CONNECTED_LESC_ENC_WITH_MITM = 0x14, //LESC encryption and MITM protection
 BLE_STATE_STATE_ERROR = 0xFF
}ext_board_ble_connection_status_t;

//type=CMD_ANS_GET_BOARD_BLE_MAC
typedef struct
{
  uint8_t addr[6];
}ext_board_ble_mac_t;

//type=CMD_ANS_BLE_CONNECTION_STATUS
typedef struct
{
 uint8_t conn_id;
 ext_board_ble_connection_status_t state;
 ext_board_ble_mac_t mac;
 int8_t rssi;
}ext_board_ble_info_t;

//type=CMD_BLE_SEND_DATA
typedef struct
{
 uint8_t conn_id;
 uint16_t length;
 //uint8_t data[length];
}ext_board_ble_send_data_t;

typedef struct
{
 uint8_t conn_id;
 uint16_t length;
 const uint8_t* data;
}ext_board_ble_send_data_aux_t;

//type=CMD_ANS_BLE_SEND_DATA
typedef struct
{
 uint8_t conn_id;
 ext_board_cmd_result_t result;
 uint16_t length;
}ext_board_ble_ans_send_data_t;

//type=CMD_BLE_RECEIVE_DATA
typedef struct
{
 uint8_t conn_id;
 uint16_t length;
}ext_board_ble_receive_data_t;

//type=CMD_ANS_BLE_RECEIVE_DATA
typedef struct
{
 uint8_t conn_id;
 ext_board_cmd_result_t result;
 uint16_t length;
 //uint8_t data[length];
}ext_board_ble_ans_receive_data_t;

typedef struct
{
 uint8_t conn_id;
 ext_board_cmd_result_t result;
 uint16_t length;
 const uint8_t data[UINT16_MAX];
}ext_board_ble_ans_receive_data_aux_t;

//none
typedef struct
{
 ext_board_ble_mac_t mac;
 int8_t rssi;
 uint8_t dlen;
 uint8_t data[31];
}ext_board_ble_beacon_info_t;

//type=CMD_ANS_BLE_BEACON_VISIBLE
typedef struct
{
 uint16_t count;
 //ext_board_ble_beacon_info_t info[count];
}ext_board_ans_ble_beacon_visible_t;

typedef struct
{
 uint16_t count;
 const ext_board_ble_beacon_info_t info[UINT16_MAX];
}ext_board_ans_ble_beacon_visible_aux_t;

//none
typedef struct
{
 uint8_t uid[8];
}ext_board_nfc_info_t;

//type=CMD_ANS_NFC_VISIBLE
typedef struct
{
 uint16_t count;
 //ext_board_nfc_info_t info[count];
}ext_board_nfc_visible_t;

typedef struct
{
 uint16_t count;
 const ext_board_nfc_info_t info[UINT16_MAX];
}ext_board_nfc_visible_aux_t;

//type=CMD_SET_TIMEOUT, 
//type=CMD_ANS_GET_TIMEOUT, 
typedef struct
{
	uint8_t timeout[2];
}ext_board_timout_t;


#ifdef __ICCARM__
typedef enum
#else 
typedef enum : uint8_t
#endif
{
  DFU_RESULT_NONE = 0,
  DFU_RESULT_GOTO_BOOTLOADER_FOR_FLASHING = 1, 
  DFU_RESULT_ERR_FLASH_CORRUPT= 2,
  DFU_RESULT_UPDATE_DONE=3,
  DFU_RESULT_CRC_ERROR=4,
  DFU_RESULT_WRONG_IMAGE=5,
  DFU_RESULT_INTERNAL_ERROR=6,
  DFU_RESULT_WRONG_VERSION=7,
  DFU_RESULT_DECRYPTION_ERROR=8,
  DFU_RESULT_TIMEOUT_ERROR=9,
}ext_board_dfu_result_t;

//type=CMD_SET_BLE_NAME
//type=CMD_ANS_GET_ADDRESS
typedef struct
{
 char name[32]; //varible with NULL termination
}ext_board_ble_name_t;

//type=CMD_SET_PASS_KEY
//type=CMD_ANS_GET_PASS_KEY
typedef struct
{
 char passkey[6];//digit 0..9 only, no NULL termination
}ext_board_ble_passkey_t;

typedef uint16_t ext_board_mess_crc_t;

#pragma pack()

ext_board_mess_crc_t get_ext_board_crc(const uint8_t* data, const uint16_t len);
int16_t ble_nfc_ext_board_parse_single_packet(uint8_t* parse_buff, uint16_t parse_len, uint16_t rx_mem_size);
int16_t ble_nfc_ext_board_rx_processing(uint8_t* parse_buff, uint16_t parse_len, uint16_t rx_mem_size);
void ble_nfc_ext_board_rx_handle(void);
void ble_nfc_ext_board_rx_reset_sate(void);

#define BLE_NFC_EXT_BOARD_PACKET_LEN(payload_len)           (sizeof(ext_board_mess_header_t)+payload_len+sizeof(ext_board_mess_crc_t))
#define BLE_NFC_EXT_BOARD_PACKET_CRC_OFFSET(payload_len)    (sizeof(ext_board_mess_header_t)+payload_len)
#define BLE_NFC_EXT_BOARD_PACKET_CRC_CALC_LEN(payload_len)  (BLE_NFC_EXT_BOARD_PACKET_CRC_OFFSET(payload_len))
#define BLE_NFC_EXT_BOARD_PACKET_PAYLOAD_OFFSET()           (sizeof(ext_board_mess_header_t))

#ifdef __cplusplus
}
#endif

#endif // __BLE_NFC_EXT_BOARD_PROTOCOL_H
