/**
******************************************************************************
* File Name          : ecu_simulation.c
* Description        : 
*                      
*                      
******************************************************************************
*/

#include "eobd_lib/ecu_simulation.h"
#include "system_config.h"

static uint8_t state[MAX_CAN_INTERFACES]={0};

//TCM negative responce
static const can_tx_frame_t vin_neg_resp=
{
  .id=0x7E9,
  .rtr=0,
  .id_type=STD_ID_TYPE,
  .dlen=0x04,
  .data={0x03, 0x7F, 0x09, 0x11},
};

//ECM responce: 3FADP4FJ2BM113913
static const can_tx_frame_t vin_resp[]=
{
  {
    .id=0x7E8,
    .rtr=0,
    .id_type=STD_ID_TYPE,
    .dlen=0x08,
    .data={0x10, 0x14, 0x49, 0x02, 0x01, 0x33, 0x46, 0x41},
  },
  {
    .id=0x7E8,
    .rtr=0,
    .id_type=STD_ID_TYPE,
    .dlen=0x08,
    .data={0x21, 0x44, 0x50, 0x34, 0x46, 0x4A, 0x32, 0x42},
  },
  {
    .id=0x7E8,
    .rtr=0,
    .id_type=STD_ID_TYPE,
    .dlen=0x08,
    .data={0x22, 0x4D, 0x31, 0x31, 0x33, 0x39, 0x31, 0x33},
  },
};

//Infiniti G35x dasboard responce 
const can_tx_frame_t dashboard_resp[]=
{
  {
    .id=0x77B,
    .rtr=0,
    .id_type=STD_ID_TYPE,
    .dlen=0x08,
    .data={0x10, 0x31, 0x61, 0x01, 0x00, 0x00, 0x00, 0x00},
  },
  {
    .id=0x77B,
    .rtr=0,
    .id_type=STD_ID_TYPE,
    .dlen=0x08,
    .data={0x21, 0x00, 0x00, 0x00, 0x02, 0xD5, 0x52, 0x14},
  },
  {
    .id=0x77B,
    .rtr=0,
    .id_type=STD_ID_TYPE,
    .dlen=0x08,
    .data={0x22, 0xFF, 0x49, 0x7E, 0x00, 0x00, 0x00, 0x00},//d[2]*0.8 - 
  },
  {
    .id=0x77B,
    .rtr=0,
    .id_type=STD_ID_TYPE,
    .dlen=0x08,
    .data={0x23, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
  },
  {
    .id=0x77B,
    .rtr=0,
    .id_type=STD_ID_TYPE,
    .dlen=0x08,
    .data={0x24, 0x00, 0x04, 0x00, 0x00, 0x00, 0x01, 0x00},
  },
  {
    .id=0x77B,
    .rtr=0,
    .id_type=STD_ID_TYPE,
    .dlen=0x08,
    .data={0x25, 0x88, 0x00, 0x00, 0x08, 0x52, 0x3B, 0x00},
  },
  {
    .id=0x77B,
    .rtr=0,
    .id_type=STD_ID_TYPE,
    .dlen=0x08,
    .data={0x26, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
  },
  {
    .id=0x77B,
    .rtr=0,
    .id_type=STD_ID_TYPE,
    .dlen=0x08,
    .data={0x27, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF},
  },
};

//TCM negative responce
static const can_tx_frame_t dtc_neg_resp=
{
  .id=0x7E9,
  .rtr=0,
  .id_type=STD_ID_TYPE,
  .dlen=0x04,
  .data={0x03, 0x7F, 0x03, 0x11},
};

//ECM responce
static const can_tx_frame_t dtc_resp[]=
{
  {
    .id=0x7E8,
    .rtr=0,
    .id_type=STD_ID_TYPE,
    .dlen=0x08,
    .data={0x10, 0x1E, 0x43, 0x0E, 0x00, 0x10, 0x01, 0x02},
  },
  {
    .id=0x7E8,
    .rtr=0,
    .id_type=STD_ID_TYPE,
    .dlen=0x08,
    .data={0x21, 0x01, 0x13, 0x01, 0x18, 0x01, 0x21, 0x01},
  },
  {
    .id=0x7E8,
    .rtr=0,
    .id_type=STD_ID_TYPE,
    .dlen=0x08,
    .data={0x22, 0x23, 0x05, 0x60, 0x07, 0x48, 0x07, 0x78},
  },
  {
    .id=0x7E8,
    .rtr=0,
    .id_type=STD_ID_TYPE,
    .dlen=0x08,
    .data={0x23, 0x09, 0x83, 0x09, 0x86, 0x21, 0x35, 0x21},
  },
  {
    .id=0x7E8,
    .rtr=0,
    .id_type=STD_ID_TYPE,
    .dlen=0x08,
    .data={0x24, 0x38, 0x27, 0x16, 0x00, 0x00, 0x00, 0x00},
  },
};

void ecu_simulation(const uint8_t can_id, const can_rx_frame_t* rx, 
                    bool (*can_transmit_blocked)(const uint8_t can_id, const can_tx_frame_t* tx, uint32_t TimeWait))
{
  if(can_id>=MAX_CAN_INTERFACES) return;
    
  if(rx->id_type!=STD_ID_TYPE) return;
  
  if(rx->rtr) return;
  
  if((rx->id==0x7DF || rx->id==0x7E0 || rx->id==0x7E1) && rx->dlen>=0x03 && rx->data[0]==0x02 && rx->data[1]==0x09 && rx->data[2]==0x02)
  {
    if(rx->id==0x7DF || rx->id==0x7E1)
    {
      can_transmit_blocked(can_id, &vin_neg_resp, 10);
    }
    
    if(rx->id==0x7DF || rx->id==0x7E0)
    {
      can_transmit_blocked(can_id, &vin_resp[0], 10);
      
      state[can_id]=1;
    }
  }
  else if(state[can_id]==1 && rx->id==0x7E0 && rx->dlen>=0x01 && rx->data[0]==0x30)
  {
    for(uint8_t i=1; i<sizeof(vin_resp)/sizeof(vin_resp[0]); i++)
    {
      can_transmit_blocked(can_id, &vin_resp[i], 10);
    }
    
    state[can_id]=0;
  }
  
  else if(rx->id==0x75B && rx->dlen>=0x03 && rx->data[0]==0x02 && rx->data[1]==0x21 && rx->data[2]==0x01)
  {
    can_transmit_blocked(can_id, &dashboard_resp[0], 10);
    
    state[can_id]=2;
  }
  else if(state[can_id]==2 && rx->id==0x75B && rx->dlen>=0x01 && rx->data[0]==0x30)
  {
    for(uint8_t i=1; i<sizeof(dashboard_resp)/sizeof(dashboard_resp[0]); i++)
    {
      can_transmit_blocked(can_id, &dashboard_resp[i], 10);
    }
    
    state[can_id]=0;
  }
  
  else if((rx->id==0x7DF || rx->id==0x7E0 || rx->id==0x7E1) && rx->dlen>=0x02 && rx->data[0]==0x01 && rx->data[1]==0x03)
  {
    if(rx->id==0x7DF || rx->id==0x7E1)
    {
      can_transmit_blocked(can_id, &dtc_neg_resp, 10);
    }
    
    if(rx->id==0x7DF || rx->id==0x7E0)
    {
      can_transmit_blocked(can_id, &dtc_resp[0], 10);
      
      state[can_id]=3;
    }
  }
  else if(state[can_id]==3 && rx->id==0x7E0 && rx->dlen>=0x01 && rx->data[0]==0x30)
  {
    for(uint8_t i=1; i<sizeof(dtc_resp)/sizeof(dtc_resp[0]); i++)
    {
      can_transmit_blocked(can_id, &dtc_resp[i], 10);
    }
    
    state[can_id]=0;
  }
}
