/**
******************************************************************************
* File Name          : eobd.c
* Description        : 
*                      
*                      
******************************************************************************
*/

#include "eobd_lib/eobd.h"
#include <stdio.h>

const char* get_verbose_obd_negative_code(const uint8_t neg_code)
{
  switch(neg_code)
  {
  case 0x10: return "generalReject";
  case 0x11: return "serviceNotSupported";
  case 0x12: return "subFunctionNotSupported-InvalidFormat";
  case 0x21: return "busy-RepeatRequest";
  case 0x22: return "conditionsNotCorrectOrRequestSequenceError";
  case 0x23: return "routineNotComplete";
  case 0x78: return "requestCorrectlyReceived-ResponsePending";
  default:   return "unknown";
  }
}

int16_t obd_dtcs_decode(const uint8_t* buff, uint16_t len, char* dst, uint16_t dst_max_size, const char delimiter)
{
  if(dst_max_size<8) return -1;
  
  dst[0]='\0';
  
  if(!len) return -1;
  
  const uint8_t dtc_count=buff[0];
  
  if(len!=(dtc_count*2+1)) return -1;
  
  const dtc_t* dtc=(dtc_t*)&buff[1];
  
  for(uint8_t i=0; i<dtc_count; i++)
  {
    char first_char;
    
    switch(dtc[i].first_char)
    {
    case 0: first_char='P'; break;
    case 1: first_char='C'; break;
    case 2: first_char='B'; break;
    case 3: first_char='U'; break;
    }
    
    int s_len=snprintf(dst, dst_max_size, "%c%hhX%hhX%hhX%hhX%c", first_char, dtc[i].second_char, dtc[i].third_char, dtc[i].fourth_char, dtc[i].fifth_char, delimiter);
    
    if(s_len<0 || s_len>=dst_max_size)
    {
      break;
    }
    
    dst_max_size-=s_len;
    dst+=s_len;
  }

  return dtc_count;
}