/**
******************************************************************************
* File Name          : eobd.h
* Description        : 
*                      
*                      
******************************************************************************
*/

/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __EOBD_H
#define __EOBD_H

#ifdef __cplusplus
extern "C" {
#endif 

#include <stdint.h>

//Modes:
#define SHOW_CURRENT_DATA                                0x01
#define SHOW_FREEZE_FRAME_DATA                           0x02
#define SHOW_STORED_DIAGNOSTIC_TROUBLE_CODES             0x03
#define CLEAR_DIAGNOSTIC_TROUBLE_CODES_AND_STORED_VALUES 0x04
#define TEST_RESULTS_OXYGEN_SENSOR_MONITORING            0x05
#define TEST_RESULTS_OTHER_SYSTEM_MONITORING             0x06
#define SHOW_PENDING_DIAGNOSTIC_TROUBLE_CODES            0x07
#define CONTROL_OPERATION_OF_ONBOARD_SYSTEM              0x08
#define REQUEST_VEHICLE_INFORMATION                      0x09
#define PERMANENT_DTCS                                   0x0A

typedef struct
{
  uint16_t third_char:4;  //0-F
  uint16_t second_char:2; //0-3
  uint16_t first_char:2;  //0-P, 1-, 2-B, 3-U
  uint16_t fifth_char:4;  //0-F
  uint16_t fourth_char:4; //0-F
}dtc_t;

inline uint8_t get_responce_for_mode(const uint8_t mode) {return (0x40|mode);}

const char* get_verbose_obd_negative_code(const uint8_t neg_code);
int16_t obd_dtcs_decode(const uint8_t* buff, uint16_t len, char* dst, uint16_t dst_max_size, const char delimiter);

#ifdef __cplusplus
}
#endif 

#endif //__EOBD_H