/**
******************************************************************************
* File Name          : subtask_manage.c
* Description        : 
*
*
******************************************************************************
*/

/* Includes ------------------------------------------------------------------*/
#include "FreeRTOS.h"
#include "task.h"
#include "subtask_utils_lib/subtask_manage.h"

/* C code---------------------------------------------------------------------*/
static inline void subtask_wait_wakeup_cmd(subtask_manage_t* const ctx)
{
  //call in subtask
  while(!ctx->wakeup_cmd) {vTaskDelay(100);}
}

static inline void subtask_wait_wakeup_cmd_with_reset_cmd(subtask_manage_t* const ctx)
{
  //call in subtask
  while(!ctx->wakeup_cmd) {vTaskDelay(100);}
  ctx->wakeup_cmd=SUBTASK_NO_CMD;
}

static inline bool subtask_is_need_sleep(subtask_manage_t* const ctx)
{
  //call in subtask
  if(ctx->sleep_cmd) {return true;}
  else               {return false;}
}

static inline void subtask_set_insleep_answer(subtask_manage_t* const ctx)
{
  //call in subtask
  ctx->sleep_cmd=SUBTASK_IN_SLEEP_ANSWER;
}

static void subtask_handle(void* args)
{
  subtask_manage_t* const ctx=(subtask_manage_t* const)args;
    
  subtask_wait_wakeup_cmd(ctx);
    
  if(ctx->rom_consts->onetime_init!=NULL) {ctx->rom_consts->onetime_init();}
  
  for(;;)
  {
    subtask_wait_wakeup_cmd_with_reset_cmd(ctx);
    
    if(ctx->rom_consts->is_verbose)
    {
      LOG("%s: ready to work...\n", ctx->rom_consts->name);
    }
  
    if(ctx->rom_consts->init!=NULL) {ctx->rom_consts->init();}
    
    for(;;)
    {
      if(subtask_is_need_sleep(ctx) \
        && (ctx->rom_consts->is_sleep_allowed==NULL || (ctx->rom_consts->is_sleep_allowed!=NULL && ctx->rom_consts->is_sleep_allowed())))
      {
        break;
      }
      
      ctx->rom_consts->main_cycle();
    }
    
    if(ctx->rom_consts->deinit!=NULL) {ctx->rom_consts->deinit();}
    
    if(ctx->rom_consts->is_verbose)
    {
      LOG("%s: in sleep...\n", ctx->rom_consts->name);
    }
    
    subtask_set_insleep_answer(ctx);
  }
}

void subtask_wakeup(subtask_manage_t* const ctx)
{
  //call in master task
  ctx->sleep_cmd=SUBTASK_NO_CMD;
  ctx->wakeup_cmd=SUBTASK_WAKEUP_REQUEST;
}

void subtask_goto_sleep(subtask_manage_t* const ctx)
{
  //call in master task
  ctx->sleep_cmd=SUBTASK_SLEEP_REQUEST;
  while(ctx->sleep_cmd!=SUBTASK_IN_SLEEP_ANSWER) vTaskDelay(50);
  ctx->sleep_cmd=SUBTASK_NO_CMD;
}

void subtask_init(subtask_manage_t* const ctx)
{
  //call in master task onetime
  ctx->sleep_cmd=SUBTASK_IN_SLEEP_ANSWER;
  ctx->wakeup_cmd=SUBTASK_NO_CMD;
  
  xTaskCreate(subtask_handle, ctx->rom_consts->name, ctx->rom_consts->stack_size, ctx, ctx->rom_consts->priority, NULL);
}

bool bad_mutex_take(volatile uint8_t* const mutex, const bool is_wait_for_taking)
{
  bool is_taking=false;
  
  for(;;)
  {
    taskENTER_CRITICAL();
    if(!(mutex[0])) 
    {
      mutex[0]=1;
      taskEXIT_CRITICAL();
      is_taking=true;
      break;
    }
    taskEXIT_CRITICAL();
    
    if(!is_wait_for_taking) break;
    
    vTaskDelay(1);
  }
  
  return is_taking;
}

void bad_mutex_give(volatile uint8_t* const mutex)
{
  taskENTER_CRITICAL();
  mutex[0]=0;
  taskEXIT_CRITICAL();
}