/**
  ******************************************************************************
  * File Name          : subtask_manage.h
  * Description        :
  *                      
  *                      
  ******************************************************************************
*/
#ifndef __SUBTASK_MANAGE_H
#define __SUBTASK_MANAGE_H

#ifdef __cplusplus
extern "C" {
#endif 
  
#include <stdint.h> 
#include <stdlib.h>
#include <stdio.h>
#include <stdbool.h>

typedef enum
{
  SUBTASK_NO_CMD=0,
  SUBTASK_SLEEP_REQUEST=1,
  SUBTASK_WAKEUP_REQUEST=1,
  SUBTASK_IN_SLEEP_ANSWER=2,
}subtask_cmd_t;

typedef const struct
{
  const char* const name;
  const uint16_t stack_size;
  const uint8_t priority;
  const bool is_verbose;
  
  void (*onetime_init)(void);
  void (*init)(void);
  void (*main_cycle)(void);
  void (*deinit)(void);
  bool (*is_sleep_allowed)(void);
}subtask_manage_const_t;
  
typedef struct
{
  const subtask_manage_const_t* const rom_consts;
  volatile subtask_cmd_t sleep_cmd;
  volatile subtask_cmd_t wakeup_cmd;
}subtask_manage_t;

#define __INIT_CONST_SUBTASK_CTX_FIELDS(__subtask_ctx, __subtask_name, __subtask_stack_size, __subtask_priority, __subtask_is_verbose, __subtask_onetime_init, __subtask_init, __subtask_main_cycle, __subtask_deinit, __subtask_is_sleep_allowed) \
static const subtask_manage_const_t (__subtask_ctx##_const) = \
{ \
  .name=(__subtask_name), \
  .stack_size=(__subtask_stack_size), \
  .priority=(__subtask_priority), \
  .is_verbose=(__subtask_is_verbose), \
  .onetime_init=(__subtask_onetime_init), \
  .init=(__subtask_init), \
  .main_cycle=(__subtask_main_cycle), \
  .deinit=(__subtask_deinit), \
  .is_sleep_allowed=(__subtask_is_sleep_allowed), \
}; \
static subtask_manage_t (__subtask_ctx) = \
{ \
  .rom_consts=&(__subtask_ctx##_const), \
  .sleep_cmd=SUBTASK_IN_SLEEP_ANSWER, \
  .wakeup_cmd=SUBTASK_NO_CMD, \
};

void subtask_wakeup(subtask_manage_t* const ctx);
void subtask_goto_sleep(subtask_manage_t* const ctx);
void subtask_init(subtask_manage_t* const ctx);

bool bad_mutex_take(volatile uint8_t* const mutex, const bool is_wait_for_taking);
void bad_mutex_give(volatile uint8_t* const mutex);

extern void LOG(const char* string, ...);

#ifdef __cplusplus
}
#endif 

#endif /*__SUBTASK_MANAGE_H*/