#ifndef LIB_TIMER_H
#define LIB_TIMER_H

#include <time/time.h>

namespace NTime
{
class TTimer
{
public:
    TTimer() = default;

    bool IsStarted() const {
        return Started;
    }

    void Start();
    void Restart();
    void Stop();
    TTime Elapsed();
    bool HasExpired(const TTime& timeout);

private:
    bool Started = false;
    TTime StartTime = TTime(0);
};

inline void TTimer::Start() { 
    StartTime = TTime::Now();
    Started = true;
}

inline void TTimer::Restart() {
    if (!Started) {
        Started = true;
    }

    StartTime = TTime::Now();
}

inline void TTimer::Stop() {
    Started = false;
}

inline TTime TTimer::Elapsed() {
    return TTime::Now() - StartTime;
}

inline bool TTimer::HasExpired(const TTime& timeout) {
    return Elapsed() >= timeout;
}
}

#endif /* LIB_TIMER_H */
