/**
  ******************************************************************************
  * File Name          : Manager.cpp
  * Description        :    (),    
  *                        .      
  *                       .
  *                      
  ******************************************************************************
*/


/* Includes ------------------------------------------------------------------*/
#include "manager.h"

/* Global variables-----------------------------------------------------------*/

/* C++ code-------------------------------------------------------------------*/
// 
CManager::CManager(const char* mngr_name, QueueHandle_t* output_queue, uint8_t input_queue_size, uint8_t priority, TaskFunction_t task_starter, uint16_t stack_size)
{
  //      
  this->input_queue = xQueueCreate(input_queue_size, sizeof(input_message));
  #ifdef DEBUG
  vQueueAddToRegistry(this->input_queue, mngr_name);
  #endif
  //     
  this->output_queue = output_queue;
  //  
  this->priority = priority;
  //  
  xTaskCreate(task_starter, mngr_name, stack_size, NULL, tskIDLE_PRIORITY, &this->task_handle);
}

//        ,   
bool CManager::Send_message(QueueHandle_t* queue, TickType_t xTicksToWait)
{
  if(xQueueSend(*queue, &this->output_message, xTicksToWait) != pdPASS) return false;
  else                                                                  return true;  
}

//      ,  
bool CManager::Wait_message(TickType_t xTicksToWait)
{
  return xQueueReceive(this->input_queue, &this->input_message, xTicksToWait);
}

//   
void CManager::Set_priority(void)
{
  vTaskPrioritySet(this->task_handle, tskIDLE_PRIORITY + this->priority);
}

