/**
  ******************************************************************************
  * File Name          : Manager.h
  * Description        :    (),    
  *                        .      
  *                       .
  *                      
  ******************************************************************************
*/

/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef MANAGER_H
#define MANAGER_H

/* Includes ------------------------------------------------------------------*/
#include "FreeRTOS.h"
#include "queue.h"
#include "task.h"
#include "system_messages.h"

/* Defines- ------------------------------------------------------------------*/

/* C++ code-------------------------------------------------------------------*/
class CManager
{
  public:
  // ,   ,    ,    ,     ,  
  CManager(const char* mngr_name, QueueHandle_t* output_queue, uint8_t output_queue_size, uint8_t priority, TaskFunction_t task_starter, uint16_t stack_size);  
  //  ,  
  virtual void Init() = 0;
  //  ,  
  virtual void Deinit(void) = 0; 
  //  
  virtual void Main_cycle(void) = 0;
  //  
  void Set_priority(void);
  //   
  TaskHandle_t task_handle;
  //   
  QueueHandle_t input_queue;
  //     
  QueueHandle_t* output_queue;
  
  //       
  bool Send_message(QueueHandle_t* queue, TickType_t xTicksToWait = portMAX_DELAY);
  //       
  bool Wait_message(TickType_t xTicksToWait);
  //  
  T_system_message input_message;
  //  
  T_system_message output_message;
  
  protected:

  //   
  uint8_t priority;
  //   

};

/* C code---------------------------------------------------------------------*/

#endif //MANAGER_H