/**
******************************************************************************
* File Name          : server_manager.cpp
* Description        : �������� SERVER
*
*
******************************************************************************
*/

/* Includes ------------------------------------------------------------------*/
#include "server_manager/server_manager.h"
#include "syscom_manager.h"
#include "System/system.h"
#include "debug_port.h"

#if (!defined(UINT16_MAX))
#define UINT16_MAX __UINT16_T_MAX__
#endif //(!defined(UINT16_MAX))

#if defined(USE_CINTERION_MODEM_LIB)
#include "gsm_modems_lib/cinterion/cinterion_modem_lib.h"
#elif defined(USE_SIMCOM_MODEM_LIB)
#include "gsm_modems_lib/simcom/simcom_modem_lib.h"
#elif defined(USE_QUECTEL_MODEM_LIB)
#include "gsm_modems_lib/quectel/quectel_modem_lib.h"
#else
#error
#endif //USE_CINTERION_MODEM_LIB //USE_SIMCOM_MODEM_LIB //USE_QUECTEL_MODEM_LIB

#if (MAX_SIM_COUNT < 1) || (MAX_SIM_COUNT > 2)
#error этот менеджер поддерживает одну или две sim
#endif //MAX_SIM_COUNT

#if defined(CHECK_SIM_0_TIMEOUT_MS)
#error replace CHECK_SIM_0_TIMEOUT_MS -> CHECK_MAINT_SIM_TIMEOUT_MS
#endif //defined(CHECK_SIM_0_TIMEOUT_MS)

#if (MAX_SIM_COUNT > 1) && (!defined(CHECK_MAINT_SIM_TIMEOUT_MS))
#error defined CHECK_MAINT_SIM_TIMEOUT_MS
#endif //(MAX_SIM_COUNT > 1) && (!defined(CHECK_SIM_0_TIMEOUT_MS))

#include "time_utilities/time_utilities.h"
#include "rtc_driver.h"
#include "leds_driver.h"
#include "Black_box/Black_box.h"
#include "tea_crypt/tea.h"
#include "NOR_FTL/NOR_FTL.h"

#ifdef __cplusplus
extern "C" {
#endif
#define CONFIGURED 1
#include "usbd_cdc_vcp.h"
#ifdef __cplusplus
}
#endif

/* Global variables-----------------------------------------------------------*/
// SERVER менеджер
CSERVER_manager SERVER_manager(SERVER_MANAGER_NAME, &Syscom_manager.input_queue, SERVER_MANAGER_INPUT_CUEUE_SIZE, SERVER_MANAGER_PRIORITY, Start_server_manager, SERVER_MANAGER_STACK_SIZE);
extern CBlack_box Black_box;
extern CNOR_ftl NOR_ftl;

extern void Shadow_settings_manage(const TSetting_header* header, const uint8_t* payload);

#if defined(USE_PULSED_MODEM_POWER_ON)
static const TIM_TimeBaseInitTypeDef modem_pwr_tim_cfg  = {MODEM_PWR_TIM_CLOCK_MHZ, TIM_CounterMode_Up, 0xffff, TIM_CKD_DIV1, 0};
static const NVIC_InitTypeDef modem_pwr_nvic_cfg = {MODEM_PWR_TIM_IRQn, MODEM_PWR_TIM_IRQ_PRIORITY, 0, ENABLE};

static volatile struct modem_pwr_struct
{
  uint8_t is_modem_pwr_ready;
  uint8_t modem_pwr_on_pulse_idx;
}modem_pwr;

//in us
static const uint16_t modem_pwr_on_pulse[] =
{
  140, 143, 147, 153, 162, 167, 173, 180, 188, 196, 206, 217, 230, 243, 259, 276,
  295, 317, 341, 368, 399, 434, 473, 517, 567, 624, 688, 761, 845, 941, 1051, 1177
};
//in us
static const uint16_t modem_pwr_off_pulse=50;
#endif //USE_PULSED_MODEM_POWER_ON

static conn_ctx_t conn_ctx[SERVER_TCP_CNT]={0};
static uint8_t rx_mem_conn[SERVER_TCP_CNT][1024];
#if defined(__EC21_X__) || defined(__UG95__)
static uint8_t common_tx_mem[2*1460];
#else
static uint8_t common_tx_mem[1460];
#endif //defined(__EC21_X__) || defined(__UG95__)
static local_server_settings_t local_settings[SERVER_TCP_CNT];
static uint32_t apn_settings_digest;
static struct local_traffic_counter_struct
{
  uint16_t rx;
  uint16_t tx;
}local_traffic_counter[SERVER_TCP_CNT]={0};
static struct cycle_poll_struct
{
  uint16_t main_timeout;
  uint32_t last_activity_time;
}cycle_poll;

#if (DEVICE_TYPE == DEVICE_TYPE_VEGA_MT_32K_LTE || DEVICE_TYPE == DEVICE_TYPE_VEGA_MT_32K_LTE_V2)
static struct scan_mode_struct
{
  uint8_t mode;
  uint32_t timerS;
}scan_mode;
#elif (DEVICE_TYPE == DEVICE_TYPE_VEGA_MT_25K || DEVICE_TYPE == DEVICE_TYPE_VEGA_MT_32K_LTE_V3)
#define AUTO_SCAN_MODE 0
#endif //DEVICE_TYPE_VEGA_MT_32K_LTE || DEVICE_TYPE_VEGA_MT_32K_LTE_V2 || DEVICE_TYPE_VEGA_MT_25K || DEVICE_TYPE == DEVICE_TYPE_VEGA_MT_32K_LTE_V2

#define SMS_OUT_QUEURE_LEN 4
static struct sms_out_queue_struct
{
  uint8_t is_not_empty;
  uint8_t phone_id;
  uint16_t sms_data_max_size;
  char* sms_data;
}sms_out_queue[SMS_OUT_QUEURE_LEN]={0};

#if defined(BT3_PRESENT)
static conn_ctx_t bt_ctx={0};
static uint8_t bt_rx_mem[256];
#endif //defined(BT3_PRESENT)

#define BEELINE_MNC 99

static int8_t _got_vega_packet_callback(uint8_t conn_id, uint8_t* packet, uint8_t* ans_buff, uint16_t ans_buff_size, uint16_t* ans_len)
{
  static volatile uint8_t is_busy=0;

  for(;;)
  {
    taskENTER_CRITICAL();
    if(!is_busy)
    {
      is_busy=1;
      taskEXIT_CRITICAL();
      break;
    }
    taskEXIT_CRITICAL();
    vTaskDelay(2);
  }

  xQueueReceive(SERVER_manager.answer_queue, &SERVER_manager.input_message, 0);//flush

  SERVER_manager.output_message.source = SERVER_MANAGER;
  SERVER_manager.output_message.source_id = conn_id;
  SERVER_manager.output_message.code = MESSAGE_SERVER_RECV_DATA;
  SERVER_manager.output_message.pPayload = packet;
  SERVER_manager.output_message.pAnswer = ans_buff;
  SERVER_manager.output_message.answer_size = ans_buff_size;
  SERVER_manager.Send_message(SERVER_manager.output_queue);

  xQueueReceive(SERVER_manager.answer_queue, &SERVER_manager.input_message, portMAX_DELAY);

  if(SERVER_manager.input_message.code==COMMAND_SERVER_DATA_ANSWER_OK)
  {
    *ans_len=SERVER_manager.input_message.answer_size;
    is_busy=0;
    return 0;
  }
  else
  {
    //Константин гарантирует, что это условие выполняется только тогда, когда не хватает места для формирования ответа
    *ans_len=0;
    is_busy=0;
    return -1;
  }
}

got_vega_packet_callback_t get_got_vega_packet_callback_pointer(void)
{
  return _got_vega_packet_callback;
}

static uint32_t _get_unix_time(void)
{
  return GetUnixTime();
}

static int16_t _socket_write(uint8_t conn_id, uint8_t* buff, uint16_t len)
{
  if(conn_id<=SERVER_LAST_TCP_CONN_ID)
  {
    int16_t wlen;
    wlen=tcp_socket_write(conn_id, buff, len);
    if(wlen>0)
    {
      cycle_poll.last_activity_time=xTaskGetTickCount();

      local_traffic_counter[conn_id].tx+=wlen;

      System.Grab(portMAX_DELAY);
      System.server_state.traffic_counter[conn_id].tx+=(local_traffic_counter[conn_id].tx)/1024;
      System.Release();
      local_traffic_counter[conn_id].tx=(local_traffic_counter[conn_id].tx)%1024;
    }
    return wlen;
  }
  else if(conn_id==SERVER_USB_CONN_ID) return USB_CDC_Send(buff, len, 300);

#if defined(BT3_PRESENT)
  else if(conn_id==SERVER_BT_CONN_ID)
  {
    int16_t wlen;
    wlen=BtSppWrite(NULL, buff, len);
    if(wlen>0) cycle_poll.last_activity_time=xTaskGetTickCount();
    return wlen;
  }
#endif //defined(BT3_PRESENT)

  else
    return -1;
}

static int16_t _socket_read(uint8_t conn_id, uint8_t* buff, uint16_t len)
{
  if(conn_id<=SERVER_LAST_TCP_CONN_ID)
  {
    int16_t rlen;
    if(len>1460) len=1460;
    rlen=tcp_socket_read(conn_id, buff, len);
    if(rlen>0)
    {
      cycle_poll.last_activity_time=xTaskGetTickCount();

      local_traffic_counter[conn_id].rx+=rlen;

      System.Grab(portMAX_DELAY);
      System.server_state.traffic_counter[conn_id].rx+=(local_traffic_counter[conn_id].rx)/1024;
      System.Release();
      local_traffic_counter[conn_id].rx=(local_traffic_counter[conn_id].rx)%1024;

#if NO_RX_DATA_SIM_CHANGE_OR_REBOOT_TIMEOUT_S > 0
      SERVER_manager.last_tcp_data_recv_timeS=GetSecondsFromStartup();
#endif //NO_RX_DATA_SIM_CHANGE_OR_REBOOT_TIMEOUT_S > 0

      SERVER_manager.yandex_force_block_timerS=GetSecondsFromStartup();
    }
    return rlen;
  }
  else if(conn_id==SERVER_USB_CONN_ID) return USB_CDC_Receive(buff, len, 10);

#if defined(BT3_PRESENT)
  else if(conn_id==SERVER_BT_CONN_ID)
  {
    int16_t rlen;
    if(len>1024) len=1024;
    rlen=BtSppRead(NULL, buff, len);
    if(rlen>0) cycle_poll.last_activity_time=xTaskGetTickCount();
    return rlen;
  }
#endif //defined(BT3_PRESENT)

  else
    return -1;
}

#if defined(BT3_PRESENT)
static uint32_t bt_timeout_after_socket_openMS=0;
#endif //defined(BT3_PRESENT)

static int16_t _socket_open(uint8_t conn_id, const char* addr)
{
  if(conn_id<=SERVER_LAST_TCP_CONN_ID)
  {
    int16_t res;
    res=tcp_socket_open(conn_id, addr);
    if(res!=GSM_RES_OK) return -1;
    return 0;
  }
  else if(conn_id==SERVER_USB_CONN_ID)
  {
    if(CONFIGURED!=USB_CDC_State()) return -1;
    USB_CDC_Receive(NULL, NULL ,NULL);
    return 0;
  }

#if defined(BT3_PRESENT)
  else if(conn_id==SERVER_BT_CONN_ID)
  {
    if(!BtIsSppConnectExist())
    {
      return -1;
    }
    else
    {
      bt_timeout_after_socket_openMS=xTaskGetTickCount()+2000;
      return 0;
    }
  }
#endif //defined(BT3_PRESENT)

  else
    return -1;
}

static cstate_t _socket_state(uint8_t conn_id)
{
  if(conn_id<=SERVER_LAST_TCP_CONN_ID)
  {
    int16_t cstate=tcp_socket_state(conn_id);
    if(cstate<0) return INTERNAL_ERR_CSTATE;
    else if(cstate==UP_OR_LISTENNING_CONN_STATE) return CONNECTED_CSTATE;
    else if(cstate==DOWN_CONN_STATE) return DOWN_CSTATE;
    else return WAIT_CONNECTED_CSTATE;
  }
  else if(conn_id==SERVER_USB_CONN_ID)
  {
    if(CONFIGURED!=USB_CDC_State()) return DOWN_CSTATE;
    else return CONNECTED_CSTATE;
  }

#if defined(BT3_PRESENT)
  else if(conn_id==SERVER_BT_CONN_ID)
  {
    if(!timeAfter(xTaskGetTickCount(), bt_timeout_after_socket_openMS)) return WAIT_CONNECTED_CSTATE;
    else if(BtIsSppConnectExist()) return CONNECTED_CSTATE;
    else return DOWN_CSTATE;
  }
#endif //defined(BT3_PRESENT)

  else
    return INTERNAL_ERR_CSTATE;
}

static int16_t _socket_close(uint8_t conn_id)
{
  if(conn_id<=SERVER_LAST_TCP_CONN_ID)
  {
    return tcp_socket_close(conn_id);
  }
  else if(conn_id==SERVER_USB_CONN_ID) return 0;

#if defined(BT3_PRESENT)
  else if(conn_id==SERVER_BT_CONN_ID)
  {
    return BtSppDisconnect();
  }
#endif //defined(BT3_PRESENT)

  else
    return -1;
}

static int16_t _socket_get_nack_len(uint8_t conn_id, uint32_t* naclen)
{
  *naclen=0;
  if(conn_id<=SERVER_LAST_TCP_CONN_ID)
  {
#if defined(USE_CINTERION_MODEM_LIB)
    return get_tx_unack_data_len(conn_id, naclen);
#endif //USE_CINTERION_MODEM_LIB

#if defined(USE_SIMCOM_MODEM_LIB)
    return tcp_socket_transmitting_state(conn_id, NULL, NULL, naclen);
#endif //USE_SIMCOM_MODEM_LIB

#if defined(USE_QUECTEL_MODEM_LIB)
    return tcp_socket_transmitting_state(conn_id, NULL, NULL, naclen);
#endif //USE_QUECTEL_MODEM_LIB
  }
  else if(conn_id==SERVER_USB_CONN_ID) return 0;

#if defined(BT3_PRESENT)
  else if(conn_id==SERVER_BT_CONN_ID)
  {
    return GSM_RES_OK;
  }
#endif //USE_SIMCOM_MODEM_LIB

  else
    return -1;
}

static void _grab_mess(uint8_t type)
{
  (void) type;
  Black_box.Grab();
}

static void _release_mess(uint8_t type)
{
  (void) type;
  Black_box.Release();
}

static int8_t _get_mess_count(uint8_t type, uint8_t receiver, uint32_t* mess_count)
{
  (void) type;
  *mess_count=Black_box.get_message_count(receiver);
  return 0;
}

static uint8_t* _read_message(uint8_t type, uint8_t receiver, uint16_t message_offset)
{
  (void) type;
  static uint8_t bbox_buff[BB_MESSAGE_MAXSIZE];
  if(Black_box.read_message(bbox_buff, receiver, message_offset) == BB_OPERATION_OK) return bbox_buff;
  else return NULL;
}

static int8_t _delete_messages(uint8_t type, uint8_t receiver, uint8_t message_count)
{
  (void) type;
  if(Black_box.delete_messages(receiver, message_count) == BB_OPERATION_OK) return 0;
  else return -1;
}

static int8_t _get_message_param_name_type(uint16_t param_id, uint16_t* trans_param_id, const uint8_t* param_type_in_pack, const char** param_name, param_types_t* param_type, uint16_t* egts_param_id)
{
  TSensor_data_type data_type;

  if(trans_param_id!=NULL) trans_param_id[0]=param_id;

  if(0==System.Find_sensor(param_id, param_name, NULL, &data_type, egts_param_id)) {return -1;}

  if(data_type==UNITED)
  {
    if(param_type_in_pack==NULL)  {return -1;}
    data_type=(TSensor_data_type)param_type_in_pack[0];
  }

  switch (data_type)
  {
  case BOOL:   param_type[0]=BOOL_PARAM_TYPE; break;
  case UINT8:  param_type[0]=UINT8_PARAM_TYPE; break;
  case INT8:   param_type[0]=INT8_PARAM_TYPE; break;
  case UINT16: param_type[0]=UINT16_PARAM_TYPE; break;
  case INT16:  param_type[0]=INT16_PARAM_TYPE; break;
  case UINT32: param_type[0]=UINT32_PARAM_TYPE; break;
  case INT32:  param_type[0]=INT32_PARAM_TYPE; break;
  case UINT64: param_type[0]=UINT64_PARAM_TYPE; break;
  case INT64:  param_type[0]=INT64_PARAM_TYPE; break;
  case FLOAT:  param_type[0]=FLOAT_PARAM_TYPE; break;
  case DOUBLE: param_type[0]=DOUBLE_PARAM_TYPE; break;
  case STRING: param_type[0]=STRING_PARAM_TYPE; break;
  default:     return -1;
  }

  if(param_type_in_pack==NULL || \
    (param_type_in_pack!=NULL && param_type_in_pack[0]==(uint8_t)data_type))
  {
    return 0;
  }

  return -1;
}

static int8_t _photo_inf(uint8_t conn_id, const char** fname, uint32_t* size, uint32_t* time_stamp, uint8_t* busy_status)
{
  *size=0;
  return 0;
}

static int8_t _photo_read_chunk(uint8_t conn_id, const char* fname, uint8_t* dst_buff, uint16_t read_len, uint32_t read_offset)
{
  return -1;
}

static int8_t _photo_delete(uint8_t conn_id, const char* fname)
{
  return -1;
}

static int8_t _file_clean(const char* fname)
{
  static const char* const allowable_fnames[]={"LOG", "FIRMWARE", "CANPRO", "SETTINGS", "FOTO1", "FOTO2", "FOTO3", "FOTO4", "FOTO5"};

  uint8_t i;
  for(i=0; i<sizeof(allowable_fnames)/sizeof(const char* const); i++)
  {
    if(memcmp(fname, allowable_fnames[i], sizeof(allowable_fnames[i]))==0)
    {
      break;
    }
  }
  if(i>=sizeof(allowable_fnames)/sizeof(const char* const))  return -2;//файл имеет недопустисое имя

  Black_box.Grab();

  uint8_t is_opened;
  if(Black_box.fopened(fname, &is_opened) != BB_OPERATION_OK)
  {
    Black_box.Release();
    return -1;
  }
  if(is_opened)
  {
    Black_box.Release();
    return -3;
  }

  if(Black_box.fopen(fname) != BB_OPERATION_OK)
  {
    Black_box.Release();
    return -1;
  }

  if(Black_box.fflush(fname) != BB_OPERATION_OK)
  {
    Black_box.fclose(fname);
    Black_box.Release();
    return -1;
  }

  if(Black_box.fsave() != BB_OPERATION_OK)
  {
    Black_box.fclose(fname);
    Black_box.Release();
    return -1;
  }

  if(Black_box.fclose(fname) != BB_OPERATION_OK)
  {
    Black_box.Release();
    return -1;
  }

  Black_box.Release();
  return 0;
}

static int8_t _file_write_chunk(const uint8_t conn_id, const char** fname, uint8_t* chunk, uint16_t chunk_len, uint8_t is_first_chunk, uint8_t is_cert_verify)
{
  static const char* const allowable_fnames[]={"FIRMWARE", "CANPRO", "SETTINGS"};
  static const char* const unknown_fname="";

  static struct
  {
    tea_context cert_ctx;
    union
    {
      struct
      {
        uint32_t cert[2];
        char fname[8];
        uint8_t dev_type;
        uint8_t reserve[7];
      };
      uint8_t header[24];
    };
    uint8_t header_pos;
    uint8_t is_header_cert_calced;
  }file_write_chunk_ctx[SERVER_LAST_COMMON_CONN_ID+1];

  uint8_t copy_len;
  uint8_t is_opened;

  //������ ���� �� ������, ������������ ������������
  if(conn_id>SERVER_LAST_COMMON_CONN_ID) return -1;//for(;;);

  if(is_cert_verify)
  {
    //*fname=(char*)&header[8];
    //��������� ��� ������ ��������� �� ��� � allowable_fnames

    tea_certify_finish(&file_write_chunk_ctx[conn_id].cert_ctx);

    if(memcmp(file_write_chunk_ctx[conn_id].cert, file_write_chunk_ctx[conn_id].cert_ctx.cert, sizeof(file_write_chunk_ctx[conn_id].cert_ctx.cert))==0)
    {
      //подписи совпали, сохраняем изменения в файле
      Black_box.Grab();

      if(Black_box.fopen(*fname) != BB_OPERATION_OK)
      {
        Black_box.Release();
        return -2;
      }

      if(Black_box.fsave() != BB_OPERATION_OK)
      {
        Black_box.fclose(*fname);
        Black_box.Release();
        return -1;
      }

      if(Black_box.fclose(*fname) != BB_OPERATION_OK)
      {
        Black_box.Release();
        return -1;
      }

      Black_box.Release();

      return 0;
    }
    else
    {
      Black_box.Grab();

      if(Black_box.fopen(*fname) != BB_OPERATION_OK)
      {
        Black_box.Release();
        return -1;
      }

      if(Black_box.fflush(*fname) != BB_OPERATION_OK)
      {
        Black_box.fclose(*fname);
        Black_box.Release();
        return -1;
      }

      if(Black_box.fsave() != BB_OPERATION_OK)
      {
        Black_box.fclose(*fname);
        Black_box.Release();
        return -1;
      }

      if(Black_box.fclose(*fname) != BB_OPERATION_OK)
      {
        Black_box.Release();
        return -1;
      }

      Black_box.Release();

      return -3; //������� �� �������
    }
  }

  if(is_first_chunk)
  {
    file_write_chunk_ctx[conn_id].header_pos=0;
    file_write_chunk_ctx[conn_id].is_header_cert_calced=0;
    tea_certify_init(&file_write_chunk_ctx[conn_id].cert_ctx, __get_vega_signat_key());
  }

  //����� �� ������� ���������
  if(file_write_chunk_ctx[conn_id].header_pos<sizeof(file_write_chunk_ctx[conn_id].header))
  {
    if(chunk_len>sizeof(file_write_chunk_ctx[conn_id].header)) copy_len=sizeof(file_write_chunk_ctx[conn_id].header);
    else                                                       copy_len=(uint8_t)chunk_len;
    memcpy(&file_write_chunk_ctx[conn_id].header[file_write_chunk_ctx[conn_id].header_pos], chunk, copy_len);
    file_write_chunk_ctx[conn_id].header_pos+=copy_len;
    chunk_len-=copy_len;
    *fname=unknown_fname;
    if(chunk_len==0) return 0;
    chunk+=copy_len;
  }

  if(file_write_chunk_ctx[conn_id].is_header_cert_calced==0)
  {
    tea_certify_update(&file_write_chunk_ctx[conn_id].cert_ctx, &file_write_chunk_ctx[conn_id].header[sizeof(file_write_chunk_ctx[conn_id].cert)], sizeof(file_write_chunk_ctx[conn_id].header)-sizeof(file_write_chunk_ctx[conn_id].cert));
    file_write_chunk_ctx[conn_id].is_header_cert_calced=1;
  }

  //���� ��� ����� ������������� � allowable_fnames
  *fname=unknown_fname;
  const uint8_t fname_len=strnlen(file_write_chunk_ctx[conn_id].fname, sizeof(file_write_chunk_ctx[conn_id].fname));
  uint8_t i;
  for(i=0; i<sizeof(allowable_fnames)/sizeof(const char* const); i++)
  {
    if(fname_len==strlen(allowable_fnames[i]) &&
       memcmp(file_write_chunk_ctx[conn_id].fname, allowable_fnames[i], fname_len)==0)
    {
      *fname=allowable_fnames[i];
      break;
    }
  }
  if(i>=sizeof(allowable_fnames)/sizeof(const char* const)) return -2;//���� ����� ������������ ���

#if (DEVICE_TYPE == DEVICE_TYPE_VEGA_MT_5_V2 || DEVICE_TYPE == DEVICE_TYPE_VEGA_MT_5_CAN_V2 || DEVICE_TYPE == DEVICE_TYPE_VEGA_MT_5_V3 || DEVICE_TYPE == DEVICE_TYPE_VEGA_MT_5_CAN_V3 || DEVICE_TYPE == DEVICE_TYPE_VEGA_MT_X_LITE)
#if defined(GNSS_UPDATE_FW_PRESENT)
  //� MT-5 v2 � v3 ��� ����� "CANPRO", ���������� "FIRMWARE"
  if(memcmp(file_write_chunk_ctx[conn_id].fname, allowable_fnames[i], fname_len)==0)
  {
    if(strcmp(*fname, "CANPRO") == 0)
    {
      *fname="FIRMWARE";
    }
  }
#endif //defined(GNSS_UPDATE_FW_PRESENT)
#endif //(DEVICE_TYPE == DEVICE_TYPE_VEGA_MT_5_V2 || DEVICE_TYPE == DEVICE_TYPE_VEGA_MT_5_CAN_V2 || DEVICE_TYPE == DEVICE_TYPE_VEGA_MT_5_V3 || DEVICE_TYPE == DEVICE_TYPE_VEGA_MT_5_CAN_V3 || DEVICE_TYPE == DEVICE_TYPE_VEGA_MT_X_LITE)

  tea_certify_update(&file_write_chunk_ctx[conn_id].cert_ctx, chunk, chunk_len);

  Black_box.Grab();

  if(Black_box.fopened(*fname, &is_opened)!= BB_OPERATION_OK)
  {
    Black_box.Release();
    return -2;
  }

  if(is_opened)
  {
    Black_box.Release();
    return -1;
  }

  if(Black_box.fopen(*fname) != BB_OPERATION_OK)
  {
    Black_box.Release();
    return -2;
  }

  if(is_first_chunk)
  {
    if(Black_box.fflush(*fname) != BB_OPERATION_OK)
    {
      Black_box.fclose(*fname);
      Black_box.Release();
      return -1;
    }
    if(Black_box.fsave() != BB_OPERATION_OK)
    {
      Black_box.fclose(*fname);
      Black_box.Release();
      return -1;
    }
  }

  ///*
  if(file_write_chunk_ctx[conn_id].is_header_cert_calced==1)
  {
    //���� ��� ���� ��������, �� ����� � ��������� �����
    if(strcmp(*fname, "SETTINGS") == 0)
    {
      if(Black_box.fwrite(*fname, file_write_chunk_ctx[conn_id].header, sizeof(file_write_chunk_ctx[conn_id].header)) != BB_OPERATION_OK)
      {
        Black_box.fclose(*fname);
        Black_box.Release();
        return -1;
      }
    }

    file_write_chunk_ctx[conn_id].is_header_cert_calced=2;
  }
  //*/

  if(Black_box.fwrite(*fname, chunk, chunk_len) != BB_OPERATION_OK)
  {
    Black_box.fclose(*fname);
    Black_box.Release();
    return -1;
  }

  //  �������� ����� �������� �������
  //  if(Black_box.fsave() != BB_OPERATION_OK)
  //  {
  //    Black_box.fclose(*fname);
  //    Black_box.Release();
  //    return -1;
  //  }

  if(Black_box.fclose(*fname) != BB_OPERATION_OK)
  {
    Black_box.Release();
    return -1;
  }

  Black_box.Release();

  return 0;
}

static int8_t _file_read_chunk(uint8_t conn_id, const char* fname, uint32_t* fsize, uint8_t* dst_buff, uint16_t* readed_len , uint16_t req_len, uint32_t read_offset)
{
  static struct file_read_chunk_ctx_struct
  {
    uint32_t start_read_log_ptr;
  }file_read_chunk_ctx[SERVER_LAST_COMMON_CONN_ID+1];

  int8_t res=0;

  //������ ���� �� ������, ������������ ������������
  if(conn_id>SERVER_LAST_COMMON_CONN_ID) return -1;

  Black_box.Grab();
  for(;;)
  {
    uint8_t is_opened;
    if(Black_box.fopened(fname, &is_opened) != BB_OPERATION_OK)
    {
      //��� ������ �����
      res=-4;
      break;
    }
    if(is_opened)
    {
      //занят
      res=-2;
      break;
    }

    if(Black_box.fsize(fname, fsize) != BB_OPERATION_OK)
    {
      //������ ������
      res=-1;
      break;
    }

    if(Black_box.fopen(fname) != BB_OPERATION_OK)
    {
      //ошибка памяти
      res=-1;
      break;
    }

    if(*fsize<=read_offset)
    {
      Black_box.fclose(fname);
      //задано смещение вне файла
      res=-3;
      break;
    }

    if(req_len>=*fsize-read_offset) req_len=*fsize-read_offset;

    //���� LOG, �� ��������� ����������� ��������� �� ������ � ��
    uint32_t internal_read_offset=0;
    if(memcmp("LOG", fname, strlen("LOG"))==0)
    {
      uint32_t curr_log_ptr=Black_box.get_file_read_ptr("LOG");

      //���� ��� ������ ������
      if(read_offset==0)
      {
        file_read_chunk_ctx[conn_id].start_read_log_ptr=curr_log_ptr;
      }
      else
      {
        //сместился указатель на чтение
        if(file_read_chunk_ctx[conn_id].start_read_log_ptr<curr_log_ptr)
        {
          internal_read_offset=curr_log_ptr-file_read_chunk_ctx[conn_id].start_read_log_ptr;
        }
        //сместился указатель на чтение, кольцо замкнулось
        else if(file_read_chunk_ctx[conn_id].start_read_log_ptr>curr_log_ptr)
        {
          internal_read_offset=(Black_box.get_file_total_size("LOG")-file_read_chunk_ctx[conn_id].start_read_log_ptr)+curr_log_ptr;
        }
      }
    }

    if(read_offset<internal_read_offset)
    {
      Black_box.fclose(fname);
      //неправильно посчитали смещение internal_read_offset
      res=-1;
      break;
    }

    if(Black_box.fread(fname, read_offset-internal_read_offset, dst_buff, req_len)!= BB_OPERATION_OK)
    {
      Black_box.fclose(fname);
      //ошибка памяти
      res=-1;
      break;
    }

    *readed_len=req_len;

    if(Black_box.fclose(fname) != BB_OPERATION_OK)
    {
      //ошибка памяти
      res=-1;
      break;
    }

    break;
  }
  Black_box.Release();

  if(res<0) *readed_len=0;

  return res;
}

static void _file_downloaded_signal(uint8_t conn_id, const char** fname)
{
  SERVER_manager.output_message.source =   SERVER_MANAGER;
  SERVER_manager.output_message.code =     MESSAGE_SERVER_FILE_DOWNLOADED;
  SERVER_manager.output_message.pPayload = *fname;
  SERVER_manager.Send_message(SERVER_manager.output_queue);
}

static int8_t _common_cmd_callback(uint8_t conn_id, ext_cmd_t cmd, uint8_t post_delay_in_seconds, const void* param)
{
  //нельзя вызываться из потока конфигуратора
  if(SERVER_manager.task_handle!=xTaskGetCurrentTaskHandle())
  {
    return -1;
  }

  if(cmd==TOFACTORY_CMD_TYPE)
  {
    vTaskDelay(post_delay_in_seconds*1000);
    Black_box.Grab();
    RTC_WriteBackupRegister(RTC_BKP_DR7, 0x02);
    NOR_ftl.Format_memory();
    NVIC_SystemReset();

    return 1;
  }
  else if(cmd==BBOX_CLEAR_CMD_TYPE)
  {
    LOG("%s: �ommand clean black box recv\n", SERVER_manager.name);
    vTaskDelay(post_delay_in_seconds*1000);
    Black_box.Grab();
    Black_box.Clean();
    NVIC_SystemReset();

    return 1;
  }
  else if(cmd==REBOOT_MODEM_CMD_TYPE)
  {
    LOG("%s: reboot modem сommand recv, change apn_settings_digest\n", SERVER_manager.name);
    apn_settings_digest++;//изменение этого параметра приведет к перезагрузке менеджера при переодической проверке apn
    return 1;
  }
  else if(cmd==REBOOT_GNSS_CMD_TYPE)
  {
    SERVER_manager.output_message.source =   SERVER_MANAGER;
    SERVER_manager.output_message.code =     MESSAGE_SERVER_REBOOT_GNSS;
    SERVER_manager.output_message.pPayload = NULL;
    SERVER_manager.Send_message(SERVER_manager.output_queue);
    return 1;
  }
  else if(cmd==REBOOT_CMD_TYPE)
  {
    LOG("%s: reboot сommand recv\n", SERVER_manager.name);
    vTaskDelay(post_delay_in_seconds*1000);//задержка если нужна
    Black_box.Grab();
    NVIC_SystemReset();

    return 1;
  }
  else if(cmd==MAKE_PHOTO_CMD_TYPE)
  {
#if defined(CAMERA_PRESENT)
    SERVER_manager.output_message.source =   SERVER_MANAGER;
    SERVER_manager.output_message.code =     MESSAGE_SERVER_TAKE_PHOTO;
    SERVER_manager.output_message.pPayload = NULL;
    SERVER_manager.Send_message(SERVER_manager.output_queue);
    return 1;
#else
    return -1;
#endif
  }
  else if(cmd==SET_OUT_STATE)
  {
    ext_cmd_set_out_param_t* p=(ext_cmd_set_out_param_t*)param;

    if(p->pin>0 && p->pin<=MAX_DIGITAL_OUTPUTS && p->state<=1)
    {
      LOG("%s: Setting digital_out_%hhu %hhu->%hhu\n", SERVER_manager.name, p->pin, System.signal_state.digital_output[p->pin-1], p->state);

      System.signal_state.digital_output[p->pin-1]=p->state;

      return 1;
    }
    else
    {
      return -1;
    }
  }
  else if(cmd==SET_EXT_OUT_STATE)
  {
#if defined(BR_PRESENT)
    ext_cmd_set_out_param_t* p=(ext_cmd_set_out_param_t*)param;

    if(p->pin>0 && p->pin<=MAX_EXT_DIGITAL_OUTPUTS && p->state<=1)
    {
      LOG("%s: Setingt ex_dig_out_%hhu %hhu->%hhu\n", SERVER_manager.name, p->pin, System.signal_state.ext_digital_output[p->pin-1], p->state);

      System.signal_state.ext_digital_output[p->pin-1]=p->state;

      return 1;
    }
    else
    {
      return -1;
    }
#else
    return -1;
#endif
  }
  else if(cmd==SERVER_CFG_INFO)
  {
    char* s=(char*)param;

    for(uint8_t i=0, offset=0; i<SERVER_TCP_CNT; i++)
    {
      int s_len=sprintf(s+offset,
        "server%hhu: %s&%s&%hu&%lu%s", \
          i+1, local_settings[i].addr, prot_type_name[local_settings[i].prot_type], local_settings[i].connection_periodM, local_settings[i].user_terminal_addr, (i>=SERVER_TCP_CNT-1)?(""):("\n"));
      if(s_len<0) return -1;
      offset+=s_len;
    }
    return 1;
  }
  else if(cmd==CAN_CONTROL_CMD_TYPE || cmd==CAN_CONTROL_CMD_W_UUID_TYPE)
  {
#if defined(CANPRO_PRESENT)
    SERVER_manager.output_message.source =   SERVER_MANAGER;
    SERVER_manager.output_message.code =     MESSAGE_SERVER_CAN_CONTROL;

    memset(&SERVER_manager.output_message.ext_args, 0, sizeof(SERVER_manager.output_message.ext_args));

    //сюда пишем uuid
    if(cmd==CAN_CONTROL_CMD_W_UUID_TYPE)
    {
      SERVER_manager.output_message.command_uid = *(uint32_t*)((uint8_t*)param+1);
      SERVER_manager.output_message.source_id   = *(uint8_t*)((uint8_t*)param+5);
    }
    else
    {
      SERVER_manager.output_message.command_uid = 0x00;
      SERVER_manager.output_message.source_id   = 0xff;
    }

    switch(*(uint8_t*)param)
    {
    case BLINKER_FLASHING_CAN_COMMAND:              {SERVER_manager.output_message.subcode=CAN_BLINKER_FLASHING_SUBCODE; break;}
    case HORN_SIGNALING_CAN_COMMAND:                {SERVER_manager.output_message.subcode=CAN_HORN_SIGNALING_SUBCODE; break;}
    case HORN_W_BLINKER_SIGNALIG_CAN_COMMAND:       {SERVER_manager.output_message.subcode=CAN_HORN_W_BLINKER_SIGNALIG_SUBCODE; break;}
    case WINDOWS_CLOSING_1S_CAN_COMMAND:            {SERVER_manager.output_message.subcode=CAN_WINDOWS_CLOSING_1S_SUBCODE; break;}
    case WINDOWS_CLOSING_3S_CAN_COMMAND:            {SERVER_manager.output_message.subcode=CAN_WINDOWS_CLOSING_3S_SUBCODE; break;}
    case WINDOWS_CLOSING_5S_CAN_COMMAND:            {SERVER_manager.output_message.subcode=CAN_WINDOWS_CLOSING_5S_SUBCODE; break;}
    case WINDOWS_CLOSING_7S_CAN_COMMAND:            {SERVER_manager.output_message.subcode=CAN_WINDOWS_CLOSING_7S_SUBCODE; break;}
    case WINDOWS_CLOSING_9S_CAN_COMMAND:            {SERVER_manager.output_message.subcode=CAN_WINDOWS_CLOSING_9S_SUBCODE; break;}
    case WINDOWS_CLOSING_11S_CAN_COMMAND:           {SERVER_manager.output_message.subcode=CAN_WINDOWS_CLOSING_11S_SUBCODE; break;}
    case WINDOWS_CLOSING_13S_CAN_COMMAND:           {SERVER_manager.output_message.subcode=CAN_WINDOWS_CLOSING_13S_SUBCODE; break;}
    case WINDOWS_CLOSING_15S_CAN_COMMAND:           {SERVER_manager.output_message.subcode=CAN_WINDOWS_CLOSING_15S_SUBCODE; break;}
    case WINDOWS_CLOSING_17S_CAN_COMMAND:           {SERVER_manager.output_message.subcode=CAN_WINDOWS_CLOSING_17S_SUBCODE; break;}
    case WINDOWS_CLOSING_19S_CAN_COMMAND:           {SERVER_manager.output_message.subcode=CAN_WINDOWS_CLOSING_19S_SUBCODE; break;}
    case WINDOWS_CLOSING_21S_CAN_COMMAND:           {SERVER_manager.output_message.subcode=CAN_WINDOWS_CLOSING_21S_SUBCODE; break;}
    case WINDOWS_CLOSING_23S_CAN_COMMAND:           {SERVER_manager.output_message.subcode=CAN_WINDOWS_CLOSING_23S_SUBCODE; break;}
    case WINDOWS_CLOSING_25S_CAN_COMMAND:           {SERVER_manager.output_message.subcode=CAN_WINDOWS_CLOSING_25S_SUBCODE; break;}
    case WINDOWS_CLOSING_27S_CAN_COMMAND:           {SERVER_manager.output_message.subcode=CAN_WINDOWS_CLOSING_27S_SUBCODE; break;}
    case WINDOWS_CLOSING_29S_CAN_COMMAND:           {SERVER_manager.output_message.subcode=CAN_WINDOWS_CLOSING_29S_SUBCODE; break;}
    case WINDOWS_OPENING_1S_CAN_COMMAND:            {SERVER_manager.output_message.subcode=CAN_WINDOWS_OPENING_1S_SUBCODE; break;}
    case WINDOWS_OPENING_3S_CAN_COMMAND:            {SERVER_manager.output_message.subcode=CAN_WINDOWS_OPENING_3S_SUBCODE; break;}
    case WINDOWS_OPENING_5S_CAN_COMMAND:            {SERVER_manager.output_message.subcode=CAN_WINDOWS_OPENING_5S_SUBCODE; break;}
    case WINDOWS_OPENING_7S_CAN_COMMAND:            {SERVER_manager.output_message.subcode=CAN_WINDOWS_OPENING_7S_SUBCODE; break;}
    case WINDOWS_OPENING_9S_CAN_COMMAND:            {SERVER_manager.output_message.subcode=CAN_WINDOWS_OPENING_9S_SUBCODE; break;}
    case WINDOWS_OPENING_11S_CAN_COMMAND:           {SERVER_manager.output_message.subcode=CAN_WINDOWS_OPENING_11S_SUBCODE; break;}
    case WINDOWS_OPENING_13S_CAN_COMMAND:           {SERVER_manager.output_message.subcode=CAN_WINDOWS_OPENING_13S_SUBCODE; break;}
    case WINDOWS_OPENING_15S_CAN_COMMAND:           {SERVER_manager.output_message.subcode=CAN_WINDOWS_OPENING_15S_SUBCODE; break;}
    case WINDOWS_OPENING_17S_CAN_COMMAND:           {SERVER_manager.output_message.subcode=CAN_WINDOWS_OPENING_17S_SUBCODE; break;}
    case WINDOWS_OPENING_19S_CAN_COMMAND:           {SERVER_manager.output_message.subcode=CAN_WINDOWS_OPENING_19S_SUBCODE; break;}
    case WINDOWS_OPENING_21S_CAN_COMMAND:           {SERVER_manager.output_message.subcode=CAN_WINDOWS_OPENING_21S_SUBCODE; break;}
    case WINDOWS_OPENING_23S_CAN_COMMAND:           {SERVER_manager.output_message.subcode=CAN_WINDOWS_OPENING_23S_SUBCODE; break;}
    case WINDOWS_OPENING_25S_CAN_COMMAND:           {SERVER_manager.output_message.subcode=CAN_WINDOWS_OPENING_25S_SUBCODE; break;}
    case WINDOWS_OPENING_27S_CAN_COMMAND:           {SERVER_manager.output_message.subcode=CAN_WINDOWS_OPENING_27S_SUBCODE; break;}
    case WINDOWS_OPENING_29S_CAN_COMMAND:           {SERVER_manager.output_message.subcode=CAN_WINDOWS_OPENING_29S_SUBCODE; break;}
    case ALL_DOOR_CLOSING_CAN_COMMAND:              {SERVER_manager.output_message.subcode=CAN_ALL_DOOR_CLOSING_SUBCODE; break;}
    case DRIVER_DOOR_OPENING_CAN_COMMAND:           {SERVER_manager.output_message.subcode=CAN_DRIVER_DOOR_OPENING_SUBCODE; break;}
    case ALL_DOOR_OPENING_CAN_COMMAND:              {SERVER_manager.output_message.subcode=CAN_ALL_DOOR_OPENING_SUBCODE; break;}
    case TRUNK_DOOR_OPENING_CAN_COMMAND:            {SERVER_manager.output_message.subcode=CAN_TRUNK_DOOR_OPENING_SUBCODE; break;}
    case ENGINE_STOPING_CAN_COMMAND:                {SERVER_manager.output_message.subcode=CAN_ENGINE_STOPING_SUBCODE; break;}
    case ENGINE_STARTING_CAN_COMMAND:               {SERVER_manager.output_message.subcode=CAN_ENGINE_STARTING_SUBCODE; break;}
    case EMULATION_DRIVER_DOOR_OPENING_CAN_COMMAND: {SERVER_manager.output_message.subcode=CAN_EMULATION_DRIVER_DOOR_OPENING_SUBCODE; break;}
    case WEBASTO_STOPPING_CAN_COMMAND:              {SERVER_manager.output_message.subcode=CAN_WEBASTO_STOPPING_SUBCODE; break;}
    case WEBASTO_STARTING_CAN_COMMAND:              {SERVER_manager.output_message.subcode=CAN_WEBASTO_STARTING_SUBCODE; break;}

    case YADRIVE_WARMING_COMMAND:                   {SERVER_manager.output_message.subcode=YADRIVE_WARMING_SUBCODE; const uint8_t warming_args=15; memcpy(&SERVER_manager.output_message.ext_args, &warming_args, sizeof(warming_args));  break;}
    case YADRIVE_STOP_WARMING_COMMAND:              {SERVER_manager.output_message.subcode=YADRIVE_STOP_WARMING_SUBCODE; break;}
    case YADRIVE_START_OF_LEASE_COMMAND:            {SERVER_manager.output_message.subcode=YADRIVE_START_OF_LEASE_SUBCODE; break;}
    case YADRIVE_END_OF_LEASE_COMMAND:              {SERVER_manager.output_message.subcode=YADRIVE_END_OF_LEASE_SUBCODE; break;}
    case YADRIVE_HOOD_UNLOCK_COMMAND:               {SERVER_manager.output_message.subcode=YADRIVE_HOOD_UNLOCK_SUBCODE; break;}
    case YADRIVE_HOOD_LOCK_COMMAND:                 {SERVER_manager.output_message.subcode=YADRIVE_HOOD_LOCK_SUBCODE; break;}
    case YADRIVE_FORCED_END_OF_LEASE_COMMAND:       {SERVER_manager.output_message.subcode=YADRIVE_FORCED_END_OF_LEASE_SUBCODE; break;}
    case YADRIVE_DTC_CLEAR_COMMAND:                 {SERVER_manager.output_message.subcode=YADRIVE_DTC_CLEAR_SUBCODE; break;}

    case AUXILIARY_CAR_COMMAND_W_ARG_0:             {SERVER_manager.output_message.subcode=AUXILIARY_CAR_COMMANDS_SUBCODE; SERVER_manager.output_message.ext_args=0; break;}
    case AUXILIARY_CAR_COMMAND_W_ARG_1:             {SERVER_manager.output_message.subcode=AUXILIARY_CAR_COMMANDS_SUBCODE; SERVER_manager.output_message.ext_args=1; break;}
    case AUXILIARY_CAR_COMMAND_W_ARG_2:             {SERVER_manager.output_message.subcode=AUXILIARY_CAR_COMMANDS_SUBCODE; SERVER_manager.output_message.ext_args=2; break;}
    case AUXILIARY_CAR_COMMAND_W_ARG_3:             {SERVER_manager.output_message.subcode=AUXILIARY_CAR_COMMANDS_SUBCODE; SERVER_manager.output_message.ext_args=3; break;}
    case AUXILIARY_CAR_COMMAND_W_ARG_4:             {SERVER_manager.output_message.subcode=AUXILIARY_CAR_COMMANDS_SUBCODE; SERVER_manager.output_message.ext_args=4; break;}
    case AUXILIARY_CAR_COMMAND_W_ARG_5:             {SERVER_manager.output_message.subcode=AUXILIARY_CAR_COMMANDS_SUBCODE; SERVER_manager.output_message.ext_args=5; break;}

    default:                                        {return -1;}
    }

    SERVER_manager.output_message.pPayload = NULL;
    SERVER_manager.Send_message(SERVER_manager.output_queue);
    return 1;
#else
    return -1;
#endif
  }
  else
  {
    //неизвестная команда
    return -1;
  }
}

#if defined(ITF_TRANSPORT_PRESENT)

#if defined(RS485_PRESENT)
#include "rs485_driver.h"
#endif //RS485_PRESENT

#if defined(RS232_PRESENT)
#include "rs232_driver.h"
#endif //RS232_PRESENT

#if defined(RS_UART_PRESENT)
#include "rsuart_driver.h"
#endif //RS_UART_PRESENT

uint16_t _itf_tx_rx_callback(const void* itf_header, uint8_t* tx_data, uint8_t* rx_data, uint16_t rx_len)
{
  const TVega_itf_data* itf=(const TVega_itf_data*)itf_header;

  uint16_t ret=0;

  if(itf->itf_id==0xFD)
  {
    //только из потока SERVER_manager
    if(SERVER_manager.task_handle!=xTaskGetCurrentTaskHandle()) return 0;

    fwd_modem_rx_enabele(rx_data, rx_len);
    send_data_in_fwd_mode((const char*)tx_data, itf->data_len);

    uint32_t end_timeMS_wait=itf->rs.timeout*1000+xTaskGetTickCount();

    for(;;)
    {
      ret=get_fwd_recv_len();

      if(ret>=rx_len)
      {
        break;
      }
      else if(ret && (strnstr((const char*)rx_data, "OK\r\n", ret)!=NULL ||
                      strnstr((const char*)rx_data, "ERROR\r\n", ret)!=NULL))
      {
        break;
      }
      else if(ret && strnstr((const char*)rx_data, "+CME ERROR:", ret)!=NULL)
      {
        break;
      }
      else if(timeAfter(xTaskGetTickCount(), end_timeMS_wait))
      {
        break;
      }

      vTaskDelay(10);
    }

    vTaskDelay(200);//ждем \r\n
    ret=get_fwd_recv_len();
    fwd_modem_rx_disable();

    return ret;
  }

  if(itf->rs.baudrate<1200 || itf->rs.baudrate>115200 /*|| !itf->data_len*/) return ret;

  if(false) {}
#if defined(RS232_PRESENT)
  else if(itf->itf_id==0x01)
  {
    if(RS232_Trying_Grab())
    {
      RS232_SetParam(itf->rs.baudrate, itf->rs.timeout*10, "8N1");
      ret=RS232_TxRx(tx_data, itf->data_len, rx_data, rx_len);
      RS232_Release();
    }
  }
#endif //RS232_PRESENT
#if defined(RS485_PRESENT)
  else if(itf->itf_id==0x02)
  {
    if(RS485_Trying_Grab())
    {
      RS485_SetParam(itf->rs.baudrate, itf->rs.timeout*10, "8N1");
      ret=RS485_TxRx(tx_data, itf->data_len, rx_data, rx_len);
      RS485_Release();
    }
  }
#endif //RS485_PRESENT
#if defined(RS_UART_PRESENT)
  else if(itf->itf_id==0x03)
  {
    if(RSUART_Trying_Grab())
    {
      RSUART_SetParam(itf->rs.baudrate, itf->rs.timeout*10, "8N1");
      ret=RSUART_TxRx(tx_data, itf->data_len, rx_data, rx_len);
      RSUART_Release();
    }
  }
#endif //RS_UART_PRESENT

  return ret;
}
#endif //defined(ITF_TRANSPORT_PRESENT)

#if defined(CAN_VEGA_FWD_PRESENT)
static uint8_t _is_can_fwd_enabled_callback(const uint8_t conn_id, uint32_t* const max_nack_len_for_send)
{
  if(conn_id==System.fwd_can_server_id)
  {
    if(max_nack_len_for_send!=NULL)
    {
      if(conn_id<=SERVER_LAST_TCP_CONN_ID)
      {
#if defined(__EC21_X__) || defined(__UG95__)
        max_nack_len_for_send[0]=10*1024;
#else
        max_nack_len_for_send[0]=3*1024;
#endif //defined(__EC21_X__) || defined(__UG95__)
      }
      else
      {
        max_nack_len_for_send[0]=0;
      }
    }

    return 1;
  }
  else
  {
    return 0;
  }
}
#endif //defined(CAN_VEGA_FWD_PRESENT)

#if defined(FASTDATA_PRESENT)
static uint8_t _is_fastdata_fwd_enabled_callback(const uint8_t conn_id, uint32_t* const max_nack_len_for_send)
{
#if defined(__EC21_X__) || defined(__UG95__) || defined(__A7670E__)
  if(conn_id==System.fastdata_fwd_can_server_id)
  {
    if(max_nack_len_for_send!=NULL)
    {
      if(conn_id<=SERVER_LAST_TCP_CONN_ID)
      {
        max_nack_len_for_send[0]=10*1024;
      }
      else
      {
        max_nack_len_for_send[0]=0;
      }
    }

    return 1;
  }
  else
  {
    return 0;
  }
#else
  return 0;
#endif //defined(__EC21_X__) || defined(__UG95__) || defined(__A7670E__)
}
#endif //defined(FASTDATA_PRESENT)

static const char* _get_device_imei(void)
{
  return System.server_state.IMEI;//не атомарный доступ, если вызвывается не из потока server_man
}

#if defined(CHANGE_SIM_BY_NO_VALID_VEGA_PACKET_PRESENT)
static uint32_t last_valid_vega_packet_timeS;

static const uint8_t MAIN_YANDEX_SERVER_ID=SERVER_TCP_3_CONN_ID;

static void _got_valid_vega_packet(const uint8_t conn_id, const void* packet)
{
  if(USE_NEW_CHANGE_SIM_BY_NO_VALID_VEGA_PACKET)
  {
    const TVega_message* header=(const TVega_message*)packet;

    if(conn_id==MAIN_YANDEX_SERVER_ID &&
       (header->type==BBOX_MESSAGES_ANS ||
        header->type==FILE_WHOLLY ||
        header->type==GET_FILE ||
        header->type==FILE_CHUNK)
       )
    {
      last_valid_vega_packet_timeS=GetSecondsFromStartup();
    }

    return;
  }
  else
  {
    if(conn_id<=SERVER_LAST_TCP_CONN_ID)
    {
      last_valid_vega_packet_timeS=GetSecondsFromStartup();
    }
  }
}
#endif //defined(CHANGE_SIM_BY_NO_VALID_VEGA_PACKET_PRESENT)

static const common_prot_const_t protocols_common_const =
{
  .get_device_imei=_get_device_imei,
  .get_unix_time=_get_unix_time,
  .socket_write=_socket_write,
  .socket_read=_socket_read,
  .socket_open=_socket_open,
  .socket_state=_socket_state,
  .socket_close=_socket_close,
  .socket_get_nack_len=_socket_get_nack_len,
  .grab_mess=_grab_mess,
  .release_mess=_release_mess,
  .get_mess_count=_get_mess_count,
  .read_message=_read_message,
  .delete_messages=_delete_messages,
  .get_message_param_name_type=_get_message_param_name_type,
  //.find_ad_sens_in_bbox_mess=_find_ad_sens_in_bbox_mess,
  .photo_inf=_photo_inf,
  .photo_read_chunk=_photo_read_chunk,
  .photo_delete=_photo_delete,
  .file_write_chunk=_file_write_chunk,
  .file_downloaded_signal=_file_downloaded_signal,
  .file_clean=_file_clean,
  .file_read_chunk=_file_read_chunk,
  .common_cmd_callback=_common_cmd_callback,
#if defined(ITF_TRANSPORT_PRESENT)
  .itf_tx_rx_callback=_itf_tx_rx_callback,
#endif //defined(ITF_TRANSPORT_PRESENT)
#if defined(CAN_VEGA_FWD_PRESENT)
  .is_can_fwd_enabled_callback=_is_can_fwd_enabled_callback,
#endif //defined(CAN_VEGA_FWD_PRESENT)
#if defined(FASTDATA_PRESENT)
  .is_fastdata_fwd_enabled_callback=_is_fastdata_fwd_enabled_callback,
#endif //defined(FASTDATA_PRESENT)
#if defined(CHANGE_SIM_BY_NO_VALID_VEGA_PACKET_PRESENT)
  .got_valid_vega_packet=_got_valid_vega_packet,
#endif //defined(CHANGE_SIM_BY_NO_VALID_VEGA_PACKET_PRESENT)
};

const common_prot_const_t* get_protocols_common_const_pointer(void)
{
  return &protocols_common_const;
}

#if defined(USE_QUECTEL_MODEM_LIB) || defined(USE_SIMCOM_MODEM_LIB)
void tcp_socket_new_data_recv(uint8_t ctx)
{
  if(0==uxQueueMessagesWaiting(SERVER_manager.input_queue))
  {
    static const T_system_message new_rx_data_message =
    {
      .source=SERVER_MANAGER,
      .code=MESSAGE_SERVER_RECV_DATA,
      .subcode=0,
      .pPayload=NULL,
      .payload_size=0,
      .pAnswer=NULL,
      .answer_size=0,
      .source_id=0,
#if (DEVICE_TYPE == DEVICE_TYPE_VEGA_MT_25K || DEVICE_TYPE == DEVICE_TYPE_VEGA_MT_32K_LTE || DEVICE_TYPE == DEVICE_TYPE_VEGA_MT_32K_LTE_V2 || DEVICE_TYPE == DEVICE_TYPE_VEGA_MT_32K_LTE_V3)
      .command_uid=0,
      .ext_args=0,
#endif //(DEVICE_TYPE == DEVICE_TYPE_VEGA_MT_25K || DEVICE_TYPE == DEVICE_TYPE_VEGA_MT_32K_LTE || DEVICE_TYPE == DEVICE_TYPE_VEGA_MT_32K_LTE_V2 || DEVICE_TYPE == DEVICE_TYPE_VEGA_MT_32K_LTE_V3)
    };

    xQueueSend(SERVER_manager.input_queue, &new_rx_data_message, 0);
  }
}

void force_wakeup_if_sleep(void)
{
#if defined(MODEM_PSAVE_PRESENT)
  if(__MODEM_DTR_PIN_IS_SLEEP())
  {
    tcp_socket_new_data_recv(0xFF);
  }
#endif //defined(MODEM_PSAVE_PRESENT)
}

#endif //defined(USE_QUECTEL_MODEM_LIB) || defined(USE_SIMCOM_MODEM_LIB)

void dtmf_recv_callback(char val)
{
  //none
}

static uint8_t need_save_backup_settings=0;

void need_update_backup_settings_file(void)
{
  need_save_backup_settings=1;
}

#if defined(BACKUP_SETTINGS_TO_MODEM_MEMORY_PRESENT)
static bool load_settings_from_backup(const char* fname, const char** verbose)
{
  uint32_t fsize;
  uint32_t fctx;
  uint32_t crc;

  if(verbose!=NULL) *verbose="";

  if(GSM_RES_OK!=m_fs_init())
  {
    if(verbose!=NULL) *verbose="m_fs_init";
    return false;
  }

  if(GSM_RES_OK!=m_fsize(fname, &fsize, (char*)common_tx_mem, sizeof(common_tx_mem)))
  {
    if(verbose!=NULL) *verbose="no file";
    return false;
  }

  if(fsize<=sizeof(TSetting_header)+sizeof(crc))
  {
    if(verbose!=NULL) *verbose="file size err";
    return false;
  }

  fsize-=sizeof(crc);

  if(GSM_RES_OK!=m_fopen(fname, &fctx, 0))
  {
    if(verbose!=NULL) *verbose="m_fopen err";
    return false;
  }

  if(GSM_RES_OK!=m_fseek(fctx, 0))
  {
    if(verbose!=NULL) *verbose="m_fseek err";
    if(GSM_RES_OK!=m_fclose(fctx)) {vTaskDelay(200); m_fclose(fctx);}
    return false;
  }

  crc32_fast_init(&crc);

  for(uint32_t offset=0; fsize>offset;)
  {
    int16_t rlen=m_fread(fctx, common_tx_mem, (fsize-offset>sizeof(common_tx_mem))?(sizeof(common_tx_mem)):(fsize-offset));
    if(rlen<0)
    {
      if(verbose!=NULL) *verbose="m_fread err";
      if(GSM_RES_OK!=m_fclose(fctx)) {vTaskDelay(200); m_fclose(fctx);}
      return false;
    }
    else
    {
      crc32_fast_update(&crc, common_tx_mem, rlen);
    }
    offset+=rlen;
  }

  uint32_t file_crc;
  if(sizeof(file_crc)!=m_fread(fctx, (uint8_t*)&file_crc, sizeof(file_crc)))
  {
    if(verbose!=NULL) *verbose="m_fread err";
    if(GSM_RES_OK!=m_fclose(fctx)) {vTaskDelay(200); m_fclose(fctx);}
    return false;
  }

  crc32_fast_finish(&crc);
  if(crc!=file_crc)
  {
    if(verbose!=NULL) *verbose="file crc err";
    if(GSM_RES_OK!=m_fclose(fctx)) {vTaskDelay(200); m_fclose(fctx);}
    return false;
  }

  if(GSM_RES_OK!=m_fseek(fctx, 0))
  {
    if(verbose!=NULL) *verbose="m_fseek err";
    if(GSM_RES_OK!=m_fclose(fctx)) {vTaskDelay(200); m_fclose(fctx);}
    return false;
  }

  crc32_fast_init(&crc);

  for(uint32_t offset=0; fsize>offset;)
  {
    int16_t rlen=m_fread(fctx, common_tx_mem, (fsize-offset>sizeof(common_tx_mem))?(sizeof(common_tx_mem)):(fsize-offset));
    if(rlen<0)
    {
      if(verbose!=NULL) *verbose="m_fread err";
      if(GSM_RES_OK!=m_fclose(fctx)) {vTaskDelay(200); m_fclose(fctx);}
      return false;
    }
    else
    {
      for(uint16_t parsed_len=0; rlen>parsed_len;)
      {
        TSetting_header header;
        bool is_enable_correct_rlen=false;

        if((rlen-parsed_len)>=sizeof(header))
        {
          memcpy(&header, &common_tx_mem[parsed_len], sizeof(header));

          if(header.size>sizeof(common_tx_mem))
          {
            LOG("%s: Error setting %d too big to parse\n", SERVER_manager.name, header.id);

            //crc не считаем, т.к. можем вылететь неизвестно куда
            parsed_len+=(sizeof(header)+header.size);
            break;
          }

          if((rlen-parsed_len)>=(sizeof(header)+header.size))
          {
            uint8_t *ptr;
            uint16_t setting_size=System.Find_setting(header.id, header.subid, &ptr);

            //
            crc32_fast_update(&crc, &common_tx_mem[parsed_len], sizeof(header)+header.size);

            if(!System.Is_setting_id(header.id))
            {
              //это вообще не настройка, Петя гандон
              parsed_len+=(sizeof(header)+header.size);

              continue;
            }

            if(setting_size && setting_size>header.size)
            {
              memset(ptr, 0, setting_size);
              __PRINTF("%s: Warning, setting %d recv size: %d, while real_size is: %d\n", SERVER_manager.name, header.id, header.size, setting_size);
            }
            else if(!setting_size || setting_size<header.size)
            {
              if(setting_size == 0) {__PRINTF("%s: Setting id %d subid %d not found\n", SERVER_manager.name, header.id, header.subid);}
              else                  {__PRINTF("%s: Error setting %d recv size: %d, while real_size is: %d\n", SERVER_manager.name, header.id, header.size, setting_size);}
              parsed_len+=(sizeof(header)+header.size);

              continue;
            }

            System.Grab(portMAX_DELAY);
            memcpy(ptr, &common_tx_mem[parsed_len+sizeof(header)], header.size);

            //если настройка строковая, то добавляем нуль (защита от передачи не нультерминированных настроек)
            //если настройка в виде структуры, то приходится делать приведение
            if(header.id==VEGA_SETTING_APN)
            {
              TGSM_APN* cfg=(TGSM_APN*)ptr;
              cfg->APN[sizeof(cfg->APN)-1]='\0';
              cfg->user[sizeof(cfg->user)-1]='\0';
              cfg->password[sizeof(cfg->password)-1]='\0';
            }
            else if(header.id==VEGA_SETTING_SERVER_ADDR)
            {
              TGSM_server* cfg=(TGSM_server*)ptr;
              cfg->address[sizeof(cfg->address)-1]='\0';
            }
            //если одиночные строковые настройки
            else if(header.id==VEGA_SETTING_SERVER_PIN || header.id==VEGA_SETTING_PIN_CODE)
            {
              ptr[setting_size-1]='\0';
            }
            else
            {
              Shadow_settings_manage(&header, ptr);
            }
            System.Release();

            parsed_len+=(sizeof(header)+header.size);
          }
          else
          {
            is_enable_correct_rlen=true;
          }
        }
        else
        {
          is_enable_correct_rlen=true;
        }

        if(is_enable_correct_rlen)
        {
          rlen-=rlen-parsed_len;
          if(GSM_RES_OK!=m_fseek(fctx, offset+rlen))
          {
            if(verbose!=NULL) *verbose="m_fseek err";
            if(GSM_RES_OK!=m_fclose(fctx)) {vTaskDelay(200); m_fclose(fctx);}
            return false;
          }
        }
      }
    }
    offset+=rlen;
  }

  if(sizeof(file_crc)!=m_fread(fctx, (uint8_t*)&file_crc, sizeof(file_crc)))
  {
    LOG("%s: %s\n", SERVER_manager.name, "crc m_fread err after parse");
  }

  crc32_fast_finish(&crc);
  if(crc!=file_crc)
  {
    LOG("%s: %s\n", SERVER_manager.name, "file crc err after parse");
  }

  if(GSM_RES_OK!=m_fclose(fctx)) {vTaskDelay(200); m_fclose(fctx);}

  if(verbose!=NULL) *verbose="done";
  return true;
}

static bool save_settings_to_backup(const char* fname, const char** verbose)
{
  TSetting_header header;
  uint8_t *setting_ptr;
  uint16_t idx=0;
  uint16_t offset=0;
  uint32_t crc;
  uint32_t fctx;

  if(GSM_RES_OK!=m_fs_init())
  {
    if(verbose!=NULL) *verbose="m_fs_init err";
    return false;
  }

  if(GSM_RES_OK!=m_fopen(fname, &fctx, 1))
  {
    if(verbose!=NULL) *verbose="m_fopen err";
    return false;
  }

  if(GSM_RES_OK!=m_fseek(fctx, 0))
  {
    if(verbose!=NULL) *verbose="m_fseek err";
    if(GSM_RES_OK!=m_fclose(fctx)) {vTaskDelay(200); m_fclose(fctx);}
    return false;
  }

  crc32_fast_init(&crc);

  System.Grab(portMAX_DELAY);
  while(header.size=System.Get_setting(idx, &header.id, &header.subid, &setting_ptr))
  {
#if IWDG_ENABLE > 0
    IWDG_ReloadCounter();
#endif //IWDG_ENABLE > 0
    if((header.size+sizeof(header))>(sizeof(common_tx_mem)-offset))
    {
      if(offset!=m_fwrite(fctx, common_tx_mem, offset))
      {
        System.Release();
        if(verbose!=NULL) *verbose="m_fwrite err";
        if(GSM_RES_OK!=m_fclose(fctx)) {vTaskDelay(200); m_fclose(fctx);}
        return false;
      }

      crc32_fast_update(&crc, common_tx_mem, offset);

      offset = 0;
    }

    memcpy(common_tx_mem+offset, (uint8_t*)&header, sizeof(header));
    offset+=sizeof(header);
    memcpy(common_tx_mem + offset, setting_ptr, header.size);
    offset+=header.size;
    idx++;

    // Если на следующем круге настройки кончатся, дописываем что есть
    if(!System.Get_setting(idx, &header.id, &header.subid, &setting_ptr))
    {
#if IWDG_ENABLE > 0
      IWDG_ReloadCounter();
#endif //IWDG_ENABLE > 0
      if(offset!=m_fwrite(fctx, common_tx_mem, offset))
      {
        System.Release();
        if(verbose!=NULL) *verbose="m_fwrite err";
        if(GSM_RES_OK!=m_fclose(fctx)) {vTaskDelay(200); m_fclose(fctx);}
        return false;
      }
      crc32_fast_update(&crc, common_tx_mem, offset);
      crc32_fast_finish(&crc);
      if(sizeof(crc)!=m_fwrite(fctx, (uint8_t*)&crc, sizeof(crc)))
      {
        System.Release();
        if(verbose!=NULL) *verbose="m_fwrite err";
        if(GSM_RES_OK!=m_fclose(fctx)) {vTaskDelay(200); m_fclose(fctx);}
        return false;
      }
      offset = 0;
    }
  }
  System.Release();

  if(GSM_RES_OK!=m_fclose(fctx)) {vTaskDelay(200); m_fclose(fctx);}

  if(verbose!=NULL) *verbose="done";
  return true;
}

static bool delete_settings_from_backup(const char* fname, const char** verbose)
{
  if(verbose!=NULL) *verbose="";

  if(GSM_RES_OK!=m_fs_init())
  {
    if(verbose!=NULL) *verbose="m_fs_init";
    return false;
  }

  uint32_t fsize;
  if(GSM_RES_OK!=m_fsize(fname, &fsize, (char*)common_tx_mem, sizeof(common_tx_mem)))
  {
    if(verbose!=NULL) *verbose="no file";
    return false;
  }

  if(GSM_RES_OK!=m_fdelete(fname))
  {
    if(verbose!=NULL) *verbose="m_fdelete err";
    return false;
  }

  if(verbose!=NULL) *verbose="done";
  return true;
}
#endif //defined(BACKUP_SETTINGS_TO_MODEM_MEMORY_PRESENT)

void CSERVER_manager::Backup_settings_handler(void)
{
#if defined(BACKUP_SETTINGS_TO_MODEM_MEMORY_PRESENT)
  const char* verbose;
  const char* fname="BACKPUP_SETTINGS"; //не исправлять название!

  if(RTC_ReadBackupRegister(RTC_BKP_DR8))
  {
    if(RTC_ReadBackupRegister(RTC_BKP_DR8)==0x01)
    {
      //выставлен признак самопроизвольного сброса настроек, востанавливаем его из файла (если он есть)
      LOG("%s: start load backup settings...\n", this->name);
      if(load_settings_from_backup(fname, &verbose))
      {
        this->output_message.source = SERVER_MANAGER;
        this->output_message.code =   MESSAGE_SERVER_SAVE_BASE;
        this->output_message.subcode = 0;//без последующего сохранения в backup
        this->Send_message(this->output_queue);
      }
      LOG("%s: load backup settings: %s\n", this->name, verbose);
    }
    else
    {
      //удаляем backup файл, если это сброс по команде
      delete_settings_from_backup(fname, &verbose);
      LOG("%s: delete backup settings: %s\n", this->name, verbose);
    }
    RTC_WriteBackupRegister(RTC_BKP_DR8, 0x00);
  }
  else if(need_save_backup_settings)
  {
    //если нужно обновить backup
    need_save_backup_settings=0;
    LOG("%s: start save backup settings...\n", this->name);
    save_settings_to_backup(fname, &verbose);
    LOG("%s: save backup settings: %s\n", this->name, verbose);
  }
#else
  const char* verbose="not support";

  if(RTC_ReadBackupRegister(RTC_BKP_DR8))
  {
    if(RTC_ReadBackupRegister(RTC_BKP_DR8)==0x01)
    {
      LOG("%s: load backup settings: %s\n", this->name, verbose);
    }
    else
    {
      //удаляем backup файл, если это сброс по команде
      LOG("%s: delete backup settings: %s\n", this->name, verbose);
    }
    RTC_WriteBackupRegister(RTC_BKP_DR8, 0x00);
  }
  else if(need_save_backup_settings)
  {
    //если нужно обновить backup
    need_save_backup_settings=0;
    LOG("%s: save backup settings: %s\n", this->name, verbose);
  }
#endif //defined(BACKUP_SETTINGS_TO_MODEM_MEMORY_PRESENT)
}

static uint8_t wait_staus_pin(uint8_t desire_state, uint16_t timeout)
{
#if defined(USE_SIMCOM_MODEM_LIB) && defined(__A7670E__)
  static const uint8_t DELAY = 100;

  timeout = timeout/DELAY;
  if(!timeout) timeout++;

  uint8_t is_ok = 0;

  for(uint16_t i = 0; i < timeout; i++)
  {
    uint8_t curr_state = __GET_SIMCOM_STATUS_PIN_STATE();

    if((desire_state && curr_state) ||
       (!desire_state && !curr_state))
    {
       is_ok = 1;
       break;
    }

    vTaskDelay(DELAY);
  }

  return is_ok;
#else
  return desire_state;
#endif //defined(USE_SIMCOM_MODEM_LIB) && defined(__A7670E__)
}

/* C++ code-------------------------------------------------------------------*/
// Конструктор SERVER-менеджера
CSERVER_manager::CSERVER_manager(const char* mngr_name, QueueHandle_t* output_queue, uint8_t input_queue_size, uint8_t priority, TaskFunction_t task_starter, uint16_t stack_size):
  CManager(mngr_name, output_queue, input_queue_size, priority, task_starter, stack_size)
  {

#if defined(USE_SIMCOM_MODEM_LIB)
    this->bt_initialized=0;
#endif //USE_SIMCOM_MODEM_LIB

    this->name = mngr_name;
    this->modem_initialized=0;
    this->sleep_cmd=0;
    this->force_wakeup=0;
    this->is_man_reinit=0;
    this->is_start_after_power_on=1;
    this->answer_queue=NULL;

    this->current_sim_id=0;
#if MAX_SIM_COUNT > 1
    this->current_sim_id=MAIN_SIM_ID;
    this->desired_sim_id=this->current_sim_id;
#endif //MAX_SIM_COUNT > 1

#if defined(USE_EVA_AGPS)
    this->last_agps_download_time=0;
#endif //USE_EVA_AGPS

    System.server_state.is_on=0;
    System.server_state.usb_connected=0;

    SERVER_manager.configurator_task_sleep_state=2;
    SERVER_manager.configurator_task_wakeup_cmd=0;

    for(uint8_t i=0; i<SERVER_TCP_CNT; i++)
    {
      System.server_state.tcp_connect_state[i]=0;
    }

    init_server_notifies();

    SERVER_manager.yandex_force_block_timerS=0;
  }

  bool CSERVER_manager::Is_bt_connected(void)
  {
#if defined(BT3_PRESENT)
    //���� � ������ ������ ��������� bt ������������
    if(System.server_state.is_on && bt_ctx.protocol_type==VEGA_PROTOCOL_TYPE && (bt_ctx.server_ctx_state==DO_AUTORIZATION || bt_ctx.server_ctx_state==CONTINUE_COMMUNICATION))
    {
      return true;
    }
    else
    {
      return false;
    }
#else
    return false;
#endif //defined(BT3_PRESENT)
  }

  bool CSERVER_manager::Psave_handler(bool sleep_enable, const uint16_t no_sleep_max_wait_message, const bool is_conn_ctx_initialized)
  {
#if defined(MODEM_PSAVE_PRESENT)
#if !((defined(USE_SIMCOM_MODEM_LIB) && (defined(__SIM800__) || defined(__SIM800_DS__) || defined(__A7670E__))) || \
     (defined(USE_QUECTEL_MODEM_LIB) && (defined(__MC60__) || (defined(__EC21_X__)))))
#error //not suppoort yet
#endif //!((defined(USE_SIMCOM_MODEM_LIB) && (defined(__SIM800__) || defined(__SIM800_DS__) || defined(__A7670E__))) || \
          (defined(USE_QUECTEL_MODEM_LIB) && (defined(__MC60__) || (defined(__EC21_X__)))))

#if !defined(MODEM_DTR_PORT)
#error MODEM_DTR_PORT undefined
#endif //!defined(MODEM_DTR_PORT)

    if(sleep_enable && psave_enabled && System.gsm_psave_settings.use_psave)
    {
      bool message_recived = 0;

      __MODEM_DTR_PIN_HI(); //sleep
      for(uint8_t i = 0; i < 20; i++)
      {
        message_recived = this->Wait_message(900);
        if(message_recived) {break;}

        if(is_conn_ctx_initialized)
        {
          uint8_t force_wake = 0;
          for(uint8_t j = 0; j < SERVER_TCP_CNT; j++)
          {
            if(force_wake = server_conn_check_if_need_wakeup(&conn_ctx[j]))
            {
              __PRINTF("%s: wake event from %s\n", this->name, conn_ctx[j].server_ctx_name);
              break;
            }
          }
          if(force_wake) {break;}
        }

        if(System.server_state.serving_cell.RegStat == REGISTERED_FROM_HOME_OPERATOR_CREG_STATUS ||
           System.server_state.serving_cell.RegStat == REGISTERED_FROM_FOREING_OPERATOR_CREG_STATUS)
        {
          //����...
          LedG_On(); vTaskDelay(50);
          LedG_Off();
        }
        else
        {
          //���� ����...
          LedG_On();  vTaskDelay(50);
          LedG_Off(); vTaskDelay(50);
          LedG_On();  vTaskDelay(50);
          LedG_Off();
        }
      }
      __MODEM_DTR_PIN_LOW();//wakeup
      vTaskDelay(50);
      for(uint8_t i = 0; i < 10; i++)
      {
        if(GSM_RES_OK == send_simple_at("AT\r", 10))
        {
          break;
        }
      }

      return message_recived;
    }
    else
    {
      return this->Wait_message(no_sleep_max_wait_message);
    }
#else
    return this->Wait_message(no_sleep_max_wait_message);
#endif //defined(MODEM_PSAVE_PRESENT)
  }

  // Основной цикл
  void CSERVER_manager::Main_cycle(void)
  {
#if MAX_SIM_COUNT > 1
    this->last_network_view_time_MS=xTaskGetTickCount();
#endif //MAX_SIM_COUNT > 1

    if(this->sleep_cmd)
    {
      __PRINTF("%s: goto sleep\n", this->name);
      return;
    }

    uint32_t  end_wait_time_MS;

    end_wait_time_MS=40*1000-1+xTaskGetTickCount();

    uint32_t next_voice_call_poll_timeMS=1000+xTaskGetTickCount();

#if defined(MODEM_PSAVE_PRESENT)
    if(true)
    {
      int16_t at_res;

      for(uint8_t att = 0; att < MAX_SEND_AT_ATTEMPT; att++)
      {
        at_res = modem_psave_mode_cfg(1);
        if(GSM_RES_OK == at_res) {break;}
        if(att != MAX_SEND_AT_ATTEMPT - 1) {vTaskDelay(1000*(att+1));}
      }

      if(GSM_RES_OK == at_res)
      {
        LOG("%s: modem psave enabled ok\n", this->name);
        psave_enabled = 1;
      }
      else
      {
        LOG("%s: modem psave enabled err\n", this->name);
        psave_enabled = 0;
      }
    }
#else
    //modem_psave_mode_cfg(0);
#endif //defined(MODEM_PSAVE_PRESENT)

    //���� ����������� � ����
    for(;;)
    {
      creg_state_t creg_gsm;

#if defined(__SIM800_DS__) && (MAX_SIM_COUNT > 1)
      //оправшиваем форсированно
      if(this->current_sim_id==0)    get_ds_creg_state(&creg_gsm, NULL, 1);
      else                           get_ds_creg_state(NULL, &creg_gsm, 1);
#else
      get_creg_state(&creg_gsm, 1);//оправшиваем форсированно
#endif //__SIM800_DS__ && (MAX_SIM_COUNT > 1)

      if(System.server_state.serving_cell.CELLID!=creg_gsm.netCellId || System.server_state.serving_cell.AcT!=creg_gsm.AcT || System.server_state.serving_cell.LAC!=creg_gsm.netLac || System.server_state.serving_cell.RegStat!=creg_gsm.regStatus)
      {
        operator_inf_t operator_inf;
        get_operator_inf(&operator_inf);

        if(System.server_state.serving_cell.RegStat!=creg_gsm.regStatus)
        {
          LOG("%s: Reg status changed: %s -> %s\n", this->name, get_reg_status_verbose(System.server_state.serving_cell.RegStat), get_reg_status_verbose(creg_gsm.regStatus));
        }

        if(System.server_state.serving_cell.AcT!=creg_gsm.AcT)
        {
          LOG("%s: AcT changed: %s -> %s\n", this->name, get_act_verbose(System.server_state.serving_cell.AcT), get_act_verbose(creg_gsm.AcT));
        }

        if(System.server_state.serving_cell.MCC!=operator_inf.mcc || System.server_state.serving_cell.MNC!=operator_inf.mnc)
        {
          LOG("%s: Mobile codes changed: MCC=%hhu, MNC=%hhu\n", this->name, operator_inf.mcc, operator_inf.mnc);
        }

        System.Grab(portMAX_DELAY);
        System.server_state.serving_cell.CELLID=creg_gsm.netCellId;
        System.server_state.serving_cell.AcT=creg_gsm.AcT;
        System.server_state.serving_cell.LAC=creg_gsm.netLac;
        System.server_state.serving_cell.RegStat=creg_gsm.regStatus;
        System.server_state.serving_cell.MCC=operator_inf.mcc;
        System.server_state.serving_cell.MNC=operator_inf.mnc;
        System.Release();

        __PRINTF("%s: mcc=%hhu, mnc=%hhu, lac=%hX, cell_id=%lX, reg=%hhu\n", this->name, System.server_state.serving_cell.MCC, System.server_state.serving_cell.MNC, System.server_state.serving_cell.LAC, System.server_state.serving_cell.CELLID, System.server_state.serving_cell.RegStat);
      }

      if(System.server_state.serving_cell.RegStat==REGISTRATION_DENIED_CREG_STATUS || /*System.server_state.serving_cell.RegStat==NOT_REGISTERED_ME_NOT_SEARCHING_OPERATOR_CREG_STATUS || */\
        System.server_state.serving_cell.RegStat==REGISTERED_FROM_HOME_OPERATOR_CREG_STATUS || System.server_state.serving_cell.RegStat==REGISTERED_FROM_FOREING_OPERATOR_CREG_STATUS)
      {
#if MAX_SIM_COUNT > 1
        this->last_network_view_time_MS=xTaskGetTickCount();
#endif //MAX_SIM_COUNT > 1
        if(System.server_state.serving_cell.RegStat==REGISTRATION_DENIED_CREG_STATUS || System.server_state.serving_cell.RegStat==NOT_REGISTERED_ME_NOT_SEARCHING_OPERATOR_CREG_STATUS) LedG_On();
        break;
      }

      //если есть звонок, выходим
      if(timeAfter(xTaskGetTickCount(), next_voice_call_poll_timeMS))
      {
        int16_t at_res;
        call_state_t* call_state=(call_state_t*)common_tx_mem;

        at_res=get_call_state(call_state);
        if(at_res==GSM_RES_OK && call_state->is_call_present) break;
        next_voice_call_poll_timeMS=1000+xTaskGetTickCount();
      }

      if(timeAfter(xTaskGetTickCount(), end_wait_time_MS)) break;

      const bool message_recived = Psave_handler(true, 50);

      if(message_recived)
      {
        if(this->input_message.code==COMMAND_SLEEP)
        {
          __PRINTF("%s: recv sleep cmd\n", this->name);
          this->sleep_cmd=1;
          return;
        }
        else if(this->input_message.code==COMMAND_SERVER_SEND_SMS)
        {
          __PRINTF("%s: recv send sms cmd\n", this->name);

          uint8_t is_full=1;
          for(uint8_t i=0; i<SMS_OUT_QUEURE_LEN; i++)
          {
            if(!sms_out_queue[i].is_not_empty)
            {
              is_full=0;
              sms_out_queue[i].is_not_empty=1;
              sms_out_queue[i].phone_id=this->input_message.subcode;
              sms_out_queue[i].sms_data=(char*)this->input_message.pPayload;
              sms_out_queue[i].sms_data_max_size=this->input_message.payload_size;
              break;
            }
          }

          if(is_full)
          {
            LOG("%s: sms_out_queue is full\n", this->name);
          }
        }
      }
    }

    for(uint8_t i=0; i<SERVER_TCP_CNT; i++)
    {
      if(conn_ctx[i].protocol_type!=VOID_PROTOCOL_TYPE)
      {
        conn_ctx[i].conn_fail_counter=0;
        conn_ctx[i].server_ctx_state=DO_CONNECTING;
      }
    }

#if defined(BT3_PRESENT)
    if(this->bt_initialized)
    {
      bt_ctx.protocol_type=VEGA_PROTOCOL_TYPE;
      bt_ctx.rx_buff=bt_rx_mem;
      bt_ctx.rx_buff_size=sizeof(bt_rx_mem);
      bt_ctx.server_addr="bt_host"; bt_ctx.server_ctx_name="bt_vega_ctx";
      bt_ctx.keepalive_timeoutS=0xffff;
      bt_ctx.connection_periodM=0;
      bt_ctx.server_ctx_state=DO_CONNECTING;
      bt_ctx.conn_ctx_id=SERVER_BT_CONN_ID;
      bt_ctx.conn_fail_counter=0;
      bt_ctx.common_const=&protocols_common_const;

#if defined(VEGA_SECURE_PRESENT)
      bt_ctx.secure=NULL;
#endif //defined(VEGA_SECURE_PRESENT)

#if defined(VEGA_ESECURE_PRESENT)
      bt_ctx.esecure=NULL;
#endif //defined(VEGA_ESECURE_PRESENT)

      bt_ctx.protocol.vega.use_passwd_opt=&System.security_settings.use_pin;
      bt_ctx.protocol.vega.passwd=System.security_settings.pin;
      bt_ctx.protocol.vega.bbox_receiver=0;
      bt_ctx.protocol.vega.tx_mem=common_tx_mem;
      bt_ctx.protocol.vega.tx_mem_size=sizeof(common_tx_mem);
      bt_ctx.protocol.vega.dev_type=DEVICE_TYPE;
      bt_ctx.protocol.vega.got_vega_packet_callback=_got_vega_packet_callback;
    }
    else
    {
      bt_ctx.protocol_type=VOID_PROTOCOL_TYPE;
    }

    uint8_t en_time_sync=1;
    uint8_t is_en_entering_bt_conn_handle=0;
#endif //defined(BT3_PRESENT)

#if defined(USE_SIMCOM_MODEM_LIB) || defined(USE_QUECTEL_MODEM_LIB)
    uint8_t en_time_sync=1;
#endif //defined(USE_SIMCOM_MODEM_LIB) || defined(USE_QUECTEL_MODEM_LIB)

    uint32_t wdg_and_rssi_timeMS=xTaskGetTickCount()+WDT_AND_RSSI_TIMEOUT_MS/4-1;
    uint32_t check_settings_timeMS=xTaskGetTickCount();
    uint32_t modem_reboot_timeS=GetSecondsFromStartup()+MODEM_REBOOT_TIMEOUT_S-1;
    next_voice_call_poll_timeMS=xTaskGetTickCount();

#if NO_RX_DATA_SIM_CHANGE_OR_REBOOT_TIMEOUT_S > 0
    this->last_tcp_data_recv_timeS=GetSecondsFromStartup();
#endif //NO_RX_DATA_SIM_CHANGE_OR_REBOOT_TIMEOUT_S > 0

#if defined(CHANGE_SIM_BY_NO_VALID_VEGA_PACKET_PRESENT)
    last_valid_vega_packet_timeS=GetSecondsFromStartup()+1*60;
#endif //defined(CHANGE_SIM_BY_NO_VALID_VEGA_PACKET_PRESENT)

    cycle_poll.last_activity_time=xTaskGetTickCount()+6000;

#if (DEVICE_TYPE == DEVICE_TYPE_VEGA_MT_32K_LTE || DEVICE_TYPE == DEVICE_TYPE_VEGA_MT_32K_LTE_V2)
    scan_mode.mode=AUTO_SCAN_MODE;
    scan_mode.timerS=GetSecondsFromStartup();
#endif //DEVICE_TYPE_VEGA_MT_32K_LTE || DEVICE_TYPE_VEGA_MT_32K_LTE_V2

    for(;;)
    {
      if(timeAfter(xTaskGetTickCount(), cycle_poll.last_activity_time+2000))
      {
        cycle_poll.main_timeout=400;
      }
      else if(timeAfter(xTaskGetTickCount(), cycle_poll.last_activity_time+1000))
      {
        cycle_poll.main_timeout=200;
      }
      else
      {
#if defined(__EHS5__)
        cycle_poll.main_timeout=35;
#else
        cycle_poll.main_timeout=50;
#endif //defined(__EHS5__)
      }

      const bool message_recived = Psave_handler((cycle_poll.main_timeout >= 400), cycle_poll.main_timeout, true);

      if(message_recived)
      {
        if(this->input_message.code==COMMAND_SLEEP)
        {
          __PRINTF("%s: recv sleep cmd\n", this->name);
          this->sleep_cmd=1;
          return;
        }
        else if(this->input_message.code==MESSAGE_SERVER_RECV_DATA)
        {
          //отослали из парсера для форсированной обработки
        }
        else if(this->input_message.code==COMMAND_SERVER_SEND_SMS)
        {
          __PRINTF("%s: recv send sms cmd\n", this->name);

          uint8_t is_full=1;
          for(uint8_t i=0; i<SMS_OUT_QUEURE_LEN; i++)
          {
            if(!sms_out_queue[i].is_not_empty)
            {
              is_full=0;
              sms_out_queue[i].is_not_empty=1;
              sms_out_queue[i].phone_id=this->input_message.subcode;
              sms_out_queue[i].sms_data=(char*)this->input_message.pPayload;
              sms_out_queue[i].sms_data_max_size=this->input_message.payload_size;
              break;
            }
          }

          if(is_full)
          {
            LOG("%s: sms_out_queue is full\n", this->name);
          }
        }
#if defined(VOICE_CALL_PRESENT)
        //
#endif //VOICE_CALL_PRESENT
      }

      if(this->sleep_cmd)
      {
        __PRINTF("%s: goto sleep\n", this->name);
        return;
      }

      //Обрабатываем очередь смс
      for(uint8_t i=0; i<SMS_OUT_QUEURE_LEN; i++)
      {
        if(sms_out_queue[i].is_not_empty)
        {
          sms_out_queue[i].is_not_empty=0;

          if(sms_out_queue[i].phone_id<MAX_AUTORIZED_PHONES)
          {
            uint8_t phone_len=strnlen(System.security_settings.autorized_phones[sms_out_queue[i].phone_id], sizeof(System.security_settings.autorized_phones[sms_out_queue[i].phone_id]));

            if(phone_len>0 && phone_len<sizeof(System.security_settings.autorized_phones[sms_out_queue[i].phone_id]))
            {
              struct sms_out_struct
              {
                char* number;
                char* text;
                uint8_t* conv_heap;
                uint16_t conv_heap_size;
              }sms;

              sms.number=(char*)&common_tx_mem[0];
              sms.text=(char*)&common_tx_mem[sizeof(System.security_settings.autorized_phones[sms_out_queue[i].phone_id])];
              sms.conv_heap=(uint8_t*)&common_tx_mem[sizeof(System.security_settings.autorized_phones[sms_out_queue[i].phone_id])+sms_out_queue[i].sms_data_max_size];
              sms.conv_heap_size=sizeof(common_tx_mem)-(sizeof(System.security_settings.autorized_phones[sms_out_queue[i].phone_id])+sms_out_queue[i].sms_data_max_size);

              System.Grab(portMAX_DELAY);
              memcpy(sms.number, System.security_settings.autorized_phones[sms_out_queue[i].phone_id], sizeof(System.security_settings.autorized_phones[sms_out_queue[i].phone_id]));
              sms.number[sizeof(System.security_settings.autorized_phones[sms_out_queue[i].phone_id])-1]='\0';
              memcpy(sms.text, sms_out_queue[i].sms_data, sms_out_queue[i].sms_data_max_size);
              sms.text[sms_out_queue[i].sms_data_max_size-1]='\0';
              System.Release();

              int16_t res;
              LOG("%s: send sms: \"%s\", phone: %s\n", this->name, sms.text, sms.number);
              res=SendSmsInTextMode(sms.number, sms.text, 1, sms.conv_heap, sms.conv_heap_size);
              if(res<0) LOG("%s: send sms err (%hd)\n", this->name, res);
              //break;//за раз отправляем по одному сообщению, для того что-бы чаще читать из основной очереди
            }
          }
        }
      }

#if defined(USE_SIMCOM_MODEM_LIB)
      if(en_time_sync)
      {
        uint32_t network_time;
        if(GSM_RES_OK==get_network_time(&network_time))
        {
          if(network_time>GetUnixTime()+(60*60*24*365))
          {
            SetUnixTime(network_time);
            time_struct_t time;
            conv_unixtime_to_time(&time, network_time);
            LOG("%s: system time sync with network (%hu.%hhu.%hhu, %hhu:%hhu:%hhu UTC)\n", this->name, time.year, time.mon, time.day, time.hour, time.min, time.sec);
          }
          en_time_sync=0;
        }
      }
#endif //USE_SIMCOM_MODEM_LIB

#if defined(USE_QUECTEL_MODEM_LIB)
      bool is_beeline = BEELINE_MNC == System.server_state.serving_cell.MNC;
      if(en_time_sync && !is_beeline)
      {
        ntp_sync_time("0.ru.pool.ntp.org", 123);

        uint32_t network_time;
        if(GSM_RES_OK==get_network_time(&network_time))
        {
          if(network_time>GetUnixTime()+(60*60*24*365))
          {
            SetUnixTime(network_time);
            time_struct_t time;
            conv_unixtime_to_time(&time, network_time);
            LOG("%s: system time sync with network (%hu.%hhu.%hhu, %hhu:%hhu:%hhu UTC)\n", this->name, time.year, time.mon, time.day, time.hour, time.min, time.sec);
          }
          en_time_sync=0;
        }
      }
#endif //USE_QUECTEL_MODEM_LIB

      if(timeAfter(xTaskGetTickCount(), check_settings_timeMS))
      {

#if MAX_SIM_COUNT > 1
        const char* change_event_str="unknown";

        if(this->force_change_sim || \
          System.server_state.serving_cell.RegStat==REGISTRATION_DENIED_CREG_STATUS || \
            /*System.server_state.serving_cell.RegStat==NOT_REGISTERED_ME_NOT_SEARCHING_OPERATOR_CREG_STATUS || \*/
              timeAfter(xTaskGetTickCount(), this->last_network_view_time_MS+NO_NETWORK_TIME_MS_FOR_CHANGE_SIM-1))
        {
          //если нет сети более NO_NETWORK_TIME_MS_FOR_CHANGE_SIM
          if(this->current_sim_id==0) this->desired_sim_id=1;
          else                        this->desired_sim_id=0;

          if(this->force_change_sim)                                                                        change_event_str="force change cmd";
          else if(System.server_state.serving_cell.RegStat==REGISTRATION_DENIED_CREG_STATUS || \
            System.server_state.serving_cell.RegStat==NOT_REGISTERED_ME_NOT_SEARCHING_OPERATOR_CREG_STATUS) change_event_str="registration denied/ not searching operator";
          else                                                                                              change_event_str="no network";
        }
        else
        {
#if CHECK_MAINT_SIM_TIMEOUT_MS > 0
          if(this->current_sim_id!=MAIN_SIM_ID && timeAfter(xTaskGetTickCount(), work_on_reserve_sim_end_timeMS))
          {
            this->desired_sim_id=MAIN_SIM_ID;
            this->force_change_sim=1; //в случае DSDS модема, если основная сим будет отсуствовать, это не приведет к перезагрузке модема

            change_event_str="periodic return to main sim";
          }
#endif //CHECK_MAINT_SIM_TIMEOUT_MS > 0
        }

        if(this->current_sim_id!=this->desired_sim_id)
        {
#if defined(USE_FAST_SIM_CHANGE)
          LOG("%s: sim will be changing by \"%s\"\n", this->name, change_event_str);

          this->Fast_sim_change();
          if(this->is_man_reinit || this->sleep_cmd) return;

#if CHECK_MAINT_SIM_TIMEOUT_MS > 0
          if(this->current_sim_id!=MAIN_SIM_ID) this->work_on_reserve_sim_end_timeMS=xTaskGetTickCount()+CHECK_MAINT_SIM_TIMEOUT_MS-1;
#endif //CHECK_MAINT_SIM_TIMEOUT_MS > 0

#if NO_RX_DATA_SIM_CHANGE_OR_REBOOT_TIMEOUT_S > 0
          this->last_tcp_data_recv_timeS=GetSecondsFromStartup();
#endif //NO_RX_DATA_SIM_CHANGE_OR_REBOOT_TIMEOUT_S > 0

#if defined(CHANGE_SIM_BY_NO_VALID_VEGA_PACKET_PRESENT)
          last_valid_vega_packet_timeS=GetSecondsFromStartup()+1*60;
#endif //defined(CHANGE_SIM_BY_NO_VALID_VEGA_PACKET_PRESENT)

#if MAX_SIM_COUNT > 1
          this->last_network_view_time_MS=xTaskGetTickCount();
#endif //MAX_SIM_COUNT > 1

          this->force_change_sim=0;

          //modem_reboot_timeS=GetSecondsFromStartup()+MODEM_REBOOT_TIMEOUT_S-1;
#else
          LOG("%s: simcard id changed to %hhu by \"%s\", restart manager\n", this->name, this->desired_sim_id, change_event_str);

          this->is_man_reinit=1;
          return;
#endif //defined(USE_FAST_SIM_CHANGE)
        }
#endif //MAX_SIM_COUNT > 1

#if defined(USE_APN_CHANGE_WITHOUT_REBOOT)
        bool is_apn_changed=false;

        System.Grab(portMAX_DELAY);
        if(apn_settings_digest!=crc32_fast_full((uint8_t*)&System.connection_settings.APN[this->current_sim_id], sizeof(System.connection_settings.APN[this->current_sim_id]))) is_apn_changed=true;
        System.Release();

        if(is_apn_changed)
        {
          TGSM_APN* local_apn=(TGSM_APN*)&common_tx_mem[0];

          System.Grab(portMAX_DELAY);
          memcpy(local_apn, &System.connection_settings.APN[this->current_sim_id], sizeof(TGSM_APN));
          apn_settings_digest=crc32_fast_full((uint8_t*)&System.connection_settings.APN[this->current_sim_id], sizeof(System.connection_settings.APN[this->current_sim_id]));
          System.Release();

          local_apn->APN[sizeof(local_apn->APN)-1]='\0';
          local_apn->user[sizeof(local_apn->user)-1]='\0';
          local_apn->password[sizeof(local_apn->password)-1]='\0';

          if(is_enable_set_minimum_functionality_for_set_apn())
          {
            if(GSM_RES_OK!=cfun_config(4, 0)) {LOG("%s: setting cfun=4 err\n", this->name);}
          }

          int16_t at_res;
          for(uint8_t att=0; att<MAX_SEND_AT_ATTEMPT; att++)
          {
            at_res=gprs_config(local_apn->user, local_apn->password, local_apn->APN);
            if(GSM_RES_OK==at_res) break;
            if(att!=MAX_SEND_AT_ATTEMPT-1) vTaskDelay(200*(att+1));
          }
          if(GSM_RES_OK!=at_res) __PRINTF("%s: gprs_config err\n", this->name);
          LOG("%s: apn settings (sim id=%hhu), \"%s\", \"%s\", \"%s\" %s\n", this->name, this->current_sim_id, local_apn->APN, local_apn->user, local_apn->password, (GSM_RES_OK==at_res)?("applied"):("not applied"));

          if(is_enable_set_minimum_functionality_for_set_apn())
          {
            if(GSM_RES_OK!=cfun_config(1, 0)) {LOG("%s: setting cfun=1 err\n", this->name);}
          }
        }
#else
        System.Grab(portMAX_DELAY);
        if(apn_settings_digest!=crc32_fast_full((uint8_t*)&System.connection_settings.APN[this->current_sim_id], sizeof(System.connection_settings.APN[this->current_sim_id]))) this->is_man_reinit=1;
        System.Release();

        if(this->is_man_reinit)
        {
          LOG("%s: new apn settings (sim id=%hhu), restart manager\n", this->name, this->current_sim_id);
          return;
        }
#endif //defined(USE_APN_CHANGE_WITHOUT_REBOOT)

        System.Grab(portMAX_DELAY);

        for(uint8_t i=0; i<SERVER_TCP_CNT; i++)
        {
          serv_ctx_prot_type_t prot_type_in_system;

          if(System.connection_settings.server[i].server_protocol==SERVER_OFF)                  prot_type_in_system=VOID_PROTOCOL_TYPE;
#if defined(USE_EGTS_PROTOCOL_LIB)
          else if(System.connection_settings.server[i].server_protocol==EGTS)                   prot_type_in_system=EGTS_PROTOCOL_TYPE;
          else if(System.connection_settings.server[i].server_protocol==EGTS_LIGHT_1)           prot_type_in_system=EGTS_LIGHT_1_PROTOCOL_TYPE;
          else if(System.connection_settings.server[i].server_protocol==EGTS_LIGHT_2)           prot_type_in_system=EGTS_LIGHT_2_PROTOCOL_TYPE;
#endif //USE_EGTS_PROTOCOL_LIB
          else if(System.connection_settings.server[i].server_protocol==WIALON)                 prot_type_in_system=WIALON_PROTOCOL_TYPE;
          else if(System.connection_settings.server[i].server_protocol==VEGA)                   prot_type_in_system=VEGA_PROTOCOL_TYPE;
#if defined(USE_NDTP_PROTOCOL_LIB)
          else if(System.connection_settings.server[i].server_protocol==NDTP)                   prot_type_in_system=NDTP_PROTOCOL_TYPE;
#endif //USE_NDTP_PROTOCOL_LIB
          else if(System.connection_settings.server[i].server_protocol==WIALON_COMBINE)         prot_type_in_system=WIALON_BIN_PROTOCOL_TYPE;
#if defined(USE_NAVIS_PROTOCOL_LIB)
          else if(System.connection_settings.server[i].server_protocol==NAVIS_PROTOCOL)         prot_type_in_system=NAVIS_PROTOCOL_TYPE;
#endif //USE_NAVIS_PROTOCOL_LIB
          else
          {
            //неподдерживаемый протокол
            continue;
          }

          uint16_t len;
          len=strnlen(System.connection_settings.server[i].address, sizeof(System.connection_settings.server[i].address));
          if(len >= sizeof(System.connection_settings.server[i].address) || len >= sizeof(local_settings[i].addr))
          {
            //строка не нультерминированная или не вмещается в локальный буфер
            continue;
          }

          if(strchr(System.connection_settings.server[i].address, ':')==NULL)
          {
            if(System.connection_settings.server[i].address[0]!='\0')
            {
              //строка не содержит символ ':' и не пустая строка
              continue;
            }
          }

          if(sizeof(local_settings[i].addr)>sizeof(System.connection_settings.server[i].address)) len=sizeof(System.connection_settings.server[i].address);
          else len=sizeof(local_settings[i].addr);

          if(local_settings[i].prot_type!=prot_type_in_system || memcmp(local_settings[i].addr, System.connection_settings.server[i].address, len)!=0 \
            || local_settings[i].connection_periodM!=System.connection_settings.server[i].connection_period \
              || local_settings[i].user_terminal_addr!=System.connection_settings.ndtp_address[i])
          {
            local_settings[i].prot_type=prot_type_in_system;
            memcpy(local_settings[i].addr, System.connection_settings.server[i].address, len);
            local_settings[i].addr[sizeof(local_settings[i].addr)-1]='\0';
            if(System.connection_settings.server[i].connection_period>10*24*60) System.connection_settings.server[i].connection_period=10*24*60;//ограничиваем 10 днями
            local_settings[i].connection_periodM=System.connection_settings.server[i].connection_period;
            local_settings[i].user_terminal_addr=System.connection_settings.ndtp_address[i];
            local_settings[i].is_update=1;
          }

          //измениние pin_enabled_opt не приводит к разрыву соединения
          if(System.connection_settings.security[i].pin_cfg==PIN_ENABLED)
            local_settings[i].pin_enabled_opt=1;
          else
            local_settings[i].pin_enabled_opt=0;
        }
        System.Release();

        for(uint8_t i=0; i<SERVER_TCP_CNT; i++)
        {
          if(local_settings[i].is_update)
          {
            if(!(conn_ctx[i].protocol_type==VOID_PROTOCOL_TYPE || conn_ctx[i].server_ctx_state==WAIT_NEXT_SESSION))
            {
              conn_ctx[i].common_const->socket_close(conn_ctx[i].conn_ctx_id);
            }

            clear_server_notifies(i);

            conn_ctx[i].protocol_type=local_settings[i].prot_type;
            conn_ctx[i].server_ctx_state=DO_CONNECTING;
            conn_ctx[i].connection_periodM=local_settings[i].connection_periodM;
            conn_ctx[i].conn_fail_counter=0;

#if defined(VEGA_SECURE_PRESENT)
            conn_ctx[i].secure=NULL;
#endif //defined(VEGA_SECURE_PRESENT)

#if defined(VEGA_ESECURE_PRESENT)
            conn_ctx[i].esecure=NULL;
#endif //defined(VEGA_ESECURE_PRESENT)

            if(conn_ctx[i].protocol_type==VOID_PROTOCOL_TYPE)
            {
              //none
            }
#if defined(USE_EGTS_PROTOCOL_LIB)
            else if(conn_ctx[i].protocol_type==EGTS_PROTOCOL_TYPE || conn_ctx[i].protocol_type==EGTS_LIGHT_1_PROTOCOL_TYPE || conn_ctx[i].protocol_type==EGTS_LIGHT_2_PROTOCOL_TYPE)
            {
              EgtsDeInitCtx(&conn_ctx[i].protocol.egts);
              conn_ctx[i].protocol.egts.tid=local_settings[i].user_terminal_addr;
              conn_ctx[i].protocol.egts.oid=local_settings[i].user_terminal_addr;
              conn_ctx[i].protocol.egts.tx_mem=common_tx_mem;
              conn_ctx[i].protocol.egts.tx_mem_size=sizeof(common_tx_mem);
              conn_ctx[i].protocol.egts.bbox_receiver=i+1;
              conn_ctx[i].protocol.egts.egts_cmd_callback=_egts_cmd_callback;
              conn_ctx[i].protocol.egts.egts_get_current_state_callback=_egts_get_current_state_callback;
            }
#endif //USE_EGTS_PROTOCOL_LIB
#if defined(USE_WIALON_PROTOCOL_LIB)
            else if(conn_ctx[i].protocol_type==WIALON_PROTOCOL_TYPE)
            {
              WialonDeInitCtx(&conn_ctx[i].protocol.wialon);
              conn_ctx[i].protocol.wialon.use_passwd_opt=&local_settings[i].pin_enabled_opt;
              conn_ctx[i].protocol.wialon.passwd=System.connection_settings.security[i].pin;
              conn_ctx[i].protocol.wialon.tx_mem=common_tx_mem;
              conn_ctx[i].protocol.wialon.tx_mem_size=sizeof(common_tx_mem);
              conn_ctx[i].protocol.wialon.bbox_receiver=i+1;
            }
#endif //USE_WIALON_PROTOCOL_LIB
            else if(conn_ctx[i].protocol_type==VEGA_PROTOCOL_TYPE)
            {
              VegaDeInitCtx(&conn_ctx[i].protocol.vega);
              conn_ctx[i].protocol.vega.use_passwd_opt=&local_settings[i].pin_enabled_opt;
              conn_ctx[i].protocol.vega.passwd=System.connection_settings.security[i].pin;
              conn_ctx[i].protocol.vega.bbox_receiver=i+1;
              conn_ctx[i].protocol.vega.tx_mem=common_tx_mem;
              conn_ctx[i].protocol.vega.tx_mem_size=sizeof(common_tx_mem);
              conn_ctx[i].protocol.vega.dev_type=DEVICE_TYPE;
              conn_ctx[i].protocol.vega.got_vega_packet_callback=_got_vega_packet_callback;
#if defined(CHANGE_SIM_BY_NO_VALID_VEGA_PACKET_PRESENT)
              last_valid_vega_packet_timeS=GetSecondsFromStartup()+1*60;
#endif //defined(CHANGE_SIM_BY_NO_VALID_VEGA_PACKET_PRESENT)
            }
#if defined(USE_NDTP_PROTOCOL_LIB)
            else if(conn_ctx[i].protocol_type==NDTP_PROTOCOL_TYPE)
            {
              NdtpDeInitCtx(&conn_ctx[i].protocol.ndtp);
              conn_ctx[i].protocol.ndtp.bbox_receiver=i+1;
              conn_ctx[i].protocol.ndtp.peer_address=local_settings[i].user_terminal_addr;
              conn_ctx[i].protocol.ndtp.filling_ndtp_ext_data=_filling_ndtp_ext_data;
              conn_ctx[i].protocol.ndtp.tx_mem=common_tx_mem;
              conn_ctx[i].protocol.ndtp.tx_mem_size=sizeof(common_tx_mem);
            }
#endif //USE_NDTP_PROTOCOL_LIB
            else if(conn_ctx[i].protocol_type==WIALON_BIN_PROTOCOL_TYPE)
            {
              WialonBinDeInitCtx(&conn_ctx[i].protocol.wialon_bin);
              System.Grab(portMAX_DELAY);
              if(local_settings[i].user_terminal_addr) conn_ctx[i].protocol.wialon_bin.terminal_id=local_settings[i].user_terminal_addr;
              else                                     conn_ctx[i].protocol.wialon_bin.terminal_id=strtoull(System.server_state.IMEI, NULL, 10);
              System.Release();
              conn_ctx[i].protocol.wialon_bin.use_passwd_opt=&local_settings[i].pin_enabled_opt;
              conn_ctx[i].protocol.wialon_bin.passwd=System.connection_settings.security[i].pin;
              conn_ctx[i].protocol.wialon_bin.tx_mem=common_tx_mem;
              conn_ctx[i].protocol.wialon_bin.tx_mem_size=sizeof(common_tx_mem);
              conn_ctx[i].protocol.wialon_bin.bbox_receiver=i+1;
            }
#if defined(USE_NAVIS_PROTOCOL_LIB)
            else if(conn_ctx[i].protocol_type==NAVIS_PROTOCOL_TYPE)
            {
              NavisDeInitCtx(&conn_ctx[i].protocol.navis);
              System.Grab(portMAX_DELAY);
              if(local_settings[i].user_terminal_addr) conn_ctx[i].protocol.navis.terminal_id=local_settings[i].user_terminal_addr;
              else                                     conn_ctx[i].protocol.navis.terminal_id=strtoull(System.server_state.IMEI, NULL, 10);
              System.Release();
              conn_ctx[i].protocol.navis.tx_mem=common_tx_mem;
              conn_ctx[i].protocol.navis.tx_mem_size=sizeof(common_tx_mem);
              conn_ctx[i].protocol.navis.bbox_receiver=i+1;
              conn_ctx[i].protocol.navis.filling_gnss_state=_navis_filling_gnss_state;
            }
#endif //USE_NAVIS_PROTOCOL_LIB
            local_settings[i].is_update=0;

            LOG("%s: new settings, server id: %hhu, addr: %s, type: %s, conn_period: %hu minutes, user_terminal_addr: %lu\n", \
              this->name, i+1, local_settings[i].addr, prot_type_name[local_settings[i].prot_type], local_settings[i].connection_periodM, local_settings[i].user_terminal_addr);
          }
        }

        check_settings_timeMS=xTaskGetTickCount()+2000-1;
      }

      // Регулярный опрос модема на предмет наличия связи и качества сигнала
      if(timeAfter(xTaskGetTickCount(), wdg_and_rssi_timeMS))
      {
        operate_modem_temp_status_t temp_status;
        operate_modem_power_status_t power_status;

        power_status=get_modem_power_status();
        if(power_status!=UNKNOWN_MODEM_POWER_STATUS)
        {
          const char* res_str="unknown";
          if(power_status==UNDERVOLTAGE_MODEM_POWER_STATUS)     res_str="undervoltage";
          else if(power_status==OVERVOLTAGE_MODEM_POWER_STATUS) res_str="overvoltage";

          LOG("%s: warning, modem pwr %s detect!!!\n", this->name, res_str);
        }

        temp_status=get_modem_temp_status();
        if(temp_status!=UNKNOWN_MODEM_TEMP_STATUS && temp_status!=NORMAL_MODEM_TEMP_STATUS)
        {
          const char* res_str="unknown";
          if(temp_status==LOWEST_MODEM_TEMP_STATUS)             res_str="lowest";
          else if(temp_status==LOW_MODEM_TEMP_STATUS)           res_str="low";
          else if(temp_status==UPPER_MODEM_TEMP_STATUS)         res_str="upper";
          else if(temp_status==UPPERMOST_MODEM_TEMP_STATUS)     res_str="uppermost";

          LOG("%s: warning, modem %s temp detect!!!\n", this->name, res_str);
        }

        Backup_settings_handler();

        Sms_handler();

        if(this->is_man_reinit) return;//по смс получили команду на переинициализвцию

        if(timeAfter(GetSecondsFromStartup(), modem_reboot_timeS))
        {
          LOG("%s: restart modem after %lu min\n", this->name, MODEM_REBOOT_TIMEOUT_S/60);
          this->is_man_reinit=1;
          return;
        }

        int16_t at_res;
        for(uint8_t att=0; att<MAX_SEND_AT_ATTEMPT; att++)
        {
          at_res=send_simple_at("AT+CSQ\r", 6000);
          if(GSM_RES_OK==at_res) break;
          if(att!=MAX_SEND_AT_ATTEMPT-1) vTaskDelay(1000*(att+1));
        }
        if(GSM_RES_OK!=at_res)
        {
#if (MAX_SIM_COUNT > 1)
          LOG("%s: AT+CSQ err, restart manager with sim change\n", this->name);

          if(this->current_sim_id==0) {this->desired_sim_id=1;}
          else                        {this->desired_sim_id=0;}

          //this->force_change_sim=1
#else
          LOG("%s: AT+CSQ err, restart manager\n", this->name);
#endif //(MAX_SIM_COUNT > 1)

          this->is_man_reinit=1;
          return;
        }

        if(System.server_state.signal_rssi!=get_rssi_level())
        {
          int16_t var;
          System.Grab(portMAX_DELAY);
          System.server_state.signal_rssi=get_rssi_level();
          System.server_state.signal_rssi<=31 ? (var=2*System.server_state.signal_rssi-113) : (var=-120);
          System.server_state.signal_dbm=(int8_t)var;
          System.Release();
          __PRINTF("%s: change rssi to %hu\n", this->name, (uint16_t)System.server_state.signal_rssi);
        }

        if(true)
        {
#if (DEVICE_TYPE == DEVICE_TYPE_VEGA_MT_32K_LTE || DEVICE_TYPE == DEVICE_TYPE_VEGA_MT_32K_LTE_V2)
#if defined(FORCED_LTE_MODE_ONLY)
          System.server_state.scan_mode=LTE_ONLY_SCAN_MODE;

          if(false){}
#else //
          uint8_t newscanmode=System.server_state.scan_mode;

          if(newscanmode!=scan_mode.mode)
          {
            LOG("%s: scanmode change %hhu->%hhu\n", this->name, scan_mode.mode, newscanmode);

            scan_mode.mode=newscanmode;
            if(GSM_RES_OK==network_search_mode_configuration((network_scanmode_t)scan_mode.mode))
            {
              if(scan_mode.mode!=0) scan_mode.timerS=GetSecondsFromStartup()+3*60;
            }
            else
            {
              System.server_state.scan_mode=AUTO_SCAN_MODE;
              scan_mode.mode=AUTO_SCAN_MODE;
              LOG("%s: scanmode change err\n", this->name);
            }
          }
          else if(timeAfter(GetSecondsFromStartup(), scan_mode.timerS) && (network_scanmode_t)scan_mode.mode!=AUTO_SCAN_MODE)
          {
            LOG("%s: scanmode change %hhu->0\n", this->name, scan_mode.mode);

            if(GSM_RES_OK==network_search_mode_configuration(AUTO_SCAN_MODE))
            {
              System.server_state.scan_mode=AUTO_SCAN_MODE;
              scan_mode.mode=AUTO_SCAN_MODE;
            }
            else
            {
              LOG("%s: scanmode change err\n", this->name);
            }
          }
  #endif //FORCED_LTE_MODE_ONLY
#elif (DEVICE_TYPE == DEVICE_TYPE_VEGA_MT_25K || DEVICE_TYPE == DEVICE_TYPE_VEGA_MT_32K_LTE_V3)
          System.server_state.scan_mode=AUTO_SCAN_MODE;//�� ��������������
#endif //DEVICE_TYPE_VEGA_MT_32K_LTE  || DEVICE_TYPE_VEGA_MT_32K_LTE_V2 || DEVICE_TYPE_VEGA_MT_25K || DEVICE_TYPE == DEVICE_TYPE_VEGA_MT_32K_LTE_V3

          if(false){}
          else
          {
#if (DEVICE_TYPE == DEVICE_TYPE_VEGA_MT_32K_LTE || DEVICE_TYPE == DEVICE_TYPE_VEGA_MT_32K_LTE_V2 || DEVICE_TYPE == DEVICE_TYPE_VEGA_MT_32K_LTE_V3)
//#warning ��� ����� DEVICE_TYPE_VEGA_MT_32K_LTE � DEVICE_TYPE_VEGA_MT_32K_LTE_V2 �� ���������� ���������� � ��
#else
            if(GSM_RES_OK==get_cells_inf((char*)common_tx_mem, sizeof(common_tx_mem)))
            {
              uint16_t cmp_len=strnlen((char*)common_tx_mem, sizeof(common_tx_mem));
              if(cmp_len>(sizeof(System.server_state.ext_serving_cells_info)-1)) cmp_len=sizeof(System.server_state.ext_serving_cells_info)-1;

              if(memcmp(System.server_state.ext_serving_cells_info, common_tx_mem, cmp_len)!=0)
              {
                System.Grab(portMAX_DELAY);
                snprintf(System.server_state.ext_serving_cells_info, sizeof(System.server_state.ext_serving_cells_info), "%s", common_tx_mem);
                System.Release();
                //__PRINTF("%s: %s\n", this->name, common_tx_mem);
              }
            }
#endif
          }
        }

#if defined(USE_CINTERION_MODEM_LIB)
        static const uint32_t modem_reboot_flag = SYSSTART_GSM;
#endif //USE_CINTERION_MODEM_LIB

#if defined(USE_SIMCOM_MODEM_LIB)
        static const uint32_t modem_reboot_flag = RDY_FGSM;
#endif //USE_SIMCOM_MODEM_LIB

#if defined(USE_QUECTEL_MODEM_LIB)
        static const uint32_t modem_reboot_flag = RDY_FGSM;
#endif //USE_QUECTEL_MODEM_LIB

          if(ReadModemAtFlag(modem_reboot_flag))
          {
            ResetModemAtFlag(modem_reboot_flag);
            LOG("%s: modem reboot detect, restart manager\n", this->name);
            this->is_man_reinit=1;
            return;
          }

          if(System.server_state.serving_cell.MCC==0 && System.server_state.serving_cell.MNC==0)
          {
            operator_inf_t operator_inf;
            get_operator_inf(&operator_inf);
            if(System.server_state.serving_cell.MCC!=operator_inf.mcc || System.server_state.serving_cell.MNC!=operator_inf.mnc)
            {
              System.Grab(portMAX_DELAY);
              System.server_state.serving_cell.MCC=operator_inf.mcc;
              System.server_state.serving_cell.MNC=operator_inf.mnc;
              System.Release();

              //LOG("%s: mcc=%hhu, mnc=%hhu\n", this->name, System.server_state.serving_cell.MCC, System.server_state.serving_cell.MNC);
            }
          }

          wdg_and_rssi_timeMS=xTaskGetTickCount()+WDT_AND_RSSI_TIMEOUT_MS-1;
      }

      creg_state_t creg_gsm;

#if defined(__SIM800_DS__)
      if(this->current_sim_id==0)    get_ds_creg_state(&creg_gsm, NULL, 0);
      else                           get_ds_creg_state(NULL, &creg_gsm, 0);
#else
      get_creg_state(&creg_gsm, 0);
#endif //__SIM800_DS__

      if(System.server_state.serving_cell.CELLID!=creg_gsm.netCellId || System.server_state.serving_cell.AcT!=creg_gsm.AcT || System.server_state.serving_cell.LAC!=creg_gsm.netLac || System.server_state.serving_cell.RegStat!=creg_gsm.regStatus)
      {
        operator_inf_t operator_inf;
        get_operator_inf(&operator_inf);

        if(System.server_state.serving_cell.RegStat!=creg_gsm.regStatus)
        {
          LOG("%s: Reg status changed: %s -> %s\n", this->name, get_reg_status_verbose(System.server_state.serving_cell.RegStat), get_reg_status_verbose(creg_gsm.regStatus));
        }

        if(System.server_state.serving_cell.AcT!=creg_gsm.AcT)
        {
          LOG("%s: AcT changed: %s -> %s\n", this->name, get_act_verbose(System.server_state.serving_cell.AcT), get_act_verbose(creg_gsm.AcT));
        }

        if(System.server_state.serving_cell.MCC!=operator_inf.mcc || System.server_state.serving_cell.MNC!=operator_inf.mnc)
        {
          LOG("%s: Mobile codes changed: MCC=%hhu, MNC=%hhu\n", this->name, operator_inf.mcc, operator_inf.mnc);
        }

        System.Grab(portMAX_DELAY);
        System.server_state.serving_cell.CELLID=creg_gsm.netCellId;
        System.server_state.serving_cell.AcT=creg_gsm.AcT;
        System.server_state.serving_cell.LAC=creg_gsm.netLac;
        System.server_state.serving_cell.RegStat=creg_gsm.regStatus;
        System.server_state.serving_cell.MCC=operator_inf.mcc;
        System.server_state.serving_cell.MNC=operator_inf.mnc;
        System.Release();

        __PRINTF("%s: mcc=%hhu, mnc=%hhu, lac=%hX, cell_id=%lX, reg=%hhu\n", this->name, System.server_state.serving_cell.MCC, System.server_state.serving_cell.MNC, System.server_state.serving_cell.LAC, System.server_state.serving_cell.CELLID, System.server_state.serving_cell.RegStat);
      }

      if(get_sim_failure_status())
      {
        LOG("%s: sim failure detect, restart manager\n", this->name);
        this->is_man_reinit=1;
        return;
      }

#if defined(USE_SIMCOM_MODEM_LIB)
      uint8_t jstate=0;
      if(JAMMING_DETECTED==get_jamming_state(0)) jstate=1;

      if(jstate!=System.server_state.jammed)
      {
        System.server_state.jammed=jstate;
        //LOG("%s: change jamming state: %s\n", this->name, jstate ? "jamming detect" : "no jamming");
      }
#endif //USE_SIMCOM_MODEM_LIB

      for(uint8_t i=0; i<SERVER_TCP_CNT; i++)
      {
        server_conn_handler(&conn_ctx[i], this->name);
        if(conn_ctx[i].server_ctx_state==CONTINUE_COMMUNICATION)        System.server_state.tcp_connect_state[i]=1;
        else                                                            System.server_state.tcp_connect_state[i]=0;
      }

#if defined(DGNSS_PRESENT)
      ntrip_handler(&ntrip_ctx);
#endif //DGNSS_PRESENT

#if defined(VOICE_CALL_PRESENT)
      if(timeAfter(xTaskGetTickCount(), next_voice_call_poll_timeMS))
      {
        //
        next_voice_call_poll_timeMS=xTaskGetTickCount()+2008;
      }
#else //если голосовой вызов не поддерживается, кладём трубку
      if(timeAfter(xTaskGetTickCount(), next_voice_call_poll_timeMS))
      {
        call_state_t* call_state=(call_state_t*)common_tx_mem;
        int16_t at_res;

        at_res=get_call_state(call_state);

        if(at_res==GSM_RES_OK && call_state->is_call_present)
        {
          voice_call_disconnect();
        }

        next_voice_call_poll_timeMS=xTaskGetTickCount()+2008;
      }
#endif //VOICE_CALL_PRESENT

      uint8_t is_all_protocols_void=1;
      for(uint8_t i=0; i<SERVER_TCP_CNT; i++)
      {
        if(conn_ctx[i].protocol_type!=VOID_PROTOCOL_TYPE)
        {
          is_all_protocols_void=0;
          break;
        }
      }

      if(!is_all_protocols_void)
      {
        uint8_t sim_change_or_reboot=1;
        const char* change_event_verbose="conn_fail_counters overflow";

        for(uint8_t i=0; i<SERVER_TCP_CNT; i++)
        {
          if(conn_ctx[i].protocol_type!=VOID_PROTOCOL_TYPE && conn_ctx[i].conn_fail_counter<MAX_CONN_FAIL_COUNT_FOR_SIM_CHANGE_OR_REBOOT)
          {
            sim_change_or_reboot=0;
            break;
          }
        }

#if NO_RX_DATA_SIM_CHANGE_OR_REBOOT_TIMEOUT_S > 0
        if(!sim_change_or_reboot)
        {
          if(timeAfter(GetSecondsFromStartup(), this->last_tcp_data_recv_timeS+NO_RX_DATA_SIM_CHANGE_OR_REBOOT_TIMEOUT_S))
          {
            change_event_verbose="no rx data from servers";
            sim_change_or_reboot=2;
          }
        }
#endif //NO_RX_DATA_SIM_CHANGE_OR_REBOOT_TIMEOUT_S > 0

#if defined(CHANGE_SIM_BY_NO_VALID_VEGA_PACKET_PRESENT)
      if (!sim_change_or_reboot) {
        uint8_t number_of_lost_vega_servers = 0;
        uint8_t number_of_vega_servers = 0;
        if (USE_NEW_CHANGE_SIM_BY_NO_VALID_VEGA_PACKET) {
          if (System.connection_settings.main_yandex_server_id < MAX_SERVERS_COUNT) {
            if (VEGA_PROTOCOL_TYPE == conn_ctx[System.connection_settings.main_yandex_server_id].protocol_type) {
              number_of_vega_servers++;
              const uint8_t bbox_receiver = conn_ctx[System.connection_settings.main_yandex_server_id].protocol.vega.bbox_receiver;
              if (0 == Black_box.get_message_count(bbox_receiver) ) {
                /*onLine*/
                last_valid_vega_packet_timeS = GetSecondsFromStartup();
              }
            }
          }
          if (true == timeAfter(GetSecondsFromStartup(),
                                 last_valid_vega_packet_timeS + 3 * SEC_IN_MIN)) {
             change_event_verbose = "no valid packets from main vega server";
             sim_change_or_reboot = 3;
          }
        } else {
          for (uint8_t i = 0; i < SERVER_TCP_CNT; i++) {
            if (VEGA_PROTOCOL_TYPE == conn_ctx[i].protocol_type) {
              number_of_vega_servers++;
              if (0 == System.server_state.tcp_connect_state[i]) {
                number_of_lost_vega_servers++;
              }
            }
          }
          if ((number_of_vega_servers / 2) < number_of_lost_vega_servers ) {
            change_event_verbose = "no valid packets from majority vega servers";
            sim_change_or_reboot = 4;
          }
        }
      }
#endif //defined(CHANGE_SIM_BY_NO_VALID_VEGA_PACKET_PRESENT)

        if(sim_change_or_reboot)
        {
#if defined(USE_FAST_SIM_CHANGE) && (MAX_SIM_COUNT > 1)

          if(this->current_sim_id==0) this->desired_sim_id=1;
          else                        this->desired_sim_id=0;

          this->fast_sim_change_conn_fail_counter++;

          if(this->fast_sim_change_conn_fail_counter>=MAX_SIM_COUNT)
          {
            LOG("%s: sim will be changing by \"%s\", restart manager\n", this->name, change_event_verbose);

            this->is_man_reinit=1;
            return;
          }

          LOG("%s: sim will be changing by \"%s\"\n", this->name, change_event_verbose);

          this->Fast_sim_change();
          if(this->is_man_reinit || this->sleep_cmd) return;

#if CHECK_MAINT_SIM_TIMEOUT_MS > 0
          if(this->current_sim_id!=MAIN_SIM_ID) this->work_on_reserve_sim_end_timeMS=xTaskGetTickCount()+CHECK_MAINT_SIM_TIMEOUT_MS-1;
#endif //CHECK_MAINT_SIM_TIMEOUT_MS > 0

#if NO_RX_DATA_SIM_CHANGE_OR_REBOOT_TIMEOUT_S > 0
          this->last_tcp_data_recv_timeS=GetSecondsFromStartup();
#endif //NO_RX_DATA_SIM_CHANGE_OR_REBOOT_TIMEOUT_S > 0

#if defined(CHANGE_SIM_BY_NO_VALID_VEGA_PACKET_PRESENT)
          last_valid_vega_packet_timeS=GetSecondsFromStartup()+2*60;
#endif //defined(CHANGE_SIM_BY_NO_VALID_VEGA_PACKET_PRESENT)

#if MAX_SIM_COUNT > 1
          this->last_network_view_time_MS=xTaskGetTickCount();
#endif //MAX_SIM_COUNT > 1

          //modem_reboot_timeS=GetSecondsFromStartup()+MODEM_REBOOT_TIMEOUT_S-1;
#else

#if MAX_SIM_COUNT > 1
          if(this->current_sim_id==0) this->desired_sim_id=1;
          else                        this->desired_sim_id=0;

#if defined(USE_QUECTEL_MODEM_LIB)
#if defined(__MC60__)
          if(GSM_RES_OK!=change_sim_card(this->desired_sim_id))
          {
            LOG("%s: switch to sim id %hhu err\n", this->name, this->desired_sim_id);
            this->desired_sim_id=this->current_sim_id;//возвращаем
          }
#endif //defined(__MC60__)
#endif //defined(USE_QUECTEL_MODEM_LIB)

          LOG("%s: %s, restart manager with sim id %hhu\n", this->name, change_event_verbose, this->desired_sim_id);
#else
          LOG("%s: %s, restart manager\n", change_event_verbose, this->name);
#endif //MAX_SIM_COUNT > 1

          this->is_man_reinit=1;
          return;
#endif //defined(USE_FAST_SIM_CHANGE) && (MAX_SIM_COUNT > 1)
        }
      }

#if defined(USE_FAST_SIM_CHANGE) && (MAX_SIM_COUNT > 1)
      for(uint8_t i=0; i<SERVER_TCP_CNT; i++)
      {
        if(conn_ctx[i].protocol_type!=VOID_PROTOCOL_TYPE && (conn_ctx[i].server_ctx_state==CONTINUE_COMMUNICATION || conn_ctx[i].server_ctx_state==DO_AUTORIZATION))
        {
          this->fast_sim_change_conn_fail_counter=0;
          break;
        }
      }
#endif //defined(USE_FAST_SIM_CHANGE) && (MAX_SIM_COUNT > 1)

      uint8_t is_continue_communication=0;
      for(uint8_t i=0; i<SERVER_TCP_CNT; i++)
      {
        if(conn_ctx[i].protocol_type!=VOID_PROTOCOL_TYPE && conn_ctx[i].server_ctx_state==CONTINUE_COMMUNICATION)
        {
          is_continue_communication=1;
          break;
        }
      }

      if(is_continue_communication)
      {
        LedG_Toggle();
#if MAX_SIM_COUNT > 1
        this->last_network_view_time_MS=xTaskGetTickCount();
#endif //MAX_SIM_COUNT > 1
      }
      else if(System.server_state.serving_cell.RegStat==REGISTERED_FROM_HOME_OPERATOR_CREG_STATUS || System.server_state.serving_cell.RegStat==REGISTERED_FROM_FOREING_OPERATOR_CREG_STATUS)
      {
        LedG_On();
#if MAX_SIM_COUNT > 1
        this->last_network_view_time_MS=xTaskGetTickCount();
#endif //MAX_SIM_COUNT > 1
      }
      else
      {
        LedG_Off();
      }

#if defined(BT3_PRESENT)
      if(this->bt_initialized)
      {
        BtSppAcceptHandle();
        if(!is_en_entering_bt_conn_handle)
        {
          if(BtIsSppConnectExist())
          {
            is_en_entering_bt_conn_handle=1;
            __PRINTF("%s: spp bluetooth device connected\n", this->name);
          }
        }
        if(is_en_entering_bt_conn_handle) server_conn_handler(&bt_ctx, this->name);
        if(bt_ctx.server_ctx_state==WAIT_NEXT_SESSION) is_en_entering_bt_conn_handle=0;
      }
#endif //defined(BT3_PRESENT)
    }
  }

  // Инициализация менеджера
  void CSERVER_manager::Init (void)
  {
    // Установка приоритета задаче
    vTaskPrioritySet(this->task_handle, tskIDLE_PRIORITY + this->priority);

    if(this->answer_queue==NULL) this->answer_queue=xQueueCreate(1, sizeof(input_message));

    while(1)
    {
      if(this->is_man_reinit)
        break;
      if(this->Wait_message(100) || this->force_wakeup)
      {
        if(this->input_message.code == COMMAND_WAKEUP || this->force_wakeup)
        {
          this->force_wakeup=0;
          //если это первый старт manager'a
          if(this->is_start_after_power_on)
          {
            Black_box.Grab();
            Black_box.Register_in_base("imei_backup", sizeof(System.server_state.IMEI), 0, System.server_state.IMEI);
            if(System.server_state.IMEI[0]==0xff)
            {
              System.server_state.IMEI[0]='\0';
              Black_box.Save_base("imei_backup");
            }
            Black_box.Release();

            System.server_state.IMEI[sizeof(System.server_state.IMEI)-1]='\0';

            static const char* const conn_ctx_names[SERVER_TCP_CNT]={"conn_ctx_1", "conn_ctx_2", "conn_ctx_3", "conn_ctx_4"};
            for(uint8_t i=0; i<SERVER_TCP_CNT; i++)
            {
              conn_ctx[i].protocol_type=VOID_PROTOCOL_TYPE;
              conn_ctx[i].rx_buff=rx_mem_conn[i];
              conn_ctx[i].rx_buff_size=sizeof(rx_mem_conn[i]);
              conn_ctx[i].server_ctx_name=(char*)conn_ctx_names[i];
              conn_ctx[i].conn_ctx_id=i;
              conn_ctx[i].keepalive_timeoutS=60+15;
              conn_ctx[i].server_ctx_state=WAIT_NEXT_SESSION;
              conn_ctx[i].common_const=&protocols_common_const;

              local_settings[i].addr[0]='\0';
              conn_ctx[i].server_addr=local_settings[i].addr;
              local_settings[i].is_update=1;
            }

            this->is_start_after_power_on=0;
          }

          SERVER_manager.configurator_task_sleep_state=0;
          SERVER_manager.configurator_task_wakeup_cmd=1;

          System.server_state.is_on=1;

          LOG("%s: waking up...\n", this->name);
          break;
        }
      }
    }
    this->is_man_reinit=0;

#if defined(USE_FAST_SIM_CHANGE)
    this->fast_sim_change_conn_fail_counter=0;
#endif //defined(USE_FAST_SIM_CHANGE)

    this->Modem_pins_init();

#if defined(USE_DISCHARGE_MODEM_POWER)
    __DISCHARGE_MODEM_POWER_ON();
    vTaskDelay(2000);
    __DISCHARGE_MODEM_POWER_OFF();
#endif //USE_DISCHARGE_MODEM_POWER

    for(;;)
    {
#if MAX_SIM_COUNT > 1
      if(this->current_sim_id!=this->desired_sim_id) this->current_sim_id=this->desired_sim_id;

      if(this->current_sim_id==0)
      {
#if (!defined(__SIM800_DS__))
        __MODEM_SEL_SIM_0();
#endif //!__SIM800_DS__
      }
      else
      {
#if (!defined(__SIM800_DS__))
        __MODEM_SEL_SIM_1();
#endif //!__SIM800_DS__

#if CHECK_MAINT_SIM_TIMEOUT_MS > 0
        this->work_on_reserve_sim_end_timeMS=xTaskGetTickCount()+CHECK_MAINT_SIM_TIMEOUT_MS-1;
#endif //CHECK_MAINT_SIM_TIMEOUT_MS > 0
      }
#endif //MAX_SIM_COUNT > 1

      if(this->Wait_message(0))
      {
        if(this->input_message.code==COMMAND_SLEEP)
        {
          LOG("%s: modem initialization breaking\n", this->name);
          this->sleep_cmd=1;
          return;
        }
        else if(this->input_message.code==COMMAND_SERVER_SEND_SMS)
        {
          __PRINTF("%s: recv send sms cmd\n", this->name);

          uint8_t is_full=1;
          for(uint8_t i=0; i<SMS_OUT_QUEURE_LEN; i++)
          {
            if(!sms_out_queue[i].is_not_empty)
            {
              is_full=0;
              sms_out_queue[i].is_not_empty=1;
              sms_out_queue[i].phone_id=this->input_message.subcode;
              sms_out_queue[i].sms_data=(char*)this->input_message.pPayload;
              sms_out_queue[i].sms_data_max_size=this->input_message.payload_size;
              break;
            }
          }

          if(is_full)
          {
            LOG("%s: sms_out_queue is full\n", this->name);
          }
        }
      }

      LOG("%s: turning on modem (sim id %hhu)...\n", this->name, this->current_sim_id);

      System.server_state.used_sim=this->current_sim_id+1;

#if defined(USE_PRECHARGE_MODEM_POWER)
      __PRECHARGE_MODEM_POWER_ON();
      vTaskDelay(1500);
      __PRECHARGE_MODEM_POWER_OFF();
#endif //USE_PRECHARGE_MODEM_POWER

      System.Grab(portMAX_DELAY);
      PWR_PVDCmd(DISABLE);
#if defined(USE_PULSED_MODEM_POWER_ON)
      modem_pwr.is_modem_pwr_ready=0;
      modem_pwr.modem_pwr_on_pulse_idx=0;
      MODEM_PWR_TIM->CNT  = 0;
      MODEM_PWR_TIM->CCR1 = 0xffff;
      MODEM_PWR_TIM->CCR2 = 0x0001;
      MODEM_PWR_TIM->SR = ~TIM_IT_CC1; //clear CC1 IT flag
      MODEM_PWR_TIM->SR = ~TIM_IT_CC2; //clear CC2 IT flag
      MODEM_PWR_TIM->CR1 |= TIM_CR1_CEN;//run timer
      while(!modem_pwr.is_modem_pwr_ready) vTaskDelay(5);
      vTaskDelay(10);
#else
      __MODEM_POWER_EN();
      vTaskDelay(30);
#endif
      PWR_PVDCmd(ENABLE);
      System.Release();

#if defined(USE_QUECTEL_MODEM_LIB)
      vTaskDelay(500);
#else
      vTaskDelay(2300);
#endif

#if defined(USE_CINTERION_MODEM_LIB)
#error
#endif //USE_CINTERION_MODEM_LIB

#if defined(USE_SIMCOM_MODEM_LIB)
    ResetSimcomLibState();

#if defined(__A7670E__)
    ModemUartInit(115200, false); //����� � ������ ����. ���������� ��������, CTS � ������� ���������. �������� ���������� �������� �����
    __SIMCOM_PWRKEY_PIN_HI();
    vTaskDelay(100);
    __SIMCOM_PWRKEY_PIN_LOW();
    vTaskDelay(1000);
#else //defined(__SIM800__) || defined(__SIM800_DS__)
    ModemUartInit(115200, true);
     __SIMCOM_PWRKEY_PIN_HI();
    //vTaskDelay(8000);//vTaskDelay(1200);
    //� ����� �������� ���� RDY � ����� ���� ������� �� ��������� �������������
    //��� ������ ���� ���������� �� ����������� � ����
    if(true)
    {
      uint8_t sync_time_enable_att=4;
      for(uint8_t i=0; i<80; i++)//8 seconds
      {
        if(sync_time_enable_att && WaitModemFlags(RDY_FGSM, 0))
        {
          if(GSM_RES_OK==set_network_sync_time())
          {
            sync_time_enable_att=0;
          }
          else
          {
            if(sync_time_enable_att) sync_time_enable_att--;
          }
        }
        vTaskDelay(100);
      }
    }
    __SIMCOM_PWRKEY_PIN_LOW();
    vTaskDelay(3000);
#endif //defined(__A7670E__) || defined(__SIM800__) || defined(__SIM800_DS__)

    creg_state_t creg_gsm;
    get_creg_state(&creg_gsm, 0);
    System.Grab(portMAX_DELAY);
    System.server_state.serving_cell.CELLID=creg_gsm.netCellId;
    System.server_state.serving_cell.AcT=creg_gsm.AcT;
    System.server_state.serving_cell.LAC=creg_gsm.netLac;
    System.server_state.serving_cell.RegStat=creg_gsm.regStatus;
    System.server_state.serving_cell.MCC=0;
    System.server_state.serving_cell.MNC=0;
#if defined(YANDEX_EXTENDED_SENSORS_PRESENT)
    System.server_state.ext_serving_cells_info[0]='\0';
    System.server_state.scan_mode=AUTO_SCAN_MODE;
#endif //defined(YANDEX_EXTENDED_SENSORS_PRESENT)

    System.server_state.signal_rssi=get_rssi_level();
    System.server_state.signal_dbm=-120;

    System.server_state.jammed=0;
    System.Release();

    __PRINTF("%s: waiting status pin hi level signal....\n", this->name);

#if defined(__A7670E__)
    static const uint16_t STATUS_PIN_WAIT = 300;
#else //defined(__SIM800__) || defined(__SIM800_DS__)
    static const uint16_t STATUS_PIN_WAIT = 100;
#endif //defined(__A7670E__) || defined(__SIM800__) || defined(__SIM800_DS__)

    for(uint16_t i=0; i<STATUS_PIN_WAIT; i++)
    {
      if(__GET_SIMCOM_STATUS_PIN_STATE()) break;
      vTaskDelay(100);
    }

    if(__GET_SIMCOM_STATUS_PIN_STATE())
    {
      __PRINTF("%s: status pin hi level signal ok, waiting +CFUN: 1\n", this->name);

      if(WaitModemFlags(CFUN_X_FGSM, 10000))
      {
#if !defined(__A7670E__)
        uint8_t cfun_stae;
        get_cfun_stae(&cfun_stae, 0);
        if(cfun_stae!=1) cfun_config(1, 0);
#endif //!defined(__A7670E__)

        __PRINTF("%s: +CFUN: 1 ok, wait sim, call, sms ready...\n", this->name);

#if defined(__SIM800_DS__)
        if(this->current_sim_id==0 && WaitModemFlags(SIMREADY_FGSM|SMS_READY_FGSM|CALL_READY_FGSM|CPIN_NOT_INSERTED_FGSM, 45000) && WaitModemFlags(SMS_READY_FGSM|CPIN_NOT_INSERTED_FGSM, 65000) && WaitModemFlags(CALL_READY_FGSM|CPIN_NOT_INSERTED_FGSM, 65000) )
#else
        if(/*this->current_sim_id==0 && */WaitModemFlags(SIMREADY_FGSM|SMS_READY_FGSM|CALL_READY_FGSM|CPIN_NOT_INSERTED_FGSM, 45000) && WaitModemFlags(SMS_READY_FGSM|CPIN_NOT_INSERTED_FGSM, 65000) && WaitModemFlags(CALL_READY_FGSM|CPIN_NOT_INSERTED_FGSM, 65000) )
#endif //defined(__SIM800_DS__)
        {
          if(!ReadModemAtFlag(CPIN_NOT_INSERTED_FGSM))
          {
            __PRINTF("%s: sim (id %hhu), call, sms ready ok\n", this->name, this->current_sim_id);
            break;
          }
        }

#if MAX_SIM_COUNT > 1
#if defined(__SIM800_DS__)
        else if(this->current_sim_id==1 && WaitModemFlags(SIMREADY_DS_FGSM|SMS_READY_DS_FGSM|CALL_READY_DS_FGSM|CPIN_NOT_INSERTED_DS_FGSM, 45000) && WaitModemFlags(SMS_READY_DS_FGSM|CPIN_NOT_INSERTED_DS_FGSM, 65000) && WaitModemFlags(CALL_READY_DS_FGSM|CPIN_NOT_INSERTED_DS_FGSM, 65000) )
        {
          if(!ReadModemAtFlag(CPIN_NOT_INSERTED_DS_FGSM))
          {
            __PRINTF("%s: sim (id %hhu), call, sms ready ok\n", this->name, this->current_sim_id);
            break;
          }
        }
#endif //__SIM800_DS__
#endif //MAX_SIM_COUNT > 1

        LOG("%s: sim (id %hhu) or call or sms ready err\n", this->name, this->current_sim_id);
        soft_switch_off_modem();
        wait_staus_pin(0, 8000);
        __MODEM_POWER_DIS();
#if MAX_SIM_COUNT > 1
        if(this->current_sim_id==0) this->desired_sim_id=1;
        else                        this->desired_sim_id=0;
#endif //MAX_SIM_COUNT > 1
      }
      else
      {
        LOG("%s: +CFUN: 1 err\n", this->name);

        send_simple_at("AT\r", 2000);
        send_simple_at("AT\r", 2000);
        send_simple_at("AT+IPR=115200\r", 2000);//baudrate
        send_simple_at("AT+IFC=2,2\r", 2000);//hw flow control
        send_simple_at("AT&W\r", 2000);//save

        vTaskDelay(200);
        soft_switch_off_modem();
        wait_staus_pin(0, 8000);
        __MODEM_POWER_DIS();
      }
    }
    else
    {
      LOG("%s: status pin hi level signal err\n", this->name);
      __MODEM_POWER_DIS();
    }

    ModemUartDeInit();

#if MAX_SIM_COUNT > 1
#if (!defined(__SIM800_DS__))
    __MODEM_SEL_SIM_NO_PHANTOM_POWER();
#endif //!__SIM800_DS__
#endif //MAX_SIM_COUNT > 1

#if defined(USE_DISCHARGE_MODEM_POWER)
      __DISCHARGE_MODEM_POWER_ON();
#endif //USE_DISCHARGE_MODEM_POWER
      vTaskDelay(5000);
#if defined(USE_DISCHARGE_MODEM_POWER)
      __DISCHARGE_MODEM_POWER_OFF();
#endif //USE_DISCHARGE_MODEM_POWER
  }
  LOG("%s: modem ready\n", this->name);

  ClearAllModemAtFlags();
   send_simple_at("AT\r", 2000);
   send_simple_at("AT\r", 2000);
#if defined(__A7670E__) && defined(USE_MODEM_UART_DMA_RX)
  //send_simple_at("AT+IPR=115200\r", 2000);
  send_simple_at("AT+IPR=460800\r", 2000);//baudrate
  ModemUartDeInit();
  //ModemUartInit(115200, false);
  ModemUartInit(460800, false);
  send_simple_at("AT\r", 2000);
  send_simple_at("AT\r", 2000);
  //send_simple_at("AT+QCFG=\"dbgctl\",0\r", 2000);
#else
  send_simple_at("AT+IPR=115200\r", 2000);//baudrate
#endif //defined(__A7670E__) && defined(USE_MODEM_UART_DMA_RX)
  send_simple_at("AT+IFC=2,2\r", 2000);//hw flow control

#if defined(__A7670E__)
  ModemUartDeInit();
#if defined(__A7670E__) && defined(USE_MODEM_UART_DMA_RX)
  ModemUartInit(460800, true); //�������� ���������� ��������
#else
  ModemUartInit(115200, true); //�������� ���������� ��������
#endif //defined(__A7670E__) && defined(USE_MODEM_UART_DMA_RX)
#endif //defined(__A7670E__)

  ClearAllModemAtFlags();
  vTaskDelay(200);

  int16_t at_res;

  for(uint8_t att=0; att<MAX_SEND_AT_ATTEMPT; att++)
  {
    at_res=send_simple_at("ATE0\r", 2000);//echo off
    if(GSM_RES_OK==at_res) break;
    if(att!=MAX_SEND_AT_ATTEMPT-1) vTaskDelay(200*(att+1));
  }
  if(GSM_RES_OK!=at_res) __PRINTF("%s: Echo off err\n", this->name);

#if defined(__SIM800_DS__) && (MAX_SIM_COUNT > 1)
  //переключаемся на сим 1 для чтения imei
  for(uint8_t att=0; att<MAX_SEND_AT_ATTEMPT; att++)
  {
    at_res=select_default_sim(1);//select the first SIM card

    if(GSM_RES_OK==at_res) break;
    if(att!=MAX_SEND_AT_ATTEMPT-1) vTaskDelay(200*(att+1));
  }
  if(GSM_RES_OK!=at_res) {LOG("%s: select the sim card err\n", this->name);}

  //������ imei
  at_res=get_modem_imie((char*)common_tx_mem, sizeof(common_tx_mem));
  if(GSM_RES_OK==at_res)
  {
    System.Grab(portMAX_DELAY);
    memcpy(System.server_state.IMEI, common_tx_mem, sizeof(System.server_state.IMEI));
    System.server_state.IMEI[sizeof(System.server_state.IMEI)-1]='\0';
    System.Release();

    //сохраняем в базу imei
    Black_box.Grab();
    Black_box.Save_base("imei_backup");
    Black_box.Release();

    LOG("%s: modem imei: %s\n", this->name, System.server_state.IMEI);
  }
  else
  {
    LOG("%s: modem imei read err\n", this->name);
    System.server_state.IMEI[sizeof(System.server_state.IMEI)-1]='\0';
  }

  for(uint8_t att=0; att<MAX_SEND_AT_ATTEMPT; att++)
  {
    if(this->current_sim_id==0)
    {
      //at_res=select_default_sim(1);//select the first SIM card
      //сим 1 уже выбрана
      at_res=GSM_RES_OK;
    }
    else
    {
      at_res=select_default_sim(2);//select the second SIM card
    }

    if(GSM_RES_OK==at_res) break;
    if(att!=MAX_SEND_AT_ATTEMPT-1) vTaskDelay(200*(att+1));
  }
  if(GSM_RES_OK!=at_res) {LOG("%s: select the sim card err\n", this->name);}

#else

  at_res=get_modem_imie((char*)common_tx_mem, sizeof(common_tx_mem));
  if(GSM_RES_OK==at_res)
  {
    System.Grab(portMAX_DELAY);
    memcpy(System.server_state.IMEI, common_tx_mem, sizeof(System.server_state.IMEI));
    System.server_state.IMEI[sizeof(System.server_state.IMEI)-1]='\0';
    System.Release();

    //сохраняем в базу imei
    Black_box.Grab();
    Black_box.Save_base("imei_backup");
    Black_box.Release();

    LOG("%s: modem imei: %s\n", this->name, System.server_state.IMEI);
  }
  else
  {
    LOG("%s: modem imei read err\n", this->name);
    System.server_state.IMEI[sizeof(System.server_state.IMEI)-1]='\0';
  }
#endif //__SIM800_DS__ && (MAX_SIM_COUNT > 1)

  at_res=get_software_inf((char*)common_tx_mem, sizeof(common_tx_mem));
  if(GSM_RES_OK==at_res)
  {
    System.Grab(portMAX_DELAY);
    memcpy(System.server_state.modem_version, common_tx_mem, sizeof(System.server_state.modem_version));
    System.server_state.modem_version[sizeof(System.server_state.modem_version)-1]='\0';
    System.Release();
    LOG("%s: software: %s\n", this->name, System.server_state.modem_version);
  }
  else
  {
    LOG("%s: modem software read err\n", this->name);
    System.server_state.modem_version[0]='\0';
  }

  at_res=get_iccid((char*)common_tx_mem, sizeof(common_tx_mem));
  if(GSM_RES_OK==at_res)
  {
    System.Grab(portMAX_DELAY);
    memcpy(System.server_state.ICCID[this->current_sim_id], common_tx_mem, sizeof(System.server_state.ICCID[this->current_sim_id]));
    System.server_state.ICCID[this->current_sim_id][sizeof(System.server_state.ICCID[this->current_sim_id])-1]='\0';
    System.Release();

    LOG("%s: iccid%hhu: %s\n", this->name, this->current_sim_id+1, System.server_state.ICCID[this->current_sim_id]);
  }
  else
  {
    LOG("%s: iccid%hhu read err\n", this->name, this->current_sim_id+1);
    System.server_state.ICCID[this->current_sim_id][0]='\0';
  }

  for(uint8_t att=0; att<MAX_SEND_AT_ATTEMPT; att++)
  {
    at_res=send_simple_at("AT+CMEE=1\r", 2000);//Error Message Format
    if(GSM_RES_OK==at_res) break;
    if(att!=MAX_SEND_AT_ATTEMPT-1) vTaskDelay(200*(att+1));
  }
  if(GSM_RES_OK!=at_res) __PRINTF("%s: AT+CMEE err\n", this->name);

  for(uint8_t att=0; att<MAX_SEND_AT_ATTEMPT; att++)
  {
    at_res=set_network_sync_time();
    if(GSM_RES_OK==at_res) break;
    if(att!=MAX_SEND_AT_ATTEMPT-1) vTaskDelay(200*(att+1));
  }
  if(GSM_RES_OK!=at_res) __PRINTF("%s: set_network_sync_time err\n", this->name);

  for(uint8_t att=0; att<MAX_SEND_AT_ATTEMPT; att++)
  {
    at_res=creg_urc_extended_mode();
    if(GSM_RES_OK==at_res) break;
    if(att!=MAX_SEND_AT_ATTEMPT-1) vTaskDelay(200*(att+1));
  }
  if(GSM_RES_OK!=at_res) __PRINTF("%s: creg_urc_extended_mode err\n", this->name);

  static const uint8_t coops_att=2;
  for(uint8_t att=0; att<coops_att; att++)
  {
    uint32_t cops_timer=xTaskGetTickCount();
    at_res=operator_present_config();
    LOG("%s: COPS config %s at %u ms\n", this->name, (GSM_RES_OK==at_res)?"ok":"failed", xTaskGetTickCount()-cops_timer);
    if(GSM_RES_OK==at_res) break;
    if(att!=coops_att-1) vTaskDelay(2000*(att+1));
  }
  if(GSM_RES_OK!=at_res) __PRINTF("%s: operator_present_config err\n", this->name);

  for(uint8_t att=0; att<MAX_SEND_AT_ATTEMPT; att++)
  {
    at_res=enable_modem_ext_temp_monitoring();
    if(GSM_RES_OK==at_res) break;
    if(att!=MAX_SEND_AT_ATTEMPT-1) vTaskDelay(200*(att+1));
  }
  if(GSM_RES_OK!=at_res) __PRINTF("%s: enable_modem_ext_temp_monitoring err\n", this->name);

  for(uint8_t att=0; att<MAX_SEND_AT_ATTEMPT; att++)
  {
    at_res=config_modem_tcpip_stack();
    if(GSM_RES_OK==at_res) break;
    if(att!=MAX_SEND_AT_ATTEMPT-1) vTaskDelay(200*(att+1));
  }
  if(GSM_RES_OK!=at_res) __PRINTF("%s: config_modem_tcpip_stack err\n", this->name);


  TGSM_APN* local_apn=(TGSM_APN*)&common_tx_mem[0];

  System.Grab(portMAX_DELAY);
  memcpy(local_apn, &System.connection_settings.APN[this->current_sim_id], sizeof(TGSM_APN));
  apn_settings_digest=crc32_fast_full((uint8_t*)&System.connection_settings.APN[this->current_sim_id], sizeof(System.connection_settings.APN[this->current_sim_id]));
  System.Release();

  local_apn->APN[sizeof(local_apn->APN)-1]='\0';
  local_apn->user[sizeof(local_apn->user)-1]='\0';
  local_apn->password[sizeof(local_apn->password)-1]='\0';

  for(uint8_t att=0; att<MAX_SEND_AT_ATTEMPT; att++)
  {
    at_res=gprs_config(local_apn->user, local_apn->password, local_apn->APN);
    if(GSM_RES_OK==at_res) break;
    if(att!=MAX_SEND_AT_ATTEMPT-1) vTaskDelay(200*(att+1));
  }
  if(GSM_RES_OK!=at_res) __PRINTF("%s: gprs_config err\n", this->name);
  LOG("%s: apn settings (sim id=%hhu), \"%s\", \"%s\", \"%s\" %s\n", this->name, this->current_sim_id, local_apn->APN, local_apn->user, local_apn->password, (GSM_RES_OK==at_res)?("applied"):("not applied"));

  //не использум BT в MT-25K
  this->bt_initialized=0;

  for(uint8_t att=0; att<MAX_SEND_AT_ATTEMPT; att++)
  {
    at_res=jamming_detect_config();
    if(GSM_RES_OK==at_res) break;
    if(att!=MAX_SEND_AT_ATTEMPT-1) vTaskDelay(200*(att+1));
  }
  if(GSM_RES_OK!=at_res) __PRINTF("%s: jamming_detect_config err\n", this->name);
#endif //USE_SIMCOM_MODEM_LIB

#if defined(USE_QUECTEL_MODEM_LIB)
    ResetQuectelLibState();
    ModemUartInit(115200, true);

    __QUECTEL_PWRKEY_PIN_HI();
    vTaskDelay(800);//vTaskDelay(1200);
    __QUECTEL_PWRKEY_PIN_LOW();
    vTaskDelay(2000);

    creg_state_t creg_gsm;
    get_creg_state(&creg_gsm, 0);
    System.Grab(portMAX_DELAY);
    System.server_state.serving_cell.CELLID=creg_gsm.netCellId;
    System.server_state.serving_cell.AcT=creg_gsm.AcT;
    System.server_state.serving_cell.LAC=creg_gsm.netLac;
    System.server_state.serving_cell.RegStat=creg_gsm.regStatus;
    System.server_state.serving_cell.MCC=0;
    System.server_state.serving_cell.MNC=0;
#if defined(YANDEX_EXTENDED_SENSORS_PRESENT)
    System.server_state.ext_serving_cells_info[0]='\0';
    System.server_state.scan_mode=AUTO_SCAN_MODE;
#endif //defined(YANDEX_EXTENDED_SENSORS_PRESENT)

    System.server_state.signal_rssi=get_rssi_level();
    System.server_state.signal_dbm=-120;

    System.server_state.jammed=0;
    System.Release();

    __PRINTF("%s: waiting status pin hi level signal....\n", this->name);

    for(uint16_t i=0; i<300; i++)
    {
      if(__GET_QUECTEL_STATUS_PIN_STATE()) break;
      vTaskDelay(100);
    }

    if(__GET_QUECTEL_STATUS_PIN_STATE())
    {
      __PRINTF("%s: status pin hi level signal ok, waiting +CFUN: 1\n", this->name);

      WaitModemFlags(RDY_FGSM, 10000);

      set_uart_urcport();

      if(WaitModemFlags(CFUN_X_FGSM, 10000))
      {
        uint8_t cfun_stae;
        get_cfun_stae(&cfun_stae, 0);
        if(cfun_stae!=1) cfun_config(1, 0);

        __PRINTF("%s: +CFUN: 1 ok, wait sim, call, sms ready...\n", this->name);

        if(/*this->current_sim_id==0 && */WaitModemFlags(SIMREADY_FGSM|SMS_READY_FGSM|CALL_READY_FGSM|CPIN_NOT_INSERTED_FGSM, 45000) && WaitModemFlags(SMS_READY_FGSM|CPIN_NOT_INSERTED_FGSM, 65000) && WaitModemFlags(CALL_READY_FGSM|CPIN_NOT_INSERTED_FGSM, 65000) )
        {
          if(!ReadModemAtFlag(CPIN_NOT_INSERTED_FGSM))
          {
            __PRINTF("%s: sim (id %hhu), call, sms ready ok\n", this->name, this->current_sim_id);
            break;
          }
        }

        LOG("%s: sim (id %hhu) or call or sms ready err\n", this->name, this->current_sim_id);
        if(GSM_RES_OK!=soft_switch_off_modem())
        {
          vTaskDelay(5000);
          soft_switch_off_modem();
          wait_staus_pin(0, 8000);
        }
        __MODEM_POWER_DIS();
#if MAX_SIM_COUNT > 1
        if(this->current_sim_id==0) this->desired_sim_id=1;
        else                        this->desired_sim_id=0;
#endif //MAX_SIM_COUNT > 1
      }
      else
      {
        LOG("%s: +CFUN: 1 err\n", this->name);

        send_simple_at("AT\r", 2000);
        send_simple_at("AT\r", 2000);
        send_simple_at("AT+IPR=115200\r", 2000);//baudrate
        send_simple_at("AT+IFC=2,2\r", 2000);//hw flow control
        send_simple_at("AT&W\r", 2000);//save

        vTaskDelay(200);
        soft_switch_off_modem();
        wait_staus_pin(0, 8000);
        __MODEM_POWER_DIS();
      }
    }
    else
    {
      LOG("%s: status pin hi level signal err\n", this->name);
      __MODEM_POWER_DIS();
    }

    ModemUartDeInit();

#if MAX_SIM_COUNT > 1
#if (!defined(__SIM800_DS__))
    __MODEM_SEL_SIM_NO_PHANTOM_POWER();
#endif //!__SIM800_DS__
#endif //MAX_SIM_COUNT > 1

#if defined(USE_DISCHARGE_MODEM_POWER)
      __DISCHARGE_MODEM_POWER_ON();
#endif //USE_DISCHARGE_MODEM_POWER
      vTaskDelay(5000);
#if defined(USE_DISCHARGE_MODEM_POWER)
      __DISCHARGE_MODEM_POWER_OFF();
#endif //USE_DISCHARGE_MODEM_POWER
  }
  LOG("%s: modem ready\n", this->name);

  ClearAllModemAtFlags();
  send_simple_at("AT\r", 2000);
  send_simple_at("AT\r", 2000);
#if defined(__EC21_X__) && defined(USE_MODEM_UART_DMA_RX)
  //send_simple_at("AT+IPR=115200\r", 2000);
  send_simple_at("AT+IPR=460800\r", 2000);//baudrate
  ModemUartDeInit();
  //ModemUartInit(115200, true);
  ModemUartInit(460800, true);
  send_simple_at("AT\r", 2000);
  send_simple_at("AT\r", 2000);
  //send_simple_at("AT+QCFG=\"dbgctl\",0\r", 2000);
#else
  send_simple_at("AT+IPR=115200\r", 2000);//baudrate
#endif //defined(__EC21_X__) && defined(USE_MODEM_UART_DMA_RX)
  send_simple_at("AT+IFC=2,2\r", 2000);//hw flow control

  ClearAllModemAtFlags();
  vTaskDelay(200);

  int16_t at_res;

  for(uint8_t att=0; att<MAX_SEND_AT_ATTEMPT; att++)
  {
    at_res=send_simple_at("ATE0\r", 2000);//echo off
    if(GSM_RES_OK==at_res) break;
    if(att!=MAX_SEND_AT_ATTEMPT-1) vTaskDelay(200*(att+1));
  }
  if(GSM_RES_OK!=at_res) __PRINTF("%s: Echo off err\n", this->name);

#if defined(__SIM800_DS__) && (MAX_SIM_COUNT > 1)
  //переключаемся на сим 1 для чтения imei
  for(uint8_t att=0; att<MAX_SEND_AT_ATTEMPT; att++)
  {
    at_res=select_default_sim(1);//select the first SIM card

    if(GSM_RES_OK==at_res) break;
    if(att!=MAX_SEND_AT_ATTEMPT-1) vTaskDelay(200*(att+1));
  }
  if(GSM_RES_OK!=at_res) {LOG("%s: select the sim card err\n", this->name);}

  //читаем imei
  at_res=get_modem_imie((char*)common_tx_mem, sizeof(common_tx_mem));
  if(GSM_RES_OK==at_res)
  {
    System.Grab(portMAX_DELAY);
    memcpy(System.server_state.IMEI, common_tx_mem, sizeof(System.server_state.IMEI));
    System.server_state.IMEI[sizeof(System.server_state.IMEI)-1]='\0';
    System.Release();

    //сохраняем в базу imei
    Black_box.Grab();
    Black_box.Save_base("imei_backup");
    Black_box.Release();

    LOG("%s: modem imei: %s\n", this->name, System.server_state.IMEI);
  }
  else
  {
    LOG("%s: modem imei read err\n", this->name);
    System.server_state.IMEI[sizeof(System.server_state.IMEI)-1]='\0';
  }

  //добавить проверку кол-ва симкарт
  for(uint8_t att=0; att<MAX_SEND_AT_ATTEMPT; att++)
  {
    if(this->current_sim_id==0)
    {
      //at_res=select_default_sim(1);//select the first SIM card
      //сим 1 уже выбрана
      at_res=GSM_RES_OK;
    }
    else
    {
      at_res=select_default_sim(2);//select the second SIM card
    }

    if(GSM_RES_OK==at_res) break;
    if(att!=MAX_SEND_AT_ATTEMPT-1) vTaskDelay(200*(att+1));
  }
  if(GSM_RES_OK!=at_res) {LOG("%s: select the sim card err\n", this->name);}

#else

  at_res=get_modem_imie((char*)common_tx_mem, sizeof(common_tx_mem));
  if(GSM_RES_OK==at_res)
  {
    System.Grab(portMAX_DELAY);
    memcpy(System.server_state.IMEI, common_tx_mem, sizeof(System.server_state.IMEI));
    System.server_state.IMEI[sizeof(System.server_state.IMEI)-1]='\0';
    System.Release();

    //сохраняем в базу imei
    Black_box.Grab();
    Black_box.Save_base("imei_backup");
    Black_box.Release();

    LOG("%s: modem imei: %s\n", this->name, System.server_state.IMEI);
  }
  else
  {
    LOG("%s: modem imei read err\n", this->name);
    System.server_state.IMEI[sizeof(System.server_state.IMEI)-1]='\0';
  }
#endif //__SIM800_DS__ && (MAX_SIM_COUNT > 1)

  at_res=get_software_inf((char*)common_tx_mem, sizeof(common_tx_mem));
  if(GSM_RES_OK==at_res)
  {
    System.Grab(portMAX_DELAY);
    memcpy(System.server_state.modem_version, common_tx_mem, sizeof(System.server_state.modem_version));
    System.server_state.modem_version[sizeof(System.server_state.modem_version)-1]='\0';
    System.Release();
    LOG("%s: software: %s\n", this->name, System.server_state.modem_version);
  }
  else
  {
    LOG("%s: modem software read err\n", this->name);
    System.server_state.modem_version[0]='\0';
  }

  at_res=get_iccid((char*)common_tx_mem, sizeof(common_tx_mem));
  if(GSM_RES_OK==at_res)
  {
    System.Grab(portMAX_DELAY);
    memcpy(System.server_state.ICCID[this->current_sim_id], common_tx_mem, sizeof(System.server_state.ICCID[this->current_sim_id]));
    System.server_state.ICCID[this->current_sim_id][sizeof(System.server_state.ICCID[this->current_sim_id])-1]='\0';
    System.Release();

    LOG("%s: iccid%hhu: %s\n", this->name, this->current_sim_id+1, System.server_state.ICCID[this->current_sim_id]);
  }
  else
  {
    LOG("%s: iccid%hhu read err\n", this->name, this->current_sim_id+1);
    System.server_state.ICCID[this->current_sim_id][0]='\0';
  }

  for(uint8_t att=0; att<MAX_SEND_AT_ATTEMPT; att++)
  {
    at_res=send_simple_at("AT+CMEE=1\r", 2000);//Error Message Format
    if(GSM_RES_OK==at_res) break;
    if(att!=MAX_SEND_AT_ATTEMPT-1) vTaskDelay(200*(att+1));
  }
  if(GSM_RES_OK!=at_res) __PRINTF("%s: AT+CMEE err\n", this->name);

  for(uint8_t att=0; att<MAX_SEND_AT_ATTEMPT; att++)
  {
    at_res=set_network_sync_time();
    if(GSM_RES_OK==at_res) break;
    if(att!=MAX_SEND_AT_ATTEMPT-1) vTaskDelay(200*(att+1));
  }
  if(GSM_RES_OK!=at_res) __PRINTF("%s: set_network_sync_time err\n", this->name);

  for(uint8_t att=0; att<MAX_SEND_AT_ATTEMPT; att++)
  {
    at_res=creg_urc_extended_mode();
    if(GSM_RES_OK==at_res) break;
    if(att!=MAX_SEND_AT_ATTEMPT-1) vTaskDelay(200*(att+1));
  }
  if(GSM_RES_OK!=at_res) __PRINTF("%s: creg_urc_extended_mode err\n", this->name);

  static const uint8_t coops_att=2;
  for(uint8_t att=0; att<coops_att; att++)
  {
    uint32_t cops_timer=xTaskGetTickCount();
    at_res=operator_present_config();
    LOG("%s: COPS config %s at %u ms\n", this->name, (GSM_RES_OK==at_res)?"ok":"failed", xTaskGetTickCount()-cops_timer);
    if(GSM_RES_OK==at_res) break;
    if(att!=coops_att-1) vTaskDelay(2000*(att+1));
  }
  if(GSM_RES_OK!=at_res) __PRINTF("%s: operator_present_config err\n", this->name);

  for(uint8_t att=0; att<MAX_SEND_AT_ATTEMPT; att++)
  {
    at_res=enable_modem_ext_temp_monitoring();
    if(GSM_RES_OK==at_res) break;
    if(att!=MAX_SEND_AT_ATTEMPT-1) vTaskDelay(200*(att+1));
  }
  if(GSM_RES_OK!=at_res) __PRINTF("%s: enable_modem_ext_temp_monitoring err\n", this->name);

  for(uint8_t att=0; att<MAX_SEND_AT_ATTEMPT; att++)
  {
    at_res=config_modem_tcpip_stack();
    if(GSM_RES_OK==at_res) break;
    if(att!=MAX_SEND_AT_ATTEMPT-1) vTaskDelay(200*(att+1));
  }
  if(GSM_RES_OK!=at_res) __PRINTF("%s: config_modem_tcpip_stack err\n", this->name);


  TGSM_APN* local_apn=(TGSM_APN*)&common_tx_mem[0];

  System.Grab(portMAX_DELAY);
  memcpy(local_apn, &System.connection_settings.APN[this->current_sim_id], sizeof(TGSM_APN));
  apn_settings_digest=crc32_fast_full((uint8_t*)&System.connection_settings.APN[this->current_sim_id], sizeof(System.connection_settings.APN[this->current_sim_id]));
  System.Release();

  local_apn->APN[sizeof(local_apn->APN)-1]='\0';
  local_apn->user[sizeof(local_apn->user)-1]='\0';
  local_apn->password[sizeof(local_apn->password)-1]='\0';

  if(is_enable_set_minimum_functionality_for_set_apn())
  {
    if(GSM_RES_OK!=cfun_config(4, 0)) {LOG("%s: setting cfun=4 err\n", this->name);}
  }

  for(uint8_t att=0; att<MAX_SEND_AT_ATTEMPT; att++)
  {
    at_res=gprs_config(local_apn->user, local_apn->password, local_apn->APN);
    if(GSM_RES_OK==at_res) break;
    if(att!=MAX_SEND_AT_ATTEMPT-1) vTaskDelay(200*(att+1));
  }
  if(GSM_RES_OK!=at_res) __PRINTF("%s: gprs_config err\n", this->name);

  LOG("%s: apn settings (sim id=%hhu), \"%s\", \"%s\", \"%s\" %s\n", this->name, this->current_sim_id, local_apn->APN, local_apn->user, local_apn->password, (GSM_RES_OK==at_res)?("applied"):("not applied"));

  if(is_enable_set_minimum_functionality_for_set_apn())
  {
    if(GSM_RES_OK!=cfun_config(1, 0)) {LOG("%s: setting cfun=1 err\n", this->name);}
  }

#if defined(FORCED_LTE_MODE_ONLY)
  for(uint8_t att=0; att<MAX_SEND_AT_ATTEMPT; att++)
  {
    at_res=network_search_mode_configuration(LTE_ONLY_SCAN_MODE);
    if(GSM_RES_OK==at_res) break;
    if(att!=MAX_SEND_AT_ATTEMPT-1) vTaskDelay(200*(att+1));
  }
  if(GSM_RES_OK!=at_res)
  {
    LOG("%s: enter LTE ONLY MODE err\n", this->name);
  }
  else
  {
    LOG("%s: enter LTE ONLY MODE ok\n", this->name);
  }
#endif //FORCED_LTE_MODE_ONLY

  for(uint8_t att=0; att<MAX_SEND_AT_ATTEMPT; att++)
  {
    at_res=jamming_detect_config();
    if(GSM_RES_OK==at_res) break;
    if(att!=MAX_SEND_AT_ATTEMPT-1) vTaskDelay(200*(att+1));
  }
  if(GSM_RES_OK!=at_res) __PRINTF("%s: jamming_detect_config err\n", this->name);
#endif //USE_QUECTEL_MODEM_LIB

#if MAX_SIM_COUNT > 1
  this->force_change_sim=0;
#endif //MAX_SIM_COUNT > 1

  this->modem_initialized=1;

#if defined(GSM_USB_FORWARDING)
#warning GSM_USB_FORWARDING is enabled

  static uint8_t buff[1024];
  modem_uart_rx_t* modem_uart_rx=GetModemUartRxStructPtr();
  int16_t len;

  modem_uart_rx->is_init=0;//"suspend" modem_at_parse
  vTaskDelay(200);
  USB_CDC_Init();
  System.server_state.usb_connected=1;
  for(;;)
  {
    xSemaphoreTake(*modem_uart_rx->sync_obj, 10);
    len=filled_cbuff_len(&modem_uart_rx->cbuff);
    if(len>sizeof(buff)) len=sizeof(buff);
    if(len>0)
    {
      read_from_cbuff(&modem_uart_rx->cbuff, buff, len);
      if(free_cbuff_len(&modem_uart_rx->cbuff)>MODEM_RX_BUFF_WM)
      {
        __MODEM_UART_SOFT_RTS_PIN_LOW();
      }
      USB_CDC_Send(buff, len, 100);
    }

    len=USB_CDC_Receive(buff, sizeof(buff), 5);
    if(len>0)
    {
      WriteToModemUart(buff, len, 1000);
    }
  }
#endif
  }

// Деинициализация менеджера
void CSERVER_manager::Deinit(void)
{
  LedG_Off();

  for(uint8_t i=0; i<SERVER_TCP_CNT; i++)
  {
    System.server_state.tcp_connect_state[i]=0;
  }

#if defined(BT3_PRESENT)
  if(this->bt_initialized)
  {
    if(!(bt_ctx.protocol_type==VOID_PROTOCOL_TYPE || bt_ctx.server_ctx_state==WAIT_NEXT_SESSION)) bt_ctx.common_const->socket_close(bt_ctx.conn_ctx_id);
    BtPower(0);
  }
#endif //defined(BT3_PRESENT)

  if(this->modem_initialized)
  {
    for(uint8_t i=0; i<SERVER_TCP_CNT; i++)
    {
      if(!(conn_ctx[i].protocol_type==VOID_PROTOCOL_TYPE || conn_ctx[i].server_ctx_state==WAIT_NEXT_SESSION)) conn_ctx[i].common_const->socket_close(conn_ctx[i].conn_ctx_id);
    }
    soft_switch_off_modem();
    wait_staus_pin(0, 8000);
  }

#if defined(USE_CINTERION_MODEM_LIB)
  ResetCenterionLibState();
#endif //USE_CINTERION_MODEM_LIB

#if defined(USE_SIMCOM_MODEM_LIB)
  ResetSimcomLibState();
#endif //USE_SIMCOM_MODEM_LIB

#if defined(USE_QUECTEL_MODEM_LIB)
  ResetQuectelLibState();
#endif //USE_QUECTEL_MODEM_LIB

  creg_state_t creg_gsm;
  get_creg_state(&creg_gsm, 0);
  System.Grab(portMAX_DELAY);
  System.server_state.serving_cell.CELLID=creg_gsm.netCellId;
  System.server_state.serving_cell.AcT=creg_gsm.AcT;
  System.server_state.serving_cell.LAC=creg_gsm.netLac;
  System.server_state.serving_cell.RegStat=creg_gsm.regStatus;
  System.server_state.serving_cell.MCC=0;
  System.server_state.serving_cell.MNC=0;
#if defined(YANDEX_EXTENDED_SENSORS_PRESENT)
  System.server_state.ext_serving_cells_info[0]='\0';
  System.server_state.scan_mode=AUTO_SCAN_MODE;
#endif //defined(YANDEX_EXTENDED_SENSORS_PRESENT)

  System.server_state.signal_rssi=get_rssi_level();
  System.server_state.signal_dbm=-120;

  System.server_state.jammed=0;
  System.Release();

  ModemUartDeInit();
  __MODEM_POWER_DIS();

  this->Modem_pins_deinit();
  this->modem_initialized=0;

#if defined(USE_SIMCOM_MODEM_LIB)
  this->bt_initialized=0;
#endif //USE_SIMCOM_MODEM_LIB

  if(!this->is_man_reinit)
  {
    //ожидаем пока уснет задача конфигуратора
    LOG("%s: manager deinit, waiting configurator fall asleep\n", this->name);
    SERVER_manager.configurator_task_sleep_state=1;
#if (!defined(DISABLE_CONFIGURATOR_TASK))
    while(SERVER_manager.configurator_task_sleep_state!=2) vTaskDelay(50);
#endif
    SERVER_manager.configurator_task_sleep_state=0;
    LOG("%s: ready for sleep\n", this->name);
    this->sleep_cmd=0;

    System.server_state.is_on=0;
  }
}

#if (MAX_SIM_COUNT > 1) && (defined(USE_FAST_SIM_CHANGE))
#if defined(__SIM800_DS__)
void CSERVER_manager::Fast_sim_change(void)
{
  int16_t at_res;
  uint8_t default_sim, first_sim_present, second_sim_present;

  at_res=get_sim_status(&default_sim, &first_sim_present, &second_sim_present);

  if(GSM_RES_OK!=at_res)
  {
    LOG("%s: get sim card status err, restart manager...\n", this->name);

    if(this->desired_sim_id==0) this->desired_sim_id=1;
    else                        this->desired_sim_id=0;

    this->is_man_reinit=1;

    return;
  }

  default_sim--;//convert to id

  LOG("%s: curr sim id: %hhu, first: %s, second: %s\n", this->name, default_sim, (first_sim_present)?("available"):("not available"), (second_sim_present)?("available"):("not available"));

  if((this->desired_sim_id==0 && first_sim_present) || \
    (this->desired_sim_id==1 && second_sim_present))
  {
    for(uint8_t i=0; i<SERVER_TCP_CNT; i++)
    {
      System.server_state.tcp_connect_state[i]=0;
      if(!(conn_ctx[i].protocol_type==VOID_PROTOCOL_TYPE || conn_ctx[i].server_ctx_state==WAIT_NEXT_SESSION)) conn_ctx[i].common_const->socket_close(conn_ctx[i].conn_ctx_id);

      conn_ctx[i].server_ctx_state=WAIT_NEXT_SESSION;
      conn_ctx[i].start_next_session_timeMS=xTaskGetTickCount()+2000;
      conn_ctx[i].conn_fail_counter=0;
    }

    ResetSimcomLibState();

    creg_state_t creg_gsm;
    get_creg_state(&creg_gsm, 0);
    System.Grab(portMAX_DELAY);
    System.server_state.serving_cell.CELLID=creg_gsm.netCellId;
    System.server_state.serving_cell.AcT=creg_gsm.AcT;
    System.server_state.serving_cell.LAC=creg_gsm.netLac;
    System.server_state.serving_cell.RegStat=creg_gsm.regStatus;
    System.server_state.serving_cell.MCC=0;
    System.server_state.serving_cell.MNC=0;
#if defined(YANDEX_EXTENDED_SENSORS_PRESENT)
    System.server_state.ext_serving_cells_info[0]='\0';
    System.server_state.scan_mode=AUTO_SCAN_MODE;
#endif //defined(YANDEX_EXTENDED_SENSORS_PRESENT)

    System.server_state.signal_rssi=get_rssi_level();
    System.server_state.signal_dbm=-120;

    System.server_state.jammed=0;
    System.Release();

    at_res=select_default_sim(this->desired_sim_id+1);

    if(GSM_RES_OK!=at_res)
    {
      LOG("%s: select the sim card err\n", this->name);

      //возвращаем обратну желаемую сим
      if(this->desired_sim_id==0) this->desired_sim_id=1;
      else                        this->desired_sim_id=0;

      this->is_man_reinit=1;

      return;
    }
  }
  else
  {
    LOG("%s: no sim for change\n", this->name);

    //возвращаем обратну желаемую сим
    if(this->desired_sim_id==0) this->desired_sim_id=1;
    else                        this->desired_sim_id=0;

    if(!this->force_change_sim)
    {
      this->is_man_reinit=1;
    }

    return;
  }

  this->current_sim_id=this->desired_sim_id;
  System.server_state.used_sim=this->current_sim_id+1;

  at_res=get_iccid((char*)common_tx_mem, sizeof(common_tx_mem));
  if(GSM_RES_OK==at_res)
  {
    System.Grab(portMAX_DELAY);
    memcpy(System.server_state.ICCID[this->current_sim_id], common_tx_mem, sizeof(System.server_state.ICCID[this->current_sim_id]));
    System.server_state.ICCID[this->current_sim_id][sizeof(System.server_state.ICCID[this->current_sim_id])-1]='\0';
    System.Release();

    LOG("%s: iccid%hhu: %s\n", this->name, this->current_sim_id+1, System.server_state.ICCID[this->current_sim_id]);
  }
  else
  {
    LOG("%s: iccid%hhu read err\n", this->name, this->current_sim_id+1);
    System.server_state.ICCID[this->current_sim_id][0]='\0';
  }

  TGSM_APN* local_apn=(TGSM_APN*)&common_tx_mem[0];

  System.Grab(portMAX_DELAY);
  memcpy(local_apn, &System.connection_settings.APN[this->current_sim_id], sizeof(TGSM_APN));
  apn_settings_digest=crc32_fast_full((uint8_t*)&System.connection_settings.APN[this->current_sim_id], sizeof(System.connection_settings.APN[this->current_sim_id]));
  System.Release();

  local_apn->APN[sizeof(local_apn->APN)-1]='\0';
  local_apn->user[sizeof(local_apn->user)-1]='\0';
  local_apn->password[sizeof(local_apn->password)-1]='\0';

  for(uint8_t att=0; att<MAX_SEND_AT_ATTEMPT; att++)
  {
    at_res=gprs_config(local_apn->user, local_apn->password, local_apn->APN);
    if(GSM_RES_OK==at_res) break;
    if(att!=MAX_SEND_AT_ATTEMPT-1) vTaskDelay(200*(att+1));
  }
  if(GSM_RES_OK!=at_res) __PRINTF("%s: gprs_config err\n", this->name);

  LOG("%s: apn settings (sim id=%hhu), \"%s\", \"%s\", \"%s\" %s\n", this->name, this->current_sim_id, local_apn->APN, local_apn->user, local_apn->password, (GSM_RES_OK==at_res)?("applied"):("not applied"));

  cfun_config(1, 0);//без этой команды была ошибка +CME ERROR: 797 (CFUN state is 0 or 4)

  static const uint8_t coops_att=2;
  for(uint8_t att=0; att<coops_att; att++)
  {
    uint32_t cops_timer=xTaskGetTickCount();
    at_res=operator_present_config();
    LOG("%s: COPS config %s at %u ms\n", this->name, (GSM_RES_OK==at_res)?"ok":"failed", xTaskGetTickCount()-cops_timer);
    if(GSM_RES_OK==at_res) break;
    if(att!=coops_att-1) vTaskDelay(2000*(att+1));
  }

  creg_state_t creg_gsm;
  if(this->current_sim_id==0)    get_ds_creg_state(&creg_gsm, NULL, 1);
  else                           get_ds_creg_state(NULL, &creg_gsm, 1);
}
#endif //defined(__SIM800_DS__)

#if defined(USE_QUECTEL_MODEM_LIB)
#if (defined(__MC60__))
#error MC60 not support USE_FAST_SIM_CHANGE
#endif //(defined(__MC60__))
void CSERVER_manager::Fast_sim_change(void)
{
  for(uint8_t i=0; i<SERVER_TCP_CNT; i++)
  {
    System.server_state.tcp_connect_state[i]=0;
    if(!(conn_ctx[i].protocol_type==VOID_PROTOCOL_TYPE || conn_ctx[i].server_ctx_state==WAIT_NEXT_SESSION)) conn_ctx[i].common_const->socket_close(conn_ctx[i].conn_ctx_id);

    conn_ctx[i].server_ctx_state=WAIT_NEXT_SESSION;
    conn_ctx[i].start_next_session_timeMS=xTaskGetTickCount()+2000;
    conn_ctx[i].conn_fail_counter=0;
  }

  for(uint8_t change_sim_attempt=2; ; )
  {
    if(GSM_RES_OK!=cfun_config(0, 0)) {LOG("%s: setting cfun=0 err\n", this->name);}

    ResetQuectelLibState();

    creg_state_t creg_gsm;
    get_creg_state(&creg_gsm, 0);
    System.Grab(portMAX_DELAY);
    System.server_state.serving_cell.CELLID=creg_gsm.netCellId;
    System.server_state.serving_cell.AcT=creg_gsm.AcT;
    System.server_state.serving_cell.LAC=creg_gsm.netLac;
    System.server_state.serving_cell.RegStat=creg_gsm.regStatus;
    System.server_state.serving_cell.MCC=0;
    System.server_state.serving_cell.MNC=0;
#if defined(YANDEX_EXTENDED_SENSORS_PRESENT)
    System.server_state.ext_serving_cells_info[0]='\0';
    System.server_state.scan_mode=AUTO_SCAN_MODE;
#endif //defined(YANDEX_EXTENDED_SENSORS_PRESENT)

    System.server_state.signal_rssi=get_rssi_level();
    System.server_state.signal_dbm=-120;

    System.server_state.jammed=0;
    System.Release();

    if(this->desired_sim_id==0) {__MODEM_SEL_SIM_0();}
    else                        {__MODEM_SEL_SIM_1();}

    this->current_sim_id=this->desired_sim_id;
    System.server_state.used_sim=this->current_sim_id+1;

    TGSM_APN* local_apn=(TGSM_APN*)&common_tx_mem[0];

    System.Grab(portMAX_DELAY);
    memcpy(local_apn, &System.connection_settings.APN[this->current_sim_id], sizeof(TGSM_APN));
    apn_settings_digest=crc32_fast_full((uint8_t*)&System.connection_settings.APN[this->current_sim_id], sizeof(System.connection_settings.APN[this->current_sim_id]));
    System.Release();

    local_apn->APN[sizeof(local_apn->APN)-1]='\0';
    local_apn->user[sizeof(local_apn->user)-1]='\0';
    local_apn->password[sizeof(local_apn->password)-1]='\0';

    int16_t at_res;
    for(uint8_t att=0; att<MAX_SEND_AT_ATTEMPT; att++)
    {
      at_res=gprs_config(local_apn->user, local_apn->password, local_apn->APN);
      if(GSM_RES_OK==at_res) break;
      if(att!=MAX_SEND_AT_ATTEMPT-1) vTaskDelay(200*(att+1));
    }
    if(GSM_RES_OK!=at_res) __PRINTF("%s: gprs_config err\n", this->name);

    LOG("%s: apn settings (sim id=%hhu), \"%s\", \"%s\", \"%s\" %s\n", this->name, this->current_sim_id, local_apn->APN, local_apn->user, local_apn->password, (GSM_RES_OK==at_res)?("applied"):("not applied"));

    LOG("%s: set up full functionality with sim id %hhu\n", this->name, this->current_sim_id);

    if(GSM_RES_OK!=cfun_config(1, 0)) {LOG("%s: setting cfun=1 err\n", this->name);}

    send_simple_at("AT+CPIN?\r", 6000);

    if(!get_sim_failure_status())
    {
      if(WaitModemFlags(SIMREADY_FGSM|SMS_READY_FGSM|CALL_READY_FGSM|CPIN_NOT_INSERTED_FGSM, 45000) && WaitModemFlags(SMS_READY_FGSM|CPIN_NOT_INSERTED_FGSM, 65000) && WaitModemFlags(CALL_READY_FGSM|CPIN_NOT_INSERTED_FGSM, 65000) )
      {
        if(!ReadModemAtFlag(CPIN_NOT_INSERTED_FGSM))
        {
          LOG("%s: sim (id %hhu), call, sms ready ok\n", this->name, this->current_sim_id);

          at_res=get_iccid((char*)common_tx_mem, sizeof(common_tx_mem));
          if(GSM_RES_OK==at_res)
          {
            System.Grab(portMAX_DELAY);
            memcpy(System.server_state.ICCID[this->current_sim_id], common_tx_mem, sizeof(System.server_state.ICCID[this->current_sim_id]));
            System.server_state.ICCID[this->current_sim_id][sizeof(System.server_state.ICCID[this->current_sim_id])-1]='\0';
            System.Release();

            LOG("%s: iccid%hhu: %s\n", this->name, this->current_sim_id+1, System.server_state.ICCID[this->current_sim_id]);
          }
          else
          {
            LOG("%s: iccid%hhu read err\n", this->name, this->current_sim_id+1);
            System.server_state.ICCID[this->current_sim_id][0]='\0';
          }

          break;
        }
      }
    }
    else
    {
      LOG("%s: sim (id %hhu) not inserted...\n", this->name, this->current_sim_id);
    }

    if(this->Wait_message(0))
    {
      if(this->input_message.code==COMMAND_SLEEP)
      {
        __PRINTF("%s: recv sleep cmd\n", this->name);
        this->sleep_cmd=1;
        return;
      }
    }

    change_sim_attempt--;

    if(!change_sim_attempt)
    {
      //если попали сюда, значит не смогли вернутся на туже сим с которой начинали переключение
      LOG("%s: sim change fail, restart manager\n", this->name);
      this->is_man_reinit=1;
      return;
    }

    if(this->current_sim_id==0) this->desired_sim_id=1;
    else                        this->desired_sim_id=0;
  }
}
#endif //defined(USE_QUECTEL_MODEM_LIB)

#if defined(USE_CINTERION_MODEM_LIB)
#error not support on BGS-2, EHS-5
/*
Notes: No guarantee can be given, nor any liability accepted, if loss of data is encountered after
removing the SIM card during operation.
Also, no guarantee can be given for properly initialising any SIM card that the user inserts after
having removed a SIM card during operation. In this case, the application must restart BGS2-E/BGS2-W.
If using a SIM card holder without detecting contact please be sure to switch off the module
before removing the SIM Card or inserting a new one.
*/
#endif //defined(USE_CINTERION_MODEM_LIB)
#endif //(MAX_SIM_COUNT > 1) && (defined(USE_FAST_SIM_CHANGE))

#define NONE_POST_ACTION              0
#define REBOOT_DEVICE_POST_ACTION     1
#define REBOOT_MODEM_POST_ACTION      2
#define FORMAT_MEMORY_POST_ACTION     3
#define BBOX_CLEAR_POST_ACTION        4
void CSERVER_manager::Sms_handler(void)
{
  int16_t res;
  sms_inf_t sms_inf;
  res=QuerySms(&sms_inf);
  if(res==GSM_RES_OK && sms_inf.used && sms_inf.total)
  {
    res=ReadSmsConfig();
    if(res==GSM_RES_OK)
    {
      uint8_t processed_count=0;
      for(uint16_t idx=1; idx<=sms_inf.total; idx++)
      {
        uint8_t post_action=NONE_POST_ACTION;

        const uint8_t phone_mem_size=sizeof(System.security_settings.autorized_phones[0]);
        char* phone=(char*)&common_tx_mem[sizeof(common_tx_mem)-phone_mem_size];

        const uint8_t max_sms_len_in_7bit=160;

        const uint16_t sms_heap_mem_size=max_sms_len_in_7bit+1;
        char* sms_heap_mem=(char*)&common_tx_mem[sizeof(common_tx_mem)-phone_mem_size-sms_heap_mem_size];

        const uint16_t ans_sms1_mem_size=max_sms_len_in_7bit+1;
        char* ans_sms1_mem=(char*)&common_tx_mem[sizeof(common_tx_mem)-phone_mem_size-sms_heap_mem_size-ans_sms1_mem_size];

        const uint16_t ans_sms2_mem_size=max_sms_len_in_7bit+1;
        char* ans_sms2_mem=(char*)&common_tx_mem[sizeof(common_tx_mem)-phone_mem_size-sms_heap_mem_size-ans_sms1_mem_size-ans_sms2_mem_size];

        sms_udh_chunks_inf_t chunks_inf;
        uint8_t is_emty=0;
        uint8_t is_allready_deleted=0;
        res=ReadSms(idx, sms_heap_mem, sms_heap_mem_size, &is_emty, phone, phone_mem_size, &chunks_inf);
        sms_heap_mem[sms_heap_mem_size-1]='\0';
        phone[phone_mem_size-1]='\0';
        if(res<0)
        {
          __PRINTF("%s: read sms err, idx=%hhu\n", this->name, idx);
        }
        else if(res==0 && !is_emty)
        {
          __PRINTF("%s: sms can't decoding, idx=%hhu, phone: %s\n", this->name, idx, phone);
        }
        else if(res==0 && is_emty)
        {
          __PRINTF("%s: sms emty, idx=%hhu\n", this->name, idx);
        }
        else
        {
          uint8_t pin_len;
          uint8_t is_accessed=0;
          System.Grab(portMAX_DELAY);
          pin_len=strnlen(System.security_settings.pin, sizeof(System.security_settings.pin));
          if(res>(pin_len+sizeof("@:")-1) && sms_heap_mem[0]=='@' && sms_heap_mem[pin_len+1]==':' && memcmp(&sms_heap_mem[1], System.security_settings.pin, pin_len)==0) {is_accessed=1;}
          System.Release();

          if(is_accessed)
          {
            for(uint8_t j=0; j<pin_len; j++) sms_heap_mem[1+j]='*';
          }

          __CHAR_BUFF_PRINTF(sms_heap_mem, res, "%s: sms len=%hu, idx=%hhu, phone: %s, uid=%hhu, tot_chunks=%hhu, curr_chunk=%hhu\n", this->name, res, idx, phone, chunks_inf.uid, chunks_inf.total, chunks_inf.current);

#if defined(FORCED_LTE_MODE_ONLY)
          is_accessed=0;
#endif //FORCED_LTE_MODE_ONLY

          if(is_accessed)
          {
            struct
            {
              uint8_t is_phone_valid:1;
              uint8_t is_sms_send_en:1;
            }ans_flags=
            {
              .is_phone_valid=0,
              .is_sms_send_en=0,
            };

            const uint8_t phone_len=strlen(phone);

            if(phone_len)
            {
              uint8_t i;
              for(i=0; i<phone_len; i++)
              {
                if(i==0)
                {
                  if(!(phone[i]=='+') && !(phone[i]>='0' && phone[i]<='9')) break;
                }
                else
                {
                  if(!(phone[i]>='0' && phone[i]<='9')) break;
                }
              }
              if(i==phone_len) ans_flags.is_phone_valid=1;
            }

            char* cmd=sms_heap_mem+pin_len+sizeof("@:")-1;
            uint8_t cmd_len=strlen(cmd);

            uint32_t cmd_expiration_time=0;
            const char* cmd_expiration_time_str=strstr(cmd, "/t:");

            if(cmd_expiration_time_str!=NULL && cmd_expiration_time_str[3]>='0' && cmd_expiration_time_str[3]<='9')
            {
              char* str_end;
              cmd_expiration_time=strtoul(&cmd_expiration_time_str[3], &str_end, 10);

              if(str_end-cmd_expiration_time_str<cmd_len) {cmd_len-=str_end-cmd_expiration_time_str;}
              else                                        {cmd_expiration_time_str=0;}
            }

            if(cmd_expiration_time!=0 && GetUnixTime()<1558694050)
            {
              LOG("%s: cmd \"%s\" from \"%s\" has ignored, clock not sync\n", this->name, cmd, phone);

              if(ans_flags.is_phone_valid)
              {
                memcpy(ans_sms1_mem, "cmd has ignored, clock not sync", sizeof("cmd has ignored, clock not sync"));
                ans_sms2_mem[0]='\0';
                ans_flags.is_sms_send_en=1;
              }
            }
            else if(cmd_expiration_time!=0 && GetUnixTime()>cmd_expiration_time)
            {
              LOG("%s: cmd \"%s\" time from \"%s\" has expired\n", this->name, cmd, phone);

              if(ans_flags.is_phone_valid)
              {
                memcpy(ans_sms1_mem, "execution time has expired", sizeof("execution time has expired"));
                ans_sms2_mem[0]='\0';
                ans_flags.is_sms_send_en=1;
              }
            }
            else
            {
            if(cmd_len==(sizeof("nosleep")-1) && strstr(cmd, "nosleep")!=NULL)
            {
              LOG("%s: nosleep cmd from \"%s\"\n", this->name, phone);
              if(ans_flags.is_phone_valid)
              {
                memcpy(ans_sms1_mem, "nosleep ok", sizeof("nosleep ok"));
                ans_sms2_mem[0]='\0';
                ans_flags.is_sms_send_en=1;
              }

              System.Grab(portMAX_DELAY);
              System.power_settings.sleep_by_ignition=0;
              System.power_settings.sleep_by_stop=0;
              System.power_settings.sleep_by_wakeup=0;
              System.Release();

              this->output_message.source = SERVER_MANAGER;
              this->output_message.code =   MESSAGE_SERVER_SAVE_BASE;
              this->output_message.subcode = 1;//c последудующим сохранением в backup
              this->Send_message(this->output_queue);
            }
            else if(cmd_len==(sizeof("info?")-1) && strstr(cmd, "info?")!=NULL)
            {
              LOG("%s: info? cmd from \"%s\"\n", this->name, phone);
              if(ans_flags.is_phone_valid)
              {
                int s_len;
                uint16_t offset;

                offset=0;
                System.Grab(portMAX_DELAY);
                for(;;)
                {
                  s_len=snprintf(ans_sms1_mem+offset, ans_sms1_mem_size-offset, \
                    "%s\n", __get_fw_version());
                  if(s_len<0 || s_len>=ans_sms1_mem_size) break;
                  offset+=s_len;
                  s_len=snprintf(ans_sms1_mem+offset, ans_sms1_mem_size-offset, \
                    "imei: %.*s\n", sizeof(System.server_state.IMEI)-1, System.server_state.IMEI);
                  if(s_len<0 || s_len>=ans_sms1_mem_size-offset) break;
                  offset+=s_len;
                  s_len=snprintf(ans_sms1_mem+offset, ans_sms1_mem_size-offset, \
                    "lat: %.4f, lon: %.4f, sat inview: %hhu, sat inuse: %hhu, valid: %hhu", System.gnss_state.lat, System.gnss_state.lon, System.gnss_state.total_sat_inview, System.gnss_state.sat_inuse, System.gnss_state.coord_status);
                  if(s_len<0 || s_len>=ans_sms1_mem_size-offset) break;
                  //offset+=s_len;

                  break;
                }
                System.Release();

                offset=0;
                for(;;)
                {
                  System.Grab(portMAX_DELAY);
                  s_len=snprintf(ans_sms2_mem+offset, ans_sms2_mem_size-offset, \
                    "ign: %hhu, acc: %.1f, ext: %.1f, temp: %.1f, move: %hhu\n", System.signal_state.ignition, System.signal_state.internal_acc_voltage, System.signal_state.external_voltage, System.signal_state.internal_temp, System.signal_state.gsensor_move_sensor);
                  if(s_len<0 || s_len>=ans_sms2_mem_size-offset) {System.Release(); break;}
                  offset+=s_len;
                  System.Release();

                  Black_box.Grab(portMAX_DELAY);
                  s_len=snprintf(ans_sms2_mem+offset, ans_sms2_mem_size-offset, \
                    "black box: %lu, %lu, %lu, %lu", Black_box.get_message_count(1), Black_box.get_message_count(2), Black_box.get_message_count(3), Black_box.get_message_count(4));
                  if(s_len<0 || s_len>=ans_sms2_mem_size-offset) {Black_box.Release(); break;}
                  //offset+=s_len;
                  Black_box.Release();

                  break;
                }

                ans_flags.is_sms_send_en=1;
              }
            }
            else if(cmd_len==(sizeof("server?")-1) && strstr(cmd, "server?")!=NULL)
            {
              LOG("%s: server? cmd from \"%s\"\n", this->name, phone);
              if(ans_flags.is_phone_valid)
              {

                for(uint8_t i=0, offset=0; i<SERVER_TCP_CNT/2; i++)
                {
                  int s_len=snprintf(ans_sms1_mem+offset, ans_sms1_mem_size-offset, \
                    "server%hhu: %s&%s&%hu&%lu%s", \
                      i+1, local_settings[i].addr, prot_type_name[local_settings[i].prot_type], local_settings[i].connection_periodM, local_settings[i].user_terminal_addr, (i>=SERVER_TCP_CNT/2-1)?(""):("\n"));
                  if(s_len<0 || s_len>=ans_sms1_mem_size-offset) break;
                  offset+=s_len;
                }

                for(uint8_t i=SERVER_TCP_CNT/2, offset=0; i<SERVER_TCP_CNT; i++)
                {
                  int s_len=snprintf(ans_sms2_mem+offset, ans_sms2_mem_size-offset, \
                    "server%hhu: %s&%s&%hu&%lu%s", \
                      i+1, local_settings[i].addr, prot_type_name[local_settings[i].prot_type], local_settings[i].connection_periodM, local_settings[i].user_terminal_addr, (i>=SERVER_TCP_CNT-1)?(""):("\n"));
                  if(s_len<0 || s_len>=ans_sms2_mem_size-offset) break;
                  offset+=s_len;
                }

                ans_flags.is_sms_send_en=1;
              }
            }
            else if(strstr(cmd, "server1:")!=NULL || strstr(cmd, "server2:")!=NULL || strstr(cmd, "server3:")!=NULL || strstr(cmd, "server4:")!=NULL)
            {
              uint8_t serv_idx;
              uint8_t is_setting_valid=0;
              ESERVER_proto server_proto;
              uint16_t conn_period;
              uint32_t ndtp_addr;
              uint8_t addr_port_len;

              serv_idx=atoi(cmd+sizeof("server")-1);
              cmd+=sizeof("serverX:")-1;

              if(3==sym_cnt_in_str(cmd, '&') && 1==sym_cnt_in_str(cmd, ':') && \
                strchr(cmd,'&')>strchr(cmd,':') && \
                  atoi(strchr(cmd,':')+1)<=65535 && atoi(strchr(cmd,':')+1)>0
                    )
              {
                uint8_t i;
                const char* recv_protocol_type_ptr;
                recv_protocol_type_ptr=strchr(cmd,'&')+1;
                addr_port_len=recv_protocol_type_ptr-1-cmd;
                if(addr_port_len<GSM_MAX_SERVER_ADDR_LEN)
                {
                  for(i=0; i<prot_type_name_cnt; i++)
                  {
                    const uint8_t name_len=strlen(prot_type_name[i]);

                    if(memcmp(recv_protocol_type_ptr, prot_type_name[i], name_len)==0 &&
                       recv_protocol_type_ptr[name_len]=='&')
                    {
                      if     (i==VEGA_PROTOCOL_TYPE)         server_proto=VEGA;
#if defined(USE_EGTS_PROTOCOL_LIB)
                      else if(i==EGTS_PROTOCOL_TYPE)         server_proto=EGTS;
                      else if(i==EGTS_LIGHT_1_PROTOCOL_TYPE) server_proto=EGTS_LIGHT_1;
                      else if(i==EGTS_LIGHT_2_PROTOCOL_TYPE) server_proto=EGTS_LIGHT_2;
#endif //USE_EGTS_PROTOCOL_LIB
#if defined(USE_WIALON_PROTOCOL_LIB)
                      else if(i==WIALON_PROTOCOL_TYPE)       server_proto=WIALON;
#endif //USE_WIALON_PROTOCOL_LIB
#if defined(USE_NDTP_PROTOCOL_LIB)
                      else if(i==NDTP_PROTOCOL_TYPE)         server_proto=NDTP;
#endif //USE_NDTP_PROTOCOL_LIB
#if defined(USE_WIALON_BIN_PROTOCOL_LIB)
                      else if(i==WIALON_BIN_PROTOCOL_TYPE)   server_proto=WIALON_COMBINE;
#endif //USE_WIALON_BIN_PROTOCOL_LIB
                      //else if (i==TELTONIKA_PROTOCOL_TYPE)
#if defined(USE_NAVIS_PROTOCOL_LIB)
                      else if(i==NAVIS_PROTOCOL_TYPE)        server_proto=NAVIS_PROTOCOL;
#endif //USE_NAVIS_PROTOCOL_LIB
                      else                                   server_proto=SERVER_OFF;

                      break;
                    }
#if defined(USE_NAVIS_PROTOCOL_LIB)
//специально для Анны Золотоверховой
                    else if(memcmp(recv_protocol_type_ptr, "yatut", sizeof("yatut")-1)==0)
                    {
                      server_proto=NAVIS_PROTOCOL;
                      break;
                    }
#endif //USE_NAVIS_PROTOCOL_LIB
                  }
                  if(i<prot_type_name_cnt)//есть такое имя
                  {
                    char* coon_param_ptr=cmd;
                    coon_param_ptr=strchr(coon_param_ptr, '&')+1;
                    coon_param_ptr=strchr(coon_param_ptr, '&')+1;
                    if(*coon_param_ptr>='0' && *coon_param_ptr<='9')
                    {
                      //addr_port=cmd;
                      conn_period=(uint16_t)strtoul(coon_param_ptr, NULL, 10);

                      coon_param_ptr=strchr(coon_param_ptr, '&')+1;
                      if(*coon_param_ptr>='0' && *coon_param_ptr<='9')
                      {
                        ndtp_addr=(uint32_t)strtoul(coon_param_ptr, NULL, 10);
                        is_setting_valid=1;
                      }
                    }
                  }
                }
              }

              if(is_setting_valid)
              {
                System.Grab(portMAX_DELAY);
                memcpy(System.connection_settings.server[serv_idx-1].address, cmd, addr_port_len);
                System.connection_settings.server[serv_idx-1].address[addr_port_len]='\0';
                System.connection_settings.server[serv_idx-1].connection_period=conn_period;
                System.connection_settings.server[serv_idx-1].server_protocol=server_proto;
                System.connection_settings.ndtp_address[serv_idx-1]=ndtp_addr;
                System.connection_settings.security[serv_idx-1].pin_cfg=PIN_DISABLED;
                System.Release();

                this->output_message.source =   SERVER_MANAGER;
                this->output_message.code =     MESSAGE_SERVER_SAVE_BASE;
                this->output_message.subcode = 1;//c последудующим сохранением в backup
                this->Send_message(this->output_queue);
              }

              LOG("%s: server%hhu cfg cmd from \"%s\" %s, cfg: %s\n", this->name, serv_idx, phone, (is_setting_valid?"valid":"invalid"), cmd);
              if(ans_flags.is_phone_valid)
              {
                snprintf(ans_sms1_mem, ans_sms1_mem_size, "server%hhu config is %s", serv_idx, (is_setting_valid?"valid":"invalid"));
                ans_sms2_mem[0]='\0';
                ans_flags.is_sms_send_en=1;
              }
            }
            else if(cmd_len==(sizeof("rebootgnss")-1) && strstr(cmd, "rebootgnss")!=NULL)
            {
              LOG("%s: reboot gnss cmd from \"%s\"\n", this->name, phone);

              if(0>_common_cmd_callback(0xFF, REBOOT_GNSS_CMD_TYPE, 0, NULL))
              {
                if(ans_flags.is_phone_valid)
                {
                  memcpy(ans_sms1_mem, "rebootgnss err", sizeof("rebootgnss err"));
                  ans_sms2_mem[0]='\0';
                  ans_flags.is_sms_send_en=1;
                }
              }
              else
              {
                if(ans_flags.is_phone_valid)
                {
                  memcpy(ans_sms1_mem, "rebootgnss ok", sizeof("rebootgnss ok"));
                  ans_sms2_mem[0]='\0';
                  ans_flags.is_sms_send_en=1;
                }
              }
            }
            else if(cmd_len==(sizeof("rebootmodem")-1) && strstr(cmd, "rebootmodem")!=NULL)
            {
              LOG("%s: rebootmodem cmd from \"%s\"\n", this->name, phone);
              if(ans_flags.is_phone_valid)
              {
                memcpy(ans_sms1_mem, "reboot modem ok", sizeof("reboot modem ok"));
                ans_sms2_mem[0]='\0';
                ans_flags.is_sms_send_en=1;
              }
              post_action=REBOOT_MODEM_POST_ACTION;
            }
            else if(cmd_len==(sizeof("reboot")-1) && strstr(cmd, "reboot")!=NULL)
            {
              LOG("%s: reboot device cmd from \"%s\"\n", this->name, phone);
              if(ans_flags.is_phone_valid)
              {
                memcpy(ans_sms1_mem, "reboot ok", sizeof("reboot ok"));
                ans_sms2_mem[0]='\0';
                ans_flags.is_sms_send_en=1;
              }
              post_action=REBOOT_DEVICE_POST_ACTION;
            }
            else if(cmd_len==(sizeof("tofactory")-1) && strstr(cmd, "tofactory")!=NULL)
            {
              LOG("%s: tofactory cmd from \"%s\"\n", this->name, phone);
              if(ans_flags.is_phone_valid)
              {
                memcpy(ans_sms1_mem, "tofactory ok", sizeof("tofactory ok"));
                ans_sms2_mem[0]='\0';
                ans_flags.is_sms_send_en=1;
              }
              post_action=FORMAT_MEMORY_POST_ACTION;
            }
            else if(cmd_len==(sizeof("bboxclear")-1) && strstr(cmd, "bboxclear")!=NULL)
            {
              LOG("%s: bboxclear cmd from \"%s\"\n", this->name, phone);
              if(ans_flags.is_phone_valid)
              {
                memcpy(ans_sms1_mem, "bboxclear ok", sizeof("bboxclear ok"));
                ans_sms2_mem[0]='\0';
                ans_flags.is_sms_send_en=1;
              }
              post_action=BBOX_CLEAR_POST_ACTION;
            }
            else if(cmd_len==(sizeof("makephoto")-1) && strstr(cmd, "makephoto")!=NULL)
            {
              LOG("%s: makephoto cmd from \"%s\"\n", this->name, phone);

              if(0>_common_cmd_callback(0xFF, MAKE_PHOTO_CMD_TYPE, 0, NULL))
              {
                if(ans_flags.is_phone_valid)
                {
                  memcpy(ans_sms1_mem, "makephoto err", sizeof("makephoto err"));
                  ans_sms2_mem[0]='\0';
                  ans_flags.is_sms_send_en=1;
                }
              }
              else
              {
                if(ans_flags.is_phone_valid)
                {
                  memcpy(ans_sms1_mem, "makephoto ok", sizeof("makephoto ok"));
                  ans_sms2_mem[0]='\0';
                  ans_flags.is_sms_send_en=1;
                }
              }
            }
            else if(strstr(cmd, "setout")!=NULL && cmd[sizeof("setout")]=='=')
            {
              LOG("%s: setout cmd from \"%s\"\n", this->name, phone);

              cmd+=sizeof("setout")-1;

              ext_cmd_set_out_param_t param;

              param.pin=(uint8_t)strtoul(cmd, NULL, 10);
              cmd+=2;
              param.state=(uint8_t)strtoul(cmd, NULL, 10);

              if(0>_common_cmd_callback(0xFF, SET_OUT_STATE, 0, &param))
              {
                if(ans_flags.is_phone_valid)
                {
                  sprintf(ans_sms1_mem, "setout%hhu=%hhu err", param.pin, param.state);
                  ans_sms2_mem[0]='\0';
                  ans_flags.is_sms_send_en=1;
                }
              }
              else
              {
                if(ans_flags.is_phone_valid)
                {
                  sprintf(ans_sms1_mem, "setout%hhu=%hhu ok", param.pin, param.state);
                  ans_sms2_mem[0]='\0';
                  ans_flags.is_sms_send_en=1;
                }
              }
            }
            else if(strstr(cmd, "setextout")!=NULL && (cmd[sizeof("setextoutX")-1]=='=' || cmd[sizeof("setextoutXX")-1]=='='))
            {
              LOG("%s: setextout cmd from \"%s\"\n", this->name, phone);

              cmd+=sizeof("setextout")-1;

              ext_cmd_set_out_param_t param;

              param.pin=(uint8_t)strtoul(cmd, NULL, 10);
              if(cmd[sizeof("setextoutX")-1]=='=') cmd+=2;
              else                                 cmd+=3;
              param.state=(uint8_t)strtoul(cmd, NULL, 10);

              if(0>_common_cmd_callback(0xFF, SET_EXT_OUT_STATE, 0, &param))
              {
                if(ans_flags.is_phone_valid)
                {
                  sprintf(ans_sms1_mem, "setextout%hhu=%hhu err", param.pin, param.state);
                  ans_sms2_mem[0]='\0';
                  ans_flags.is_sms_send_en=1;
                }
              }
              else
              {
                if(ans_flags.is_phone_valid)
                {
                  sprintf(ans_sms1_mem, "setextout%hhu=%hhu ok", param.pin, param.state);
                  ans_sms2_mem[0]='\0';
                  ans_flags.is_sms_send_en=1;
                }
              }
            }
            else if(strstr(cmd, "setapn:")!=NULL || strstr(cmd, "setapn1:")!=NULL
#if MAX_SIM_COUNT > 1
                    || strstr(cmd, "setapn2:")!=NULL
#endif //MAX_SIM_COUNT > 1
                      )
            {
              uint8_t sim_id=0;

#if MAX_SIM_COUNT > 1
              if(strstr(cmd, "setapn2:")!=NULL) sim_id=1;
#endif //MAX_SIM_COUNT > 1

              LOG("%s: setapn cmd (sim id %hhu) from \"%s\"\n", this->name, sim_id, phone);

              char* apn_p=NULL;
              char* user_p;
              char* pass_p;

              if(2==sym_cnt_in_str(cmd, '&') /*&& strstr(cmd, "&&") == NULL */&& strstr(cmd, ":&") == NULL)
              {
                if(strstr(cmd, "&&") != NULL)
                {
                  apn_p=strchr(cmd, ':')+1;
                  *strchr(apn_p, '&')='\0';
                  user_p=(char*)"";
                  pass_p=(char*)"";
                }
                else
                {
                  apn_p=strchr(cmd, ':')+1;
                  user_p=strchr(apn_p, '&')+1;
                  pass_p=strchr(user_p, '&')+1;
                  *(user_p-1)='\0';
                  *(pass_p-1)='\0';
                  //pass_p уже нультерминированна
                }

                if(strlen(apn_p)==0 || strlen(apn_p)>=sizeof(System.connection_settings.APN[sim_id].APN)
                   || strlen(user_p)>=sizeof(System.connection_settings.APN[sim_id].user)
                     || strlen(pass_p)>=sizeof(System.connection_settings.APN[sim_id].password))
                {
                  apn_p=NULL;
                }

                if(apn_p!=NULL)
                {
                  System.Grab(portMAX_DELAY);
                  snprintf(System.connection_settings.APN[sim_id].APN, sizeof(System.connection_settings.APN[sim_id].APN), apn_p);
                  snprintf(System.connection_settings.APN[sim_id].user, sizeof(System.connection_settings.APN[sim_id].user), user_p);
                  snprintf(System.connection_settings.APN[sim_id].password, sizeof(System.connection_settings.APN[sim_id].password), pass_p);
                  System.Release();

                  //todo: Проверить!
                  this->output_message.source = SERVER_MANAGER;
                  this->output_message.code =   MESSAGE_SERVER_SAVE_BASE;
                  this->output_message.subcode = 1;//c последудующим сохранением в backup
                  this->Send_message(this->output_queue);

                  //если пришла настройка для используемой сим, нужно будет переинициализировать менеджер
                  //if(this->current_sim_id==sim_id)
                  ans_flags.is_sms_send_en=1;
                }
              }

              if(ans_flags.is_phone_valid)
              {
                if(apn_p!=NULL) memcpy(ans_sms1_mem, "setapn ok", sizeof("setapn ok"));
                else            memcpy(ans_sms1_mem, "setapn config is invalid", sizeof("setapn config is invalid"));
                ans_sms2_mem[0]='\0';
              }
            }
            else
            {
              uint8_t can_cmd;
              const char* verbose;
              if(UNKNOWN_CAN_CMD_TABLE_IDX!=is_can_cmd_in_sms(cmd, &can_cmd, &verbose))
              {
                LOG("%s: %s cmd from \"%s\"\n", this->name, verbose, phone);

                if(0>_common_cmd_callback(0xFF, CAN_CONTROL_CMD_TYPE, 0, &can_cmd))
                {
                  if(ans_flags.is_phone_valid)
                  {
                    snprintf(ans_sms1_mem, ans_sms1_mem_size, "%s command err", verbose);
                    ans_sms2_mem[0]='\0';
                    ans_flags.is_sms_send_en=1;
                  }
                }
                else
                {
                  if(ans_flags.is_phone_valid)
                  {
                    snprintf(ans_sms1_mem, ans_sms1_mem_size, "%s command received", verbose);
                    ans_sms2_mem[0]='\0';
                    ans_flags.is_sms_send_en=1;
                  }
                }
              }
              else
              {
                //не знаем такой команды
              }
            }
          }
            if(ans_flags.is_sms_send_en)
            {
              res=SendSmsInTextMode(phone, ans_sms1_mem, 0, (uint8_t*)sms_heap_mem, sms_heap_mem_size);
              if(res<0) LOG("%s: send sms1 err (%hd)\n", this->name, res);

              if(strlen(ans_sms2_mem))
              {
                res=SendSmsInTextMode(phone, ans_sms2_mem, 0, (uint8_t*)sms_heap_mem, sms_heap_mem_size);
                if(res<0) LOG("%s: send sms2 err (%hd)\n", this->name, res);
              }
            }
          }
        }

        if(!is_emty)
        {
          if(!is_allready_deleted)
          {
            res=DeleteSms(idx);
            if(res!=GSM_RES_OK)
            {
              LOG("%s: sms delete err, idx=%hhu\n", this->name, idx);
            }
          }
          processed_count++;
        }

        if(post_action==REBOOT_DEVICE_POST_ACTION)
        {
          for(uint8_t i=0; i<SERVER_TCP_CNT; i++)
          {
            if(!(conn_ctx[i].protocol_type==VOID_PROTOCOL_TYPE || conn_ctx[i].server_ctx_state==WAIT_NEXT_SESSION)) conn_ctx[i].common_const->socket_close(conn_ctx[i].conn_ctx_id);
          }
          soft_switch_off_modem();
          wait_staus_pin(0, 8000);
          Black_box.Grab();
          NVIC_SystemReset();
        }
        else if(post_action==FORMAT_MEMORY_POST_ACTION)
        {
          for(uint8_t i=0; i<SERVER_TCP_CNT; i++)
          {
            if(!(conn_ctx[i].protocol_type==VOID_PROTOCOL_TYPE || conn_ctx[i].server_ctx_state==WAIT_NEXT_SESSION)) conn_ctx[i].common_const->socket_close(conn_ctx[i].conn_ctx_id);
          }
          soft_switch_off_modem();
          wait_staus_pin(0, 8000);

          _common_cmd_callback(0xFF, TOFACTORY_CMD_TYPE, 0, NULL);
          NVIC_SystemReset();
        }
        else if(post_action==BBOX_CLEAR_POST_ACTION)
        {
          for(uint8_t i=0; i<SERVER_TCP_CNT; i++)
          {
            if(!(conn_ctx[i].protocol_type==VOID_PROTOCOL_TYPE || conn_ctx[i].server_ctx_state==WAIT_NEXT_SESSION)) conn_ctx[i].common_const->socket_close(conn_ctx[i].conn_ctx_id);
          }
          soft_switch_off_modem();
          wait_staus_pin(0, 8000);

          _common_cmd_callback(0xFF, BBOX_CLEAR_CMD_TYPE, 0, NULL);
          NVIC_SystemReset();
        }
        else if(post_action==REBOOT_MODEM_POST_ACTION)
        {
          this->is_man_reinit=1;
        }

        if(processed_count>=sms_inf.used) break;
      }
    }
  }
}

// Получение и разбор команд извне
void CSERVER_manager::Receive_command(TickType_t xTicksToWait)
{
  //none
}

void CSERVER_manager::Modem_pins_init(void)
{
#if defined(USE_SIMCOM_MODEM_LIB)
  GPIO_InitTypeDef GPIO_InitStructure;

  GPIO_InitStructure.GPIO_Speed = GPIO_Speed_2MHz;
  GPIO_InitStructure.GPIO_Mode = GPIO_Mode_OUT;
  GPIO_InitStructure.GPIO_OType = GPIO_OType_PP;
  GPIO_InitStructure.GPIO_PuPd = GPIO_PuPd_NOPULL;

  GPIO_InitStructure.GPIO_OType = SIMCOM_PWRKEY_PIN_MODE;
  GPIO_InitStructure.GPIO_Pin = SIMCOM_PWRKEY_PIN;
  GPIO_Init(SIMCOM_PWRKEY_PORT, &GPIO_InitStructure);
  __SIMCOM_PWRKEY_PIN_LOW();

  GPIO_InitStructure.GPIO_OType = MODEM_POWER_EN_PIN_MODE;
  GPIO_InitStructure.GPIO_Pin = MODEM_POWER_EN_PIN;
  GPIO_Init(MODEM_POWER_EN_PORT, &GPIO_InitStructure);
  __MODEM_POWER_DIS();

  GPIO_InitStructure.GPIO_Speed = GPIO_Speed_2MHz;
  GPIO_InitStructure.GPIO_Mode = GPIO_Mode_IN;
  GPIO_InitStructure.GPIO_PuPd = GPIO_PuPd_NOPULL;

  GPIO_InitStructure.GPIO_Pin = SIMCOM_STATUS_PIN;
  GPIO_Init(SIMCOM_STATUS_PORT, &GPIO_InitStructure);
#endif //USE_SIMCOM_MODEM_LIB


#if defined(USE_QUECTEL_MODEM_LIB)
  GPIO_InitTypeDef GPIO_InitStructure;

  GPIO_InitStructure.GPIO_Speed = GPIO_Speed_2MHz;
  GPIO_InitStructure.GPIO_Mode = GPIO_Mode_OUT;
  GPIO_InitStructure.GPIO_OType = GPIO_OType_PP;
  GPIO_InitStructure.GPIO_PuPd = GPIO_PuPd_NOPULL;

  GPIO_InitStructure.GPIO_OType = QUECTEL_PWRKEY_PIN_MODE;
  GPIO_InitStructure.GPIO_Pin = QUECTEL_PWRKEY_PIN;
  GPIO_Init(QUECTEL_PWRKEY_PORT, &GPIO_InitStructure);
  __QUECTEL_PWRKEY_PIN_LOW();

  GPIO_InitStructure.GPIO_OType = MODEM_POWER_EN_PIN_MODE;
  GPIO_InitStructure.GPIO_Pin = MODEM_POWER_EN_PIN;
  GPIO_Init(MODEM_POWER_EN_PORT, &GPIO_InitStructure);
  __MODEM_POWER_DIS();

  GPIO_InitStructure.GPIO_Speed = GPIO_Speed_2MHz;
  GPIO_InitStructure.GPIO_Mode = GPIO_Mode_IN;
  GPIO_InitStructure.GPIO_PuPd = GPIO_PuPd_NOPULL;

  GPIO_InitStructure.GPIO_Pin = QUECTEL_STATUS_PIN;
  GPIO_Init(QUECTEL_STATUS_PORT, &GPIO_InitStructure);
#endif //USE_QUECTEL_MODEM_LIB

#if MAX_SIM_COUNT > 1
#if (!defined(__SIM800_DS__))
  __MODEM_SEL_SIM_NO_PHANTOM_POWER();
  GPIO_InitStructure.GPIO_Speed = GPIO_Speed_2MHz;
  GPIO_InitStructure.GPIO_PuPd  = GPIO_PuPd_NOPULL;
  GPIO_InitStructure.GPIO_Mode = GPIO_Mode_OUT;

  GPIO_InitStructure.GPIO_OType = MODEM_SIM_SEL_PIN_MODE;
  GPIO_InitStructure.GPIO_Pin = MODEM_SIM_SEL_PIN;
  GPIO_Init(MODEM_SIM_SEL_PORT, &GPIO_InitStructure);
  __MODEM_SEL_SIM_NO_PHANTOM_POWER();
#endif //!__SIM800_DS__
#endif //MAX_SIM_COUNT > 1

#if defined(VOICE_CALL_PRESENT)
  GPIO_InitStructure.GPIO_Speed = GPIO_Speed_2MHz;
  GPIO_InitStructure.GPIO_Mode = GPIO_Mode_OUT;
  GPIO_InitStructure.GPIO_PuPd = GPIO_PuPd_NOPULL;

  GPIO_InitStructure.GPIO_Pin = MIC_PWR_PIN;
  GPIO_InitStructure.GPIO_OType = MIC_PWR_PIN_MODE;
  GPIO_Init(MIC_PWR_PORT, &GPIO_InitStructure);
  __MIC_PWR_DIS();

  GPIO_InitStructure.GPIO_Pin = AMP_PWR_PIN;
  GPIO_InitStructure.GPIO_OType = AMP_PWR_PIN_MODE;
  GPIO_Init(AMP_PWR_PORT, &GPIO_InitStructure);
  __AMP_PWR_DIS();
#endif //VOICE_CALL_PRESENT

#if defined(USE_PULSED_MODEM_POWER_ON)
  NVIC_Init((NVIC_InitTypeDef*)&modem_pwr_nvic_cfg);
  __MODEM_PWR_TIM_CLOCK_CMD(ENABLE);

  TIM_DeInit(MODEM_PWR_TIM);
  TIM_TimeBaseInit(MODEM_PWR_TIM, (TIM_TimeBaseInitTypeDef*)&modem_pwr_tim_cfg);
  MODEM_PWR_TIM->CR1 &=~ TIM_CR1_CEN;//stop timer
  MODEM_PWR_TIM->SR = ~TIM_IT_CC1; //clear CC1 IT flag
  MODEM_PWR_TIM->SR = ~TIM_IT_CC2; //clear CC2 IT flag
  MODEM_PWR_TIM->DIER |= TIM_IT_CC1;//enable CC1 IT
  MODEM_PWR_TIM->DIER |= TIM_IT_CC2;//enable CC2 IT
#endif //USE_PULSED_MODEM_POWER_ON

#if defined(USE_PRECHARGE_MODEM_POWER)
  __PRECHARGE_MODEM_POWER_OFF();
  GPIO_InitStructure.GPIO_Speed = GPIO_Speed_2MHz;
  GPIO_InitStructure.GPIO_Mode = GPIO_Mode_OUT;
  GPIO_InitStructure.GPIO_PuPd = GPIO_PuPd_NOPULL;

  GPIO_InitStructure.GPIO_OType = PRECHARGE_MODEM_POWER_PIN_MODE;
  GPIO_InitStructure.GPIO_Pin=PRECHARGE_MODEM_POWER_PIN;
  GPIO_Init(PRECHARGE_MODEM_POWER_PORT, &GPIO_InitStructure);
  __PRECHARGE_MODEM_POWER_OFF();
#endif //USE_PRECHARGE_MODEM_POWER

#if defined(USE_DISCHARGE_MODEM_POWER)
  __DISCHARGE_MODEM_POWER_OFF();
  GPIO_InitStructure.GPIO_Speed = GPIO_Speed_2MHz;
  GPIO_InitStructure.GPIO_Mode = GPIO_Mode_OUT;
  GPIO_InitStructure.GPIO_PuPd = GPIO_PuPd_NOPULL;

  GPIO_InitStructure.GPIO_OType = DISCHARGE_MODEM_POWER_PIN_MODE;
  GPIO_InitStructure.GPIO_Pin=DISCHARGE_MODEM_POWER_PIN;
  GPIO_Init(DISCHARGE_MODEM_POWER_PORT, &GPIO_InitStructure);
  __DISCHARGE_MODEM_POWER_OFF();
#endif //USE_DISCHARGE_MODEM_POWER

#if defined(MODEM_DTR_PORT)
  __MODEM_DTR_PIN_LOW();
  GPIO_InitStructure.GPIO_Speed = GPIO_Speed_2MHz;
  GPIO_InitStructure.GPIO_Mode = GPIO_Mode_OUT;
  GPIO_InitStructure.GPIO_PuPd = GPIO_PuPd_NOPULL;

  GPIO_InitStructure.GPIO_OType = MODEM_DTR_PIN_MODE;
  GPIO_InitStructure.GPIO_Pin = MODEM_DTR_PIN;
  GPIO_Init(MODEM_DTR_PORT, &GPIO_InitStructure);
  __MODEM_DTR_PIN_LOW();
#endif //defined(MODEM_DTR_PORT)
}

void CSERVER_manager::Modem_pins_deinit(void)
{
#if defined(USE_SIMCOM_MODEM_LIB)
    GPIO_InitTypeDef GPIO_InitStructure;

    /* Configure pins as analog */
    GPIO_InitStructure.GPIO_Mode = GPIO_Mode_AIN;
    GPIO_InitStructure.GPIO_PuPd = GPIO_PuPd_NOPULL;

    GPIO_InitStructure.GPIO_Pin = SIMCOM_PWRKEY_PIN;
    GPIO_Init(SIMCOM_PWRKEY_PORT, &GPIO_InitStructure);

    GPIO_InitStructure.GPIO_Pin = MODEM_POWER_EN_PIN;
    GPIO_Init(MODEM_POWER_EN_PORT, &GPIO_InitStructure);

    GPIO_InitStructure.GPIO_Pin = SIMCOM_STATUS_PIN;
    GPIO_Init(SIMCOM_STATUS_PORT, &GPIO_InitStructure);
#endif //USE_SIMCOM_MODEM_LIB

#if defined(USE_QUECTEL_MODEM_LIB)
    GPIO_InitTypeDef GPIO_InitStructure;

    /* Configure pins as analog */
    GPIO_InitStructure.GPIO_Mode = GPIO_Mode_AIN;
    GPIO_InitStructure.GPIO_PuPd = GPIO_PuPd_NOPULL;

    GPIO_InitStructure.GPIO_Pin = QUECTEL_PWRKEY_PIN;
    GPIO_Init(QUECTEL_PWRKEY_PORT, &GPIO_InitStructure);

    GPIO_InitStructure.GPIO_Pin = MODEM_POWER_EN_PIN;
    GPIO_Init(MODEM_POWER_EN_PORT, &GPIO_InitStructure);

    GPIO_InitStructure.GPIO_Pin = QUECTEL_STATUS_PIN;
    GPIO_Init(QUECTEL_STATUS_PORT, &GPIO_InitStructure);
#endif //USE_QUECTEL_MODEM_LIB

#if MAX_SIM_COUNT > 1
#if (!defined(__SIM800_DS__))
  __MODEM_SEL_SIM_NO_PHANTOM_POWER();
  GPIO_InitStructure.GPIO_Mode = GPIO_Mode_AIN;
  GPIO_InitStructure.GPIO_PuPd = GPIO_PuPd_NOPULL;
  GPIO_InitStructure.GPIO_Pin = MODEM_POWER_EN_PIN;
  GPIO_Init(MODEM_POWER_EN_PORT, &GPIO_InitStructure);
#endif //!__SIM800_DS__
#endif //MAX_SIM_COUNT > 1

#if defined(VOICE_CALL_PRESENT)
  GPIO_InitStructure.GPIO_Mode = GPIO_Mode_AIN;
  GPIO_InitStructure.GPIO_PuPd = GPIO_PuPd_NOPULL;
  GPIO_InitStructure.GPIO_Pin = MIC_PWR_PIN;
  GPIO_Init(MIC_PWR_PORT, &GPIO_InitStructure);

  GPIO_InitStructure.GPIO_Pin = AMP_PWR_PIN;
  GPIO_Init(AMP_PWR_PORT, &GPIO_InitStructure);
#endif //VOICE_CALL_PRESENT

#if defined(USE_PULSED_MODEM_POWER_ON)
  __MODEM_PWR_TIM_CLOCK_CMD(DISABLE);
  MODEM_PWR_TIM->SR = ~TIM_IT_CC1; //clear CC1 IT flag
  MODEM_PWR_TIM->SR = ~TIM_IT_CC2; //clear CC2 IT flag
#endif //USE_PULSED_MODEM_POWER_ON

#if defined(USE_PRECHARGE_MODEM_POWER)
  __PRECHARGE_MODEM_POWER_OFF();
#endif //USE_PRECHARGE_MODEM_POWER

#if defined(USE_DISCHARGE_MODEM_POWER)
  __DISCHARGE_MODEM_POWER_OFF();
#endif //USE_DISCHARGE_MODEM_POWER

#if defined(MODEM_DTR_PORT)
  __MODEM_DTR_PIN_LOW();
#endif //defined(MODEM_DTR_PORT)
}

/* C code---------------------------------------------------------------------*/
static void modem_at_parse(void* argument)
{
#if defined(USE_CINTERION_MODEM_LIB)
  CinterionParse_cycle();
#endif //USE_CINTERION_MODEM_LIB

#if defined(USE_SIMCOM_MODEM_LIB)
  SimcomParse_cycle();
#endif //USE_SIMCOM_MODEM_LIB

#if defined(USE_QUECTEL_MODEM_LIB)
  QuectelParse_cycle();
#endif //USE_QUECTEL_MODEM_LIB
}

static void configurator_task(void* argument)
{
  System.server_state.usb_connected=0;

  static conn_ctx_t usb_ctx;
#if defined(STM32F413_423xx)
  static uint8_t usb_rx_mem[512];
  static uint8_t usb_tx_mem[512];
#else
  static uint8_t usb_rx_mem[512];
  static uint8_t usb_tx_mem[512];
#endif //defined(STM32F413_423xx)

  uint8_t is_reinit_only=0;
  for(;;)
  {
    if(!is_reinit_only)
    {
      //SERVER_manager.configurator_task_sleep_state=2;

      while(!SERVER_manager.configurator_task_wakeup_cmd)
      {
        System.server_state.usb_connected=0;
        vTaskDelay(100);
      }
      SERVER_manager.configurator_task_wakeup_cmd=0;
    }

    USB_CDC_Init();

    while(USB_CDC_State() != CONFIGURED)
    {
      vTaskDelay(200);
      if(SERVER_manager.configurator_task_sleep_state) {is_reinit_only=0; break;}
    }

    if(USB_CDC_State() == CONFIGURED) System.server_state.usb_connected=1;

    usb_ctx.protocol_type=VEGA_PROTOCOL_TYPE;
    usb_ctx.rx_buff=usb_rx_mem;
    usb_ctx.rx_buff_size=sizeof(usb_rx_mem);
    usb_ctx.server_addr="usb_host"; usb_ctx.server_ctx_name="usb_vega_ctx";
    usb_ctx.keepalive_timeoutS=0xffff;
    usb_ctx.connection_periodM=0;
    usb_ctx.server_ctx_state=DO_CONNECTING;
    usb_ctx.conn_ctx_id=SERVER_USB_CONN_ID;
    usb_ctx.conn_fail_counter=0;
    usb_ctx.common_const=&protocols_common_const;

#if defined(VEGA_SECURE_PRESENT)
    usb_ctx.secure=NULL;
#endif //defined(VEGA_SECURE_PRESENT)

#if defined(VEGA_ESECURE_PRESENT)
    usb_ctx.esecure=NULL;
#endif //defined(VEGA_ESECURE_PRESENT)

    usb_ctx.protocol.vega.use_passwd_opt=&System.security_settings.use_pin;
    usb_ctx.protocol.vega.passwd=System.security_settings.pin;
    usb_ctx.protocol.vega.bbox_receiver=0;
    usb_ctx.protocol.vega.tx_mem=usb_tx_mem;
    usb_ctx.protocol.vega.tx_mem_size=sizeof(usb_tx_mem);
    usb_ctx.protocol.vega.dev_type=DEVICE_TYPE;
    usb_ctx.protocol.vega.got_vega_packet_callback=_got_vega_packet_callback;

    for(;;)
    {
      if(SERVER_manager.configurator_task_sleep_state) {is_reinit_only=0; break;}

      server_conn_handler(&usb_ctx, "configurator");
      if(usb_ctx.server_ctx_state==WAIT_NEXT_SESSION)  {is_reinit_only=1; break;}
    }

    USB_CDC_Deinit();
    System.server_state.usb_connected=0;

    vTaskDelay(10);

    if(!is_reinit_only)
    {
      SERVER_manager.configurator_task_sleep_state=2;
    }
  }
}

// Функция запуска SERVER менеджера
void Start_server_manager(void* argument)
{
  xTaskCreate(modem_at_parse, "modem_at_parse", configMINIMAL_STACK_SIZE+8, NULL, configMAX_PRIORITIES-1, NULL);

#if (!defined(DISABLE_CONFIGURATOR_TASK))
  xTaskCreate(configurator_task, "configurator_task", configMINIMAL_STACK_SIZE*2, NULL, SERVER_MANAGER_PRIORITY, NULL);
#else
#warning configurator_task disabled!!!
#endif

  for(;;)
  {
    SERVER_manager.Init();
    SERVER_manager.Main_cycle();
    SERVER_manager.Deinit();
  }
}

#ifdef __cplusplus
extern "C" {
#endif

#if defined(USE_PULSED_MODEM_POWER_ON)
#pragma optimize=speed
void MODEM_PWR_TIM_IRQHandler(void)
{
  if(MODEM_PWR_TIM->SR & TIM_IT_CC1)
  {
    MODEM_PWR_TIM->SR = ~TIM_IT_CC1;//clear IT flag
    __MODEM_POWER_DIS();
    //LedG_Off();
  }
  else if(MODEM_PWR_TIM->SR & TIM_IT_CC2)
  {
    MODEM_PWR_TIM->CR1 &=~ TIM_CR1_CEN;//stop timer
    MODEM_PWR_TIM->SR = ~TIM_IT_CC2;//clear IT flag

    __MODEM_POWER_EN();
    //LedG_On();

    if(modem_pwr.modem_pwr_on_pulse_idx>=(sizeof(modem_pwr_on_pulse)/sizeof(modem_pwr_on_pulse[modem_pwr.modem_pwr_on_pulse_idx])))
    {
      modem_pwr.is_modem_pwr_ready=1;
    }
    else
    {
      MODEM_PWR_TIM->CNT  = 0;
      MODEM_PWR_TIM->CCR1 = modem_pwr_on_pulse[modem_pwr.modem_pwr_on_pulse_idx++];
      MODEM_PWR_TIM->CCR2 = modem_pwr_off_pulse+MODEM_PWR_TIM->CCR1;
      MODEM_PWR_TIM->CR1 |= TIM_CR1_CEN;//run timer
    }
  }
  else
  {//не должны сюда попадать
    MODEM_PWR_TIM->CR1&=~TIM_CR1_CEN;//stop timer
    __MODEM_POWER_EN();
    //LedG_On();
    modem_pwr.is_modem_pwr_ready=1;
  }
}
#endif //USE_PULSED_MODEM_POWER_ON

void got_ping_ans(const uint8_t conn_id){}

#ifdef __cplusplus
}
#endif
