/**
  ******************************************************************************
  * File Name          : server_manager.h
  * Description        : Менеджер SERVER
  *
  *
  ******************************************************************************
*/

/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef SERVER_MANAGER_H
#define SERVER_MANAGER_H

/* Includes ------------------------------------------------------------------*/
#include <stdint.h>
#include "server_manager_config.h"
#include "manager.h"
#include "FreeRTOS.h"
#include "task.h"
#include "serv_protocols_lib/serv_protocol_handler.h"
#include "System/system.h"

#if (defined(USE_SERVER_NOTIFY_IN_WCOMBINE) || defined(USE_SERVER_NOTIFY_IN_VEGA))
#include "serv_protocols_lib/server_notifies.h"
#endif //(defined(USE_SERVER_NOTIFY_IN_WCOMBINE) || defined(USE_SERVER_NOTIFY_IN_VEGA))

/* Defines- ------------------------------------------------------------------*/
// Системные настройки менеджера
#define SERVER_MANAGER_NAME                           "srv_man" // Имя менеджера
#define SERVER_MANAGER_INPUT_CUEUE_SIZE               3 // Количество элементов во входящей очереди сообщений
#define SERVER_MANAGER_PRIORITY                       1 // Приоритет задачи менеджера
#define SERVER_MANAGER_STACK_SIZE                     256 // Размер стэка менеджера в словах
#define USE_NEW_CHANGE_SIM_BY_NO_VALID_VEGA_PACKET    1U

typedef struct
{
  char                  addr[GSM_MAX_SERVER_ADDR_LEN+1];
  serv_ctx_prot_type_t  prot_type;
  uint16_t              connection_periodM;
  uint32_t              user_terminal_addr;
  uint8_t               pin_enabled_opt; //измениние этого параметра не приводит к разрыву соединения (пришлось добавить, из-за того, что в system есть состояние PIN_DISABLED=1)
  uint8_t               is_update;
}local_server_settings_t;

typedef int8_t (*got_vega_packet_callback_t)(uint8_t conn_id, uint8_t* packet, uint8_t* ans_buff, uint16_t ans_buff_size, uint16_t* ans_len);

got_vega_packet_callback_t get_got_vega_packet_callback_pointer(void);
const common_prot_const_t* get_protocols_common_const_pointer(void);

void need_update_backup_settings_file(void);

/* C++ code-------------------------------------------------------------------*/
class CSERVER_manager: public CManager
{
  public:
  // Конструктор, определяется имя менеджера, передается коллбэк на таймер, указатель на исходящую очередь, интерфейс обмена данными с железом
  CSERVER_manager(const char* mngr_name, QueueHandle_t* output_queue, uint8_t input_queue_size, uint8_t priority, TaskFunction_t task_starter, uint16_t stack_size);
  // Инициализация менеджера, реализует наследник
  void Init();
  // Деинициализация менеджера, реализует наследник
  void Deinit(void);
  // Главный цикл менеджера
  void Main_cycle(void);
#if MAX_SIM_COUNT > 1
  void Fast_sim_change(void);
#endif //MAX_SIM_COUNT > 1
  // Очередь ответов на собщения MESSAGE_SERVER_RECV_DATA
  QueueHandle_t answer_queue;

  uint8_t configurator_task_sleep_state; //0-работает, 1-подготовка ко сну, 2 - спит
  uint8_t configurator_task_wakeup_cmd;

  void Force_sim_change(void) {force_change_sim=1;};

  bool Is_busy_for_sim_change(void) {if(!modem_initialized || force_change_sim){return true;} else{return false;}}

  uint8_t Get_current_sim_id(void) {return current_sim_id;}

  bool Is_bt_connected(void);

  // Имя менеджера
  const char* name;

#if defined(USE_SIMCOM_MODEM_LIB)
   uint8_t bt_initialized;
#endif //USE_SIMCOM_MODEM_LIB

  uint32_t yandex_force_block_timerS;

#if (NO_RX_DATA_SIM_CHANGE_OR_REBOOT_TIMEOUT_S > 0)
  uint32_t last_tcp_data_recv_timeS;
#endif //(NO_RX_DATA_SIM_CHANGE_OR_REBOOT_TIMEOUT_S > 0)

  private:

  // Получение и разбор команд извне
  void Receive_command(TickType_t xTicksToWait);

  void Modem_pins_init(void);
  void Modem_pins_deinit(void);

  void Sms_handler(void);

  void Backup_settings_handler(void);

  uint8_t modem_initialized;
  uint8_t sleep_cmd;
  uint8_t force_wakeup;//for bebug only
  uint8_t is_man_reinit;
  uint8_t is_start_after_power_on;

  uint8_t current_sim_id;
#if MAX_SIM_COUNT > 1
  uint8_t force_change_sim;
  uint8_t desired_sim_id;//id сим на которую необходимо переключиться
  uint32_t work_on_reserve_sim_end_timeMS;
  uint32_t last_network_view_time_MS;//время последего наличия регистрации в сети

#if defined(USE_FAST_SIM_CHANGE)
  uint8_t fast_sim_change_conn_fail_counter;
#endif //defined(USE_FAST_SIM_CHANGE)

#endif //MAX_SIM_COUNT > 1

  #if defined(MODEM_PSAVE_PRESENT)
  uint8_t psave_enabled:1;
#endif //defined(MODEM_PSAVE_PRESENT)

  // ���������� ������������������ ������
  bool Psave_handler(bool sleep_enable, const uint16_t no_sleep_max_wait_message, const bool is_conn_ctx_initialized = false);
};

/* C code---------------------------------------------------------------------*/
// Функция создания SERVER менеджера
extern void Create_server_manager(void);
// Функция запуска SERVER менеджера
extern void Start_server_manager(void* argument);
// Для обеспечения видимости другими менеджерами
extern CSERVER_manager SERVER_manager;

#endif