/**
******************************************************************************
* File Name          :
* Description        :
*
*
******************************************************************************
*/

//Kia Rio, Hyunday Solaris
static const uint16_t KIA_RIO_CAN1_SPEED=100;

static const can_filter_t kia_rio_2017_can1[]=
{
  {.bank_type=STD_ID_FILTER_BANK_TYPE, {.std.value1=0x100, .std.value2=0x102, .std.value3=0x103, .std.value4=0x130}},
};
static_assert(!(sizeof(kia_rio_2017_can1)>MAX_FILTER_TABLE_SIZE-1), "wrong kia_rio_2017 filter size");

static const uint16_t HYUNDAI_SOLARIS_CAN1_SPEED=100;

static const can_filter_t hyundai_solaris_2017_can1[]=
{
  {.bank_type=STD_ID_FILTER_BANK_TYPE, {.std.value1=0x1A3, .std.value2=0x1A1, .std.value3=0x130, .std.value4=0x000}},
};
static_assert(!(sizeof(hyundai_solaris_2017_can1)>MAX_FILTER_TABLE_SIZE-1), "wrong hyundai_solaris_2017_can1 filter size");

static const uint16_t KIA_RIO_CAN2_SPEED=500;

static const uint16_t HYUNDAI_SOLARIS_CAN2_SPEED=500;

static const can_filter_t kia_rio_hyundai_solaris_2017_can2[]=
{
  {.bank_type=STD_ID_FILTER_BANK_TYPE, {.std.value1=0x329, .std.value2=0x593, .std.value3=0x111, .std.value4=0x541}},
  {.bank_type=STD_ID_FILTER_BANK_TYPE, {.std.value1=0x545, .std.value2=0x316, .std.value3=0x50C, .std.value4=0x260}},
  {.bank_type=STD_ID_FILTER_BANK_TYPE, {.std.value1=0x5B0, .std.value2=0x18F, .std.value3=0x381, .std.value4=0x507}},
  {.bank_type=STD_ID_FILTER_BANK_TYPE, {.std.value1=0x7E8, .std.value2=0x7CE, .std.value3=0x5A0, .std.value4=0x2B0}},
  {.bank_type=STD_ID_W_MASK_FILTER_BANK_TYPE, {.std_w_mask.value1=0x700, .std_w_mask.mask1=0x700, .std_w_mask.value2=0x700, .std_w_mask.mask2=0x700}},
};
static_assert(!(sizeof(kia_rio_hyundai_solaris_2017_can2)>MAX_FILTER_TABLE_SIZE-1), "wrong kia_rio_hyundai_solaris_2017_can2 filter size");

static const can_commands_table_t kia_rio_2017_can_commands_table[]=
{
  {PARKING_LIGHT_ON_CMD_TYPE,    CAN1, .id_type=STD_ID_TYPE, .id_1=0x700, .repeats_1=3, .mess_1={0x02,0x10,0x03,0x00,0x00,0x00,0x00,0x00}, .len_1=8, .delay_1=100, .id_2=0x700, .repeats_2=4, .mess_2={0x04,0x2f,0xb0,0x11,0x03,0x00,0x00,0x00}, .len_2=8, .delay_2=100, .seq_repeats=1},
  {PARKING_LIGHT_OFF_CMD_TYPE,   CAN1, .id_type=STD_ID_TYPE, .id_1=0x700, .repeats_1=3, .mess_1={0x04,0x2f,0xb0,0x11,0x00,0x00,0x00,0x00}, .len_1=8, .delay_1=100, .id_2=0x700, .repeats_2=0, .mess_2={0}, .len_2=0, .delay_2=0, .seq_repeats=1},
  {CENTRAL_LOCK_CLOSE_CMD_TYPE,  CAN1, .id_type=STD_ID_TYPE, .id_1=0x700, .repeats_1=3, .mess_1={0x02,0x10,0x03,0x00,0x00,0x00,0x00,0x00}, .len_1=8, .delay_1=100, .id_2=0x700, .repeats_2=4, .mess_2={0x04,0x2f,0xb0,0x2b,0x03,0x00,0x00,0x00}, .len_2=8, .delay_2=100, .seq_repeats=1},
  {CENTRAL_LOCK_OPEN_CMD_TYPE,   CAN1, .id_type=STD_ID_TYPE, .id_1=0x700, .repeats_1=3, .mess_1={0x02,0x10,0x03,0x00,0x00,0x00,0x00,0x00}, .len_1=8, .delay_1=100, .id_2=0x700, .repeats_2=4, .mess_2={0x04,0x2f,0xb0,0x2c,0x03,0x00,0x00,0x00}, .len_2=8, .delay_2=100, .seq_repeats=1},
  {TRUNK_OPEN_CMD_TYPE,          CAN1, .id_type=STD_ID_TYPE, .id_1=0x700, .repeats_1=3, .mess_1={0x02,0x10,0x03,0x00,0x00,0x00,0x00,0x00}, .len_1=8, .delay_1=100, .id_2=0x700, .repeats_2=4, .mess_2={0x04,0x2f,0xb0,0x2e,0x03,0x00,0x00,0x00}, .len_2=8, .delay_2=100, .seq_repeats=1},
};

static const can_commands_table_t hyundai_solaris_can_commands_table[]=
{
  {CENTRAL_LOCK_CLOSE_CMD_TYPE,  CAN1, .id_type=STD_ID_TYPE, .id_1=0x742, .repeats_1=2,   .mess_1={0x02,0x10,0x03,0x00,0x00,0x00,0x00,0x00}, .len_1=8, .delay_1=50,  .id_2=0x742, .repeats_2=2, .mess_2={0x04,0x2f,0xb0,0x2b,0x03,0x00,0x00,0x00}, .len_2=8, .delay_2=50, .seq_repeats=1},
  {CENTRAL_LOCK_OPEN_CMD_TYPE,   CAN1, .id_type=STD_ID_TYPE, .id_1=0x742, .repeats_1=2,   .mess_1={0x02,0x10,0x03,0x00,0x00,0x00,0x00,0x00}, .len_1=8, .delay_1=50,  .id_2=0x742, .repeats_2=2, .mess_2={0x04,0x2f,0xb0,0x2c,0x03,0x00,0x00,0x00}, .len_2=8, .delay_2=50, .seq_repeats=1},
};

//Renault Kaptur
static const uint16_t RENAULT_KAPTUR_CAN1_SPEED=500;

static const can_filter_t renault_kaptur_2016_can1[]=
{
  {.bank_type=STD_ID_FILTER_BANK_TYPE, {.std.value1=0x5DE, .std.value2=0x350, .std.value3=0x204, .std.value4=0x4DE}},
  {.bank_type=STD_ID_FILTER_BANK_TYPE, {.std.value1=0x1F6, .std.value2=0x090, .std.value3=0x3F7, .std.value4=0x4AC}},
  {.bank_type=STD_ID_FILTER_BANK_TYPE, {.std.value1=0x186, .std.value2=0x4F8, .std.value3=0x653, .std.value4=0x29A}},
  {.bank_type=STD_ID_FILTER_BANK_TYPE, {.std.value1=0x7E8, .std.value2=0x666, .std.value3=0x66A, .std.value4=0x763}},//new: 0x666, 0x66A, 0x763
  {.bank_type=STD_ID_FILTER_BANK_TYPE, {.std.value1=0x0C6, .std.value2=0x090, .std.value3=0x000, .std.value4=0x000}},
  {.bank_type=STD_ID_W_MASK_FILTER_BANK_TYPE, {.std_w_mask.value1=0x700, .std_w_mask.mask1=0x700, .std_w_mask.value2=0x700, .std_w_mask.mask2=0x700}},
};
static_assert(!(sizeof(renault_kaptur_2016_can1)>MAX_FILTER_TABLE_SIZE-1), "wrong renault_kaptur_2016 filter size");

static const can_commands_table_t renault_kaptur_can_commands_table[]=
{
  {PARKING_LIGHT_ON_CMD_TYPE,    CAN1, .id_type=STD_ID_TYPE, .id_1=0x745, .repeats_1=10, .mess_1={0x02,0x10,0xC0,0xFF,0xFF,0xFF,0xFF,0xFF}, .len_1=8, .delay_1=20, .id_2=0x745, .repeats_2=4, .mess_2={0x04,0x30,0x08,0x20,0x02,0xFF,0xFF,0xFF}, .len_2=8, .delay_2=20, .seq_repeats=1},
  {PARKING_LIGHT_OFF_CMD_TYPE,   CAN1, .id_type=STD_ID_TYPE, .id_1=0x745, .repeats_1=4,  .mess_1={0x03,0x30,0x08,0x11,0xFF,0xFF,0xFF,0xFF}, .len_1=8, .delay_1=20, .id_2=0, .repeats_2=0, .mess_2={0}, .len_2=0, .delay_2=0, .seq_repeats=1},
  {CENTRAL_LOCK_CLOSE_CMD_TYPE,  CAN1, .id_type=STD_ID_TYPE, .id_1=0x745, .repeats_1=10, .mess_1={0x02,0x10,0xC0,0xFF,0xFF,0xFF,0xFF,0xFF}, .len_1=8, .delay_1=20, .id_2=0x745, .repeats_2=4, .mess_2={0x04,0x30,0x01,0x00,0x00,0xFF,0xFF,0xFF}, .len_2=8, .delay_2=20, .seq_repeats=1},
  {CENTRAL_LOCK_OPEN_CMD_TYPE,   CAN1, .id_type=STD_ID_TYPE, .id_1=0x745, .repeats_1=10, .mess_1={0x02,0x10,0xC0,0xFF,0xFF,0xFF,0xFF,0xFF}, .len_1=8, .delay_1=20, .id_2=0x745, .repeats_2=4, .mess_2={0x04,0x30,0x01,0x00,0x01,0xFF,0xFF,0xFF}, .len_2=8, .delay_2=20, .seq_repeats=1},
};

//Hyunday Genesis
static const uint16_t HYUNDAI_GENESIS_CAN1_SPEED=500;

static const can_filter_t hyundai_genesis_2017_can1[]=
{
  {.bank_type=STD_ID_FILTER_BANK_TYPE, {.std.value1=0x101, .std.value2=0x105, .std.value3=0x168, .std.value4=0x169}},
  {.bank_type=STD_ID_FILTER_BANK_TYPE, {.std.value1=0x000, .std.value2=0x000, .std.value3=0x000, .std.value4=0x000}},
};
static_assert(!(sizeof(hyundai_genesis_2017_can1)>MAX_FILTER_TABLE_SIZE-1), "wrong hyundai_genesis_2017_can1 filter size");

static const uint16_t HYUNDAI_GENESIS_CAN2_SPEED=500;

static const can_filter_t hyundai_genesis_2017_can2[]=
{
  {.bank_type=STD_ID_FILTER_BANK_TYPE, {.std.value1=0x220, .std.value2=0x260, .std.value3=0x251, .std.value4=0x366}},
  {.bank_type=STD_ID_FILTER_BANK_TYPE, {.std.value1=0x367, .std.value2=0x52A, .std.value3=0x490, .std.value4=0x500}},
  {.bank_type=STD_ID_FILTER_BANK_TYPE, {.std.value1=0x507, .std.value2=0x50C, .std.value3=0x541, .std.value4=0x553}},
  {.bank_type=STD_ID_FILTER_BANK_TYPE, {.std.value1=0x568, .std.value2=0x53E, .std.value3=0x593, .std.value4=0x5B0}},
  {.bank_type=STD_ID_FILTER_BANK_TYPE, {.std.value1=0x7E8, .std.value2=0x7CE, .std.value3=0x59D, .std.value4=0x329}},
  {.bank_type=STD_ID_FILTER_BANK_TYPE, {.std.value1=0x000, .std.value2=0x000, .std.value3=0x000, .std.value4=0x000}},
  {.bank_type=STD_ID_W_MASK_FILTER_BANK_TYPE, {.std_w_mask.value1=0x700, .std_w_mask.mask1=0x700, .std_w_mask.value2=0x700, .std_w_mask.mask2=0x700}},
};
static_assert(!(sizeof(hyundai_genesis_2017_can2)>MAX_FILTER_TABLE_SIZE-1), "wrong hyundai_genesis_2017_can2 filter size");

static const uint16_t HYUNDAI_GENESIS_CAN3_SPEED=500;

static const can_filter_t hyundai_genesis_2017_can3[]=
{
  {.bank_type=STD_ID_W_MASK_FILTER_BANK_TYPE, {.std_w_mask.value1=0x700, .std_w_mask.mask1=0x700, .std_w_mask.value2=0x700, .std_w_mask.mask2=0x700}},
};
static_assert(!(sizeof(hyundai_genesis_2017_can3)>MAX_FILTER_TABLE_SIZE-1), "wrong hyundai_genesis_2017_can3 filter size");

static const can_commands_table_t hyundai_genesis_can_commands_table[]=
{
  {PARKING_LIGHT_ON_CMD_TYPE,            CAN1, .id_type=STD_ID_TYPE, .id_1=0x103, .repeats_1=1,  .mess_1={0x00,0x00,0x00,0x40,0x00,0x00,0x00,0x00}, .len_1=8, .delay_1=100, .id_2=0, .repeats_2=0, .mess_2={0}, .len_2=0, .delay_2=0, .seq_repeats=1},
  {CENTRAL_LOCK_CLOSE_CMD_TYPE,          CAN1, .id_type=STD_ID_TYPE, .id_1=0x000, .repeats_1=3,  .mess_1={0x00,0x10,0x00,0x00,0x00,0x00,0x00,0x00}, .len_1=8, .delay_1=40, .id_2=0x00, .repeats_2=3, .mess_2={0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, .len_2=8, .delay_2=40, .seq_repeats=1},
  {CENTRAL_LOCK_OPEN_CMD_TYPE,           CAN1, .id_type=STD_ID_TYPE, .id_1=0x000, .repeats_1=3,  .mess_1={0x00,0x20,0x00,0x00,0x00,0x00,0x00,0x00}, .len_1=8, .delay_1=40, .id_2=0x00, .repeats_2=3, .mess_2={0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, .len_2=8, .delay_2=40, .seq_repeats=1},
  {EXT_WINDOWS_CLOSING_CMD_TYPE_GENESIS, CAN1, .id_type=STD_ID_TYPE, .id_1=0x120, .repeats_1=100,.mess_1={0x10,0x00,0x00,0x22,0x21,0x00,0x00,0x00}, .len_1=8, .delay_1=40, .id_2=0, .repeats_2=0, .mess_2={0}, .len_2=0, .delay_2=0, .seq_repeats=1},
};

//Audi A3
static const uint16_t AUDI_A3_CAN1_SPEED=500;

static const can_filter_t audi_a3_2018_can1[]=
{
  {.bank_type=STD_ID_FILTER_BANK_TYPE, {.std.value1=0x107, .std.value2=0x30B, .std.value3=0x31B, .std.value4=0x394}},
  {.bank_type=STD_ID_FILTER_BANK_TYPE, {.std.value1=0x3C0, .std.value2=0x3C7, .std.value3=0x520, .std.value4=0x583}},
  {.bank_type=STD_ID_FILTER_BANK_TYPE, {.std.value1=0x5F9, .std.value2=0x658, .std.value3=0x65A, .std.value4=0x30D}},
  {.bank_type=STD_ID_FILTER_BANK_TYPE, {.std.value1=0x3BE, .std.value2=0x366, .std.value3=0x3D0, .std.value4=0x3D1}},
  {.bank_type=STD_ID_FILTER_BANK_TYPE, {.std.value1=0x3CF, .std.value2=0x3CE, .std.value3=0x040, .std.value4=0x0FD}},
  {.bank_type=STD_ID_FILTER_BANK_TYPE, {.std.value1=0x3DA, .std.value2=0x3EB, .std.value3=0x000, .std.value4=0x000}},
};
static_assert(!(sizeof(audi_a3_2018_can1)>MAX_FILTER_TABLE_SIZE-1), "wrong audi_a3_2018_can1 filter size");

static const uint16_t AUDI_A3_CAN2_SPEED=500;

static const can_filter_t audi_a3_2018_can2[]=
{
  {.bank_type=STD_ID_FILTER_BANK_TYPE, {.std.value1=0x106, .std.value2=0x121, .std.value3=0x6B2, .std.value4=0x7E8}},
  {.bank_type=STD_ID_FILTER_BANK_TYPE, {.std.value1=0x086, .std.value2=0x000, .std.value3=0x000, .std.value4=0x000}},
  {.bank_type=STD_ID_W_MASK_FILTER_BANK_TYPE, {.std_w_mask.value1=0x700, .std_w_mask.mask1=0x700, .std_w_mask.value2=0x700, .std_w_mask.mask2=0x700}},
};
static_assert(!(sizeof(audi_a3_2018_can2)>MAX_FILTER_TABLE_SIZE-1), "wrong audi_a3_2018_can2 filter size");

//for AUDI A3 2018 и Skoda Octavia(кроме окон)
static const can_commands_table_t audi_a3_can_commands_table[]=
{
  {WINDOWS_CLOSING_CMD_TYPE,        CAN1, .id_type=STD_ID_TYPE, .id_1=0x185, .repeats_1=4, .mess_1={0x22,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, .len_1=8, .delay_1=50, .id_2=0x185, .repeats_2=4, .mess_2={0x00,0x22,0x00,0x00,0x00,0x00,0x00,0x00}, .len_2=8, .delay_2=50, .seq_repeats=1},//для старых A3, на новых закрывается только водительская
  {WINDOWS_CLOSING_NEW_A3_CMD_TYPE, CAN1, .id_type=STD_ID_TYPE, .id_1=0x184, .repeats_1=1, .mess_1={0x00,0x00,0x00,0x02,0x02,0xAA,0x04,0x00}, .len_1=8, .delay_1=25, .id_2=0x184, .repeats_2=1, .mess_2={0x00,0x0F,0x00,0x02,0x02,0xAA,0x06,0x00}, .len_2=8, .delay_2=25, .seq_repeats=125},//для новых A3, на старых не закрываются задние окна
  {SILENT_HORN_CMD_TYPE,            CAN1, .id_type=STD_ID_TYPE, .id_1=0x3EB, .repeats_1=2, .mess_1={0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00}, .len_1=8, .delay_1=10, .id_2=0x3EB, .repeats_2=2, .mess_2={0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, .len_2=8, .delay_2=10, .seq_repeats=1},//не гудим, т.к. громко
  {HORN_CMD_TYPE,                   CAN1, .id_type=STD_ID_TYPE, .id_1=0x3EB, .repeats_1=1, .mess_1={0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00}, .len_1=8, .delay_1=50, .id_2=0, .repeats_2=0, .mess_2={0}, .len_2=0, .delay_2=0, .seq_repeats=1},
  {CENTRAL_LOCK_CLOSE_CMD_TYPE,     CAN1, .id_type=STD_ID_TYPE, .id_1=0x184, .repeats_1=2, .mess_1={0x00,0x50,0x00,0x00,0x00,0x00,0x00,0x00}, .len_1=8, .delay_1=50, .id_2=0x3D0, .repeats_2=2, .mess_2={0x40,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, .len_2=8, .delay_2=50, .seq_repeats=1},
  {CENTRAL_LOCK_OPEN_CMD_TYPE,      CAN1, .id_type=STD_ID_TYPE, .id_1=0x184, .repeats_1=2, .mess_1={0x00,0xA0,0x00,0x00,0x00,0x00,0x00,0x00}, .len_1=8, .delay_1=50, .id_2=0x3D0, .repeats_2=2, .mess_2={0x20,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, .len_2=8, .delay_2=50, .seq_repeats=1},
};

//Audi Q3
static const uint16_t AUDI_Q3_CAN1_SPEED=100;

static const can_filter_t audi_q3_2018_can1[]=
{
  {.bank_type=STD_ID_FILTER_BANK_TYPE, {.std.value1=0x470, .std.value2=0x531, .std.value3=0x575, .std.value4=0x151}},
  {.bank_type=STD_ID_FILTER_BANK_TYPE, {.std.value1=0x3B5, .std.value2=0x621, .std.value3=0x400, .std.value4=0x629}},
  {.bank_type=STD_ID_FILTER_BANK_TYPE, {.std.value1=0x000, .std.value2=0x000, .std.value3=0x000, .std.value4=0x000}},
};
static_assert(!(sizeof(audi_q3_2018_can1)>MAX_FILTER_TABLE_SIZE-1), "wrong audi_q3_2018_can1 filter size");

static const uint16_t AUDI_Q3_CAN2_SPEED=500;

static const can_filter_t audi_q3_2018_can2[]=
{
  {.bank_type=STD_ID_FILTER_BANK_TYPE, {.std.value1=0x280, .std.value2=0x288, .std.value3=0x443, .std.value4=0x448}},
  {.bank_type=STD_ID_FILTER_BANK_TYPE, {.std.value1=0x480, .std.value2=0x48A, .std.value3=0x520, .std.value4=0x5A0}},
  {.bank_type=STD_ID_FILTER_BANK_TYPE, {.std.value1=0x7E8, .std.value2=0x320, .std.value3=0x440, .std.value4=0x570}},
  {.bank_type=STD_ID_FILTER_BANK_TYPE, {.std.value1=0x0D0, .std.value2=0x3D0, .std.value3=0x000, .std.value4=0x000}},
  {.bank_type=STD_ID_W_MASK_FILTER_BANK_TYPE, {.std_w_mask.value1=0x700, .std_w_mask.mask1=0x700, .std_w_mask.value2=0x700, .std_w_mask.mask2=0x700}},
};
static_assert(!(sizeof(audi_q3_2018_can2)>MAX_FILTER_TABLE_SIZE-1), "wrong audi_q3_2018_can2 filter size");

static const can_commands_table_t audi_q3_can_commands_table[]=
{
  {PARKING_LIGHT_ON_CMD_TYPE,    CAN1, .id_type=STD_ID_TYPE, .id_1=0x2C1, .repeats_1=4,  .mess_1={0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, .len_1=8, .delay_1=100, .id_2=0, .repeats_2=0, .mess_2={0}, .len_2=0, .delay_2=0, .seq_repeats=1},
  {WINDOWS_CLOSING_CMD_TYPE,     CAN1, .id_type=STD_ID_TYPE, .id_1=0x391, .repeats_1=8,  .mess_1={0x00,0x80,0x00,0x00,0x00,0x00,0x00,0x00}, .len_1=3, .delay_1=100, .id_2=0x391, .repeats_2=8, .mess_2={0x55,0x80,0x00,0x00,0x00,0x00,0x00,0x00}, .len_2=3, .delay_2=100, .seq_repeats=1},
  //{SILENT_HORN_CMD_TYPE,       CAN1, .id_type=STD_ID_TYPE, .id_1=0x2C1, .repeats_1=1,  .mess_1={0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, .len_1=8, .delay_1=50,  .id_2=0, .repeats_2=0, .mess_2={0}, .len_2=0, .delay_2=0, .seq_repeats=1},//не гудим, т.к. громко
  {HORN_CMD_TYPE,                CAN1, .id_type=STD_ID_TYPE, .id_1=0x2C1, .repeats_1=4,  .mess_1={0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, .len_1=8, .delay_1=10,  .id_2=0, .repeats_2=0, .mess_2={0}, .len_2=0, .delay_2=0, .seq_repeats=1},
  //{CENTRAL_LOCK_CLOSE_CMD_TYPE,  CAN1, .id_type=STD_ID_TYPE, .id_1=0x381, .repeats_1=10, .mess_1={0xC0,0x0F,0x00,0x8C,0x00,0x00,0x00,0x00}, .len_1=6, .delay_1=10,  .id_2=0, .repeats_2=0, .mess_2={0}, .len_2=0, .delay_2=0, .seq_repeats=1},//только двери, на новых Q3 проблема с зеркалами
  //{CENTRAL_LOCK_OPEN_CMD_TYPE,   CAN1, .id_type=STD_ID_TYPE, .id_1=0x381, .repeats_1=10, .mess_1={0xA0,0x0F,0x00,0x8C,0x00,0x00,0x00,0x00}, .len_1=6, .delay_1=10,  .id_2=0, .repeats_2=0, .mess_2={0}, .len_2=0, .delay_2=0, .seq_repeats=1},//только двери, на новых Q3 проблема с зеркалами
  {CENTRAL_LOCK_CLOSE_CMD_TYPE,  CAN1, .id_type=STD_ID_TYPE, .id_1=0x391, .repeats_1=4, .mess_1={0x55,0x80,0x00,0x00,0x00,0x00,0x00,0x00}, .len_1=3, .delay_1=25,  .id_2=0x381, .repeats_2=10, .mess_2={0xC0,0x0F,0x00,0x8C,0x00,0x00,0x00,0x00}, .len_2=6, .delay_2=10, .seq_repeats=1},//зеркала + двери len=3???
  {CENTRAL_LOCK_OPEN_CMD_TYPE,   CAN1, .id_type=STD_ID_TYPE, .id_1=0x391, .repeats_1=4, .mess_1={0x55,0x40,0x00,0x8C,0x00,0x00,0x00,0x00}, .len_1=3, .delay_1=25,  .id_2=0x381, .repeats_2=10, .mess_2={0xA0,0x0F,0x00,0x8C,0x00,0x00,0x00,0x00}, .len_2=6, .delay_2=10, .seq_repeats=1},//зеркала + двери len=3???
};

static const can_commands_table_t vw_caddy_can_commands_table[]=
{
  {CENTRAL_LOCK_CLOSE_CMD_TYPE,  CAN1, .id_type=STD_ID_TYPE, .id_1=0x381, .repeats_1=5, .mess_1={0x40,0x0C,0xC8,0x80,0x02,0x00,0x00,0x00}, .len_1=6, .delay_1=30,  .id_2=0x000, .repeats_2=0, .mess_2={0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, .len_2=0, .delay_2=0, .seq_repeats=1},
  {CENTRAL_LOCK_OPEN_CMD_TYPE,   CAN1, .id_type=STD_ID_TYPE, .id_1=0x381, .repeats_1=5, .mess_1={0x20,0x0C,0xC8,0x80,0x02,0x00,0x00,0x00}, .len_1=6, .delay_1=30,  .id_2=0x000, .repeats_2=0, .mess_2={0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, .len_2=0, .delay_2=0, .seq_repeats=1},
};

//Porsche Macan, Porsche 911 2018
static const uint16_t PORSCHE_CAN1_SPEED=500;

static const can_filter_t porsche_2018_can1[]=
{
  {.bank_type=STD_ID_FILTER_BANK_TYPE, {.std.value1=0x582, .std.value2=0x662, .std.value3=0x3D0, .std.value4=0x3D1}},
  {.bank_type=STD_ID_FILTER_BANK_TYPE, {.std.value1=0x3D2, .std.value2=0x3D3, .std.value3=0x000, .std.value4=0x000}},
};
static_assert(!(sizeof(porsche_2018_can1)>MAX_FILTER_TABLE_SIZE-1), "wrong porsche_2018_can1 filter size");

static const uint16_t PORSCHE_CAN2_SPEED=500;

static const can_filter_t porsche_2018_can2[]=
{
  {.bank_type=STD_ID_FILTER_BANK_TYPE, {.std.value1=0x308, .std.value2=0x105, .std.value3=0x107, .std.value4=0x390}},
  {.bank_type=STD_ID_FILTER_BANK_TYPE, {.std.value1=0x3C0, .std.value2=0x440, .std.value3=0x103, .std.value4=0x640}},
  {.bank_type=STD_ID_FILTER_BANK_TYPE, {.std.value1=0x674, .std.value2=0x7E8, .std.value3=0x086, .std.value4=0x040}},
  {.bank_type=STD_ID_FILTER_BANK_TYPE, {.std.value1=0x6B7, .std.value2=0x6B2, .std.value3=0x3C3, .std.value4=0x393}},
  {.bank_type=STD_ID_FILTER_BANK_TYPE, {.std.value1=0x11A, .std.value2=0x5EC, .std.value3=0x6A1, .std.value4=0x363}},
  {.bank_type=STD_ID_FILTER_BANK_TYPE, {.std.value1=0x444, .std.value2=0x000, .std.value3=0x000, .std.value4=0x000}},
  {.bank_type=STD_ID_W_MASK_FILTER_BANK_TYPE, {.std_w_mask.value1=0x700, .std_w_mask.mask1=0x700, .std_w_mask.value2=0x700, .std_w_mask.mask2=0x700}},
};
static_assert(!(sizeof(porsche_2018_can2)>MAX_FILTER_TABLE_SIZE-1), "wrong porsche_2018_can2 filter size");

static const uint16_t PORSCHE_CAN3_SPEED=500;

static const can_filter_t porsche_2018_can3[]=
{
  {.bank_type=STD_ID_W_MASK_FILTER_BANK_TYPE, {.std_w_mask.value1=0x700, .std_w_mask.mask1=0x700, .std_w_mask.value2=0x700, .std_w_mask.mask2=0x700}},
};
static_assert(!(sizeof(porsche_2018_can3)>MAX_FILTER_TABLE_SIZE-1), "wrong porsche_2018_can3 filter size");

static const can_commands_table_t porsche_can_commands_table[]=
{
  ////{PARKING_LIGHT_ON_CMD_TYPE,            CAN1, .id_type=STD_ID_TYPE, .id_1=0x3C2, .repeats_1=1,  .mess_1={0x01,0x00,0x0D,0x80,0x00,0x01,0x00,0x00}, .len_1=8, .delay_1=2000,  .id_2=0x3C2, .repeats_2=1, .mess_2={0x02,0x00,0x0D,0x80,0x00,0x01,0x00,0x00}, .len_2=8, .delay_2=10, .seq_repeats=1},
  //{PARKING_LIGHT_ON_CMD_TYPE,              CAN1, .id_type=STD_ID_TYPE, .id_1=0x363, .repeats_1=1,  .mess_1={0x00,0x04,0x1f,0x00,0x00,0x00,0x00,0x00}, .len_1=4, .delay_1=200, .id_2=0x363, .repeats_2=1, .mess_2={0x00,0x00,0x10,0x00,0x00,0x00,0x00,0x00}, .len_2=4, .delay_2=10, .seq_repeats=1},
  {PARKING_LIGHT_ON_CMD_TYPE,              CAN1, .id_type=STD_ID_TYPE, .id_1=0x70E, .repeats_1=1,  .mess_1={0x02,0x10,0x4F,0x00,0xAA,0xAA,0xAA,0xAA}, .len_1=8, .delay_1=20,  .id_2=0x70E, .repeats_2=1, .mess_2={0x04,0x31,0x01,0x04,0x17,0xAA,0xAA,0xAA}, .len_2=8, .delay_2=150, .seq_repeats=1},
  {PARKING_LIGHT_OFF_CMD_TYPE,             CAN1, .id_type=STD_ID_TYPE, .id_1=0x70E, .repeats_1=2,  .mess_1={0x04,0x31,0x02,0x04,0x17,0xAA,0xAA,0xAA}, .len_1=8, .delay_1=50,  .id_2=0,     .repeats_2=0, .mess_2={0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, .len_2=0, .delay_2=0, .seq_repeats=1},
  {WINDOWS_CLOSING_CMD_TYPE,               CAN1, .id_type=STD_ID_TYPE, .id_1=0x3D7, .repeats_1=30, .mess_1={0x00,0x00,0x00,0x00,0x11,0x11,0x00,0x00}, .len_1=8, .delay_1=200, .id_2=0x3D7, .repeats_2=50, .mess_2={0x00,0x00,0x00,0x00,0x11,0x11,0x00,0x00}, .len_2=8, .delay_2=100, .seq_repeats=1},
  //{CENTRAL_LOCK_CLOSE_PORSCHE_1_CMD_TYPE,  CAN1, .id_type=STD_ID_TYPE, .id_1=0x180, .repeats_1=3,  .mess_1={0x55,0x01,0x00,0x80,0x00,0x00,0x00,0x00}, .len_1=8, .delay_1=100, .id_2=0x180, .repeats_2=2, .mess_2={0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, .len_2=8, .delay_2=100, .seq_repeats=1},
  //{CENTRAL_LOCK_CLOSE_PORSCHE_2_CMD_TYPE,  CAN1, .id_type=STD_ID_TYPE, .id_1=0x180, .repeats_1=1,  .mess_1={0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x00}, .len_1=8, .delay_1=100, .id_2=0x180, .repeats_2=0, .mess_2={0x00,0x04,0x55,0x00,0x00,0x00,0x00,0x00}, .len_2=8, .delay_2=100, .seq_repeats=1},
  //{CENTRAL_LOCK_OPEN_CMD_TYPE,             CAN1, .id_type=STD_ID_TYPE, .id_1=0x180, .repeats_1=3,  .mess_1={0xAA,0x00,0x00,0x40,0x00,0x00,0x00,0x00}, .len_1=8, .delay_1=100, .id_2=0, .repeats_2=0, .mess_2={0}, .len_2=0, .delay_2=0, .seq_repeats=1},
  //как на пандоре
  {CENTRAL_LOCK_CLOSE_PORSCHE_1_CMD_TYPE,  CAN1, .id_type=STD_ID_TYPE, .id_1=0x7F8, .repeats_1=5, .mess_1={0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, .len_1=1, .delay_1=10,  .id_2=0x3D0, .repeats_2=8, .mess_2={0x40,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, .len_2=8, .delay_2=10,    .seq_repeats=1},
  {CENTRAL_LOCK_OPEN_CMD_TYPE,             CAN1, .id_type=STD_ID_TYPE, .id_1=0x7F8, .repeats_1=5, .mess_1={0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, .len_1=1, .delay_1=10,  .id_2=0x3D0, .repeats_2=8, .mess_2={0x20,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, .len_2=8, .delay_2=10,    .seq_repeats=1},
  {TRUNK_OPEN_CMD_TYPE,                    CAN1, .id_type=STD_ID_TYPE, .id_1=0x6A1, .repeats_1=3, .mess_1={0x00,0xC1,0x01,0x02,0x14,0x10,0x00,0x00}, .len_1=8, .delay_1=100, .id_2=0x1A1, .repeats_2=20, .mess_2={0x01,0x00,0x20,0x00,0x00,0xC0,0x01,0x00}, .len_2=8, .delay_2=100, .seq_repeats=1},
  //проверить гудок на 911
  {HORN_CMD_TYPE,                          CAN1, .id_type=STD_ID_TYPE, .id_1=0x3C2, .repeats_1=4, .mess_1={0x00,0x02,0x01,0x80,0x80,0x01,0x00,0x00}, .len_1=8, .delay_1=100,
                                                                       .id_2=0x3C2, .repeats_2=4, .mess_2={0x00,0x02,0x01,0x80,0x00,0x01,0x00,0x00}, .len_2=8, .delay_2=10, .seq_repeats=1},
  {SILENT_HORN_CMD_TYPE,                   CAN1, .id_type=STD_ID_TYPE, .id_1=0x3C2, .repeats_1=2, .mess_1={0x00,0x02,0x01,0x80,0x80,0x01,0x00,0x00}, .len_1=8, .delay_1=10,
                                                                       .id_2=0x3C2, .repeats_2=4, .mess_2={0x00,0x02,0x01,0x80,0x00,0x01,0x00,0x00}, .len_2=8, .delay_2=10, .seq_repeats=1},
};

//Porsche Panamera 2019
static const uint16_t PORSCHE_PANAMERA_CAN1_SPEED=500;

static const can_filter_t porsche_panamera_2019_can1[]=
{
  {.bank_type=STD_ID_FILTER_BANK_TYPE, {.std.value1=0x3D0, .std.value2=0x3D1, .std.value3=0x3CE, .std.value4=0x3CF}},
  {.bank_type=STD_ID_FILTER_BANK_TYPE, {.std.value1=0x65A, .std.value2=0x3C0, .std.value3=0x104, .std.value4=0x0AD}},
  {.bank_type=STD_ID_FILTER_BANK_TYPE, {.std.value1=0x0A8, .std.value2=0x0A0, .std.value3=0x520, .std.value4=0x6B2}},
  {.bank_type=STD_ID_FILTER_BANK_TYPE, {.std.value1=0x462, .std.value2=0x582, .std.value3=0x640, .std.value4=0x30B}},
  {.bank_type=STD_ID_FILTER_BANK_TYPE, {.std.value1=0x3D5, .std.value2=0x395, .std.value3=0x6AE, .std.value4=0x121}},
  {.bank_type=STD_ID_FILTER_BANK_TYPE, {.std.value1=0x106, .std.value2=0x366, .std.value3=0x3C7, .std.value4=0x040}},
  {.bank_type=STD_ID_FILTER_BANK_TYPE, {.std.value1=0x31B, .std.value2=0x5E0, .std.value3=0x000, .std.value4=0x000}},
  {.bank_type=STD_ID_W_MASK_FILTER_BANK_TYPE, {.std_w_mask.value1=0x700, .std_w_mask.mask1=0x700, .std_w_mask.value2=0x700, .std_w_mask.mask2=0x700}},
};
static_assert(!(sizeof(porsche_panamera_2019_can1)>MAX_FILTER_TABLE_SIZE-1), "wrong porsche_panamera_2019_can1 filter size");

static const uint16_t PORSCHE_PANAMERA_CAN3_SPEED=500;

static const can_filter_t porsche_panamera_2019_can3[]=
{
  {.bank_type=STD_ID_W_MASK_FILTER_BANK_TYPE, {.std_w_mask.value1=0x700, .std_w_mask.mask1=0x700, .std_w_mask.value2=0x700, .std_w_mask.mask2=0x700}},
};
static_assert(!(sizeof(porsche_panamera_2019_can3)>MAX_FILTER_TABLE_SIZE-1), "wrong porsche_panamera_2019_can3 filter size");

static const can_commands_table_t porsche_panamera_2019_can_commands_table[]=
{
  //{CENTRAL_LOCK_CLOSE_CMD_TYPE, CAN1, .id_type=STD_ID_TYPE, .id_1=0x184, .repeats_1=11, .mess_1={0x55,0x55,0x55,0x00,0x00,0x00,0x04,0x00}, .len_1=8, .delay_1=100, .id_2=0x000, .repeats_2=0,  .mess_2={0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, .len_2=0, .delay_2=0,   .seq_repeats=1},
  //{CENTRAL_LOCK_OPEN_CMD_TYPE,  CAN1, .id_type=STD_ID_TYPE, .id_1=0x184, .repeats_1=11, .mess_1={0xAA,0xAA,0xAA,0x00,0x00,0x00,0x04,0x00}, .len_1=8, .delay_1=100, .id_2=0x000, .repeats_2=0,  .mess_2={0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, .len_2=0, .delay_2=0,   .seq_repeats=1},
  {CENTRAL_LOCK_CLOSE_CMD_TYPE, CAN1, .id_type=STD_ID_TYPE, .id_1=0x3D1, .repeats_1=15, .mess_1={0x40,0x00,0x00,0x00,0x00,0x00,0x00,0x20}, .len_1=8, .delay_1=100,
                                                            .id_2=0x000, .repeats_2=0,  .mess_2={0}, .len_2=0, .delay_2=0, .seq_repeats=1},

  {CENTRAL_LOCK_OPEN_CMD_TYPE,  CAN1, .id_type=STD_ID_TYPE, .id_1=0x3D1, .repeats_1=5,  .mess_1={0x20,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, .len_1=8, .delay_1=10,
                                                            .id_2=0x3D1, .repeats_2=5,  .mess_2={0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, .len_2=8, .delay_2=10,  .seq_repeats=1},

  {ROOF_CLOSING_CMD_TYPE,       CAN1, .id_type=STD_ID_TYPE, .id_1=0x598, .repeats_1=4,  .mess_1={0x00,0x00,0x00,0x00,0x0A,0x80,0x00,0x02}, .len_1=8, .delay_1=100,
                                                            .id_2=0x000, .repeats_2=0,  .mess_2={0}, .len_2=0, .delay_2=0,  .seq_repeats=1},

  {HORN_CMD_TYPE,               CAN1, .id_type=STD_ID_TYPE, .id_1=0x331, .repeats_1=1,  .mess_1={0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01}, .len_1=8, .delay_1=50, .id_2=0x000, .repeats_2=0,  .mess_2={0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, .len_2=0, .delay_2=0,   .seq_repeats=1},
  {PARKING_LIGHT_ON_CMD_TYPE,   CAN1, .id_type=STD_ID_TYPE, .id_1=0x366, .repeats_1=5,  .mess_1={0x00,0x00,0x10,0x1E,0x01,0x00,0x00,0x00}, .len_1=8, .delay_1=100, .id_2=0x000, .repeats_2=0,  .mess_2={0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, .len_2=0, .delay_2=0,   .seq_repeats=1},

  {PANAMERA_WINDOWS_CLOSING1_1_CMD_TYPE, CAN1, .id_type=STD_ID_TYPE, .id_1=0x74B, .repeats_1=1,  .mess_1={0x02,0x10,0x03,0x55,0x55,0x55,0x55,0x55}, .len_1=8, .delay_1=200, .id_2=0x74B, .repeats_2=1,  .mess_2={0x10,0x08,0x2F,0x04,0x11,0x03,0x0A,0x00}, .len_2=8, .delay_2=200, .seq_repeats=1},
  {PANAMERA_WINDOWS_CLOSING1_2_CMD_TYPE, CAN1, .id_type=STD_ID_TYPE, .id_1=0x74B, .repeats_1=1,  .mess_1={0x21,0x00,0x00,0x55,0x55,0x55,0x55,0x55}, .len_1=8, .delay_1=200, .id_2=0x000, .repeats_2=0,  .mess_2={0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, .len_2=0, .delay_2=0,   .seq_repeats=1},

  {PANAMERA_WINDOWS_CLOSING2_1_CMD_TYPE, CAN1, .id_type=STD_ID_TYPE, .id_1=0x74A, .repeats_1=1,  .mess_1={0x02,0x10,0x03,0x55,0x55,0x55,0x55,0x55}, .len_1=8, .delay_1=200, .id_2=0x74A, .repeats_2=1,  .mess_2={0x10,0x08,0x2F,0x04,0x10,0x03,0x0A,0x00}, .len_2=8, .delay_2=200, .seq_repeats=1},
  {PANAMERA_WINDOWS_CLOSING2_2_CMD_TYPE, CAN1, .id_type=STD_ID_TYPE, .id_1=0x74A, .repeats_1=1,  .mess_1={0x21,0x00,0x00,0x55,0x55,0x55,0x55,0x55}, .len_1=8, .delay_1=200, .id_2=0x000, .repeats_2=0,  .mess_2={0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, .len_2=0, .delay_2=0,   .seq_repeats=1},

  {PANAMERA_WINDOWS_CLOSING3_1_CMD_TYPE, CAN1, .id_type=STD_ID_TYPE, .id_1=0x73E, .repeats_1=1,  .mess_1={0x02,0x10,0x03,0x55,0x55,0x55,0x55,0x55}, .len_1=8, .delay_1=200, .id_2=0x73E, .repeats_2=1,  .mess_2={0x10,0x08,0x2F,0x04,0x12,0x03,0x0A,0x00}, .len_2=8, .delay_2=200, .seq_repeats=1},
  {PANAMERA_WINDOWS_CLOSING3_2_CMD_TYPE, CAN1, .id_type=STD_ID_TYPE, .id_1=0x73E, .repeats_1=1,  .mess_1={0x21,0x00,0x00,0x55,0x55,0x55,0x55,0x55}, .len_1=8, .delay_1=200, .id_2=0x000, .repeats_2=0,  .mess_2={0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, .len_2=0, .delay_2=0,   .seq_repeats=1},

  {PANAMERA_WINDOWS_CLOSING4_1_CMD_TYPE, CAN1, .id_type=STD_ID_TYPE, .id_1=0x73F, .repeats_1=1,  .mess_1={0x02,0x10,0x03,0x55,0x55,0x55,0x55,0x55}, .len_1=8, .delay_1=200, .id_2=0x73F, .repeats_2=1,  .mess_2={0x10,0x08,0x2F,0x04,0x13,0x03,0x0A,0x00}, .len_2=8, .delay_2=200, .seq_repeats=1},
  {PANAMERA_WINDOWS_CLOSING4_2_CMD_TYPE, CAN1, .id_type=STD_ID_TYPE, .id_1=0x73F, .repeats_1=1,  .mess_1={0x21,0x00,0x00,0x55,0x55,0x55,0x55,0x55}, .len_1=8, .delay_1=200, .id_2=0x000, .repeats_2=0,  .mess_2={0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, .len_2=0, .delay_2=0,   .seq_repeats=1},
};

//MB E200
static const uint16_t MB_E200_CAN1_SPEED=250;

static const can_filter_t mb_e200_2018_can1[]=
{
  {.bank_type=STD_ID_FILTER_BANK_TYPE, {.std.value1=0x397, .std.value2=0x39B, .std.value3=0x3A3, .std.value4=0x3A5}},
  {.bank_type=STD_ID_FILTER_BANK_TYPE, {.std.value1=0x351, .std.value2=0x337, .std.value3=0x33D, .std.value4=0x335}},
  {.bank_type=STD_ID_FILTER_BANK_TYPE, {.std.value1=0x31A, .std.value2=0x320, .std.value3=0x32E, .std.value4=0x328}},
  {.bank_type=STD_ID_FILTER_BANK_TYPE, {.std.value1=0x2FB, .std.value2=0x15F, .std.value3=0x33B, .std.value4=0x15B}},
  {.bank_type=STD_ID_FILTER_BANK_TYPE, {.std.value1=0x17F, .std.value2=0x000, .std.value3=0x000, .std.value4=0x000}},
};
static_assert(!(sizeof(mb_e200_2018_can1)>MAX_FILTER_TABLE_SIZE-1), "wrong mb_e200_2018_can1 filter size");

static const uint16_t MB_E200_CAN2_SPEED=500;

static const can_filter_t mb_e200_2018_can2[]=
{
  {.bank_type=STD_ID_FILTER_BANK_TYPE, {.std.value1=0x020, .std.value2=0x2C7, .std.value3=0x141, .std.value4=0x147}},
  {.bank_type=STD_ID_FILTER_BANK_TYPE, {.std.value1=0x2FE, .std.value2=0x10D, .std.value3=0x3C2, .std.value4=0x2CF}},
  {.bank_type=STD_ID_FILTER_BANK_TYPE, {.std.value1=0x309, .std.value2=0x098, .std.value3=0x0B1, .std.value4=0x339}},
  {.bank_type=STD_ID_FILTER_BANK_TYPE, {.std.value1=0x087, .std.value2=0x000, .std.value3=0x000, .std.value4=0x000}},
  {.bank_type=STD_ID_W_MASK_FILTER_BANK_TYPE, {.std_w_mask.value1=0x700, .std_w_mask.mask1=0x700, .std_w_mask.value2=0x700, .std_w_mask.mask2=0x700}},
};
static_assert(!(sizeof(mb_e200_2018_can2)>MAX_FILTER_TABLE_SIZE-1), "wrong mb_e200_2018_can2 filter size");

/*
//OBD, на E200 не подключен
static const uint16_t MB_E200_CAN3_SPEED=500;

static const can_filter_t mb_e200_2018_can3[]=
{
  {.bank_type=STD_ID_W_MASK_FILTER_BANK_TYPE, {.std_w_mask.value1=0x000, .std_w_mask.mask1=0x000, .std_w_mask.value2=0x000, .std_w_mask.mask2=0x000}},
  {.bank_type=STD_ID_FILTER_BANK_TYPE,        {.std.value1=0x000, .std.value2=0x000, .std.value3=0x000, .std.value4=0x000}},
};
static_assert(!(sizeof(mb_e200_2018_can3)>MAX_FILTER_TABLE_SIZE-1), "wrong mb_e200_2018_can3 filter size");
*/

static const can_commands_table_t mb_e200_2018_can_commands_table[]=
{
  {PARKING_LIGHT_ON_CMD_TYPE,    CAN1, .id_type=STD_ID_TYPE, .id_1=0x11F, .repeats_1=2,  .mess_1={0x00,0x00,0x1E,0x07,0x00,0x00,0x00,0x00}, .len_1=4, .delay_1=50, .id_2=0x11F, .repeats_2=2, .mess_2={0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, .len_2=4, .delay_2=50, .seq_repeats=2},
  {WINDOWS_CLOSING_CMD_TYPE,     CAN1, .id_type=STD_ID_TYPE, .id_1=0x079, .repeats_1=1,  .mess_1={0x06,0x02,0x00,0x00,0x00,0x00,0x00,0x00}, .len_1=2, .delay_1=30, .id_2=0x079, .repeats_2=1, .mess_2={0x07,0x02,0x00,0x00,0x00,0x00,0x00,0x00}, .len_2=2, .delay_2=30,  .seq_repeats=130},//работает только при постановке на охрану, повторять эту последовательность пока не закроются окна
  {CENTRAL_LOCK_CLOSE_CMD_TYPE,  CAN1, .id_type=STD_ID_TYPE, .id_1=0x307, .repeats_1=10, .mess_1={0x00,0x11,0x11,0x55,0x00,0x00,0x00,0x00}, .len_1=8, .delay_1=25, .id_2=0,     .repeats_2=0, .mess_2={0}, .len_2=0, .delay_2=0, .seq_repeats=1},
  {CENTRAL_LOCK_OPEN_CMD_TYPE,   CAN1, .id_type=STD_ID_TYPE, .id_1=0x307, .repeats_1=20, .mess_1={0x00,0x22,0x22,0xAA,0x00,0x00,0x00,0x00}, .len_1=8, .delay_1=25, .id_2=0,     .repeats_2=0, .mess_2={0}, .len_2=0, .delay_2=0, .seq_repeats=1},
};

//Toyota RAV4
static const uint16_t TOYOTA_RAV4_2019_CAN1_SPEED=500;

static const can_filter_t toyota_rav4_2019_can1[]=
{
  {.bank_type=STD_ID_FILTER_BANK_TYPE, {.std.value1=0x361, .std.value2=0x3BB, .std.value3=0x3BC, .std.value4=0x617}},
  {.bank_type=STD_ID_FILTER_BANK_TYPE, {.std.value1=0x0B4, .std.value2=0x611, .std.value3=0x1C4, .std.value4=0x619}},
  {.bank_type=STD_ID_FILTER_BANK_TYPE, {.std.value1=0x620, .std.value2=0x639, .std.value3=0x4A5, .std.value4=0x622}},
  {.bank_type=STD_ID_FILTER_BANK_TYPE, {.std.value1=0x025, .std.value2=0x226, .std.value3=0x3B7, .std.value4=0x6E1}},
  {.bank_type=STD_ID_FILTER_BANK_TYPE, {.std.value1=0x614, .std.value2=0x610, .std.value3=0x638, .std.value4=0x612}},
  {.bank_type=STD_ID_FILTER_BANK_TYPE, {.std.value1=0x7C8, .std.value2=0x000, .std.value3=0x000, .std.value4=0x000}},
  {.bank_type=STD_ID_W_MASK_FILTER_BANK_TYPE, {.std_w_mask.value1=0x700, .std_w_mask.mask1=0x700, .std_w_mask.value2=0x700, .std_w_mask.mask2=0x700}},
};
static_assert(!(sizeof(toyota_rav4_2019_can1)>MAX_FILTER_TABLE_SIZE-1), "wrong toyota_rav4_2019_can1 filter size");

static const uint16_t TOYOTA_RAV4_2019_CAN2_SPEED=500;

static const can_filter_t toyota_rav4_2019_can2[]=
{
  {.bank_type=STD_ID_W_MASK_FILTER_BANK_TYPE, {.std_w_mask.value1=0x000, .std_w_mask.mask1=0x000, .std_w_mask.value2=0x000, .std_w_mask.mask2=0x000}},
  {.bank_type=STD_ID_FILTER_BANK_TYPE,        {.std.value1=0x000, .std.value2=0x000, .std.value3=0x000, .std.value4=0x000}},
};
static_assert(!(sizeof(toyota_rav4_2019_can2)>MAX_FILTER_TABLE_SIZE-1), "wrong toyota_rav4_2019_can2 filter size");

static const uint16_t TOYOTA_RAV4_2019_CAN3_SPEED=500;

static const can_filter_t toyota_rav4_2019_can3[]=
{
  {.bank_type=STD_ID_W_MASK_FILTER_BANK_TYPE, {.std_w_mask.value1=0x000, .std_w_mask.mask1=0x000, .std_w_mask.value2=0x000, .std_w_mask.mask2=0x000}},
  {.bank_type=STD_ID_FILTER_BANK_TYPE,        {.std.value1=0x000, .std.value2=0x000, .std.value3=0x000, .std.value4=0x000}},
};
static_assert(!(sizeof(toyota_rav4_2019_can3)>MAX_FILTER_TABLE_SIZE-1), "wrong toyota_rav4_2019_can3 filter size");

static const can_commands_table_t toyota_rav4_2019_can_commands_table[]=
{
  {PARKING_LIGHT_ON_CMD_TYPE,       CAN1, .id_type=STD_ID_TYPE, .id_1=0x623, .repeats_1=2, .mess_1={0x19,0x00,0x80,0x00,0x00,0x00,0x00,0x20}, .len_1=8, .delay_1=25,
                                                                .id_2=0,     .repeats_2=0, .mess_2={0}, .len_2=0, .delay_2=0, .seq_repeats=1},

  {DRIVER_WINDOW_CLOSING_CMD_TYPE,  CAN1, .id_type=STD_ID_TYPE, .id_1=0x750, .repeats_1=1, .mess_1={0x90,0x04,0x30,0x01,0x01,0x80,0x00,0x00}, .len_1=8, .delay_1=50,
                                                                .id_2=0,     .repeats_2=0, .mess_2={0}, .len_2=0, .delay_2=0, .seq_repeats=1},
  {PASS_WINDOW_CLOSING_CMD_TYPE,    CAN1, .id_type=STD_ID_TYPE, .id_1=0x750, .repeats_1=1, .mess_1={0x91,0x04,0x30,0x01,0x01,0x80,0x00,0x00}, .len_1=8, .delay_1=50,
                                                                .id_2=0,     .repeats_2=0, .mess_2={0}, .len_2=0, .delay_2=0, .seq_repeats=1},
  {REAR_R_WINDOW_CLOSING_CMD_TYPE,  CAN1, .id_type=STD_ID_TYPE, .id_1=0x750, .repeats_1=1, .mess_1={0x92,0x04,0x30,0x01,0x01,0x80,0x00,0x00}, .len_1=8, .delay_1=50,
                                                                .id_2=0,     .repeats_2=0, .mess_2={0}, .len_2=0, .delay_2=0, .seq_repeats=1},
  {REAR_L_WINDOW_CLOSING_CMD_TYPE,  CAN1, .id_type=STD_ID_TYPE, .id_1=0x750, .repeats_1=1, .mess_1={0x93,0x04,0x30,0x01,0x01,0x80,0x00,0x00}, .len_1=8, .delay_1=50,
                                                                .id_2=0,     .repeats_2=0, .mess_2={0}, .len_2=0, .delay_2=0, .seq_repeats=1},

  {CENTRAL_LOCK_CLOSE_CMD_TYPE,     CAN1, .id_type=STD_ID_TYPE, .id_1=0x750, .repeats_1=1, .mess_1={0x40,0x05,0x30,0x11,0x00,0x80,0x00,0x00}, .len_1=8, .delay_1=50,
                                                                .id_2=0,     .repeats_2=0, .mess_2={0}, .len_2=0, .delay_2=0, .seq_repeats=1},
  {CENTRAL_LOCK_OPEN_CMD_TYPE,      CAN1, .id_type=STD_ID_TYPE, .id_1=0x750, .repeats_1=1, .mess_1={0x40,0x05,0x30,0x11,0x00,0x40,0x00,0x00}, .len_1=8, .delay_1=50,
                                                                .id_2=0,     .repeats_2=0, .mess_2={0}, .len_2=0, .delay_2=0, .seq_repeats=1},
  //гудим аналогом
  //{HORN_CMD_TYPE,                   CAN1, .id_type=STD_ID_TYPE, .id_1=0x750, .repeats_1=2, .mess_1={0x40,0x04,0x30,0x06,0x00,0x20,0x00,0x00}, .len_1=8, .delay_1=100,
  //                                                              .id_2=0x750, .repeats_2=4, .mess_2={0x40,0x04,0x30,0x06,0x00,0x00,0x00,0x00}, .len_2=8, .delay_2=10,   .seq_repeats=1},
  //{SILENT_HORN_CMD_TYPE,            CAN1, .id_type=STD_ID_TYPE, .id_1=0x750, .repeats_1=2, .mess_1={0x40,0x04,0x30,0x06,0x00,0x20,0x00,0x00}, .len_1=8, .delay_1=20,
  //                                                             .id_2=0x750, .repeats_2=4, .mess_2={0x40,0x04,0x30,0x06,0x00,0x00,0x00,0x00}, .len_2=8, .delay_2=10,   .seq_repeats=1},
};

//BMW 520i
static const uint16_t BMW_520I_CAN1_SPEED=500;

static const can_filter_t bmw_520i_2018_can1[]=
{
  {.bank_type=STD_ID_FILTER_BANK_TYPE, {.std.value1=0x612, .std.value2=0x03C, .std.value3=0x130, .std.value4=0x799}}, //для определения активности на 7й серии можно использовать 0x03C и 0x130
  {.bank_type=STD_ID_FILTER_BANK_TYPE, {.std.value1=0x7C0, .std.value2=0x7C1, .std.value3=0x000, .std.value4=0x000}},//все для "не засыпания"
  {.bank_type=STD_ID_W_MASK_FILTER_BANK_TYPE, {.std_w_mask.value1=0x700, .std_w_mask.mask1=0x700, .std_w_mask.value2=0x700, .std_w_mask.mask2=0x700}},
};
static_assert(!(sizeof(bmw_520i_2018_can1)>MAX_FILTER_TABLE_SIZE-1), "wrong bmw_520i_2018_can1 filter size");

static const uint16_t BMW_520I_CAN2_SPEED=500;

static const can_filter_t bmw_520i_2018_can2[]=
{
  {.bank_type=STD_ID_FILTER_BANK_TYPE, {.std.value1=0x0A5, .std.value2=0x0C2, .std.value3=0x0EF, .std.value4=0x1B3}},
  {.bank_type=STD_ID_FILTER_BANK_TYPE, {.std.value1=0x0DC, .std.value2=0x2B5, .std.value3=0x330, .std.value4=0x12F}},
  {.bank_type=STD_ID_FILTER_BANK_TYPE, {.std.value1=0x21A, .std.value2=0x2FC, .std.value3=0x581, .std.value4=0x1A1}},
  {.bank_type=STD_ID_FILTER_BANK_TYPE, {.std.value1=0x0F3, .std.value2=0x1F6, .std.value3=0x3F9, .std.value4=0x302}},
};
static_assert(!(sizeof(bmw_520i_2018_can2)>MAX_FILTER_TABLE_SIZE-1), "wrong bmw_520i_2018_can2 filter size");

static const can_commands_table_t bmw_520i_can_commands_table[]=
{
  {PARKING_LIGHT_ON_CMD_TYPE,    CAN1, .id_type=STD_ID_TYPE, .id_1=0x6F1, .repeats_1=2, .mess_1={0x40,0x10,0x07,0x2E,0xD5,0x42,0x00,0x12}, .len_1=8, .delay_1=100,
                                                             .id_2=0x6F1, .repeats_2=4, .mess_2={0x40,0x21,0x00,0x20,0x00,0x00,0x00,0x00}, .len_2=4, .delay_2=10, .seq_repeats=1},
  {WINDOWS_CLOSING_CMD_TYPE,     CAN1, .id_type=STD_ID_TYPE, .id_1=0x6F1, .repeats_1=2, .mess_1={0x40,0x06,0x31,0x01,0xA1,0x7F,0x40,0x00}, .len_1=8, .delay_1=10,
                                                             .id_2=0,     .repeats_2=0, .mess_2={0}, .len_2=0, .delay_2=0, .seq_repeats=1},
  {WINDOWS_OPENING_CMD_TYPE,     CAN1, .id_type=STD_ID_TYPE, .id_1=0x6F1, .repeats_1=2, .mess_1={0x40,0x06,0x31,0x01,0xA1,0x7F,0x40,0x64}, .len_1=8, .delay_1=10,
                                                             .id_2=0,     .repeats_2=0, .mess_2={0}, .len_2=0, .delay_2=0, .seq_repeats=1},
  {CENTRAL_LOCK_CLOSE_CMD_TYPE,  CAN1, .id_type=STD_ID_TYPE, .id_1=0x6F1, .repeats_1=2, .mess_1={0x40,0x05,0x31,0x01,0xAC,0x57,0x02,0x00}, .len_1=7, .delay_1=10,
                                                             .id_2=0,     .repeats_2=0, .mess_2={0}, .len_2=0, .delay_2=0, .seq_repeats=1},
  {CENTRAL_LOCK_OPEN_CMD_TYPE,   CAN1, .id_type=STD_ID_TYPE, .id_1=0x6F1, .repeats_1=2, .mess_1={0x40,0x05,0x31,0x01,0xAC,0x57,0x01,0x00}, .len_1=7, .delay_1=10,
                                                             .id_2=0,     .repeats_2=0, .mess_2={0}, .len_2=0, .delay_2=0, .seq_repeats=1},
  {HORN_CMD_TYPE,                CAN1, .id_type=STD_ID_TYPE, .id_1=0x6F1, .repeats_1=1, .mess_1={0x40,0x05,0x2E,0xD2,0x98,0x00,0x64,0x00}, .len_1=7, .delay_1=200,
                                                             .id_2=0,     .repeats_2=0, .mess_2={0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, .len_2=0, .delay_2=0,   .seq_repeats=1},
  //{SILENT_HORN_CMD_TYPE,         CAN1, .id_type=STD_ID_TYPE, .id_1=0x6F1, .repeats_1=1, .mess_1={0x40,0x05,0x2E,0xD2,0x98,0x00,0x40,0x00}, .len_1=7, .delay_1=200,
  //                                                           .id_2=0,     .repeats_2=0, .mess_2={0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, .len_2=0, .delay_2=0,   .seq_repeats=1},
  {TRUNK_OPEN_CMD_TYPE,          CAN1, .id_type=STD_ID_TYPE, .id_1=0x6F1, .repeats_1=2, .mess_1={0x40,0x05,0x31,0x01,0xAC,0x57,0x05,0x00}, .len_1=7, .delay_1=10,
                                                             .id_2=0,     .repeats_2=0, .mess_2={0}, .len_2=0, .delay_2=0, .seq_repeats=1},
};

//Ford Transit
static const uint16_t FORD_TRANSIT_CAN1_SPEED=125;

static const can_filter_t ford_transit_2017_can1[]=
{
  {.bank_type=STD_ID_FILTER_BANK_TYPE, {.std.value1=0x127, .std.value2=0x0F1, .std.value3=0x102, .std.value4=0x10D}},
  {.bank_type=STD_ID_FILTER_BANK_TYPE, {.std.value1=0x0B9, .std.value2=0x320, .std.value3=0x080, .std.value4=0x000}},
};
static_assert(!(sizeof(ford_transit_2017_can1)>MAX_FILTER_TABLE_SIZE-1), "wrong ford_transit_2017_can1 filter size");

static const uint16_t FORD_TRANSIT_CAN2_SPEED=500;

static const can_filter_t ford_transit_2017_can2[]=
{
  {.bank_type=STD_ID_FILTER_BANK_TYPE, {.std.value1=0x7E8, .std.value2=0x010, .std.value3=0x122, .std.value4=0x211}},
  {.bank_type=STD_ID_FILTER_BANK_TYPE, {.std.value1=0x254, .std.value2=0x264, .std.value3=0x342, .std.value4=0x494}},
  {.bank_type=STD_ID_FILTER_BANK_TYPE, {.std.value1=0x299, .std.value2=0x170, .std.value3=0x000, .std.value4=0x000}},
  {.bank_type=STD_ID_W_MASK_FILTER_BANK_TYPE, {.std_w_mask.value1=0x700, .std_w_mask.mask1=0x700, .std_w_mask.value2=0x700, .std_w_mask.mask2=0x700}},
};
static_assert(!(sizeof(ford_transit_2017_can2)>MAX_FILTER_TABLE_SIZE-1), "wrong ford_transit_2017_can2 filter size");

//Citroen Jumpy
static const uint16_t CITROEN_JUMPY_CAN1_SPEED=125;

static const can_filter_t citroen_jumpy_2018_can1[]=
{
  {.bank_type=STD_ID_FILTER_BANK_TYPE, {.std.value1=0x161, .std.value2=0x128, .std.value3=0x168, .std.value4=0x0F6}},
  {.bank_type=STD_ID_FILTER_BANK_TYPE, {.std.value1=0x276, .std.value2=0x0B6, .std.value3=0x2AD, .std.value4=0x221}},
  {.bank_type=STD_ID_FILTER_BANK_TYPE, {.std.value1=0x000, .std.value2=0x000, .std.value3=0x000, .std.value4=0x000}},
};
static_assert(!(sizeof(citroen_jumpy_2018_can1)>MAX_FILTER_TABLE_SIZE-1), "wrong citroen_jumpy_2018_can1 filter size");

static const uint16_t CITROEN_JUMPY_CAN2_SPEED=500;

static const can_filter_t citroen_jumpy_2018_can2[]=
{
  {.bank_type=STD_ID_FILTER_BANK_TYPE, {.std.value1=0x349, .std.value2=0x412, .std.value3=0x2E8, .std.value4=0x208}},
  {.bank_type=STD_ID_FILTER_BANK_TYPE, {.std.value1=0x3CD, .std.value2=0x305, .std.value3=0x572, .std.value4=0x000}},
  {.bank_type=STD_ID_W_MASK_FILTER_BANK_TYPE, {.std_w_mask.value1=0x700, .std_w_mask.mask1=0x700, .std_w_mask.value2=0x700, .std_w_mask.mask2=0x700}},
};
static_assert(!(sizeof(citroen_jumpy_2018_can2)>MAX_FILTER_TABLE_SIZE-1), "wrong citroen_jumpy_2018_can2 filter size");

//Nissan Leaf
static const uint16_t NISSAN_LEAF_CAN1_SPEED=500;

static const can_filter_t nissan_leaf_2019_can1[]=
{
  {.bank_type=STD_ID_FILTER_BANK_TYPE, {.std.value1=0x421, .std.value2=0x5C5, .std.value3=0x284, .std.value4=0x5B3}},
  {.bank_type=STD_ID_FILTER_BANK_TYPE, {.std.value1=0x5A9, .std.value2=0x180, .std.value3=0x354, .std.value4=0x50D}},
  {.bank_type=STD_ID_FILTER_BANK_TYPE, {.std.value1=0x510, .std.value2=0x60D, .std.value3=0x1CB, .std.value4=0x002}},
  {.bank_type=STD_ID_FILTER_BANK_TYPE, {.std.value1=0x551, .std.value2=0x390, .std.value3=0x351, .std.value4=0x000}},
};
static_assert(!(sizeof(nissan_leaf_2019_can1)>MAX_FILTER_TABLE_SIZE-1), "wrong nissan_leaf_2019_can1 filter size");

static const uint16_t NISSAN_LEAF_CAN2_SPEED=500;

static const can_filter_t nissan_leaf_2019_can2[]=
{
  {.bank_type=STD_ID_W_MASK_FILTER_BANK_TYPE, {.std_w_mask.value1=0x000, .std_w_mask.mask1=0x000, .std_w_mask.value2=0x000, .std_w_mask.mask2=0x000}},
};
static_assert(!(sizeof(nissan_leaf_2019_can2)>MAX_FILTER_TABLE_SIZE-1), "wrong nissan_leaf_2019_can2 filter size");

static const can_commands_table_t nissan_leaf_can_commands_table[]=
{
  {CENTRAL_LOCK_CLOSE_CMD_TYPE,  CAN2, .id_type=STD_ID_TYPE, .id_1=0x745, .repeats_1=2,   .mess_1={0x02,0x10,0xC0,0xFF,0xFF,0xFF,0xFF,0xFF}, .len_1=8, .delay_1=25, .id_2=0x745, .repeats_2=2, .mess_2={0x04,0x30,0x02,0x00,0x00,0xFF,0xFF,0xFF}, .len_2=8, .delay_2=50, .seq_repeats=1},
  {CENTRAL_LOCK_OPEN_CMD_TYPE,   CAN2, .id_type=STD_ID_TYPE, .id_1=0x745, .repeats_1=2,   .mess_1={0x02,0x10,0xC0,0xFF,0xFF,0xFF,0xFF,0xFF}, .len_1=8, .delay_1=25, .id_2=0x745, .repeats_2=2, .mess_2={0x04,0x30,0x02,0x00,0x01,0xFF,0xFF,0xFF}, .len_2=8, .delay_2=50, .seq_repeats=1},
  {PARKING_LIGHT_ON_CMD_TYPE,    CAN2, .id_type=STD_ID_TYPE, .id_1=0x745, .repeats_1=2,   .mess_1={0x02,0x10,0xC0,0xFF,0xFF,0xFF,0xFF,0xFF}, .len_1=8, .delay_1=25, .id_2=0x745, .repeats_2=2, .mess_2={0x04,0x30,0x3B,0x20,0x02,0xFF,0xFF,0xFF}, .len_2=8, .delay_2=50, .seq_repeats=1},//дальний
  {LEAF_WAKEUP_CMD_TYPE,         CAN2, .id_type=STD_ID_TYPE, .id_1=0x745, .repeats_1=160, .mess_1={0x02,0x10,0xC0,0xFF,0xFF,0xFF,0xFF,0xFF}, .len_1=8, .delay_1=25, .id_2=0,     .repeats_2=0, .mess_2={0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, .len_2=0, .delay_2=0,  .seq_repeats=1},//4 секунды
};

//Lada Largus
static const uint16_t LADA_LARGUS_CAN1_SPEED=500;

static const can_filter_t lada_largus_2017_can1[]=
{
  {.bank_type=STD_ID_FILTER_BANK_TYPE, {.std.value1=0x160, .std.value2=0x35D, .std.value3=0x182, .std.value4=0x000}},
};
static_assert(!(sizeof(lada_largus_2017_can1)>MAX_FILTER_TABLE_SIZE-1), "wrong lada_largus_2017_can1 filter size");

//Volvo XC60
static const uint16_t VOLVO_XC60_CAN1_SPEED=500;

static const can_filter_t volvo_xc60_2018_can1[]=
{
  {.bank_type=STD_ID_FILTER_BANK_TYPE, {.std.value1=0x066, .std.value2=0x04A, .std.value3=0x041, .std.value4=0x185}},
  {.bank_type=STD_ID_FILTER_BANK_TYPE, {.std.value1=0x630, .std.value2=0x730, .std.value3=0x111, .std.value4=0x158}},
  {.bank_type=STD_ID_FILTER_BANK_TYPE, {.std.value1=0x285, .std.value2=0x000, .std.value3=0x000, .std.value4=0x000}},
  {.bank_type=STD_ID_W_MASK_FILTER_BANK_TYPE, {.std_w_mask.value1=0x700, .std_w_mask.mask1=0x700, .std_w_mask.value2=0x700, .std_w_mask.mask2=0x700}},
};
static_assert(!(sizeof(volvo_xc60_2018_can1)>MAX_FILTER_TABLE_SIZE-1), "wrong volvo_xc60_2018_can1 filter size");

static const uint16_t VOLVO_XC60_CAN2_SPEED=500;

static const can_filter_t volvo_xc60_2018_can2[]=
{
  {.bank_type=STD_ID_FILTER_BANK_TYPE, {.std.value1=0x020, .std.value2=0x040, .std.value3=0x612, .std.value4=0x613}},
  {.bank_type=STD_ID_FILTER_BANK_TYPE, {.std.value1=0x0E0, .std.value2=0x100, .std.value3=0x370, .std.value4=0x1E0}},
  {.bank_type=STD_ID_FILTER_BANK_TYPE, {.std.value1=0x160, .std.value2=0x030, .std.value3=0x010, .std.value4=0x0B0}},
  {.bank_type=STD_ID_FILTER_BANK_TYPE, {.std.value1=0x210, .std.value2=0x000, .std.value3=0x000, .std.value4=0x000}},
};
static_assert(!(sizeof(volvo_xc60_2018_can2)>MAX_FILTER_TABLE_SIZE-1), "wrong volvo_xc60_2018_can2 filter size");

static const uint16_t VOLVO_XC60_CAN3_SPEED=500;

static const can_filter_t volvo_xc60_2018_can3[]=
{
  {.bank_type=STD_ID_FILTER_BANK_TYPE, {.std.value1=0x030, .std.value2=0x050, .std.value3=0x000, .std.value4=0x000}},
};
static_assert(!(sizeof(volvo_xc60_2018_can3)>MAX_FILTER_TABLE_SIZE-1), "wrong volvo_xc60_2018_can3 filter size");

static const can_commands_table_t volvo_xc60_2018_can_commands_table[]=
{
  //{CENTRAL_LOCK_CLOSE_CMD_TYPE, CAN2, .id_type=STD_ID_TYPE, .id_1=0x57F, .repeats_1=7, .mess_1={0x10,0x09,0xC0,0x00,0x00,0x00,0x00,0x00}, .len_1=4, .delay_1=10, .id_2=0x020, .repeats_2=8, .mess_2={0x28,0x32,0x2D,0x20,0x10,0x12,0x20,0x08}, .len_2=8, .delay_2=10, .seq_repeats=1}, //не закрывает багажник
  {CENTRAL_LOCK_CLOSE_CMD_TYPE, CAN2, .id_type=STD_ID_TYPE, .id_1=0x57F, .repeats_1=7, .mess_1={0x10,0x09,0xC0,0x00,0x00,0x00,0x00,0x00}, .len_1=4, .delay_1=10, .id_2=0x010, .repeats_2=8, .mess_2={0xD5,0x35,0x0D,0x0D,0xFF,0x00,0x00,0x00}, .len_2=8, .delay_2=10, .seq_repeats=1},
  {CENTRAL_LOCK_OPEN_CMD_TYPE,  CAN2, .id_type=STD_ID_TYPE, .id_1=0x57F, .repeats_1=7, .mess_1={0x10,0x09,0xC0,0x00,0x00,0x00,0x00,0x00}, .len_1=4, .delay_1=10, .id_2=0x020, .repeats_2=8, .mess_2={0x18,0x31,0x19,0x18,0x10,0x12,0x20,0x28}, .len_2=8, .delay_2=10, .seq_repeats=1},
  {WINDOWS_CLOSING_CMD_TYPE,    CAN2, .id_type=STD_ID_TYPE, .id_1=0x040, .repeats_1=5, .mess_1={0xE3,0x56,0x20,0xE0,0xEB,0x19,0xA2,0x00}, .len_1=8, .delay_1=15, .id_2=0x000, .repeats_2=0, .mess_2={0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, .len_2=0, .delay_2=0,  .seq_repeats=1},
};

//Volvo XC40
static const uint16_t VOLVO_XC40_CAN1_SPEED=500;

static const can_filter_t volvo_xc40_2018_can1[]=
{
  //{.bank_type=STD_ID_W_MASK_FILTER_BANK_TYPE, {.std_w_mask.value1=0x000, .std_w_mask.mask1=0x000, .std_w_mask.value2=0x000, .std_w_mask.mask2=0x000}},
  {.bank_type=STD_ID_FILTER_BANK_TYPE,        {.std.value1=0x111, .std.value2=0x19F, .std.value3=0x04A, .std.value4=0x066}},
  {.bank_type=STD_ID_FILTER_BANK_TYPE,        {.std.value1=0x041, .std.value2=0x158, .std.value3=0x126, .std.value4=0x185}},
  {.bank_type=STD_ID_FILTER_BANK_TYPE,        {.std.value1=0x34F, .std.value2=0x630, .std.value3=0x000, .std.value4=0x000}},
  {.bank_type=STD_ID_FILTER_BANK_TYPE,        {.std.value1=0x000, .std.value2=0x000, .std.value3=0x000, .std.value4=0x000}},
};
static_assert(!(sizeof(volvo_xc40_2018_can1)>MAX_FILTER_TABLE_SIZE-1), "wrong volvo_xc40_2018_can1 filter size");

static const uint16_t VOLVO_XC40_CAN2_SPEED=500;

static const can_filter_t volvo_xc40_2018_can2[]=
{
  //{.bank_type=STD_ID_W_MASK_FILTER_BANK_TYPE, {.std_w_mask.value1=0x000, .std_w_mask.mask1=0x000, .std_w_mask.value2=0x000, .std_w_mask.mask2=0x000}},
  {.bank_type=STD_ID_FILTER_BANK_TYPE,        {.std.value1=0x040, .std.value2=0x0E0, .std.value3=0x100, .std.value4=0x020}},
  {.bank_type=STD_ID_FILTER_BANK_TYPE,        {.std.value1=0x470, .std.value2=0x370, .std.value3=0x1E0, .std.value4=0x160}},
  {.bank_type=STD_ID_FILTER_BANK_TYPE,        {.std.value1=0x030, .std.value2=0x010, .std.value3=0x0B0, .std.value4=0x210}},
  {.bank_type=STD_ID_FILTER_BANK_TYPE,        {.std.value1=0x310, .std.value2=0x000, .std.value3=0x000, .std.value4=0x000}},
  {.bank_type=STD_ID_FILTER_BANK_TYPE,        {.std.value1=0x000, .std.value2=0x000, .std.value3=0x000, .std.value4=0x000}},
  {.bank_type=STD_ID_W_MASK_FILTER_BANK_TYPE, {.std_w_mask.value1=0x700, .std_w_mask.mask1=0x700, .std_w_mask.value2=0x700, .std_w_mask.mask2=0x700}},
};
static_assert(!(sizeof(volvo_xc40_2018_can2)>MAX_FILTER_TABLE_SIZE-1), "wrong volvo_xc40_2018_can2 filter size");

static const uint16_t VOLVO_XC40_CAN3_SPEED=500;

static const can_filter_t volvo_xc40_2018_can3[]=
{
  {.bank_type=STD_ID_W_MASK_FILTER_BANK_TYPE, {.std_w_mask.value1=0x000, .std_w_mask.mask1=0x000, .std_w_mask.value2=0x000, .std_w_mask.mask2=0x000}},
  {.bank_type=STD_ID_FILTER_BANK_TYPE,        {.std.value1=0x000, .std.value2=0x000, .std.value3=0x000, .std.value4=0x000}},
};
static_assert(!(sizeof(volvo_xc40_2018_can3)>MAX_FILTER_TABLE_SIZE-1), "wrong volvo_xc40_2018_can3 filter size");

static const can_commands_table_t volvo_xc40_2018_can_commands_table[]=
{
  {VOLVO_XC40_CAN_CENTRAL_LOCK_CLOSE_CMD_TYPE, CAN2, .id_type=STD_ID_TYPE,  .id_1=0x010, .repeats_1=10, .mess_1={0xD5,0x35,0x0D,0x0D,0xFF,0x00,0x00,0x00}, .len_1=8, .delay_1=10,
                                                                            .id_2=0x000, .repeats_2=0,  .mess_2={0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, .len_2=0, .delay_2=0,  .seq_repeats=1},
  //{VOLVO_XC40_CAN_CENTRAL_LOCK_OPEN_CMD_TYPE,  CAN2, .id_type=STD_ID_TYPE, .id_1=0x020, .repeats_1=10, .mess_1={0x18,0x31,0x19,0x18,0x10,0x12,0x20,0x28}, .len_1=8, .delay_1=10,
                                                                          //.id_2=0x000, .repeats_2=0,  .mess_2={0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, .len_2=0, .delay_2=0,  .seq_repeats=1}, //не отпирает багажник, если включена опция "открывать только водительскую"
  {VOLVO_XC40_CAN_CENTRAL_LOCK_OPEN_CMD_TYPE,  CAN2, .id_type=STD_ID_TYPE,  .id_1=0x020, .repeats_1=10, .mess_1={0x18,0x31,0x19,0x18,0x10,0x12,0x20,0x28}, .len_1=8, .delay_1=10,
                                                                            .id_2=0x030, .repeats_2=10, .mess_2={0xFF,0x82,0xA9,0xD3,0x01,0xD8,0x21,0x08}, .len_2=8, .delay_2=10,  .seq_repeats=1}, //вторая команда для отприрания багажника
  {WINDOWS_CLOSING_CMD_TYPE,    CAN2, .id_type=STD_ID_TYPE,                 .id_1=0x040, .repeats_1=5,  .mess_1={0xE3,0x56,0x20,0xE0,0xEB,0x19,0xA2,0x00}, .len_1=8, .delay_1=10,
                                                                            .id_2=0x000, .repeats_2=0,  .mess_2={0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, .len_2=0, .delay_2=0,  .seq_repeats=1},
  {VOLVO_XC40_ROOF_CLOSING_1_CMD_TYPE, CAN3, .id_type=EXT_ID_TYPE,          .id_1=0x1DD01FFF, .repeats_1=100,  .mess_1={0x02,0x3E,0x80,0x00,0x00,0x00,0x00,0x00}, .len_1=8, .delay_1=10,
                                                                            .id_2=0x00000000, .repeats_2=0,    .mess_2={0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, .len_2=0, .delay_2=0,  .seq_repeats=1},
  {VOLVO_XC40_ROOF_CLOSING_2_CMD_TYPE, CAN3, .id_type=EXT_ID_TYPE,          .id_1=0x1DD01A01, .repeats_1=1,    .mess_1={0x02,0x10,0x03,0x00,0x00,0x00,0x00,0x00}, .len_1=8, .delay_1=100,
                                                                            .id_2=0x1DD01A01, .repeats_2=1,    .mess_2={0x06,0x31,0x01,0x20,0x11,0x02,0x40,0x00}, .len_2=8, .delay_2=10, .seq_repeats=1},
};

//Range Rover Velar
static const uint16_t RANGE_ROVER_VELAR_CAN1_SPEED=500;

static const can_filter_t range_rover_velar_2018_can1[]=
{
  {.bank_type=STD_ID_FILTER_BANK_TYPE, {.std.value1=0x040, .std.value2=0x360, .std.value3=0x044, .std.value4=0x084}},
  {.bank_type=STD_ID_FILTER_BANK_TYPE, {.std.value1=0x190, .std.value2=0x184, .std.value3=0x012, .std.value4=0x460}},
  {.bank_type=STD_ID_FILTER_BANK_TYPE, {.std.value1=0x240, .std.value2=0x350, .std.value3=0x1A8, .std.value4=0x430}},
  {.bank_type=STD_ID_FILTER_BANK_TYPE, {.std.value1=0x000, .std.value2=0x000, .std.value3=0x000, .std.value4=0x000}},
};
static_assert(!(sizeof(range_rover_velar_2018_can1)>MAX_FILTER_TABLE_SIZE-1), "wrong range_rover_velar_2018_can1 filter size");

static const uint16_t RANGE_ROVER_VELAR_CAN2_SPEED=500;

static const can_filter_t range_rover_velar_2018_can2[]=
{
  {.bank_type=STD_ID_FILTER_BANK_TYPE, {.std.value1=0x172, .std.value2=0x180, .std.value3=0x220, .std.value4=0x228}},
  {.bank_type=STD_ID_FILTER_BANK_TYPE, {.std.value1=0x1C8, .std.value2=0x110, .std.value3=0x2B0, .std.value4=0x1E1}},
  {.bank_type=STD_ID_FILTER_BANK_TYPE, {.std.value1=0x000, .std.value2=0x000, .std.value3=0x000, .std.value4=0x000}},
};
static_assert(!(sizeof(range_rover_velar_2018_can2)>MAX_FILTER_TABLE_SIZE-1), "wrong range_rover_velar_2018_can2 filter size");

static const uint16_t RANGE_ROVER_VELAR_CAN3_SPEED=500;

static const can_filter_t range_rover_velar_2018_can3[]=
{
  {.bank_type=STD_ID_FILTER_BANK_TYPE, {.std.value1=0x7E8, .std.value2=0x000, .std.value3=0x000, .std.value4=0x000}},
  {.bank_type=STD_ID_W_MASK_FILTER_BANK_TYPE, {.std_w_mask.value1=0x700, .std_w_mask.mask1=0x700, .std_w_mask.value2=0x700, .std_w_mask.mask2=0x700}},
};
static_assert(!(sizeof(range_rover_velar_2018_can3)>MAX_FILTER_TABLE_SIZE-1), "wrong range_rover_velar_2018_can3 filter size");

static const can_commands_table_t range_rover_velar_commands_table[]=
{
  {CENTRAL_LOCK_CLOSE_CMD_TYPE,        CAN2, .id_type=STD_ID_TYPE, .id_1=0x172, .repeats_1=3, .mess_1={0x54,0xF9,0x40,0x13,0x02,0x80,0xC0,0x08}, .len_1=8, .delay_1=40, .id_2=0x000, .repeats_2=0, .mess_2={0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, .len_2=0, .delay_2=0, .seq_repeats=1},
  {CENTRAL_LOCK_OPEN_CMD_TYPE,         CAN2, .id_type=STD_ID_TYPE, .id_1=0x172, .repeats_1=3, .mess_1={0x34,0xF9,0x40,0x13,0x02,0x40,0xC0,0x08}, .len_1=8, .delay_1=40, .id_2=0x000, .repeats_2=0, .mess_2={0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, .len_2=0, .delay_2=0, .seq_repeats=1},
  //{EXT_WINDOWS_CLOSING_CMD_TYPE_VELAR, CAN2, .id_type=STD_ID_TYPE, .id_1=0x172, .repeats_1=4, .mess_1={0x14,0xF9,0x40,0x13,0x06,0x01,0xC1,0x01}, .len_1=8, .delay_1=40, .id_2=0x172, .repeats_2=1, .mess_2={0x14,0xF9,0x40,0x13,0x06,0x02,0xC2,0x02}, .len_2=8, .delay_2=40, .seq_repeats=1}, //закрывает цз, отправлять 1 раз (эмулируем человека)
  //{WINDOWS_OPENING_CMD_TYPE,           CAN2, .id_type=STD_ID_TYPE, .id_1=0x172, .repeats_1=1, .mess_1={0x14,0xF9,0x40,0x13,0x06,0x0C,0xCC,0x0C}, .len_1=8, .delay_1=40, .id_2=0x000, .repeats_2=0, .mess_2={0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, .len_2=0, .delay_2=0, .seq_repeats=1},
  {PARKING_LIGHT_ON_CMD_TYPE,          CAN2, .id_type=STD_ID_TYPE, .id_1=0x1E1, .repeats_1=3, .mess_1={0x5F,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, .len_1=1, .delay_1=99, .id_2=0x1E1, .repeats_2=2, .mess_2={0x41,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, .len_2=1, .delay_2=10, .seq_repeats=1},
};

//Nissan Qashqai
static const uint16_t NISSAN_QASHQAI_CAN1_SPEED=500;

static const can_filter_t nissan_qashqai_2018_can1[]=
{
  {.bank_type=STD_ID_FILTER_BANK_TYPE, {.std.value1=0x41F, .std.value2=0x002, .std.value3=0x15A, .std.value4=0x454}},
  {.bank_type=STD_ID_FILTER_BANK_TYPE, {.std.value1=0x02A, .std.value2=0x17B, .std.value3=0x15C, .std.value4=0x224}},
  {.bank_type=STD_ID_FILTER_BANK_TYPE, {.std.value1=0x29A, .std.value2=0x300, .std.value3=0x353, .std.value4=0x411}},
  {.bank_type=STD_ID_FILTER_BANK_TYPE, {.std.value1=0x412, .std.value2=0x451, .std.value3=0x453, .std.value4=0x456}},
  {.bank_type=STD_ID_FILTER_BANK_TYPE, {.std.value1=0x4F9, .std.value2=0x208, .std.value3=0x2D3, .std.value4=0x5D9}},
  {.bank_type=STD_ID_FILTER_BANK_TYPE, {.std.value1=0x763, .std.value2=0x7E8, .std.value3=0x4F2, .std.value4=0x000}},
  {.bank_type=STD_ID_W_MASK_FILTER_BANK_TYPE, {.std_w_mask.value1=0x700, .std_w_mask.mask1=0x700, .std_w_mask.value2=0x700, .std_w_mask.mask2=0x700}},
};
static_assert(!(sizeof(nissan_qashqai_2018_can1)>MAX_FILTER_TABLE_SIZE-1), "wrong nissan_qashqai_2018_can1 filter size");

static const can_commands_table_t nissan_qashqai_can_commands_table[]=
{
  {DIAG_SESSION_CMD_TYPE,        CAN1, .id_type=STD_ID_TYPE, .id_1=0x745, .repeats_1=8, .mess_1={0x02,0x3E,0x00,0xFF,0xFF,0xFF,0xFF,0xFF}, .len_1=8, .delay_1=100, .id_2=0x000, .repeats_2=0, .mess_2={0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, .len_2=0, .delay_2=0,  .seq_repeats=1},
  {CENTRAL_LOCK_CLOSE_CMD_TYPE,  CAN1, .id_type=STD_ID_TYPE, .id_1=0x745, .repeats_1=4, .mess_1={0x02,0x10,0x03,0xFF,0xFF,0xFF,0xFF,0xFF}, .len_1=8, .delay_1=50,  .id_2=0x745, .repeats_2=2, .mess_2={0x06,0x2F,0x01,0x02,0x03,0x00,0x01,0xFF}, .len_2=8, .delay_2=50, .seq_repeats=1},
  {CENTRAL_LOCK_OPEN_CMD_TYPE,   CAN1, .id_type=STD_ID_TYPE, .id_1=0x745, .repeats_1=4, .mess_1={0x02,0x10,0x03,0xFF,0xFF,0xFF,0xFF,0xFF}, .len_1=8, .delay_1=50,  .id_2=0x745, .repeats_2=2, .mess_2={0x06,0x2F,0x01,0x02,0x03,0x00,0x02,0xFF}, .len_2=8, .delay_2=50, .seq_repeats=1},
  {CLEAR_BCM_ERRS_CMD_TYPE,      CAN1, .id_type=STD_ID_TYPE, .id_1=0x745, .repeats_1=1, .mess_1={0x04,0x14,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF}, .len_1=8, .delay_1=50,  .id_2=0x000, .repeats_2=0, .mess_2={0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, .len_2=0, .delay_2=0,  .seq_repeats=1},
  {CLEAR_ENGINE_ERRS_CMD_TYPE,   CAN1, .id_type=STD_ID_TYPE, .id_1=0x7E0, .repeats_1=1, .mess_1={0x03,0x14,0xFF,0x00,0xFF,0xFF,0xFF,0xFF}, .len_1=8, .delay_1=50,  .id_2=0x000, .repeats_2=0, .mess_2={0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, .len_2=0, .delay_2=0,  .seq_repeats=1},
};

//VW Transporter
#define VW_TRANSPORTER_CAN1_SPEED       AUDI_Q3_CAN1_SPEED
#define vw_transporter_2018_can1        audi_q3_2018_can1
#define VW_TRANSPORTER_CAN2_SPEED       AUDI_Q3_CAN2_SPEED
#define vw_transporter_2018_can2        audi_q3_2018_can2

//Hyunday Creta
static const uint16_t HYUNDAI_CRETA_CAN1_SPEED=100;

static const can_filter_t hyundai_creta_2019_can1[]=
{
  {.bank_type=STD_ID_FILTER_BANK_TYPE, {.std.value1=0x168, .std.value2=0x103, .std.value3=0x102, .std.value4=0x40F}},
  {.bank_type=STD_ID_FILTER_BANK_TYPE, {.std.value1=0x000, .std.value2=0x000, .std.value3=0x000, .std.value4=0x000}},
};
static_assert(!(sizeof(hyundai_creta_2019_can1)>MAX_FILTER_TABLE_SIZE-1), "wrong hyundai_creta_2019_can1 filter size");

static const uint16_t HYUNDAI_CRETA_CAN2_SPEED=500;

static const can_filter_t hyundai_creta_2019_can2[]=
{
  {.bank_type=STD_ID_FILTER_BANK_TYPE, {.std.value1=0x541, .std.value2=0x316, .std.value3=0x52A, .std.value4=0x5B0}},
  {.bank_type=STD_ID_FILTER_BANK_TYPE, {.std.value1=0x329, .std.value2=0x549, .std.value3=0x545, .std.value4=0x251}},
  {.bank_type=STD_ID_FILTER_BANK_TYPE, {.std.value1=0x111, .std.value2=0x7CE, .std.value3=0x556, .std.value4=0x5A0}},
  {.bank_type=STD_ID_FILTER_BANK_TYPE, {.std.value1=0x000, .std.value2=0x000, .std.value3=0x000, .std.value4=0x000}},
  {.bank_type=STD_ID_W_MASK_FILTER_BANK_TYPE, {.std_w_mask.value1=0x700, .std_w_mask.mask1=0x700, .std_w_mask.value2=0x700, .std_w_mask.mask2=0x700}},
};
static_assert(!(sizeof(hyundai_creta_2019_can2)>MAX_FILTER_TABLE_SIZE-1), "wrong hyundai_creta_2019_can2 filter size");

static const can_commands_table_t hyundai_creta_can_commands_table[]=
{
  {CENTRAL_LOCK_CLOSE_CMD_TYPE,            CAN1, .id_type=STD_ID_TYPE, .id_1=0x168, .repeats_1=5, .mess_1={0x10,0x08,0x01,0x00,0x01,0x10,0x00,0x00}, .len_1=8, .delay_1=20, .id_2=0x000, .repeats_2=0, .mess_2={0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, .len_2=0, .delay_2=0,  .seq_repeats=1},
  {CENTRAL_LOCK_OPEN_CMD_TYPE,             CAN1, .id_type=STD_ID_TYPE, .id_1=0x168, .repeats_1=5, .mess_1={0x10,0x04,0x01,0x00,0x01,0x10,0x00,0x00}, .len_1=8, .delay_1=20, .id_2=0x000, .repeats_2=0, .mess_2={0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, .len_2=0, .delay_2=0,  .seq_repeats=1},
  {CRETA_CAN_PARKING_LIGHT_ON_CMD_TYPE,    CAN2, .id_type=STD_ID_TYPE, .id_1=0x7A0, .repeats_1=1, .mess_1={0x04,0x2F,0xB0,0x15,0x03,0x00,0x00,0x00}, .len_1=8, .delay_1=20, .id_2=0x7A0, .repeats_2=1, .mess_2={0x04,0x2F,0xB0,0x16,0x03,0x00,0x00,0x00}, .len_2=8, .delay_2=20, .seq_repeats=4}, //моргает 5 секунд, но только с зажиганием
  {KIA_BCM_BEGIN_CONFIG_1_CMD_TYPE,        CAN2, .id_type=STD_ID_TYPE, .id_1=0x7A0, .repeats_1=1, .mess_1={0x02,0x10,0x03,0x00,0x00,0x00,0x00,0x00}, .len_1=8, .delay_1=0,  .id_2=0x000, .repeats_2=0, .mess_2={0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, .len_2=0, .delay_2=0,  .seq_repeats=1},
  {KIA_BCM_DISABLE_DOORS_BLOCK_CMD_TYPE,   CAN2, .id_type=STD_ID_TYPE, .id_1=0x7A0, .repeats_1=1, .mess_1={0x05,0x2E,0x12,0xA0,0x09,0x00,0x00,0x00}, .len_1=8, .delay_1=0,  .id_2=0x000, .repeats_2=0, .mess_2={0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, .len_2=0, .delay_2=0,  .seq_repeats=1},
  {KIA_BCM_DISABLE_DOORS_UNBLOCK_CMD_TYPE, CAN2, .id_type=STD_ID_TYPE, .id_1=0x7A0, .repeats_1=1, .mess_1={0x05,0x2E,0x12,0xA0,0x0A,0x00,0x00,0x00}, .len_1=8, .delay_1=0,  .id_2=0x000, .repeats_2=0, .mess_2={0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, .len_2=0, .delay_2=0,  .seq_repeats=1},
  {KIA_BCM_END_CONFIG_2_CMD_TYPE,          CAN2, .id_type=STD_ID_TYPE, .id_1=0x7A8, .repeats_1=1, .mess_1={0x03,0x6E,0x12,0xA0,0xAA,0xAA,0xAA,0xAA}, .len_1=8, .delay_1=0,  .id_2=0x000, .repeats_2=0, .mess_2={0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, .len_2=0, .delay_2=0,  .seq_repeats=1},
};

//BMW X1 F48 2019
static const uint16_t BMW_X1_CAN1_SPEED=500;

static const can_filter_t bmw_x1_2019_can1[]=
{
  {.bank_type=STD_ID_FILTER_BANK_TYPE, {.std.value1=0x612, .std.value2=0x03C, .std.value3=0x130, .std.value4=0x799}}, //для определения активности на 7й серии можно использовать 0x03C и 0x130
  {.bank_type=STD_ID_FILTER_BANK_TYPE, {.std.value1=0x7C0, .std.value2=0x7C1, .std.value3=0x6F1, .std.value4=0x000}},//все для "не засыпания"
  {.bank_type=STD_ID_W_MASK_FILTER_BANK_TYPE, {.std_w_mask.value1=0x700, .std_w_mask.mask1=0x700, .std_w_mask.value2=0x700, .std_w_mask.mask2=0x700}},
};
static_assert(!(sizeof(bmw_x1_2019_can1)>MAX_FILTER_TABLE_SIZE-1), "wrong bmw_x1_2019_can1 filter size");

static const uint16_t BMW_X1_CAN2_SPEED=500;

static const can_filter_t bmw_x1_2019_can2[]=
{
  {.bank_type=STD_ID_FILTER_BANK_TYPE, {.std.value1=0x0A5, .std.value2=0x0D9, .std.value3=0x2FC, .std.value4=0x2FC}},
  {.bank_type=STD_ID_FILTER_BANK_TYPE, {.std.value1=0x0DC, .std.value2=0x173, .std.value3=0x330, .std.value4=0x6F1}},
  {.bank_type=STD_ID_FILTER_BANK_TYPE, {.std.value1=0x03C, .std.value2=0x12F, .std.value3=0x581, .std.value4=0x1A1}},
  {.bank_type=STD_ID_FILTER_BANK_TYPE, {.std.value1=0x1B3, .std.value2=0x1F6, .std.value3=0x3F9, .std.value4=0x302}},
  {.bank_type=STD_ID_FILTER_BANK_TYPE, {.std.value1=0x000, .std.value2=0x000, .std.value3=0x000, .std.value4=0x000}},
};
static_assert(!(sizeof(bmw_x1_2019_can2)>MAX_FILTER_TABLE_SIZE-1), "wrong bmw_x1_2019_can2 filter size");

static const can_commands_table_t bmw_x1_2019_can_commands_table[]=
{
  {WINDOWS_CLOSING_CMD_TYPE,    CAN1, .id_type=STD_ID_TYPE, .id_1=0x6F1, .repeats_1=4, .mess_1={0x40,0x06,0x31,0x01,0xA1,0x7F,0x40,0x00}, .len_1=8, .delay_1=20, .id_2=0x000, .repeats_2=0, .mess_2={0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, .len_2=0, .delay_2=0,  .seq_repeats=1},
  {WINDOWS_OPENING_CMD_TYPE,    CAN1, .id_type=STD_ID_TYPE, .id_1=0x6F1, .repeats_1=4, .mess_1={0x40,0x06,0x31,0x01,0xA1,0x7F,0x40,0x64}, .len_1=8, .delay_1=20, .id_2=0x000, .repeats_2=0, .mess_2={0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, .len_2=0, .delay_2=0,  .seq_repeats=1},
  {CENTRAL_LOCK_CLOSE_CMD_TYPE, CAN1, .id_type=STD_ID_TYPE, .id_1=0x6F1, .repeats_1=4, .mess_1={0x40,0x05,0x31,0x01,0xAC,0x57,0x02,0x00}, .len_1=7, .delay_1=20, .id_2=0x000, .repeats_2=0, .mess_2={0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, .len_2=0, .delay_2=0,  .seq_repeats=1},
  {CENTRAL_LOCK_OPEN_CMD_TYPE,  CAN1, .id_type=STD_ID_TYPE, .id_1=0x6F1, .repeats_1=4, .mess_1={0x40,0x05,0x31,0x01,0xAC,0x57,0x01,0x00}, .len_1=7, .delay_1=20, .id_2=0x000, .repeats_2=0, .mess_2={0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, .len_2=0, .delay_2=0,  .seq_repeats=1},
  {HORN_CMD_TYPE,               CAN1, .id_type=STD_ID_TYPE, .id_1=0x6F1, .repeats_1=1, .mess_1={0x40,0x05,0x2E,0xD2,0x98,0x00,0x64,0x00}, .len_1=7, .delay_1=20, .id_2=0x000, .repeats_2=0, .mess_2={0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, .len_2=0, .delay_2=0,  .seq_repeats=1},
  {PARKING_LIGHT_ON_CMD_TYPE,   CAN1, .id_type=STD_ID_TYPE, .id_1=0x6F1, .repeats_1=1, .mess_1={0x40,0x10,0x07,0x2E,0xD5,0x42,0x00,0x12}, .len_1=8, .delay_1=10, .id_2=0x6F1, .repeats_2=1, .mess_2={0x40,0x21,0x00,0xC8,0x00,0x00,0x00,0x00}, .len_2=8, .delay_2=10, .seq_repeats=1},
};

//Hyunday Sonata 2020 Беспилотники
static const uint16_t HYUNDAY_SONATA_SD_CAN1_SPEED=500;

static const can_filter_t hyunday_sonata_sd_2020_can1[]=
{
  {.bank_type=STD_ID_W_MASK_FILTER_BANK_TYPE, {.std_w_mask.value1=0x000, .std_w_mask.mask1=0x000, .std_w_mask.value2=0x000, .std_w_mask.mask2=0x000}},
  {.bank_type=STD_ID_FILTER_BANK_TYPE,        {.std.value1=0x000, .std.value2=0x000, .std.value3=0x000, .std.value4=0x000}},
};
static_assert(!(sizeof(hyunday_sonata_sd_2020_can1)>MAX_FILTER_TABLE_SIZE-1), "wrong hyunday_sonata_sd_2020_can1 filter size");

static const uint16_t HYUNDAY_SONATA_SD_CAN2_SPEED=500;

static const can_filter_t hyunday_sonata_sd_2020_can2[]=
{
  {.bank_type=STD_ID_W_MASK_FILTER_BANK_TYPE, {.std_w_mask.value1=0x000, .std_w_mask.mask1=0x000, .std_w_mask.value2=0x000, .std_w_mask.mask2=0x000}},
  {.bank_type=STD_ID_FILTER_BANK_TYPE,        {.std.value1=0x000, .std.value2=0x000, .std.value3=0x000, .std.value4=0x000}},
};
static_assert(!(sizeof(hyunday_sonata_sd_2020_can2)>MAX_FILTER_TABLE_SIZE-1), "wrong hyunday_sonata_sd_2020_can2 filter size");

//Renault Logan, 2013 - 2021 (II)
static const uint16_t RENAULT_LOGAN_CAN1_SPEED=500;

static const can_filter_t renault_logan_2013_can1[]=
{
  {.bank_type=STD_ID_W_MASK_FILTER_BANK_TYPE, {.std_w_mask.value1=0x000, .std_w_mask.mask1=0x000, .std_w_mask.value2=0x000, .std_w_mask.mask2=0x000}},
  {.bank_type=STD_ID_FILTER_BANK_TYPE,        {.std.value1=0x000, .std.value2=0x000, .std.value3=0x000, .std.value4=0x000}},
};
static_assert(!(sizeof(renault_logan_2013_can1)>MAX_FILTER_TABLE_SIZE-1), "wrong renault_logan_2013_can1 filter size");

static const can_commands_table_t renault_logan_2013_can_commands_table[]=
{
  {LOGAN_2013_PRECAN_CMD_TYPE,  CAN1, .id_type=STD_ID_TYPE, .id_1=0x745, .repeats_1=1, .mess_1={0x02,0x10,0xC0,0xFF,0xFF,0xFF,0xFF,0xFF}, .len_1=8, .delay_1=100,
                                                            .id_2=0x000, .repeats_2=0, .mess_2={0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, .len_2=0, .delay_2=0,   .seq_repeats=1},

  {CENTRAL_LOCK_CLOSE_CMD_TYPE, CAN1, .id_type=STD_ID_TYPE, .id_1=0x745, .repeats_1=1, .mess_1={0x04,0x30,0x01,0x00,0x00,0xFF,0xFF,0xFF}, .len_1=8, .delay_1=300,
                                                            .id_2=0x745, .repeats_2=1, .mess_2={0x02,0x10,0x81,0xFF,0xFF,0xFF,0xFF,0xFF}, .len_2=8, .delay_2=100, .seq_repeats=1},

  {CENTRAL_LOCK_OPEN_CMD_TYPE,  CAN1, .id_type=STD_ID_TYPE, .id_1=0x745, .repeats_1=1, .mess_1={0x04,0x30,0x01,0x00,0x01,0xFF,0xFF,0xFF}, .len_1=8, .delay_1=300,
                                                            .id_2=0x745, .repeats_2=1, .mess_2={0x02,0x10,0x81,0xFF,0xFF,0xFF,0xFF,0xFF}, .len_2=8, .delay_2=100, .seq_repeats=1},

  {PARKING_LIGHT_ON_CMD_TYPE,   CAN1, .id_type=STD_ID_TYPE, .id_1=0x745, .repeats_1=1, .mess_1={0x04,0x30,0x08,0x20,0x02,0xFF,0xFF,0xFF}, .len_1=8, .delay_1=300,
                                                            .id_2=0x745, .repeats_2=1, .mess_2={0x03,0x30,0x08,0x11,0xFF,0xFF,0xFF,0xFF}, .len_2=8, .delay_2=100, .seq_repeats=1},
};

//Jeep Wrangler 2018
static const uint16_t JEEP_WRANGLER_2018_CAN1_SPEED=500;

static const can_filter_t jeep_wrangler_2018_can1[]=
{
  {.bank_type=STD_ID_W_MASK_FILTER_BANK_TYPE, {.std_w_mask.value1=0x000, .std_w_mask.mask1=0x000, .std_w_mask.value2=0x000, .std_w_mask.mask2=0x000}},
  {.bank_type=STD_ID_FILTER_BANK_TYPE,        {.std.value1=0x000, .std.value2=0x000, .std.value3=0x000, .std.value4=0x000}},
};
static_assert(!(sizeof(jeep_wrangler_2018_can1)>MAX_FILTER_TABLE_SIZE-1), "wrong jeep_wrangler_2018_can1 filter size");

static const can_commands_table_t jeep_wrangler_2018_can_commands_table[]=
{
  {CENTRAL_LOCK_CLOSE_CMD_TYPE, CAN1, .id_type=STD_ID_TYPE, .id_1=0x7FF, .repeats_1=4, .mess_1={0x02,0x3E,0xE0,0xFF,0xFF,0xFF,0xFF,0xFF}, .len_1=8, .delay_1=10,
                                                            .id_2=0x1C0, .repeats_2=3, .mess_2={0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, .len_2=6, .delay_2=10, .seq_repeats=1},

  {CENTRAL_LOCK_OPEN_CMD_TYPE,  CAN1, .id_type=STD_ID_TYPE, .id_1=0x7FF, .repeats_1=4, .mess_1={0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, .len_1=8, .delay_1=10,
                                                            .id_2=0x1C0, .repeats_2=3, .mess_2={0x04,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, .len_2=6, .delay_2=10, .seq_repeats=1},

  {PRESS_TRC_BUTTON_CMD_TYPE,   CAN1, .id_type=STD_ID_TYPE, .id_1=0x289, .repeats_1=3, .mess_1={0x30,0x00,0x0F,0x1E,0xC0,0x09,0x80,0x00}, .len_1=8, .delay_1=10,
                                                            .id_2=0x000, .repeats_2=0, .mess_2={0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, .len_2=0, .delay_2=0, .seq_repeats=1},
};

//Audi A6 2018
static const uint16_t AUDI_A6_2018_CAN1_SPEED=500;

static const can_filter_t audi_a6_2018_can1[]=
{
  {.bank_type=STD_ID_W_MASK_FILTER_BANK_TYPE, {.std_w_mask.value1=0x000, .std_w_mask.mask1=0x000, .std_w_mask.value2=0x000, .std_w_mask.mask2=0x000}},
  {.bank_type=STD_ID_FILTER_BANK_TYPE,        {.std.value1=0x000, .std.value2=0x000, .std.value3=0x000, .std.value4=0x000}},
  {.bank_type=EXT_ID_W_MASK_FILTER_BANK_TYPE, {.ext_w_mask.value1=0x00000000, .ext_w_mask.mask1=0x00000000}},
};
static_assert(!(sizeof(audi_a6_2018_can1)>MAX_FILTER_TABLE_SIZE-1), "wrong audi_a6_2018_can1 filter size");

static const uint16_t AUDI_A6_2018_CAN2_SPEED=500;

static const can_filter_t audi_a6_2018_can2[]=
{
  {.bank_type=STD_ID_W_MASK_FILTER_BANK_TYPE, {.std_w_mask.value1=0x000, .std_w_mask.mask1=0x000, .std_w_mask.value2=0x000, .std_w_mask.mask2=0x000}},
  {.bank_type=STD_ID_FILTER_BANK_TYPE,        {.std.value1=0x000, .std.value2=0x000, .std.value3=0x000, .std.value4=0x000}},
};
static_assert(!(sizeof(audi_a6_2018_can2)>MAX_FILTER_TABLE_SIZE-1), "wrong audi_a6_2018_can2 filter size");

static const can_commands_table_t audi_a6_2018_can_commands_table[]=
{
  {CENTRAL_LOCK_CLOSE_CMD_TYPE, CAN1, .id_type=STD_ID_TYPE, .id_1=0x7FF, .repeats_1=10, .mess_1={0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, .len_1=1, .delay_1=10,
                                                            .id_2=0x3D1, .repeats_2=8,  .mess_2={0x40,0x00,0x01,0xC1,0x80,0x00,0x00,0x20}, .len_2=8, .delay_2=20, .seq_repeats=1},

  {CENTRAL_LOCK_OPEN_CMD_TYPE,  CAN1, .id_type=STD_ID_TYPE, .id_1=0x7FF, .repeats_1=10, .mess_1={0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, .len_1=1, .delay_1=10,
                                                            .id_2=0x3D0, .repeats_2=8,  .mess_2={0x22,0x80,0x00,0xC1,0x80,0x00,0x10,0x00}, .len_2=8, .delay_2=20, .seq_repeats=1},

  {WINDOWS_CLOSING_CMD_TYPE,    CAN1, .id_type=STD_ID_TYPE, .id_1=0x184, .repeats_1=20, .mess_1={0x27,0x0A,0x00,0x02,0x00,0xAA,0x00,0x00}, .len_1=8, .delay_1=10,
                                                            .id_2=0x000, .repeats_2=0,  .mess_2={0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, .len_2=0, .delay_2=0,  .seq_repeats=50},

  //если часто слать, поворотники загораются и не гаснут
  //{PARKING_LIGHT_ON_CMD_TYPE,   CAN1, .id_type=STD_ID_TYPE, .id_1=0x700, .repeats_1=8,  .mess_1={0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, .len_1=8, .delay_1=10,
  //                                                          .id_2=0x366, .repeats_2=2,  .mess_2={0x00,0x20,0x00,0x1E,0x80,0x03,0x00,0x00}, .len_2=8, .delay_2=10, .seq_repeats=1},
};