/**
******************************************************************************
* File Name          :
* Description        :
*
*
******************************************************************************
*/

static void jumpy_analog_to_can_handler(void)
{
  if(can_program==CITROEN_JUMPY_2018_PROGRAM)
  {
    uint8_t input_id;

    input_id=CITROEN_JUMPY_CLS_STATE_INPUT_ID;
    if(input_id!=0xff)
    {
      System.sensor_settings.mfi[input_id].input_type=DIG_IN;
      System.sensor_settings.mfi[input_id].polarity=ACTIVE_0;

      if(System.signal_state.digital_input[input_id])  _cls_state=UNLOCKED_CLS_STATE;
      else                                             _cls_state=LOCKED_CLS_STATE;
    }

    input_id=CITROEN_JUMPY_FRONT_DOORS_INPUT_ID;
    if(input_id!=0xff)
    {
      System.sensor_settings.mfi[input_id].input_type=DIG_IN;
      System.sensor_settings.mfi[input_id].polarity=ACTIVE_0;

      if(System.signal_state.digital_input[input_id]) System.can_state.sec_flags.driver_door=1;
      else                                            System.can_state.sec_flags.driver_door=0;
    }

    input_id=CITROEN_JUMPY_REAR_DOORS_INPUT_ID;
    if(input_id!=0xff)
    {
      System.sensor_settings.mfi[input_id].input_type=DIG_IN;
      System.sensor_settings.mfi[input_id].polarity=ACTIVE_0;

      if(System.signal_state.digital_input[input_id])  System.can_state.sec_flags.l_rear_door=1;
      else                                             System.can_state.sec_flags.l_rear_door=0;
    }


    input_id=CITROEN_JUMPY_HOOD_DOOR_INPUT_ID;
    if(input_id!=0xff)
    {
      System.sensor_settings.mfi[input_id].input_type=DIG_IN;
      System.sensor_settings.mfi[input_id].polarity=ACTIVE_0;

      if(System.signal_state.digital_input[input_id])   System.can_state.sec_flags.hood=1;
      else                                              System.can_state.sec_flags.hood=0;
    }

    input_id=CITROEN_JUMPY_TRUNK_DOOR_INPUT_ID;
    if(input_id!=0xff)
    {
      System.sensor_settings.mfi[input_id].input_type=DIG_IN;
      System.sensor_settings.mfi[input_id].polarity=ACTIVE_0;

      if(System.signal_state.digital_input[input_id])  System.can_state.sec_flags.trunk=1;
      else                                             System.can_state.sec_flags.trunk=0;
    }

    static_assert(!((CITROEN_JUMPY_MANUAL_GEARBOX_INPUT_ID+1)>MAX_MF_INPUTS), "wrong CITROEN_JUMPY_MANUAL_GEARBOX_INPUT_ID defined");
    input_id=CITROEN_JUMPY_MANUAL_GEARBOX_INPUT_ID;
    System.sensor_settings.mfi[input_id].input_type=DIG_IN;
    System.sensor_settings.mfi[input_id].polarity=ACTIVE_0;
  }
}

static void nissan_leaf_analog_to_can_handler(void)
{
  if(can_program==NISSAN_LEAF_2019_PROGRAM)
  {
    uint8_t input_id;

    input_id=NISSAN_LEAF_HOOD_DOOR_INPUT_ID;
    if(input_id!=0xff)
    {
      System.sensor_settings.mfi[input_id].input_type=DIG_IN;
      System.sensor_settings.mfi[input_id].polarity=NISSAN_LEAF_HOOD_DOOR_INPUT_POLARITY;

      if(System.signal_state.digital_input[input_id]) System.can_state.sec_flags.hood=1;
      else                                            System.can_state.sec_flags.hood=0;
    }

    input_id=NISSAN_LEAF_CHARGE_CAP_INPUT_ID;
    if(input_id!=0xff)
    {
      System.sensor_settings.mfi[input_id].input_type=DIG_IN;
      System.sensor_settings.mfi[input_id].polarity=NISSAN_LEAF_CHARGE_CAP_INPUT_POLARITY;

      if(System.signal_state.digital_input[input_id]) System.signal_state.tank_flap=1;
      else                                            System.signal_state.tank_flap=0;
    }

  }
}

static void bmw_520i_analog_to_can_handler(void)
{
  if(can_program==BMW_520I_2018_PROGRAM)
  {
    //на BMW забыли подключить зажигание
    System.sensor_settings.use_can_ignition=true;


    uint8_t input_id=IS_BMW_320D_INPUT_ID;
    System.sensor_settings.mfi[input_id].input_type=DIG_IN;
    System.sensor_settings.mfi[input_id].polarity=ACTIVE_0;

    if(is_can_timer_expired(AUX_CAN_TIMER_1))
    {
      System.can_state.cont_flags.inflation_pressure=0;
    }

    if(is_can_timer_expired(AUX_CAN_TIMER_2))
    {
      System.can_state.cont_flags.serv_maint=0;
    }

    if(is_can_timer_expired(AUX_CAN_TIMER_3))
    {
      System.signal_state.washer_liquid=0;
    }
  }
}

static void audi_a3_octavia_rapid_analog_to_can_handler(void)
{
  if(can_program==SKODA_RAPID_2018_PROGRAM)
  {
    uint8_t input_id;

    input_id=SKODA_RAPID_HOOD_DOOR_INPUT_ID;
    if(input_id!=0xff)
    {
      System.sensor_settings.mfi[input_id].input_type=DIG_IN;
      System.sensor_settings.mfi[input_id].polarity=SKODA_RAPID_HOOD_DOOR_INPUT_POLARITY;

      if(System.signal_state.digital_input[input_id]) System.can_state.sec_flags.hood=1;
      else                                            System.can_state.sec_flags.hood=0;
    }

    if(is_can_timer_expired(AUX_CAN_TIMER_1))
    {
      if(System.can_state.numeric_data.eng_rpm || System.can_state.sec_flags.engine_is_on)
      {
        System.Grab(portMAX_DELAY);
        System.can_state.numeric_data.eng_rpm=0;
        System.can_state.sec_flags.engine_is_on=0;
        System.Release();
      }
    }
  }
}

static void ford_transit_analog_to_can_handler(void)
{
  if(can_program==FORD_TRANSIT_2017_PROGRAM)
  {
    uint8_t input_id;

    input_id=FORD_TRANSIT_REAR_DOOR_INPUT_ID;
    if(input_id!=0xff)
    {
      System.sensor_settings.mfi[input_id].input_type=DIG_IN;
      System.sensor_settings.mfi[input_id].polarity=FORD_TRANSIT_REAR_DOOR_INPUT_POLARITY;

      if(System.signal_state.digital_input[input_id]) System.can_state.sec_flags.l_rear_door=1;
      else                                            System.can_state.sec_flags.l_rear_door=0;
    }

    input_id=FORD_TRANSIT_TRUNK_DOOR_INPUT_ID;
    if(input_id!=0xff)
    {
      System.sensor_settings.mfi[input_id].input_type=DIG_IN;
      System.sensor_settings.mfi[input_id].polarity=FORD_TRANSIT_TRUNK_DOOR_INPUT_POLARITY;

      if(System.signal_state.digital_input[input_id]) System.can_state.sec_flags.trunk=1;
      else                                            System.can_state.sec_flags.trunk=0;
    }

    input_id=FORD_TRANSIT_HOOD_DOOR_INPUT_ID;
    if(input_id!=0xff)
    {
      System.sensor_settings.mfi[input_id].input_type=DIG_IN;
      System.sensor_settings.mfi[input_id].polarity=FORD_TRANSIT_HOOD_DOOR_INPUT_POLARITY;

      if(System.signal_state.digital_input[input_id]) System.can_state.sec_flags.hood=1;
      else                                            System.can_state.sec_flags.hood=0;
    }

    if(is_can_timer_expired(EMERG_LIGHT_FIX_TIMER))
    {
      System.signal_state.emergency_lights=0;
    }
  }
}

static void kia_rio_analog_to_can_handler(void)
{
  if(can_program==KIA_RIO_2017_PROGRAM)
  {
    uint8_t input_id;

    input_id=RIO_WASHER_LIQUID_INPUT_ID;
    if(input_id!=0xff)
    {
      System.sensor_settings.mfi[input_id].input_type=DIG_IN;
      System.sensor_settings.mfi[input_id].polarity=ACTIVE_0;

      if(System.signal_state.digital_input[input_id]) System.signal_state.washer_liquid=1;
      else                                            System.signal_state.washer_liquid=0;

      System.can_state.numeric_data.ad_blue_p=System.signal_state.washer_liquid;//temporary
    }

    if(is_can_timer_expired(EMERG_LIGHT_FIX_TIMER))
    {
      System.signal_state.emergency_lights=0;
    }
  }
}

static void renault_kaptur_analog_to_can_handler(void)
{
  if(can_program==RENAULT_KAPTUR_2016_PROGRAM)
  {
    //none
  }
}

static void hyundai_creta_analog_to_can_handler(void)
{
  if(can_program==HYUNDAI_CRETA_2019_PROGRAM)
  {
    uint8_t input_id;

    input_id=HYUNDAI_CRETA_HOOD_DOOR_INPUT_ID;
    if(input_id!=0xff)
    {
      System.sensor_settings.mfi[input_id].input_type=DIG_IN;
      System.sensor_settings.mfi[input_id].polarity=HYUNDAI_CRETA_HOOD_DOOR_INPUT_POLARITY;

      //жалобы на ложняки концевика, предположительно из-за влаги
      if(System.signal_state.digital_input[input_id]) System.can_state.sec_flags.hood=1;
      else                                            System.can_state.sec_flags.hood=0;
    }
  }
}

static void bmw_x1_analog_to_can_handler(void)
{
  if(can_program==BMW_X1_2019_PROGRAM)
  {
    //на BMW X1 зажигание подключили к ACC или хз куда, которое отключается с задержкой и все идет по пизде
    System.sensor_settings.use_can_ignition=true;

    if(is_can_timer_expired(AUX_CAN_TIMER_1))
    {
      System.can_state.cont_flags.inflation_pressure=0;
    }

    if(is_can_timer_expired(AUX_CAN_TIMER_2))
    {
      System.can_state.cont_flags.serv_maint=0;
    }

    if(is_can_timer_expired(AUX_CAN_TIMER_3))
    {
      System.signal_state.washer_liquid=0;
    }
  }
}

static void largus_analog_to_can_handler(void)
{
  if(can_program==LADA_LARGUS_2017_PROGRAM)
  {
    System.Grab(portMAX_DELAY);

    //т.к. в Largus'е нет скорости в CAN
    System.can_state.numeric_data.can_speed=(uint8_t)System.gnss_state.speed;

    if(!(__GET_IGN_STATE()))
    {
      System.can_state.numeric_data.eng_rpm=0;
      System.can_state.sec_flags.engine_is_on=0;
    }

    System.Release();
  }
}

static void volvo_xc60_analog_to_can_handler(void)
{
  if(can_program==VOLVO_XC60_2018_PROGRAM)
  {
    if(is_can_timer_expired(EMERG_LIGHT_FIX_TIMER))
    {
      System.signal_state.emergency_lights=0;
    }
    /*
    uint8_t input_id;

    input_id=VOLVO_XC60_PASS_DOOR_INPUT_ID;
    if(input_id!=0xff)
    {
      System.sensor_settings.mfi[input_id].input_type=DIG_IN;
      System.sensor_settings.mfi[input_id].polarity=ACTIVE_0;

      if(System.signal_state.digital_input[input_id]) System.can_state.sec_flags.pass_door=0;
      else                                            System.can_state.sec_flags.pass_door=1;
    }

    input_id=VOLVO_XC60_RIGHT_REAR_DOOR_INPUT_ID;
    if(input_id!=0xff)
    {
      System.sensor_settings.mfi[input_id].input_type=DIG_IN;
      System.sensor_settings.mfi[input_id].polarity=ACTIVE_0;

      if(System.signal_state.digital_input[input_id]) System.can_state.sec_flags.r_rear_door=0;
      else                                            System.can_state.sec_flags.r_rear_door=1;
    }

    input_id=VOLVO_XC60_HOOD_DOOR_INPUT_ID;
    if(input_id!=0xff)
    {
      System.sensor_settings.mfi[input_id].input_type=DIG_IN;
      System.sensor_settings.mfi[input_id].polarity=ACTIVE_0;

      if(System.signal_state.digital_input[input_id]) System.can_state.sec_flags.hood=0;
      else                                            System.can_state.sec_flags.hood=1;
    }

    input_id=VOLVO_XC60_TRUNK_DOOR_INPUT_ID;
    if(input_id!=0xff)
    {
      System.sensor_settings.mfi[input_id].input_type=DIG_IN;
      System.sensor_settings.mfi[input_id].polarity=ACTIVE_0;

      if(System.signal_state.digital_input[input_id]) System.can_state.sec_flags.trunk=0;
      else                                            System.can_state.sec_flags.trunk=1;
    }
    */
  }
}

static void volvo_xc40_analog_to_can_handler(void)
{
  if(can_program==VOLVO_XC40_2018_PROGRAM)
  {
    if(is_can_timer_expired(EMERG_LIGHT_FIX_TIMER))
    {
      System.signal_state.emergency_lights=0;
    }
  }
}

static void qashqai_analog_to_can_handler(void)
{
  if(can_program==NISSAN_QASHQAI_2018_PROGRAM)
  {
    if(is_can_timer_expired(EMERG_LIGHT_FIX_TIMER))
    {
      System.signal_state.emergency_lights=0;
    }
  }
}

static void range_rover_velar_analog_to_can_handler(void)
{
  if(can_program==RANGE_ROVER_VELAR_2018_PROGRAM)
  {

  }
}

static void mb_e200_2018_analog_to_can_handler(void)
{
  if(can_program==MB_E200_2018_PROGRAM)
  {
    uint8_t input_id=IS_MB_C180_INPUT_ID;
    System.sensor_settings.mfi[input_id].input_type=DIG_IN;
    System.sensor_settings.mfi[input_id].polarity=ACTIVE_0;

    input_id=IS_MB_E200_2020_INPUT_ID;
    System.sensor_settings.mfi[input_id].input_type=DIG_IN;
    System.sensor_settings.mfi[input_id].polarity=ACTIVE_0;
  }
}

static void audi_q3_analog_to_can_handler(void)
{
  if(can_program==VW_TRANSPORTER_2018_PROGRAM)
  {
    if(is_can_timer_expired(EMERG_LIGHT_FIX_TIMER))
    {
      System.signal_state.emergency_lights=0;
    }
  }
  else if(can_program==SKODA_RAPID_2013_PROGRAM)
  {
    const uint8_t input_id=SKODA_RAPID_2013_CLS_STATE_INPUT_ID;
    System.sensor_settings.mfi[input_id].input_type=DIG_IN;
    System.sensor_settings.mfi[input_id].polarity=ACTIVE_0;

    if(System.signal_state.digital_input[input_id]) {_cls_state=UNLOCKED_CLS_STATE;}
    else                                            {_cls_state=LOCKED_CLS_STATE;}

    if(_cls_state==LOCKED_CLS_STATE)
    {
      System.signal_state.cls_state.driver_door=0; System.signal_state.cls_state.l_rear_door=0; System.signal_state.cls_state.r_rear_door=0; System.signal_state.cls_state.pass_door=0;
    }
    else
    {
      System.signal_state.cls_state.driver_door=1; System.signal_state.cls_state.l_rear_door=1; System.signal_state.cls_state.r_rear_door=1; System.signal_state.cls_state.pass_door=1;
    }

    System.signal_state.cls_state.driver_door_prepared=1;
    System.signal_state.cls_state.l_rear_door_prepared=1;
    System.signal_state.cls_state.r_rear_door_prepared=1;
    System.signal_state.cls_state.pass_door_prepared=1;
  }
}

static void toyota_rav4_2019_analog_to_can_handler(void)
{
  if(can_program==TOYOTA_RAV4_2019_PROGRAM)
  {
    if(is_can_timer_expired(AUX_CAN_TIMER_1))
    {
      if(System.can_state.numeric_data.eng_rpm || System.can_state.sec_flags.engine_is_on)
      {
        System.Grab(portMAX_DELAY);
        {
          System.can_state.numeric_data.eng_rpm=0;
          System.can_state.sec_flags.engine_is_on=0;
        }System.Release();
      }
    }
  }
}

static void porsche_panamera_analog_to_can_handler(void)
{
  if(can_program==PORSCHE_PANAMERA_2019_PROGRAM)
  {
    //none
  }
}

static void hyundai_sonata_sd_analog_to_can_handler(void)
{
  if(can_program==HYUNDAI_SONATA_SD_2020_PROGRAM)
  {
    //none
  }
}


static void can_rx_kia_rio_hyundai_solaris_2017_handler(void)
{
  can_rx_frame_t rx;

  for(uint8_t can_id=CAN1_ID; can_id<HW_CAN_COUNT; can_id++)
  {
    uint16_t mess_count=filled_count_in_sfifo(&can_rx_sfifo[can_id]);

    for(uint16_t j=0; j<mess_count; j++)
    {
      if(!read_from_sfifo(&can_rx_sfifo[can_id], &rx))
      {
        __PRINTF("%s_RX sfifo is full, drop counter: %lu\n", get_name_from_can_id(can_id), can_rx_sfifo[can_id].drop_counter);
      }

#if defined(CAN_VEGA_FWD_PRESENT)
      rx_fwd_hadler(can_id, &rx);
#endif //defined(CAN_VEGA_FWD_PRESENT)

#if defined(YANDEX_OBD_PRESENT)
      obd_rx_handler(can_id, &rx);
#endif //defined(YANDEX_OBD_PRESENT)

      can_rx_debug_trace(&rx, can_id);

        if(can_id==CAN1_ID)
        {
          //Сервисная шина
          if(rx.id_type==STD_ID_TYPE)
          {
            if(can_program==KIA_RIO_2017_PROGRAM)
            {
              if(rx.id==0x103)
              {
                if(rx.data[2]&(1<<7))  System.can_state.sec_flags.driver_door=1;
                else                   System.can_state.sec_flags.driver_door=0;

                if(rx.data[0]&(1<<7))  System.can_state.sec_flags.pass_door=1;
                else                   System.can_state.sec_flags.pass_door=0;

                if(rx.data[5]&(1<<7))  System.can_state.sec_flags.l_rear_door=1;
                else                   System.can_state.sec_flags.l_rear_door=0;

                if(rx.data[5]&(1<<4))  System.can_state.sec_flags.r_rear_door=1;
                else                   System.can_state.sec_flags.r_rear_door=0;

                if(rx.data[6]&(1<<3))  System.can_state.sec_flags.trunk=1;
                else                   System.can_state.sec_flags.trunk=0;
              }
              else if(rx.id==0x130)
              {
                if(rx.data[3]&(1<<0))  System.can_state.sec_flags.hood=1;
                else                   System.can_state.sec_flags.hood=0;

                if(rx.data[6]&(1<<0))  System.can_state.sec_flags.hand_break=1;
                else                   System.can_state.sec_flags.hand_break=0;
              }
              else if(rx.id==0x100)
              {
                if(rx.data[3]==0x08 || rx.data[3]==0x10 /*ACC*/ || rx.data[3]==0xD8 || rx.data[3]==0x58 || rx.data[3]==0xA0)  System.can_state.sec_flags.key_in_ign=1;
                else                                                                                                          System.can_state.sec_flags.key_in_ign=0;

                if(rx.data[3]==0xD8 || rx.data[3]==0x58 || rx.data[3]==0xA0/*стартер*/)                                       System.can_state.sec_flags.ignition=1;
                else                                                                                                          System.can_state.sec_flags.ignition=0;
              }
              else if(rx.id==0x102)
              {
                if(rx.data[2]&(1<<1))   System.can_state.cont_flags.marker_lights=1;
                else                    System.can_state.cont_flags.marker_lights=0;

                if(rx.data[2]&(1<<2))   System.can_state.cont_flags.dipped_beam=1;
                else                    System.can_state.cont_flags.dipped_beam=0;

                if(rx.data[2]&(1<<3))   System.can_state.cont_flags.high_beam=1;
                else                    System.can_state.cont_flags.high_beam=0;
              }
            }
            else if(can_program==HYUNDAI_SOLARIS_2017_PROGRAM)
            {
              if(rx.id==0x1A3)
              {
                //D2
                //80 - дверь водителя открыта
                //00 - дверь водителя закрыта
                if(rx.data[2]!=0xFF)
                {
                  if(rx.data[2]&(1<<7))  System.can_state.sec_flags.driver_door=1;
                  else                   System.can_state.sec_flags.driver_door=0;
                }

                //D0
                //80 - дверь пассажира открыта
                //00 - дверь пассажира закрыта
                if(rx.data[0]!=0xFF)
                {
                  if(rx.data[0]&(1<<7))  System.can_state.sec_flags.pass_door=1;
                  else                   System.can_state.sec_flags.pass_door=0;
                }

                //D5
                //80 - открыта задняя левая дверь
                //10 - открыта задняя правая дверь
                //00 - задние двери закрыты
                if(rx.data[5]!=0xFF)
                {
                  if(rx.data[5]&(1<<7))  System.can_state.sec_flags.l_rear_door=1;
                  else                   System.can_state.sec_flags.l_rear_door=0;

                  if(rx.data[5]&(1<<4))  System.can_state.sec_flags.r_rear_door=1;
                  else                   System.can_state.sec_flags.r_rear_door=0;
                }

                //D6
                //08 - багажник открыт
                //00 - багажник закрыт
                if(rx.data[6]!=0xFF)
                {
                  if(rx.data[6]&(1<<3))  System.can_state.sec_flags.trunk=1;
                  else                   System.can_state.sec_flags.trunk=0;
                }

                //D3 D4
                //00 00 свет выкл
                //20 40 габариты
                //22 40 ближний свет
                //24 40 дальний свет
                //22 50 ближний свет + задние туманки
                if(rx.data[3]!=0xFF)
                {
                  if(rx.data[3]&(1<<5))   System.can_state.cont_flags.marker_lights=1;
                  else                    System.can_state.cont_flags.marker_lights=0;

                  if(rx.data[3]&(1<<1))   System.can_state.cont_flags.dipped_beam=1;
                  else                    System.can_state.cont_flags.dipped_beam=0;

                  if(rx.data[3]&(1<<2))   System.can_state.cont_flags.high_beam=1;
                  else                    System.can_state.cont_flags.high_beam=0;
                }
              }
              else if(rx.id==0x1A1)
              {
                //D1
                //00 - нет ключа
                //20 - включ вставлен
                //40 - ACC
                //60 - IGN
                //80 - STARTER
                if(rx.data[1]!=0xFF)
                {
                  if(rx.data[1]==0x20 || rx.data[1]==0x40 || rx.data[1]==0x60 || rx.data[1]==0x80)  System.can_state.sec_flags.key_in_ign=1;
                  else                                                                              System.can_state.sec_flags.key_in_ign=0;

                  if(rx.data[1]==0x60 || rx.data[1]==0x80)                                          System.can_state.sec_flags.ignition=1;
                  else                                                                              System.can_state.sec_flags.ignition=0;
                }
              }
              else if(rx.id==0x130)
              {
                //D6
                //80 - ручник опущен, фары не горят
                //81 - ручник затянут, фары не горят
                //01 - ручник затянут, фары горят
                if(rx.data[6]!=0xFF)
                {
                  if(rx.data[6]&(1<<0))  System.can_state.sec_flags.hand_break=1;
                  else                   System.can_state.sec_flags.hand_break=0;
                }

                //взято из Rio, на проверяемом Solaris нет информации о капоте
                if(rx.data[3]!=0xFF)
                {
                  if(rx.data[3]&(1<<0))  System.can_state.sec_flags.hood=1;
                  else                   System.can_state.sec_flags.hood=0;
                }
              }
            }
          }//if(rx.id_type==STD_ID_TYPE)
        }
        else if(can_id==CAN2_ID)
        {
          //Моторная шина
          if(rx.id_type==STD_ID_TYPE)
          {
            if(rx.id==0x329)
            {
              if(rx.data[4]==0x12)  System.can_state.sec_flags.pedal_break=1;
              else/*0x11*/          System.can_state.sec_flags.pedal_break=0;
            }
            else if (rx.id==0x2B0)
            {
              System.Grab(portMAX_DELAY);
              int16_t angle = (rx.data[1] << 8) | rx.data[0];
              System.can_state.numeric_data.battery_charge_level = angle * -0.1f;
              System.can_state.numeric_data.thresher_rpm = rx.data[2];
              System.Release();
            }
            else if(rx.id==0x111)
            {
              System.can_state.numeric_data.can_axle_1=rx.data[1];
              //D1
              //x9 - зажигание выкл.
              if(rx.data[1]!=0xFF)
              {
                System.Grab(portMAX_DELAY);
                {
                  if((rx.data[1]&0x0f)==0x00)      {System.can_state.sec_flags.parking=1; System.can_state.sec_flags.reverse_gear=0;}
                  else if((rx.data[1]&0x0f)==0x07) {System.can_state.sec_flags.parking=0; System.can_state.sec_flags.reverse_gear=1;}
                  else                             {System.can_state.sec_flags.parking=0; System.can_state.sec_flags.reverse_gear=0;}

                  if((rx.data[1]&0x0f)==0x00)       System.signal_state.selector_position='P';
                  else if ((rx.data[1]&0x0f)==0x07) System.signal_state.selector_position='R';
                  else if ((rx.data[1]&0x0f)==0x06) System.signal_state.selector_position='N';
                  else if ((rx.data[1]&0x0f)==0x05) System.signal_state.selector_position='D';
                  else if ((rx.data[1]&0x0f)==0x08) System.signal_state.selector_position='M';
                  else if ((rx.data[1]&0x0f)==0x09) System.signal_state.selector_position='U';

                  //если стоим на месте и на паркинге, то приходит нуль
                  //System.can_state.numeric_data.eng_rpm=((rx.data[6]<<8)|(rx.data[5]<<0))/4;

                  //if(System.can_state.numeric_data.eng_rpm>350) System.can_state.sec_flags.engine_is_on=1;
                  //else                                          System.can_state.sec_flags.engine_is_on=0;
                }System.Release();
              }
            }
            else if(rx.id==0x260)
            {
              if(rx.data[2]!=0xFF)
              {
                System.can_state.numeric_data.accelerator=(rx.data[2]*100Ul)/255Ul;
              }
            }
            else if(rx.id==0x545)
            {
               //напряжение АКБ
               //(rx.data[3])/10.f

               if(rx.data[0]!=0xFF)
               {
                 if(rx.data[0]&(1<<1)) System.can_state.cont_flags.check_engine=1;
                 else                  System.can_state.cont_flags.check_engine=0;
               }
            }
            else if(rx.id==0x5A0)
            {
               if(rx.data[4]!=0xFF)
               {
                 if(rx.data[4]&(1<<0)) System.can_state.cont_flags.airbag=0;
                 else                  System.can_state.cont_flags.airbag=1;
               }
            }
            else if(rx.id==0x316)
            {
              if(rx.data[6]!=0xFF && rx.data[3]!=0xFF)
              {
                System.Grab(portMAX_DELAY);
                {
                  System.can_state.numeric_data.can_speed=rx.data[6];
                  //1000rpm 0x10
                  //2000rpm 0x20
                  System.can_state.numeric_data.eng_rpm=(rx.data[3]*1000UL)/16UL;

                  if(System.can_state.numeric_data.eng_rpm>350) System.can_state.sec_flags.engine_is_on=1;
                  else                                          System.can_state.sec_flags.engine_is_on=0;
                }System.Release();
              }
            }
            else if(rx.id==0x50C)
            {
              System.Grab(portMAX_DELAY);
              {
                //расстоние до пустого бака
                //314 0x3a05
                //315 0x3b05
                //316 0x3c05
                //317 0x3d05
                //319 0x3f05
                //613 0x6506
                System.can_state.numeric_data.fuel_lev_l=0x03ff&(rx.data[4]<<8)|(rx.data[3]<<0);

                //средний расход л/100км
                //-------D0D1
                //-//- 0xc8ff
                //13.5 0xc821
                //14.0 0x0823
                //14.4 0x0824
                //14.5 0x4824
                //15.6 0x0827
                //15.8 0x8827
                uint16_t val=((rx.data[1]<<8)|(rx.data[0]<<0))>>4;
                if(val==0xFFC)
                {
                  System.can_state.numeric_data.fuel_flow=0;
                }
                else
                {
                  System.can_state.numeric_data.fuel_flow=val/(4*10.0f);
                }
              }System.Release();
            }
            else if(rx.id==0x5B0)
            {
              System.Grab(portMAX_DELAY);
              {
                System.can_state.numeric_data.can_odo_km=((rx.data[2]<<16)|(rx.data[1]<<8)|(rx.data[0]<<0))/10.0f;
              }System.Release();
            }
            else if(rx.id==0x541)
            {
              if(can_program==KIA_RIO_2017_PROGRAM)
              {
                if(rx.data[1]&(1<<2))   System.can_state.cont_flags.driver_safety_belt=1;
                else                    System.can_state.cont_flags.driver_safety_belt=0;
              }
              else if(can_program==HYUNDAI_SOLARIS_2017_PROGRAM)
              {
                //D1
                //44 - ремень водителя вставлен
                //40 - ремень водителя вытащен
                if(rx.data[1]&(1<<2))   System.can_state.cont_flags.driver_safety_belt=1;
                else                    System.can_state.cont_flags.driver_safety_belt=0;
              }

              if(rx.data[4]!=0xFF) //проверяли только на рио
              {
                if(rx.data[4]&(1<<1))
                {
                  System.signal_state.emergency_lights=1;
                  restart_can_timer(EMERG_LIGHT_FIX_TIMER, 2500);
                }
              }
            }
            else if(rx.id==0x381)
            {
              //лампа рулевого управления
              if(rx.data[0]==0x00)//гасит лампу
              {
                System.can_state.cont_flags.chek_coolant=0;//изменить, временно!!!
              }

              //лампа акб
              if(rx.data[5]==0x00)//гасит лампу
              {
                System.can_state.cont_flags.battery=0;
              }

              //лампа давления масла
              if(rx.data[7]==0x00)//гасит лампу
              {
                System.can_state.cont_flags.chek_oil=0;
              }

              can_timers[AUX_CAN_TIMER_2]=1500;
            }
            else if(rx.id==0x18F)
            {
              //лампа уровня масла
              if(rx.data[4]==0xF0)//зажигаем лампу
              {
                //System.can_state.cont_flags.chek_oil=0;
              }
              can_timers[AUX_CAN_TIMER_1]=1500;
            }
            else if(rx.id==0x593)
            {
              //лампа TPMS
              if(rx.data[0]==0x00)//гасит лампу
              {
                System.can_state.cont_flags.inflation_pressure=0;
              }
              else
              {
                System.can_state.cont_flags.inflation_pressure=1;
              }
              can_timers[AUX_CAN_TIMER_4]=1500;
            }
            else if(rx.id==0x507)
            {
              if(rx.data[0]!=0xFF)
              {
                if(rx.data[0]&(1<<0))   System.can_state.cont_flags.abs=1;
                else                    System.can_state.cont_flags.abs=0;

                if(rx.data[0]&(1<<1))   System.can_state.cont_flags.esp=1;
                else                    System.can_state.cont_flags.esp=0;
              }
            }
            else if(rx.id==0x7CE)
            {
              //uds ответ на запрос уровня топлива
              if(rx.data[0]==0x21 && rx.data[2]!=0xFF)
              {
                //похоже это литры деленые пополам rx.data[2]/2

                float val=roundf((float)rx.data[2]*(100.0f/97.0f));
                if(val>100.0f) val=100.0f;

                System.set_fuel_level_p((uint8_t)val);
              }
            }
            else if(rx.id==0x7E8)
            {
              //OBDII ответ
              if(rx.data[0]==0x03 &&  rx.data[1]==0x41 && rx.data[2]==0x05)
              {
                System.Grab(portMAX_DELAY);
                {
                  System.can_state.numeric_data.eng_temp=rx.data[3]-40.0f;
                }System.Release();
              }
              /*
              else if(rx.data[0]==0x03 &&  rx.data[1]==0x41 && rx.data[2]==0x04)
              {
                System.Grab(portMAX_DELAY);
                {
                  System.can_state.numeric_data.engine_load=(rx.data[3]*100Ul)/255Ul;
                }System.Release();
              }
              */
            }
          }//if(rx.id_type==STD_ID_TYPE)
        }
        else if(can_id==CAN3_ID)
        {
          //none
        }
    }

    if(mess_count)
    {
      restart_sleep_and_rx_timers(can_id);
    }
  }

  System.can_state.sec_flags.can_in_sleep=can_sleep_indicate_handler();

  if(System.can_state.sec_flags.ignition && !can_timers[AUX_CAN_TIMER_1] && !get_can_from_id_from_periph(CAN2))
  {
    //no data on oil level lamp
  }
  else if(get_can_from_id_from_periph(CAN2) || !System.can_state.sec_flags.ignition)
  {

  }

  if(System.can_state.sec_flags.ignition && !can_timers[AUX_CAN_TIMER_2] && !get_can_from_id_from_periph(CAN2))
  {
    System.can_state.cont_flags.chek_coolant=1;//изменить, временно!!!
    System.can_state.cont_flags.battery=1;
    System.can_state.cont_flags.chek_oil=1;
  }
  else if(get_can_from_id_from_periph(CAN2) || !System.can_state.sec_flags.ignition)
  {
    System.can_state.cont_flags.chek_coolant=0;//изменить, временно!!!
    System.can_state.cont_flags.battery=0;
    System.can_state.cont_flags.chek_oil=0;
  }

  if(System.can_state.sec_flags.ignition && !can_timers[AUX_CAN_TIMER_4] && !get_can_from_id_from_periph(CAN2))
  {
    System.can_state.cont_flags.inflation_pressure=1;
  }
  else if(get_can_from_id_from_periph(CAN2) || !System.can_state.sec_flags.ignition)
  {
    System.can_state.cont_flags.inflation_pressure=0;
  }

  blocks_handler();

  kia_rio_analog_to_can_handler();

  taxi_blocks_handler();
}

static void can_rx_renault_kaptur_2016_handler(void)
{
  can_rx_frame_t rx;

  for(uint8_t can_id=CAN1_ID; can_id<HW_CAN_COUNT; can_id++)
  {
    uint16_t mess_count=filled_count_in_sfifo(&can_rx_sfifo[can_id]);

    for(uint16_t j=0; j<mess_count; j++)
    {
      if(!read_from_sfifo(&can_rx_sfifo[can_id], &rx))
      {
        __PRINTF("%s_RX sfifo is full, drop counter: %lu\n", get_name_from_can_id(can_id), can_rx_sfifo[can_id].drop_counter);
      }

#if defined(CAN_VEGA_FWD_PRESENT)
      rx_fwd_hadler(can_id, &rx);
#endif //defined(CAN_VEGA_FWD_PRESENT)

#if defined(YANDEX_OBD_PRESENT)
      obd_rx_handler(can_id, &rx);
#endif //defined(YANDEX_OBD_PRESENT)

      can_rx_debug_trace(&rx, can_id);

        if(can_id==CAN1_ID)
        {
          //Моторная шина
          if(rx.id_type==STD_ID_TYPE)
          {
            if(rx.id==0x5DE)
            {
              if(rx.data[1]&(1<<3)) System.can_state.sec_flags.driver_door=1;
              else                  System.can_state.sec_flags.driver_door=0;

              if(rx.data[1]&(1<<1)) System.can_state.sec_flags.pass_door=1;
              else                  System.can_state.sec_flags.pass_door=0;

              if(rx.data[2]&(1<<6)) System.can_state.sec_flags.l_rear_door=1;
              else                  System.can_state.sec_flags.l_rear_door=0;

              if(rx.data[2]&(1<<4)) System.can_state.sec_flags.r_rear_door=1;
              else                  System.can_state.sec_flags.r_rear_door=0;

              if(rx.data[7]&(1<<4)) System.can_state.sec_flags.trunk=1;
              else                  System.can_state.sec_flags.trunk=0;

              if(rx.data[0]&(1<<2)) System.can_state.cont_flags.marker_lights=1;
              else                  System.can_state.cont_flags.marker_lights=0;

              if(rx.data[0]&(1<<1)) System.can_state.cont_flags.dipped_beam=1;
              else                  System.can_state.cont_flags.dipped_beam=0;

              if(rx.data[0]&(1<<0)) System.can_state.cont_flags.high_beam=1;
              else                  System.can_state.cont_flags.high_beam=0;
            }
            else if(rx.id==0x0C6)
            {
              uint16_t angle = (rx.data[0] << 8) | rx.data[1];

              float angle_result = 0;

              if (angle & (1 << 15)) {
                angle &= ~(1 << 15);
                angle_result = angle;
                angle_result *= -1.0f;
              } else {
                angle = 0x7FFF - angle;
                angle_result = angle;
              }

              angle_result /= 10.0f;

              System.can_state.numeric_data.battery_charge_level = angle_result; // steering wheels
              System.can_state.numeric_data.thresher_rpm = (rx.data[2] << 8) | rx.data[3]; // steering acceleration
            }
            else if (rx.id==0x090)
            {
              System.can_state.numeric_data.brake = rx.data[0];
            }
            else if(rx.id==0x350)
            {
              if(rx.data[6]!=0xFF)
              {
                if(rx.data[6]&(1<<7)) System.can_state.sec_flags.hood=0;
                else                  System.can_state.sec_flags.hood=1;
              }

              if(rx.data[7]!=0xFF)
              {
                if(rx.data[7]&(1<<4)) System.signal_state.emergency_lights=1;
                else                  System.signal_state.emergency_lights=0;
              }
            }
            else if(rx.id==0x1F6)
            {
              //не видим
              if(rx.data[2]&(1<<3)) System.can_state.sec_flags.pedal_break=1;
              else                  System.can_state.sec_flags.pedal_break=0;
            }
            else if(rx.id==0x3F7)
            {
              if(rx.data[0]==0x08 /*P*/ || rx.data[0]==0x10 /*R*/ || rx.data[0]==0x18 /*N*/ || rx.data[0]==0x20 /*D*/|| rx.data[0]==0x80 /*M*/ || rx.data[0]==0x88 /*M*/)
              {
                System.Grab(portMAX_DELAY);
                {
                  if(rx.data[0]==0x08)          {System.can_state.sec_flags.parking=1; System.can_state.sec_flags.reverse_gear=0;}
                  else if(rx.data[0]==0x10)     {System.can_state.sec_flags.parking=0; System.can_state.sec_flags.reverse_gear=1;}
                  else                          {System.can_state.sec_flags.parking=0; System.can_state.sec_flags.reverse_gear=0;}

                  if(rx.data[0]==0x08) System.signal_state.selector_position='P';
                  else if (rx.data[0]==0x10) System.signal_state.selector_position='R';
                  else if (rx.data[0]==0x18) System.signal_state.selector_position='N';
                  else if (rx.data[0]==0x20) System.signal_state.selector_position='D';
                  else if (rx.data[0]==0x80 || rx.data[0]==0x88) System.signal_state.selector_position='M';

                }System.Release();
              }
            }
            else if(rx.id==0x4AC)
            {
              System.Grab(portMAX_DELAY);
              {
                if(rx.data[4]&(1<<5))     System.can_state.sec_flags.ignition=1;
                else                      System.can_state.sec_flags.ignition=0;
              }System.Release();
            }
            else if(rx.id==0x4F8)
            {
              System.Grab(portMAX_DELAY);
              {
                if(rx.data[0]&(1<<3))     System.can_state.sec_flags.hand_break=1;
                else                      System.can_state.sec_flags.hand_break=0;
              }System.Release();
            }
            else if(rx.id==0x186)
            {
              if(rx.data[0]!=0xff)
              {
                System.Grab(portMAX_DELAY);
                {
                  //1000rpm 0x20
                  //2000rpm 0x40
                  System.can_state.numeric_data.eng_rpm=(rx.data[0]*1000UL)/32UL;

                  if(System.can_state.numeric_data.eng_rpm>350) System.can_state.sec_flags.engine_is_on=1;
                  else                                          System.can_state.sec_flags.engine_is_on=0;

                  //0xFA-кикдаун
                  System.can_state.numeric_data.accelerator=(rx.data[5]*100Ul)/204Ul;

                }System.Release();
              }
            }
            else if(rx.id==0x653)
            {
              if(rx.data[1]!=0xFF)
              {
                if(rx.data[1]&(1<<6))     System.can_state.cont_flags.driver_safety_belt=0;
                else                      System.can_state.cont_flags.driver_safety_belt=1;

                if(rx.data[1]&(1<<4))     System.can_state.cont_flags.passenger_safety_belt=0;
                else                      System.can_state.cont_flags.passenger_safety_belt=1;
              }
            }
            else if(rx.id==0x29A)
            {
              uint16_t val = (rx.data[0]<<8)|(rx.data[1]<<0);

              if(val < 0xFFFE)
              {
                if(can_program==RENAULT_KAPTUR_2016_PROGRAM)
                {
                  System.can_state.numeric_data.can_speed=(val*2Ul)/381Ul; //0.00525
                }
                else
                {
                  System.can_state.numeric_data.can_speed=(val)/166Ul;
                }
              }
            }
            else if(rx.id==0x7E8)
            {
              //OBDII ответ
              if(rx.data[0]==0x03 &&  rx.data[1]==0x41 && rx.data[2]==0x05)
              {
                System.Grab(portMAX_DELAY);
                {
                  System.can_state.numeric_data.eng_temp=rx.data[3]-40.0f;
                }System.Release();
              }
//              else if(rx.data[0]==0x03 &&  rx.data[1]==0x41 && rx.data[2]==0x04)
//              {
//                System.Grab(portMAX_DELAY);
//                {
//                  System.can_state.numeric_data.engine_load=1+(rx.data[3]*100Ul)/255Ul;
//                }System.Release();
//              }
              else if(can_program==RENAULT_KAPTUR_2016_PROGRAM && rx.data[0]==0x03 &&  rx.data[1]==0x41 && rx.data[2]==0x2F)
              {
                  //1.4? или 1,6?
                  //rx.data[3] стрелка
                  //160        100%
                  //105        75%
                  //70         50%
                  //37         25% (?)
                  //11(?)     ~20% лампа (?)
                  System.set_fuel_level_p((rx.data[3]*100Ul)/160Ul);
              }
//              else if(rx.data[0]==0x04 &&  rx.data[1]==0x41 && rx.data[2]==0x5E)
//              {
//                System.Grab(portMAX_DELAY);
//                {
//                  System.can_state.numeric_data.fuel_flow=((rx.data[3]<<8)|(rx.data[4]<<0))/20.0f;
//                }System.Release();
//              }
            }
            else if(rx.id==0x666)
            {
              //хз, esp отпределяет, abs не проверяли
              if(rx.data[0]&(1<<3))   System.can_state.cont_flags.abs=1;
              else                    System.can_state.cont_flags.abs=0;

              if(rx.data[0]&(1<<6))   System.can_state.cont_flags.esp=1;
              else                    System.can_state.cont_flags.esp=0;

              if(rx.data[2])   System.can_state.cont_flags.abs=1;
              else             System.can_state.cont_flags.abs=0;
            }
            else if(rx.id==0x66A)
            {
              if((rx.data[0]&(1<<3)) || (rx.data[0]&(1<<4)) \
                || (rx.data[2]&(1<<1)) || (rx.data[2]&(1<<3)) || (rx.data[2]&(1<<6))) System.can_state.cont_flags.check_engine=1;
              else                                                                    System.can_state.cont_flags.check_engine=0;

              if((rx.data[2]&(1<<4)) || (rx.data[2]&(1<<5)))                          System.can_state.cont_flags.chek_oil=1;
              else                                                                    System.can_state.cont_flags.chek_oil=0;
            }
            else if(rx.id==0x763)
            {
              if(rx.data[0]==0x06 && rx.data[1]==0x62 && rx.data[2]==0x02 && rx.data[3]==0x07)
              {
                System.Grab(portMAX_DELAY);
                {
                  System.can_state.numeric_data.can_odo_km=((rx.data[4]<<16)|(rx.data[5]<<8)|(rx.data[6]<<0));
                }System.Release();
              }
              else if(can_program==RENAULT_DOKKER_2018_PROGRAM && rx.data[0]==0x05 && rx.data[1]==0x62 && rx.data[2]==0x22 && rx.data[3]==0x03)
              {
                //в литрах, возможно на Kaptur тоже будет работать
                uint16_t val=(rx.data[4]<<8)|(rx.data[5]<<0);

                if(val!=0xFFFF)
                {
                  val=(uint16_t)lroundf(val/100.0f);

                  System.Grab(portMAX_DELAY);
                  {
                    System.can_state.numeric_data.fuel_lev_l=val;
                  }System.Release();

                  val=(rx.data[4]<<8)|(rx.data[5]<<0);
                  val=(val)/50Ul;
                  //ограничение убираем, пока не оттарировали
                  //if(val>100) val=100;

                  System.set_fuel_level_p(val);
                }
              }
            }
          }//if(rx.id_type==STD_ID_TYPE)
        }
        else if(can_id==CAN2_ID)
        {
          //none
        }
        else if(can_id==CAN3_ID)
        {
          //none
        }
    }

    if(mess_count)
    {
      restart_sleep_and_rx_timers(can_id);
    }
  }

  System.can_state.sec_flags.can_in_sleep=can_sleep_indicate_handler();

  blocks_handler();

  renault_kaptur_analog_to_can_handler();

  taxi_blocks_handler();
}

static void can_rx_hyundai_genesis_2017_handler(void)
{
  can_rx_frame_t rx;

  for(uint8_t can_id=CAN1_ID; can_id<HW_CAN_COUNT; can_id++)
  {
    uint16_t mess_count=filled_count_in_sfifo(&can_rx_sfifo[can_id]);

    for(uint16_t j=0; j<mess_count; j++)
    {
      if(!read_from_sfifo(&can_rx_sfifo[can_id], &rx))
      {
        __PRINTF("%s_RX sfifo is full, drop counter: %lu\n", get_name_from_can_id(can_id), can_rx_sfifo[can_id].drop_counter);
      }

#if defined(CAN_VEGA_FWD_PRESENT)
      rx_fwd_hadler(can_id, &rx);
#endif //defined(CAN_VEGA_FWD_PRESENT)

#if defined(YANDEX_OBD_PRESENT)
      obd_rx_handler(can_id, &rx);
#endif //defined(YANDEX_OBD_PRESENT)

      can_rx_debug_trace(&rx, can_id);

        if(can_id==CAN1_ID)
        {
          //Салонная шина 500 кбит\с
          if(rx.id_type==STD_ID_TYPE)
          {
            if(rx.id==0x101)
            {
              System.Grab(portMAX_DELAY);
              {
                if(rx.data[0]&(1<<5))   System.can_state.cont_flags.driver_safety_belt=0;
                else                    System.can_state.cont_flags.driver_safety_belt=1;
              }System.Release();
            }
            else if(rx.id==0x168)
            {
              /*
              00000168 08 00 04 00 13 70 00 00 все замки открыты
              00000168 08 00 00 00 13 70 00 00 все замки открыты кроме водительского
              00000168 08 00 00 00 12 70 00 00 все замки открыты кроме водительского и заденго левого
              00000168 00 00 00 00 12 70 00 00 все замки открыты кроме водительского и заденго левого и пассажиского
              00000168 00 00 00 00 12 50 00 00 все замки закрыты
              */

              if(!(rx.data[0]==0xFF || rx.data[2]==0xFF || rx.data[4]==0xFF || rx.data[5]==0xFF))
              {
                if(rx.data[2]&(1<<2)) System.signal_state.cls_state.driver_door=1;
                else                  System.signal_state.cls_state.driver_door=0;
                System.signal_state.cls_state.driver_door_prepared=1;

                if(rx.data[4]&(1<<0)) System.signal_state.cls_state.l_rear_door=1;
                else                  System.signal_state.cls_state.l_rear_door=0;
                System.signal_state.cls_state.l_rear_door_prepared=1;

                if(rx.data[5]&(1<<5)) System.signal_state.cls_state.r_rear_door=1;
                else                  System.signal_state.cls_state.r_rear_door=0;
                System.signal_state.cls_state.r_rear_door_prepared=1;

                if(rx.data[0]&(1<<3)) System.signal_state.cls_state.pass_door=1;
                else                  System.signal_state.cls_state.pass_door=0;
                System.signal_state.cls_state.pass_door_prepared=1;

                if(System.signal_state.cls_state.driver_door || System.signal_state.cls_state.l_rear_door || System.signal_state.cls_state.r_rear_door || System.signal_state.cls_state.pass_door) _cls_state=UNLOCKED_CLS_STATE;
                else                                                                                                                                                                               _cls_state=LOCKED_CLS_STATE;

                if(System.signal_state.cls_state.driver_door || System.signal_state.cls_state.l_rear_door || System.signal_state.cls_state.r_rear_door || System.signal_state.cls_state.pass_door) System.can_state.sec_flags.closed_by_pult=0;
                else                                                                                                                                                                               System.can_state.sec_flags.closed_by_pult=1;
              }
            }
            else if(rx.id==0x105)
            {
              /*
              00000105 0f 00 00 00 00 00 00 00 00 все окна открыты
              00000105 0e 00 00 00 00 00 00 00 00 все окна открыты кроме заднего левого
              00000105 0c 00 00 00 00 00 00 00 00 все окна открыты кроме заднего левого и заднего правого
              00000105 08 00 00 00 00 00 00 00 00 все окна открыты кроме заднего левого, заднего правого и пассажирского
              00000105 00 00 00 00 00 00 00 00 00 все окна закрыты
              */
              if(!(rx.data[0]==0xFF))
              {
                if(rx.data[0]&(1<<3))  System.signal_state.windows_position.driver_door=1;
                else                   System.signal_state.windows_position.driver_door=0;
                System.signal_state.windows_position.driver_door_prepared=1;

                if(rx.data[0]&(1<<2))  System.signal_state.windows_position.pass_door=1;
                else                   System.signal_state.windows_position.pass_door=0;
                System.signal_state.windows_position.pass_door_prepared=1;

                if(rx.data[0]&(1<<1))  System.signal_state.windows_position.r_rear_door=1;
                else                   System.signal_state.windows_position.r_rear_door=0;
                System.signal_state.windows_position.r_rear_door_prepared=1;

                if(rx.data[0]&(1<<0))  System.signal_state.windows_position.l_rear_door=1;
                else                   System.signal_state.windows_position.l_rear_door=0;
                System.signal_state.windows_position.l_rear_door_prepared=1;
              }
            }
            else if(rx.id==0x169)
            {
              if(rx.data[1]!=0xFF)
              {
                if(rx.data[1]&(1<<7)) System.can_state.sec_flags.pedal_break=1;
                else                  System.can_state.sec_flags.pedal_break=0;
              }
            }
          }//if(rx.id_type==STD_ID_TYPE)
        }
        else if(can_id==CAN2_ID)
        {
          //Моторная шина 500 кбит\с
          if(rx.id_type==STD_ID_TYPE)
          {
            if(rx.id==0x220)
            {
              //не работает
              /*
              //0x00 0x00 не нажато
              //0x80 0x01 в половину
              //0xEC 0x05 со всей силы вдавлено
              //педаль тормоза
              System.Grab(portMAX_DELAY);
              {
                if(rx.data[3]==0x00 && rx.data[4]==0x00)  System.can_state.sec_flags.pedal_break=0;
                else                                      System.can_state.sec_flags.pedal_break=1;
              }System.Release();
              */
            }
            else if(rx.id==0x260)
            {
              //педаль газа
              System.Grab(portMAX_DELAY);
              {
                //третий байт от A7(газ не нажат) до EE(до упора) при незаведенном автомобиле
                if(rx.data[2]<=0xa7) System.can_state.numeric_data.accelerator=0;
                else                 System.can_state.numeric_data.accelerator=((rx.data[2]-0xA7UL)*100Ul)/(0xEEUL-0xA7UL);
              }System.Release();
            }
            else if(rx.id==0x251)
            {
              //угол поворота рулевого колеса
            }
            else if(rx.id==0x366)
            {
              //тахометр
              System.Grab(portMAX_DELAY);
              {
                //0E холостые
                //17 1500...1550
                //1F 2000
                System.can_state.numeric_data.eng_rpm=(rx.data[2]*1000UL)/16UL;

                if(System.can_state.numeric_data.eng_rpm>350) System.can_state.sec_flags.engine_is_on=1;
                else                                          System.can_state.sec_flags.engine_is_on=0;
              }System.Release();
            }
            else if(rx.id==0x367)
            {
              //положение селектора АКПП
              if(!(rx.data[4]==0xff))
              {
                System.Grab(portMAX_DELAY);
                {
                  if((rx.data[4]&0x0f)==0x00)      {System.can_state.sec_flags.parking=1; System.can_state.sec_flags.reverse_gear=0;}
                  else if((rx.data[4]&0x0f)==0x07) {System.can_state.sec_flags.parking=0; System.can_state.sec_flags.reverse_gear=1;}
                  else                             {System.can_state.sec_flags.parking=0; System.can_state.sec_flags.reverse_gear=0;}

                  if((rx.data[4]&0x0f)==0x00)       System.signal_state.selector_position='P';
                  else if ((rx.data[4]&0x0f)==0x07) System.signal_state.selector_position='R';
                  else if ((rx.data[4]&0x0f)==0x06) System.signal_state.selector_position='N';
                  else if ((rx.data[4]&0x0f)==0x05) System.signal_state.selector_position='D';
                  else if ((rx.data[4]&0x0f)==0x08) System.signal_state.selector_position='M';//не проверялось
                  else if ((rx.data[4]&0x0f)==0x09) System.signal_state.selector_position='U';//как на RIO, не проверялось
                }System.Release();
              }
            }
            else if(rx.id==0x52A)
            {
              //скорость
              if(rx.data[0]!=0xFF)
              {
                System.can_state.numeric_data.can_speed=rx.data[0];
              }
            }
            else if(rx.id==0x490)
            {
              //комплектация с электронным ручником, в комплектации с ножником этого ID нет
              //ручник/EPB
              is_genesis_w_electric_hand_break=true;

              if(rx.data[0]!=0xFF)
              {
                if(rx.data[0]&(1<<0))     System.can_state.sec_flags.hand_break=1;
                else                      System.can_state.sec_flags.hand_break=0;
              }
            }
            else if(rx.id==0x500)
            {
              //SRS
              if(rx.data[0]==0)     System.can_state.cont_flags.airbag=1;
              else                  System.can_state.cont_flags.airbag=0;
            }
            else if(rx.id==0x507)
            {
              //ABS
              if(rx.data[0]==0)     System.can_state.cont_flags.abs=0;
              else                  System.can_state.cont_flags.abs=1;
            }
            else if(rx.id==0x50C)
            {
              //запас хода
              System.Grab(portMAX_DELAY);
              {
                //аналогично RIO
                //расстоние до пустого бака
                //314 0x3a05
                //315 0x3b05
                //316 0x3c05
                //317 0x3d05
                //319 0x3f05
                //613 0x6506
                System.can_state.numeric_data.fuel_lev_l=0x03ff&(rx.data[4]<<8)|(rx.data[3]<<0);

                //средний расход л/100км
                //-------D0D1
                //-//- 0xc8ff
                //13.5 0xc821
                //14.0 0x0823
                //14.4 0x0824
                //14.5 0x4824
                //15.6 0x0827
                //15.8 0x8827
                uint16_t val=((rx.data[1]<<8)|(rx.data[0]<<0))>>4;
                if(val==0xFFC)
                {
                  System.can_state.numeric_data.fuel_flow=0;
                }
                else
                {
                  System.can_state.numeric_data.fuel_flow=val/(4*10.0f);
                }
              }System.Release();
            }
            else if(rx.id==0x541)
            {
              //статусы передних дверей, фар, багажника, капота
              //00 - выкл, 02 - acc, 03 - ign, 04 - start
              if((rx.data[0]&0x0f)==0x02 || (rx.data[0]&0x0f)==0x03 || (rx.data[0]&0x0f)==0x04) System.can_state.sec_flags.key_in_ign=1;
              else                                                                              System.can_state.sec_flags.key_in_ign=0;

              if((rx.data[0]&0x0f)==0x03 || (rx.data[0]&0x0f)==0x04) System.can_state.sec_flags.ignition=1;
              else                                                   System.can_state.sec_flags.ignition=0;

              if((rx.data[0]&0x0f)==0x00)      System.signal_state.key_position='O';
              else if((rx.data[0]&0x0f)==0x02) System.signal_state.key_position='A';
              else if((rx.data[0]&0x0f)==0x03) System.signal_state.key_position='I';
              else if((rx.data[0]&0x0f)==0x04) System.signal_state.key_position='S';
              else                             System.signal_state.key_position='U';

              if(rx.data[1]&(1<<0))  System.can_state.sec_flags.driver_door=1;
              else                   System.can_state.sec_flags.driver_door=0;

              if(rx.data[4]&(1<<3))  System.can_state.sec_flags.pass_door=1;
              else                   System.can_state.sec_flags.pass_door=0;

              if(rx.data[1]&(1<<4))  System.can_state.sec_flags.trunk=1;
              else                   System.can_state.sec_flags.trunk=0;

              if(rx.data[2]&(1<<1))  System.can_state.sec_flags.hood=1;
              else                   System.can_state.sec_flags.hood=0;

              //D4
              //0X off
              //CX auto
              //4X marker
              //8X dipped
              //X0 hi off
              //X1 hi on

              //если включен режим авто
              if((rx.data[4]&(1<<6)) && (rx.data[4]&(1<<7)))
              {
                if(System.can_state.sec_flags.ignition)
                {
                  System.can_state.cont_flags.marker_lights=1;
                  System.can_state.cont_flags.dipped_beam=1;
                }
                else
                {
                  System.can_state.cont_flags.marker_lights=0;
                  System.can_state.cont_flags.dipped_beam=0;
                }
              }
              else
              {
                if(rx.data[4]&(1<<6)) System.can_state.cont_flags.marker_lights=1;
                else                  System.can_state.cont_flags.marker_lights=0;

                if(rx.data[4]&(1<<7)) System.can_state.cont_flags.dipped_beam=1;
                else                  System.can_state.cont_flags.dipped_beam=0;
              }

              if(rx.data[4]&(1<<0)) System.can_state.cont_flags.high_beam=1;
              else                  System.can_state.cont_flags.high_beam=0;

              if(rx.data[4]!=0xFF)
              {
                if(rx.data[4]&(1<<1)) System.signal_state.emergency_lights=1;
                else                  System.signal_state.emergency_lights=0;
              }

              //механический ножник
              if(!is_genesis_w_electric_hand_break)
              {
                if(rx.data[7]!=0xFF)
                {
                  if(rx.data[7]&(1<<4))     System.can_state.sec_flags.hand_break=1;
                  else                      System.can_state.sec_flags.hand_break=0;
                }
              }
            }
            else if(rx.id==0x553)
            {
              //статус габаритных огней и задних дверей
              System.Grab(portMAX_DELAY);
              {
                if(rx.data[2]&(1<<7)) System.can_state.sec_flags.r_rear_door=1;
                else                  System.can_state.sec_flags.r_rear_door=0;

                if(rx.data[3]&(1<<0)) System.can_state.sec_flags.l_rear_door=1;
                else                  System.can_state.sec_flags.l_rear_door=0;
              }System.Release();
            }
            else if(rx.id==0x568)
            {
              //Check Engine
              System.Grab(portMAX_DELAY);
              {
                if(rx.data[1]==4) System.can_state.cont_flags.check_engine=1;
                else              System.can_state.cont_flags.check_engine=0;
              }System.Release();
            }
            else if(rx.id==0x53E)
            {
              //надпись "Сделать перерыв" и рисунок чашки кофе
              //System.Grab(portMAX_DELAY);
              //{

              //}System.Release();
            }
            else if(rx.id==0x593)
            {
              //статус TPMS  давление в шинах
              System.Grab(portMAX_DELAY);
              {
                if(rx.data[0]==0)     System.can_state.cont_flags.inflation_pressure=0;
                else                  System.can_state.cont_flags.inflation_pressure=1;
              }System.Release();
            }
            else if(rx.id==0x5B0)
            {
              //текущий пробег аналогично Rio
              System.Grab(portMAX_DELAY);
              {
                System.can_state.numeric_data.can_odo_km=((rx.data[2]<<16)|(rx.data[1]<<8)|(rx.data[0]<<0))/10.f;
              }System.Release();
            }
            else if(rx.id==0x59D)
            {
              if(rx.data[0]!=0xFF)
              {
                if(rx.data[0]==0x09) System.can_state.cont_flags.fap=1;
                else                 System.can_state.cont_flags.fap=0;
              }
            }
            /*
            else if(rx.id==0x7CE)
            {
              //uds ответ на запрос уровня топлива
              if(rx.data[0]==0x21 && rx.data[2]!=0xFF)
              {
                //116-полный бак
                System.set_fuel_level_p((rx.data[2]*100Ul)/116Ul);
              }
            }
            */
            else if(rx.id==0x329)
            {
              if(rx.data[1]!=0xFF)
              {
                System.Grab(portMAX_DELAY);
                {
                  System.can_state.numeric_data.eng_temp=rx.data[1]*0.75f-48.0f;
                }System.Release();
              }
            }
            else if(rx.id==0x7CE)
            {
              //todo: нужно попробовать на генезис, рио и солярис
              static uint8_t uds_cmd_byte=0xFF;

              if(rx.data[0]==0x10)
              {
                can_timers[UDS_ANS_TIMER_ID]=550; can_timers[UDS_ANS_TIMER_ID]=550;
                uds_cmd_byte=rx.data[4];
              }
              else if(rx.data[0]==0x21 && uds_cmd_byte!=0xFF && can_timers[UDS_ANS_TIMER_ID])
              {
                if(uds_cmd_byte==0x02 && rx.data[2]!=0xFF)
                {
                  //116-полный бак
                  //System.set_fuel_level_p((rx.data[2]*100Ul)/116Ul);

                  uint8_t val=rx.data[2];

                  if(val>116)     {val=116;} //полный бак
                  else if(val<12) {val=12;}  //пустой бак

                  float fval=0.5f*(val-12);

                  //fval=roundf(0.0039f*fval*fval+1.75f*fval-1.6f); //по линии тренда
                  fval=roundf(0.001f*fval*fval+1.9f*fval-1.6f);

                  if (fval > 100.0f) {
                    System.set_fuel_level_p(100);
                  } else if (fval < 0.1f) {
                    System.set_fuel_level_p(0);
                  } else {
                    System.set_fuel_level_p((uint8_t)fval);
                  }
                }
                else if(uds_cmd_byte==0x03 && rx.data[2]!=0xFF)
                {
                  if(rx.data[2]&(1<<4)) System.signal_state.washer_liquid=1;
                  else                  System.signal_state.washer_liquid=0;

                  if(rx.data[2]&(1<<3)) System.can_state.cont_flags.battery=1;
                  else                  System.can_state.cont_flags.battery=0;

                  if(rx.data[2]&(1<<2)) System.can_state.cont_flags.chek_oil=1;
                  else                  System.can_state.cont_flags.chek_oil=0;
                }

                uds_cmd_byte=0xFF;
              }
              else
              {
                uds_cmd_byte=0xFF;
              }
            }
            else if(rx.id==0x7E8)
            {
              //не работает, нужно слать в ODB
              //OBDII ответ
              if(rx.data[0]==0x03 &&  rx.data[1]==0x41 && rx.data[2]==0x05)
              {
                //System.Grab(portMAX_DELAY);
                //{
                //  System.can_state.numeric_data.eng_temp=rx.data[3]-40.0f;
                //}System.Release();
              }
            }
          }//if(rx.id_type==STD_ID_TYPE)
        }
        else if(can_id==CAN3_ID)
        {
          //none
        }
    }

    if(mess_count)
    {
      restart_sleep_and_rx_timers(can_id);
    }
  }

  System.can_state.sec_flags.can_in_sleep=can_sleep_indicate_handler();

  blocks_handler();

  taxi_blocks_handler();
}

static void can_rx_audi_a3_2018_handler(void)
{
  can_rx_frame_t rx;

  for(uint8_t can_id=CAN1_ID; can_id<HW_CAN_COUNT; can_id++)
  {
    uint16_t mess_count=filled_count_in_sfifo(&can_rx_sfifo[can_id]);

    for(uint16_t j=0; j<mess_count; j++)
    {
      if(!read_from_sfifo(&can_rx_sfifo[can_id], &rx))
      {
        __PRINTF("%s_RX sfifo is full, drop counter: %lu\n", get_name_from_can_id(can_id), can_rx_sfifo[can_id].drop_counter);
      }

#if defined(CAN_VEGA_FWD_PRESENT)
      rx_fwd_hadler(can_id, &rx);
#endif //defined(CAN_VEGA_FWD_PRESENT)

#if defined(YANDEX_OBD_PRESENT)
      obd_rx_handler(can_id, &rx);
#endif //defined(YANDEX_OBD_PRESENT)

      can_rx_debug_trace(&rx, can_id);

        if(can_id==CAN1_ID)
        {
          //Салонная шина 500 кбит\с
          if(rx.id_type==STD_ID_TYPE)
          {
            if(rx.id==0x107)
            {
              //тахометр
              System.Grab(portMAX_DELAY);
              {
                //00 00 FE E9 80 11 23 E8       750
                //00 00 FE 3F 81 0E FB FA       1000
                //00 00 FE F5 01 0D C8 EE       1550
                //00 00 FE 88 02 0C BF CB       2000
                //00 00 FE D9 03 0D AB AC       3000
                System.can_state.numeric_data.eng_rpm=((((0x0F&rx.data[4])<<8)|(rx.data[3]<<0))*100UL)/32UL;

                if(System.can_state.numeric_data.eng_rpm>350) System.can_state.sec_flags.engine_is_on=1;
                else                                          System.can_state.sec_flags.engine_is_on=0;
              }System.Release();

              if (can_program == SKODA_RAPID_2018_PROGRAM) {
                // Uses for check engine is on
                restart_can_timer(AUX_CAN_TIMER_1, 2000);
              }
            }
            else if(rx.id==0x30B && (can_program==SKODA_OCTAVIA_2018_PROGRAM || can_program==SKODA_RAPID_2018_PROGRAM))
            {
              /*
              Рапид
              030B 10 2x 01 00 08 00 00 10 заглушен или заведен и опущен
              030B 10 2x 81 00 08 00 00 10 заведен поднят
              */

              //ручник Skoda Octavia
              if(rx.data[2]!=0xFF)
              {
                if(rx.data[2]&(1<<7))     System.can_state.sec_flags.hand_break=1;
                else                      System.can_state.sec_flags.hand_break=0;
              }
            }
            else if (rx.id==0x3DA && (can_program==SKODA_OCTAVIA_2018_PROGRAM || can_program==SKODA_RAPID_2018_PROGRAM))
            {
              uint16_t angle = (rx.data[6] << 8) | rx.data[5];
              System.can_state.numeric_data.battery_charge_level = angle * 0.125f;
            }
            else if (rx.id==0x3EB && (can_program==SKODA_OCTAVIA_2018_PROGRAM || can_program==SKODA_RAPID_2018_PROGRAM))
            {
              //steering acceleration
              System.can_state.numeric_data.thresher_rpm = rx.data[1];
            }
            else if(can_program==AUDI_A3_2018_PROGRAM && rx.id==0x30D)
            {
              //ручник Audi A3
              if(rx.data[0]!=0xFF)
              {
                System.Grab(portMAX_DELAY);
                {
                  if((rx.data[0]&0x0f)==0x04)     System.can_state.sec_flags.hand_break=1;
                  else                            System.can_state.sec_flags.hand_break=0;
                }System.Release();
              }
            }
            else if(can_program==SKODA_OCTAVIA_2018_PROGRAM && rx.id==0x31B)
            {
              //скорость берем из другого 0x0FD
              if(rx.data[6]!=0xFF)
              {
                if(rx.data[6]==0x80) System.can_state.cont_flags.abs=1;
                else                 System.can_state.cont_flags.abs=0;
              }
            }
            else if(rx.id==0x0FD)
            {
              uint16_t val=((rx.data[5]<<8)|(rx.data[4]<<0));

              //скорость
              if(val!=0xFFFF)
              {
                val=val/100;

                System.can_state.numeric_data.can_speed=val;
              }
            }
            else if(rx.id==0x394)
            {
              if(rx.data[1]!=0xFF)
              {
                System.Grab(portMAX_DELAY);
                {
                  if((rx.data[1]&0xf0)==0x10)          {System.can_state.sec_flags.parking=1; System.can_state.sec_flags.reverse_gear=0;}
                  else if((rx.data[1]&0xf0)==0x20)     {System.can_state.sec_flags.parking=0; System.can_state.sec_flags.reverse_gear=1;}
                  else                                 {System.can_state.sec_flags.parking=0; System.can_state.sec_flags.reverse_gear=0;}

                  if      ((rx.data[1]&0xf0)==0x10) System.signal_state.selector_position='P';
                  else if ((rx.data[1]&0xf0)==0x20) System.signal_state.selector_position='R';
                  else if ((rx.data[1]&0xf0)==0x30) System.signal_state.selector_position='N';
                  else if ((rx.data[1]&0xf0)==0x40) System.signal_state.selector_position='D';
                  else if ((rx.data[1]&0xf0)==0x50) System.signal_state.selector_position='S';
                  else if ((rx.data[1]&0xf0)==0x60) System.signal_state.selector_position='M';

                }System.Release();
              }
            }
            else if(rx.id==0x3C0)
            {
              if(rx.data[2]!=0xFF)
              {
                System.Grab(portMAX_DELAY);
                {
                  if(rx.data[2]==0x01 || rx.data[2]==0x03/* || rx.data[2]==0x07 || rx.data[2]==0x0B*/)  System.can_state.sec_flags.key_in_ign=1;
                  else                                                                                  System.can_state.sec_flags.key_in_ign=0;

                  if(rx.data[2]==0x03)                                                                  System.can_state.sec_flags.ignition=1;
                  else                                                                                  System.can_state.sec_flags.ignition=0;

                }System.Release();
              }
            }
            else if(rx.id==0x3C7)
            {
              //перегрев ОЖ CHECK  EPC
              if(rx.data[6]&(1<<1))                    System.can_state.cont_flags.check_engine=1;
              else                                     System.can_state.cont_flags.check_engine=0;

              if(rx.data[6]&(1<<3)|| rx.data[1]>0)     System.can_state.cont_flags.chek_coolant=1;
              else                                     System.can_state.cont_flags.chek_coolant=0;

              if(rx.data[7]>0 || (rx.data[2]&0xf0)>0)  System.can_state.cont_flags.chek_oil=1;
              else                                     System.can_state.cont_flags.chek_oil=0;
            }
            else if(rx.id==0x520)
            {
              if(can_program==AUDI_A3_2018_PROGRAM)
              {
                if(rx.data[5]!=0xFF)
                {
                  if(rx.data[5]&(1<<0))  System.can_state.cont_flags.driver_safety_belt=1;
                  else                   System.can_state.cont_flags.driver_safety_belt=0;

                  if(rx.data[5]&(1<<2))  System.can_state.cont_flags.passenger_safety_belt=1;
                  else                   System.can_state.cont_flags.passenger_safety_belt=0;
                }
              }
              else
              {
                //хз, не проверяли
                if(rx.data[5]!=0xFF)
                {
                  if(rx.data[5]==0x03)  System.can_state.cont_flags.driver_safety_belt=1;
                  else                  System.can_state.cont_flags.driver_safety_belt=0;

                  //if(rx.data[5]&(1<<2))  System.can_state.cont_flags.passenger_safety_belt=1;
                  //else                   System.can_state.cont_flags.passenger_safety_belt=0;
                }
              }
            }
            else if(rx.id==0x583)
            {
              /*
              Снято с Rapid
              Все двери закрыты цз открыт с салона кнопокой
              00000583 8 00 00 80 00 00 00 40 00
              Все двери закрыты цз закрыт
              00000583 8 00 00 05 00 00 00 54 00
              Все закрыты цз открыт ручкой двери
              00000583 8 00 00 04 00 00 00 54 00
              Багажник открыт, цз открыт
              00000583 8 00 00 80 10 01 00 40 00
              Багажник открыт, цз закрыт
              00000583 8 00 00 05 10 01 00 54 00

              цз открыт
              00000583 8 00 00 04 00 00 00 54 00
              подаем импульс
              00000583 8 00 00 05 00 00 00 54 00

              закрыли с ключа
              00000583 8 00 00 0A 00 00 00 54 00

              открыли с ключа
              00000583 8 00 00 80 00 00 00 40 00

              Открываем кнопкой на ключе с багажника
              00000583 8 00 00 84 00 04 00 54 00
              00000583 8 00 00 84 10 01 00 54 00
              */

              if(rx.data[2]!=0xFF || rx.data[3]!=0xFF)
              {
                System.Grab(portMAX_DELAY);
                {
                  System.can_state.numeric_data.bef_srvc_odo=(rx.data[0]<<24)|(rx.data[1]<<16)|(rx.data[2]<<8)|(rx.data[3]<<0);
                  System.can_state.numeric_data.ex_srvc_odo=(rx.data[4]<<24)|(rx.data[5]<<16)|(rx.data[6]<<8)|(rx.data[7]<<0);

                  if(rx.data[2]!=0xFF)
                  {
                    if((rx.data[2]&0x0f)==0x05 || (rx.data[2]&0x0f)==0x0A) _cls_state=LOCKED_CLS_STATE;
                    else                                                   _cls_state=UNLOCKED_CLS_STATE;

                    if(_cls_state==LOCKED_CLS_STATE)
                    {
                      System.signal_state.cls_state.driver_door=0; System.signal_state.cls_state.l_rear_door=0; System.signal_state.cls_state.r_rear_door=0; System.signal_state.cls_state.pass_door=0;
                    }
                    else
                    {
                      System.signal_state.cls_state.driver_door=1; System.signal_state.cls_state.l_rear_door=1; System.signal_state.cls_state.r_rear_door=1; System.signal_state.cls_state.pass_door=1;
                    }

                    System.signal_state.cls_state.driver_door_prepared=1;
                    System.signal_state.cls_state.l_rear_door_prepared=1;
                    System.signal_state.cls_state.r_rear_door_prepared=1;
                    System.signal_state.cls_state.pass_door_prepared=1;
                  }

                  if(rx.data[3]!=0xFF)
                  {
                    if(rx.data[3]&(1<<0))  System.can_state.sec_flags.driver_door=1;
                    else                   System.can_state.sec_flags.driver_door=0;

                    if(rx.data[3]&(1<<1))  System.can_state.sec_flags.pass_door=1;
                    else                   System.can_state.sec_flags.pass_door=0;

                    if(rx.data[3]&(1<<2))  System.can_state.sec_flags.l_rear_door=1;
                    else                   System.can_state.sec_flags.l_rear_door=0;

                    if(rx.data[3]&(1<<3))  System.can_state.sec_flags.r_rear_door=1;
                    else                   System.can_state.sec_flags.r_rear_door=0;

                    if(rx.data[3]&(1<<4))  System.can_state.sec_flags.trunk=1;
                    else                   System.can_state.sec_flags.trunk=0;
                  }
                }System.Release();
              }
            }
            else if(rx.id==0x5F9)
            {
              //TMPS
              if(rx.data[1]!=0xFF)
              {
                if(rx.data[1]&(1<<4))  System.can_state.cont_flags.inflation_pressure=1;
                else                   System.can_state.cont_flags.inflation_pressure=0;
              }
            }
            else if(rx.id==0x658)
            {
              if(rx.data[1]&(1<<4))  System.can_state.cont_flags.marker_lights=1;
              else                   System.can_state.cont_flags.marker_lights=0;

              if(rx.data[1]&(1<<5))  System.can_state.cont_flags.dipped_beam=1;
              else                   System.can_state.cont_flags.dipped_beam=0;

              if(rx.data[1]&(1<<6))  System.can_state.cont_flags.high_beam=1;
              else                   System.can_state.cont_flags.high_beam=0;
            }
            else if(rx.id==0x65A)
            {
              if(rx.data[1]!=0xFF)
              {
                if((rx.data[1]&0xF0)==0x80) System.signal_state.washer_liquid=1;
                else                        System.signal_state.washer_liquid=0;
              }

              if(can_program!=SKODA_RAPID_2018_PROGRAM)
              {
                if(rx.data[3]!=0xFF)
                {
                  if(rx.data[3]&(1<<7)) System.can_state.sec_flags.hood=1;
                  else                  System.can_state.sec_flags.hood=0;
                }

                if(rx.data[1]>0)        System.can_state.cont_flags.chek_brake_pads=1;
                else                    System.can_state.cont_flags.chek_brake_pads=0;
              }
            }
            ///*
            else if(rx.id==0x3BE)
            {
              //не проверяли
              if(can_program==SKODA_RAPID_2018_PROGRAM && can_bus_type[can_id]!=MOTOR_CAN_BUS_TYPE)
              {
                if(rx.data[3]!=0xFF)
                {
                  //педаль тормоза
                  if(rx.data[3]==0x50)  System.can_state.sec_flags.pedal_break=1;
                  else                  System.can_state.sec_flags.pedal_break=0;
                }
              }
            }
            else if(rx.id==0x366)
            {
              //не проверяли
              //Octavia +
              if(rx.data[2]!=0xFF)
              {
                if((rx.data[2]&0xF0)==0x10) System.signal_state.emergency_lights=1;
                else                        System.signal_state.emergency_lights=0;
              }
            }
            //положение окон, D[2] - кнопки, D[3] - степень открытия (Octavia откр 0xBF- закр 0x00), D[4] - статус
            //D[4] 8C полностью закрыто, у водительнского иногда остается в 84
            //D[0] - 02 - ЦЗ закрыт (только для передних дверей), тут же возможно концевики. Для Octavia берем из 0x583.
            else if(rx.id==0x3D0)
            {
              if(rx.data[3]!=0xFF)
              {
                if(rx.data[3]<=0x04) System.signal_state.windows_position.driver_door=0;
                else                 System.signal_state.windows_position.driver_door=1;

                System.signal_state.windows_position.driver_door_prepared=1;
              }
            }
            else if(rx.id==0x3D1)
            {
              if(rx.data[3]!=0xFF)
              {
                if(rx.data[3]<=0x04) System.signal_state.windows_position.pass_door=0;
                else                 System.signal_state.windows_position.pass_door=1;

                System.signal_state.windows_position.pass_door_prepared=1;
              }
            }
            else if(rx.id==0x3CF)
            {
              //задних стелоподьемники могут быть на "вёслах", тогда этого ID нет
              if(rx.data[3]!=0xFF)
              {
                if(rx.data[3]<=0x04) System.signal_state.windows_position.r_rear_door=0;
                else                 System.signal_state.windows_position.r_rear_door=1;

                System.signal_state.windows_position.r_rear_door_prepared=1;
              }
            }
            else if(rx.id==0x3CE)
            {
              //задних стелоподьемники могут быть на "вёслах", тогда этого ID нет
              if(rx.data[3]!=0xFF)
              {
                if(rx.data[3]<=0x04) System.signal_state.windows_position.l_rear_door=0;
                else                 System.signal_state.windows_position.l_rear_door=1;

                System.signal_state.windows_position.l_rear_door_prepared=1;
              }
            }
            else if(rx.id==0x040)
            {
              if(can_program==SKODA_OCTAVIA_2018_PROGRAM)//для других не проверяли
              {
                if(rx.data[3]!=0xFF)
                {
                  if(rx.data[3]&(1<<0)) System.can_state.cont_flags.airbag=1;
                  else                  System.can_state.cont_flags.airbag=0;
                }
              }
            }
            //*/
          }//if(rx.id_type==STD_ID_TYPE)
        }
        else if(can_id==CAN2_ID)
        {
          //Моторная шина 500 кбит\с
          if(rx.id_type==STD_ID_TYPE)
          {
            if(rx.id==0x106)
            {
              if(rx.data[3]!=0xFF)
              {
                //педаль тормоза
                if(rx.data[3]==0x04 || rx.data[3]==0x05)  System.can_state.sec_flags.pedal_break=1;
                else                                      System.can_state.sec_flags.pedal_break=0;
              }

              if(rx.data[2]!=0xFF)
              {
                //педаль тормоза
                if(rx.data[2]<=0x64)      System.can_state.numeric_data.brake=0;//temporary
                else if(rx.data[2]>=0xAF) System.can_state.numeric_data.brake=100;//temporary
                else                      System.can_state.numeric_data.brake=((rx.data[2]-0x64)*100Ul)/(0xAF-0x64);//temporary
              }
            }
            else if(rx.id==0x121)
            {
              //педаль газа
              System.can_state.numeric_data.accelerator=((rx.data[2]&0x0F)*100UL)/(0x0FUL);
            }
            else if(rx.id==0x086)
            {
              //rx.data[4] - похоже на усилие
              /*
              00000086 8 HEX        1F       0E       F8       11       00       00       00       00  крайнее лев
              00000086 8 HEX        DA       0F       6D       0B       00       00       00       00
              00000086 8 HEX        92       0E       FA       01       00       00       00       00
              00000086 8 HEX        D9       0A       27       20       00       00       00       00  середина
              00000086 8 HEX        F1       01       D9       21       00       00       00       00
              00000086 8 HEX        7C       05       7A       23       00       00       00       00
              00000086 8 HEX        09       07       19       32       00       00       00       00  крайнее прав
              */

              int32_t val=((rx.data[3]&0x1F)<<8)|((rx.data[2])<<0); //5+8бит данных

              val=(val*100)/4633; ////4633-max

              if(!(rx.data[3]&(1<<5))) val=-1*val; //5й бит положение руля

              System.Grab(portMAX_DELAY);
              {
                System.can_state.numeric_data.battery_charge_level=val;//temporary
              }System.Release();
            }
            else if(rx.id==0x6B2)
            {
              //если пришел этот id,  считаем что подключенны к моторной шине
              can_bus_type[can_id]=MOTOR_CAN_BUS_TYPE;

              //проверить на пробеге больше 255 и 65535!
              uint32_t val=((rx.data[3]&0x0f)<<16)|(rx.data[2]<<8)|(rx.data[1]<<0);
              if(!(val==0x0fffff || val==0x0ffffe))
              {
                System.Grab(portMAX_DELAY);
                {
                  System.can_state.numeric_data.can_odo_km=val;
                }System.Release();
              }
            }
            else if(rx.id==0x7E8)
            {
              //OBDII ответ
              if(rx.data[0]==0x03 && rx.data[1]==0x41 && rx.data[2]==0x2F)
              {
                uint8_t val;

                if(can_program==SKODA_OCTAVIA_2018_PROGRAM)
                {
                  val=(rx.data[3]*100Ul)/217Ul;
                }
                //прошивка для Rapid и Polo 2020 одна, отличается уровень топлива
                //Polo 2020 XW8ZZZCKZLG013591, XW8ZZZCKZMG000358
                else if(can_program==SKODA_RAPID_2018_PROGRAM && memcmp("XW8ZZZCKZ", System.signal_state.vin_sensor, sizeof("XW8ZZZCKZ")-1)==0)
                {
                  val=(rx.data[3]*100Ul)/227Ul;
                }
                //Rapid XW8AC2NH2KK106483, XW8AC2NH7LK110000
                else if(can_program==SKODA_RAPID_2018_PROGRAM)
                {
                  val=(rx.data[3]*100Ul)/241Ul;
                }
                else //if(can_program==AUDI_A3_2018_PROGRAM)
                {
                  val=(rx.data[3]*100Ul)/255Ul;
                }

                if(val>100) val=100;

                System.set_fuel_level_p(val);
              }
              else if(rx.data[0]==0x03 &&  rx.data[1]==0x41 && rx.data[2]==0x05)
              {
                System.Grab(portMAX_DELAY);
                {
                  System.can_state.numeric_data.eng_temp=rx.data[3]-40.0f;
                }System.Release();
              }
              ///*
              else if(rx.data[0]==0x07 && rx.data[1]==0x62 && rx.data[2]==0x10 && rx.data[3]==0xE0)
              {
                if(can_program==SKODA_RAPID_2018_PROGRAM && can_bus_type[can_id]!=MOTOR_CAN_BUS_TYPE)
                {
                  //пробег есть и в шине 1, 46359 км
                  //6B7 17 B X0 ...
                  //6B2 XX 17 B5 X0 ...
                  uint32_t val=(rx.data[4]<<24)|(rx.data[5]<<16)|(rx.data[6]<<8)|(rx.data[7]<<0);
                  if(val!=0xFFFFFFFF && val!=0xFFFFFFFE)
                  {
                    System.Grab(portMAX_DELAY);
                    {
                      System.can_state.numeric_data.can_odo_km=val;
                    }System.Release();
                  }
                }
              }
              //*/
              /*
              else if(rx.data[0]==0x05 &&  rx.data[1]==0x62 && rx.data[2]==0x14 && rx.data[3]==0xB4)
              {
                //пока не работает
                System.Grab(portMAX_DELAY);
                {
                  System.can_state.numeric_data.fuel_lev_l=((rx.data[4]<<8)|(rx.data[5]<<0))/100UL;
                }System.Release();
              }
              */
            }

            if(can_program==SKODA_RAPID_2018_PROGRAM && can_bus_type[can_id]!=MOTOR_CAN_BUS_TYPE)
            {
              //System.can_state.cont_flags.warning=1;
            }

          }//if(rx.id_type==STD_ID_TYPE)
        }
        else if(can_id==CAN3_ID)
        {
          //none
        }
    }

    if(mess_count)
    {
      restart_sleep_and_rx_timers(can_id);
    }
  }

  System.can_state.sec_flags.can_in_sleep=can_sleep_indicate_handler();

  blocks_handler();

  audi_a3_octavia_rapid_analog_to_can_handler();

  taxi_blocks_handler();
}

static void can_rx_audi_q3_2018_handler(void)
{
  can_rx_frame_t rx;

  for(uint8_t can_id=CAN1_ID; can_id<HW_CAN_COUNT; can_id++)
  {
    uint16_t mess_count=filled_count_in_sfifo(&can_rx_sfifo[can_id]);

    for(uint16_t j=0; j<mess_count; j++)
    {
      if(!read_from_sfifo(&can_rx_sfifo[can_id], &rx))
      {
        __PRINTF("%s_RX sfifo is full, drop counter: %lu\n", get_name_from_can_id(can_id), can_rx_sfifo[can_id].drop_counter);
      }

#if defined(CAN_VEGA_FWD_PRESENT)
      rx_fwd_hadler(can_id, &rx);
#endif //defined(CAN_VEGA_FWD_PRESENT)

#if defined(YANDEX_OBD_PRESENT)
      obd_rx_handler(can_id, &rx);
#endif //defined(YANDEX_OBD_PRESENT)

      can_rx_debug_trace(&rx, can_id);

        if(can_id==CAN1_ID)
        {
          //Салонная шина 100 кбит\с
          if(rx.id_type==STD_ID_TYPE)
          {
            if(rx.id==0x470)
            {
              if(rx.data[1]!=0xFF)
              {
                System.Grab(portMAX_DELAY);
                {
                  if(rx.data[1]&(1<<0))  System.can_state.sec_flags.driver_door=1;
                  else                   System.can_state.sec_flags.driver_door=0;

                  if(rx.data[1]&(1<<1))  System.can_state.sec_flags.pass_door=1;
                  else                   System.can_state.sec_flags.pass_door=0;

                  if(rx.data[1]&(1<<2))  System.can_state.sec_flags.l_rear_door=1;
                  else                   System.can_state.sec_flags.l_rear_door=0;

                  if(rx.data[1]&(1<<3))  System.can_state.sec_flags.r_rear_door=1;
                  else                   System.can_state.sec_flags.r_rear_door=0;

                  if(rx.data[1]&(1<<4))  System.can_state.sec_flags.hood=1;
                  else                   System.can_state.sec_flags.hood=0;

                  if(rx.data[1]&(1<<5))  System.can_state.sec_flags.trunk=1;
                  else                   System.can_state.sec_flags.trunk=0;
                }System.Release();
              }

              if(can_program==VW_TRANSPORTER_2018_PROGRAM)
              {
                if(rx.data[0]!=0xFF)
                {
                  if((rx.data[0]&0x0F)==0x08)
                  {
                    System.signal_state.emergency_lights=1;
                    restart_can_timer(EMERG_LIGHT_FIX_TIMER, 2500);
                  }
                }
              }
              else
              {
                //Q3, Polo
                if(rx.data[0]!=0xFF)
                {
                  if((rx.data[0]&0x0F)==0x08) System.signal_state.emergency_lights=1;
                  else                        System.signal_state.emergency_lights=0;
                }
              }
            }
            else if(rx.id==0x531)
            {
              System.can_state.numeric_data.can_axle_5=rx.data[0];
              //c фарами ничего не понятно
              System.Grab(portMAX_DELAY);
              {
                if(can_program==AUDI_Q3_2018_PROGRAM)
                {
                  if(rx.data[0]==0xC1)  System.can_state.cont_flags.marker_lights=1;
                  else                  System.can_state.cont_flags.marker_lights=0;

                  if(rx.data[0]==0xC3)  System.can_state.cont_flags.dipped_beam=1;
                  else                  System.can_state.cont_flags.dipped_beam=0;

                  if(rx.data[0]==0xC7)  System.can_state.cont_flags.high_beam=1;
                  else                  System.can_state.cont_flags.high_beam=0;
                }
                else //can_program==VW_POLO_2018_PROGRAM || can_program==VW_CADDY_2018_PROGRAM || can_program==VW_TRANSPORTER_2018_PROGRAM || can_program==SKODA_RAPID_2013_PROGRAM
                {
                  if(rx.data[0]==0x01)  System.can_state.cont_flags.marker_lights=1;
                  else                  System.can_state.cont_flags.marker_lights=0;

                  if(rx.data[0]==0x03)  System.can_state.cont_flags.dipped_beam=1;
                  else                  System.can_state.cont_flags.dipped_beam=0;

                  if(rx.data[0]==0x04 || rx.data[0]==0x07) System.can_state.cont_flags.high_beam=1;
                  else                                     System.can_state.cont_flags.high_beam=0;
                }
              }System.Release();
            }
            else if(rx.id==0x575)
            {
              if(can_program==VW_TRANSPORTER_2018_PROGRAM)
              {
                //скорее всего на других машинах так-же, нужно проверять
                if(rx.data[3]!=0xFF)
                {
                  if(rx.data[3]&(1<<7)) System.can_state.sec_flags.ignition=1;
                  else                  System.can_state.sec_flags.ignition=0;
                }
              }
              else if(can_program==VW_POLO_2018_PROGRAM || can_program==SKODA_RAPID_2013_PROGRAM)
              {
                if(rx.data[0]!=0xFF)
                {
                  //01-выкл, 87-вкл, 07-заведена
                  if(rx.data[0]&(1<<7)) System.can_state.sec_flags.ignition=1;
                  else                  System.can_state.sec_flags.ignition=0;
                }
              }
              else
              {
                if(rx.data[3]!=0xFF)
                {
                  if(rx.data[3]==0xA0) System.can_state.sec_flags.ignition=1;
                  else                 System.can_state.sec_flags.ignition=0;
                }
              }
            }
            else if(rx.id==0x151)
            {
              if(can_program==VW_TRANSPORTER_2018_PROGRAM)
              {
                //скорее всего на других машинах так-же, нужно проверять
                if(rx.data[1]!=0xFF)
                {
                  if(rx.data[1]&(1<<4)) System.can_state.cont_flags.driver_safety_belt=1;
                  else                  System.can_state.cont_flags.driver_safety_belt=0;
                }
              }
            }
            else if(rx.id==0x3B5)
            {
              if(can_program==VW_TRANSPORTER_2018_PROGRAM)
              {
                //скорее всего не правильно
                if(rx.data[0]!=0xFF)
                {
                  if(rx.data[0]==0x02) _cls_state=LOCKED_CLS_STATE;
                  else                 _cls_state=UNLOCKED_CLS_STATE;
                }
              }
            }
            else if(rx.id==0x621)
            {
              //Transporter+, Q3+, Polo+
              //скорее всего на других машинах так-же, нужно проверять
              if(rx.data[0]!=0xFF)
              {
                if((rx.data[0]&0x0F)==0x00) System.signal_state.washer_liquid=0; //X0
                else                        System.signal_state.washer_liquid=1; //X4
              }
            }
            else if(rx.id==0x400)
            {
              /*
              //берем из 470
              if(can_program==VW_TRANSPORTER_2018_PROGRAM)
              {
                //скорее всего на других машинах так-же, нужно проверять
                if(rx.data[0]!=0xFF)
                {
                  if((rx.data[0]&0xF0)==0x00) System.signal_state.emergency_lights=0;
                  else                        System.signal_state.emergency_lights=1;
                }
              }
              */
            }
            else if(rx.id==0x629)
            {
              //проверяли только на VW_TRANSPORTER_2018_PROGRAM
              if(can_program==VW_TRANSPORTER_2018_PROGRAM)
              {
                uint16_t val=0x0FFF&((rx.data[3]<<8)|(rx.data[2]<<0));

                if(val<0x0FFE)
                {
                  System.Grab(portMAX_DELAY);
                  System.can_state.numeric_data.fuel_lev_l=val;
                  System.Release();
                }
              }

            }
          }//if(rx.id_type==STD_ID_TYPE)
        }
        else if(can_id==CAN2_ID)
        {
          //Моторная шина 500 кбит\с
          if(rx.id_type==STD_ID_TYPE)
          {
            if(rx.id==0x0C2)
            {
              //угол поворота рулевого колеса
              System.Grab(portMAX_DELAY);
              {
              }System.Release();
            }
            else if (rx.id==0x0D0 && (can_program == VW_POLO_2018_PROGRAM))
            {
              System.Grab(portMAX_DELAY);
              {
                uint16_t raw = (rx.data[3] << 8) | rx.data[4];
                raw &= 0xFFF;

                float angle = raw * 0.15f;

                // check if left bit not set for steering wheels
                if (!((rx.data[5] >> 4) & 0x01)) {
                  angle *= -1.0f;
                }

                System.can_state.numeric_data.battery_charge_level = angle;
              }
              System.Release();
            }
            else if (rx.id==0x3D0 && (can_program == VW_POLO_2018_PROGRAM))
            {
              // steering acceleration
              System.can_state.numeric_data.thresher_rpm = rx.data[0];
            }
            else if(rx.id==0x280)
            {
              //педаль газа
              System.Grab(portMAX_DELAY);
              {
                //педаль газа
                if(rx.data[5]!=0xFF)
                {
                  System.can_state.numeric_data.accelerator=((rx.data[5])*100UL)/(0xFAUL);
                }

                if(can_program==VW_TRANSPORTER_2018_PROGRAM || can_program==SKODA_RAPID_2013_PROGRAM)
                {
                  if(System.can_state.sec_flags.engine_is_on)
                  {
                    if(rx.data[3]!=0xFF)
                    {
                      System.can_state.numeric_data.eng_rpm=((rx.data[3])*1000UL)/16UL;
                    }
                  }
                  else
                  {
                    System.can_state.numeric_data.eng_rpm=0;
                  }
                }
                else
                {
                  //у Trasporter не обнуляются обороты на заглушенной машине, (как и в оборотах из 0x48A)
                  if(rx.data[3]!=0xFF)
                  {
                    System.can_state.numeric_data.eng_rpm=((rx.data[3])*1000UL)/16UL;

                    if(System.can_state.numeric_data.eng_rpm>350) System.can_state.sec_flags.engine_is_on=1;
                    else                                          System.can_state.sec_flags.engine_is_on=0;
                  }
                }
              }System.Release();
            }
            else if(rx.id==0x288)
            {
              if(rx.data[2]!=0xFF)
              {
                if(rx.data[2]&(1<<0)) System.can_state.sec_flags.pedal_break=1;
                else                  System.can_state.sec_flags.pedal_break=0;
              }
            }
            else if(rx.id==0x320)
            {
              if(rx.data[1]!=0xFF)
              {
                if(rx.data[1]&(1<<1)) System.can_state.sec_flags.hand_break=1;
                else                  System.can_state.sec_flags.hand_break=0;
              }

              if(can_program==AUDI_Q3_2018_PROGRAM || can_program==VW_TRANSPORTER_2018_PROGRAM
                 || can_program==VW_POLO_2018_PROGRAM || can_program==SKODA_RAPID_2013_PROGRAM) //на Polo, Rapid 2013 не проверяли
              {
                //уровень появляется вместе с зажиганием
                //старший бит, похоже на лампу низкого уровня топлива

                if(rx.data[2]!=0xFF && rx.data[2]!=0x00)
                {
                  uint8_t val=0x7F&(rx.data[2]);

                  if(can_program==AUDI_Q3_2018_PROGRAM)
                  {
                    val=(val*100Ul)/64Ul;
                    if(val>100) val=100;

                    System.set_fuel_level_p(val);
                  }
                  else if(can_program==VW_TRANSPORTER_2018_PROGRAM)
                  {
                    val=(val*100Ul)/80Ul;
                    if(val>100) val=100;

                    System.set_fuel_level_p(val);
                  }
                  else if(can_program==VW_POLO_2018_PROGRAM || can_program==SKODA_RAPID_2013_PROGRAM)
                  {
                    //old bad code val=(val*100Ul)/55Ul;
                    const unsigned long empty = 5; // in normal case - 0
                    const unsigned long full = 53; // in nornal case - 55
                    val = ((val-empty) * 100UL)/(full - empty);
                    if(val>100) val=100;

                    System.set_fuel_level_p(val);
                  }
                  else
                  {
                    System.set_fuel_level_p(INVALID_FUEL_LEVEL_PERCENT);
                  }

                  //System.Grab(portMAX_DELAY);
                  //{
                  //System.can_state.numeric_data.fuel_lev_l=val;
                  //}System.Release();
                }
              }
            }
            else if(rx.id==0x443)
            {
              //TMPS
              if(rx.data[0]!=0xFF)
              {
                if(rx.data[0]&(1<<2))  System.can_state.cont_flags.inflation_pressure=1;
                else                   System.can_state.cont_flags.inflation_pressure=0;
              }
            }
            else if(can_program==AUDI_Q3_2018_PROGRAM && rx.id==0x448)
            {
              if(rx.data[4]!=0xFF)
              {
                System.Grab(portMAX_DELAY);
                {
                  if((rx.data[4]&0xf0)==0x70)          {System.can_state.sec_flags.parking=1; System.can_state.sec_flags.reverse_gear=0;}
                  else if((rx.data[4]&0xf0)==0x80)     {System.can_state.sec_flags.parking=0; System.can_state.sec_flags.reverse_gear=1;}
                  else                                 {System.can_state.sec_flags.parking=0; System.can_state.sec_flags.reverse_gear=0;}

                  if      ((rx.data[4]&0xf0)==0x70) System.signal_state.selector_position='P';
                  else if ((rx.data[4]&0xf0)==0x80) System.signal_state.selector_position='R';
                  else if ((rx.data[4]&0xf0)==0x90) System.signal_state.selector_position='N';
                  else if ((rx.data[4]&0xf0)==0xA0) System.signal_state.selector_position='D';
                  else if ((rx.data[4]&0xf0)==0x30) System.signal_state.selector_position='S';
                  else if ((rx.data[4]&0xf0)==0x10) System.signal_state.selector_position='M';

                }System.Release();
              }
            }
            else if((can_program==VW_POLO_2018_PROGRAM || can_program==VW_CADDY_2018_PROGRAM || can_program==VW_TRANSPORTER_2018_PROGRAM || can_program==SKODA_RAPID_2013_PROGRAM) && rx.id==0x440)
            {
              if(rx.data[1]!=0xFF)
              {
                System.Grab(portMAX_DELAY);
                {
                  if((rx.data[1]&0xf0)==0x80)          {System.can_state.sec_flags.parking=1; System.can_state.sec_flags.reverse_gear=0;}
                  else if((rx.data[1]&0xf0)==0x70)     {System.can_state.sec_flags.parking=0; System.can_state.sec_flags.reverse_gear=1;}
                  else                                 {System.can_state.sec_flags.parking=0; System.can_state.sec_flags.reverse_gear=0;}

                  if      ((rx.data[1]&0xf0)==0x80) System.signal_state.selector_position='P';
                  else if ((rx.data[1]&0xf0)==0x70) System.signal_state.selector_position='R';
                  else if ((rx.data[1]&0xf0)==0x60) System.signal_state.selector_position='N';
                  else if ((rx.data[1]&0xf0)==0x50) System.signal_state.selector_position='D';
                  else if ((rx.data[1]&0xf0)==0xC0) System.signal_state.selector_position='S';
                  else if ((rx.data[1]&0xf0)==0xE0) System.signal_state.selector_position='M';

                }System.Release();
              }
            }
            else if(rx.id==0x480)
            {
              //перегрев ОЖ CHECK EPC
              System.Grab(portMAX_DELAY);
              {
                if((rx.data[1]&(1<<3)) || (rx.data[1]&(1<<2)/*EPC*/)) System.can_state.cont_flags.check_engine=1;
                else                                                  System.can_state.cont_flags.check_engine=0;

                if((rx.data[1]&(1<<4)) || (rx.data[1]&(1<<5)))        System.can_state.cont_flags.chek_coolant=1;
                else                                                  System.can_state.cont_flags.chek_coolant=0;
              }System.Release();
            }
            else if(rx.id==0x48A)
            {
              if(rx.data[3]==0x06) System.can_state.cont_flags.chek_oil=1;
              else                 System.can_state.cont_flags.chek_oil=0;

              if(false && can_program==VW_TRANSPORTER_2018_PROGRAM)
              {
                //не обнуляются на заглушенной машине
                uint16_t val=(rx.data[2]<<8)|(rx.data[1]<<0);

                if(val!=0xFFFF)
                {
                  val=val*3UL;

                  System.Grab(portMAX_DELAY);
                  {
                    System.can_state.numeric_data.eng_rpm=val;

                    if(System.can_state.numeric_data.eng_rpm>350) System.can_state.sec_flags.engine_is_on=1;
                    else                                          System.can_state.sec_flags.engine_is_on=0;
                  }System.Release();
                }
              }
            }
            else if(rx.id==0x520)
            {
              uint32_t val=((rx.data[7]<<16)|(rx.data[6]<<8)|(rx.data[5]<<0));

              if(val!=0x00FFFFFF && val!=0x00FFFFFE)
              {
                System.Grab(portMAX_DELAY);
                {
                  System.can_state.numeric_data.can_odo_km=val;
                }System.Release();
              }
            }
            else if(rx.id==0x5A0)
            {
              //скорость
              System.Grab(portMAX_DELAY);
              {
                if(rx.data[2]!=0xFF)
                {
                  System.can_state.numeric_data.can_speed=2UL*rx.data[2];
                }

                if(rx.data[3]!=0xFF)
                {
                  if(rx.data[3]&(1<<2))     System.can_state.cont_flags.abs=1;
                  else                      System.can_state.cont_flags.abs=0;
                }
              }System.Release();
            }
            else if(rx.id==0x570)
            {
              if(can_program==VW_TRANSPORTER_2018_PROGRAM || can_program==SKODA_RAPID_2013_PROGRAM)
              {
                if(rx.data[0]!=0xFF)
                {
                  if(rx.data[0]&(1<<7)) System.can_state.sec_flags.engine_is_on=1;
                  else                  System.can_state.sec_flags.engine_is_on=0;

                  if(!System.can_state.sec_flags.engine_is_on && System.can_state.numeric_data.eng_rpm)
                  {
                    System.Grab(portMAX_DELAY);
                    {
                      System.can_state.numeric_data.eng_rpm=0;
                    }System.Release();
                  }
                }
              }
            }
            else if(rx.id==0x7E8)
            {
              //OBDII ответ
              //работает на старых Q3 и Polo, на новых нет (берем из 0x320)
              if((can_program==VW_POLO_2018_PROGRAM || can_program==VW_CADDY_2018_PROGRAM || can_program==SKODA_RAPID_2013_PROGRAM) && rx.data[0]==0x03 && rx.data[1]==0x41 && rx.data[2]==0x2F)
              {
                if (can_program == VW_POLO_2018_PROGRAM || can_program == SKODA_RAPID_2013_PROGRAM) {
                  //для сравнения с тем, что есть в потоке в 0x320
                  System.set_fuel_level_p((rx.data[3]*100Ul)/255Ul);
                } else {
                  System.set_fuel_level_p((rx.data[3]*100Ul)/255Ul);
                }
              }
              else if(rx.data[0]==0x03 && rx.data[1]==0x41 && rx.data[2]==0x05)
              {
                System.Grab(portMAX_DELAY);
                {
                  System.can_state.numeric_data.eng_temp=rx.data[3]-40.0f;
                }System.Release();
              }
            }
          }//if(rx.id_type==STD_ID_TYPE)
        }
        else if(can_id==CAN3_ID)
        {
          //none
        }
    }

    if(mess_count)
    {
      restart_sleep_and_rx_timers(can_id);
    }
  }

  System.can_state.sec_flags.can_in_sleep=can_sleep_indicate_handler();

  blocks_handler();

  audi_q3_analog_to_can_handler();

  taxi_blocks_handler();
}

static void can_rx_porsche_2018_handler(void)
{
  can_rx_frame_t rx;

  for(uint8_t can_id=CAN1_ID; can_id<HW_CAN_COUNT; can_id++)
  {
    uint16_t mess_count=filled_count_in_sfifo(&can_rx_sfifo[can_id]);

    for(uint16_t j=0; j<mess_count; j++)
    {
      if(!read_from_sfifo(&can_rx_sfifo[can_id], &rx))
      {
        __PRINTF("%s_RX sfifo is full, drop counter: %lu\n", get_name_from_can_id(can_id), can_rx_sfifo[can_id].drop_counter);
      }

#if defined(CAN_VEGA_FWD_PRESENT)
      rx_fwd_hadler(can_id, &rx);
#endif //defined(CAN_VEGA_FWD_PRESENT)

#if defined(YANDEX_OBD_PRESENT)
      obd_rx_handler(can_id, &rx);
#endif //defined(YANDEX_OBD_PRESENT)

      can_rx_debug_trace(&rx, can_id);

        if(can_id==CAN1_ID)
        {
          //Салонная шина 500 кбит\с
          if(rx.id_type==STD_ID_TYPE)
          {
            if(rx.id==0x582)
            {
              /*
              //пролетают нули
              if(rx.data[0]!=0xFF)
              {
                if(rx.data[0]==0x02)  System.can_state.sec_flags.trunk=0;
                else                  System.can_state.sec_flags.trunk=1;
              }
              */
            }
            else if(rx.id==0x662)
            {
              if(rx.data[1]==0x00)  System.can_state.sec_flags.hood=0;
              else                  System.can_state.sec_flags.hood=1;

              if(rx.data[2]==0x01)  System.can_state.cont_flags.marker_lights=1;
              else                  System.can_state.cont_flags.marker_lights=0;

              if(rx.data[2]==0x03)  System.can_state.cont_flags.dipped_beam=1;
              else                  System.can_state.cont_flags.dipped_beam=0;

              if(rx.data[2]==0x04 || rx.data[2]==0x07) System.can_state.cont_flags.high_beam=1;
              else                                     System.can_state.cont_flags.high_beam=0;
            }
            else if(rx.id==0x3D0 || rx.id==0x3D1 || rx.id==0x3D2 || rx.id==0x3D3)
            {
              //двери и положение окон
              //[0]
              //00 - концевик закрыт
              //01 - концевик открыт
              //06 - нажали закрыть замок
              //02 - замок закрыт
              if(!(rx.data[0]==0xFF || rx.data[0]==0x06))
              {
                if(rx.id==0x3D0)
                {
                  if(rx.data[0]==0x01) System.can_state.sec_flags.driver_door=1;
                  else                 System.can_state.sec_flags.driver_door=0;
                }
                else if(rx.id==0x3D1)
                {
                  if(rx.data[0]==0x01) System.can_state.sec_flags.pass_door=1;
                  else                 System.can_state.sec_flags.pass_door=0;
                }
                else
                {
                  if(can_program==PORSCHE_MACAN_2018_PROGRAM)
                  {
                    if(rx.id==0x3D2)
                    {
                      if(rx.data[0]==0x01) System.can_state.sec_flags.l_rear_door=1;
                      else                 System.can_state.sec_flags.l_rear_door=0;
                    }
                    else if(rx.id==0x3D3)
                    {
                      if(rx.data[0]==0x01) System.can_state.sec_flags.r_rear_door=1;
                      else                 System.can_state.sec_flags.r_rear_door=0;
                    }
                  }
                  else
                  {
                    System.can_state.sec_flags.l_rear_door=0;
                    System.can_state.sec_flags.r_rear_door=0;
                  }
                }
              }
            }
          }//if(rx.id_type==STD_ID_TYPE)
        }
        else if(can_id==CAN2_ID)
        {
          //Шина приборной панели 500 кбит\с
          if(rx.id_type==STD_ID_TYPE)
          {
            if(rx.id==0x308)
            {
              if(rx.data[0]!=0xFF)
              {
                System.Grab(portMAX_DELAY);
                {
                  if(rx.data[0]&(1<<4))  System.can_state.cont_flags.esp=1;
                  else                   System.can_state.cont_flags.esp=0;

                  if(rx.data[0]&(1<<5))  System.can_state.cont_flags.abs=1;
                  else                   System.can_state.cont_flags.abs=0;

                  //if(rx.data[0]&(1<<6))  System.can_state.sec_flags.hand_break=1;
                  //else                   System.can_state.sec_flags.hand_break=0;
                }System.Release();
              }
            }
            else if(rx.id==0x105)
            {
              if(rx.data[4]!=0xFF)
              {
                System.Grab(portMAX_DELAY);
                {
                  if(rx.data[4]&(1<<2))  System.can_state.sec_flags.pedal_break=1;
                  else                   System.can_state.sec_flags.pedal_break=0;
                }System.Release();
              }

              if(rx.data[6]!=0xFF)
              {
                System.Grab(portMAX_DELAY);
                {
                  System.can_state.numeric_data.accelerator=((rx.data[6])*100UL)/(0xFAUL);
                }System.Release();
              }
            }
            else if(rx.id==0x107)
            {
              //rpm
              System.Grab(portMAX_DELAY);
              {
                System.can_state.numeric_data.eng_rpm=((((0x0F&rx.data[4])<<8)|(rx.data[3]<<0))*100UL)/32UL;

                if(System.can_state.numeric_data.eng_rpm>350) System.can_state.sec_flags.engine_is_on=1;
                else                                          System.can_state.sec_flags.engine_is_on=0;
              }System.Release();
            }
            else if((rx.id==0x390 && can_program==PORSCHE_MACAN_2018_PROGRAM) || (rx.id==0x393 && can_program==PORSCHE_911_2018_PROGRAM))
            {
              uint8_t offset;

              if(can_program==PORSCHE_MACAN_2018_PROGRAM) offset=1;
              else                                        offset=3;

              System.can_state.numeric_data.can_axle_1=rx.data[offset];
              if(rx.data[offset]!=0xFF)
              {
                //02 P
                //03 R
                //04 N
                //25 D1
                //35 D2
                //45 D3
                //55 D4
                //29 M1
                //39 M2
                //49 M3
                //59 M4
                System.Grab(portMAX_DELAY);
                {
                  if((rx.data[offset]&0x0f)==0x02)      {System.can_state.sec_flags.parking=1; System.can_state.sec_flags.reverse_gear=0;}
                  else if((rx.data[offset]&0x0f)==0x03) {System.can_state.sec_flags.parking=0; System.can_state.sec_flags.reverse_gear=1;}
                  else                                  {System.can_state.sec_flags.parking=0; System.can_state.sec_flags.reverse_gear=0;}

                  if      ((rx.data[offset]&0x0f)==0x02) System.signal_state.selector_position='P';
                  else if ((rx.data[offset]&0x0f)==0x03) System.signal_state.selector_position='R';
                  else if ((rx.data[offset]&0x0f)==0x04) System.signal_state.selector_position='N';
                  else if ((rx.data[offset]&0x0f)==0x25) System.signal_state.selector_position='D';
                  //else if ((rx.data[offset]&0x0f)==) System.signal_state.selector_position='S';
                  else if ((rx.data[offset]&0x0f)==0x29) System.signal_state.selector_position='M';
                }System.Release();
              }
            }
            else if(rx.id==0x3C0)
            {
              if(rx.data[2]!=0xFF)
              {
                if(rx.data[2]==0x00)  System.can_state.sec_flags.key_in_ign=0;
                else                  System.can_state.sec_flags.key_in_ign=1;

                if(rx.data[2]==0x07 || rx.data[2]==0x0B /*стартер*/)  System.can_state.sec_flags.ignition=1;
                else                                                  System.can_state.sec_flags.ignition=0;
              }
            }
            else if(rx.id==0x440)
            {
              System.Grab(portMAX_DELAY);
              {
                if(rx.data[2]==0x04) System.can_state.cont_flags.chek_coolant=1;
                else                 System.can_state.cont_flags.chek_coolant=0;
              }System.Release();
            }
            //берем из салонной шины, т.к. совпадает для Macan и 911
            else if(false && rx.id==0x5EC && can_program==PORSCHE_MACAN_2018_PROGRAM)
            {
              if(rx.data[4]!=0xFF)
              {
                System.Grab(portMAX_DELAY);
                {
                  if(rx.data[4]&(1<<0))  System.can_state.sec_flags.driver_door=1;
                  else                   System.can_state.sec_flags.driver_door=0;

                  if(rx.data[4]&(1<<1))  System.can_state.sec_flags.pass_door=1;
                  else                   System.can_state.sec_flags.pass_door=0;

                  if(rx.data[4]&(1<<2))  System.can_state.sec_flags.l_rear_door=1;
                  else                   System.can_state.sec_flags.l_rear_door=0;

                  if(rx.data[4]&(1<<3))  System.can_state.sec_flags.r_rear_door=1;
                  else                   System.can_state.sec_flags.r_rear_door=0;
                }System.Release();
              }
            }
            else if(rx.id==0x640)
            {
              //Температура масла и ОЖ
            }
            else if(rx.id==0x674)
            {
              if(rx.data[0]!=0xFF && rx.data[1]!=0xFF && rx.data[2]!=0xFF)
              {
                System.Grab(portMAX_DELAY);
                {
                  if(rx.data[0]>0 || rx.data[1]>0 || rx.data[2]>0)  System.can_state.cont_flags.inflation_pressure=1;
                  else                                              System.can_state.cont_flags.inflation_pressure=0;
                }System.Release();
              }
            }
            else if(rx.id==0x086)
            {
              //rx.data[4] - похоже на усилие
              /*
              00000086 8 HEX        1F       0E       F8       11       00       00       00       00  крайнее лев
              00000086 8 HEX        DA       0F       6D       0B       00       00       00       00
              00000086 8 HEX        92       0E       FA       01       00       00       00       00
              00000086 8 HEX        D9       0A       27       20       00       00       00       00  середина
              00000086 8 HEX        F1       01       D9       21       00       00       00       00
              00000086 8 HEX        7C       05       7A       23       00       00       00       00
              00000086 8 HEX        09       07       19       32       00       00       00       00  крайнее прав
              */

              int32_t val=((rx.data[3]&0x1F)<<8)|((rx.data[2])<<0); //5+8бит данных

              val=(val*100)/4633; ////4633-max

              if(!(rx.data[3]&(1<<5))) val=-1*val; //5й бит положение руля

              System.Grab(portMAX_DELAY);
              {
                System.can_state.numeric_data.battery_charge_level=val;//temporary
              }System.Release();
            }
            else if(rx.id==0x6B7)
            {
              /*
              топливо ~50%, запас хода ~152км
              000006B7 8 HEX FB 02 F0 54 03 1F 00 9A 0741908431 21.07.2018 13:51:25.125
              000006B7 8 HEX FE FF 0F 00 00 7F 80 FE 0977484333 21.07.2018 13:55:20.701 //невалидно
              000006B7 8 HEX FB 02 A0 58 03 1F 80 FF 0978520382 21.07.2018 13:55:21.737 //невалидно
              000006B7 8 HEX FB 02 A0 58 03 1F 00 9B 0979520380 21.07.2018 13:55:22.737
              */

              /*
              лог с макана, почти полный бак запас большее 685 км, не бьётся совсем
              000006B7 8 HEX FE FF 0F 00 00 7F 80 FE 1634585010 21.07.2018 14:06:17.802
              000006B7 8 HEX 1B 00 A0 C2 00 48 C0 FE 1635616418 21.07.2018 14:06:18.833
              000006B7 8 HEX 1B 00 A0 C2 00 48 40 96 1636616694 21.07.2018 14:06:19.834
              ...
              000006B7 8 HEX 1B 00 50 C4 00 48 40 99 2643342121 21.07.2018 14:23:06.559
              000006B7 8 HEX 1B 00 50 C4 00 48 40 99 2644342152 21.07.2018 14:23:07.559
              000006B7 8 HEX 1B 00 50 C4 00 48 40 99 2645342151 21.07.2018 14:23:08.559


              D5 D6 D7
              26 00 8C примерно 50%, 266 запас хода
              4D 00 8C под завязку
              */
              System.can_state.numeric_data.can_axle_4=rx.data[5];
              System.can_state.numeric_data.can_axle_5=((rx.data[6]<<8)|(rx.data[7]<<0));

              //0x7F - невалидно
              if(!(rx.data[5]==0x7F || rx.data[5]==0xFF))
              {
                System.Grab(portMAX_DELAY);
                {
                  if(can_program==PORSCHE_911_2018_PROGRAM)
                  {
                    System.set_fuel_level_p((rx.data[5]*160Ul)/100Ul);
                  }
                  else //can_program==PORSCHE_MACAN_2018_PROGRAM
                  {
                    System.set_fuel_level_p((rx.data[5]*130Ul)/100Ul);
                  }
                  if (System.can_state.numeric_data.fuel_lev_p > 100) {
                    System.set_fuel_level_p(100);
                  }
                }System.Release();
              }
            }
            else if(rx.id==0x6B2)
            {
              //проверить на пробеге больше 255 и 65535!
              //125 км
              //6b2 0b 7d 00 20 29 dd xx xx
              //6b7 7d 00 c0 a5 03 3d 40 8f
              uint32_t val=((rx.data[3]&0x0f)<<16)|(rx.data[2]<<8)|(rx.data[1]<<0);
              if(!(val==0x0fffff || val==0x0ffffe))
              {
                System.Grab(portMAX_DELAY);
                {
                  System.can_state.numeric_data.can_odo_km=val;
                }System.Release();
              }
            }
            /*
            else if(rx.id==0x31A && can_program==PORSCHE_MACAN_2018_PROGRAM)
            {
              if(rx.data[4]!=0xFF)
              {
                System.Grab(portMAX_DELAY);
                {
                  System.can_state.numeric_data.can_speed=(((rx.data[4]&0x0f)<<8)|(rx.data[3]<<0))/50Ul;
                  temp_speed=(rx.data[4]<<8)|(rx.data[3]<<0);
                }System.Release();
              }
            }
            */
            else if(rx.id==0x103)
            {
              //System.can_state.numeric_data.can_axle_2=rx.data[7];
              if(rx.data[7]!=0xFF)
              {
                System.Grab(portMAX_DELAY);
                {
                  System.can_state.numeric_data.can_speed=(rx.data[7]*175Ul)/100Ul;
                }System.Release();
              }
            }
            else if(rx.id==0x040)
            {
              if(rx.data[4]!=0xFF)
              {
                System.Grab(portMAX_DELAY);
                {
                  if(rx.data[4]&(1<<0))  System.can_state.cont_flags.driver_safety_belt=0;
                  else                   System.can_state.cont_flags.driver_safety_belt=1;

                  if(rx.data[4]&(1<<1))  System.can_state.cont_flags.passenger_safety_belt=0;
                  else                   System.can_state.cont_flags.passenger_safety_belt=1;
                }System.Release();
              }
            }
            else if(rx.id==0x3C3)
            {
              if(rx.data[3]!=0xFF)
              {
                System.Grab(portMAX_DELAY);
                {
                  if(rx.data[3]==0x14 || rx.data[3]==0x18/*в процессе*/) System.can_state.sec_flags.hand_break=1;
                  else                                                   System.can_state.sec_flags.hand_break=0;
                }System.Release();
              }
            }
            else if(rx.id==0x11A)
            {
              uint16_t val=((rx.data[4]<<4)|(rx.data[3]>>4));

              if(val!=0x0FFF)
              {
                System.Grab(portMAX_DELAY);
                {
                  //запас хода, расстоние до пустого бака
                  System.can_state.numeric_data.fuel_lev_l=val;
                }System.Release();
              }
            }
            else if(rx.id==0x5EC)
            {
              if(rx.data[0]!=0xFF)
              {
                if(rx.data[0]==0x00) System.signal_state.windows_position.driver_door=0;
                else                 System.signal_state.windows_position.driver_door=1;

                System.signal_state.windows_position.driver_door_prepared=1;
              }

              if(rx.data[1]!=0xFF)
              {
                if(rx.data[1]==0x00) System.signal_state.windows_position.pass_door=0;
                else                 System.signal_state.windows_position.pass_door=1;

                System.signal_state.windows_position.pass_door_prepared=1;
              }

              if(rx.data[2]!=0xFF)
              {
                if(rx.data[2]==0x00) System.signal_state.windows_position.l_rear_door=0;
                else                 System.signal_state.windows_position.l_rear_door=1;

                System.signal_state.windows_position.l_rear_door_prepared=1;
              }

              if(rx.data[3]!=0xFF)
              {
                if(rx.data[3]==0x00) System.signal_state.windows_position.r_rear_door=0;
                else                 System.signal_state.windows_position.r_rear_door=1;

                System.signal_state.windows_position.r_rear_door_prepared=1;
              }
            }
            else if(rx.id==0x6A1)
            {
              if(rx.data[1]!=0xFF)
              {
                if(rx.data[1]&(1<<1)) _cls_state=LOCKED_CLS_STATE;
                else                  _cls_state=UNLOCKED_CLS_STATE;

                if(_cls_state==LOCKED_CLS_STATE)
                {
                  System.signal_state.cls_state.driver_door=0; System.signal_state.cls_state.l_rear_door=0; System.signal_state.cls_state.r_rear_door=0; System.signal_state.cls_state.pass_door=0;
                }
                else
                {
                  System.signal_state.cls_state.driver_door=1; System.signal_state.cls_state.l_rear_door=1; System.signal_state.cls_state.r_rear_door=1; System.signal_state.cls_state.pass_door=1;
                }

                System.signal_state.cls_state.driver_door_prepared=1;
                System.signal_state.cls_state.l_rear_door_prepared=1;
                System.signal_state.cls_state.r_rear_door_prepared=1;
                System.signal_state.cls_state.pass_door_prepared=1;
              }
            }
            else if(rx.id==0x363)
            {
              if(rx.data[1]!=0xFF)
              {
                if((rx.data[1]&0x0F)==0x04) System.signal_state.emergency_lights=1;
                else                        System.signal_state.emergency_lights=0;
              }
            }
            else if(rx.id==0x444)
            {
              if(can_program==PORSCHE_MACAN_2018_PROGRAM) //на 911 есть багажник?
              {
                if(rx.data[0]!=0xFF)
                {
                  if(rx.data[0]&(1<<4)) System.can_state.sec_flags.trunk=1;
                  else                  System.can_state.sec_flags.trunk=0;
                }
              }
            }
          }//if(rx.id_type==STD_ID_TYPE)
        }
        else if(can_id==CAN3_ID)
        {
          //none
        }
    }

    if(mess_count)
    {
      restart_sleep_and_rx_timers(can_id);
    }
  }

  System.can_state.sec_flags.can_in_sleep=can_sleep_indicate_handler();

  blocks_handler();

  taxi_blocks_handler();
}

static void can_rx_mb_e200_2018_handler(void)
{
  can_rx_frame_t rx;

  for(uint8_t can_id=CAN1_ID; can_id<HW_CAN_COUNT; can_id++)
  {
    uint16_t mess_count=filled_count_in_sfifo(&can_rx_sfifo[can_id]);

    for(uint16_t j=0; j<mess_count; j++)
    {
      if(!read_from_sfifo(&can_rx_sfifo[can_id], &rx))
      {
        __PRINTF("%s_RX sfifo is full, drop counter: %lu\n", get_name_from_can_id(can_id), can_rx_sfifo[can_id].drop_counter);
      }

#if defined(CAN_VEGA_FWD_PRESENT)
      rx_fwd_hadler(can_id, &rx);
#endif //defined(CAN_VEGA_FWD_PRESENT)

#if defined(YANDEX_OBD_PRESENT)
      obd_rx_handler(can_id, &rx);
#endif //defined(YANDEX_OBD_PRESENT)

      can_rx_debug_trace(&rx, can_id);

        if(can_id==CAN1_ID)
        {
          //Салонная шина 250 кбит\с
          if(rx.id_type==STD_ID_TYPE)
          {
            /*
            статус магнитафона
            RX 0000169 SFF 000003E1 8 HEX        80       09       00       00       7F       1F       CF       00 1914660037 16.08.2018 23:43:44.666
            RX 0000170 SFF 000003E1 8 HEX        80       09       00       00       7F       1F       CF       00 1914860036 16.08.2018 23:43:44.866
            RX 0000171 SFF 000003E1 8 HEX        80       09       01       00       7F       1F       CF       00 1914978820 16.08.2018 23:43:44.985
            RX 0000172 SFF 000003E1 8 HEX        80       09       01       00       7F       1F       CF       00 1915060099 16.08.2018 23:43:45.066
            RX 0000173 SFF 000003E1 8 HEX        80       09       01       00       7F       1F       CF       00 1915259892 16.08.2018 23:43:45.266
            RX 0000174 SFF 000003E1 8 HEX        80       09       01       00       7F       1F       CF       00 1915459872 16.08.2018 23:43:45.466
            RX 0000175 SFF 000003E1 8 HEX        80       09       01       00       7F       1F       CF       00 1915659888 16.08.2018 23:43:45.666
            RX 0000176 SFF 000003E1 8 HEX        80       09       01       00       7F       1F       CF       00 1915859895 16.08.2018 23:43:45.866
            RX 0000177 SFF 000003E1 8 HEX        80       09       01       00       7F       1F       CF       00 1916059885 16.08.2018 23:43:46.066
            RX 0000178 SFF 000003E1 8 HEX        80       09       01       00       7F       1F       CF       00 1916259951 16.08.2018 23:43:46.266
            RX 0000179 SFF 000003E1 8 HEX        40       09       01       00       7F       1F       CF       00 1916430913 16.08.2018 23:43:46.437
            RX 0000180 SFF 000003E1 8 HEX        40       09       00       00       7F       1F       CF       00 1916459889 16.08.2018 23:43:46.466
            RX 0000181 SFF 000003E1 8 HEX        40       09       00       00       7F       1F       CF       00 1916659987 16.08.2018 23:43:46.666
            RX 0000182 SFF 000003E1 8 HEX        40       09       00       00       7F       1F       CF       00 1916860050 16.08.2018 23:43:46.866
            RX 0000183 SFF 000003E1 8 HEX        40       09       00       00       7F       1F       CF       00 1917059926 16.08.2018 23:43:47.066
            RX 0000184 SFF 000003E1 8 HEX        40       09       00       00       7F       1F       CF       00 1917259968 16.08.2018 23:43:47.266
            RX 0000185 SFF 000003E1 8 HEX        40       09       00       00       7F       1F       CF       00 1917459932 16.08.2018 23:43:47.466
            RX 0000186 SFF 000003E1 8 HEX        40       09       00       00       7F       1F       CF       00 1917659891 16.08.2018 23:43:47.666
            RX 0000187 SFF 000003E1 8 HEX        40       09       00       00       7F       1F       CF       00 1917859996 16.08.2018 23:43:47.866
            RX 0000188 SFF 000003E1 8 HEX        40       09       00       00       7F       1F       CF       00 1918059894 16.08.2018 23:43:48.066
            RX 0000189 SFF 000003E1 8 HEX        40       09       00       00       7F       1F       CF       00 1918260011 16.08.2018 23:43:48.266
            RX 0000190 SFF 000003E1 8 HEX        40       09       00       00       7F       1F       CF       00 1918459991 16.08.2018 23:43:48.466
            RX 0000191 SFF 000003E1 8 HEX        80       09       00       00       7F       1F       CF       00 1918580445 16.08.2018 23:43:48.587
            RX 0000192 SFF 000003E1 8 HEX        80       09       00       00       7F       1F       CF       00 1918660060 16.08.2018 23:43:48.666
            RX 0000193 SFF 000003E1 8 HEX        80       09       00       00       7F       1F       CF       00 1918859933 16.08.2018 23:43:48.866
            RX 0000194 SFF 000003E1 8 HEX        80       09       00       00       7F       1F       CF       00 1919059999 16.08.2018 23:43:49.066
            RX 0000195 SFF 000003E1 8 HEX        80       09       01       00       7F       1F       CF       00 1919178849 16.08.2018 23:43:49.185
            RX 0000196 SFF 000003E1 8 HEX        80       09       01       00       7F       1F       CF       00 1919260044 16.08.2018 23:43:49.266
            RX 0000197 SFF 000003E1 8 HEX        80       09       01       00       7F       1F       CF       00 1919460023 16.08.2018 23:43:49.466
            RX 0000198 SFF 000003E1 8 HEX        40       09       01       00       7F       1F       CF       00 1919580457 16.08.2018 23:43:49.587
            RX 0000199 SFF 000003E1 8 HEX        40       09       00       00       7F       1F       CF       00 1919600889 16.08.2018 23:43:49.607
            RX 0000200 SFF 000003E1 8 HEX        40       09       00       00       7F       1F       CF       00 1919659975 16.08.2018 23:43:49.666
            RX 0000201 SFF 000003E1 8 HEX        40       09       00       00       7F       1F       CF       00 1919860056 16.08.2018 23:43:49.866
            RX 0000202 SFF 000003E1 8 HEX        40       09       00       00       7F       1F       CF       00 1920059984 16.08.2018 23:43:50.066
            RX 0000203 SFF 000003E1 8 HEX        40       09       00       00       7F       1F       CF       00 1920260091 16.08.2018 23:43:50.266
            RX 0000204 SFF 000003E1 8 HEX        40       09       00       00       7F       1F       CF       00 1920460045 16.08.2018 23:43:50.466
            RX 0000205 SFF 000003E1 8 HEX        40       09       00       00       7F       1F       CF       00 1920660319 16.08.2018 23:43:50.667
            RX 0000206 SFF 000003E1 8 HEX        40       09       00       00       7F       1F       CF       00 1920860023 16.08.2018 23:43:50.866
            RX 0000207 SFF 000003E1 8 HEX        80       09       00       00       7F       1F       CF       00 1920880530 16.08.2018 23:43:50.887
            RX 0000208 SFF 000003E1 8 HEX        80       09       00       00       7F       1F       CF       00 1921060298 16.08.2018 23:43:51.067
            RX 0000209 SFF 000003E1 8 HEX        40       09       00       00       7F       1F       CF       00 1924260031 16.08.2018 23:43:54.266
            RX 0000210 SFF 000003E1 8 HEX        40       09       00       00       7F       1F       CF       00 1924459933 16.08.2018 23:43:54.466
            RX 0000211 SFF 000003E1 8 HEX        40       09       00       00       7F       1F       CF       00 1924659948 16.08.2018 23:43:54.666
            RX 0000212 SFF 000003E1 8 HEX        40       09       00       00       7F       1F       CF       00 1924859963 16.08.2018 23:43:54.866
            RX 0000213 SFF 000003E1 8 HEX        40       09       00       00       7F       1F       CF       00 1925059995 16.08.2018 23:43:55.066
            RX 0000214 SFF 000003E1 8 HEX        40       09       00       00       7F       1F       CF       00 1925260018 16.08.2018 23:43:55.266
            RX 0000215 SFF 000003E1 8 HEX        80       09       00       00       7F       1F       CF       00 1925381282 16.08.2018 23:43:55.388
            RX 0000216 SFF 000003E1 8 HEX        80       09       00       00       7F       1F       CF       00 1925459958 16.08.2018 23:43:55.466
            RX 0000217 SFF 000003E1 8 HEX        80       09       00       00       7F       1F       CF       00 1925659979 16.08.2018 23:43:55.666
            RX 0000218 SFF 000003E1 8 HEX        80       09       00       00       7F       1F       CF       00 1925859980 16.08.2018 23:43:55.866
            RX 0000219 SFF 000003E1 8 HEX        80       09       00       00       7F       1F       CF       00 1926059991 16.08.2018 23:43:56.066
            RX 0000220 SFF 000003E1 8 HEX        80       09       00       00       7F       1F       CF       00 1926260032 16.08.2018 23:43:56.266
            RX 0000221 SFF 000003E1 8 HEX        80       09       00       00       7F       1F       CF       00 1926459971 16.08.2018 23:43:56.466
            RX 0000222 SFF 000003E1 8 HEX        80       09       00       00       7F       1F       CF       00 1926659983 16.08.2018 23:43:56.666
            RX 0000223 SFF 000003E1 8 HEX        80       09       00       00       7F       1F       CF       00 1926860016 16.08.2018 23:43:56.866
            RX 0000224 SFF 000003E1 8 HEX        80       09       00       00       7F       1F       CF       00 1927060003 16.08.2018 23:43:57.066
            RX 0000225 SFF 000003E1 8 HEX        80       09       00       00       7F       1F       CF       00 1927260045 16.08.2018 23:43:57.266
            RX 0000226 SFF 000003E1 8 HEX        80       09       00       00       7F       1F       CF       00 1927460030 16.08.2018 23:43:57.466
            RX 0000227 SFF 000003E1 8 HEX        80       09       00       00       7F       1F       CF       00 1927660018 16.08.2018 23:43:57.666
            RX 0000228 SFF 000003E1 8 HEX        80       09       00       00       7F       1F       CF       00 1927860025 16.08.2018 23:43:57.866
            RX 0000229 SFF 000003E1 8 HEX        80       09       00       00       7F       1F       CF       00 1928060027 16.08.2018 23:43:58.066
            RX 0000230 SFF 000003E1 8 HEX        80       09       00       00       7F       1F       CF       00 1928260058 16.08.2018 23:43:58.266
            RX 0000231 SFF 000003E1 8 HEX        80       09       00       00       7F       1F       CF       00 1928460005 16.08.2018 23:43:58.466
            RX 0000232 SFF 000003E1 8 HEX        80       09       01       00       7F       1F       CF       00 1928629388 16.08.2018 23:43:58.636
            RX 0000233 SFF 000003E1 8 HEX        80       09       01       00       7F       1F       CF       00 1928660042 16.08.2018 23:43:58.666
            RX 0000234 SFF 000003E1 8 HEX        80       09       01       00       7F       1F       CF       00 1928860060 16.08.2018 23:43:58.866
            RX 0000235 SFF 000003E1 8 HEX        40       09       01       00       7F       1F       CF       00 1928980411 16.08.2018 23:43:58.987
            RX 0000236 SFF 000003E1 8 HEX        40       09       00       00       7F       1F       CF       00 1929001497 16.08.2018 23:43:59.008
            RX 0000237 SFF 000003E1 8 HEX        40       09       00       00       7F       1F       CF       00 1929060064 16.08.2018 23:43:59.066
            RX 0000238 SFF 000003E1 8 HEX        40       09       00       00       7F       1F       CF       00 1929260071 16.08.2018 23:43:59.266
            RX 0000239 SFF 000003E1 8 HEX        40       09       00       00       7F       1F       CF       00 1929460102 16.08.2018 23:43:59.466
            RX 0000240 SFF 000003E1 8 HEX        40       09       00       00       7F       1F       CF       00 1929660071 16.08.2018 23:43:59.666
            RX 0000241 SFF 000003E1 8 HEX        40       09       00       00       7F       1F       CF       00 1929860073 16.08.2018 23:43:59.866
            RX 0000242 SFF 000003E1 8 HEX        40       09       00       00       7F       1F       CF       00 1930060104 16.08.2018 23:44:00.066
            */
            if(rx.id==0x397 || rx.id==0x39B || rx.id==0x3A3 || rx.id==0x3A5)
            {
              if((rx.data[1]&0xf0)==0x10 || (rx.data[1]&0xf0)==0x20)
              {
                System.Grab(portMAX_DELAY);
                {
                  if(rx.id==0x397)
                  {
                    if((rx.data[1]&0xf0)==0x10)   System.can_state.sec_flags.driver_door=0;
                    else                          System.can_state.sec_flags.driver_door=1;
                  }
                  else if(rx.id==0x39B)
                  {
                    if((rx.data[1]&0xf0)==0x10)   System.can_state.sec_flags.pass_door=0;
                    else                          System.can_state.sec_flags.pass_door=1;
                  }
                  else if(rx.id==0x3A3)
                  {
                    if((rx.data[1]&0xf0)==0x10)   System.can_state.sec_flags.l_rear_door=0;
                    else                          System.can_state.sec_flags.l_rear_door=1;
                  }
                  else if(rx.id==0x3A5)
                  {
                    if((rx.data[1]&0xf0)==0x10)   System.can_state.sec_flags.r_rear_door=0;
                    else                          System.can_state.sec_flags.r_rear_door=1;
                  }
                }System.Release();
              }
            }
            else if(rx.id==0x31A || rx.id==0x320 || rx.id==0x32E || rx.id==0x328)
            {
              /*
              положения окон и кноки управления окнами
              0x31A driver
              0x320 pass
              0x32E r
              0x328 l
              D1
              EX окна подняты
              */
              if(rx.id==0x31A)
              {
                if((rx.data[1]&0xf0)==0xE0) System.signal_state.windows_position.driver_door=0;
                else                        System.signal_state.windows_position.driver_door=1;

                System.signal_state.windows_position.driver_door_prepared=1;
              }
              else if(rx.id==0x320)
              {
                if((rx.data[1]&0xf0)==0xE0) System.signal_state.windows_position.pass_door=0;
                else                        System.signal_state.windows_position.pass_door=1;

                System.signal_state.windows_position.pass_door_prepared=1;
              }
              else if(rx.id==0x32E)
              {
                if((rx.data[1]&0xf0)==0xE0) System.signal_state.windows_position.r_rear_door=0;
                else                        System.signal_state.windows_position.r_rear_door=1;

                System.signal_state.windows_position.r_rear_door_prepared=1;
              }
              else if(rx.id==0x328)
              {
                if((rx.data[1]&0xf0)==0xE0) System.signal_state.windows_position.l_rear_door=0;
                else                        System.signal_state.windows_position.l_rear_door=1;

                System.signal_state.windows_position.l_rear_door_prepared=1;
              }
            }
            else if(rx.id==0x351)
            {
              if((rx.data[0]&0xf0)==0x10 || (rx.data[0]&0xf0)==0x20)
              {
                if((rx.data[0]&0xf0)==0x10)   System.can_state.sec_flags.trunk=0;
                else                          System.can_state.sec_flags.trunk=1;
              }
            }
            else if(rx.id==0x337)
            {
              if(rx.data[0]!=0xff)
              {
                //Низкий уровень омывающей ждикости
                if(rx.data[0]&(1<<3)) System.signal_state.washer_liquid=1;
                else                  System.signal_state.washer_liquid=0;

                System.can_state.numeric_data.ad_blue_p=System.signal_state.washer_liquid;//temporary

                if(rx.data[0]&(1<<2)) System.can_state.cont_flags.chek_coolant=1;
                else                  System.can_state.cont_flags.chek_coolant=0;

                //0x60 0110 0000 капот открыт заглушены
                //0x60 0110 0000 капот открыт заведены
                //0xA0 1010 0000 капот закрыт заглушены (так пишет Артем, я не видел такого)
                //0x50 0101 0000 капот закрыт заведены
                //При закрытии на заведённую 0xA0->0x50 (так пишет Артем, я не видел такого)

                if((rx.data[0]&0xf0)==0x60) System.can_state.sec_flags.hood=1;
                else                        System.can_state.sec_flags.hood=0;
              }
            }
            else if(rx.id==0x33D)
            {
              System.Grab(portMAX_DELAY);
              {
                if((rx.data[1]&0xf0)==0x30)  System.can_state.cont_flags.marker_lights=1;
                else                         System.can_state.cont_flags.marker_lights=0;

                if((rx.data[1]&0xf0)==0xD0)  System.can_state.cont_flags.dipped_beam=1;
                else                         System.can_state.cont_flags.dipped_beam=0;

                if((rx.data[4]&0x0f)==0x03)  System.can_state.cont_flags.high_beam=1;
                else                         System.can_state.cont_flags.high_beam=0;
              }System.Release();
            }
            else if(rx.id==0x335)
            {
              /*
              Положение переключателя
              0x335
              D4
              10 <-P
              20 ->P
              40 габ
              01 авто
              08 ближний
              */
              if(rx.data[4]==0x01) light_switch_position_in_auto_or_off=true;
              else                 light_switch_position_in_auto_or_off=false;
            }
            else if(rx.id==0x2FB)
            {
              //статус ЦЗ, не меняется при управлении по CAN, только при нажатии кнопок
              //55 19 XX XX XX XX XX цз закрыт
              //0101 0101  0001 1001
              //AA 0A XX XX XX XX XX цз открыт
              //1010 1010  0000 1010
            }
            else if(rx.id==0x15F)
            {
              if(IS_MB_C180() || IS_MB_E200_2020())
              {
                if(rx.data[1]!=0xFF)
                {
                  System.Grab(portMAX_DELAY);
                  {
                    if((rx.data[1]&0x0F)==0x08)      {System.can_state.sec_flags.parking=1; System.can_state.sec_flags.reverse_gear=0;}
                    else if((rx.data[1]&0x0F)==0x07) {System.can_state.sec_flags.parking=0; System.can_state.sec_flags.reverse_gear=1;}
                    else                             {System.can_state.sec_flags.parking=0; System.can_state.sec_flags.reverse_gear=0;}

                    if      ((rx.data[1]&0x0F)==0x08) System.signal_state.selector_position='P';
                    else if ((rx.data[1]&0x0F)==0x07) System.signal_state.selector_position='R';
                    else if ((rx.data[1]&0x0F)==0x06) System.signal_state.selector_position='N';
                    else if ((rx.data[1]&0x0F)==0x05) System.signal_state.selector_position='D';
                    //else if ((rx.data[1]&0x0F)==) System.signal_state.selector_position='S';
                    //else if ((rx.data[1]&0x0F)==0x1A || rx.data[2]==0x09) System.signal_state.selector_position='M';
                  }System.Release();
                }
              }
            }
            else if(rx.id==0x33B)
            {
              //if(IS_MB_C180())//на E200 не проверяли
              //{
                if(rx.data[4]!=0xFF)
                {
                  if((rx.data[4]&(1<<1))) System.signal_state.emergency_lights=1;
                  else                    System.signal_state.emergency_lights=0;
                }
              //}
            }
            else if(rx.id==0x15B)
            {
              //на C180 не проверяли
              if(rx.data[0]!=0xFF)
              {
                System.can_state.numeric_data.accelerator=((rx.data[0])*100Ul)/(0xFA);
              }
            }
            else if(rx.id==0x17F)
            {
              uint16_t raw = (rx.data[1] << 8) | rx.data[0];
              float angle = (raw * 0.0625) - 68608;
              angle *= -1.0f;
              angle -= 65535.0f;

              System.can_state.numeric_data.battery_charge_level = angle;
            }
          }//if(rx.id_type==STD_ID_TYPE)
        }
        else if(can_id==CAN2_ID)
        {
          //Шина приборной панели 500 кбит\с
          //ODB? запросы работают
          if(rx.id_type==STD_ID_TYPE)
          {
            if(rx.id==0x020)
            {
              if((rx.data[3]&0xf0)==0x10)  System.can_state.sec_flags.pedal_break=1;
              else                         System.can_state.sec_flags.pedal_break=0;
            }
            else if(rx.id==0x2C7)
            {
              if(!IS_MB_C180() && !IS_MB_E200_2020())
              {
                if(rx.data[2]!=0xFF)
                {
                  System.Grab(portMAX_DELAY);
                  {
                    if(rx.data[2]==0x50)      {System.can_state.sec_flags.parking=1; System.can_state.sec_flags.reverse_gear=0;}
                    else if(rx.data[2]==0x52) {System.can_state.sec_flags.parking=0; System.can_state.sec_flags.reverse_gear=1;}
                    else                      {System.can_state.sec_flags.parking=0; System.can_state.sec_flags.reverse_gear=0;}

                    if      (rx.data[2]==0x50) System.signal_state.selector_position='P';
                    else if (rx.data[2]==0x52) System.signal_state.selector_position='R';
                    else if (rx.data[2]==0x4E) System.signal_state.selector_position='N';
                    else if (rx.data[2]==0x31) System.signal_state.selector_position='D';
                    //else if (rx.data[2]==) System.signal_state.selector_position='S';
                    //else if (rx.data[2]==0x1A || rx.data[2]==0x09) System.signal_state.selector_position='M';
                  }System.Release();
                }
              }
            }
            else if(rx.id==0x141)
            {
              if(rx.data[1]==0x40)        System.can_state.cont_flags.chek_oil=1;
              else                        System.can_state.cont_flags.chek_oil=0;

              if((rx.data[3]&0xf0)==0x40) System.can_state.sec_flags.ignition=1;
              else                        System.can_state.sec_flags.ignition=0;
            }
            else if(rx.id==0x147)
            {
              if(rx.data[5]!=0xFF)
              {
                System.Grab(portMAX_DELAY);
                {
                  System.can_state.numeric_data.eng_temp=rx.data[5]-40.0f;
                }System.Release();
              }
            }
            else if(rx.id==0x2FE)
            {
              //127 отображается при включении зажигания

              if((rx.data[0]&0x7F)<=100)
              {
                System.set_fuel_level_p((rx.data[0]&0x7F));
              }
            }
            /*
            else if(rx.id==0x10D)
            {
              //rpm, на C180 не работает
              System.Grab(portMAX_DELAY);
              {
                System.can_state.numeric_data.eng_rpm=((rx.data[2])<<16)|((rx.data[1])<<8)|((rx.data[0])<<0);

                if(System.can_state.numeric_data.eng_rpm>350) System.can_state.sec_flags.engine_is_on=1;
                else                                          System.can_state.sec_flags.engine_is_on=0;
              }System.Release();
            }
            */
            else if(rx.id==0x0B1)
            {
              //rpm, работает на C180 и на E200
              //пролетает 0x3FFF
              uint16_t val=(rx.data[4]<<8)|(rx.data[3]<<0);

              if(val<0x1FFF)
              {
                System.Grab(portMAX_DELAY);
                {
                  System.can_state.numeric_data.eng_rpm=val;

                  if(System.can_state.numeric_data.eng_rpm>350) System.can_state.sec_flags.engine_is_on=1;
                  else                                          System.can_state.sec_flags.engine_is_on=0;
                }System.Release();
              }
            }
            else if(rx.id==0x3C2)
            {
              /*
              D1
              4X снят заглушен
              5X затянут заглушен
              0X снят заведен
              1X снят заведен
              */
              if(rx.data[1]!=0xFF)
              {
                System.Grab(portMAX_DELAY);
                {
                  if((rx.data[1]&0xf0)==0x50)      System.can_state.sec_flags.hand_break=1;
                  else if((rx.data[1]&0xf0)==0x10) System.can_state.sec_flags.hand_break=1;
                  else                             System.can_state.sec_flags.hand_break=0;
                }System.Release();
              }
            }
            else if(rx.id==0x2CF)
            {
              if(rx.data[7]!=0xFF)
              {
                System.Grab(portMAX_DELAY);
                {
                  if(rx.data[7]&(1<<4)) System.can_state.cont_flags.driver_safety_belt=0;
                  else                  System.can_state.cont_flags.driver_safety_belt=1;

                  if(rx.data[7]&(1<<6)) System.can_state.cont_flags.passenger_safety_belt=0;
                  else                  System.can_state.cont_flags.passenger_safety_belt=1;
                }System.Release();
              }
            }
            else if(rx.id==0x309)
            {
              uint32_t val=((rx.data[2]<<16)|(rx.data[1]<<8)|(rx.data[0]<<0));

              if(val<0xFFFFFFFE)
              {
                float fval=val/10.0f;

                System.Grab(portMAX_DELAY);
                {
                  System.can_state.numeric_data.can_odo_km=fval;
                }System.Release();
              }

              val=((rx.data[7]<<8)|(rx.data[6]<<0))&0x0FFF;

              if(val<0x0FFF)
              {
                val=val/10;

                System.can_state.numeric_data.can_speed=val;
              }
            }
            /*
            else if(rx.id==0x098)
            {
              if(rx.data[4]!=0xFF)
              {
                System.Grab(portMAX_DELAY);
                {
                  System.can_state.numeric_data.can_speed=rx.data[4];
                }System.Release();
              }
            }
            */
            else if(rx.id==0x339)
            {
              if(rx.data[0]!=0xFF)
              {
                if((rx.data[0]&0x03)==0x00)      System.signal_state.key_position='O';
                else if((rx.data[0]&0x03)==0x02) System.signal_state.key_position='A';
                else if((rx.data[0]&0x03)==0x03) System.signal_state.key_position='I';
                else                             System.signal_state.key_position='U';
              }
            }
            else if(rx.id==0x087)
            {
              uint8_t raw_l = rx.data[4];
              //uint8_t raw_h = rx.data[5];
              // put only low byte of brake
              System.can_state.numeric_data.brake=raw_l;
            }
          }//if(rx.id_type==STD_ID_TYPE)
        }
        else if(can_id==CAN3_ID)
        {
          //none
        }
    }

    if(mess_count)
    {
      restart_sleep_and_rx_timers(can_id);
    }
  }

  System.can_state.sec_flags.can_in_sleep=can_sleep_indicate_handler();

  blocks_handler();

  mb_e200_2018_analog_to_can_handler();

  taxi_blocks_handler();
}

static void can_rx_toyota_rav4_2019_handler(void)
{
  can_rx_frame_t rx;

  for(uint8_t can_id=CAN1_ID; can_id<HW_CAN_COUNT; can_id++)
  {
    uint16_t mess_count=filled_count_in_sfifo(&can_rx_sfifo[can_id]);

    for(uint16_t j=0; j<mess_count; j++)
    {
      if(!read_from_sfifo(&can_rx_sfifo[can_id], &rx))
      {
        __PRINTF("%s_RX sfifo is full, drop counter: %lu\n", get_name_from_can_id(can_id), can_rx_sfifo[can_id].drop_counter);
      }

#if defined(CAN_VEGA_FWD_PRESENT)
      rx_fwd_hadler(can_id, &rx);
#endif //defined(CAN_VEGA_FWD_PRESENT)

#if defined(YANDEX_OBD_PRESENT)
      obd_rx_handler(can_id, &rx);
#endif //defined(YANDEX_OBD_PRESENT)

      can_rx_debug_trace(&rx, can_id);

      if(can_id==CAN1_ID)
      {
        //x CAN, 500 кбит\с
        if(rx.id_type==STD_ID_TYPE)
        {
          switch(rx.id)
          {
          case 0x361:
            {
              if(rx.data[2]!=0xFF)
              {
                System.can_state.numeric_data.accelerator=(rx.data[2])/2;
              }
            }
            break;

          case 0x3BB:
            {
              if(rx.data[0]!=0xFF)
              {
                if(rx.data[0]<<(1<<0)) System.can_state.sec_flags.pedal_break=1;
                else                   System.can_state.sec_flags.pedal_break=0;
              }

              if(rx.data[2]!=0xFF)
              {
                System.Grab(portMAX_DELAY);
                {
                  System.can_state.numeric_data.eng_temp=rx.data[2]/2;
                }System.Release();
              }
            }
            break;

          case 0x3BC:
            {
              if(rx.data[1]!=0xFF)
              {
                System.Grab(portMAX_DELAY);
                {
                  if(rx.data[1]==0x20)      {System.can_state.sec_flags.parking=1; System.can_state.sec_flags.reverse_gear=0;}
                  else if(rx.data[1]==0x10) {System.can_state.sec_flags.parking=0; System.can_state.sec_flags.reverse_gear=1;}
                  else                      {System.can_state.sec_flags.parking=0; System.can_state.sec_flags.reverse_gear=0;}

                  if      (rx.data[1]==0x20) System.signal_state.selector_position='P';
                  else if (rx.data[1]==0x10) System.signal_state.selector_position='R';
                  else if (rx.data[1]==0x08) System.signal_state.selector_position='N';
                  else if (rx.data[1]==0x00) System.signal_state.selector_position='D';
                  //else if (rx.data[1]==) System.signal_state.selector_position='S';
                  else if (rx.data[1]==0x01) System.signal_state.selector_position='M';
                  else                       System.signal_state.selector_position='U';
                }System.Release();
              }
            }
            break;

          case 0x617:
            {
              uint16_t val_1=(rx.data[4]<<8)|(rx.data[5]<<0);
              uint16_t val_2=(rx.data[6]<<8)|(rx.data[7]<<0);

              if(val_1<0xFFFE && val_2<0xFFFE)
              {
                System.set_fuel_level_p(((val_1+val_2)*10Ul)/56Ul);
              }
            }
            break;

          case 0x0B4:
            {
              uint16_t val=(rx.data[5]<<8)|(rx.data[6]<<0);

              if(val<0x7FFF)
              {
                val=val/100;

                System.can_state.numeric_data.can_speed=val;
              }
            }
            break;

          case 0x611:
            {
              uint32_t val=((rx.data[5]<<16)|(rx.data[6]<<8)|(rx.data[7]<<0));

              if(val<0x00FFFFFE)
              {
                System.Grab(portMAX_DELAY);
                {
                  System.can_state.numeric_data.can_odo_km=val;
                }System.Release();
              }
            }
            break;

          case 0x1C4:
            {
              uint32_t val=(rx.data[0]<<8)|(rx.data[1]<<0);

              if(val<0x7FFF)
              {
                val=(val*75)/100;

                System.Grab(portMAX_DELAY);
                {
                  System.can_state.numeric_data.eng_rpm=val;

                  if(System.can_state.numeric_data.eng_rpm>350) System.can_state.sec_flags.engine_is_on=1;
                  else                                          System.can_state.sec_flags.engine_is_on=0;
                }System.Release();
              }
              restart_can_timer(AUX_CAN_TIMER_1, 1500);
            }
            break;

          case 0x619:
            {
              if(rx.data[0]==0x10 /*&& rx.data[1]==0x*/)
              {
                uint16_t val=(rx.data[2]<<8)|(rx.data[3]<<0);

                val=0x0FFF&val;

                if(val<0x0FFE)
                {
                  System.Grab(portMAX_DELAY);
                  {
                    //запас хода, расстоние до пустого бака
                    System.can_state.numeric_data.fuel_lev_l=val;
                  }System.Release();
                }
              }
            }
            break;

          case 0x620:
            {
              if(rx.data[4]!=0xFF)
              {
                if(rx.data[4]&(1<<5)) System.can_state.sec_flags.ignition=1;
                else                  System.can_state.sec_flags.ignition=0;
              }

              if(rx.data[5]!=0xFF)
              {
                if(rx.data[5]&(1<<5)) System.can_state.sec_flags.driver_door=1;
                else                   System.can_state.sec_flags.driver_door=0;

                if(rx.data[5]&(1<<4)) System.can_state.sec_flags.pass_door=1;
                else                  System.can_state.sec_flags.pass_door=0;

                if(rx.data[5]&(1<<2)) System.can_state.sec_flags.l_rear_door=1;
                else                  System.can_state.sec_flags.l_rear_door=0;

                if(rx.data[5]&(1<<3)) System.can_state.sec_flags.r_rear_door=1;
                else                  System.can_state.sec_flags.r_rear_door=0;

                if(rx.data[5]&(1<<1)) System.can_state.sec_flags.trunk=1;
                else                  System.can_state.sec_flags.trunk=0;
              }

              if(rx.data[7]!=0xFF)
              {
                if(rx.data[7]&(1<<4)) System.can_state.sec_flags.hand_break=1;
                else                   System.can_state.sec_flags.hand_break=0;

                if(rx.data[7]&(1<<6)) System.can_state.cont_flags.driver_safety_belt=0;
                else                  System.can_state.cont_flags.driver_safety_belt=1;
              }
            }
            break;

          case 0x639:
            {
              if(rx.data[2]!=0xFF)
              {
                if(rx.data[2]&(1<<1)) System.can_state.sec_flags.hood=1;
                else                  System.can_state.sec_flags.hood=0;
              }
            }
            break;

          case 0x4A5:
            {
              if(rx.data[4]!=0xFF)
              {
                if(rx.data[4]==0x00) _cls_state=LOCKED_CLS_STATE;
                else                 _cls_state=UNLOCKED_CLS_STATE;

                if(_cls_state==LOCKED_CLS_STATE)
                {
                  System.signal_state.cls_state.driver_door=0; System.signal_state.cls_state.l_rear_door=0; System.signal_state.cls_state.r_rear_door=0; System.signal_state.cls_state.pass_door=0;
                }
                else
                {
                  System.signal_state.cls_state.driver_door=1; System.signal_state.cls_state.l_rear_door=1; System.signal_state.cls_state.r_rear_door=1; System.signal_state.cls_state.pass_door=1;
                }

                System.signal_state.cls_state.driver_door_prepared=1;
                System.signal_state.cls_state.l_rear_door_prepared=1;
                System.signal_state.cls_state.r_rear_door_prepared=1;
                System.signal_state.cls_state.pass_door_prepared=1;
              }

              if(rx.data[2]!=0xFF)
              {
                if((rx.data[2]&0xF0)==0x00)      System.signal_state.key_position='O';
                else if((rx.data[2]&0xF0)==0x40) System.signal_state.key_position='A';
                else if((rx.data[2]&0xF0)==0xC0) System.signal_state.key_position='I';
                else                             System.signal_state.key_position='U';
              }
            }
            break;

          case 0x622:
            {
              if(rx.data[3]!=0xFF)
              {
                if(rx.data[3]&(1<<4)) System.can_state.cont_flags.marker_lights=1;
                else                  System.can_state.cont_flags.marker_lights=0;

                if(rx.data[3]&(1<<5)) System.can_state.cont_flags.dipped_beam=1;
                else                  System.can_state.cont_flags.dipped_beam=0;

                if(rx.data[3]&(1<<6)) System.can_state.cont_flags.high_beam=1;
                else                  System.can_state.cont_flags.high_beam=0;
              }
            }
            break;

          case 0x025:
            {
              //угол поворота руля
              int16_t val=(((rx.data[0]&0x0F)<<8)|((rx.data[1])<<0))<<4;//обратный код
              val=(val*-100)/(8*650);

              System.Grab(portMAX_DELAY);
              {
                System.can_state.numeric_data.battery_charge_level=val;//temporary
              }System.Release();
            }
            break;

          case 0x226:
            {
              //педаль тормоза
              uint16_t val=(rx.data[0]<<8)|(rx.data[1]<<0);

              if(rx.data[4]!=0xFF && val!=0xFFFF)
              {
                //педаль нажата
                if(rx.data[4]&(1<<5))
                {
                  val=0x0FFF&val;

                  System.can_state.numeric_data.brake=(val*100Ul)/(0x2D0);//temporary
                }
                else
                {
                  System.can_state.numeric_data.brake=0;
                }

              }
            }
            break;

          case 0x3B7:
            {
              if(rx.data[1]!=0xFF)
              {
                if(rx.data[1]&(1<<5)) System.can_state.cont_flags.esp=1;
                else                  System.can_state.cont_flags.esp=0;
              }
            }
            break;

          case 0x6E1:
            {
              //TMPS
              if(rx.data[5]!=0xFF)
              {

              }
            }
            break;

          case 0x614:
            {
              if(rx.data[3]!=0xFF)
              {
                if((rx.data[3]&(1<<3))) System.signal_state.emergency_lights=1;
                else                    System.signal_state.emergency_lights=0;
              }
            }
            break;

          case 0x610:
            {
              if(rx.data[4]!=0xFF)
              {
                if(passenger_present)
                {
                  if(rx.data[4]&(1<<6)) System.can_state.cont_flags.passenger_safety_belt=0;
                  else                  System.can_state.cont_flags.passenger_safety_belt=1;
                }
                else
                {
                  System.can_state.cont_flags.passenger_safety_belt=0;
                }
              }
            }
            break;

          case 0x638:
            {
              if(true/*rx.data[4]!=0xFF*/)
              {
                if(rx.data[4]&(1<<6)) System.signal_state.windows_position.driver_door=1;
                else                  System.signal_state.windows_position.driver_door=0;

                System.signal_state.windows_position.driver_door_prepared=1;

                if(rx.data[4]&(1<<4)) System.signal_state.windows_position.pass_door=1;
                else                  System.signal_state.windows_position.pass_door=0;

                System.signal_state.windows_position.pass_door_prepared=1;

                if(rx.data[4]&(1<<0)) System.signal_state.windows_position.l_rear_door=1;
                else                  System.signal_state.windows_position.l_rear_door=0;

                System.signal_state.windows_position.l_rear_door_prepared=1;

                if(rx.data[4]&(1<<2)) System.signal_state.windows_position.r_rear_door=1;
                else                  System.signal_state.windows_position.r_rear_door=0;

                System.signal_state.windows_position.r_rear_door_prepared=1;
              }
            }
            break;

          case 0x612:
            {
              //Датчик присутствия пассажира
              if(rx.data[4]!=0xFF)
              {
                if(rx.data[4]&(1<<4)) passenger_present=true;
                else                  passenger_present=false;
              }
            }
            break;

            case 0x7C8:
            {
              if(rx.data[0]==0x10 && rx.data[1]==0x09 && rx.data[2]==0x62)
              {
                if((rx.data[6]&(0xF0))==((0x07)&(0xF0))) System.signal_state.washer_liquid=0;
                else                                     System.signal_state.washer_liquid=1;
              }
            }
            break;

          default:
            break;
          }
        }//if(rx.id_type==STD_ID_TYPE)
      }
      else if(can_id==CAN2_ID)
      {
        //none
      }
      else if(can_id==CAN3_ID)
      {
        //none
      }
    }

    if(mess_count)
    {
      restart_sleep_and_rx_timers(can_id);
    }
  }

  System.can_state.sec_flags.can_in_sleep=can_sleep_indicate_handler();

  blocks_handler();

  toyota_rav4_2019_analog_to_can_handler();

  taxi_blocks_handler();
}

static void can_rx_bmw_520i_2018_handler(void)
{
  can_rx_frame_t rx;

  for(uint8_t can_id=CAN1_ID; can_id<HW_CAN_COUNT; can_id++)
  {
    uint16_t mess_count=filled_count_in_sfifo(&can_rx_sfifo[can_id]);

    for(uint16_t j=0; j<mess_count; j++)
    {
      if(!read_from_sfifo(&can_rx_sfifo[can_id], &rx))
      {
        __PRINTF("%s_RX sfifo is full, drop counter: %lu\n", get_name_from_can_id(can_id), can_rx_sfifo[can_id].drop_counter);
      }

#if defined(CAN_VEGA_FWD_PRESENT)
      rx_fwd_hadler(can_id, &rx);
#endif //defined(CAN_VEGA_FWD_PRESENT)

#if defined(YANDEX_OBD_PRESENT)
      obd_rx_handler(can_id, &rx);
#endif //defined(YANDEX_OBD_PRESENT)

      can_rx_debug_trace(&rx, can_id);

        if(can_id==CAN1_ID)
        {
          //Диагностический CAN, заходит на FRM в средний разъем, cиний с желтой полосой и синий с серой(?), 500 кбит\с
          if(rx.id_type==STD_ID_TYPE)
          {
            if(rx.id==0x612)
            {
            }
            else if(rx.id==0x03C)
            {
            }

          }//if(rx.id_type==STD_ID_TYPE)
        }
        else if(can_id==CAN2_ID)
        {
          //Моторный CAN, тонкий жгут в левой кик панели, заходит на FRM в средний разъем, желтый с черной полосой и желтый с белой полосой, 500 кбит\с
          if(rx.id_type==STD_ID_TYPE)
          {
            if(rx.id==0x0A5)
            {
              System.Grab(portMAX_DELAY);
              {
                System.can_state.numeric_data.eng_rpm=rx.data[6]*64UL;

                if(System.can_state.numeric_data.eng_rpm>350) System.can_state.sec_flags.engine_is_on=1;
                else                                          System.can_state.sec_flags.engine_is_on=0;
              }System.Release();
            }
            else if(rx.id==0x0C2)
            {
              System.Grab(portMAX_DELAY);
              {
                //System.can_state.numeric_data.thresher_rpm=(rx.data[3]<<8)|(rx.data[4]<<0);
                if(((rx.data[3]<<8)|(rx.data[4]<<0))<=0x646)       System.can_state.numeric_data.accelerator=0;
                else if(((rx.data[3]<<8)|(rx.data[4]<<0))>=0x1CFF) System.can_state.numeric_data.accelerator=100;
                else                                               System.can_state.numeric_data.accelerator=((((rx.data[3]<<8)|(rx.data[4]<<0))-0x646)*100Ul)/(0x1CFF-0x646);
              }System.Release();
            }
            else if(rx.id==0x0EF)
            {
                if(rx.data[6]==0x7D)  System.can_state.sec_flags.pedal_break=0;
                else                  System.can_state.sec_flags.pedal_break=1;
            }
            else if(rx.id==0x1B3)
            {
                if(System.signal_state.ignition && (rx.data[4]&0x0f)==0x00)  System.can_state.cont_flags.driver_safety_belt=1;
                else                                                         System.can_state.cont_flags.driver_safety_belt=0;

                if(rx.data[6]!=0xFF)
                {
                  //берем из другого ID, на 520i, 320d не проверяли
                  //if(rx.data[6]&(1<<3)) System.can_state.sec_flags.hand_break=1;
                  //else                  System.can_state.sec_flags.hand_break=0;
                }

                if(rx.data[4]!=0xFF)
                {
                  if(rx.data[4]&(1<<1)) System.can_state.cont_flags.airbag=1;
                  else                  System.can_state.cont_flags.airbag=0;

                  if(rx.data[4]&(1<<4)) System.can_state.cont_flags.check_engine=1;
                  else                  System.can_state.cont_flags.check_engine=0;
                }

                if(rx.data[1]!=0xFF)
                {
                  //надписи на экране, меняются поочередно
                  if(rx.data[1]==0x93)
                  {
                    System.can_state.cont_flags.inflation_pressure=1;
                    restart_can_timer(AUX_CAN_TIMER_1, 60000);
                  }

                  if(rx.data[1]==0x10)
                  {
                    System.can_state.cont_flags.serv_maint=1;
                    restart_can_timer(AUX_CAN_TIMER_2, 60000);
                  }

                  if(rx.data[1]==0xA4)
                  {
                    System.signal_state.washer_liquid=1;
                    restart_can_timer(AUX_CAN_TIMER_3, 60000);
                  }
                }
            }
            else if(rx.id==0x1F6)
            {
              if(rx.data[0]!=0xFF)
              {
                if((rx.data[0]&((1<<4)|(1<<5)))==((1<<4)|(1<<5))) System.signal_state.emergency_lights=1;
                else                                              System.signal_state.emergency_lights=0;
              }
            }
            else if(rx.id==0x3F9)
            {
              if(rx.data[4]<0xFE)
              {
                System.Grab(portMAX_DELAY);
                {
                  System.can_state.numeric_data.eng_temp=rx.data[4]-48.0f;
                }System.Release();
              }
            }
            else if(rx.id==0x0DC)
            {
              System.Grab(portMAX_DELAY);
              {
                /*
                XX XX 22 D0 07 EE  P
                XX XX 24 D0 07 E4  D
                XX XX 24 D0 07 EC  N
                XX XX 25 D0 07 E4  R
                XX XX 24 D0 07 E4  S1
                XX XX 22 D0 07 E8  M1 (в момент переключения?)
                */

                /*
                22 XX XX EE - P
                24 XX XX E4 - D, S, M
                22 XX XX EC - N
                25 XX XX E4 - R
                24 XX XX E8 - переключение
                */
                //System.can_state.numeric_data.can_axle_2=(rx.data[2]<<8)|(rx.data[5]<<0);

                if     (rx.data[2]==0x22 && rx.data[5]==0xEE) {System.can_state.sec_flags.parking=1; System.can_state.sec_flags.reverse_gear=0;}
                else if(rx.data[2]==0x25 && rx.data[5]==0xE4) {System.can_state.sec_flags.parking=0; System.can_state.sec_flags.reverse_gear=1;}
                else                                          {System.can_state.sec_flags.parking=0; System.can_state.sec_flags.reverse_gear=0;}

                if      (rx.data[2]==0x22 && rx.data[5]==0xEE) System.signal_state.selector_position='P';
                else if (rx.data[2]==0x25 && rx.data[5]==0xE4) System.signal_state.selector_position='R';
                else if (rx.data[2]==0x22 && rx.data[5]==0xEC) System.signal_state.selector_position='N';
                else if (rx.data[2]==0x24 && rx.data[5]==0xE4) System.signal_state.selector_position='D';
                //else if (rx.data[2]==0x24 && rx.data[5]==0xE4)  System.signal_state.selector_position='S';
                //else if (rx.data[2]== && rx.data[5]==0xE8)  System.signal_state.selector_position='M';
                else                       System.signal_state.selector_position='U';
              }System.Release();
            }
            else if(rx.id==0x0F3)
            {
              //System.Grab(portMAX_DELAY);
              //{
                //неправильно
                //if(rx.data[4]==0xC2)     {System.can_state.sec_flags.parking=0; System.can_state.sec_flags.reverse_gear=1;}
                //else                     {System.can_state.sec_flags.parking=0; System.can_state.sec_flags.reverse_gear=0;}
                //temp_parking=rx.data[4];

                /*
                if      (rx.data[5]==0xEE) System.signal_state.selector_position='P';
                else if (rx.data[5]==0xE4) System.signal_state.selector_position='R';
                else if (rx.data[5]==0xEC) System.signal_state.selector_position='N';
                else if (rx.data[5]==0xE4) System.signal_state.selector_position='D';
                //else if (rx.data[5]==) System.signal_state.selector_position='S';
                //else if (rx.data[5]==0x1A || rx.data[5]==0x09) System.signal_state.selector_position='M';
                */

              //}System.Release();
            }
            else if(rx.id==0x2B5)
            {
              if((rx.data[3]&0x0f)==0x01 || (rx.data[3]&0x0f)==0x04/*в процессе*/) System.can_state.sec_flags.hand_break=1;
              else                                                                 System.can_state.sec_flags.hand_break=0;
            }
            else if(rx.id==0x330)
            {
              uint32_t val;

              val=rx.data[3];

              if(val!=0xFF)
              {
                if(IS_BMW_320D())
                {
                  val=(val*100Ul)/40Ul;
                }
                else
                {
                  //дизельные 520D, 2020 WBA31DC030CF63300
                  if(memcmp("WBA31", System.signal_state.vin_sensor, sizeof("WBA31")-1)==0)
                  {
                    val=(val*100Ul)/58Ul;
                  }
                  else
                  {
                    val=(val*100Ul)/68Ul;
                  }
                }

                if(val>100) val=100;

                System.set_fuel_level_p(val);
              }

              val=(rx.data[2]<<16)|(rx.data[1]<<8)|(rx.data[0]<<0);

              if(val!=0xFFFFFF)
              {
                System.Grab(portMAX_DELAY);
                {
                  System.can_state.numeric_data.can_odo_km=val;
                }System.Release();
              }

              val=((rx.data[7]<<8)|(rx.data[6]<<0))>>4;

              if(val!=0x0FFF)
              {
                System.Grab(portMAX_DELAY);
                {
                  //запас хода, расстоние до пустого бака
                  System.can_state.numeric_data.fuel_lev_l=val;
                }System.Release();
              }
            }
            else if(rx.id==0x12F)
            {
                if(rx.data[2]==0xFA) System.can_state.sec_flags.ignition=1;
                else                 System.can_state.sec_flags.ignition=0;
            }
            else if(rx.id==0x21A)
            {
                if(rx.data[0]==0x04)  System.can_state.cont_flags.marker_lights=1;
                else                  System.can_state.cont_flags.marker_lights=0;

                if(rx.data[0]==0x05)  System.can_state.cont_flags.dipped_beam=1;
                else                  System.can_state.cont_flags.dipped_beam=0;

                if(rx.data[0]==0x07)  System.can_state.cont_flags.high_beam=1;
                else                  System.can_state.cont_flags.high_beam=0;
            }
            else if(rx.id==0x2FC)
            {
              /*
              ID  DO
              2FC 83 цз был закрыт, но была эмуляция двери или открыли дверь изнутри
              2FC 11 цз открывается из открытого
              2FC 12 цз открывается из закрытого
              2FC 81 цз открыт
              2FC 22 цз закрывается из закрытого
              2FC 82 цз закрыт
              */
              if(rx.data[0]==0x81)      _cls_state=UNLOCKED_CLS_STATE;
              else if(rx.data[0]==0x82) _cls_state=LOCKED_CLS_STATE;
              else if(rx.data[0]==0x83) _cls_state=UNKNOWN_CLS_STATE;

              //System.can_state.numeric_data.can_axle_1=(rx.data[0]<<8)|(rx.data[1]<<0);

              if(rx.data[1]&(1<<0))    System.can_state.sec_flags.driver_door=1;
              else                     System.can_state.sec_flags.driver_door=0;

              if(rx.data[1]&(1<<2))    System.can_state.sec_flags.pass_door=1;
              else                     System.can_state.sec_flags.pass_door=0;

              if(rx.data[1]&(1<<4))    System.can_state.sec_flags.l_rear_door=1;
              else                     System.can_state.sec_flags.l_rear_door=0;

              if(rx.data[1]&(1<<6))    System.can_state.sec_flags.r_rear_door=1;
              else                     System.can_state.sec_flags.r_rear_door=0;

              if(rx.data[2]&(1<<0))    System.can_state.sec_flags.trunk=1;
              else                     System.can_state.sec_flags.trunk=0;

              if(rx.data[2]&(1<<2))    System.can_state.sec_flags.hood=1;
              else                     System.can_state.sec_flags.hood=0;
            }
            else if(rx.id==0x581)
            {
                //if(rx.data[0]==0x40 && rx.data[1]==0xB5 && rx.data[2]==0x00 && rx.data[3]==0x29) System.can_state.cont_flags.airbag=1;
                //else                                                                             System.can_state.cont_flags.airbag=0;
            }
            else if(rx.id==0x1A1)
            {
              uint16_t val=((rx.data[3]<<8)|(rx.data[2]<<0));

              if(val!=0xFFFF)
              {
                val=(val*15)/1000;

                System.can_state.numeric_data.can_speed=val;
              }
            }
            else if (rx.id == 0x302)
            {
              //положение руля
              int32_t angle = ((rx.data[2]) << 8) | ((rx.data[3]) << 0);
              System.can_state.numeric_data.battery_charge_level = angle;//temporary
            }

          }//if(rx.id_type==STD_ID_TYPE)
        }
        else if(can_id==CAN3_ID)
        {
          //none
        }
    }

    if(mess_count)
    {
      restart_sleep_and_rx_timers(can_id);
    }
  }

  System.can_state.sec_flags.can_in_sleep=can_sleep_indicate_handler();

  blocks_handler();

  bmw_520i_analog_to_can_handler();

  taxi_blocks_handler();
}

static void can_rx_ford_transit_2017_handler(void)
{
  can_rx_frame_t rx;

  for(uint8_t can_id=CAN1_ID; can_id<HW_CAN_COUNT; can_id++)
  {
    uint16_t mess_count=filled_count_in_sfifo(&can_rx_sfifo[can_id]);

    for(uint16_t j=0; j<mess_count; j++)
    {
      if(!read_from_sfifo(&can_rx_sfifo[can_id], &rx))
      {
        __PRINTF("%s_RX sfifo is full, drop counter: %lu\n", get_name_from_can_id(can_id), can_rx_sfifo[can_id].drop_counter);
      }

#if defined(CAN_VEGA_FWD_PRESENT)
      rx_fwd_hadler(can_id, &rx);
#endif //defined(CAN_VEGA_FWD_PRESENT)

#if defined(YANDEX_OBD_PRESENT)
      obd_rx_handler(can_id, &rx);
#endif //defined(YANDEX_OBD_PRESENT)

      can_rx_debug_trace(&rx, can_id);

        if(can_id==CAN1_ID)
        {
          //Salon CAN, 125 кбит\с
          if(rx.id_type==STD_ID_TYPE)
          {
            if(rx.id==0x127)
            {
              if(rx.data[1]!=0xFF)
              {
                if(rx.data[1]&(1<<4)) System.can_state.sec_flags.ignition=1;
                else                  System.can_state.sec_flags.ignition=0;

                if(rx.data[1]&(1<<7)) System.can_state.cont_flags.high_beam=1;
                else                  System.can_state.cont_flags.high_beam=0;

                if((rx.data[1]&0x03)==0x03)
                {
                  System.signal_state.emergency_lights=1;
                  restart_can_timer(EMERG_LIGHT_FIX_TIMER, 2500);
                }
              }
            }
            else if(rx.id==0x080)
            {
              if(((rx.data[6]<<8)|(rx.data[7]<<0))!=0xffff)
              {
                System.Grab(portMAX_DELAY);
                {
                  //800rpm  0x01A4
                  //2000rpm 0x03D0
                  System.can_state.numeric_data.eng_rpm=(((rx.data[6]<<8)|(rx.data[7]<<0))*2UL);

                  if(System.can_state.numeric_data.eng_rpm>350) System.can_state.sec_flags.engine_is_on=1;
                  else                                          System.can_state.sec_flags.engine_is_on=0;

                }System.Release();
              }
            }
            else if(rx.id==0x0F1)
            {
              if(rx.data[0]!=0xFF)
              {
                if(rx.data[0]&(1<<5)) System.can_state.sec_flags.hand_break=1;
                else                  System.can_state.sec_flags.hand_break=0;
              }
            }
            else if(rx.id==0x102)
            {
              if(rx.data[2]!=0xFF)
              {
                //SRS
                if(rx.data[2]==0xFD) System.can_state.cont_flags.airbag=1;
                else                 System.can_state.cont_flags.airbag=0;
              }
            }
            else if(rx.id==0x10D)
            {
              if(rx.data[6]!=0xFF)
              {
                if(rx.data[6]&(1<<2)) System.can_state.sec_flags.driver_door=0;
                else                  System.can_state.sec_flags.driver_door=1;

                if(rx.data[6]&(1<<3)) System.can_state.sec_flags.pass_door=0;
                else                  System.can_state.sec_flags.pass_door=1;

                //if(rx.data[6]&(1<<4)) System.can_state.sec_flags.l_rear_door=0;
                //else                  System.can_state.sec_flags.l_rear_door=1;

                //if(rx.data[6]&(1<<6)) System.can_state.sec_flags.r_rear_door=0;
                //else                  System.can_state.sec_flags.r_rear_door=1;

                //if(rx.data[6]&(1<<0))  System.can_state.sec_flags.trunk=0;
                //else                   System.can_state.sec_flags.trunk=1;

                //if(rx.data[6]&(1<<2))  System.can_state.sec_flags.hood=0;
                //else                   System.can_state.sec_flags.hood=1;
              }
            }
            else if(rx.id==0x0B9)
            {
              if(rx.data[0]!=0xFF)
              {
                if(rx.data[0]&(1<<3)) System.can_state.cont_flags.marker_lights=1;
                else                  System.can_state.cont_flags.marker_lights=0;

                if(rx.data[0]&(1<<4)) System.can_state.cont_flags.dipped_beam=1;
                else                  System.can_state.cont_flags.dipped_beam=0;
              }
            }
            else if(rx.id==0x320)
            {
              if(rx.data[2]!=0xFF)
              {
                if(rx.data[2]==0xEF || rx.data[2]==0xCB)      System.can_state.cont_flags.driver_safety_belt=1;
                else if(rx.data[2]==0xD3 || rx.data[2]==0xA7) System.can_state.cont_flags.driver_safety_belt=0;
              }
            }
          }//if(rx.id_type==STD_ID_TYPE)
        }
        else if(can_id==CAN2_ID)
        {
          //Моторный CAN, 500 кбит\с
          if(rx.id_type==STD_ID_TYPE)
          {
            if(rx.id==0x7E8)
            {
              //OBDII ответ
              if(rx.data[0]==0x03 &&  rx.data[1]==0x41 && rx.data[2]==0x05)
              {
                System.Grab(portMAX_DELAY);
                {
                  System.can_state.numeric_data.eng_temp=rx.data[3]-40.0f;
                }System.Release();
              }
            }
            else if(rx.id==0x010)
            {
              //Положение руля
              if(rx.data[4]==0x00 || rx.data[4]==0x80)//руль не крутят, этот байт показывает воздействие на руль
              {
                if(rx.data[6]>=0x80)
                {
                  rx.data[6]-=0x80;
                  System.Grab(portMAX_DELAY);
                  {
                    System.can_state.numeric_data.battery_charge_level=((rx.data[6])*100Ul)/(0xB7-0x80);
                    if(rx.data[4]==0x00) System.can_state.numeric_data.battery_charge_level*=-1;
                  }System.Release();
                }
              }
            }
            else if(rx.id==0x122)
            {
              //байты 0, 1 - резкость нажатия
              uint16_t val=0x3FF&((rx.data[2]<<8)|(rx.data[3]<<0));
              if(val<=0x3E7)
              {
                System.can_state.numeric_data.accelerator=((val)*100Ul)/(0x3E7);
              }
            }
            else if(rx.id==0x211)
            {
              if(rx.data[1]!=0xFF)
              {
                //меняется 0xX0-0xXB
                rx.data[1]=0x0F&(rx.data[1]);

                //этот байт беспорядочно меняется при нажатии на педаль
                if(rx.data[2]==0x00) System.can_state.sec_flags.pedal_break=0;
                else                 System.can_state.sec_flags.pedal_break=1;

                System.can_state.numeric_data.brake=((rx.data[1])*100Ul)/(0x0B);
              }
            }
            /*
            else if(rx.id==0x115)
            {
              if(((rx.data[4]<<8)|(rx.data[5]<<0))!=0xffff)
              {
                System.Grab(portMAX_DELAY);
                {
                  //System.can_state.numeric_data.can_speed=rx.data[6];
                  //temp_speed=rx.data[6];

                  //при выключении зажигания, обороты остаются
                  //800rpm  0x01A4
                  //2000rpm 0x03D0
                  System.can_state.numeric_data.eng_rpm=(((rx.data[4]<<8)|(rx.data[5]<<0))*2UL);

                  if(System.can_state.numeric_data.eng_rpm>350) System.can_state.sec_flags.engine_is_on=1;
                  else                                          System.can_state.sec_flags.engine_is_on=0;

                }System.Release();
              }
            }
            */
            else if(rx.id==0x254)
            {
              /*
              if((rx.data[6])!=0xff)
              {
                System.Grab(portMAX_DELAY);
                {
                  System.can_state.numeric_data.can_speed=5*rx.data[6];
                  temp_speed=5*rx.data[6];
                }System.Release();
              }
              */
            }
            else if(rx.id==0x170)
            {
              uint8_t val=rx.data[0];

              if(val!=0xFF)
              {
                System.can_state.numeric_data.can_speed=(val&0x7F)*3;
              }
            }
            else if(rx.id==0x264)
            {
              uint16_t val=(rx.data[6]<<8)|(rx.data[7]<<0);

              if(val!=0xFFFF)
              {
                val=val&0x01FF;
                System.set_fuel_level_p(val/4);
              }
            }
            else if(rx.id==0x342)
            {
              uint32_t val=(rx.data[5]<<16)|(rx.data[6]<<8)|(rx.data[7]<<0);

              if(val!=0xffffff)
              {
                System.Grab(portMAX_DELAY);
                {
                  System.can_state.numeric_data.can_odo_km=val;
                }System.Release();
              }
            }
            else if(rx.id==0x494)
            {
              if(rx.data[5]!=0xFF)
              {
                if(rx.data[5]==0xD4) System.can_state.cont_flags.high_beam=1;
                else                 System.can_state.cont_flags.high_beam=0;
              }
            }
            else if(rx.id==0x299)
            {
              if(rx.data[4]!=0xFF)
              {
                if(rx.data[4]==0x60) System.can_state.cont_flags.check_engine=1;
                else                 System.can_state.cont_flags.check_engine=0;
              }
            }
          }//if(rx.id_type==STD_ID_TYPE)
        }
        else if(can_id==CAN3_ID)
        {
          //none
        }
    }

    if(mess_count)
    {
      restart_sleep_and_rx_timers(can_id);
    }
  }

  System.can_state.sec_flags.can_in_sleep=can_sleep_indicate_handler();

  blocks_handler();

  ford_transit_analog_to_can_handler();

  taxi_blocks_handler();
}

static void can_rx_citroen_jumpy_2018_handler(void)
{
  can_rx_frame_t rx;

  for(uint8_t can_id=CAN1_ID; can_id<HW_CAN_COUNT; can_id++)
  {
    uint16_t mess_count=filled_count_in_sfifo(&can_rx_sfifo[can_id]);

    for(uint16_t j=0; j<mess_count; j++)
    {
      if(!read_from_sfifo(&can_rx_sfifo[can_id], &rx))
      {
        __PRINTF("%s_RX sfifo is full, drop counter: %lu\n", get_name_from_can_id(can_id), can_rx_sfifo[can_id].drop_counter);
      }

#if defined(CAN_VEGA_FWD_PRESENT)
      rx_fwd_hadler(can_id, &rx);
#endif //defined(CAN_VEGA_FWD_PRESENT)

#if defined(YANDEX_OBD_PRESENT)
      obd_rx_handler(can_id, &rx);
#endif //defined(YANDEX_OBD_PRESENT)

      can_rx_debug_trace(&rx, can_id);

        if(can_id==CAN1_ID)
        {
          //Salon CAN, 125 кбит\с
          if(rx.id_type==STD_ID_TYPE)
          {
            if(rx.id==0x161)
            {
              if(rx.data[3]!=0xFF)
              {
                uint8_t var=(rx.data[3]*100Ul)/0x60Ul;
                if(var>100) var=100;

                System.set_fuel_level_p(var);
              }
            }
            else if(rx.id==0x128)
            {
              if(rx.data[0]!=0xFF)
              {
                //if(rx.data[0]&(1<<7)) System.can_state.cont_flags.marker_lights=1;
                //else                  System.can_state.cont_flags.marker_lights=0;

                if(rx.data[0]&(1<<6)) System.can_state.cont_flags.dipped_beam=1;
                else                  System.can_state.cont_flags.dipped_beam=0;

                if(rx.data[0]&(1<<5)) System.can_state.cont_flags.high_beam=1;
                else                  System.can_state.cont_flags.high_beam=0;
              }

              if(rx.data[6]!=0xFF)
              {
                if(rx.data[6]&(1<<1)) System.signal_state.emergency_lights=1;
                else                  System.signal_state.emergency_lights=0;
              }

              if(!IS_CITROEN_JUMPY_WITH_MANUAL_GEARBOX())
              {
                if(rx.data[1]!=0xFF)
                {
                  System.Grab(portMAX_DELAY);
                  {
                    if((rx.data[1]&0xf0)==0x00)      {System.can_state.sec_flags.parking=1; System.can_state.sec_flags.reverse_gear=0;}
                    else if((rx.data[1]&0xf0)==0x10) {System.can_state.sec_flags.parking=0; System.can_state.sec_flags.reverse_gear=1;}
                    else                             {System.can_state.sec_flags.parking=0; System.can_state.sec_flags.reverse_gear=0;}

                    uint8_t selector_position = (rx.data[1] & 0xF0);

                    if(selector_position==0x00)       System.signal_state.selector_position='P';
                    else if (selector_position==0x10) System.signal_state.selector_position='R';
                    else if (selector_position==0x20) System.signal_state.selector_position='N';
                    else if (selector_position==0x30) System.signal_state.selector_position='D';
                    else if (selector_position==0x90 || selector_position==0x80 || selector_position==0x70) System.signal_state.selector_position='M';
                    else                              System.signal_state.selector_position='U';
                  }System.Release();
                }
              }

              System.can_state.numeric_data.ad_blue_l=rx.data[3];
              if(rx.data[3]!=0xFF)
              {
                //сдесь похоже и другие индикаторы
                //ручник опущен:
                //0x20-заглушена
                //0xE2-некторое время после включения зажигания
                //0x22-заведена или вкл зажигание
                //ручник затянут:
                //0x20-заглушена
                //0xE2-некторое время после включения зажигания
                //0x22-заведена или вкл зажигание
                if(rx.data[3]&(1<<1)) System.can_state.sec_flags.hand_break=1;
                else                  System.can_state.sec_flags.hand_break=0;
              }
            }
            else if(rx.id==0x168)
            {
              if(rx.data[0]&(1<<3)) System.can_state.cont_flags.chek_oil=1;
              else                  System.can_state.cont_flags.chek_oil=0;

              if((rx.data[0]&(1<<5)) || (rx.data[0]&(1<<7))) System.can_state.cont_flags.chek_coolant=1;
              else                                           System.can_state.cont_flags.chek_coolant=0;

              if(rx.data[1]&(1<<4)) System.can_state.cont_flags.fap=1;
              else                  System.can_state.cont_flags.fap=0;

              if(rx.data[1]&(1<<7)) System.can_state.cont_flags.inflation_pressure=1;
              else                  System.can_state.cont_flags.inflation_pressure=0;

              if(rx.data[2]&(1<<0)) System.can_state.cont_flags.battery=1;
              else                  System.can_state.cont_flags.battery=0;

              //есть в 7м и в 3м байте, индикация разная
              if((rx.data[6]&(1<<0)) || (rx.data[2]&(1<<7))) System.can_state.cont_flags.chek_brake_pads=1;
              else                                           System.can_state.cont_flags.chek_brake_pads=0;

              //if(rx.data[2]&(1<<5)) System.can_state.cont_flags.driver_safety_belt=1;
              //else                  System.can_state.cont_flags.driver_safety_belt=0;

              //всегда горит
              //if((rx.data[3]&(1<<0)) || (rx.data[3]&(1<<1))) System.can_state.cont_flags.check_engine=1;
              //else                                           System.can_state.cont_flags.check_engine=0;

              if(rx.data[3]&(1<<4)) System.can_state.cont_flags.esp=1;
              else                  System.can_state.cont_flags.esp=0;

              if(rx.data[3]&(1<<5)) System.can_state.cont_flags.abs=1;
              else                  System.can_state.cont_flags.abs=0;

              if(rx.data[4]&(1<<5)) System.can_state.cont_flags.airbag=1;
              else                  System.can_state.cont_flags.airbag=0;

              if(rx.data[4]&(1<<7)) System.can_state.cont_flags.warning=1;
              else                  System.can_state.cont_flags.warning=0;
            }
            else if(rx.id==0x0F6)
            {
              if(rx.data[0]!=0xFF)
              {
                if(rx.data[0]&(1<<3)) System.can_state.sec_flags.ignition=1;
                else                  System.can_state.sec_flags.ignition=0;
              }

              if(rx.data[1]!=0xFF)
              {
                System.Grab(portMAX_DELAY);
                {
                  System.can_state.numeric_data.eng_temp=rx.data[1]-40.0f;
                }System.Release();
              }

              uint32_t val=((rx.data[2]<<16)|(rx.data[3]<<8)|(rx.data[4]<<0));
              if(val!=0xffffff)
              {
                System.Grab(portMAX_DELAY);
                {
                  System.can_state.numeric_data.can_odo_km=val/10.0f;
                }System.Release();
              }
            }
            else if(rx.id==0x276)
            {

            }
            else if(rx.id==0x0B6)
            {
              uint16_t val=((rx.data[2]<<8)|(rx.data[3]<<0));

              if(val!=0xFFFF)
              {
                val=val/100;
                System.can_state.numeric_data.can_speed=val;
              }
            }
            else if(rx.id==0x2AD)
            {
              if(rx.data[0]!=0xFF)
              {
                if(rx.data[0]&(1<<7)) _cls_state=LOCKED_CLS_STATE;
                else                  _cls_state=UNLOCKED_CLS_STATE;

                if(_cls_state==LOCKED_CLS_STATE)
                {
                  System.signal_state.cls_state.driver_door=0; System.signal_state.cls_state.l_rear_door=0; System.signal_state.cls_state.r_rear_door=0; System.signal_state.cls_state.pass_door=0;
                }
                else
                {
                  System.signal_state.cls_state.driver_door=1; System.signal_state.cls_state.l_rear_door=1; System.signal_state.cls_state.r_rear_door=1; System.signal_state.cls_state.pass_door=1;
                }

                System.signal_state.cls_state.driver_door_prepared=1;
                System.signal_state.cls_state.l_rear_door_prepared=1;
                System.signal_state.cls_state.r_rear_door_prepared=1;
                System.signal_state.cls_state.pass_door_prepared=1;
              }
            }
            else if(rx.id==0x221)
            {
              //запас хода
              uint16_t val=0x0FFF&((rx.data[3]<<8)|(rx.data[4]<<0));

              if(val<0x0FFE)
              {
                System.Grab(portMAX_DELAY);
                {
                  System.can_state.numeric_data.fuel_lev_l=val;
                }System.Release();
              }
            }
          }//if(rx.id_type==STD_ID_TYPE)
        }
        else if(can_id==CAN2_ID)
        {
          //Моторный CAN, 500 кбит\с
          if(rx.id_type==STD_ID_TYPE)
          {
            if(rx.id==0x349)
            {

            }
            else if(rx.id==0x412)
            {
              //Опрашивается по аналогу в jumpy_analog_to_can_handler, т.к. CAN машины не просыпается по концевмикам
              /*
              if(rx.data[6]!=0xFF)
              {
                if(rx.data[6]&(1<<3)) System.can_state.sec_flags.driver_door=0;
                else                  System.can_state.sec_flags.driver_door=1;

                if(rx.data[6]&(1<<4)) System.can_state.sec_flags.pass_door=0;
                else                  System.can_state.sec_flags.pass_door=1;

                if(rx.data[6]&(1<<6)) System.can_state.sec_flags.l_rear_door=0;
                else                  System.can_state.sec_flags.l_rear_door=1;

                //if(rx.data[6]&(1<<6)) System.can_state.sec_flags.r_rear_door=0;
                //else                  System.can_state.sec_flags.r_rear_door=1;

                if(rx.data[6]&(1<<7)) System.can_state.sec_flags.trunk=0;
                else                  System.can_state.sec_flags.trunk=1;

                //if(rx.data[6]&(1<<2)) System.can_state.sec_flags.hood=0;
                //else                  System.can_state.sec_flags.hood=1;
              }
              */
            }
            else if(rx.id==0x2E8)
            {
              if(rx.data[1]!=0xFF)
              {
                System.can_state.numeric_data.accelerator=((rx.data[1])*100Ul)/(0xC7);
              }
            }
            else if(rx.id==0x208)
            {
              if(((rx.data[0]<<8)|(rx.data[1]<<0))!=0xFFFF)
              {
                System.Grab(portMAX_DELAY);
                {
                  System.can_state.numeric_data.eng_rpm=(((rx.data[0]<<8)|(rx.data[1]<<0))/8UL);

                  if(System.can_state.numeric_data.eng_rpm>350) System.can_state.sec_flags.engine_is_on=1;
                  else                                          System.can_state.sec_flags.engine_is_on=0;
                }System.Release();
              }

              if(rx.data[4]!=0xFF)
              {
                if(rx.data[4]&(1<<1)) System.can_state.sec_flags.pedal_break=1;
                else                  System.can_state.sec_flags.pedal_break=0;
              }
            }
            else if(rx.id==0x3CD)
            {
              //Педаль тормоза
              //System.can_state.numeric_data.can_axle_1=rx.data[5];//0x22-0x70
              //System.can_state.numeric_data.can_axle_2=rx.data[6];//0x60-0x91
            }
            else if(rx.id==0x305)
            {
              //Положение руля
            }
            else if(rx.id==0x572)
            {
              if(rx.data[0]!=0xFF)
              {
                if(rx.data[0]&(1<<7)) System.can_state.cont_flags.driver_safety_belt=1;
                else                  System.can_state.cont_flags.driver_safety_belt=0;

                if(rx.data[0]&(1<<5)) System.can_state.cont_flags.passenger_safety_belt=1;
                else                  System.can_state.cont_flags.passenger_safety_belt=0;
              }
            }
          }//if(rx.id_type==STD_ID_TYPE)
        }
        else if(can_id==CAN3_ID)
        {
          //none
        }
    }

    if(mess_count)
    {
      restart_sleep_and_rx_timers(can_id);
    }
  }

  //timers handle
  System.can_state.sec_flags.can_in_sleep=can_sleep_indicate_handler();

  blocks_handler();

  jumpy_analog_to_can_handler();

  taxi_blocks_handler();
}

static void can_rx_nissan_leaf_2019_handler(void)
{
  can_rx_frame_t rx;

  for(uint8_t can_id=CAN1_ID; can_id<HW_CAN_COUNT; can_id++)
  {
    uint16_t mess_count=filled_count_in_sfifo(&can_rx_sfifo[can_id]);

    for(uint16_t j=0; j<mess_count; j++)
    {
      if(!read_from_sfifo(&can_rx_sfifo[can_id], &rx))
      {
        __PRINTF("%s_RX sfifo is full, drop counter: %lu\n", get_name_from_can_id(can_id), can_rx_sfifo[can_id].drop_counter);
      }

#if defined(CAN_VEGA_FWD_PRESENT)
      rx_fwd_hadler(can_id, &rx);
#endif //defined(CAN_VEGA_FWD_PRESENT)

#if defined(YANDEX_OBD_PRESENT)
      obd_rx_handler(can_id, &rx);
#endif //defined(YANDEX_OBD_PRESENT)

      can_rx_debug_trace(&rx, can_id);

      if(can_id==CAN1_ID)
      {
        //OBD CAN, 500 кбит\с
        if(rx.id_type==STD_ID_TYPE)
        {
          switch(rx.id)
          {
          case 0x421:
            {
              if(rx.data[0]!=0xFF)
              {
                System.Grab(portMAX_DELAY);
                {
                  if(rx.data[0]==0x08)      {System.can_state.sec_flags.parking=1; System.can_state.sec_flags.reverse_gear=0;}
                  else if(rx.data[0]==0x10) {System.can_state.sec_flags.parking=0; System.can_state.sec_flags.reverse_gear=1;}
                  else                      {System.can_state.sec_flags.parking=0; System.can_state.sec_flags.reverse_gear=0;}

                  if(rx.data[0]==0x08)      System.signal_state.selector_position='P';
                  else if(rx.data[0]==0x10) System.signal_state.selector_position='R';
                  else if(rx.data[0]==0x18) System.signal_state.selector_position='N';
                  else if(rx.data[0]==0x20) System.signal_state.selector_position='D';
                  else                      System.signal_state.selector_position='U';
                }System.Release();
              }
              break;
            }
          case 0x5C5:
            {
              if(rx.data[0]!=0xFF)
              {
                //не работает без зажигания
                if(rx.data[0]&(1<<2)) System.can_state.sec_flags.hand_break=1;
                else                  System.can_state.sec_flags.hand_break=0;
              }

              uint32_t val=((rx.data[1]<<16)|(rx.data[2]<<8)|(rx.data[3]<<0));

              if(val!=0xFFFFFF)
              {
                System.Grab(portMAX_DELAY);
                {
                  System.can_state.numeric_data.can_odo_km=val;
                }System.Release();
              }
              break;
            }
          case 0x284:
            {
              uint16_t val=((rx.data[4]<<8)|(rx.data[5]<<0));

              if(val!=0xFFFF)
              {
                val=val/100;
                System.can_state.numeric_data.can_speed=val;
              }
              break;
            }
          case 0x5B3:
            {
              //Температура батареи
              if(rx.data[1]!=0xFF)
              {
                uint8_t val=(rx.data[1]*100Ul)/0xDD;

                System.Grab(portMAX_DELAY);
                {
                  System.can_state.numeric_data.battery_temperature=val;
                }System.Release();
              }

              //Заряд батареи
              if(rx.data[6]!=0xFF)
              {
                /*
                показывает 108 при полном заряде
                uint8_t val=(rx.data[6]*100Ul)/0xDD;

                System.Grab(portMAX_DELAY);
                {
                System.can_state.numeric_data.battery_charge_level=val;
              }System.Release();
                */
              }
              break;
            }
          case 0x5A9:
            {
              if(rx.data[0]!=0x7F)
              {
                //запас хода
                uint16_t val=0x0FFF&((rx.data[1]<<8)|(rx.data[2]<<0));

                //if(val!=0x0FFF && val!=0x0FFE)
                if(val<4000)
                {
                  val=val/8;

                  System.Grab(portMAX_DELAY);
                  {
                    System.can_state.numeric_data.fuel_lev_l=val;
                  }System.Release();
                }
              }
              break;
            }
          case 0x60D:
            {
              if(rx.data[0]!=0xFF)
              {
                if(rx.data[0]&(1<<3)) System.can_state.sec_flags.driver_door=1;
                else                  System.can_state.sec_flags.driver_door=0;

                if(rx.data[0]&(1<<4)) System.can_state.sec_flags.pass_door=1;
                else                  System.can_state.sec_flags.pass_door=0;

                if(rx.data[0]&(1<<5)) System.can_state.sec_flags.l_rear_door=1;
                else                  System.can_state.sec_flags.l_rear_door=0;

                if(rx.data[0]&(1<<6)) System.can_state.sec_flags.r_rear_door=1;
                else                  System.can_state.sec_flags.r_rear_door=0;

                if(rx.data[0]&(1<<7)) System.can_state.sec_flags.trunk=1;
                else                  System.can_state.sec_flags.trunk=0;

                if(rx.data[0]&(1<<3)) System.can_state.cont_flags.marker_lights=1;
                else                  System.can_state.cont_flags.marker_lights=0;
              }

              if(rx.data[1]!=0xFF)
              {
                if(rx.data[1]&(1<<2)) System.can_state.cont_flags.dipped_beam=1;
                else                  System.can_state.cont_flags.dipped_beam=0;

                if(rx.data[1]&(1<<3)) System.can_state.cont_flags.high_beam=1;
                else                  System.can_state.cont_flags.high_beam=0;

                //if((rx.data[1]&0x0f)==0x06) System.can_state.sec_flags.ignition=1;
                //else                        System.can_state.sec_flags.ignition=0;
              }

              break;
            }
          case 0x354:
            {
              if(rx.data[4]!=0xFF)
              {
                if(rx.data[4]&(1<<3))      System.can_state.cont_flags.abs=1;
                else if(rx.data[4]&(1<<4)) System.can_state.cont_flags.abs=1;
                else                       System.can_state.cont_flags.abs=0;

                if(rx.data[4]&(1<<7)) System.can_state.cont_flags.esp=1;
                else                  System.can_state.cont_flags.esp=0;
              }
              break;
            }
          case 0x50D:
            {
              if(rx.data[0]!=0xFF && rx.data[0]!=0xFE)
              {
                System.can_state.numeric_data.battery_charge_level=rx.data[0];
                System.set_fuel_level_p(rx.data[0]);
              }

              break;
            }
          case 0x510:
            {
              break;
            }
          case 0x002:
            {
              //угол поворота руля
              break;
            }
          case 0x180:
            {
              if(rx.data[5]!=0xFF)
              {
                System.can_state.numeric_data.accelerator=(rx.data[5]*100Ul)/0xC7;
              }
              break;
            }
          case 0x1CB:
            {
              if(rx.data[3]!=0xFF)
              {
                if(rx.data[3]&(1<<2)) System.can_state.sec_flags.pedal_break=1;
                else                  System.can_state.sec_flags.pedal_break=0;
              }
              break;
            }
          case 0x551:
            {
              if(rx.data[6]!=0xFF)
              {
                if(rx.data[6]&(1<<6)) System.signal_state.eco_mode=1;
                else                  System.signal_state.eco_mode=0;

                System.can_state.numeric_data.can_axle_1=System.signal_state.eco_mode;//temporary
              }
              break;
            }
          case 0x559:
            {
              if(rx.data[0]!=0xFF)
              {
                //if(rx.data[0]&(1<<7)) System.signal_state.tank_flap=0; //0x80
                //else                  System.signal_state.tank_flap=1; //0x40

                //System.can_state.numeric_data.can_axle_2=System.signal_state.tank_flap;//temporary
              }
              break;
            }
          case 0x390:
            {
              if(rx.data[3]!=0xFF)
              {
                if((rx.data[3]&0x32)==0x32) System.can_state.sec_flags.battery_charging=1;
                else                        System.can_state.sec_flags.battery_charging=0;

                if((rx.data[3]&0x20)==0x20) System.can_state.sec_flags.charge_cable_present=1;
                else                        System.can_state.sec_flags.charge_cable_present=0;
              }

              break;
            }
          case 0x351:
            {
              if(rx.data[5]!=0xFF && rx.data[7]!=0xFF)
              {
                if((rx.data[7]&(1<<1))) System.can_state.sec_flags.ignition=1;
                else                    System.can_state.sec_flags.ignition=0;

                if(!(rx.data[5]&(1<<1)) && (rx.data[7]&(1<<1))) System.can_state.cont_flags.ready_for_motion=1;
                else                                            System.can_state.cont_flags.ready_for_motion=0;

                System.can_state.sec_flags.engine_is_on=System.can_state.cont_flags.ready_for_motion;
              }

              break;
            }
          default:
            {
              break;
            }
          }
        }//if(rx.id_type==STD_ID_TYPE)
      }
      else if(can_id==CAN2_ID)
      {
        //none
      }
      else if(can_id==CAN3_ID)
      {
        //none
      }
    }

    if(mess_count)
    {
      restart_sleep_and_rx_timers(can_id);
    }
  }

  System.can_state.sec_flags.can_in_sleep=can_sleep_indicate_handler();

  blocks_handler();

  nissan_leaf_analog_to_can_handler();

  taxi_blocks_handler();
}

static void can_rx_hyundai_sonata_sd_2020_handler(void)
{
  can_rx_frame_t rx;

  for(uint8_t can_id=CAN1_ID; can_id<HW_CAN_COUNT; can_id++)
  {
    uint16_t mess_count=filled_count_in_sfifo(&can_rx_sfifo[can_id]);

    for(uint16_t j=0; j<mess_count; j++)
    {
      if(!read_from_sfifo(&can_rx_sfifo[can_id], &rx))
      {
        __PRINTF("%s_RX sfifo is full, drop counter: %lu\n", get_name_from_can_id(can_id), can_rx_sfifo[can_id].drop_counter);
      }

#if defined(CAN_VEGA_FWD_PRESENT)
      rx_fwd_hadler(can_id, &rx);
#endif //defined(CAN_VEGA_FWD_PRESENT)

#if defined(YANDEX_OBD_PRESENT)
      obd_rx_handler(can_id, &rx);
#endif //defined(YANDEX_OBD_PRESENT)

      can_rx_debug_trace(&rx, can_id);

      if(can_id==CAN1_ID)
      {
        //500 кбит\с
        if(rx.id_type==STD_ID_TYPE)
        {
          switch(rx.id)
          {
          case 0x080:
            {
              uint16_t val=(rx.data[3]<<8)|(rx.data[2]<<0);

              if(val<0xFFFF)
              {
                val=val/4;

                if(System.can_state.numeric_data.eng_rpm!=val)
                {
                  System.Grab(portMAX_DELAY);
                  {
                    System.can_state.numeric_data.eng_rpm=val;

                    if(System.can_state.numeric_data.eng_rpm>350) System.can_state.sec_flags.engine_is_on=1;
                    else                                          System.can_state.sec_flags.engine_is_on=0;
                  }System.Release();
                }
              }

              break;
            }

          case 0x541:
            {
              if(rx.data[0]!=0xFF)
              {
                if(rx.data[0]&(1<<0))  System.can_state.sec_flags.ignition=1;
                else                   System.can_state.sec_flags.ignition=0;
              }

              break;
            }

          default:
            {
              break;
            }
          }
        }//if(rx.id_type==STD_ID_TYPE)
      }
      else if(can_id==CAN2_ID)
      {
        //500 кбит\с
        if(rx.id_type==STD_ID_TYPE)
        {
          switch(rx.id)
          {
          case 0x307:
            {

              break;
            }

          case 0x320:
            {

              break;
            }

          default:
            {
              break;
            }
          }
        }//if(rx.id_type==STD_ID_TYPE)
      }
      else if(can_id==CAN3_ID)
      {
        //none
      }
    }

    if(mess_count)
    {
      restart_sleep_and_rx_timers(can_id);
    }
  }

  System.can_state.sec_flags.can_in_sleep=can_sleep_indicate_handler();

  blocks_handler();

  hyundai_sonata_sd_analog_to_can_handler();

  taxi_blocks_handler();
}

static void can_rx_porsche_panamera_2019_handler(void)
{
  can_rx_frame_t rx;

  for(uint8_t can_id=CAN1_ID; can_id<HW_CAN_COUNT; can_id++)
  {
    uint16_t mess_count=filled_count_in_sfifo(&can_rx_sfifo[can_id]);

    for(uint16_t j=0; j<mess_count; j++)
    {
      if(!read_from_sfifo(&can_rx_sfifo[can_id], &rx))
      {
        __PRINTF("%s_RX sfifo is full, drop counter: %lu\n", get_name_from_can_id(can_id), can_rx_sfifo[can_id].drop_counter);
      }

#if defined(CAN_VEGA_FWD_PRESENT)
      rx_fwd_hadler(can_id, &rx);
#endif //defined(CAN_VEGA_FWD_PRESENT)

#if defined(YANDEX_OBD_PRESENT)
      obd_rx_handler(can_id, &rx);
#endif //defined(YANDEX_OBD_PRESENT)

      can_rx_debug_trace(&rx, can_id);

      if(can_id==CAN1_ID)
      {
        //CAN 500 оранж\зелен, в левой кик панели на бежевом разъеме
        if(rx.id_type==STD_ID_TYPE)
        {
          switch(rx.id)
          {
          case 0x3D0:
            {
              if(rx.data[0]!=0xFF)
              {
                if(rx.data[0]&(1<<0)) System.can_state.sec_flags.driver_door=1;
                else                  System.can_state.sec_flags.driver_door=0;

                if(rx.data[0]&(1<<1)) System.signal_state.cls_state.driver_door=0;
                else                  System.signal_state.cls_state.driver_door=1;

                if(System.signal_state.cls_state.driver_door || System.signal_state.cls_state.l_rear_door || System.signal_state.cls_state.r_rear_door || System.signal_state.cls_state.pass_door) _cls_state=UNLOCKED_CLS_STATE;
                else                                                                                                                                                                               _cls_state=LOCKED_CLS_STATE;

                System.signal_state.cls_state.driver_door_prepared=1;
              }

              if(rx.data[4]!=0xFF)
              {
                if(rx.data[4]==0x8C) System.signal_state.windows_position.driver_door=0;
                else                 System.signal_state.windows_position.driver_door=1;

                System.signal_state.windows_position.driver_door_prepared=1;
              }

              break;
            }
          case 0x3D1:
            {
              if(rx.data[0]!=0xFF)
              {
                if(rx.data[0]&(1<<0)) System.can_state.sec_flags.pass_door=1;
                else                  System.can_state.sec_flags.pass_door=0;

                if(rx.data[0]&(1<<1)) System.signal_state.cls_state.pass_door=0;
                else                  System.signal_state.cls_state.pass_door=1;

                if(System.signal_state.cls_state.driver_door || System.signal_state.cls_state.l_rear_door || System.signal_state.cls_state.r_rear_door || System.signal_state.cls_state.pass_door) _cls_state=UNLOCKED_CLS_STATE;
                else                                                                                                                                                                               _cls_state=LOCKED_CLS_STATE;

                System.signal_state.cls_state.pass_door_prepared=1;
              }

              if(rx.data[4]!=0xFF)
              {
                if(rx.data[4]==0x8C) System.signal_state.windows_position.pass_door=0;
                else                 System.signal_state.windows_position.pass_door=1;

                System.signal_state.windows_position.pass_door_prepared=1;
              }

              break;
            }
          case 0x3CE:
            {
              if(rx.data[0]!=0xFF)
              {
                if(rx.data[0]&(1<<0)) System.can_state.sec_flags.l_rear_door=1;
                else                  System.can_state.sec_flags.l_rear_door=0;

                if(rx.data[0]&(1<<1)) System.signal_state.cls_state.l_rear_door=0;
                else                  System.signal_state.cls_state.l_rear_door=1;

                if(System.signal_state.cls_state.driver_door || System.signal_state.cls_state.l_rear_door || System.signal_state.cls_state.r_rear_door || System.signal_state.cls_state.pass_door) _cls_state=UNLOCKED_CLS_STATE;
                else                                                                                                                                                                               _cls_state=LOCKED_CLS_STATE;

                System.signal_state.cls_state.l_rear_door_prepared=1;
              }

              if(rx.data[4]!=0xFF)
              {
                if(rx.data[4]==0x8C) System.signal_state.windows_position.l_rear_door=0;
                else                 System.signal_state.windows_position.l_rear_door=1;

                System.signal_state.windows_position.l_rear_door_prepared=1;
              }

              break;
            }
          case 0x3CF:
            {
              if(rx.data[0]!=0xFF)
              {
                if(rx.data[0]&(1<<0)) System.can_state.sec_flags.r_rear_door=1;
                else                  System.can_state.sec_flags.r_rear_door=0;

                if(rx.data[0]&(1<<1)) System.signal_state.cls_state.r_rear_door=0;
                else                  System.signal_state.cls_state.r_rear_door=1;

                if(System.signal_state.cls_state.driver_door || System.signal_state.cls_state.l_rear_door || System.signal_state.cls_state.r_rear_door || System.signal_state.cls_state.pass_door) _cls_state=UNLOCKED_CLS_STATE;
                else                                                                                                                                                                               _cls_state=LOCKED_CLS_STATE;

                System.signal_state.cls_state.r_rear_door_prepared=1;
              }

              if(rx.data[4]!=0xFF)
              {
                if(rx.data[4]==0x8C) System.signal_state.windows_position.r_rear_door=0;
                else                 System.signal_state.windows_position.r_rear_door=1;

                System.signal_state.windows_position.r_rear_door_prepared=1;
              }

              break;
            }
          case 0x65A:
            {
              if(rx.data[3]!=0xFF)
              {
                if(rx.data[3]&(1<<7)) System.can_state.sec_flags.hood=1;
                else                  System.can_state.sec_flags.hood=0;
              }

              if(rx.data[1]!=0xFF)
              {
                if(rx.data[1]&(1<<7)) System.signal_state.washer_liquid=1;
                else                  System.signal_state.washer_liquid=0;
              }

              break;
            }
          case 0x3C0:
            {
              if(rx.data[2]!=0xFF)
              {
                if(rx.data[2]==0x23 || rx.data[2]==0x2B /*стартер*/)  System.can_state.sec_flags.ignition=1;
                else                                                  System.can_state.sec_flags.ignition=0;
              }

              break;
            }
          case 0x104:
            {
              if(rx.data[7]!=0xFF)
              {
                if(rx.data[7]==0x00) System.can_state.sec_flags.hand_break=0;
                else                 System.can_state.sec_flags.hand_break=1;
              }

              break;
            }
          case 0x0AD:
            {
              uint16_t val=((rx.data[4]<<8)|(rx.data[5]<<0));

              if(val!=0xFFFF)
              {
                System.Grab(portMAX_DELAY);
                {
                  if(val==0xC814)      {System.can_state.sec_flags.parking=1; System.can_state.sec_flags.reverse_gear=0;}
                  else if(val==0xAF18) {System.can_state.sec_flags.parking=0; System.can_state.sec_flags.reverse_gear=1;}
                  else                 {System.can_state.sec_flags.parking=0; System.can_state.sec_flags.reverse_gear=0;}

                  if(val==0xC814)      System.signal_state.selector_position='P';
                  else if(val==0xAF18) System.signal_state.selector_position='R';
                  else if(val==0xC81C) System.signal_state.selector_position='N';
                  else if(val==0xC820) System.signal_state.selector_position='D';
                  else if(val==0xC838) System.signal_state.selector_position='M';
                  else                 System.signal_state.selector_position='U';
                }System.Release();
              }

              break;
            }

          case 0x0A8:
            {
              uint16_t val=((rx.data[7]<<8)|(rx.data[6]<<0));

              if(val!=0xFFFF)
              {
                val=val/4;
                System.Grab(portMAX_DELAY);
                {
                  System.can_state.numeric_data.eng_rpm=val;

                  if(System.can_state.numeric_data.eng_rpm>350) System.can_state.sec_flags.engine_is_on=1;
                  else                                          System.can_state.sec_flags.engine_is_on=0;

                }System.Release();
              }

              break;
            }

          case 0x0A0:
            {
              int32_t val=((rx.data[5]&0x0F)<<8)|((rx.data[4])<<0);

              val=(val*100)/3930; ////3930-max

              if(!(rx.data[5]&(1<<4))) val=-1*val; //4й бит положение руля

              System.Grab(portMAX_DELAY);
              {
                System.can_state.numeric_data.battery_charge_level=val;//temporary
              }System.Release();

              break;
            }
          case 0x520:
            {
              if(rx.data[5]!=0xFF)
              {
                if(rx.data[5]&(1<<0)) System.can_state.cont_flags.driver_safety_belt=1;
                else                  System.can_state.cont_flags.driver_safety_belt=0;

                if(rx.data[5]&(1<<2)) System.can_state.cont_flags.passenger_safety_belt=1;
                else                  System.can_state.cont_flags.passenger_safety_belt=0;
              }

              break;
            }
          case 0x6B2:
            {
              uint32_t val=((rx.data[3]<<16)|(rx.data[2]<<8)|(rx.data[1]<<0));

              val=val&0x0FFFFF;

              if(val<0x0FFFFE)
              {
                System.Grab(portMAX_DELAY);
                {
                  System.can_state.numeric_data.can_odo_km=val;
                }System.Release();
              }

              break;
            }
          case 0x462:
            {
              if(rx.data[2]!=0xFF)
              {
                  //System.set_fuel_level_p(rx.data[2]);
              }

              break;
            }
          case 0x582:
            {
              if(rx.data[0]!=0xFF)
              {
                if(rx.data[0]==0x02) System.can_state.sec_flags.trunk=0;
                else                 System.can_state.sec_flags.trunk=1;
              }

              break;
            }
          case 0x640:
            {
              if(rx.data[2]!=0xFF && rx.data[2]!=0xFE)
              {
                System.Grab(portMAX_DELAY);
                {
                  System.can_state.numeric_data.eng_temp=rx.data[2]-60.0f; //температура масла
                }System.Release();
              }

              break;
            }
          case 0x30B:
            {
              if(rx.data[3]!=0xFF && rx.data[3]!=0xFE)
              {
                System.can_state.numeric_data.can_speed=rx.data[3];
              }

              break;
            }
          case 0x3D5:
            {
              if(rx.data[4]!=0xFF)
              {
                if(rx.data[4]&(1<<1)) System.can_state.cont_flags.high_beam=1;
                else                  System.can_state.cont_flags.high_beam=0;
              }

              break;
            }
          case 0x395:
            {
              if(rx.data[2]!=0xFF)
              {
                if(rx.data[2]&(1<<5)) System.can_state.cont_flags.dipped_beam=1;
                else                  System.can_state.cont_flags.dipped_beam=0;

                if(rx.data[2]&(1<<6)) System.can_state.cont_flags.marker_lights=1;
                else                  System.can_state.cont_flags.marker_lights=0;
              }

              if(rx.data[3]!=0xFF)
              {
                //туманки, 07 горит, 06 нет
              }

              break;
            }
          case 0x6AE:
            {
              //зеркала

              break;
            }
          case 0x121:
            {
              if(rx.data[2]!=0xFF)
              {
                System.can_state.numeric_data.accelerator=((rx.data[2]&0x0F)*100Ul)/(0x0F);
              }

              break;
            }
          case 0x106:
            {
              //педаль тормоза
              uint16_t val=(rx.data[3]<<8)|(rx.data[2]<<0);

              if(val<0xFFFE)
              {
                val=val&(0x03FF);//10bit

                if(val<=0x0064)
                {
                  System.can_state.numeric_data.brake=0;
                }
                else
                {
                  System.can_state.numeric_data.brake=((val-0x0064)*100Ul)/((0x066E&0x03FF)-0x0064);
                }
              }

              if(rx.data[7]!=0xFF)
              {//??
                if(rx.data[7]>0x00) System.can_state.sec_flags.pedal_break=1;
                else                System.can_state.sec_flags.pedal_break=0;
              }

              break;
            }
          case 0x366:
            {
              if(rx.data[2]!=0xFF)
              {
                if(rx.data[2]&(1<<4)) System.signal_state.emergency_lights=1;
                else                  System.signal_state.emergency_lights=0;
              }

              break;
            }
          case 0x3C7:
            {
              if(rx.data[6]!=0xFF)
              {
                if(rx.data[6]&(1<<1)) System.can_state.cont_flags.check_engine=1;
                else                  System.can_state.cont_flags.check_engine=0;
              }

              break;
            }
          case 0x040:
            {
              if(rx.data[3]!=0xFF)
              {
                if(rx.data[3]&(1<<0)) System.can_state.cont_flags.airbag=1;
                else                  System.can_state.cont_flags.airbag=0;
              }

              break;
            }
          case 0x31B:
            {
              if(rx.data[6]!=0xFF)
              {
                //esp отключено (на A3 вроде abs)
                if(rx.data[6]&(1<<7)) System.can_state.cont_flags.esp=1;
                else                  System.can_state.cont_flags.esp=0;
              }

              break;
            }
          case 0x5E0:
            {
              //0(закрыто) до E4
              if(rx.data[1]!=0xFF)
              {
                if(rx.data[1]<=0x01) System.signal_state.roof.sunroof=0;
                else                 System.signal_state.roof.sunroof=1;

                System.signal_state.roof.sunroof_prepared=1;
              }

              break;
            }
          default:
            {
              break;
            }
          }
        }//if(rx.id_type==STD_ID_TYPE)
      }
      else if(can_id==CAN2_ID)
      {
        //none
      }
      else if(can_id==CAN3_ID)
      {
        if(rx.id_type==STD_ID_TYPE)
        {
          switch(rx.id)
          {
          case 0x7E8:
            {
              //OBDII ответ
              if(rx.data[0]==0x03 && rx.data[1]==0x41 && rx.data[2]==0x2F)
              {
                System.set_fuel_level_p((rx.data[3]*100Ul)/255Ul);
              }
              else if(rx.data[0]==0x03 && rx.data[1]==0x41 && rx.data[2]==0x05)
              {
                //System.Grab(portMAX_DELAY);
                //{
                //  System.can_state.numeric_data.eng_temp=rx.data[3]-40.0f;
                //}System.Release();
              }
            }

          default:
            {
              break;
            }
          }
        }
      }
    }

    if(mess_count)
    {
      restart_sleep_and_rx_timers(can_id);
    }
  }

  System.can_state.sec_flags.can_in_sleep=can_sleep_indicate_handler();

  blocks_handler();

  porsche_panamera_analog_to_can_handler();

  taxi_blocks_handler();
}

static void can_rx_lada_largus_2017_handler(void)
{
  can_rx_frame_t rx;

  for(uint8_t can_id=CAN1_ID; can_id<HW_CAN_COUNT; can_id++)
  {
    uint16_t mess_count=filled_count_in_sfifo(&can_rx_sfifo[can_id]);

    for(uint16_t j=0; j<mess_count; j++)
    {
      if(!read_from_sfifo(&can_rx_sfifo[can_id], &rx))
      {
        __PRINTF("%s_RX sfifo is full, drop counter: %lu\n", get_name_from_can_id(can_id), can_rx_sfifo[can_id].drop_counter);
      }

#if defined(CAN_VEGA_FWD_PRESENT)
      rx_fwd_hadler(can_id, &rx);
#endif //defined(CAN_VEGA_FWD_PRESENT)

#if defined(YANDEX_OBD_PRESENT)
      obd_rx_handler(can_id, &rx);
#endif //defined(YANDEX_OBD_PRESENT)

      can_rx_debug_trace(&rx, can_id);

        if(can_id==CAN1_ID)
        {
          //OBD CAN, 500 кбит\с
          if(rx.id_type==STD_ID_TYPE)
          {
            if(rx.id==0x160)
            {
              if(rx.data[3]!=0xFF)
              {
                System.can_state.numeric_data.accelerator=(rx.data[3]*100Ul)/0xC7;
              }
            }
            else if(rx.id==0x35D)
            {
              if(rx.data[4]!=0xFF)
              {
                if(rx.data[4]&(1<<4)) System.can_state.sec_flags.pedal_break=1;
                else                  System.can_state.sec_flags.pedal_break=0;
              }
            }
            else if(rx.id==0x182)
            {
              System.Grab(portMAX_DELAY);
              {
                if(__GET_IGN_STATE())
                {
                  System.can_state.numeric_data.eng_rpm=(rx.data[4]*100UL);
                }
                else
                {
                  System.can_state.numeric_data.eng_rpm=0;
                }

                if(System.can_state.numeric_data.eng_rpm>350) System.can_state.sec_flags.engine_is_on=1;
                else                                          System.can_state.sec_flags.engine_is_on=0;
              }System.Release();
            }
          }//if(rx.id_type==STD_ID_TYPE)
        }
        else if(can_id==CAN2_ID)
        {
          //none
        }
        else if(can_id==CAN3_ID)
        {
          //none
        }
    }

    if(mess_count)
    {
      restart_sleep_and_rx_timers(can_id);
    }
  }

  System.can_state.sec_flags.can_in_sleep=can_sleep_indicate_handler();

  blocks_handler();

  largus_analog_to_can_handler();

  taxi_blocks_handler();
}

static void can_rx_volvo_xc60_2018_handler(void)
{
  can_rx_frame_t rx;

  for(uint8_t can_id=CAN1_ID; can_id<HW_CAN_COUNT; can_id++)
  {
    uint16_t mess_count=filled_count_in_sfifo(&can_rx_sfifo[can_id]);

    for(uint16_t j=0; j<mess_count; j++)
    {
      if(!read_from_sfifo(&can_rx_sfifo[can_id], &rx))
      {
        __PRINTF("%s_RX sfifo is full, drop counter: %lu\n", get_name_from_can_id(can_id), can_rx_sfifo[can_id].drop_counter);
      }

#if defined(CAN_VEGA_FWD_PRESENT)
      rx_fwd_hadler(can_id, &rx);
#endif //defined(CAN_VEGA_FWD_PRESENT)

#if defined(YANDEX_OBD_PRESENT)
      obd_rx_handler(can_id, &rx);
#endif //defined(YANDEX_OBD_PRESENT)

      can_rx_debug_trace(&rx, can_id);

        if(can_id==CAN1_ID)
        {
          //бело-зеленый, зелено-желтый, 500 кбит\с
          if(rx.id_type==STD_ID_TYPE)
          {
            if(rx.id==0x066)
            {
              uint16_t val=((rx.data[3]<<8)|(rx.data[4]<<0));

              //System.can_state.numeric_data.harvest_time=((rx.data[2]<<16)|(rx.data[3]<<8)|(rx.data[4]<<0));//temporary

              if(val!=0xFFFF)
              {
                val=val/2;

                System.Grab(portMAX_DELAY);
                {
                  System.can_state.numeric_data.eng_rpm=val;

                  if(System.can_state.numeric_data.eng_rpm>350) System.can_state.sec_flags.engine_is_on=1;
                  else                                          System.can_state.sec_flags.engine_is_on=0;
                }System.Release();
              }
            }
            else if(rx.id==0x04A)
            {
              uint16_t val=((rx.data[0]<<8)|(rx.data[1]<<0));

              if(val!=0xFFFF && val>=0x8000)
              {
                System.can_state.numeric_data.accelerator=((val-0x8000UL)*100UL)/(0xE400UL-0x8000UL);
              }
            }
            else if(rx.id==0x041)
            {
              uint16_t val=((rx.data[0]<<8)|(rx.data[1]<<0));

              if(val!=0xFFFF)
              {
                if(val>=0x10)  System.can_state.sec_flags.pedal_break=1;
                else           System.can_state.sec_flags.pedal_break=0;
              }
            }
            else if(rx.id==0x185)
            {
              if(rx.data[6]!=0xFF)
              {
                System.Grab(portMAX_DELAY);
                {
                  if((rx.data[6]&0xf0)==0x80)      {System.can_state.sec_flags.parking=1; System.can_state.sec_flags.reverse_gear=0;}
                  else if((rx.data[6]&0xf0)==0xA0) {System.can_state.sec_flags.parking=0; System.can_state.sec_flags.reverse_gear=1;}
                  else                             {System.can_state.sec_flags.parking=0; System.can_state.sec_flags.reverse_gear=0;}

                  if((rx.data[6]&0xf0)==0x80)       System.signal_state.selector_position='P';
                  else if ((rx.data[6]&0xf0)==0xA0) System.signal_state.selector_position='R';
                  else if ((rx.data[6]&0xf0)==0xC0) System.signal_state.selector_position='N';
                  else if ((rx.data[6]&0xf0)==0xE0) System.signal_state.selector_position='D';
                  else                              System.signal_state.selector_position='U';
                }System.Release();
              }
            }
            else if(rx.id==0x630)
            {
              //OBDII ответ
              if(rx.data[0]==0x04 && rx.data[1]==0x62 && rx.data[2]==0xF4 && rx.data[3]==0x2F)
              {
                static uint8_t val=0;

                if(System.signal_state.vin_sensor[5]=='A')//дизель LYVUZA8ACKB248097
                {
                  val=(rx.data[4]*100Ul)/214Ul;
                  System.can_state.numeric_data.concave_clear=214;//temporarry
                }
                else if(System.signal_state.vin_sensor[5]=='0') //бензин LYVUZ08ACKB251097
                {
                  val=(rx.data[4]*100Ul)/255Ul;
                  System.can_state.numeric_data.concave_clear=255;//temporarry
                }

                if(val>100) val=100;

                System.set_fuel_level_p(val);

                //System.can_state.numeric_data.can_axle_1=rx.data[4];//temporary
              }
              else if(rx.data[0]==0x04 && rx.data[1]==0x62 && rx.data[2]==0xF4 && rx.data[3]==0x05)
              {
                System.Grab(portMAX_DELAY);
                {
                  System.can_state.numeric_data.eng_temp=rx.data[4]-40.0f;
                }System.Release();
              }
            }
            else if(rx.id==0x730)
            {

            }
            else if(rx.id==0x111)
            {
              uint16_t val=((rx.data[2]<<8)|(rx.data[3]<<0));

              //System.can_state.numeric_data.can_axle_2=val;//temporary

              if(val!=0xFFFF)
              {
                if(val==0x4E20) val=0;//приходит на заглушенную

                val=(val&0x3FFF);

                System.can_state.numeric_data.can_speed=(val*41Ul)/2000Ul;
              }
            }
            else if(rx.id==0x158)
            {
              if(rx.data[1]!=0xFF)
              {
                //100ххххх - снят с тормоза
                //010ххххх - в процессе снятия постановки
                //001ххххх - на стояночном тормозе
                if((rx.data[1]&0xE0)==(1<<7)) System.can_state.sec_flags.hand_break=0;
                else                          System.can_state.sec_flags.hand_break=1;
              }
            }
            else if(rx.id==0x285)
            {
              uint32_t val=((rx.data[2]&0x0f)<<16)|(rx.data[3]<<8)|(rx.data[4]<<0);

              if(!(val==0x0fffff || val==0x0ffffe))
              {
                System.Grab(portMAX_DELAY);
                {
                  System.can_state.numeric_data.can_odo_km=val;
                }System.Release();
              }
            }
          }//if(rx.id_type==STD_ID_TYPE)
        }
        else if(can_id==CAN2_ID)
        {
          //фиолетово-зеленый, фиолетово-белый, 500 кбит\с
          if(rx.id_type==STD_ID_TYPE)
          {
            if(rx.id==0x020)
            {
              //дергается
              if(rx.data[0]!=0xFF)
              {
                //if((rx.data[0]&0x0F)==0x0F) System.signal_state.emergency_lights=1;
                //else                        System.signal_state.emergency_lights=0;

                if((rx.data[0]&0x0F)==0x0F)
                {
                  System.signal_state.emergency_lights=1;
                  restart_can_timer(EMERG_LIGHT_FIX_TIMER, 2500);
                }

              }
            }
            else if(rx.id==0x040)
            {
              if(rx.data[6]!=0xFF)
              {
                if((rx.data[6]&0xC0)==(1<<7)) System.can_state.sec_flags.driver_door=0;
                else                          System.can_state.sec_flags.driver_door=1;
              }

              if(rx.data[5]!=0xFF)
              {
                if((rx.data[5]&0x0C)==(1<<3)) System.can_state.sec_flags.l_rear_door=0;
                else                          System.can_state.sec_flags.l_rear_door=1;
              }
            }
            else if(rx.id==0x0E0)
            {
              if(rx.data[1]!=0xFF)
              {
                if((rx.data[1]&0x30)==(1<<5)) System.can_state.sec_flags.r_rear_door=0;
                else                          System.can_state.sec_flags.r_rear_door=1;
              }

              if(rx.data[3]!=0xFF)
              {
                if((rx.data[3]&0xC0)==(1<<7)) System.can_state.sec_flags.pass_door=0;
                else                          System.can_state.sec_flags.pass_door=1;
              }

              if(rx.data[5]!=0xFF)
              {
                if((rx.data[5]&0xC0)==(1<<7)) System.can_state.sec_flags.trunk=0;
                else                          System.can_state.sec_flags.trunk=1;
              }
            }
            else if(rx.id==0x100)
            {
              System.can_state.numeric_data.brake=rx.data[4];//temporary

              ///*
              if(rx.data[4]!=0xFF)
              {
                if((rx.data[4]&0x03)==0x03) System.can_state.sec_flags.closed_by_pult=1;
                else                        System.can_state.sec_flags.closed_by_pult=0;

                if((rx.data[4]&0x03)==0x03) _cls_state=LOCKED_CLS_STATE;
                else                        _cls_state=UNLOCKED_CLS_STATE;

                if(_cls_state==LOCKED_CLS_STATE)
                {
                  System.signal_state.cls_state.driver_door=0;
                  System.signal_state.cls_state.pass_door=0;
                  System.signal_state.cls_state.l_rear_door=0;
                  System.signal_state.cls_state.r_rear_door=0;
                }
                else
                {
                  System.signal_state.cls_state.driver_door=1;
                  System.signal_state.cls_state.pass_door=1;
                  System.signal_state.cls_state.l_rear_door=1;
                  System.signal_state.cls_state.r_rear_door=1;
                }

                System.signal_state.cls_state.driver_door_prepared=1;
                System.signal_state.cls_state.l_rear_door_prepared=1;
                System.signal_state.cls_state.r_rear_door_prepared=1;
                System.signal_state.cls_state.pass_door_prepared=1;
              }
              //*/

              if(rx.data[6]!=0xFF)
              {
                if((rx.data[6]&0x03)==(1<<1)) System.can_state.sec_flags.hood=0;
                else                          System.can_state.sec_flags.hood=1;
              }
            }
            else if(rx.id==0x612)
            {

            }
            else if(rx.id==0x613)
            {

            }
            else if(rx.id==0x370)
            {
              if(rx.data[3]!=0xff)
              {
                //Низкий уровень омывающей ждикости
                if(rx.data[3]&(1<<4)) System.signal_state.washer_liquid=1;
                else                  System.signal_state.washer_liquid=0;
              }
            }
            else if(rx.id==0x1E0)
            {
              if(rx.data[3]!=0xFF)
              {
                if(rx.data[3]==0xA1) System.signal_state.windows_position.driver_door=0;
                else                 System.signal_state.windows_position.driver_door=1;

                System.signal_state.windows_position.driver_door_prepared=1;
              }
            }
            else if(rx.id==0x160)
            {
              if(rx.data[2]!=0xFF)
              {
                if(rx.data[2]==0x0A) System.signal_state.windows_position.pass_door=0;
                else                 System.signal_state.windows_position.pass_door=1;

                System.signal_state.windows_position.pass_door_prepared=1;
              }
            }
            else if(rx.id==0x030)
            {
              if(rx.data[7]!=0xFF)
              {
                if(rx.data[7]==0x08) System.signal_state.windows_position.l_rear_door=0;
                else                 System.signal_state.windows_position.l_rear_door=1;

                System.signal_state.windows_position.l_rear_door_prepared=1;
              }
            }
            else if(rx.id==0x010)
            {
              if(rx.data[0]!=0xFF)
              {
                if(rx.data[0]==0x0D) System.signal_state.windows_position.r_rear_door=0;
                else                 System.signal_state.windows_position.r_rear_door=1;

                System.signal_state.windows_position.r_rear_door_prepared=1;
              }
            }
            else if(rx.id==0x0B0)
            {
              if(rx.data[7]!=0xFF)
              {
                if(rx.data[7]&(1<<1)) System.can_state.cont_flags.driver_safety_belt=1;
                else                  System.can_state.cont_flags.driver_safety_belt=0;
              }
            }
            else if(rx.id==0x210)
            {
              uint16_t val=(rx.data[3]<<8)|(rx.data[4]<<0);

              if(val!=0xFFFF)
              {
                val=(val&0x03FF);

                //запас хода
                System.Grab(portMAX_DELAY);
                {
                  System.can_state.numeric_data.fuel_lev_l=val;
                }System.Release();
              }
            }
          }//if(rx.id_type==STD_ID_TYPE)
        }
        else if(can_id==CAN3_ID)
        {
          //, 500 кбит\с
          if(rx.id_type==STD_ID_TYPE)
          {
            if(rx.id==0x030)
            {
              if(rx.data[3]!=0xFF)
              {
                if(rx.data[3]&(1<<0)) System.can_state.cont_flags.marker_lights=1;
                else                  System.can_state.cont_flags.marker_lights=0;

                if(rx.data[3]&(1<<1)) System.can_state.cont_flags.dipped_beam=1;
                else                  System.can_state.cont_flags.dipped_beam=0;

                if(rx.data[3]&(1<<3)) System.can_state.cont_flags.high_beam=1;
                else                  System.can_state.cont_flags.high_beam=0;
              }
            }
            else if(rx.id==0x050)
            {

            }
          }//if(rx.id_type==STD_ID_TYPE)
        }
    }

    if(mess_count)
    {
      restart_sleep_and_rx_timers(can_id);
    }
  }

  System.can_state.sec_flags.can_in_sleep=can_sleep_indicate_handler();

  blocks_handler();

  volvo_xc60_analog_to_can_handler();

  taxi_blocks_handler();
}

static void can_rx_volvo_xc40_2018_handler(void)
{
  can_rx_frame_t rx;

  for(uint8_t can_id=CAN1_ID; can_id<HW_CAN_COUNT; can_id++)
  {
    uint16_t mess_count=filled_count_in_sfifo(&can_rx_sfifo[can_id]);

    for(uint16_t j=0; j<mess_count; j++)
    {
      if(!read_from_sfifo(&can_rx_sfifo[can_id], &rx))
      {
        __PRINTF("%s_RX sfifo is full, drop counter: %lu\n", get_name_from_can_id(can_id), can_rx_sfifo[can_id].drop_counter);
      }

#if defined(CAN_VEGA_FWD_PRESENT)
      rx_fwd_hadler(can_id, &rx);
#endif //defined(CAN_VEGA_FWD_PRESENT)

#if defined(YANDEX_OBD_PRESENT)
      obd_rx_handler(can_id, &rx);
#endif //defined(YANDEX_OBD_PRESENT)

      can_rx_debug_trace(&rx, can_id);

      if(can_id==CAN1_ID)
      {
        //Motor CAN, 500 кбит\с
        if(rx.id_type==STD_ID_TYPE)
        {
          switch(rx.id)
          {
          case 0x111:
            {
              uint16_t val=((rx.data[2]<<8)|(rx.data[3]<<0));

              if(val!=0xFFFF)
              {
                if(val==0x4E20) val=0;//приходит на заглушенную

                val=(val&0x0FFF);

                System.can_state.numeric_data.can_speed=val/40;
              }
            }
            break;

          case 0x19F:
            {
              /*
              uint32_t val=((rx.data[5]&0x0f)<<16)|(rx.data[6]<<8)|(rx.data[7]<<0);

              if(!(val==0x0fffff || val==0x0ffffe))
              {
                System.Grab(portMAX_DELAY);
                {
                  System.can_state.numeric_data.can_odo_km=val/10.0f;
                }System.Release();
              }
              */
            }
            break;

          case 0x04A:
            {
              uint8_t val=rx.data[0];

              if(val>=0x80 && val<=0xE4)
              {
                System.can_state.numeric_data.accelerator=((val-0x80UL)*100UL)/(0xE4UL-0x80UL);;
              }
            }
            break;

          case 0x066:
            {
              uint16_t val=((rx.data[3]<<8)|(rx.data[4]<<0));

              if(val!=0xFFFF)
              {
                val=val/2;

                System.Grab(portMAX_DELAY);
                {
                  System.can_state.numeric_data.eng_rpm=val;

                  if(System.can_state.numeric_data.eng_rpm>350) System.can_state.sec_flags.engine_is_on=1;
                  else                                          System.can_state.sec_flags.engine_is_on=0;
                }System.Release();
              }
            }
            break;

          case 0x041:
            {
              uint16_t val=((rx.data[0]<<8)|(rx.data[1]<<0));

              if(val!=0xFFFF)
              {
                if(val>=0x10)  System.can_state.sec_flags.pedal_break=1;
                else           System.can_state.sec_flags.pedal_break=0;
              }
            }
            break;

           case 0x158:
            {
              if(rx.data[1]!=0xFF)
              {
                //100ххххх - снят с тормоза
                //010ххххх - в процессе снятия постановки
                //001ххххх - на стояночном тормозе
                if((rx.data[1]&0xE0)==(1<<7)) System.can_state.sec_flags.hand_break=0;
                else                          System.can_state.sec_flags.hand_break=1;
              }
            }
            break;

          case 0x126:
            {
              if(rx.data[4]!=0xFF)
              {
                //ACC
                if(rx.data[4]&(1<<4)) System.can_state.sec_flags.ignition=1;
                else                  System.can_state.sec_flags.ignition=0;
              }
            }
            break;

          case 0x185:
            {
              if(rx.data[6]!=0xFF)
              {
                System.Grab(portMAX_DELAY);
                {
                  if((rx.data[6]&0xf0)==0x80)      {System.can_state.sec_flags.parking=1; System.can_state.sec_flags.reverse_gear=0;}
                  else if((rx.data[6]&0xf0)==0xA0) {System.can_state.sec_flags.parking=0; System.can_state.sec_flags.reverse_gear=1;}
                  else                             {System.can_state.sec_flags.parking=0; System.can_state.sec_flags.reverse_gear=0;}

                  if((rx.data[6]&0xf0)==0x80)       System.signal_state.selector_position='P';
                  else if ((rx.data[6]&0xf0)==0xA0) System.signal_state.selector_position='R';
                  else if ((rx.data[6]&0xf0)==0xC0) System.signal_state.selector_position='N';
                  else if ((rx.data[6]&0xf0)==0xE0) System.signal_state.selector_position='D';
                  else                              System.signal_state.selector_position='U';
                }System.Release();
              }
            }
            break;
          /*
          case 0x34F:
            //нету в шине
            {
              uint16_t val=((rx.data[6]<<8)|(rx.data[7]<<0));

              if(val!=0xFFFF)
              {
                //val=val&0x3FF;

                System.Grab(portMAX_DELAY);
                {
                  //запас хода, расстоние до пустого бака
                  System.can_state.numeric_data.fuel_lev_l=val;
                }System.Release();
              }
            }
            break;
            */
          case 0x630:
            {
              //OBDII ответ
              if(rx.data[0]==0x04 && rx.data[1]==0x62 && rx.data[2]==0xF4 && rx.data[3]==0x2F)
              {
                System.set_fuel_level_p((rx.data[4]*100Ul)/255Ul);
              }
              else if(rx.data[0]==0x04 && rx.data[1]==0x62 && rx.data[2]==0xF4 && rx.data[3]==0x05)
              {
                System.Grab(portMAX_DELAY);
                {
                  System.can_state.numeric_data.eng_temp=rx.data[4]-40.0f;
                }System.Release();
              }
            }
            break;

          default:
            break;
          }
        }//if(rx.id_type==STD_ID_TYPE)
      }
      else if(can_id==CAN2_ID)
      {
        //x CAN, 500 кбит\с
        if(rx.id_type==STD_ID_TYPE)
        {
          switch(rx.id)
          {
           case 0x040:
            {
              if(rx.data[6]!=0xFF)
              {
                if((rx.data[6]&0xC0)==(1<<7)) System.can_state.sec_flags.driver_door=0;
                else                          System.can_state.sec_flags.driver_door=1;
              }

              if(rx.data[5]!=0xFF)
              {
                if((rx.data[5]&0x0C)==(1<<3)) System.can_state.sec_flags.l_rear_door=0;
                else                          System.can_state.sec_flags.l_rear_door=1;
              }
            }
            break;

          case 0x0E0:
            {
              if(rx.data[1]!=0xFF)
              {
                if((rx.data[1]&0x30)==(1<<5)) System.can_state.sec_flags.r_rear_door=0;
                else                          System.can_state.sec_flags.r_rear_door=1;
              }

              if(rx.data[3]!=0xFF)
              {
                if((rx.data[3]&0xC0)==(1<<7)) System.can_state.sec_flags.pass_door=0;
                else                          System.can_state.sec_flags.pass_door=1;
              }

              if(rx.data[5]!=0xFF)
              {
                if((rx.data[5]&0xC0)==(1<<7)) System.can_state.sec_flags.trunk=0;
                else                          System.can_state.sec_flags.trunk=1;
              }
            }
            break;

          case 0x100:
            {
              if(rx.data[4]!=0xFF)
              {
                if((rx.data[4]&0x03)==0x03) System.can_state.sec_flags.closed_by_pult=1;
                else                        System.can_state.sec_flags.closed_by_pult=0;

                if((rx.data[4]&0x03)==0x03) _cls_state=LOCKED_CLS_STATE;
                else                        _cls_state=UNLOCKED_CLS_STATE;

                if(_cls_state==LOCKED_CLS_STATE)
                {
                  System.signal_state.cls_state.driver_door=0;
                  System.signal_state.cls_state.pass_door=0;
                  System.signal_state.cls_state.l_rear_door=0;
                  System.signal_state.cls_state.r_rear_door=0;
                }
                else
                {
                  System.signal_state.cls_state.driver_door=1;
                  System.signal_state.cls_state.pass_door=1;
                  System.signal_state.cls_state.l_rear_door=1;
                  System.signal_state.cls_state.r_rear_door=1;
                }

                System.signal_state.cls_state.driver_door_prepared=1;
                System.signal_state.cls_state.l_rear_door_prepared=1;
                System.signal_state.cls_state.r_rear_door_prepared=1;
                System.signal_state.cls_state.pass_door_prepared=1;
              }

              if(rx.data[6]!=0xFF)
              {
                if((rx.data[6]&0x03)==(1<<1)) System.can_state.sec_flags.hood=0;
                else                          System.can_state.sec_flags.hood=1;
              }
            }
            break;

          case 0x020:
            {
              //дергается
              if(rx.data[0]!=0xFF)
              {
                //if((rx.data[0]&0x0F)==0x0F) System.signal_state.emergency_lights=1;
                //else                        System.signal_state.emergency_lights=0;

                if((rx.data[0]&0x0F)==0x0F)
                {
                  System.signal_state.emergency_lights=1;
                  restart_can_timer(EMERG_LIGHT_FIX_TIMER, 2500);
                }

              }
            }
            break;

          case 0x470: //на XC60 так-же?
            {
              if(rx.data[3]!=0xFF)
              {
                if(rx.data[3]&(7<<0)) System.can_state.cont_flags.marker_lights=1;
                else                  System.can_state.cont_flags.marker_lights=0;

                if(rx.data[3]&(1<<1)) System.can_state.cont_flags.dipped_beam=1;
                else                  System.can_state.cont_flags.dipped_beam=0;

                if(rx.data[3]&(1<<2)) System.can_state.cont_flags.high_beam=1;
                else                  System.can_state.cont_flags.high_beam=0;
              }
            }
            break;

          case 0x370: //на XC60 так-же?
            {
              if(rx.data[3]!=0xff)
              {
                //Низкий уровень омывающей ждикости
                if(rx.data[3]&(1<<4)) System.signal_state.washer_liquid=1;
                else                  System.signal_state.washer_liquid=0;
              }
            }
            break;

          case 0x1E0: //на XC60 так-же?
            {
              if(rx.data[3]!=0xFF)
              {
                if(rx.data[3]==0xA1) System.signal_state.windows_position.driver_door=0;
                else                 System.signal_state.windows_position.driver_door=1;

                System.signal_state.windows_position.driver_door_prepared=1;
              }
            }
            break;

          case 0x160: //на XC60 так-же?
            {
              if(rx.data[2]!=0xFF)
              {
                if(rx.data[2]==0x0A) System.signal_state.windows_position.pass_door=0;
                else                 System.signal_state.windows_position.pass_door=1;

                System.signal_state.windows_position.pass_door_prepared=1;
              }
            }
            break;

          case 0x030: //на XC60 так-же?
            {
              if(rx.data[7]!=0xFF)
              {
                if(rx.data[7]==0x08) System.signal_state.windows_position.l_rear_door=0;
                else                 System.signal_state.windows_position.l_rear_door=1;

                System.signal_state.windows_position.l_rear_door_prepared=1;
              }
            }
            break;

          case 0x010: //на XC60 так-же?
            {
              if(rx.data[0]!=0xFF)
              {
                if(rx.data[0]==0x0D) System.signal_state.windows_position.r_rear_door=0;
                else                 System.signal_state.windows_position.r_rear_door=1;

                System.signal_state.windows_position.r_rear_door_prepared=1;
              }
            }
            break;

          case 0x0B0: //на XC60 так-же?
            {
              if(rx.data[7]!=0xFF)
              {
                if(rx.data[7]&(1<<1)) System.can_state.cont_flags.driver_safety_belt=1;
                else                  System.can_state.cont_flags.driver_safety_belt=0;
              }
            }
            break;

          case 0x210:
            {
              uint16_t val=(rx.data[3]<<8)|(rx.data[4]<<0);

              if(val!=0xFFFF)
              {
                val=(val&0x03FF);

                //запас хода
                System.Grab(portMAX_DELAY);
                {
                  System.can_state.numeric_data.fuel_lev_l=val;
                }System.Release();
              }
            }
            break;

          case 0x310:
            {
              uint32_t val=((rx.data[0]&0x0f)<<16)|(rx.data[1]<<8)|(rx.data[2]<<0);

              if(!(val==0x0fffff || val==0x0ffffe))
              {
                System.Grab(portMAX_DELAY);
                {
                  System.can_state.numeric_data.can_odo_km=val;
                }System.Release();
              }
            }
          break;

          default:
            break;
          }
        }//if(rx.id_type==STD_ID_TYPE)
      }
      else if(can_id==CAN3_ID)
      {
        //OBD CAN, 500 кбит\с
        if(rx.id_type==STD_ID_TYPE)
        {
          switch(rx.id)
          {
          case 0x000:
            {

            }
            break;

          default:
            break;
          }
        }//if(rx.id_type==STD_ID_TYPE)
      }
    }

    if(mess_count)
    {
      restart_sleep_and_rx_timers(can_id);
    }
  }

  System.can_state.sec_flags.can_in_sleep=can_sleep_indicate_handler();

  blocks_handler();

  volvo_xc40_analog_to_can_handler();

  taxi_blocks_handler();
}

static void can_rx_range_rover_velar_2018_handler(void)
{
  can_rx_frame_t rx;

  for(uint8_t can_id=CAN1_ID; can_id<HW_CAN_COUNT; can_id++)
  {
    uint16_t mess_count=filled_count_in_sfifo(&can_rx_sfifo[can_id]);

    for(uint16_t j=0; j<mess_count; j++)
    {
      if(!read_from_sfifo(&can_rx_sfifo[can_id], &rx))
      {
        __PRINTF("%s_RX sfifo is full, drop counter: %lu\n", get_name_from_can_id(can_id), can_rx_sfifo[can_id].drop_counter);
      }

#if defined(CAN_VEGA_FWD_PRESENT)
      rx_fwd_hadler(can_id, &rx);
#endif //defined(CAN_VEGA_FWD_PRESENT)

#if defined(YANDEX_OBD_PRESENT)
      obd_rx_handler(can_id, &rx);
#endif //defined(YANDEX_OBD_PRESENT)

      can_rx_debug_trace(&rx, can_id);

        if(can_id==CAN1_ID)
        {
          //Motor CAN, 500 кбит\с
          if(rx.id_type==STD_ID_TYPE)
          {
            if(rx.id==0x040)
            {
              //тут же угол поворота руля
              if(rx.data[0]!=0xFF)
              {
                if((rx.data[0]&(1<<4))) System.can_state.sec_flags.ignition=1;
                else                    System.can_state.sec_flags.ignition=0;

                if(System.can_state.sec_flags.ignition) System.signal_state.key_position='I';
                else                                    System.signal_state.key_position='O';
              }
            }
            else if(rx.id==0x360)
            {
              uint16_t val=((rx.data[4]<<8)|(rx.data[5]<<0));

              if(val!=0xFFFF)
              {
                if(val>5) System.can_state.sec_flags.pedal_break=1;
                else      System.can_state.sec_flags.pedal_break=0;
              }

              if(rx.data[1]!=0xFF)
              {
                System.can_state.numeric_data.accelerator=(rx.data[1]*100Ul)/0xC8;
              }
            }
            else if(rx.id==0x044)
            {
              uint16_t val=((rx.data[4]<<8)|(rx.data[5]<<0));

              if(val!=0xFFFF)
              {
                System.Grab(portMAX_DELAY);
                {
                  //на некоторых машинах val на заглушенную равен 0x4000
                  System.can_state.numeric_data.eng_rpm=val&0x1FFF;

                  if(System.can_state.numeric_data.eng_rpm>350) System.can_state.sec_flags.engine_is_on=1;
                  else                                          System.can_state.sec_flags.engine_is_on=0;
                }System.Release();
              }
            }
            else if(rx.id==0x084)
            {
              if(rx.data[6]!=0xFF)
              {
                System.Grab(portMAX_DELAY);
                {
                  if((rx.data[6]&0x0f)==0x00)      {System.can_state.sec_flags.parking=1; System.can_state.sec_flags.reverse_gear=0;}
                  else if((rx.data[6]&0x0f)==0x01) {System.can_state.sec_flags.parking=0; System.can_state.sec_flags.reverse_gear=1;}
                  else                             {System.can_state.sec_flags.parking=0; System.can_state.sec_flags.reverse_gear=0;}

                  if((rx.data[6]&0x0f)==0x00)       System.signal_state.selector_position='P';
                  else if ((rx.data[6]&0x0f)==0x01) System.signal_state.selector_position='R';
                  else if ((rx.data[6]&0x0f)==0x02) System.signal_state.selector_position='N';
                  else if ((rx.data[6]&0x0f)==0x03) System.signal_state.selector_position='D';
                  else                              System.signal_state.selector_position='U';
                }System.Release();
              }
            }
            else if(rx.id==0x190)
            {
              if(rx.data[4]!=0xFF)
              {
                if(rx.data[4]&(1<<4)) System.can_state.cont_flags.driver_safety_belt=0;
                else                  System.can_state.cont_flags.driver_safety_belt=1;
              }

              if(rx.data[5]!=0xFF)
              {
                if(rx.data[5]&(1<<1)) System.can_state.cont_flags.passenger_safety_belt=0;
                else                  System.can_state.cont_flags.passenger_safety_belt=1;
              }
            }
            else if(rx.id==0x184)
            {
              if(rx.data[3]!=0xFF)
              {
                System.can_state.numeric_data.can_speed=rx.data[3];
              }
            }
            else if(rx.id==0x012)
            {
              uint32_t val=((rx.data[5]<<16)|(rx.data[6]<<8)|(rx.data[7]<<0));

              if(val!=0x00FFFFFF)
              {
                System.Grab(portMAX_DELAY);
                {
                  System.can_state.numeric_data.can_odo_km=val;
                }System.Release();
              }
            }
            else if(rx.id==0x460)
            {
              if(rx.data[5]!=0xff)
              {
                //Низкий уровень омывающей ждикости
                if(rx.data[5]&(1<<0)) System.signal_state.washer_liquid=1;
                else                  System.signal_state.washer_liquid=0;

                System.can_state.numeric_data.ad_blue_p=System.signal_state.washer_liquid;//temporary
              }
            }
            else if(rx.id==0x240)
            {
              if(rx.data[1]&(1<<4)) System.can_state.cont_flags.check_engine=1;
              else                  System.can_state.cont_flags.check_engine=0;
            }
            else if(rx.id==0x350)
            {
              if(rx.data[7]!=0xFF)
              {
                if(rx.data[7]==0x08 || rx.data[7]==0x10 ||rx.data[7]==0x40) System.can_state.cont_flags.chek_brake_pads=1;
                else                                                        System.can_state.cont_flags.chek_brake_pads=0;
              }
            }
            else if(rx.id==0x1A8)
            {
              //мочевина
            }
            else if(rx.id==0x430)
            {
              uint16_t val=((rx.data[4]<<8)|(rx.data[5]<<0));

              if(val!=0xFFFF)
              {
                val=val&0x3FF;

                System.Grab(portMAX_DELAY);
                {
                  //запас хода, расстоние до пустого бака
                  System.can_state.numeric_data.fuel_lev_l=val;
                }System.Release();
              }
            }
          }//if(rx.id_type==STD_ID_TYPE)
        }
        else if(can_id==CAN2_ID)
        {
          //Salon CAN, 500 кбит\с
          if(rx.id_type==STD_ID_TYPE)
          {
            if(rx.id==0x172)
            {
              /*
              RX 0033955 SFF 00000172 8 HEX        14       F9       40       13       06       00       C0       00 0201707737 20.02.2019 17:37:07.320
              RX 0033956 SFF 00000172 8 HEX        14       F9       40       13       06       00       C0       00 0201747680 20.02.2019 17:37:07.360
              RX 0033957 SFF 00000172 8 HEX        14       F9       40       13       06       00       C0       00 0201787856 20.02.2019 17:37:07.400
              RX 0033958 SFF 00000172 8 HEX        14       F9       40       13       02       00       C0       00 0201827536 20.02.2019 17:37:07.440
              RX 0033959 SFF 00000172 8 HEX        14       F9       40       13       02       00       C0       00 0201867485 20.02.2019 17:37:07.480
              RX 0033960 SFF 00000172 8 HEX        14       F9       40       13       02       00       C0       00 0201907440 20.02.2019 17:37:07.520
              RX 0033961 SFF 00000172 8 HEX        14       F9       40       13       02       00       C0       00 0201947402 20.02.2019 17:37:07.560
              */

              if(rx.data[0]==0x14)//не идет команда
              {
                if(rx.data[4]==0x06)       _cls_state=LOCKED_CLS_STATE;
                else if (rx.data[4]==0x02) _cls_state=UNLOCKED_CLS_STATE;
                else                       _cls_state=UNKNOWN_CLS_STATE;

                if(_cls_state==LOCKED_CLS_STATE)
                {
                  System.signal_state.cls_state.driver_door=0;
                  System.signal_state.cls_state.pass_door=0;
                  System.signal_state.cls_state.l_rear_door=0;
                  System.signal_state.cls_state.r_rear_door=0;
                }
                else
                {
                  System.signal_state.cls_state.driver_door=1;
                  System.signal_state.cls_state.pass_door=1;
                  System.signal_state.cls_state.l_rear_door=1;
                  System.signal_state.cls_state.r_rear_door=1;
                }

                System.signal_state.cls_state.driver_door_prepared=1;
                System.signal_state.cls_state.l_rear_door_prepared=1;
                System.signal_state.cls_state.r_rear_door_prepared=1;
                System.signal_state.cls_state.pass_door_prepared=1;
              }

              if(rx.data[7]!=0xFF)
              {
                if((rx.data[7]&(0x07<<3))==(0x01<<3)) System.signal_state.windows_position.driver_door=0;
                else                                  System.signal_state.windows_position.driver_door=1;

                System.signal_state.windows_position.driver_door_prepared=1;
              }

            }
            else if(rx.id==0x180)
            {
              if(rx.data[3]!=0xFF)
              {
                if((rx.data[3]&(0x07<<5))==(0x01<<5)) System.signal_state.windows_position.pass_door=0;
                else                                  System.signal_state.windows_position.pass_door=1;

                System.signal_state.windows_position.pass_door_prepared=1;
              }
            }
            else if(rx.id==0x220)
            {

              if(rx.data[7]!=0xFF)
              {
                if((rx.data[7]&(0x07<<0))==(0x01<<0)) System.signal_state.windows_position.l_rear_door=0;
                else                                  System.signal_state.windows_position.l_rear_door=1;

                System.signal_state.windows_position.l_rear_door_prepared=1;
              }
            }
            else if(rx.id==0x228)
            {
              if(rx.data[7]!=0xFF)
              {
                if((rx.data[7]&(0x07<<0))==(0x01<<0)) System.signal_state.windows_position.r_rear_door=0;
                else                                  System.signal_state.windows_position.r_rear_door=1;

                System.signal_state.windows_position.r_rear_door_prepared=1;
              }
            }
            else if(rx.id==0x1C8)
            {
              //none
            }
            else if(rx.id==0x110)
            {
              //0xFF - все закрыто
              if(rx.data[5]&(1<<0)) System.can_state.sec_flags.driver_door=0;
              else                  System.can_state.sec_flags.driver_door=1;

              if(rx.data[5]&(1<<1)) System.can_state.sec_flags.pass_door=0;
              else                  System.can_state.sec_flags.pass_door=1;

              if(rx.data[5]&(1<<2)) System.can_state.sec_flags.l_rear_door=0;
              else                  System.can_state.sec_flags.l_rear_door=1;

              if(rx.data[5]&(1<<3)) System.can_state.sec_flags.r_rear_door=0;
              else                  System.can_state.sec_flags.r_rear_door=1;

              if(rx.data[5]&(1<<4)) System.can_state.sec_flags.trunk=0;
              else                  System.can_state.sec_flags.trunk=1;

              if(rx.data[5]&(1<<5)) System.can_state.sec_flags.hood=0;
              else                  System.can_state.sec_flags.hood=1;
            }
            else if(rx.id==0x2B0)
            {
              uint16_t val=((rx.data[2]<<8)|(rx.data[3]<<0));

              if(val==0x5221) {System.can_state.cont_flags.marker_lights=0; System.can_state.cont_flags.dipped_beam=0;}
              else            {System.can_state.cont_flags.marker_lights=1; System.can_state.cont_flags.dipped_beam=1;}

              if(((rx.data[5]&0xF0)==0x40) || ((rx.data[5]&0xF0)==0x10)) System.can_state.cont_flags.high_beam=1;
              else                                                       System.can_state.cont_flags.high_beam=0;
            }
            else if(rx.id==0x1E1)
            {
              if(rx.data[0]!=0xFF)
              {
                if(rx.data[0]==0x5F) System.signal_state.emergency_lights=1;
                else                 System.signal_state.emergency_lights=0;
              }
            }
          }//if(rx.id_type==STD_ID_TYPE)
        }
        else if(can_id==CAN3_ID)
        {
          //OBD CAN, 500 кбит\с
          if(rx.id_type==STD_ID_TYPE)
          {
            if(rx.id==0x7E8)
            {
              //OBDII ответ
              if(rx.data[0]==0x04 && rx.data[1]==0x62 && rx.data[2]==0xF4 && rx.data[3]==0x2F)
              {
                System.set_fuel_level_p((rx.data[4]*100Ul)/255Ul);
              }
              else if(rx.data[0]==0x04 && rx.data[1]==0x62 && rx.data[2]==0x03 && rx.data[3]==0xF3)
              {
                System.Grab(portMAX_DELAY);
                {
                  System.can_state.numeric_data.eng_temp=rx.data[4]-40.0f;
                }System.Release();
              }
              else if(rx.data[0]==0x05 && rx.data[1]==0x62 && rx.data[2]==0xF4 && rx.data[3]==0x67 && rx.data[4]==0x68)
              {
                //не работает
                /*
                System.Grab(portMAX_DELAY);
                {
                  System.can_state.numeric_data.eng_temp=rx.data[5]-40.0f;
                }System.Release();
                */
              }
            }
          }//if(rx.id_type==STD_ID_TYPE)
        }
    }

    if(mess_count)
    {
      restart_sleep_and_rx_timers(can_id);
    }
  }

  System.can_state.sec_flags.can_in_sleep=can_sleep_indicate_handler();

  blocks_handler();

  range_rover_velar_analog_to_can_handler();

  taxi_blocks_handler();
}

static void can_rx_nissan_qashqai_2018_handler(void)
{
  can_rx_frame_t rx;

  for(uint8_t can_id=CAN1_ID; can_id<HW_CAN_COUNT; can_id++)
  {
    uint16_t mess_count=filled_count_in_sfifo(&can_rx_sfifo[can_id]);

    for(uint16_t j=0; j<mess_count; j++)
    {
      if(!read_from_sfifo(&can_rx_sfifo[can_id], &rx))
      {
        __PRINTF("%s_RX sfifo is full, drop counter: %lu\n", get_name_from_can_id(can_id), can_rx_sfifo[can_id].drop_counter);
      }

#if defined(CAN_VEGA_FWD_PRESENT)
      rx_fwd_hadler(can_id, &rx);
#endif //defined(CAN_VEGA_FWD_PRESENT)

#if defined(YANDEX_OBD_PRESENT)
      obd_rx_handler(can_id, &rx);
#endif //defined(YANDEX_OBD_PRESENT)

      can_rx_debug_trace(&rx, can_id);

        if(can_id==CAN1_ID)
        {
          //OBD CAN, 500 кбит\с
          if(rx.id_type==STD_ID_TYPE)
          {
            if(rx.id==0x41F)
            {
              uint8_t val=rx.data[0];

              if(val!=0xFF)
              {
                val=val&0xF8;

                System.Grab(portMAX_DELAY);
                {
                  if(val==0x08)      {System.can_state.sec_flags.parking=1; System.can_state.sec_flags.reverse_gear=0;}
                  else if(val==0x10) {System.can_state.sec_flags.parking=0; System.can_state.sec_flags.reverse_gear=1;}
                  else               {System.can_state.sec_flags.parking=0; System.can_state.sec_flags.reverse_gear=0;}

                  if(val==0x08)      System.signal_state.selector_position='P';
                  else if(val==0x10) System.signal_state.selector_position='R';
                  else if(val==0x18) System.signal_state.selector_position='N';
                  else if(val==0x20) System.signal_state.selector_position='D';
                  else if(val==0x80) System.signal_state.selector_position='M';
                  else               System.signal_state.selector_position='U';
                }System.Release();
              }
            }
            else if(rx.id==0x002)
            {
              //Угол поворота руля
              int16_t angle = (rx.data[1] << 8) | rx.data[0];
              System.can_state.numeric_data.battery_charge_level = angle / 10.0f; // steering wheels
              System.can_state.numeric_data.thresher_rpm = rx.data[2]; // steering acceleraion
            }
            else if(rx.id==0x15A)
            {
              if(rx.data[2]!=0xFF)
              {
                System.can_state.numeric_data.accelerator=(rx.data[2]*100Ul)/0xC7;
              }
            }
            else if(rx.id==0x454)
            {
              System.can_state.numeric_data.can_axle_1=rx.data[2];//temporary
              if(rx.data[2]!=0xFF)
              {
                //if(rx.data[2]&(1<<5)) System.can_state.sec_flags.pedal_break=0;
                //else                  System.can_state.sec_flags.pedal_break=1;
              }

              System.can_state.numeric_data.can_axle_2=(rx.data[5]<<8)|(rx.data[6]<<0);//temporary
              if(rx.data[5]!=0xFF)
              {
                if((rx.data[5]&0xC0)==0x40) System.can_state.sec_flags.driver_door=0;
                else                        System.can_state.sec_flags.driver_door=1;

                if((rx.data[5]&0x0C)==0x04) System.can_state.sec_flags.l_rear_door=0;
                else                        System.can_state.sec_flags.l_rear_door=1;

                if((rx.data[5]&0x30)==0x10) System.can_state.sec_flags.pass_door=0;
                else                        System.can_state.sec_flags.pass_door=1;

                if((rx.data[5]&0x03)==0x01) System.can_state.sec_flags.r_rear_door=0;
                else                        System.can_state.sec_flags.r_rear_door=1;
              }

              if(rx.data[6]!=0xFF)
              {
                if(rx.data[6]&(1<<6)) System.can_state.sec_flags.pedal_break=1;
                else                  System.can_state.sec_flags.pedal_break=0;

                if(rx.data[6]&(1<<7)) System.can_state.sec_flags.trunk=1;
                else                  System.can_state.sec_flags.trunk=0;
              }
            }
            else if(rx.id==0x5D9)
            {
              if(rx.data[0]!=0xFF)
              {
                if(rx.data[0]&(1<<4)) System.can_state.sec_flags.hand_break=1;
                else                  System.can_state.sec_flags.hand_break=0;
              }
            }
            else if(rx.id==0x02A)
            {
              if(rx.data[2]!=0xFF)
              {
                if(rx.data[2]&(1<<0)) System.can_state.cont_flags.airbag=1;
                else                  System.can_state.cont_flags.airbag=0;
              }
            }
            else if(rx.id==0x17B)
            {
              if(rx.data[3]!=0xFF)
              {
                if(rx.data[3]&(1<<4)) System.signal_state.eco_mode=1;
                else                  System.signal_state.eco_mode=0;
              }
            }
            else if(rx.id==0x15C)
            {
              uint16_t val=((rx.data[0]<<8)|(rx.data[1]<<0));

              if(val!=0xFFFF)
              {
                val=val/8;

                System.Grab(portMAX_DELAY);
                {
                  System.can_state.numeric_data.eng_rpm=val;

                  if(System.can_state.numeric_data.eng_rpm>350) System.can_state.sec_flags.engine_is_on=1;
                  else                                          System.can_state.sec_flags.engine_is_on=0;
                }System.Release();
              }
            }
            else if(rx.id==0x224)
            {
              if(rx.data[0]!=0xFF)
              {
                if(rx.data[0]&(1<<5)) System.can_state.cont_flags.abs=0;
                else                  System.can_state.cont_flags.abs=1;
              }
            }
            else if(rx.id==0x29A)
            {
              if(rx.data[4]!=0xFF)
              {
                System.can_state.numeric_data.concave_clear=rx.data[4];//temporarry
                System.can_state.numeric_data.can_speed=(rx.data[4]*26UL)/10UL;
              }
            }
            else if(rx.id==0x300)
            {
              if(rx.data[1]!=0xFF)
              {
                //неисправность рулевого управления
                if(rx.data[1]&(1<<6)) System.can_state.cont_flags.stop=1;
                else                  System.can_state.cont_flags.stop=0;
              }
            }
            else if(rx.id==0x353)
            {
              if(rx.data[4]!=0xFF)
              {
                if(rx.data[4]&(1<<6)) System.can_state.cont_flags.esp=1;
                else                  System.can_state.cont_flags.esp=0;
              }
            }
            else if(rx.id==0x411)
            {
              if(rx.data[0]!=0xFF)
              {
                System.Grab(portMAX_DELAY);
                {
                  System.can_state.numeric_data.eng_temp=rx.data[0]-40.0f;
                }System.Release();
              }
            }
            else if(rx.id==0x412)
            {
              if(rx.data[1]!=0xFF)
              {
                if(rx.data[1]==0x30) System.can_state.cont_flags.check_engine=1;
                else                 System.can_state.cont_flags.check_engine=0;
              }
            }
            else if(rx.id==0x451)
            {
              if(rx.data[0]!=0xFF)
              {
                if(rx.data[0]==0x10) System.can_state.cont_flags.battery=1;
                else                 System.can_state.cont_flags.battery=0;
              }
            }
            else if(rx.id==0x453)
            {
              if(rx.data[0]!=0xFF)
              {
                if(rx.data[0]&(1<<0)) System.can_state.cont_flags.marker_lights=1;
                else                  System.can_state.cont_flags.marker_lights=0;
              }

              if(rx.data[1]!=0xFF)
              {
                if(rx.data[1]&(1<<7)) System.can_state.cont_flags.dipped_beam=1;
                else                  System.can_state.cont_flags.dipped_beam=0;

                if(rx.data[1]&(1<<6)) System.can_state.cont_flags.high_beam=1;
                else                  System.can_state.cont_flags.high_beam=0;

                if((rx.data[1]&0x03)==0x03)
                {
                  System.signal_state.emergency_lights=1;
                  restart_can_timer(EMERG_LIGHT_FIX_TIMER, 2500);
                }
              }
            }
            else if(rx.id==0x4F9)
            {
              if(rx.data[3]!=0xFF)
              {
                if(rx.data[3]&(1<<1)) System.can_state.cont_flags.driver_safety_belt=1;
                else                  System.can_state.cont_flags.driver_safety_belt=0;
              }
            }
            else if(rx.id==0x456)
            {
              if(rx.data[1]!=0xFF)
              {
                if(rx.data[1]==0x38) System.can_state.sec_flags.closed_by_pult=1;
                else                 System.can_state.sec_flags.closed_by_pult=0;

                if((rx.data[1]&0x0F)==0x08) _cls_state=LOCKED_CLS_STATE;
                else                        _cls_state=UNLOCKED_CLS_STATE;

                if(_cls_state==LOCKED_CLS_STATE)
                {
                  System.signal_state.cls_state.driver_door=0;
                  System.signal_state.cls_state.pass_door=0;
                  System.signal_state.cls_state.l_rear_door=0;
                  System.signal_state.cls_state.r_rear_door=0;
                }
                else
                {
                  System.signal_state.cls_state.driver_door=1;
                  System.signal_state.cls_state.pass_door=1;
                  System.signal_state.cls_state.l_rear_door=1;
                  System.signal_state.cls_state.r_rear_door=1;
                }

                System.signal_state.cls_state.driver_door_prepared=1;
                System.signal_state.cls_state.l_rear_door_prepared=1;
                System.signal_state.cls_state.r_rear_door_prepared=1;
                System.signal_state.cls_state.pass_door_prepared=1;
              }
            }
            else if(rx.id==0x208)
            {
              if(rx.data[0]!=0xFF)
              {
                if(rx.data[0]&(1<<7)) System.can_state.sec_flags.ignition=0;
                else                  System.can_state.sec_flags.ignition=1;
              }
            }
            else if(rx.id==0x2D3)
            {
              uint32_t val=((rx.data[2]<<16)|(rx.data[3]<<8)|(rx.data[4]<<0));

              if(val!=0xFFFFFF)
              {
                val=val/10;

                System.Grab(portMAX_DELAY);
                {
                  System.can_state.numeric_data.can_odo_km=val;
                }System.Release();
              }

              /*
              System.can_state.numeric_data.brake=rx.data[7];
              if(rx.data[7]!=0xFF)
              {
              if(rx.data[7]>=0x82) System.set_fuel_level_p(0);
              else                 System.set_fuel_level_p(260UL-(rx.data[7]*2Ul));
            }
              */
            }
            else if(rx.id==0x4F2)
            {
              uint16_t val=((rx.data[6]<<8)|(rx.data[7]<<0));

              if(val<0xFFFE)
              {
                val=val/10;

                System.Grab(portMAX_DELAY);
                {
                  System.can_state.numeric_data.fuel_lev_l=val;
                }System.Release();
              }
            }
            else if(rx.id==0x763)
            {
              static uint8_t isotp_packet_count=0;

              if(rx.data[0]==0x10 && rx.data[1]==0x66 && rx.data[2]==0x61)
              {
                isotp_packet_count=1;
              }
              else if(isotp_packet_count==1 && rx.data[0]==0x21)
              {
                isotp_packet_count=2;
              }
              else if(isotp_packet_count==2 && rx.data[0]==0x22)
              {
                //в литрах, бак 60л, по факту влазит 67л, машина показывает 71
                if(rx.data[2]!=0xFF)
                {
                  /*
                  л  - rx.data[2]
                  10 - 12
                  20 - 25
                  30 - 37
                  40 - 49
                  50 - 62
                  60 - 70
                  67 - 71
                  */

                  /*
                  uint8_t val=(uint8_t)lroundf((float)rx.data[2]*0.8571f);

                  System.Grab(portMAX_DELAY);
                  {
                    System.can_state.numeric_data.fuel_lev_l=val;
                  }System.Release();
                  */

                  if(rx.data[2]>=70) {
                    System.set_fuel_level_p(100);
                  } else {
                    System.set_fuel_level_p((rx.data[2]*100Ul)/70Ul);
                  }
                }

                isotp_packet_count=3;
              }
              else if(isotp_packet_count==3 && rx.data[0]==0x23)
              {
                if(rx.data[2]!=0xFF)
                {
                  if(rx.data[2]&(1<<3)) System.signal_state.washer_liquid=1;
                  else                  System.signal_state.washer_liquid=0;
                }
              }
              else
              {
                isotp_packet_count=0;
              }
            }
          }//if(rx.id_type==STD_ID_TYPE)
        }
        else if(can_id==CAN2_ID)
        {
          //none
        }
        else if(can_id==CAN3_ID)
        {
          //none
        }
    }

    if(mess_count)
    {
      restart_sleep_and_rx_timers(can_id);
    }
  }

  System.can_state.sec_flags.can_in_sleep=can_sleep_indicate_handler();

  blocks_handler();

  qashqai_analog_to_can_handler();

  taxi_blocks_handler();
}

static void can_rx_hyundai_creta_2019_handler(void)
{
  can_rx_frame_t rx;

  for(uint8_t can_id=CAN1_ID; can_id<HW_CAN_COUNT; can_id++)
  {
    uint16_t mess_count=filled_count_in_sfifo(&can_rx_sfifo[can_id]);

    for(uint16_t j=0; j<mess_count; j++)
    {
      if(!read_from_sfifo(&can_rx_sfifo[can_id], &rx))
      {
        __PRINTF("%s_RX sfifo is full, drop counter: %lu\n", get_name_from_can_id(can_id), can_rx_sfifo[can_id].drop_counter);
      }

#if defined(CAN_VEGA_FWD_PRESENT)
      rx_fwd_hadler(can_id, &rx);
#endif //defined(CAN_VEGA_FWD_PRESENT)

#if defined(YANDEX_OBD_PRESENT)
      obd_rx_handler(can_id, &rx);
#endif //defined(YANDEX_OBD_PRESENT)

      can_rx_debug_trace(&rx, can_id);

        if(can_id==CAN1_ID)
        {
          //Saloon CAN, 100 кбит\с
          if(rx.id_type==STD_ID_TYPE)
          {
            if(rx.id==0x168)
            {
              if(!(rx.data[0]==0xFF || rx.data[2]==0xFF || rx.data[4]==0xFF || rx.data[5]==0xFF))
              {
                if(rx.data[2]&(1<<2)) System.signal_state.cls_state.driver_door=1;
                else                  System.signal_state.cls_state.driver_door=0;
                System.signal_state.cls_state.driver_door_prepared=1;

                if(rx.data[4]&(1<<0)) System.signal_state.cls_state.l_rear_door=1;
                else                  System.signal_state.cls_state.l_rear_door=0;
                System.signal_state.cls_state.l_rear_door_prepared=1;

                if(rx.data[5]&(1<<5)) System.signal_state.cls_state.r_rear_door=1;
                else                  System.signal_state.cls_state.r_rear_door=0;
                System.signal_state.cls_state.r_rear_door_prepared=1;

                if(rx.data[0]&(1<<3)) System.signal_state.cls_state.pass_door=1;
                else                  System.signal_state.cls_state.pass_door=0;
                System.signal_state.cls_state.pass_door_prepared=1;

                if(System.signal_state.cls_state.driver_door || System.signal_state.cls_state.l_rear_door || System.signal_state.cls_state.r_rear_door || System.signal_state.cls_state.pass_door) _cls_state=UNLOCKED_CLS_STATE;
                else                                                                                                                                                                               _cls_state=LOCKED_CLS_STATE;

                if(System.signal_state.cls_state.driver_door || System.signal_state.cls_state.l_rear_door || System.signal_state.cls_state.r_rear_door || System.signal_state.cls_state.pass_door) System.can_state.sec_flags.closed_by_pult=0;
                else                                                                                                                                                                               System.can_state.sec_flags.closed_by_pult=1;

                if(rx.data[2]&(1<<6)) System.can_state.sec_flags.driver_door=1;
                else                  System.can_state.sec_flags.driver_door=0;

                if(rx.data[4]&(1<<2)) System.can_state.sec_flags.l_rear_door=1;
                else                  System.can_state.sec_flags.l_rear_door=0;

                if(rx.data[5]&(1<<7)) System.can_state.sec_flags.r_rear_door=1;
                else                  System.can_state.sec_flags.r_rear_door=0;

                if(rx.data[0]&(1<<7)) System.can_state.sec_flags.pass_door=1;
                else                  System.can_state.sec_flags.pass_door=0;

                if(rx.data[5]&(1<<1)) System.can_state.sec_flags.trunk=1;
                else                  System.can_state.sec_flags.trunk=0;
              }
            }
            else if(rx.id==0x103)
            {
              if(rx.data[3]!=0xFF)
              {
                if((rx.data[3]&0x0F)==0x08) System.signal_state.emergency_lights=1;
                else                        System.signal_state.emergency_lights=0;
              }
            }
            else if(rx.id==0x102)
            {
              if(rx.data[2]!=0xFF)
              {
                if(rx.data[2]&(1<<1)) System.can_state.cont_flags.marker_lights=1;
                else                  System.can_state.cont_flags.marker_lights=0;

                if(rx.data[2]&(1<<2)) System.can_state.cont_flags.dipped_beam=1;
                else                  System.can_state.cont_flags.dipped_beam=0;

                if(rx.data[2]&(1<<3)) System.can_state.cont_flags.high_beam=1;
                else                  System.can_state.cont_flags.high_beam=0;
              }
            }
          }//if(rx.id_type==STD_ID_TYPE)
        }
        else if(can_id==CAN2_ID)
        {
          //Motor CAN, 500 кбит\с
          if(rx.id_type==STD_ID_TYPE)
          {
            if(rx.id==0x541)
            {
              System.can_state.numeric_data.can_axle_1=rx.data[0];
              if((rx.data[0]&0x0f)==0x01 || (rx.data[0]&0x0f)==0x02 || (rx.data[0]&0x0f)==0x03 || (rx.data[0]&0x0f)==0x04) System.can_state.sec_flags.key_in_ign=1;
              else                                                                                                         System.can_state.sec_flags.key_in_ign=0;

              if((rx.data[0]&0x0f)==0x03 || (rx.data[0]&0x0f)==0x04) System.can_state.sec_flags.ignition=1;
              else                                                   System.can_state.sec_flags.ignition=0;

              if((rx.data[0]&0x0f)==0x00)      System.signal_state.key_position='O';
              if((rx.data[0]&0x0f)==0x00)      System.signal_state.key_position='K';
              else if((rx.data[0]&0x0f)==0x02) System.signal_state.key_position='A';
              else if((rx.data[0]&0x0f)==0x03) System.signal_state.key_position='I';
              else if((rx.data[0]&0x0f)==0x04) System.signal_state.key_position='S';
              else                             System.signal_state.key_position='U';

              if(rx.data[1]!=0xFF)
              {
                if(rx.data[1]&(1<<2)) System.can_state.cont_flags.driver_safety_belt=1;
                else                  System.can_state.cont_flags.driver_safety_belt=0;
              }

              if(rx.data[7]!=0xFF)
              {
                if(rx.data[7]&(1<<4))  System.can_state.sec_flags.hand_break=1;
                else                   System.can_state.sec_flags.hand_break=0;
              }

              if(rx.data[2]!=0xFF)
              {
                //нет концевика
                //if(rx.data[2]&(1<<1))  System.can_state.sec_flags.hood=1;
                //else                   System.can_state.sec_flags.hood=0;
              }
            }
            else if(rx.id==0x316)
            {
              //на рио должно быть так-же
              uint16_t val=((rx.data[3]<<8)|(rx.data[2]<<0));

              if(val!=0xFFFF)
              {
                val=val/4;
                System.Grab(portMAX_DELAY);
                {
                  System.can_state.numeric_data.eng_rpm=val;

                  if(System.can_state.numeric_data.eng_rpm>350) System.can_state.sec_flags.engine_is_on=1;
                  else                                          System.can_state.sec_flags.engine_is_on=0;
                }System.Release();
              }
            }
            /*
            else if(rx.id==0x386)
            {
              if(rx.data[7]!=0xFF)
              {
                System.can_state.numeric_data.can_speed=((rx.data[7]&0x3F)*5);
              }
            }
            */
            else if(rx.id==0x52A)
            {
              //скорость
              if(rx.data[0]!=0xFF)
              {
                System.can_state.numeric_data.can_speed=rx.data[0];
              }
            }
            else if(rx.id==0x5B0)
            {
              System.Grab(portMAX_DELAY);
              {
                System.can_state.numeric_data.can_odo_km=((rx.data[3]<<24)|(rx.data[2]<<16)|(rx.data[1]<<8)|(rx.data[0]<<0))/10.f;
              }System.Release();
            }
            else if(rx.id==0x329)
            {
              if(rx.data[6]!=0xFF)
              {
                System.can_state.numeric_data.accelerator=(rx.data[6]*100Ul)/0xFE;
              }

              if(rx.data[4]!=0xFF)
              {
                if(rx.data[4]&(1<<1)) System.can_state.sec_flags.pedal_break=1;
                else                  System.can_state.sec_flags.pedal_break=0;
              }
            }
            else if(rx.id==0x549)
            {
              if(rx.data[0]!=0xFF)
              {
                //if(rx.data[0]&(1<<7)) System.can_state.sec_flags.pedal_break=1;
                //else                  System.can_state.sec_flags.pedal_break=0;
              }
            }
            else if(rx.id==0x545)
            {
              if(rx.data[0]!=0xFF)
              {
                if(rx.data[0]&(1<<1)) System.can_state.cont_flags.check_engine=1;
                else                  System.can_state.cont_flags.check_engine=0;
              }

              if(rx.data[3]!=0xFF)
              {
                //System.Grab(portMAX_DELAY);
                //{
                //  System.can_state.numeric_data.eng_temp=rx.data[3]-44.0f;
                //}System.Release();
              }
            }
            else if(rx.id==0x556)
            {
              if(rx.data[1]!=0xFF)
              {
                System.Grab(portMAX_DELAY);
                {
                  System.can_state.numeric_data.eng_temp=rx.data[1]-40.0f;
                }System.Release();
              }
            }
            else if(rx.id==0x251)
            {
              //угол поворота рулевого колеса
            }
            else if(rx.id==0x111)
            {
              System.can_state.numeric_data.can_axle_2=rx.data[1];
              if(rx.data[1]!=0xFF)
              {
                System.Grab(portMAX_DELAY);
                {
                  if((rx.data[1]&0x0f)==0x00)      {System.can_state.sec_flags.parking=1; System.can_state.sec_flags.reverse_gear=0;}
                  else if((rx.data[1]&0x0f)==0x07) {System.can_state.sec_flags.parking=0; System.can_state.sec_flags.reverse_gear=1;}
                  else                             {System.can_state.sec_flags.parking=0; System.can_state.sec_flags.reverse_gear=0;}

                  if((rx.data[1]&0x0f)==0x00)       System.signal_state.selector_position='P';
                  else if ((rx.data[1]&0x0f)==0x07) System.signal_state.selector_position='R';
                  else if ((rx.data[1]&0x0f)==0x06) System.signal_state.selector_position='N';
                  else if ((rx.data[1]&0x0f)==0x05) System.signal_state.selector_position='D';
                  else if ((rx.data[1]&0x0f)==0x08) System.signal_state.selector_position='M';
                  else if ((rx.data[1]&0x0f)==0x09) System.signal_state.selector_position='U';
                }System.Release();
              }
            }
            else if(rx.id==0x5A0)
            {
              if(rx.data[4]!=0xFF)
              {
                if(rx.data[4]&(1<<0)) System.can_state.cont_flags.airbag=0; //18 - горит, 19 - не горит
                else                  System.can_state.cont_flags.airbag=1;
              }
            }
            else if(rx.id==0x7CE)
            {
              //todo: нужно попробовать на генезис, рио и солярис
              static uint8_t uds_cmd_byte=0xFF;

              if(rx.data[0]==0x10)
              {
                can_timers[UDS_ANS_TIMER_ID]=550; can_timers[UDS_ANS_TIMER_ID]=550;
                uds_cmd_byte=rx.data[4];
              }
              else if(rx.data[0]==0x21 && uds_cmd_byte!=0xFF && can_timers[UDS_ANS_TIMER_ID])
              {
                if(uds_cmd_byte==0x02 && rx.data[2]!=0xFF)
                {
                  System.set_fuel_level_p(rx.data[2]);
                }
                else if(uds_cmd_byte==0x03 && rx.data[2]!=0xFF)
                {
                  if(rx.data[2]&(1<<4)) System.signal_state.washer_liquid=1;
                  else                  System.signal_state.washer_liquid=0;

                  if(rx.data[2]&(1<<3)) System.can_state.cont_flags.battery=1;
                  else                  System.can_state.cont_flags.battery=0;

                  if(rx.data[2]&(1<<2)) System.can_state.cont_flags.chek_oil=1;
                  else                  System.can_state.cont_flags.chek_oil=0;
                }

                uds_cmd_byte=0xFF;
              }
              else
              {
                uds_cmd_byte=0xFF;
              }
            }
          }//if(rx.id_type==STD_ID_TYPE)
        }
        else if(can_id==CAN3_ID)
        {
          //none
        }
    }

    if(mess_count)
    {
      restart_sleep_and_rx_timers(can_id);
    }
  }

  System.can_state.sec_flags.can_in_sleep=can_sleep_indicate_handler();

  blocks_handler();

  hyundai_creta_analog_to_can_handler();

  taxi_blocks_handler();
}

static void can_rx_bmw_x1_2019_handler(void)
{
  can_rx_frame_t rx;

  for(uint8_t can_id=CAN1_ID; can_id<HW_CAN_COUNT; can_id++)
  {
    uint16_t mess_count=filled_count_in_sfifo(&can_rx_sfifo[can_id]);

    for(uint16_t j=0; j<mess_count; j++)
    {
      if(!read_from_sfifo(&can_rx_sfifo[can_id], &rx))
      {
        __PRINTF("%s_RX sfifo is full, drop counter: %lu\n", get_name_from_can_id(can_id), can_rx_sfifo[can_id].drop_counter);
      }

#if defined(CAN_VEGA_FWD_PRESENT)
      rx_fwd_hadler(can_id, &rx);
#endif //defined(CAN_VEGA_FWD_PRESENT)

#if defined(YANDEX_OBD_PRESENT)
      obd_rx_handler(can_id, &rx);
#endif //defined(YANDEX_OBD_PRESENT)

      can_rx_debug_trace(&rx, can_id);

        if(can_id==CAN1_ID)
        {
          //OBD CAN, 500 кбит\с
          if(rx.id_type==STD_ID_TYPE)
          {
            switch(rx.id)
            {

            default:
              break;
            }
          }//if(rx.id_type==STD_ID_TYPE)
        }
        else if(can_id==CAN2_ID)
        {
          //Motor CAN, 500 кбит\с
          if(rx.id_type==STD_ID_TYPE)
          {
            switch(rx.id)
            {
            case 0x0A5:
              {
                if(rx.data[6]!=0xFF)
                {
                  System.Grab(portMAX_DELAY);
                  {
                    System.can_state.numeric_data.eng_rpm=(rx.data[6]*64UL);

                    if(System.can_state.numeric_data.eng_rpm>350) System.can_state.sec_flags.engine_is_on=1;
                    else                                          System.can_state.sec_flags.engine_is_on=0;
                  }System.Release();
                }
              }
              break;

            case 0x0D9:
              {
                if(rx.data[2]!=0xFF)
                {
                  System.can_state.numeric_data.accelerator=(rx.data[2]*100Ul)/0xA0;
                }
              }
              break;

            case 0x2FC:
              {
                if(rx.data[0]!=0xFF)
                {
                  if((0x03&rx.data[0])==0x02)      _cls_state=LOCKED_CLS_STATE;
                  else if((0x03&rx.data[0])==0x01) _cls_state=UNLOCKED_CLS_STATE;
                  else                             _cls_state=UNKNOWN_CLS_STATE;

                  if(_cls_state==LOCKED_CLS_STATE)
                  {
                    System.signal_state.cls_state.driver_door=0;
                    System.signal_state.cls_state.pass_door=0;
                    System.signal_state.cls_state.l_rear_door=0;
                    System.signal_state.cls_state.r_rear_door=0;
                  }
                  else
                  {
                    System.signal_state.cls_state.driver_door=1;
                    System.signal_state.cls_state.pass_door=1;
                    System.signal_state.cls_state.l_rear_door=1;
                    System.signal_state.cls_state.r_rear_door=1;
                  }
                }

                System.signal_state.cls_state.driver_door_prepared=1;
                System.signal_state.cls_state.l_rear_door_prepared=1;
                System.signal_state.cls_state.r_rear_door_prepared=1;
                System.signal_state.cls_state.pass_door_prepared=1;

                if(rx.data[1]!=0xFF)
                {
                  if(rx.data[1]&(1<<0)) System.can_state.sec_flags.driver_door=1;
                  else                  System.can_state.sec_flags.driver_door=0;


                  if(rx.data[1]&(1<<2)) System.can_state.sec_flags.pass_door=1;
                  else                  System.can_state.sec_flags.pass_door=0;

                  if(rx.data[1]&(1<<4)) System.can_state.sec_flags.l_rear_door=1;
                  else                  System.can_state.sec_flags.l_rear_door=0;

                  if(rx.data[1]&(1<<6)) System.can_state.sec_flags.r_rear_door=1;
                  else                  System.can_state.sec_flags.r_rear_door=0;
                }

                if(rx.data[2]!=0xFF)
                {
                  if(rx.data[2]&(1<<0)) System.can_state.sec_flags.trunk=1;
                  else                  System.can_state.sec_flags.trunk=0;

                  if(rx.data[2]&(1<<2)) System.can_state.sec_flags.hood=1;
                  else                  System.can_state.sec_flags.hood=0;
                }
              }
              break;

            case 0x0DC:
              {
                if(rx.data[2]!=0xFF)
                {
                  System.Grab(portMAX_DELAY);
                  {
                    if((rx.data[2]&0x0f)==0x02 && (rx.data[5]&0x0f)==0x0E)      {System.can_state.sec_flags.parking=1; System.can_state.sec_flags.reverse_gear=0;}
                    else if((rx.data[2]&0x0f)==0x05 && (rx.data[5]&0x0f)==0x04) {System.can_state.sec_flags.parking=0; System.can_state.sec_flags.reverse_gear=1;}
                    else                                                        {System.can_state.sec_flags.parking=0; System.can_state.sec_flags.reverse_gear=0;}

                    if((rx.data[2]&0x0f)==0x02 && (rx.data[5]&0x0f)==0x0E)       System.signal_state.selector_position='P';
                    else if ((rx.data[2]&0x0f)==0x05 && (rx.data[5]&0x0f)==0x04) System.signal_state.selector_position='R';
                    else if ((rx.data[2]&0x0f)==0x02 && (rx.data[5]&0x0f)==0x0C) System.signal_state.selector_position='N';
                    else if ((rx.data[2]&0x0f)==0x04 && (rx.data[5]&0x0f)==0x04) System.signal_state.selector_position='D';
                    else                                                         System.signal_state.selector_position='U';
                  }System.Release();
                }
              }
              break;

            case 0x173:
              {
                //if(rx.data[7]!=0xFF)
                //{
                //  if(rx.data[7]&(1<<4))  System.can_state.sec_flags.hand_break=1;
                //  else                   System.can_state.sec_flags.hand_break=0;
                //}
              }
              break;

            case 0x330:
              {
                uint32_t val=((rx.data[2]<<16)|(rx.data[1]<<8)|(rx.data[0]<<0));

                if(val!=0xFFFFFF)
                {
                  System.Grab(portMAX_DELAY);
                  {
                    System.can_state.numeric_data.can_odo_km=val;
                  }System.Release();
                }

                val=rx.data[3];

                if(val!=0xFF)
                {
                  //System.can_state.numeric_data.fuel_lev_l=val;

                  if(val>=51) {
                    System.set_fuel_level_p(100);
                  } else {
                    System.set_fuel_level_p((val*100Ul)/51Ul);
                  }
                }

                //запас хода
                val=((rx.data[7]<<8)|(rx.data[6]<<0))>>4;

                if(val!=0xFF)
                {
                  System.Grab(portMAX_DELAY);
                  {
                    System.can_state.numeric_data.fuel_lev_l=val;
                  }System.Release();
                }
              }
              break;

            case 0x03C:
              {
                if(rx.data[1]!=0xFF)
                {
                  if(rx.data[1]&(1<<5)) System.can_state.sec_flags.ignition=1;
                  else                  System.can_state.sec_flags.ignition=0;
                }
              }
              break;

            case 0x12F:
              {
                if(rx.data[6]!=0xFF)
                {
                  if(rx.data[6]&(1<<0)) System.can_state.sec_flags.pedal_break=1;
                  else                  System.can_state.sec_flags.pedal_break=0;
                }
              }
              break;

            case 0x581:
              {
                if(rx.data[3]!=0xFF)
                {
                  if(rx.data[3]&(1<<0)) System.can_state.cont_flags.driver_safety_belt=0;
                  else                  System.can_state.cont_flags.driver_safety_belt=1;
                }
              }
              break;

            case 0x1A1:
              {
                uint16_t val=((rx.data[3]<<8)|(rx.data[2]<<0));

                if(val!=0xFFFF)
                {
                  val=(val*15)/1000;

                  System.can_state.numeric_data.can_speed=val;
                }
              }
              break;

            case 0x1B3:
              {
                if(rx.data[6]!=0xFF)
                {
                  if(rx.data[6]&(1<<3)) System.can_state.sec_flags.hand_break=1;
                  else                  System.can_state.sec_flags.hand_break=0;
                }

                if(rx.data[4]!=0xFF)
                {
                  if(rx.data[4]&(1<<1)) System.can_state.cont_flags.airbag=1;
                  else                  System.can_state.cont_flags.airbag=0;

                  if(rx.data[4]&(1<<4)) System.can_state.cont_flags.check_engine=1;
                  else                  System.can_state.cont_flags.check_engine=0;
                }

                if(rx.data[1]!=0xFF)
                {
                  //надписи на экране, меняются поочередно
                  if(rx.data[1]==0x93)
                  {
                    System.can_state.cont_flags.inflation_pressure=1;
                    restart_can_timer(AUX_CAN_TIMER_1, 60000);
                  }

                  if(rx.data[1]==0x10)
                  {
                    System.can_state.cont_flags.serv_maint=1;
                    restart_can_timer(AUX_CAN_TIMER_2, 60000);
                  }

                  if(rx.data[1]==0xA4)
                  {
                    System.signal_state.washer_liquid=1;
                    restart_can_timer(AUX_CAN_TIMER_3, 60000);
                  }
                }
              }
              break;

            case 0x1F6:
              {
                if(rx.data[0]!=0xFF)
                {
                  if((rx.data[0]&((1<<4)|(1<<5)))==((1<<4)|(1<<5))) System.signal_state.emergency_lights=1;
                  else                                              System.signal_state.emergency_lights=0;
                }
              }
              break;

            case 0x3F9:
              {
                if(rx.data[4]<0xFE)
                {
                  System.Grab(portMAX_DELAY);
                  {
                    System.can_state.numeric_data.eng_temp=rx.data[4]-48.0f;
                  }System.Release();
                }
              }
              break;

            case 0x302:
              {
                //положение руля
                int32_t val=((rx.data[2])<<8)|((rx.data[3])<<0);

                //System.Grab(portMAX_DELAY);
                System.can_state.numeric_data.battery_charge_level=val;//temporary
                //System.Release();
              }
              break;

            default:
              break;
            }
          }//if(rx.id_type==STD_ID_TYPE)
        }
        else if(can_id==CAN3_ID)
        {
          //none
        }
    }

    if(mess_count)
    {
      restart_sleep_and_rx_timers(can_id);
    }
  }

  System.can_state.sec_flags.can_in_sleep=can_sleep_indicate_handler();

  blocks_handler();

  bmw_x1_analog_to_can_handler();

  taxi_blocks_handler();
}


static void mustang_audio_handler(void)
{
#if defined(JQ6500_AUDUO_PRESENT)
  uint8_t can_speed=System.can_state.numeric_data.can_speed;

  static struct
  {
    uint8_t open_roof:1;
    uint8_t unautozied_ign_on:1;
    uint8_t hand_brake_one_time_event:1;
    uint8_t overspeed;
    uint32_t drive_on_hand_brake_timer;
    uint32_t miles_timer;
    uint32_t fuel_timer;
    uint32_t unautozied_ign_on_timer;
  }audio_events={0};

  if(System.signal_state.current_audio_file!=0) return;

  //???
  if((lease_state==IN_END_LEASE_STATE || lease_state==IN_FORCED_END_LEASE_STATE) && System.signal_state.ignition)
  {
    if(!audio_events.unautozied_ign_on)
    {
      bool is_busy;

      if(yandex_audio_cmd_callback("\x00\x02\x00", 3, &is_busy, 0xFF, 0, 0, NULL) && !is_busy)
      {
        audio_events.unautozied_ign_on=1;
        audio_events.unautozied_ign_on_timer=GetSecondsFromStartup();
      }
    }
  }
  else if(lease_state==IN_LEASE_STATE || (!System.signal_state.ignition && timeAfter(GetSecondsFromStartup(), audio_events.unautozied_ign_on_timer+5)))
  {
    audio_events.unautozied_ign_on=0;
  }

  if(can_program==FORD_MUSTANG_1969_PROGRAM)
  {
    //???
    if(!audio_events.hand_brake_one_time_event && lease_state==IN_LEASE_STATE && System.signal_state.ignition && System.can_state.sec_flags.hand_break)
    {
      bool is_busy;
      if(yandex_audio_cmd_callback("\x00\x0E\x00", 3, &is_busy, 0xFF, 0, 0, NULL) && !is_busy)
      {
        audio_events.hand_brake_one_time_event=1;
      }
    }
    else if(lease_state!=IN_LEASE_STATE)
    {
      audio_events.hand_brake_one_time_event=0;
    }

    if(timeAfter(GetSecondsFromStartup(), audio_events.drive_on_hand_brake_timer) && \
      lease_state==IN_LEASE_STATE && System.signal_state.ignition && \
        can_speed>4 && System.can_state.sec_flags.hand_break)
    {
      bool is_busy;
      if(yandex_audio_cmd_callback("\x00\x03\x00", 3, &is_busy, 0xFF, 0, 0, NULL) && !is_busy)
      {
        audio_events.drive_on_hand_brake_timer=GetSecondsFromStartup()+30;
      }
    }
    else if(!(lease_state==IN_LEASE_STATE && System.signal_state.ignition))
    {
      audio_events.drive_on_hand_brake_timer=GetSecondsFromStartup();
    }
  }

  if(lease_state==IN_LEASE_STATE && System.signal_state.ignition && \
    (audio_events.overspeed<1 && can_speed>=60 && can_speed<90) || \
      (audio_events.overspeed<2 && can_speed>=90 && can_speed<110) || \
        (audio_events.overspeed<3 && can_speed>=110 && can_speed<130) || \
          (audio_events.overspeed<4 && can_speed>=130))
  {
    bool is_busy;

    static const uint8_t cmd[][4]=
    {
      "\x00\x06\x00",
      "\x00\x07\x00",
      "\x00\x08\x00",
      "\x00\x09\x00",
    };

    if(yandex_audio_cmd_callback(cmd[audio_events.overspeed], 3, &is_busy, 0xFF, 0, 0, NULL) && !is_busy)
    {
      if      (audio_events.overspeed<1 && can_speed>=60 && can_speed<90)   audio_events.overspeed=1;
      else if (audio_events.overspeed<2 && can_speed>=90 && can_speed<110)  audio_events.overspeed=2;
      else if (audio_events.overspeed<3 && can_speed>=110 && can_speed<130) audio_events.overspeed=3;
      else if (audio_events.overspeed<4 && can_speed>=130)                  audio_events.overspeed=4;
    }
  }
  else if(!(lease_state==IN_LEASE_STATE && System.signal_state.ignition))
  {
    audio_events.overspeed=0;
  }

  /*
  if(timeAfter(GetSecondsFromStartup(), audio_events.miles_timer) && \
    lease_state==IN_LEASE_STATE && System.signal_state.ignition && \
      can_speed>10)
  {
    bool is_busy;
    if(yandex_audio_cmd_callback("\x00\x08\x00", 3, &is_busy, 0xFF, 0, NULL) && !is_busy)
    {
      audio_events.miles_timer=GetSecondsFromStartup()+30*60;
    }
  }
  else if(!(lease_state==IN_LEASE_STATE && System.signal_state.ignition))
  {
    audio_events.miles_timer=GetSecondsFromStartup();
  }
  */

  if(timeAfter(GetSecondsFromStartup(), audio_events.fuel_timer) && \
    lease_state==IN_LEASE_STATE && System.signal_state.ignition && \
      can_speed>5 && System.can_state.numeric_data.fuel_lev_l>0 && System.can_state.numeric_data.fuel_lev_l<=15)
  {
    bool is_busy;
    if(yandex_audio_cmd_callback("\x00\x05\x00", 3, &is_busy, 0xFF, 0, 0, NULL) && !is_busy);
    {
      audio_events.fuel_timer=GetSecondsFromStartup()+5*60;
    }
  }
  else if(!(lease_state==IN_LEASE_STATE && System.signal_state.ignition))
  {
    audio_events.fuel_timer=GetSecondsFromStartup();
  }

  if(false && can_program==FORD_MUSTANG_1969_PROGRAM)
  {
    if(lease_state==IN_END_LEASE_STATE || lease_state==IN_FORCED_END_LEASE_STATE)
    {
      audio_events.open_roof=0;
    }
    else
    {
      if(!audio_events.open_roof && System.signal_state.ignition && System.can_state.numeric_data.can_speed>4 && \
        (!System.signal_state.ext_digital_input[FORD_MUSTANG69_ROOF_BRINPUT_ID] || \
          !System.signal_state.ext_digital_input[FORD_MUSTANG69_LEFT_ROOF_LOCK_BRINPUT_ID] || \
            !System.signal_state.ext_digital_input[FORD_MUSTANG69_RIGHT_ROOF_LOCK_BRINPUT_ID]))
      {
        bool is_busy;
        if(yandex_audio_cmd_callback("\x00\x0B\x00", 3, &is_busy, 0xFF, 0, 0, NULL) && !is_busy)//пока нет такого файла
        {
          audio_events.open_roof=1;
        }
      }
    }
  }
#endif //defined(JQ6500_AUDUO_PRESENT)
}

static void ford_mustang_1965_handler(void)
{
  uint8_t input_id;

  if(System.signal_state.vin_sensor[0]=='\0')
  {
    System.Grab(portMAX_DELAY);
    snprintf(System.signal_state.vin_sensor, sizeof(System.signal_state.vin_sensor), "5F09A772328000000");
    System.Release();
  }

  input_id=FORD_MUSTANG65_TACHO_INPUT_ID;
  if(input_id!=0xff)
  {
    System.sensor_settings.mfi[input_id].input_type=FREQ_IN;
    System.sensor_settings.mfi[input_id].polarity=ACTIVE_0;

    System.Grab(portMAX_DELAY);
    System.can_state.numeric_data.eng_rpm=(uint16_t)System.signal_state.freq_input[input_id];

    if(System.can_state.numeric_data.eng_rpm>350) System.can_state.sec_flags.engine_is_on=1;
    else                                          System.can_state.sec_flags.engine_is_on=0;
    System.Release();
  }

  input_id=FORD_MUSTANG65_SPEED_INPUT_ID;
  if(input_id!=0xff)
  {
    System.sensor_settings.mfi[input_id].input_type=FREQ_IN;
    System.sensor_settings.mfi[input_id].polarity=ACTIVE_1;

    System.Grab(portMAX_DELAY);
    System.can_state.numeric_data.can_speed=(uint8_t)System.signal_state.freq_input[input_id];
    System.Release();
  }

  input_id=FORD_MUSTANG65_FUEL_INPUT_ID;
  if(input_id!=0xff)
  {
    System.sensor_settings.mfi[input_id].input_type=FREQ_IN;
    System.sensor_settings.mfi[input_id].polarity=ACTIVE_0;

    static const uint16_t window_size=256;

    static struct
    {
      uint16_t window_pos_init;
      uint16_t window_pos;
      uint8_t  window[window_size];
    }fuel_filt={0};

    if(/*__GET_IGN_STATE() && */is_can_timer_expired(FUEL_FILT_TIMER))
    {
      System.Grab(portMAX_DELAY);
      uint16_t freq=(uint16_t)roundf(roundf(System.signal_state.freq_input[input_id]));
      System.Release();

      if(freq>=500 && freq<=1500)
      {
        fuel_filt.window[fuel_filt.window_pos]=(freq-500)/10;
        System.can_state.numeric_data.ad_blue_p=fuel_filt.window[fuel_filt.window_pos];//debug
        fuel_filt.window_pos++;
        if(fuel_filt.window_pos>=window_size) fuel_filt.window_pos=0;

        uint16_t wsize;
        if(fuel_filt.window_pos_init<window_size)
        {
          fuel_filt.window_pos_init++;
          wsize=fuel_filt.window_pos_init;
        }
        else
        {
          wsize=window_size;
        }

        uint32_t val=0;
        for(uint16_t i=0; i<wsize; i++)
        {
          val+=fuel_filt.window[i];
        }
        val=val/wsize;

        System.set_fuel_level_p(val);
      }

      restart_can_timer(FUEL_FILT_TIMER, 500);
    }
  }

  input_id=FORD_MUSTANG65_ENGINE_TEMP_INPUT_ID;
  if(input_id!=0xff)
  {
    System.sensor_settings.mfi[input_id].input_type=ANALOG_IN;
    System.sensor_settings.mfi[input_id].polarity=ACTIVE_1;

    if(__GET_IGN_STATE())
    {
      System.Grab(portMAX_DELAY);
      if(System.signal_state.analog_input[input_id]>0.5f)
      {
        //y=196.875-18.75x
        float temp=roundf(196.875f-18.75f*System.signal_state.analog_input[input_id]);

        if(temp<160.0f && temp>-20.0f)
        {
          System.can_state.numeric_data.eng_temp=temp;
        }
      }
      System.Release();
    }

  }

  System.sensor_settings.br_settings.interface=BR_RS485;
#if defined(DUTS_PRESENT)
  for(uint8_t i=0; i<MAX_DUTS; i++)  System.sensor_settings.dut[i].type=DUT_OFF;
#endif //DUTS_PRESENT

  //BR
  input_id=FORD_MUSTANG65_DRIVER_DOOR_BRINPUT_ID;
  if(input_id!=0xff)
  {
    System.sensor_settings.ext_mfi[input_id].input_type=DIG_IN;
    System.sensor_settings.ext_mfi[input_id].polarity=ACTIVE_0;

    if(System.signal_state.ext_digital_input[input_id]) System.can_state.sec_flags.driver_door=1;
    else                                                System.can_state.sec_flags.driver_door=0;
  }

  input_id=FORD_MUSTANG65_PASS_DOOR_BRINPUT_ID;
  if(input_id!=0xff)
  {
    System.sensor_settings.ext_mfi[input_id].input_type=DIG_IN;
    System.sensor_settings.ext_mfi[input_id].polarity=ACTIVE_0;

    if(System.signal_state.ext_digital_input[input_id]) System.can_state.sec_flags.pass_door=1;
    else                                                System.can_state.sec_flags.pass_door=0;
  }

  input_id=FORD_MUSTANG65_HOOD_DOOR_BRINPUT_ID;
  if(input_id!=0xff)
  {
    System.sensor_settings.ext_mfi[input_id].input_type=DIG_IN;
    System.sensor_settings.ext_mfi[input_id].polarity=ACTIVE_0;

    if(System.signal_state.ext_digital_input[input_id]) System.can_state.sec_flags.hood=1;
    else                                                System.can_state.sec_flags.hood=0;
  }

  input_id=FORD_MUSTANG65_TRUNK_DOOR_BRINPUT_ID;
  if(input_id!=0xff)
  {
    System.sensor_settings.ext_mfi[input_id].input_type=DIG_IN;
    System.sensor_settings.ext_mfi[input_id].polarity=ACTIVE_0;

    if(System.signal_state.ext_digital_input[input_id]) System.can_state.sec_flags.trunk=1;
    else                                                System.can_state.sec_flags.trunk=0;
  }

  input_id=FORD_MUSTANG65_HAND_BREAK_BRINPUT_ID;
  if(input_id!=0xff)
  {
    System.sensor_settings.ext_mfi[input_id].input_type=DIG_IN;
    System.sensor_settings.ext_mfi[input_id].polarity=ACTIVE_0;

    if(System.signal_state.ext_digital_input[input_id]) System.can_state.sec_flags.hand_break=0;
    else                                                System.can_state.sec_flags.hand_break=1;
  }

  input_id=FORD_MUSTANG65_PARKING_BRINPUT_ID;
  if(input_id!=0xff)
  {
    System.sensor_settings.ext_mfi[input_id].input_type=DIG_IN;
    System.sensor_settings.ext_mfi[input_id].polarity=ACTIVE_0;

    if(System.signal_state.ext_digital_input[input_id]) System.can_state.sec_flags.parking=1;
    else                                                System.can_state.sec_flags.parking=0;
  }

  input_id=FORD_MUSTANG65_FUEL_CAP_BRINPUT_ID;
  if(input_id!=0xff)
  {
    System.sensor_settings.ext_mfi[input_id].input_type=DIG_IN;
    System.sensor_settings.ext_mfi[input_id].polarity=ACTIVE_0;

    //if(System.signal_state.ext_digital_input[input_id]) System.can_state.sec_flags.=1;
    //else                                                System.can_state.sec_flags.=0;
  }

  input_id=FORD_MUSTANG65_HOOD_LOCK_BRINPUT_ID;
  if(input_id!=0xff)
  {
    System.sensor_settings.ext_mfi[input_id].input_type=DIG_IN;
    System.sensor_settings.ext_mfi[input_id].polarity=ACTIVE_0;

    //if(System.signal_state.ext_digital_input[input_id]) System.can_state.sec_flags.=1;
    //else                                                System.can_state.sec_flags.=0;
  }

  input_id=FORD_MUSTANG65_FUEL_CAP_LOCK_BRINPUT_ID;
  if(input_id!=0xff)
  {
    System.sensor_settings.ext_mfi[input_id].input_type=DIG_IN;
    System.sensor_settings.ext_mfi[input_id].polarity=ACTIVE_0;

    //if(System.signal_state.ext_digital_input[input_id]) System.can_state.sec_flags.=1;
    //else                                                System.can_state.sec_flags.=0;
  }

  if(true)
  {
    //Вход 2 стекло водителя -поднят-воздух
    //Вход 3 ветровик водителя -закрыт-земля
    //Вход 4 стекло пассажира - поднято-воздух
    //Вход 5 ветровик пассажира-закрыт-земля

    System.sensor_settings.ext_mfi[FORD_MUSTANG65_DRIVER_WINDOW_BRINPUT_ID].input_type=DIG_IN;
    System.sensor_settings.ext_mfi[FORD_MUSTANG65_DRIVER_WINDOW_BRINPUT_ID].polarity=ACTIVE_0;
    System.sensor_settings.ext_mfi[FORD_MUSTANG65_PASS_WINDOW_BRINPUT_ID].input_type=DIG_IN;
    System.sensor_settings.ext_mfi[FORD_MUSTANG65_PASS_WINDOW_BRINPUT_ID].polarity=ACTIVE_0;

    System.sensor_settings.ext_mfi[FORD_MUSTANG65_DRIVER_WINDOW_LEAF_BRINPUT_ID].input_type=DIG_IN;
    System.sensor_settings.ext_mfi[FORD_MUSTANG65_DRIVER_WINDOW_LEAF_BRINPUT_ID].polarity=ACTIVE_0;
    System.sensor_settings.ext_mfi[FORD_MUSTANG65_PASS_WINDOW_LEAF_BRINPUT_ID].input_type=DIG_IN;
    System.sensor_settings.ext_mfi[FORD_MUSTANG65_PASS_WINDOW_LEAF_BRINPUT_ID].polarity=ACTIVE_0;

    if(!System.signal_state.ext_digital_input[FORD_MUSTANG65_DRIVER_WINDOW_BRINPUT_ID])     System.signal_state.windows_position.driver_door=0;
    else                                                                                    System.signal_state.windows_position.driver_door=1;
    System.signal_state.cls_state.driver_door_prepared=1;

    if(System.signal_state.ext_digital_input[FORD_MUSTANG65_DRIVER_WINDOW_LEAF_BRINPUT_ID]) System.signal_state.windows_position.l_rear_door=0;
    else                                                                                    System.signal_state.windows_position.l_rear_door=1;
    System.signal_state.cls_state.l_rear_door_prepared=1;

    if(!System.signal_state.ext_digital_input[FORD_MUSTANG65_PASS_WINDOW_BRINPUT_ID])       System.signal_state.windows_position.pass_door=0;
    else                                                                                    System.signal_state.windows_position.pass_door=1;
    System.signal_state.cls_state.pass_door_prepared=1;

    if(System.signal_state.ext_digital_input[FORD_MUSTANG65_PASS_WINDOW_LEAF_BRINPUT_ID])   System.signal_state.windows_position.r_rear_door=0;
    else                                                                                    System.signal_state.windows_position.r_rear_door=1;
    System.signal_state.cls_state.r_rear_door_prepared=1;
  }

  System.Grab(portMAX_DELAY);
  System.track_settings.odometer_by_ign=1;
  System.can_state.numeric_data.can_odo_km=System.gnss_state.odometer;
  System.can_state.numeric_data.can_speed=(uint8_t)System.gnss_state.speed;
  System.can_state.sec_flags.engine_is_on=System.signal_state.ignition;//temporarry
  System.Release();

  mustang_audio_handler();

  blocks_handler();
}

static void ford_mustang_1969_handler(void)
{
  uint8_t input_id;

  if(System.signal_state.vin_sensor[0]=='\0')
  {
    System.Grab(portMAX_DELAY);
    snprintf(System.signal_state.vin_sensor, sizeof(System.signal_state.vin_sensor), "9F03H207336000000");
    System.Release();
  }

  input_id=FORD_MUSTANG69_TACHO_INPUT_ID;
  if(input_id!=0xff)
  {
    System.sensor_settings.mfi[input_id].input_type=FREQ_IN;
    System.sensor_settings.mfi[input_id].polarity=ACTIVE_0;

    System.Grab(portMAX_DELAY);
    System.can_state.numeric_data.eng_rpm=(uint16_t)System.signal_state.freq_input[input_id];

    if(System.can_state.numeric_data.eng_rpm>350) System.can_state.sec_flags.engine_is_on=1;
    else                                          System.can_state.sec_flags.engine_is_on=0;
    System.Release();
  }

  input_id=FORD_MUSTANG69_SPEED_INPUT_ID;
  if(input_id!=0xff)
  {
    System.sensor_settings.mfi[input_id].input_type=FREQ_IN;
    System.sensor_settings.mfi[input_id].polarity=ACTIVE_1;

    System.Grab(portMAX_DELAY);
    System.can_state.numeric_data.can_speed=(uint8_t)System.signal_state.freq_input[input_id];
    System.Release();
  }

  /*
  input_id=FORD_MUSTANG69_FUEL_INPUT_ID;
  if(input_id!=0xff)
  {
    System.sensor_settings.mfi[input_id].input_type=ANALOG_IN;
    System.sensor_settings.mfi[input_id].polarity=ACTIVE_1;

    float adc_val=((float)fuel_raw)*MFI_ADC_K;
    System.can_state.numeric_data.harvest_area=adc_val;

    if(__GET_IGN_STATE())
    {
      System.Grab(portMAX_DELAY);
      if(adc_val>0.8f)
      {
        //y=127.5-15.5x
        adc_val=127.5f-15.5f*adc_val;
        if(adc_val<0)          adc_val=0.0f;
        else if(adc_val>78.0f) adc_val=78.0f;

        System.can_state.numeric_data.fuel_lev_l=(uint16_t)adc_val;
        System.set_fuel_level_p((uint8_t)roundf(adc_val/0.78f));
      }
      System.Release();
    }
  }
  */

  input_id=FORD_MUSTANG69_FUEL_INPUT_ID;
  if(input_id!=0xff)
  {
    System.sensor_settings.mfi[input_id].input_type=FREQ_IN;
    System.sensor_settings.mfi[input_id].polarity=ACTIVE_0;

    static const uint16_t window_size=1024;

    static struct
    {
      uint16_t window_pos_init;
      uint16_t window_pos;
      uint8_t  window[window_size];
    }fuel_filt={0};

    if(/*__GET_IGN_STATE() && */is_can_timer_expired(FUEL_FILT_TIMER))
    {
      System.Grab(portMAX_DELAY);
      uint16_t freq=(uint16_t)roundf(roundf(System.signal_state.freq_input[input_id]));
      System.Release();

      if(freq>=500 && freq<=1500)
      {
        fuel_filt.window[fuel_filt.window_pos]=(freq-500)/10;
        System.can_state.numeric_data.ad_blue_p=fuel_filt.window[fuel_filt.window_pos];//debug
        fuel_filt.window_pos++;
        if(fuel_filt.window_pos>=window_size) fuel_filt.window_pos=0;

        uint16_t wsize;
        if(fuel_filt.window_pos_init<window_size)
        {
          fuel_filt.window_pos_init++;
          wsize=fuel_filt.window_pos_init;
        }
        else
        {
          wsize=window_size;
        }

        uint32_t val=0;
        for(uint16_t i=0; i<wsize; i++)
        {
          val+=fuel_filt.window[i];
        }
        val=val/wsize;

        System.set_fuel_level_p(val);
      }

      restart_can_timer(FUEL_FILT_TIMER, 500);
    }
  }

  input_id=FORD_MUSTANG69_ENGINE_TEMP_INPUT_ID;
  if(input_id!=0xff)
  {
    System.sensor_settings.mfi[input_id].input_type=ANALOG_IN;
    System.sensor_settings.mfi[input_id].polarity=ACTIVE_1;

    System.Grab(portMAX_DELAY);
    System.can_state.numeric_data.eng_temp=System.signal_state.analog_input[input_id];
    System.Release();
  }

  System.sensor_settings.br_settings.interface=BR_RS485;
#if defined(DUTS_PRESENT)
  for(uint8_t i=0; i<MAX_DUTS; i++)  System.sensor_settings.dut[i].type=DUT_OFF;
#endif //DUTS_PRESENT

  //BR
  input_id=FORD_MUSTANG69_DRIVER_DOOR_BRINPUT_ID;
  if(input_id!=0xff)
  {
    System.sensor_settings.ext_mfi[input_id].input_type=DIG_IN;
    System.sensor_settings.ext_mfi[input_id].polarity=ACTIVE_0;

    if(System.signal_state.ext_digital_input[input_id]) System.can_state.sec_flags.driver_door=1;
    else                                                System.can_state.sec_flags.driver_door=0;
  }

  input_id=FORD_MUSTANG69_PASS_DOOR_BRINPUT_ID;
  if(input_id!=0xff)
  {
    System.sensor_settings.ext_mfi[input_id].input_type=DIG_IN;
    System.sensor_settings.ext_mfi[input_id].polarity=ACTIVE_0;

    if(System.signal_state.ext_digital_input[input_id]) System.can_state.sec_flags.pass_door=1;
    else                                                System.can_state.sec_flags.pass_door=0;
  }

  input_id=FORD_MUSTANG69_HOOD_DOOR_BRINPUT_ID;
  if(input_id!=0xff)
  {
    System.sensor_settings.ext_mfi[input_id].input_type=DIG_IN;
    System.sensor_settings.ext_mfi[input_id].polarity=ACTIVE_0;

    if(System.signal_state.ext_digital_input[input_id]) System.can_state.sec_flags.hood=1;
    else                                                System.can_state.sec_flags.hood=0;
  }

  input_id=FORD_MUSTANG69_TRUNK_DOOR_BRINPUT_ID;
  if(input_id!=0xff)
  {
    System.sensor_settings.ext_mfi[input_id].input_type=DIG_IN;
    System.sensor_settings.ext_mfi[input_id].polarity=ACTIVE_0;

    if(System.signal_state.ext_digital_input[input_id]) System.can_state.sec_flags.trunk=1;
    else                                                System.can_state.sec_flags.trunk=0;
  }

  input_id=FORD_MUSTANG69_HAND_BREAK_BRINPUT_ID;
  if(input_id!=0xff)
  {
    System.sensor_settings.ext_mfi[input_id].input_type=DIG_IN;
    System.sensor_settings.ext_mfi[input_id].polarity=ACTIVE_0;

    if(System.signal_state.ext_digital_input[input_id]) System.can_state.sec_flags.hand_break=1;
    else                                                System.can_state.sec_flags.hand_break=0;
  }

  input_id=FORD_MUSTANG69_PARKING_BRINPUT_ID;
  if(input_id!=0xff)
  {
    System.sensor_settings.ext_mfi[input_id].input_type=DIG_IN;
    System.sensor_settings.ext_mfi[input_id].polarity=ACTIVE_0;

    if(System.signal_state.ext_digital_input[input_id]) System.can_state.sec_flags.parking=1;
    else                                                System.can_state.sec_flags.parking=0;
  }

  input_id=FORD_MUSTANG69_FUEL_CAP_BRINPUT_ID;
  if(input_id!=0xff)
  {
    System.sensor_settings.ext_mfi[input_id].input_type=DIG_IN;
    System.sensor_settings.ext_mfi[input_id].polarity=ACTIVE_0;

    //if(System.signal_state.ext_digital_input[input_id]) System.can_state.sec_flags.=1;
    //else                                                System.can_state.sec_flags.=0;
  }

  input_id=FORD_MUSTANG69_HOOD_LOCK_BRINPUT_ID;
  if(input_id!=0xff)
  {
    System.sensor_settings.ext_mfi[input_id].input_type=DIG_IN;
    System.sensor_settings.ext_mfi[input_id].polarity=ACTIVE_0;

    //if(System.signal_state.ext_digital_input[input_id]) System.can_state.sec_flags.=1;
    //else                                                System.can_state.sec_flags.=0;
  }

  if(true)
  {
    System.sensor_settings.ext_mfi[FORD_MUSTANG69_ROOF_BRINPUT_ID].input_type=DIG_IN;
    System.sensor_settings.ext_mfi[FORD_MUSTANG69_ROOF_BRINPUT_ID].polarity=ACTIVE_0;
    System.sensor_settings.ext_mfi[FORD_MUSTANG69_LEFT_ROOF_LOCK_BRINPUT_ID].input_type=DIG_IN;
    System.sensor_settings.ext_mfi[FORD_MUSTANG69_LEFT_ROOF_LOCK_BRINPUT_ID].polarity=ACTIVE_0;
    System.sensor_settings.ext_mfi[FORD_MUSTANG69_RIGHT_ROOF_LOCK_BRINPUT_ID].input_type=DIG_IN;
    System.sensor_settings.ext_mfi[FORD_MUSTANG69_RIGHT_ROOF_LOCK_BRINPUT_ID].polarity=ACTIVE_0;
  }

  System.Grab(portMAX_DELAY);
  System.track_settings.odometer_by_ign=1;
  System.can_state.numeric_data.can_odo_km=System.gnss_state.odometer;
  System.can_state.numeric_data.can_speed=(uint8_t)System.gnss_state.speed;
  System.can_state.sec_flags.engine_is_on=System.signal_state.ignition;//temporarry
  System.Release();

  mustang_audio_handler();

  blocks_handler();
}

static void renault_logan_2013_analog_to_can_handler(void)
{
  if(can_program==RENAULT_LOGAN_2013_PROGRAM)
  {
    //none
  }

  if(can_program==RENAULT_DUSTER_2021_PROGRAM)
  {
    //none
  }

  if(can_program==RENAULT_ARKANA_2018_PROGRAM)
  {
    System.sensor_settings.mfi[RENAULT_ARKANA_2018_HOOD_INPUT_ID].input_type = DIG_IN;
    System.sensor_settings.mfi[RENAULT_ARKANA_2018_HOOD_INPUT_ID].polarity = ACTIVE_0;

    if(System.signal_state.digital_input[RENAULT_ARKANA_2018_HOOD_INPUT_ID])
    {
      System.can_state.sec_flags.hood = 0;
    }
    else
    {
      System.can_state.sec_flags.hood = 1;
    }
  }
}

static void can_rx_renault_logan_2013_handler(void)
{
  can_rx_frame_t rx;

  for(uint8_t can_id=CAN1_ID; can_id<HW_CAN_COUNT; can_id++)
  {
    uint16_t mess_count=filled_count_in_sfifo(&can_rx_sfifo[can_id]);

    for(uint16_t j=0; j<mess_count; j++)
    {
      if(!read_from_sfifo(&can_rx_sfifo[can_id], &rx))
      {
        __PRINTF("%s_RX sfifo is full, drop counter: %lu\n", get_name_from_can_id(can_id), can_rx_sfifo[can_id].drop_counter);
      }

#if defined(CAN_VEGA_FWD_PRESENT)
      rx_fwd_hadler(can_id, &rx);
#endif //defined(CAN_VEGA_FWD_PRESENT)

#if defined(YANDEX_OBD_PRESENT)
      obd_rx_handler(can_id, &rx);
#endif //defined(YANDEX_OBD_PRESENT)

      can_rx_debug_trace(&rx, can_id);

      if(can_id==CAN1_ID)
      {
        //500 кбит\с
        if(rx.id_type==STD_ID_TYPE)
        {
          switch(rx.id)
          {
            case 0x186:
            {
              uint16_t val=((rx.data[0]<<8)|(rx.data[1]<<0));

              if(val!=0xFFFF)
              {
                System.Grab(portMAX_DELAY);
                {
                  System.can_state.numeric_data.eng_rpm=(val*13UL)/100Ul;

                  if(System.can_state.numeric_data.eng_rpm>350) System.can_state.sec_flags.engine_is_on=1;
                  else                                          System.can_state.sec_flags.engine_is_on=0;
                }System.Release();
              }

              if(__GET_IGN_STATE())
              {
                if(rx.data[5]!=0xFF)
                {
                  System.can_state.numeric_data.accelerator=(rx.data[5]*2Ul)/(5Ul);
                }
              }
              else
              {
                System.can_state.numeric_data.accelerator=0;
              }
            }
            break;

            case 0x1F6:
            {
              //педаль сцепления
            }
            break;

            case 0x29A:
            {
              uint16_t val=((rx.data[0]<<8)|(rx.data[1]<<0));

              if(val < 0xFFFE)
              {
                if(can_program==RENAULT_DUSTER_2021_PROGRAM || can_program==RENAULT_ARKANA_2018_PROGRAM)
                {
                  System.can_state.numeric_data.can_speed=(val*2Ul)/381Ul; //0.00525
                }
                else
                {
                  System.can_state.numeric_data.can_speed=(val)/211Ul; //0.00474
                }
              }
            }
            break;

            case 0x350:
            {
              if(can_program==RENAULT_DUSTER_2021_PROGRAM || can_program==RENAULT_ARKANA_2018_PROGRAM)
              {
                uint8_t val = rx.data[0]&0x07;

                if(val == 0x05 || val == 0x06 || val == 0x07) {System.can_state.sec_flags.ignition=1;}
                else                                          {System.can_state.sec_flags.ignition=0;}
              }
              if(can_program==LADA_LARGUS_2020_PROGRAM)
              {
                uint8_t val = rx.data[0]&0x07;
                if(val == 0x04 || val == 0x05 || val == 0x06 || val == 0x07) {System.can_state.sec_flags.key_in_acc = 1;}
                else                                                         {System.can_state.sec_flags.key_in_acc = 0;}
              }

              if(rx.data[5]&(1<<4)) {System.can_state.sec_flags.pedal_break=0;}
              else                  {System.can_state.sec_flags.pedal_break=1;}

              if(rx.data[7]&(1<<4)) {System.signal_state.emergency_lights=1;}
              else                  {System.signal_state.emergency_lights=0;}
            }
            break;

            case 0x3F7:
            {
              if(can_program==RENAULT_DUSTER_2021_PROGRAM || can_program==RENAULT_ARKANA_2018_PROGRAM)
              {
                if(rx.data[0] != 0x00) //иногда летит 0 при глушении
                {
                  //if(System.can_state.sec_flags.engine_is_on)
                  {
                    if(rx.data[0]==0x08 /*P*/ || rx.data[0]==0x10 /*R*/ || rx.data[0]==0x18 /*N*/ || rx.data[0]==0x20 /*D*/|| rx.data[0]==0x80 /*M*/ || rx.data[0]==0x88 /*M*/)
                    {
                      System.Grab(portMAX_DELAY);

                      if(rx.data[0]==0x08)          {System.can_state.sec_flags.parking=1; System.can_state.sec_flags.reverse_gear=0;}
                      else if(rx.data[0]==0x10)     {System.can_state.sec_flags.parking=0; System.can_state.sec_flags.reverse_gear=1;}
                      else                          {System.can_state.sec_flags.parking=0; System.can_state.sec_flags.reverse_gear=0;}

                      if(rx.data[0]==0x08)                           {System.signal_state.selector_position='P';}
                      else if (rx.data[0]==0x10)                     {System.signal_state.selector_position='R';}
                      else if (rx.data[0]==0x18)                     {System.signal_state.selector_position='N';}
                      else if (rx.data[0]==0x20)                     {System.signal_state.selector_position='D';}
                      else if (rx.data[0]==0x80 || rx.data[0]==0x88) {System.signal_state.selector_position='M';}
                    }
                    System.Release();
                  }
                }
              }
            }
            break;

            case 0x3B7:
            {
              //Наружная температура (°C)
            }
            break;

            case 0x4F8:
            {
              if(can_program!=RENAULT_DUSTER_2021_PROGRAM && can_program!=RENAULT_ARKANA_2018_PROGRAM)
              {
                if(rx.data[0]&(1<<6)) {System.can_state.sec_flags.ignition=1;}
                else                  {System.can_state.sec_flags.ignition=0;}
              }

              if(rx.data[0]&(1<<3)) {System.can_state.sec_flags.hand_break=1;}
              else                  {System.can_state.sec_flags.hand_break=0;}
            }
            break;

            case 0x55D:
            {
              System.Grab(portMAX_DELAY);
              {
                if(can_program!=RENAULT_DUSTER_2021_PROGRAM && can_program!=RENAULT_ARKANA_2018_PROGRAM)
                {
                  if(System.can_state.sec_flags.engine_is_on)
                  {
                    if(rx.data[1]!=0xFF)
                    {
                      //на заглушенной показывает вкл заднюю передачу
                      if(rx.data[1]&(1<<5))         {System.can_state.sec_flags.parking=0; System.can_state.sec_flags.reverse_gear=1;}
                      else                          {System.can_state.sec_flags.parking=0; System.can_state.sec_flags.reverse_gear=0;}

                      if(rx.data[1]&(1<<5))         {System.signal_state.selector_position='R';}
                      else if(rx.data[1]&(1<<3))    {System.signal_state.selector_position='N';}
                      else                          {System.signal_state.selector_position='M';}
                    }
                  }
                  else
                  {
                    System.can_state.sec_flags.parking=0; System.can_state.sec_flags.reverse_gear=0;

                    System.signal_state.selector_position='U';
                  }
                }

                if(rx.data[7]!=0xFF)
                {
                  if((rx.data[7]&(1<<0))) {_cls_state=LOCKED_CLS_STATE;}
                  else                    {_cls_state=UNLOCKED_CLS_STATE;}

                  if(_cls_state==LOCKED_CLS_STATE)
                  {
                    System.signal_state.cls_state.driver_door=0; System.signal_state.cls_state.l_rear_door=0; System.signal_state.cls_state.r_rear_door=0; System.signal_state.cls_state.pass_door=0;
                  }
                  else
                  {
                    System.signal_state.cls_state.driver_door=1; System.signal_state.cls_state.l_rear_door=1; System.signal_state.cls_state.r_rear_door=1; System.signal_state.cls_state.pass_door=1;
                  }

                  System.signal_state.cls_state.driver_door_prepared=1;
                  System.signal_state.cls_state.l_rear_door_prepared=1;
                  System.signal_state.cls_state.r_rear_door_prepared=1;
                  System.signal_state.cls_state.pass_door_prepared=1;
                }
              }System.Release();
            }
            break;

            case 0x5D7:
            {
              uint32_t val=((rx.data[2]<<24)|(rx.data[3]<<16)|(rx.data[4]<<8)|(rx.data[5]<<0))>>4;

              if(val!=0x0FFFFFFF)
              {
                val = val/100;

                System.Grab(portMAX_DELAY);
                {
                  System.can_state.numeric_data.can_odo_km=val;
                }System.Release();
              }
            }
            break;

            case 0x5DA:
            {
              if(rx.data[0]!=0xFF)
              {
                System.Grab(portMAX_DELAY);
                {
                  System.can_state.numeric_data.eng_temp=rx.data[0]-40.0f;
                }System.Release();
              }
            }
            break;

            case 0x5DE:
            {
              if(rx.data[1]!=0xFF)
              {
                if(rx.data[1]&(1<<3))  {System.can_state.sec_flags.driver_door=1;}
                else                   {System.can_state.sec_flags.driver_door=0;}

                if(rx.data[1]&(1<<1))  {System.can_state.sec_flags.pass_door=1;}
                else                   {System.can_state.sec_flags.pass_door=0;}
              }

              if(rx.data[2]!=0xFF)
              {
                if(rx.data[2]&(1<<6))  {System.can_state.sec_flags.l_rear_door=1;}
                else                   {System.can_state.sec_flags.l_rear_door=0;}

                if(can_program!=RENAULT_DUSTER_2021_PROGRAM && can_program!=RENAULT_ARKANA_2018_PROGRAM)
                {
                  if(rx.data[2]&(1<<6))  {System.can_state.sec_flags.r_rear_door=1;} //Уточнить на логан
                  else                   {System.can_state.sec_flags.r_rear_door=0;}
                }
                else
                {
                  if(rx.data[2]&(1<<4))  {System.can_state.sec_flags.r_rear_door=1;}
                  else                   {System.can_state.sec_flags.r_rear_door=0;}
                }
              }

              if(rx.data[2]!=0xFF)
              {
                if(rx.data[7]&(1<<4))  {System.can_state.sec_flags.trunk=1;}
                else                   {System.can_state.sec_flags.trunk=0;}
              }

              if(rx.data[0]!=0xFF)
              {
                if(rx.data[0]&(1<<2))   {System.can_state.cont_flags.marker_lights=1;}
                else                    {System.can_state.cont_flags.marker_lights=0;}

                if(rx.data[0]&(1<<1))   {System.can_state.cont_flags.dipped_beam=1;}
                else                    {System.can_state.cont_flags.dipped_beam=0;}

                if(rx.data[0]&(1<<0))   {System.can_state.cont_flags.high_beam=1;}
                else                    {System.can_state.cont_flags.high_beam=0;}
              }
            }
            break;

            case 0x653:
            {
              if(rx.data[1]!=0xFF)
              {
                if(rx.data[1]&(1<<6)) {System.can_state.cont_flags.driver_safety_belt=0;}
                else                  {System.can_state.cont_flags.driver_safety_belt=1;}
              }
            }
            break;

            case 0x66A:
            {
              if(rx.data[0]!=0xFF)
              {
                if(rx.data[0]&(1<<3)) {System.can_state.cont_flags.check_engine=1;}
                else                  {System.can_state.cont_flags.check_engine=0;}
              }
            }
            break;

            case 0x6FB:
            {
              if((0x7F&rx.data[3])<0x7E)
              {
                uint8_t val = (0x7F&rx.data[3])/2;//литры

                System.can_state.numeric_data.ad_blue_l = val;//temporary

                val = (0x7F&rx.data[3]);//%, ��� ���� 50�
                val = (uint8_t)roundf((float)(val*100U)/96.0f); //96 - ��������
                //ограничение убираем, пока не оттарировали
                if(val > 100) val = 100;

                if(can_program==LADA_LARGUS_2020_PROGRAM && val==0)
                {
                  val = 1; // need non-zero value for normal backend work
                }

                System.set_fuel_level_p(val);
              }
            }
            break;

            default:
            break;
          }
        }//if(rx.id_type==STD_ID_TYPE)
      }
      else if(can_id==CAN2_ID)
      {
        if(rx.id_type==STD_ID_TYPE)
        {
          switch(rx.id)
          {
            case 0x000:
            {

            }
            break;

            default:
            break;
          }
        }//if(rx.id_type==STD_ID_TYPE)
      }
      else if(can_id==CAN3_ID)
      {
        //OBD CAN, 500 кбит\с
        if(rx.id_type==STD_ID_TYPE)
        {
          switch(rx.id)
          {
            case 0x000:
            {

            }
            break;

            default:
            break;
          }
        }//if(rx.id_type==STD_ID_TYPE)
      }
    }

    if(mess_count)
    {
      restart_sleep_and_rx_timers(can_id);
    }
  }

  System.can_state.sec_flags.can_in_sleep=can_sleep_indicate_handler();

  blocks_handler();

  renault_logan_2013_analog_to_can_handler();

  taxi_blocks_handler();
}

static void jeep_wrangler_2018_analog_to_can_handler(void)
{
  if(can_program==JEEP_WRANGLER_2018_PROGRAM)
  {
    System.sensor_settings.mfi[JEEP_WRANGLER_2018_ROOF_INPUT_ID].input_type=DIG_IN;
    System.sensor_settings.mfi[JEEP_WRANGLER_2018_ROOF_INPUT_ID].polarity=ACTIVE_0;

  }
}

static void can_rx_jeep_wrangler_2018_handler(void)
{
  can_rx_frame_t rx;

  for(uint8_t can_id=CAN1_ID; can_id<HW_CAN_COUNT; can_id++)
  {
    uint16_t mess_count=filled_count_in_sfifo(&can_rx_sfifo[can_id]);

    for(uint16_t j=0; j<mess_count; j++)
    {
      if(!read_from_sfifo(&can_rx_sfifo[can_id], &rx))
      {
        __PRINTF("%s_RX sfifo is full, drop counter: %lu\n", get_name_from_can_id(can_id), can_rx_sfifo[can_id].drop_counter);
      }

#if defined(CAN_VEGA_FWD_PRESENT)
      rx_fwd_hadler(can_id, &rx);
#endif //defined(CAN_VEGA_FWD_PRESENT)

#if defined(YANDEX_OBD_PRESENT)
      obd_rx_handler(can_id, &rx);
#endif //defined(YANDEX_OBD_PRESENT)

      can_rx_debug_trace(&rx, can_id);

      if(can_id==CAN1_ID)
      {
        //500 кбит\с
        if(rx.id_type==STD_ID_TYPE)
        {
          switch(rx.id)
          {
            case 0x3AC:
            {
              /*
              //это trip odo
              uint32_t val = ((rx.data[5]<<16)|(rx.data[6]<<8)|(rx.data[7]<<0));

              if(val < 0x00FFFFFE)
              {
                System.Grab(portMAX_DELAY);
                {
                  System.can_state.numeric_data.can_odo_km = val/10.0f;
                }System.Release();
              }
              */
            }
            break;

            case 0x079:
            {
              uint16_t val = ((rx.data[4]<<8)|(rx.data[5]<<0));

              if(val < 0xFFFE)
              {
                System.can_state.numeric_data.can_speed = val/128;
              }
            }
            break;

            case 0x025:
            {
              uint16_t val = ((rx.data[0]<<8)|(rx.data[1]<<0));

              if(val < 0xFFFE)
              {
                System.Grab(portMAX_DELAY);

                System.can_state.numeric_data.eng_rpm = val;

                if(System.can_state.numeric_data.eng_rpm > 350) {System.can_state.sec_flags.engine_is_on = 1;}
                else                                            {System.can_state.sec_flags.engine_is_on = 0;}

                System.Release();
              }
            }
            break;

            case 0x27A:
            {
              uint32_t val = ((rx.data[4]<<16)|(rx.data[5]<<8)|(rx.data[6]<<0));

              if(val < 0x00FFFFFE)
              {
                System.Grab(portMAX_DELAY);
                {
                  System.can_state.numeric_data.can_odo_km = val/10.0f;
                }System.Release();
              }
            }
            break;

            case 0x27B:
            {
              //todo: на не заведенную приходит мусор?
              if(System.can_state.sec_flags.engine_is_on)
              {
                uint16_t val = ((rx.data[0]<<8)|(rx.data[1]<<0))&(0x0FFF);

                if(val < 0x0FFE)
                {
                  System.Grab(portMAX_DELAY);

                  //запас хода, расстоние до пустого бака
                  System.can_state.numeric_data.fuel_lev_l = val;

                  System.Release();
                }
              }
            }
            break;

            case 0x077:
            {
              if(rx.data[0]&(1<<2)) {System.can_state.sec_flags.ignition = 1;}
              else                  {System.can_state.sec_flags.ignition = 0;}

              if(System.can_state.sec_flags.ignition) {System.signal_state.key_position = 'I';}
              else                                    {System.signal_state.key_position = 'O';}

            }
            break;

            case 0x07B:
            {
              uint8_t val = rx.data[2];

              System.can_state.numeric_data.accelerator=(val*100Ul)/0xFF;
            }
            break;

            case 0x083:
            {
              if(rx.data[0]&(1<<2)) {System.can_state.sec_flags.pedal_break = 1;}
              else                  {System.can_state.sec_flags.pedal_break = 0;}
            }
            break;

            case 0x023:
            {
              //положение руля
              int16_t val = ((rx.data[0]<<8)|(rx.data[1]<<0));

              val = (100*(val - 4096))/(2*680);

              System.Grab(portMAX_DELAY);
              System.can_state.numeric_data.battery_charge_level = val;//temporary
              System.Release();
            }
            break;

            case 0x127:
            {
              uint8_t val = rx.data[1];

              if(val < 0xFE)
              {
                System.Grab(portMAX_DELAY);
                {
                  System.can_state.numeric_data.eng_temp = val - 40.0f;
                }System.Release();
              }
            }
            break;

            case 0x0AD:
            {
              uint8_t val = rx.data[0]&0x0F;

              System.Grab(portMAX_DELAY);

              if(val == 0x01)      {System.can_state.sec_flags.parking = 1; System.can_state.sec_flags.reverse_gear = 0;}
              else if(val == 0x02) {System.can_state.sec_flags.parking = 0; System.can_state.sec_flags.reverse_gear = 1;}
              else                 {System.can_state.sec_flags.parking = 0; System.can_state.sec_flags.reverse_gear = 0;}

              if(val == 0x01)       System.signal_state.selector_position = 'P';
              else if (val == 0x02) System.signal_state.selector_position = 'R';
              else if (val == 0x03) System.signal_state.selector_position = 'N';
              else if (val == 0x04) System.signal_state.selector_position = 'D';

              System.Release();
            }
            break;

            case 0x291:
            {
              if((rx.data[0]&(1<<6))) {_cls_state=UNLOCKED_CLS_STATE;}
              else                    {_cls_state=LOCKED_CLS_STATE;}

              if(_cls_state==LOCKED_CLS_STATE)
              {
                System.signal_state.cls_state.driver_door=0; System.signal_state.cls_state.l_rear_door=0; System.signal_state.cls_state.r_rear_door=0; System.signal_state.cls_state.pass_door=0;
              }
              else
              {
                System.signal_state.cls_state.driver_door=1; System.signal_state.cls_state.l_rear_door=1; System.signal_state.cls_state.r_rear_door=1; System.signal_state.cls_state.pass_door=1;
              }

              System.signal_state.cls_state.driver_door_prepared=1;
              System.signal_state.cls_state.l_rear_door_prepared=1;
              System.signal_state.cls_state.r_rear_door_prepared=1;
              System.signal_state.cls_state.pass_door_prepared=1;

              if(rx.data[2]&(1<<1)) {System.can_state.sec_flags.driver_door=1;}
              else                  {System.can_state.sec_flags.driver_door=0;}

              if(rx.data[2]&(1<<2)) {System.can_state.sec_flags.pass_door=1;}
              else                  {System.can_state.sec_flags.pass_door=0;}

              if(rx.data[2]&(1<<6)) {System.can_state.sec_flags.trunk=1;}
              else                  {System.can_state.sec_flags.trunk=0;}

              if(rx.data[2]&(1<<0)) {System.can_state.cont_flags.marker_lights=1;}
              else                  {System.can_state.cont_flags.marker_lights=0;}

              if(rx.data[2]&(1<<7)) {System.can_state.sec_flags.hand_break=1;}
              else                  {System.can_state.sec_flags.hand_break=0;}

              if(rx.data[7]&(1<<1)) {System.can_state.cont_flags.dipped_beam=1;}
              else                  {System.can_state.cont_flags.dipped_beam=0;}

              if(rx.data[7]&(1<<2)) {System.can_state.cont_flags.high_beam=1;}
              else                  {System.can_state.cont_flags.high_beam=0;}

              if(rx.data[3]&(0xF0) == 0x30) {System.signal_state.emergency_lights=1;}
              else                          {System.signal_state.emergency_lights=0;}
            }
            break;

            case 0x283:
            {
              if(rx.data[1]&(1<<2)) {System.can_state.sec_flags.hood=1;}
              else                  {System.can_state.sec_flags.hood=0;}
            }
            break;

            case 0x1D0:
            {
              if(rx.data[1]&(1<<5)) {System.can_state.cont_flags.driver_safety_belt=0;}
              else                  {System.can_state.cont_flags.driver_safety_belt=1;}

              if(rx.data[2]&(1<<2)) {System.can_state.cont_flags.passenger_safety_belt=0;}
              else                  {System.can_state.cont_flags.passenger_safety_belt=1;}

              if(rx.data[0]&(1<<2)) {System.can_state.cont_flags.airbag=1;}
              else                  {System.can_state.cont_flags.airbag=0;}
            }
            break;

            case 0x13D:
            {
              if(rx.data[0]&(1<<0)) {System.can_state.cont_flags.check_engine=1;}
              else                  {System.can_state.cont_flags.check_engine=0;}
            }
            break;

            case 0x296:
            {
              if(rx.data[0]&(1<<0)) {System.can_state.cont_flags.inflation_pressure=1;}
              else                  {System.can_state.cont_flags.inflation_pressure=0;}
            }
            break;

            case 0x0DD:
            {
              if(rx.data[6]&(1<<6)) {System.can_state.cont_flags.esp=1;}
              else                  {System.can_state.cont_flags.esp=0;}
            }
            break;

            case 0x08D:
            {
              uint8_t val = rx.data[0]&0x0F;

              //Полный привод
              System.can_state.numeric_data.can_axle_1 = val; //temporary
            }
            break;

            case 0x277:
            {
              uint32_t val = ((rx.data[0]<<16)|(rx.data[1]<<8)|(rx.data[2]<<0));

              //Полный привод
              System.can_state.numeric_data.harvest_time = val; //temporary
            }
            break;

            case 0x265:
            {
              //Вставленность двери водителя
              //Вставленность двери пассажира
            }
            break;

            case 0x25F:
            {
              //Вставленность крыши
              if(rx.data[3]&(1<<0)) {System.can_state.cont_flags.fap = 1;} //temporary
              else                  {System.can_state.cont_flags.fap = 0;} //temporary
            }
            break;

            case 0x7E8:
            {
              //OBDII ответ
              if(rx.data[0]==0x03 && rx.data[1]==0x41 && rx.data[2]==0x2F)
              {
                //0xF2 - полный бак
                System.set_fuel_level_p((rx.data[3]*100Ul)/0xF2);
              }
            }
            break;

            default:
            break;
          }
        }//if(rx.id_type==STD_ID_TYPE)
      }
      else if(can_id==CAN2_ID)
      {
        if(rx.id_type==STD_ID_TYPE)
        {
          switch(rx.id)
          {
            case 0x000:
            {

            }
            break;

            default:
            break;
          }
        }//if(rx.id_type==STD_ID_TYPE)
      }
      else if(can_id==CAN3_ID)
      {
        //OBD CAN, 500 кбит\с
        if(rx.id_type==STD_ID_TYPE)
        {
          switch(rx.id)
          {
            case 0x000:
            {

            }
            break;

            default:
            break;
          }
        }//if(rx.id_type==STD_ID_TYPE)
      }
    }

    if(mess_count)
    {
      restart_sleep_and_rx_timers(can_id);
    }
  }

  System.can_state.sec_flags.can_in_sleep=can_sleep_indicate_handler();

  blocks_handler();

  jeep_wrangler_2018_analog_to_can_handler();

  taxi_blocks_handler();
}

static void audi_a6_2018_analog_to_can_handler(void)
{
  if(can_program==AUDI_A6_2018_PROGRAM)
  {
    if(is_can_timer_expired(AUX_CAN_TIMER_1))
    {
      if(System.can_state.numeric_data.eng_rpm || System.can_state.sec_flags.engine_is_on)
      {
        System.Grab(portMAX_DELAY);
        {
          System.can_state.numeric_data.eng_rpm=0;
          System.can_state.sec_flags.engine_is_on=0;
        }System.Release();
      }
    }
  }
}

static void can_rx_audi_a6_2018_handler(void)
{
  can_rx_frame_t rx;

  for(uint8_t can_id=CAN1_ID; can_id<HW_CAN_COUNT; can_id++)
  {
    uint16_t mess_count=filled_count_in_sfifo(&can_rx_sfifo[can_id]);

    for(uint16_t j=0; j<mess_count; j++)
    {
      if(!read_from_sfifo(&can_rx_sfifo[can_id], &rx))
      {
        __PRINTF("%s_RX sfifo is full, drop counter: %lu\n", get_name_from_can_id(can_id), can_rx_sfifo[can_id].drop_counter);
      }

#if defined(CAN_VEGA_FWD_PRESENT)
      rx_fwd_hadler(can_id, &rx);
#endif //defined(CAN_VEGA_FWD_PRESENT)

#if defined(YANDEX_OBD_PRESENT)
      obd_rx_handler(can_id, &rx);
#endif //defined(YANDEX_OBD_PRESENT)

      can_rx_debug_trace(&rx, can_id);

      if(can_id==CAN1_ID)
      {
        //500 кбит\с
        if(rx.id_type==STD_ID_TYPE)
        {
          switch(rx.id)
          {
            case 0x040:
            {
              if(rx.data[3]&(1<<0)) {System.can_state.cont_flags.airbag=1;}
              else                  {System.can_state.cont_flags.airbag=0;}
            }
            break;

            case 0x0A8:
            {
              uint16_t val = ((rx.data[7]<<8)|(rx.data[6]<<0));

              if(val < 0xFFFE)
              {
                val = val/4;

                System.Grab(portMAX_DELAY);

                System.can_state.numeric_data.eng_rpm = val;

                if(System.can_state.numeric_data.eng_rpm > 350) {System.can_state.sec_flags.engine_is_on = 1;}
                else                                            {System.can_state.sec_flags.engine_is_on = 0;}

                System.Release();

                restart_can_timer(AUX_CAN_TIMER_1, 2000);
              }
            }
            break;

            case 0x0AD:
            {
              uint8_t val = rx.data[5];

              System.Grab(portMAX_DELAY);

              if(val == 0x14)      {System.can_state.sec_flags.parking = 1; System.can_state.sec_flags.reverse_gear = 0;}
              else if(val == 0x18) {System.can_state.sec_flags.parking = 0; System.can_state.sec_flags.reverse_gear = 1;}
              else                 {System.can_state.sec_flags.parking = 0; System.can_state.sec_flags.reverse_gear = 0;}

              if(val == 0x14)       System.signal_state.selector_position = 'P';
              else if (val == 0x18) System.signal_state.selector_position = 'R';
              else if (val == 0x1C) System.signal_state.selector_position = 'N';
              else if (val == 0x20) System.signal_state.selector_position = 'D';
              else if (val == 0x38) System.signal_state.selector_position = 'S';

              System.Release();
            }
            break;

            case 0x0FD:
            {
              uint16_t val=((rx.data[5]<<8)|(rx.data[4]<<0));

              //скорость
              if(val < 0xFFFE)
              {
                val=val/100;

                System.can_state.numeric_data.can_speed = val;
              }

              //TRC-off
              if(rx.data[6]&(1<<0)) {System.can_state.numeric_data.concave_clear = 1;} //temporary
              else                  {System.can_state.numeric_data.concave_clear = 0;} //temporary
            }
            break;

            case 0x121:
            {
              uint8_t val = rx.data[2]&0x0F;

              System.can_state.numeric_data.accelerator=(val*66Ul)/(10Ul);
            }
            break;

            case 0x12B:
            {
              //кнопки на руле
            }
            break;

            case 0x1A2:
            {
              if(rx.data[4]&(1<<4)) {System.can_state.sec_flags.hand_break = 1;}
              else                  {System.can_state.sec_flags.hand_break = 0;}
            }
            break;

            case 0x31B:
            {
              /*
              //не работает
              uint8_t val = rx.data[3];

              if(val < 0xFE)
              {
                System.can_state.numeric_data.can_speed = val;
              }
              */
            }
            break;

            case 0x32A:
            {
              //Авария ГУР
            }
            break;

            case 0x366:
            {
              if(rx.data[2]&(1<<4)) {System.signal_state.emergency_lights = 1;}
              else                  {System.signal_state.emergency_lights = 0;}
            }
            break;

            case 0x391:
            {
              uint8_t val = rx.data[1];

              if(val!=0xFF)
              {
                System.Grab(portMAX_DELAY);
                {
                  System.can_state.numeric_data.eng_temp = val - 40.0f;
                }System.Release();
              }
            }
            break;

            case 0x3BE:
            {
              if(rx.data[3]&(1<<6)) {System.can_state.sec_flags.pedal_break = 1;}
              else                  {System.can_state.sec_flags.pedal_break = 0;}
            }
            break;

            case 0x3C0:
            {
              if(rx.data[2]&(1<<1)) {System.can_state.sec_flags.ignition = 1;}
              else                  {System.can_state.sec_flags.ignition = 0;}

              if(System.can_state.sec_flags.ignition) {System.signal_state.key_position = 'I';}
              else                                    {System.signal_state.key_position = 'O';}

            }
            break;

            case 0x3C7:
            {
              if(rx.data[6]&(1<<0)) {System.can_state.cont_flags.esp = 1;}
              else                  {System.can_state.cont_flags.esp = 0;}

              if(rx.data[6]&(1<<1)) {System.can_state.cont_flags.check_engine = 1;}
              else                  {System.can_state.cont_flags.check_engine = 0;}
            }
            break;

            case 0x3D0:
            {
              if(rx.data[0]!=0xFF)
              {
                if(rx.data[0]&(1<<0)) System.can_state.sec_flags.driver_door=1;
                else                  System.can_state.sec_flags.driver_door=0;

                if(rx.data[0]&(1<<1)) System.signal_state.cls_state.driver_door=0;
                else                  System.signal_state.cls_state.driver_door=1;

                if(System.signal_state.cls_state.driver_door || System.signal_state.cls_state.l_rear_door || System.signal_state.cls_state.r_rear_door || System.signal_state.cls_state.pass_door) _cls_state=UNLOCKED_CLS_STATE;
                else                                                                                                                                                                               _cls_state=LOCKED_CLS_STATE;

                System.signal_state.cls_state.driver_door_prepared=1;
              }

              if(rx.data[4]!=0xFF)
              {
                if(rx.data[4]==0x8C) System.signal_state.windows_position.driver_door=0;
                else                 System.signal_state.windows_position.driver_door=1;

                System.signal_state.windows_position.driver_door_prepared=1;
              }
            }
            break;

            case 0x3D1:
            {
              if(rx.data[0]!=0xFF)
              {
                if(rx.data[0]&(1<<0)) System.can_state.sec_flags.pass_door=1;
                else                  System.can_state.sec_flags.pass_door=0;

                if(rx.data[0]&(1<<1)) System.signal_state.cls_state.pass_door=0;
                else                  System.signal_state.cls_state.pass_door=1;

                if(System.signal_state.cls_state.driver_door || System.signal_state.cls_state.l_rear_door || System.signal_state.cls_state.r_rear_door || System.signal_state.cls_state.pass_door) _cls_state=UNLOCKED_CLS_STATE;
                else                                                                                                                                                                               _cls_state=LOCKED_CLS_STATE;

                System.signal_state.cls_state.pass_door_prepared=1;
              }

              if(rx.data[4]!=0xFF)
              {
                if(rx.data[4]==0x8C) System.signal_state.windows_position.pass_door=0;
                else                 System.signal_state.windows_position.pass_door=1;

                System.signal_state.windows_position.pass_door_prepared=1;
              }
            }
            break;

            case 0x3C9:
            {
              if(rx.data[1]!=0xFF)
              {
                //Наружная температура (°C)
                //= rx.data[1] - 40.0f;
              }
            }
            break;

            case 0x3CE:
            {
              if(rx.data[0]!=0xFF)
              {
                if(rx.data[0]&(1<<0)) System.can_state.sec_flags.l_rear_door=1;
                else                  System.can_state.sec_flags.l_rear_door=0;

                if(rx.data[0]&(1<<1)) System.signal_state.cls_state.l_rear_door=0;
                else                  System.signal_state.cls_state.l_rear_door=1;

                if(System.signal_state.cls_state.driver_door || System.signal_state.cls_state.l_rear_door || System.signal_state.cls_state.r_rear_door || System.signal_state.cls_state.pass_door) _cls_state=UNLOCKED_CLS_STATE;
                else                                                                                                                                                                               _cls_state=LOCKED_CLS_STATE;

                System.signal_state.cls_state.l_rear_door_prepared=1;
              }

              if(rx.data[4]!=0xFF)
              {
                if(rx.data[4]==0x8C) System.signal_state.windows_position.l_rear_door=0;
                else                 System.signal_state.windows_position.l_rear_door=1;

                System.signal_state.windows_position.l_rear_door_prepared=1;
              }
            }
            break;

            case 0x3CF:
            {
              if(rx.data[0]!=0xFF)
              {
                if(rx.data[0]&(1<<0)) System.can_state.sec_flags.r_rear_door=1;
                else                  System.can_state.sec_flags.r_rear_door=0;

                if(rx.data[0]&(1<<1)) System.signal_state.cls_state.r_rear_door=0;
                else                  System.signal_state.cls_state.r_rear_door=1;

                if(System.signal_state.cls_state.driver_door || System.signal_state.cls_state.l_rear_door || System.signal_state.cls_state.r_rear_door || System.signal_state.cls_state.pass_door) _cls_state=UNLOCKED_CLS_STATE;
                else                                                                                                                                                                               _cls_state=LOCKED_CLS_STATE;

                System.signal_state.cls_state.r_rear_door_prepared=1;
              }

              if(rx.data[4]!=0xFF)
              {
                if(rx.data[4]==0x8C) System.signal_state.windows_position.r_rear_door=0;
                else                 System.signal_state.windows_position.r_rear_door=1;

                System.signal_state.windows_position.r_rear_door_prepared=1;
              }
            }
            break;

            case 0x520:
            {
              if(rx.data[5]&(1<<0)) {System.can_state.cont_flags.driver_safety_belt = 1;}
              else                  {System.can_state.cont_flags.driver_safety_belt = 0;}

              if(rx.data[5]&(1<<2)) {System.can_state.cont_flags.passenger_safety_belt = 1;}
              else                  {System.can_state.cont_flags.passenger_safety_belt = 0;}
            }
            break;

            case 0x583:
            {
              if(rx.data[3]&(1<<4)) {System.can_state.sec_flags.trunk = 1;}
              else                  {System.can_state.sec_flags.trunk = 0;}
            }
            break;

            case 0x5F4:
            {
              if(rx.data[2]&(1<<2)) {System.can_state.sec_flags.alarm_act = 0;}
              else                  {System.can_state.sec_flags.alarm_act = 1;}
            }
            break;

            case 0x658:
            {
              if((rx.data[1]&(1<<4)) || (rx.data[1]&(1<<7))) {System.can_state.cont_flags.marker_lights = 1;} //+ПТФ
              else                                           {System.can_state.cont_flags.marker_lights = 0;}

              if(rx.data[1]&(1<<5)) {System.can_state.cont_flags.dipped_beam = 1;}
              else                  {System.can_state.cont_flags.dipped_beam = 0;}

              if(rx.data[1]&(1<<6)) {System.can_state.cont_flags.high_beam = 1;}
              else                  {System.can_state.cont_flags.high_beam = 0;}
            }
            break;

            case 0x65A:
            {
              if(rx.data[3]&(1<<7)) {System.can_state.sec_flags.hood = 1;}
              else                  {System.can_state.sec_flags.hood = 0;}

              if(rx.data[1]&(1<<7)) {System.signal_state.washer_liquid=1;}
              else                  {System.signal_state.washer_liquid=0;}
            }
            break;

            case 0x6B7:
            {
              uint32_t val = ((rx.data[2]<<16)|(rx.data[1]<<8)|(rx.data[0]<<0));
              val = val&0x000FFFFF;

              if(val < 0x00FFFFFE)
              {
                System.Grab(portMAX_DELAY);
                {
                  System.can_state.numeric_data.can_odo_km = val;
                }System.Release();
              }

              val = rx.data[5];

              if(val < 0xFE)
              {
                System.set_fuel_level_p((val*100Ul)/73Ul);
              }
            }
            break;

            default:
            break;
          }
        }//if(rx.id_type==STD_ID_TYPE)
        else if(rx.id_type==EXT_ID_TYPE)
        {
          switch(rx.id)
          {
            case 0x17330F10:
            {
              if(rx.data[1] == 0x07 && rx.data[2] == 0x33)
              {
                uint16_t val = ((rx.data[5]<<8)|(rx.data[4]<<0));

                if(val < 0xFFFE)
                {
                  System.Grab(portMAX_DELAY);

                  //����� ����, ��������� �� ������� ����
                  System.can_state.numeric_data.fuel_lev_l = val;

                  System.Release();
                }
              }
            }
            break;

            case 0x17331210:
            {
              if(rx.data[0] == 0x34 && rx.data[1] == 0x90)
              {
                if(rx.data[2] == 0x20)
                {
                  System.Grab(portMAX_DELAY);
                  System.can_state.numeric_data.bef_srvc_odo = rx.data[3]*100;
                  System.can_state.numeric_data.ex_srvc_odo = 0;
                  System.Release();
                }
                else if(rx.data[3] == 0x30)
                {
                  System.Grab(portMAX_DELAY);
                  System.can_state.numeric_data.bef_srvc_odo = 0;
                  System.can_state.numeric_data.ex_srvc_odo = rx.data[3]*100;
                  System.Release();
                }
              }
              else if(rx.data[0] == 0x34 && rx.data[1] == 0x91)
              {
                uint16_t val = ((rx.data[4]<<8)|(rx.data[3]<<0));

                if(rx.data[2] == 0x02)
                {
                  System.Grab(portMAX_DELAY);
                  System.can_state.numeric_data.bef_srvc_time = val;
                  System.can_state.numeric_data.ex_srvc_time = 0;
                  System.Release();
                }
                else if(rx.data[3] == 0x03)
                {
                  System.Grab(portMAX_DELAY);
                  System.can_state.numeric_data.bef_srvc_time = 0;
                  System.can_state.numeric_data.ex_srvc_time = val;
                  System.Release();
                }
              }
            }
            break;

            default:
            break;
          }
        }//else if(rx.id_type==EXT_ID_TYPE)
      }
      else if(can_id==CAN2_ID)
      {
        if(rx.id_type==STD_ID_TYPE)
        {
          switch(rx.id)
          {
            case 0x000:
            {

            }
            break;

            default:
            break;
          }
        }//if(rx.id_type==STD_ID_TYPE)
      }
      else if(can_id==CAN3_ID)
      {
        //OBD CAN, 500 кбит\с
        if(rx.id_type==STD_ID_TYPE)
        {
          switch(rx.id)
          {
            case 0x000:
            {

            }
            break;

            default:
            break;
          }
        }//if(rx.id_type==STD_ID_TYPE)
      }
    }

    if(mess_count)
    {
      restart_sleep_and_rx_timers(can_id);
    }
  }

  System.can_state.sec_flags.can_in_sleep=can_sleep_indicate_handler();

  blocks_handler();

  audi_a6_2018_analog_to_can_handler();

  taxi_blocks_handler();
}