#ifndef __OUTPUTS_DEFINES_H
#define __OUTPUTS_DEFINES_H

#define OUTPUT_NUMBER(OUT_NUM)                                (OUT_NUM-1)
#define INPUT_NUMBER(IN_NUM)                                  (IN_NUM-1)

//Kia Rio
#define RIO_IGNITION_OUTPUT_ID                                (OUTPUT_NUMBER(1))
#define RIO_STARTER_OUTPUT_ID                                 (OUTPUT_NUMBER(2))
#define RIO_HORN_OUTPUT_ID                                    (OUTPUT_NUMBER(3))
#define RIO_WIRED_BLOCKING_RELAY_OUTPUT_ID                    (OUTPUT_NUMBER(4))//блокировка зажигания
#define RIO_WINDOWS_OUTPUT_ID                                 (OUTPUT_NUMBER(5))
#define RIO_HOOD_LOCK_OUTPUT_ID                               (OUTPUT_NUMBER(6))
#define RIO_DRIVER_DOOR_EMULATION_OUTPUT_ID                   (OUTPUT_NUMBER(7))
#define RIO_HOOD_UNLOCK_OUTPUT_ID                             (OUTPUT_NUMBER(8))
//                                                            (OUTPUT_NUMBER(9))
#define RIO_WIRELESS_BLOCKING_RELAY_OUTPUT_ID                 (OUTPUT_NUMBER(10))//бп блокировка бензонасоса
#define RIO_MAX_STARTER_SWITCH_ON_TIME_MS                     (4000)

#define RIO_WASHER_LIQUID_INPUT_ID                            (INPUT_NUMBER(2))

//Hyundai Solaris
#define SOLARIS_WIRED_BLOCKING_RELAY_OUTPUT_ID                (OUTPUT_NUMBER(4))//блокировка зажигания
#define SOLARIS_WIRELESS_BLOCKING_RELAY_OUTPUT_ID             (0xFF)

//Renault Kaptur
//ц.вх 1 (id 0) - статус заммка капота
#define KAPTUR_DRIVER_DOOR_EMULATION_OUTPUT_ID                (OUTPUT_NUMBER(1))
#define KAPTUR_START_STOP_BUTTON_OUTPUT_ID                    (OUTPUT_NUMBER(2))
#define KAPTUR_HORN_OUTPUT_ID                                 (OUTPUT_NUMBER(3))
#define KAPTUR_WIRED_BLOCKING_RELAY_OUTPUT_ID                 (OUTPUT_NUMBER(4))//блокировка бензонасоса
#define KAPTUR_WINDOWS_OUTPUT_ID                              (OUTPUT_NUMBER(5))
#define KAPTUR_HOOD_UNLOCK_OUTPUT_ID                          (OUTPUT_NUMBER(6))
#define KAPTUR_DISABLE_KEY_MODULE_POWER_ID                    (OUTPUT_NUMBER(7))//нз реле на считывателе ключа
#define KAPTUR_HOOD_LOCK_OUTPUT_ID                            (OUTPUT_NUMBER(8))
//                                                            (OUTPUT_NUMBER(9))
#define KAPTUR_WIRELESS_BLOCKING_RELAY_OUTPUT_ID              (OUTPUT_NUMBER(10))//бп блокировка зажигания

//Hyundai Genesis
#define GENESIS_DRIVER_DOOR_EMULATION_OUTPUT_ID               (OUTPUT_NUMBER(1))
#define GENESIS_START_STOP_BUTTON_OUTPUT_ID                   (OUTPUT_NUMBER(2))
#define GENESIS_HORN_OUTPUT_ID                                (OUTPUT_NUMBER(3))
#define GENESIS_WIRED_BLOCKING_RELAY_OUTPUT_ID                (OUTPUT_NUMBER(4))//ничего нет
#define GENESIS_WINDOWS_OUTPUT_ID                             (OUTPUT_NUMBER(5))
#define GENESIS_HOOD_UNLOCK_OUTPUT_ID                         (OUTPUT_NUMBER(6))
#define GENESIS_PEADAL_BREAK_OUTPUT_ID                        (OUTPUT_NUMBER(7))
#define GENESIS_HOOD_LOCK_OUTPUT_ID                           (OUTPUT_NUMBER(8))
#define GENESIS_KEY_POWER_OUTPUT_ID                           (OUTPUT_NUMBER(9))
#define GENESIS_WIRELESS_BLOCKING_RELAY_OUTPUT_ID             (OUTPUT_NUMBER(10))

//Audi A3, Audi Q3, Skoda Octavia, Skoda Rapid
#define AUDI_A3_Q3_IGNITION_OUTPUT_ID                         (OUTPUT_NUMBER(1))
#define AUDI_A3_Q3_STARTER_OUTPUT_ID                          (OUTPUT_NUMBER(2))
#define SKODA_RAPID_HORN_OUTPUT_ID                            (OUTPUT_NUMBER(3))
#define AUDI_A3_Q3_WIRED_BLOCKING_RELAY_OUTPUT_ID             (OUTPUT_NUMBER(4))//блокировка зажигания (или бензонасос? если зажигание, то прогрев из завершенной аренды работать не будет)
#define AUDI_START_STOP_OFF_OUTPUT_ID                         (OUTPUT_NUMBER(5))
#define SKODA_OCTAVIA_RAPID_WINDOWS_OUTPUT_ID                 (OUTPUT_NUMBER(5))
#define AUDI_A3_Q3_HOOD_UNLOCK_OUTPUT_ID                      (OUTPUT_NUMBER(6))
#define AUDI_A3_Q3_KEY_POWER_OUTPUT_ID                        (OUTPUT_NUMBER(7))
#define AUDI_A3_Q3_HOOD_LOCK_OUTPUT_ID                        (OUTPUT_NUMBER(8))
#define AUDI_A3_SKODA_OCTAVIA_RAPID_EMERG_LIGHT_OUTPUT_ID     (OUTPUT_NUMBER(9))//A3, Octavia, Rapid моргает по аналогу
#define AUDI_A3_Q3_WIRELESS_BLOCKING_RELAY_OUTPUT_ID          (OUTPUT_NUMBER(10))//бп блокировка бензонасоса
#define SKODA_RAPID_CLS_LOCK_OUTPUT_ID                        (OUTPUT_NUMBER(10))
#define SKODA_RAPID_CLS_UNLOCK_OUTPUT_ID                      (OUTPUT_NUMBER(10))
#define SKODA_OCTAVIA_RAPID_WIRELESS_BLOCKING_RELAY_OUTPUT_ID (OUTPUT_NUMBER(12))//бп блокировка бензонасоса

#define SKODA_RAPID_HOOD_DOOR_INPUT_POLARITY                  (ACTIVE_0)
#define SKODA_RAPID_HOOD_DOOR_INPUT_ID                        (INPUT_NUMBER(3))

//WV POLO
#define VW_POLO_HORN_OUTPUT_ID                                (OUTPUT_NUMBER(3))
#define VW_POLO_WINDOWS_OUTPUT_ID                             (OUTPUT_NUMBER(5))
#define VW_POLO_EMERG_LIGHT_OUTPUT_ID                         (OUTPUT_NUMBER(9))
#define VW_POLO_CLS_LOCK_OUTPUT_ID                            (OUTPUT_NUMBER(10))
#define VW_POLO_CLS_UNLOCK_OUTPUT_ID                          (OUTPUT_NUMBER(11))
#define VW_POLO_WIRELESS_BLOCKING_RELAY_OUTPUT_ID             (OUTPUT_NUMBER(12))//бп блокировка бензонасоса

#define SKODA_RAPID_2013_CLS_STATE_INPUT_ID                   (INPUT_NUMBER(2))

#define SKODA_RAPID_2013_CLS_STATE_INPUT_ID                   (INPUT_NUMBER(2))

//Porsche Macan, Porsche 911, Panamera
#define PORSCHE_IGNITION_OUTPUT_ID                            (OUTPUT_NUMBER(1))
#define PORSCHE_STARTER_OUTPUT_ID                             (OUTPUT_NUMBER(2))
//
#define PORSCHE_WIRED_BLOCKING_RELAY_OUTPUT_ID                (OUTPUT_NUMBER(4))//блокировка зажигания
#define PORSCHE_PEADAL_BREAK_OUTPUT_ID                        (OUTPUT_NUMBER(5))
#define PORSCHE_HOOD_UNLOCK_OUTPUT_ID                         (OUTPUT_NUMBER(6))
#define PORSCHE_KEY_POWER_OUTPUT_ID                           (OUTPUT_NUMBER(7))
#define PORSCHE_HOOD_LOCK_OUTPUT_ID                           (OUTPUT_NUMBER(8))
//
#define PORSCHE_WIRELESS_BLOCKING_RELAY_OUTPUT_ID             (OUTPUT_NUMBER(10))//бп блокировка бензонасоса

//MB E200
#define MB_E200_START_STOP_BUTTON_OUTPUT_ID                   (OUTPUT_NUMBER(2))
#define MB_E200_HORN_OUTPUT_ID                                (OUTPUT_NUMBER(3))//на E200 не смонтирован, на С180 через реле
#define MB_E200_HOOD_UNLOCK_OUTPUT_ID                         (OUTPUT_NUMBER(6))
#define MB_E200_WIRED_BLOCKING_RELAY_OUTPUT_ID                (OUTPUT_NUMBER(4))//проводная блокировка, на E200 не смонтирован, только на С180
#define MB_E200_HOOD_LOCK_OUTPUT_ID                           (OUTPUT_NUMBER(8))
#define MB_E200_KEY_POWER_OUTPUT_ID                           (OUTPUT_NUMBER(9))
#define MB_E200_WIRELESS_BLOCKING_RELAY_OUTPUT_ID             (OUTPUT_NUMBER(10))//бп блокировка бензонасоса

#define IS_MB_C180_INPUT_ID                                   (INPUT_NUMBER(2))
#define IS_MB_C180()                                          (System.signal_state.digital_input[IS_MB_C180_INPUT_ID])
#define IS_MB_E200_2020_INPUT_ID                              (INPUT_NUMBER(4))
#define IS_MB_E200_2020()                                     (System.signal_state.digital_input[IS_MB_E200_2020_INPUT_ID])

//BMW 520i
#define BMW_520I_START_STOP_BUTTON_OUTPUT_ID                  (OUTPUT_NUMBER(2))
#define BMW_520I_PEADAL_BREAK_OUTPUT_ID                       (OUTPUT_NUMBER(5))
#define BMW_520I_HOOD_UNLOCK_OUTPUT_ID                        (OUTPUT_NUMBER(6))
#define BMW_520I_DRIVER_DOOR_EMULATION_OUTPUT_ID              (OUTPUT_NUMBER(7))//не использовать, т.к открывается цз. Артем говорит что больше не открывается, больше переделывать не будем.
#define BMW_520I_HOOD_LOCK_OUTPUT_ID                          (OUTPUT_NUMBER(8))
#define BMW_520I_KEY_POWER_OUTPUT_ID                          (OUTPUT_NUMBER(9))
#define BMW_520I_WIRELESS_BLOCKING_RELAY_OUTPUT_ID            (OUTPUT_NUMBER(10))//бп блокировка бензонасоса

#define IS_BMW_320D_INPUT_ID                                  (INPUT_NUMBER(2))
#define IS_BMW_320D()                                         (System.signal_state.digital_input[IS_BMW_320D_INPUT_ID])

//Ford Transit
#define FORD_TRANSIT_REAR_DOOR_INPUT_POLARITY                 (ACTIVE_0)
#define FORD_TRANSIT_REAR_DOOR_INPUT_ID                       (INPUT_NUMBER(2))
#define FORD_TRANSIT_TRUNK_DOOR_INPUT_POLARITY                (ACTIVE_1)
#define FORD_TRANSIT_TRUNK_DOOR_INPUT_ID                      (INPUT_NUMBER(3))
#define FORD_TRANSIT_HOOD_DOOR_INPUT_POLARITY                 (ACTIVE_0)
#define FORD_TRANSIT_HOOD_DOOR_INPUT_ID                       (INPUT_NUMBER(4))

#define FORD_TRANSIT_TEMP_IGNITION_OUTPUT_ID                  (OUTPUT_NUMBER(1)) //используется только перед открытием ЦЗ
//#define FORD_TRANSIT_IGNITION_OUTPUT_ID                     (OUTPUT_NUMBER(1))
//#define FORD_TRANSIT_STARTER_OUTPUT_ID                      (OUTPUT_NUMBER(2))
#define FORD_TRANSIT_HORN_OUTPUT_ID                           (OUTPUT_NUMBER(3))
#define FORD_TRANSIT_WIRED_BLOCKING_RELAY_OUTPUT_ID           (OUTPUT_NUMBER(4))//блокировка зажигания
#define FORD_TRANSIT_WINDOWS_OUTPUT_ID                        (OUTPUT_NUMBER(5))
#define FORD_TRANSIT_HOOD_UNLOCK_OUTPUT_ID                    (OUTPUT_NUMBER(6))
//#define FORD_TRANSIT_KEY_POWER_OUTPUT_ID                      (OUTPUT_NUMBER(7))
#define FORD_TRANSIT_HOOD_LOCK_OUTPUT_ID                      (OUTPUT_NUMBER(8))
#define FORD_TRANSIT_EMERG_LIGHT_OUTPUT_ID                    (OUTPUT_NUMBER(9))
#define FORD_TRANSIT_CLS_LOCK_OUTPUT_ID                       (OUTPUT_NUMBER(10))
#define FORD_TRANSIT_CLS_UNLOCK_OUTPUT_ID                     (OUTPUT_NUMBER(11))
#define FORD_TRANSIT_WIRELESS_BLOCKING_RELAY_OUTPUT_ID        (0xFF)//бп блокировка бензонасоса

//Citroen Jumpy
#define CITROEN_JUMPY_CLS_STATE_INPUT_ID                      (INPUT_NUMBER(2))
#define CITROEN_JUMPY_HOOD_DOOR_INPUT_ID                      (INPUT_NUMBER(3))
#define CITROEN_JUMPY_FRONT_DOORS_INPUT_ID                    (INPUT_NUMBER(4))
#define CITROEN_JUMPY_MANUAL_GEARBOX_INPUT_ID                 (INPUT_NUMBER(5))
#define CITROEN_JUMPY_REAR_DOORS_INPUT_ID                     (0xFF)
#define CITROEN_JUMPY_TRUNK_DOOR_INPUT_ID                     (0xFF)
#define IS_CITROEN_JUMPY_WITH_MANUAL_GEARBOX()                (System.signal_state.digital_input[CITROEN_JUMPY_MANUAL_GEARBOX_INPUT_ID])

#define CITROEN_JUMPY_IGNITION_OUTPUT_ID                      (OUTPUT_NUMBER(1))
#define CITROEN_JUMPY_STARTER_OUTPUT_ID                       (OUTPUT_NUMBER(2))
#define CITROEN_JUMPY_HORN_OUTPUT_ID                          (OUTPUT_NUMBER(3))
#define CITROEN_JUMPY_WIRED_BLOCKING_RELAY_OUTPUT_ID          (OUTPUT_NUMBER(4))//блокировка зажигания
#define CITROEN_JUMPY_WINDOWS_OUTPUT_ID                       (OUTPUT_NUMBER(5))
#define CITROEN_JUMPY_HOOD_UNLOCK_OUTPUT_ID                   (OUTPUT_NUMBER(6))
#define CITROEN_JUMPY_KEY_POWER_OUTPUT_ID                     (OUTPUT_NUMBER(7))
#define CITROEN_JUMPY_HOOD_LOCK_OUTPUT_ID                     (OUTPUT_NUMBER(8))
#define CITROEN_JUMPY_EMERG_LIGHT_OUTPUT_ID                   (OUTPUT_NUMBER(9))
#define CITROEN_JUMPY_CLS_LOCK_OUTPUT_ID                      (OUTPUT_NUMBER(10))
#define CITROEN_JUMPY_CLS_UNLOCK_OUTPUT_ID                    (OUTPUT_NUMBER(10))
#define CITROEN_JUMPY_WIRELESS_BLOCKING_RELAY_OUTPUT_ID       (OUTPUT_NUMBER(12))//бп блокировка бензонасоса

//Lada Largus
#define LADA_LARGUS_CLS_UNLOCK_OUTPUT_ID                      (OUTPUT_NUMBER(6))
#define LADA_LARGUS_CLS_LOCK_OUTPUT_ID                        (OUTPUT_NUMBER(8))
#define LADA_LARGUS_WIRELESS_BLOCKING_RELAY_OUTPUT_ID         (0xFF)
#define LADA_LARGUS_HOOD_UNLOCK_OUTPUT_ID                     (0xFF)
#define LADA_LARGUS_HOOD_LOCK_OUTPUT_ID                       (0xFF)

//Volvo XC60
#define VOLVO_XC60_PEADAL_BREAK_OUTPUT_ID                     (OUTPUT_NUMBER(1))
#define VOLVO_XC60_START_STOP_BUTTON_OUTPUT_ID                (OUTPUT_NUMBER(2))
#define VOLVO_XC60_HORN_OUTPUT_ID                             (OUTPUT_NUMBER(3))
#define VOLVO_XC60_WIRED_BLOCKING_RELAY_OUTPUT_ID             (OUTPUT_NUMBER(4))
//#define VOLVO_XC60_WINDOWS_OUTPUT_ID                        (OUTPUT_NUMBER(5))
#define VOLVO_XC60_HOOD_UNLOCK_OUTPUT_ID                      (OUTPUT_NUMBER(6))
#define VOLVO_XC60_DRIVER_DOOR_EMULATION_OUTPUT_ID            (OUTPUT_NUMBER(7))
#define VOLVO_XC60_HOOD_LOCK_OUTPUT_ID                        (OUTPUT_NUMBER(8))
#define VOLVO_XC60_EMERG_LIGHT_OUTPUT_ID                      (OUTPUT_NUMBER(9))
#define VOLVO_XC60_KEY_POWER_OUTPUT_ID                        (OUTPUT_NUMBER(10))
#define VOLVO_XC60_WIRELESS_BLOCKING_RELAY_OUTPUT_ID          (0xFF)

//Volvo XC40
#define VOLVO_XC40_PEADAL_BREAK_OUTPUT_ID                     (OUTPUT_NUMBER(1))
#define VOLVO_XC40_START_STOP_BUTTON_OUTPUT_ID                (OUTPUT_NUMBER(2))
#define VOLVO_XC40_HORN_OUTPUT_ID                             (OUTPUT_NUMBER(3))
#define VOLVO_XC40_WIRED_BLOCKING_RELAY_OUTPUT_ID             (OUTPUT_NUMBER(4))
//#define VOLVO_XC40_WINDOWS_OUTPUT_ID                        (OUTPUT_NUMBER(5))
#define VOLVO_XC40_HOOD_UNLOCK_OUTPUT_ID                      (OUTPUT_NUMBER(6))
#define VOLVO_XC40_DRIVER_DOOR_EMULATION_OUTPUT_ID            (OUTPUT_NUMBER(7))
//#define VOLVO_XC40_CLS_UNLOCK_OUTPUT_ID                       (VOLVO_XC40_DRIVER_DOOR_EMULATION_OUTPUT_ID)
#define VOLVO_XC40_HOOD_LOCK_OUTPUT_ID                        (OUTPUT_NUMBER(8))
#define VOLVO_XC40_EMERG_LIGHT_OUTPUT_ID                      (OUTPUT_NUMBER(9))
#define VOLVO_XC40_KEY_POWER_OUTPUT_ID                        (OUTPUT_NUMBER(10))
#define VOLVO_XC40_CLS_LOCK_OUTPUT_ID                         (OUTPUT_NUMBER(11))
#define VOLVO_XC40_CLS_UNLOCK_OUTPUT_ID                       (OUTPUT_NUMBER(12))
#define VOLVO_XC40_WIRELESS_BLOCKING_RELAY_OUTPUT_ID          (0xFF)

//Range Rover Velar
#define RANGE_ROVER_VELAR_START_STOP_BUTTON_OUTPUT_ID         (OUTPUT_NUMBER(1))
#define RANGE_ROVER_VELAR_STARTER_OUTPUT_ID                   (OUTPUT_NUMBER(2))
#define RANGE_ROVER_VELAR_HORN_OUTPUT_ID                      (OUTPUT_NUMBER(3))
#define RANGE_ROVER_VELAR_WIRED_BLOCKING_RELAY_OUTPUT_ID      (OUTPUT_NUMBER(4))
#define RANGE_ROVER_VELAR_WINDOWS_OUTPUT_ID                   (OUTPUT_NUMBER(5))//используется для подключения к LIN
#define RANGE_ROVER_VELAR_HOOD_UNLOCK_OUTPUT_ID               (OUTPUT_NUMBER(6))
#define RANGE_ROVER_VELAR_KEY_POWER_OUTPUT_ID                 (OUTPUT_NUMBER(7))
#define RANGE_ROVER_VELAR_HOOD_LOCK_OUTPUT_ID                 (OUTPUT_NUMBER(8))
#define RANGE_ROVER_VELAR_KEY2_POWER_OUTPUT_ID                (OUTPUT_NUMBER(10))//проводной обходчик через реле
#define RANGE_ROVER_VELAR_CLS_UNLOCK_OUTPUT_ID                (OUTPUT_NUMBER(11))
#define RANGE_ROVER_VELAR_CLS_LOCK_OUTPUT_ID                  (OUTPUT_NUMBER(12))
#define RANGE_ROVER_VELAR_WIRELESS_BLOCKING_RELAY_OUTPUT_ID   (0xFF)//бп блокировка
#define RANGE_ROVER_VELAR_PEADAL_BREAK_OUTPUT_ID              (0xFF)

//Nissan Qashqai
#define NISSAN_QASHQAI_IGNITION_OUTPUT_ID                     (OUTPUT_NUMBER(1))
#define NISSAN_QASHQAI_STARTER_OUTPUT_ID                      (OUTPUT_NUMBER(2))
#define NISSAN_QASHQAI_HORN_OUTPUT_ID                         (OUTPUT_NUMBER(3))
#define NISSAN_QASHQAI_WIRED_BLOCKING_RELAY_OUTPUT_ID         (OUTPUT_NUMBER(4))//блокировка бензонасоса
#define NISSAN_QASHQAI_WINDOWS_OUTPUT_ID                      (OUTPUT_NUMBER(5))
#define NISSAN_QASHQAI_HOOD_ULOCK_OUTPUT_ID                   (OUTPUT_NUMBER(6))
#define NISSAN_QASHQAI_DRIVER_DOOR_EMULATION_OUTPUT_ID        (OUTPUT_NUMBER(7))
#define NISSAN_QASHQAI_HOOD_LOCK_OUTPUT_ID                    (OUTPUT_NUMBER(8))
#define NISSAN_QASHQAI_EMERG_LIGHT_OUTPUT_ID                  (OUTPUT_NUMBER(9))
#define NISSAN_QASHQAI_ENGINE_CAN_RELAY_OUTPUT_ID             (OUTPUT_NUMBER(10))//отключенгие моторной шины
#define NISSAN_QASHQAI_WIRELESS_BLOCKING_RELAY_OUTPUT_ID      (0xFF)//бп блокировка

//VW Transporter
#define VW_TRANSPORTER_MANUAL_GEARBOX_INPUT_ID                (INPUT_NUMBER(5))
#define IS_VW_TRANSPORTER_WITH_MANUAL_GEARBOX()               (System.signal_state.digital_input[VW_TRANSPORTER_MANUAL_GEARBOX_INPUT_ID])

#define VW_TRANSPORTER_IGNITION_OUTPUT_ID                     (OUTPUT_NUMBER(1))
#define VW_TRANSPORTER_STARTER_OUTPUT_ID                      (OUTPUT_NUMBER(2))
#define VW_TRANSPORTER_HORN_OUTPUT_ID                         (OUTPUT_NUMBER(3))
#define VW_TRANSPORTER_WIRED_BLOCKING_RELAY_OUTPUT_ID         (OUTPUT_NUMBER(4))//блокировка зажигания
#define VW_TRANSPORTER_WINDOWS_OUTPUT_ID                      (OUTPUT_NUMBER(5))
#define VW_TRANSPORTER_HOOD_UNLOCK_OUTPUT_ID                  (OUTPUT_NUMBER(6))
#define VW_TRANSPORTER_ACC_OUTPUT_ID                          (OUTPUT_NUMBER(7))
#define VW_TRANSPORTER_HOOD_LOCK_OUTPUT_ID                    (OUTPUT_NUMBER(8))
#define VW_TRANSPORTER_EMERG_LIGHT_OUTPUT_ID                  (OUTPUT_NUMBER(9))
#define VW_TRANSPORTER_CLS_LOCK_OUTPUT_ID                     (OUTPUT_NUMBER(10))
#define VW_TRANSPORTER_CLS_UNLOCK_OUTPUT_ID                   (OUTPUT_NUMBER(11))
#define VW_TRANSPORTER_WIRELESS_BLOCKING_RELAY_OUTPUT_ID      (0xFF)//бп блокировка бензонасоса

//Hyundai Creta
#define HYUNDAI_CRETA_HOOD_DOOR_INPUT_POLARITY                (ACTIVE_0)
#define HYUNDAI_CRETA_HOOD_DOOR_INPUT_ID                      (INPUT_NUMBER(3))

#define HYUNDAI_CRETA_IGNITION_OUTPUT_ID                      (OUTPUT_NUMBER(1))
#define HYUNDAI_CRETA_STARTER_OUTPUT_ID                       (OUTPUT_NUMBER(2))
#define HYUNDAI_CRETA_HORN_OUTPUT_ID                          (OUTPUT_NUMBER(3))
#define HYUNDAI_CRETA_WIRED_BLOCKING_RELAY_OUTPUT_ID          (OUTPUT_NUMBER(4))//блокировка зажигания
#define HYUNDAI_CRETA_WINDOWS_OUTPUT_ID                       (OUTPUT_NUMBER(5))
#define HYUNDAI_CRETA_HOOD_LOCK_OUTPUT_ID                     (OUTPUT_NUMBER(6))
#define HYUNDAI_CRETA_LIGHTS_POWER_OUTPUT_ID                  (OUTPUT_NUMBER(7))
#define HYUNDAI_CRETA_HOOD_UNLOCK_OUTPUT_ID                   (OUTPUT_NUMBER(8))
#define HYUNDAI_CRETA_EMERG_LIGHT_OUTPUT_ID                   (OUTPUT_NUMBER(9))
#define HYUNDAI_CRETA_HEAD_CONTROL_OUTPUT_ID                  (OUTPUT_NUMBER(12))
#define HYUNDAI_CRETA_WIRELESS_BLOCKING_RELAY_OUTPUT_ID       (0xFF)//бп блокировка бензонасоса

//BMW X1
#define BMW_X1_START_STOP_BUTTON_OUTPUT_ID                    (OUTPUT_NUMBER(2))
#define BMW_X1_PEADAL_BREAK_OUTPUT_ID                         (OUTPUT_NUMBER(5))
#define BMW_X1_HOOD_UNLOCK_OUTPUT_ID                          (OUTPUT_NUMBER(6))
#define BMW_X1_DRIVER_DOOR_EMULATION_OUTPUT_ID                (OUTPUT_NUMBER(7))
#define BMW_X1_HOOD_LOCK_OUTPUT_ID                            (OUTPUT_NUMBER(8))
#define BMW_X1_KEY_POWER_OUTPUT_ID                            (OUTPUT_NUMBER(9))
#define BMW_X1_WIRELESS_BLOCKING_RELAY_OUTPUT_ID              (0xFF)//бп блокировка бензонасоса

//Ford Mustang'65
#define FORD_MUSTANG65_ENGINE_TEMP_INPUT_ID                   (INPUT_NUMBER(1))
#define FORD_MUSTANG65_FUEL_INPUT_ID                          (INPUT_NUMBER(2))
#define FORD_MUSTANG65_TACHO_INPUT_ID                         (INPUT_NUMBER(3))
#define FORD_MUSTANG65_SPEED_INPUT_ID                         (INPUT_NUMBER(4))

#define FORD_MUSTANG65_WIRED1_BLOCKING_RELAY_OUTPUT_ID        (OUTPUT_NUMBER(1)) //блок стартера, включенный выход разрывает цепь
#define FORD_MUSTANG65_WIRED_BLOCKING_RELAY_OUTPUT_ID         (OUTPUT_NUMBER(2)) //блок катушки зажигания, включенный выход разрывает цепь
#define FORD_MUSTANG65_HORN_OUTPUT_ID                         (OUTPUT_NUMBER(3))
#define FORD_MUSTANG65_IGNITION_ID                            (OUTPUT_NUMBER(4))
#define FORD_MUSTANG65_CLS_LOCK_OUTPUT_ID                     (OUTPUT_NUMBER(5))
#define FORD_MUSTANG65_HOOD_UNLOCK_OUTPUT_ID                  (OUTPUT_NUMBER(6))
#define FORD_MUSTANG65_CLS_UNLOCK_OUTPUT_ID                   (OUTPUT_NUMBER(7))
#define FORD_MUSTANG65_HOOD_LOCK_OUTPUT_ID                    (OUTPUT_NUMBER(8))
#define FORD_MUSTANG65_WIRELESS_BLOCKING_RELAY_OUTPUT_ID      (0xFF)//бп блокировка бензонасоса

#define FORD_MUSTANG65_TRUNK_UNLOCK_BROUTPUT_ID               (OUTPUT_NUMBER(1))
#define FORD_MUSTANG65_TRUNK_LOCK_BROUTPUT_ID                 (OUTPUT_NUMBER(2))
#define FORD_MUSTANG65_FUEL_CAP_UNLOCK_BROUTPUT_ID            (OUTPUT_NUMBER(3))
#define FORD_MUSTANG65_FUEL_CAP_LOCK_BROUTPUT_ID              (OUTPUT_NUMBER(4))
#define FORD_MUSTANG65_POWER_EN_BROUTPUT_ID                   (OUTPUT_NUMBER(5)) //включение всей электрики
#define FORD_MUSTANG65_POWER_DIS_BROUTPUT_ID                  (OUTPUT_NUMBER(6)) //отключение всей электрики
#define FORD_MUSTANG65_HEAD_LIGHTS_BROUTPUT_ID                (OUTPUT_NUMBER(7))

#define FORD_MUSTANG65_TRUNK_DOOR_BRINPUT_ID                  (INPUT_NUMBER(1))
#define FORD_MUSTANG65_DRIVER_WINDOW_BRINPUT_ID               (INPUT_NUMBER(2))
#define FORD_MUSTANG65_DRIVER_WINDOW_LEAF_BRINPUT_ID          (INPUT_NUMBER(3))//форточка
#define FORD_MUSTANG65_PASS_WINDOW_BRINPUT_ID                 (INPUT_NUMBER(4))
#define FORD_MUSTANG65_PASS_WINDOW_LEAF_BRINPUT_ID            (INPUT_NUMBER(5))//форточка
//#define  (INPUT_NUMBER(6))
#define FORD_MUSTANG65_DRIVER_DOOR_BRINPUT_ID                 (INPUT_NUMBER(7))
#define FORD_MUSTANG65_HOOD_DOOR_BRINPUT_ID                   (INPUT_NUMBER(8))
#define FORD_MUSTANG65_PASS_DOOR_BRINPUT_ID                   (INPUT_NUMBER(9))
#define FORD_MUSTANG65_HOOD_LOCK_BRINPUT_ID                   (INPUT_NUMBER(10)) //статус замка капота
#define FORD_MUSTANG65_PARKING_BRINPUT_ID                     (INPUT_NUMBER(11))
#define FORD_MUSTANG65_FUEL_CAP_LOCK_BRINPUT_ID               (INPUT_NUMBER(12)) //статус замка пробки
#define FORD_MUSTANG65_HAND_BREAK_BRINPUT_ID                  (INPUT_NUMBER(13))
#define FORD_MUSTANG65_FUEL_CAP_BRINPUT_ID                    (INPUT_NUMBER(14))

//Ford Mustang'69
//#define (INPUT_NUMBER(1))//статус замка капота
#define FORD_MUSTANG69_FUEL_INPUT_ID                          (INPUT_NUMBER(2))
#define FORD_MUSTANG69_ENGINE_TEMP_INPUT_ID                   (INPUT_NUMBER(3))
#define FORD_MUSTANG69_TACHO_INPUT_ID                         (INPUT_NUMBER(4))
#define FORD_MUSTANG69_SPEED_INPUT_ID                         (0xFF)

#define FORD_MUSTANG69_WIRED1_BLOCKING_RELAY_OUTPUT_ID        (OUTPUT_NUMBER(1)) //блок стартера, включенный выход разрывает цепь
#define FORD_MUSTANG69_WIRED_BLOCKING_RELAY_OUTPUT_ID         (OUTPUT_NUMBER(2)) //блок катушки зажигания, включенный выход разрывает цепь
#define FORD_MUSTANG69_HORN_OUTPUT_ID                         (OUTPUT_NUMBER(3))
//#define FORD_MUSTANG69_IGNITION_ID                            (OUTPUT_NUMBER(4))
#define FORD_MUSTANG69_WIRED2_BLOCKING_RELAY_OUTPUT_ID        (OUTPUT_NUMBER(4)) //блок крыши
#define FORD_MUSTANG69_CLS_LOCK_OUTPUT_ID                     (OUTPUT_NUMBER(5))
#define FORD_MUSTANG69_HOOD_UNLOCK_OUTPUT_ID                  (OUTPUT_NUMBER(6))
#define FORD_MUSTANG69_CLS_UNLOCK_OUTPUT_ID                   (OUTPUT_NUMBER(7))
#define FORD_MUSTANG69_HOOD_LOCK_OUTPUT_ID                    (OUTPUT_NUMBER(8))
#define FORD_MUSTANG69_WIRELESS_BLOCKING_RELAY_OUTPUT_ID      (0xFF)//бп блокировка бензонасоса

#define FORD_MUSTANG69_TRUNK_UNLOCK_BROUTPUT_ID               (OUTPUT_NUMBER(1))
#define FORD_MUSTANG69_TRUNK_LOCK_BROUTPUT_ID                 (OUTPUT_NUMBER(2))
#define FORD_MUSTANG69_FUEL_CAP_UNLOCK_BROUTPUT_ID            (0xFF)
#define FORD_MUSTANG69_FUEL_CAP_LOCK_BROUTPUT_ID              (0xFF)
#define FORD_MUSTANG69_POWER_EN_BROUTPUT_ID                   (OUTPUT_NUMBER(3)) //включение всей электрики
#define FORD_MUSTANG69_POWER_DIS_BROUTPUT_ID                  (OUTPUT_NUMBER(4)) //отключение всей электрики
#define FORD_MUSTANG69_WINDOWS_BROUTPUT_ID                    (OUTPUT_NUMBER(6))
#define FORD_MUSTANG69_HEAD_LIGHTS_BROUTPUT_ID                (OUTPUT_NUMBER(7))

#define FORD_MUSTANG69_TRUNK_DOOR_BRINPUT_ID                  (INPUT_NUMBER(1))
#define FORD_MUSTANG69_LEFT_ROOF_LOCK_BRINPUT_ID              (INPUT_NUMBER(2)) //замок крыши левый
#define FORD_MUSTANG69_RIGHT_ROOF_LOCK_BRINPUT_ID             (INPUT_NUMBER(3)) //замок крыши правый
#define FORD_MUSTANG69_ROOF_BRINPUT_ID                        (INPUT_NUMBER(4)) //концевик крыши
#define FORD_MUSTANG69_DRIVER_DOOR_BRINPUT_ID                 (INPUT_NUMBER(5))
#define FORD_MUSTANG69_PASS_DOOR_BRINPUT_ID                   (INPUT_NUMBER(6))
#define FORD_MUSTANG69_HOOD_DOOR_BRINPUT_ID                   (INPUT_NUMBER(7))
#define FORD_MUSTANG69_PARKING_BRINPUT_ID                     (INPUT_NUMBER(8))
//#define (INPUT_NUMBER(9))
//#define (INPUT_NUMBER(10))
//#define (INPUT_NUMBER(11))
#define FORD_MUSTANG69_HOOD_LOCK_BRINPUT_ID                   (INPUT_NUMBER(12)) //статус замка капота
#define FORD_MUSTANG69_HAND_BREAK_BRINPUT_ID                  (INPUT_NUMBER(13))
#define FORD_MUSTANG69_FUEL_CAP_BRINPUT_ID                    (INPUT_NUMBER(14))

//Nissan Leaf Yandex
#define NISSAN_LEAF_HOOD_DOOR_INPUT_POLARITY                  (ACTIVE_0)
#define NISSAN_LEAF_HOOD_DOOR_INPUT_ID                        (INPUT_NUMBER(3))

#define NISSAN_LEAF_CHARGE_CAP_INPUT_POLARITY                 (ACTIVE_0)
#define NISSAN_LEAF_CHARGE_CAP_INPUT_ID                       (INPUT_NUMBER(2))

#define NISSAN_LEAF_ECO_KEY_OUTPUT_ID                         (OUTPUT_NUMBER(1))
#define NISSAN_LEAF_START_STOP_BUTTON_OUTPUT_ID               (OUTPUT_NUMBER(2))
#define NISSAN_LEAF_HORN_OUTPUT_ID                            (OUTPUT_NUMBER(3))
#define NISSAN_LEAF_KEY_POWER_OUTPUT_ID                       (OUTPUT_NUMBER(4))
#define NISSAN_LEAF_WINDOWS_OUTPUT_ID                         (OUTPUT_NUMBER(5))
#define NISSAN_LEAF_HOOD_UNLOCK_OUTPUT_ID                     (OUTPUT_NUMBER(6))
//
#define NISSAN_LEAF_HOOD_LOCK_OUTPUT_ID                       (OUTPUT_NUMBER(8))
#define NISSAN_LEAF_EMERG_LIGHT_OUTPUT_ID                     (OUTPUT_NUMBER(9))
#define NISSAN_LEAF_CLS_LOCK_OUTPUT_ID                        (OUTPUT_NUMBER(10))
#define NISSAN_LEAF_CLS_UNLOCK_OUTPUT_ID                      (OUTPUT_NUMBER(11))
#define NISSAN_LEAF_CHARGE_UNLOCK_OUTPUT_ID                   (OUTPUT_NUMBER(12))
#define NISSAN_LEAF_CHARGE_LOCK_OUTPUT_ID                     (NISSAN_LEAF_CHARGE_UNLOCK_OUTPUT_ID)
//#define NISSAN_LEAF_WIRED_BLOCKING_RELAY_OUTPUT_ID          (OUTPUT_NUMBER())
#define NISSAN_LEAF_WIRELESS_BLOCKING_RELAY_OUTPUT_ID         (0xFF)

//Toyota RAV4
#define TOYOTA_RAV4_START_STOP_BUTTON_OUTPUT_ID               (OUTPUT_NUMBER(1))
#define TOYOTA_RAV4_PEADAL_BREAK_OUTPUT_ID                    (OUTPUT_NUMBER(2))
#define TOYOTA_RAV4_HORN_OUTPUT_ID                            (OUTPUT_NUMBER(3))
#define TOYOTA_RAV4_WIRED_BLOCKING_RELAY_OUTPUT_ID            (OUTPUT_NUMBER(4))
#define TOYOTA_RAV4_HOOD_UNLOCK_OUTPUT_ID                     (OUTPUT_NUMBER(6))
#define TOYOTA_RAV4_HOOD_LOCK_OUTPUT_ID                       (OUTPUT_NUMBER(8))
#define TOYOTA_RAV4_KEY_POWER_OUTPUT_ID                       (OUTPUT_NUMBER(10))
#define TOYOTA_RAV4_WIRELESS_BLOCKING_RELAY_OUTPUT_ID         (0xFF)

//Hyunday Sonata Беспилотники
#define HYUNDAI_SONATA_SD_START_STOP_BUTTON_OUTPUT_ID         (OUTPUT_NUMBER(2))
#define HYUNDAI_SONATA_SD_PEADAL_BREAK_OUTPUT_ID              (OUTPUT_NUMBER(7))
#define HYUNDAI_SONATA_SD_KEY_POWER_OUTPUT_ID                 (OUTPUT_NUMBER(9))
//#define HYUNDAI_SONATA_SD_WIRELESS_BLOCKING_RELAY_OUTPUT_ID  (0xFF)

//Renault Logan 2013
#define RENAULT_LOGAN_2013_IGNITION_OUTPUT_ID                 (OUTPUT_NUMBER(1))
//#define RENAULT_LOGAN_2013_STARTER_OUTPUT_ID                (OUTPUT_NUMBER(2))
#define RENAULT_LOGAN_2013_HORN_OUTPUT_ID                     (OUTPUT_NUMBER(3))
#define RENAULT_LOGAN_2013_WIRED_BLOCKING_RELAY_OUTPUT_ID     (OUTPUT_NUMBER(4))
#define RENAULT_LOGAN_2013_WINDOWS_OUTPUT_ID                  (OUTPUT_NUMBER(5))
#define RENAULT_LOGAN_2013_HOOD_LOCK_OUTPUT_ID                (OUTPUT_NUMBER(6))
//#define RENAULT_LOGAN_2013_DRIVER_DOOR_EMULATION_OUTPUT_ID  (OUTPUT_NUMBER(7))
#define RENAULT_LOGAN_2013_HOOD_UNLOCK_OUTPUT_ID              (OUTPUT_NUMBER(8))

#define RENAULT_LOGAN_2013_WIRELESS_BLOCKING_RELAY_OUTPUT_ID  (0xFF)

//Renault Duster 2021
#define RENAULT_DUSTER_2021_IGNITION_OUTPUT_ID                (OUTPUT_NUMBER(1))
#define RENAULT_DUSTER_2021_STARTER_OUTPUT_ID                 (OUTPUT_NUMBER(2))
#define RENAULT_DUSTER_2021_HORN_OUTPUT_ID                    (OUTPUT_NUMBER(3))
#define RENAULT_DUSTER_2021_WIRED_BLOCKING_RELAY_OUTPUT_ID    (OUTPUT_NUMBER(4))
#define RENAULT_DUSTER_2021_WINDOWS_OUTPUT_ID                 (OUTPUT_NUMBER(5))
#define RENAULT_DUSTER_2021_HOOD_LOCK_OUTPUT_ID               (OUTPUT_NUMBER(6))
//#define RENAULT_DUSTER_2021_DRIVER_DOOR_EMULATION_OUTPUT_ID (OUTPUT_NUMBER(7))
#define RENAULT_DUSTER_2021_HOOD_UNLOCK_OUTPUT_ID             (OUTPUT_NUMBER(8))

#define RENAULT_DUSTER_2021_WIRELESS_BLOCKING_RELAY_OUTPUT_ID (0xFF)

//Jeep Wrangler 2018
#define JEEP_WRANGLER_2018_ROOF_INPUT_ID                      (INPUT_NUMBER(3)) //������ �����

#define JEEP_WRANGLER_2018_START_STOP_BUTTON_OUTPUT_ID        (OUTPUT_NUMBER(1)) //2 ���� ������ ��� ��������� ���������/ 1 ��� ��� ����������
#define JEEP_WRANGLER_2018_REMOTE_KEY_OUTPUT_ID               (OUTPUT_NUMBER(2)) //������ �� ������, ������� ������� - �������, ��������� - ���������
#define JEEP_WRANGLER_2018_HORN_OUTPUT_ID                     (OUTPUT_NUMBER(3))
#define JEEP_WRANGLER_2018_WIRED_BLOCKING_RELAY_OUTPUT_ID     (OUTPUT_NUMBER(4))
#define JEEP_WRANGLER_2018_WINDOWS_OUTPUT_ID                  (OUTPUT_NUMBER(5)) //������� 1 ���
#define JEEP_WRANGLER_2018_HOOD_LOCK_OUTPUT_ID                (OUTPUT_NUMBER(6))
//#define JEEP_WRANGLER_2018_DRIVER_DOOR_EMULATION_OUTPUT_ID  (OUTPUT_NUMBER(7))
#define JEEP_WRANGLER_2018_HOOD_UNLOCK_OUTPUT_ID              (OUTPUT_NUMBER(8))
#define JEEP_WRANGLER_2018_KEY_POWER_OUTPUT_ID                (OUTPUT_NUMBER(9))
#define JEEP_WRANGLER_2018_EMERG_LIGHT_OUTPUT_ID              (OUTPUT_NUMBER(10)) //пока держим минус - моргает

#define JEEP_WRANGLER_2018_WIRELESS_BLOCKING_RELAY_OUTPUT_ID  (0xFF)

//Audi A6 2018
#define AUDI_A6_2018_START_STOP_BUTTON_OUTPUT_ID              (OUTPUT_NUMBER(1))
#define AUDI_A6_2018_PEADAL_BREAK_OUTPUT_ID                   (OUTPUT_NUMBER(2))
#define AUDI_A6_2018_HORN_OUTPUT_ID                           (OUTPUT_NUMBER(3))
#define AUDI_A6_2018_WIRED_BLOCKING_RELAY_OUTPUT_ID           (OUTPUT_NUMBER(4))
#define AUDI_A6_2018_HOOD_LOCK_OUTPUT_ID                      (OUTPUT_NUMBER(6))
//
#define AUDI_A6_2018_HOOD_UNLOCK_OUTPUT_ID                    (OUTPUT_NUMBER(8))
#define AUDI_A6_2018_KEY_POWER_OUTPUT_ID                      (OUTPUT_NUMBER(9))
//
#define AUDI_A6_2018_WIRELESS_BLOCKING_RELAY_OUTPUT_ID        (0xFF)

//Renault Arkana 18
#define RENAULT_ARKANA_2018_HOOD_INPUT_ID                     (INPUT_NUMBER(2)) //����� ����� ������

#define RENAULT_ARKANA_2018_PEADAL_BREAK_OUTPUT_ID            (OUTPUT_NUMBER(1))
#define RENAULT_ARKANA_2018_START_STOP_BUTTON_OUTPUT_ID       (OUTPUT_NUMBER(2))
#define RENAULT_ARKANA_2018_HORN_OUTPUT_ID                    (OUTPUT_NUMBER(3))
#define RENAULT_ARKANA_2018_WIRED_BLOCKING_RELAY_OUTPUT_ID    (OUTPUT_NUMBER(4))
#define RENAULT_ARKANA_2018_WINDOWS_OUTPUT_ID                 (OUTPUT_NUMBER(5))
#define RENAULT_ARKANA_2018_HOOD_LOCK_OUTPUT_ID               (OUTPUT_NUMBER(6))
//#define RENAULT_ARKANA_2018_DRIVER_DOOR_EMULATION_OUTPUT_ID (OUTPUT_NUMBER(7))
#define RENAULT_ARKANA_2018_HOOD_UNLOCK_OUTPUT_ID             (OUTPUT_NUMBER(8))
//#define RENAULT_ARKANA_2018_EMERG_LIGHT_OUTPUT_ID           (OUTPUT_NUMBER(9))
#define RENAULT_ARKANA_2018_KEY_POWER_OUTPUT_ID               (OUTPUT_NUMBER(10))
#define RENAULT_ARKANA_2018_WIRELESS_BLOCKING_RELAY_OUTPUT_ID (0xFF)

#endif //__OUTPUTS_DEFINES_H