/**
******************************************************************************
* File Name          : signalman_can_subtask.h
* Description        : 
*                      
*                      
******************************************************************************
*/

/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __SIGNALMAN_CAN_SUBTASK_H
#define __SIGNALMAN_CAN_SUBTASK_H

/* Includes ------------------------------------------------------------------*/
#include <stdint.h>
#include "System\system.h"
#include "serv_protocols_lib/server_notifies.h"
#include "can_signals/vega_can_typedefs.h"
#include "can_hw_config.h"

typedef can_rx_frame_t can_rx_t;

typedef struct
{
  const char* name;
  can_rx_t rx[CAN_RX_QUEUE_LEN];
  uint16_t in_idx;
  uint16_t out_idx;
  uint16_t idx_mask;
  uint32_t drop_counter;
  uint8_t is_full; //fifo заполненно и были потерянны данные
}can_rx_sfifo_t;

typedef stm_can_filter_t can_filter_t;

typedef enum
{
  UNLOCKED_CLS_STATE=0,
  LOCKED_CLS_STATE=1,
  UNKNOWN_CLS_STATE=2,
}cls_state_t;

typedef enum
{
  IN_LEASE_STATE            = 0,
  IN_END_LEASE_STATE        = 1,
  IN_FORCED_END_LEASE_STATE = 2,
  UNKNOWN_LEASE_STATE       = 255,
}lease_state_t;

#define CAN_SUBTASK_COMMAND_IS_BUSY           0
#define CAN_SUBTASK_COMMAND_START_PROCCES     1
#define CAN_SUBTASK_COMMAND_UNKNOWN_ARG       2

#define INVALID_FUEL_LEVEL_PERCENT            ((uint8_t)255)

inline void notify_logging(uint8_t server_notify_id, uint32_t uid, notify_state_t notify_state, const char* res_str, bool add_res)
{
  const char* notify_state_str="";
  
  if(server_notify_id==0xFF) return;//add_res=true;
  if(res_str==NULL) res_str="null";
  
  if(notify_state==IN_PROCESS_NOTIFY_STATE)        notify_state_str="in progress";
  else if(notify_state==IS_LAST_NOTIFY_STATE)      notify_state_str="last";
  else if(notify_state==IS_BUSY_NOTIFY_STATE)      notify_state_str="busy";
  else if(notify_state==UNKNOWN_ARGS_NOTIFY_STATE) notify_state_str="unknown args";
  else if(notify_state==ERROR_NOTIFY_STATE)        notify_state_str="error";
  
  LOG("sid: %hhu, uid: %lX, %s /%s/%s\n", server_notify_id, uid, res_str, notify_state_str, (add_res)?(""):(" (notify add failed)"));
}

void can_subtask_onetime_init(void);
void can_subtask_init(void);
void can_subtask_main_cycle(void);
void can_subtask_deinit(void);
bool can_subtask_is_sleep_allowed(void);

uint8_t signalman_can_subtask_commnad_handle(const uint8_t cmd, const uint8_t server_notify_id, const uint32_t uid, const uint8_t nonce[8], const void* ext_args);
void auto_hood_unlock_watchdog(void);
void engine_stop_watchdog(void);
void startstop_off_watchdog(bool is_force_stop_and_deinit);
void async_analog_windows_closing_watchdog(bool is_force_stop_and_deinit);
void delayed_windows_closing_handler(void);
void async_key_power_off_watchdog(bool is_force_off_and_deinit);
void forced_eco_on_handler(void);
void engine_stop_by_xxx_handler(void);
void wakeup_electric_car_on_charge_handler(void);
void guard_handler(void);
void antitheft_handler(void);
void antitheft2_handler(void);
bool is_horn_alarm_active(void);
bool is_can_horn_alarm_active(void);

void check_fuel_level_watchdog();

#endif //__SIGNALMAN_CAN_SUBTASK_H
