param (
    [Parameter(Mandatory=$true)]
    [string]
    $BinaryDirectory
)

$ArcadiaRoot = (Get-Item $PSScriptRoot).Parent.Parent.Parent.Parent
$BuildRoot = "$ArcadiaRoot/drive/vega/.build"

ya make "$ArcadiaRoot/drive/vega/utils/bin_to_vbf" -o "$BuildRoot"
cp "$PSScriptRoot/encrypt_and_sign.cfg" "$BuildRoot/" -Force
cp "$ArcadiaRoot/drive/vega/utils/bin_to_vbf/bin_to_vbf.exe" "$BuildRoot/" -Force
cp "$BinaryDirectory/*" "$BuildRoot/" -Force
Start-Process "$BuildRoot/bin_to_vbf.exe" -WorkingDirectory $BuildRoot -Wait -NoNewWindow
$files = Get-ChildItem $BuildRoot
foreach ($file in $files) {
    if (!$file.Name.Contains("VEGA MT")) {
        continue
    }
    if ($file.Name.Endswith(".vbf")) {
        continue
    }
    mv $file.FullName ($file.FullName + ".vbf") -Force
}
