#!/usr/bin/env python
# -*- coding: utf-8 -*-


from .utils import ALL_YANDEX_ZONES, permanent 


from requests.utils import requote_uri


PATH_PAIRS = [
  ("catalog/Великий Новгород", "veliky-novgorod"),
  ("catalog/Витебск", "vitebsk"),
  ("catalog/Екатеринбург", "yekaterinburg"),
  ("catalog/Краснодар", "krasnodar"),
  ("catalog/Москва", "moscow"),
  ("catalog/Новосибирск", "novosibirsk"),
  ("catalog/Ростов-на-Дону", "rostov-on-don"),
  ("catalog/Санкт-Петербург", "saint-petersburg"),
  ("catalog/Тверь", "tver"),
  ("catalog/Челябинск", "chelyabinsk"),
  ("Абакан", "abakan"),
  ("Абакан/Ачинск", "abakan--achinsk"),
  ("Абакан/Красноярск", "abakan--krasnoyarsk"),
  ("Абакан/Кызыл", "abakan--kyzyl"),
  ("Абакан/Шушенское", "abakan--shushenskoe"),
  ("Агидель/Нефтекамск", "agidel--nephtekamsk"),
  ("Александровск", "aleksandrovsk"),
  ("Алушта", "alushta"),
  ("Алушта/Воронеж", "voronezh--moscow"),
  ("Алушта/Москва", "alushta--moscow"),
  ("Альметьевск/Казань", "almetyevsk--kazan"),
  ("Альметьевск/Тольятти", "almetyevsk--togliatti"),
  ("Анапа", "anapa"),
  ("Анапа/Краснодар", "anapa--krasnodar"),
  ("Анапа/Москва", "anapa--moscow"),
  ("Анапа/Севастополь", "anapa--sevastopol"),
  ("Анапа/Симферополь", "anapa--simferopol"),
  ("Анапа/Феодосия", "anapa--feodosia"),
  ("Арзамас/Дивеево", "arzamas--diveevo"),
  ("Арзамас/Москва", "arzamas--moscow"),
  ("Арзамас/Саратов", "arzamas--saratov"),
  ("Армавир", "armavir-ru"),
  ("Архангельск", "arhangelsk"),
  ("Архангельск/Вельск", "arhangelsk--velsk"),
  ("Архангельск/Вологда", "arhangelsk--vologda"),
  ("Архангельск/Котлас", "arhangelsk--kotlas"),
  ("Архангельск/Северодвинск", "arhangelsk--severodvinsk"),
  ("Архипо-Осиповка", "arkhipo-osipovka"),
  ("Архыз", "arkhyz-ru"),
  ("Архыз/Ставрополь", "arkhyz-ru--stavropol"),
  ("Астрахань", "astrahan"),
  ("Астрахань/Волгоград", "astrahan--volgograd"),
  ("Астрахань/Краснодар", "astrahan--krasnodar"),
  ("Астрахань/Минеральные Воды", "astrahan--mineralniye-vodi"),
  ("Астрахань/Москва", "astrahan--moscow"),
  ("Астрахань/Ростов-на-Дону", "astrahan--rostov-on-don"),
  ("Астрахань/Симферополь", "astrahan--simferopol"),
  ("Астрахань/Сочи", "astrahan--sochi"),
  ("Астрахань/Ставрополь", "astrahan--stavropol"),
  ("Астрахань/Ялта", "astrahan--yalta"),
  ("Ахтубинск", "ahtubinsk"),
  ("Ахтубинск/Астрахань", "ahtubinsk--astrahan"),
  ("Ахтубинск/Волгоград", "ahtubinsk--volgograd"),
  ("Ачинск", "achinsk"),
  ("Ачинск/Боготол", "achinsk--bogotol"),
  ("Ачинск/Кемерово", "achinsk--kemerovo"),
  ("Ачинск/Красноярск", "achinsk--krasnoyarsk"),
  ("Ачинск/Ужур", "achinsk--ujur"),
  ("Балаково", "balakovo"),
  ("Балаково/Москва", "balakovo--moscow"),
  ("Балаково/Самара", "balakovo--samara"),
  ("Балаково/Ульяновск", "balakovo--ulyanovsk"),
  ("Балаково/Хвалынск", "balakovo--hvalynsk"),
  ("Барнаул", "barnaul"),
  ("Барнаул/Белокуриха", "barnaul--belokurikha"),
  ("Барнаул/Бийск", "barnaul--biysk"),
  ("Барнаул/Благовещенка", "barnaul--blagoveshchenka"),
  ("Барнаул/Горно-Алтайск", "barnaul--gorno-altaysk"),
  ("Барнаул/Завьялово", "barnaul--zavjyalovo-altai-krai"),
  ("Барнаул/Камень-на-Оби", "barnaul--kamen-na-obi"),
  ("Барнаул/Кемерово", "barnaul--kemerovo"),
  ("Барнаул/Кулунда", "barnaul--kulunda"),
  ("Барнаул/Кытманово", "barnaul--kitmanivo"),
  ("Барнаул/Новокузнецк", "barnaul--novokuznetsk"),
  ("Барнаул/Новосибирск", "barnaul--novosibirsk"),
  ("Барнаул/Поспелиха", "barnaul--pospeliha"),
  ("Барнаул/Родино", "barnaul--rodino"),
  ("Барнаул/Рубцовск", "barnaul--rubtsovsk"),
  ("Барнаул/Славгород", "barnaul--slavgorod-ru"),
  ("Барнаул/Томск", "barnaul--tomsk"),
  ("Барнаул/Усть-Калманка", "barnaul--ust-kalmanka"),
  ("Барнаул/Чемал", "barnaul--chemal"),
  ("Белгород", "belgorod"),
  ("Белгород/Воронеж", "belgorod--voronezh"),
  ("Белгород/Краснодар", "belgorod--krasnodar"),
  ("Белгород/Курск", "belgorod--kursk"),
  ("Белгород/Москва", "belgorod--moscow"),
  ("Белгород/Орёл", "belgorod--orel"),
  ("Белгород/Россошь", "belgorod--rossosh"),
  ("Белгород/Ростов-на-Дону", "belgorod--rostov-on-don"),
  ("Белгород/Симферополь", "belgorod--simferopol"),
  ("Белгород/Старый Оскол", "belgorod--stariy-oskol"),
  ("Белокуриха", "belokurikha"),
  ("Белокуриха/Барнаул", "belokurikha--barnaul"),
  ("Белокуриха/Бийск", "belokurikha--biysk"),
  ("Белокуриха/Новокузнецк", "belokurikha--novokuznetsk"),
  ("Белокуриха/Новосибирск", "belokurikha--novosibirsk"),
  ("Березники/Пермь", "berezniki-perm-district--perm"),
  ("Бийск", "biysk"),
  ("Бийск/Барнаул", "biysk--barnaul"),
  ("Бийск/Новокузнецк", "biysk--novokuznetsk"),
  ("Бийск/Новосибирск", "biysk--novosibirsk"),
  ("Бийск/Томск", "biysk--tomsk"),
  ("Бийск/Чемал", "biysk--chemal"),
  ("Бирск", "birsk"),
  ("Бирск/Уфа", "birsk--ufa"),
  ("Благовещенск/Свободный", "blagoveshchensk--svobodniy"),
  ("Богородицк/Москва", "bogoroditsk--moscow"),
  ("Брянск", "bryansk"),
  ("Брянск/Белгород", "bryansk--belgorod"),
  ("Брянск/Гомель", "bryansk--gomel"),
  ("Брянск/Климово", "bryansk--klimovo"),
  ("Брянск/Курск", "bryansk--kursk"),
  ("Брянск/Москва", "bryansk--moscow"),
  ("Брянск/Новозыбков", "bryansk--novozibkov"),
  ("Брянск/Смоленск", "bryansk--smolensk"),
  ("Брянск/Тула", "bryansk--tula"),
  ("Варшава/Брест", "warsaw--brest"),
  ("Великие Луки/Псков", "velikie-luky--pskov"),
  ("Великий Новгород", "veliky-novgorod"),
  ("Великий Новгород/Санкт-Петербург", "veliky-novgorod--saint-petersburg"),
  ("Великий Новгород/Старая Русса", "veliky-novgorod--staraya-russa"),
  ("Вильнюс/Минск", "vilnius--minsk"),
  ("Витебск/Москва", "vitebsk--moscow"),
  ("Владикавказ/Армавир", "vladikavkaz--armavir-ru"),
  ("Владикавказ/Волгоград", "vladikavkaz--volgograd"),
  ("Владикавказ/Махачкала", "vladikavkaz--makhachkala"),
  ("Владикавказ/Минеральные Воды", "vladikavkaz--mineralniye-vodi"),
  ("Владикавказ/Тбилиси", "vladikavkaz--tbilisi"),
  ("Владимир", "vladimir"),
  ("Владимир/Волгоград", "vladimir--volgograd"),
  ("Владимир/Иваново", "vladimir--ivanovo"),
  ("Владимир/Кострома", "vladimir--kostroma"),
  ("Владимир/Москва", "vladimir--moscow"),
  ("Владимир/Муром", "vladimir--murom"),
  ("Владимир/Нижний Новгород", "vladimir--nizhny-novgorod"),
  ("Владимир/Рязань", "vladimir--ryazan"),
  ("Владимир/Ярославль", "vladimir--yaroslavl"),
  ("Волгоград", "volgograd"),
  ("Волгоград/Астрахань", "volgograd--astrahan"),
  ("Волгоград/Ахтубинск", "volgograd--ahtubinsk"),
  ("Волгоград/Волгодонск", "volgograd--volgodonsk"),
  ("Волгоград/Воронеж", "volgograd--voronezh"),
  ("Волгоград/Камышин", "volgograd--kamishin"),
  ("Волгоград/Краснодар", "volgograd--krasnodar"),
  ("Волгоград/Михайловка", "volgograd--mihaylovka-volgograd-district"),
  ("Волгоград/Москва", "volgograd--moscow"),
  ("Волгоград/Нижний Новгород", "volgograd--nizhny-novgorod"),
  ("Волгоград/Пенза", "volgograd--penza"),
  ("Волгоград/Ростов-на-Дону", "volgograd--rostov-on-don"),
  ("Волгоград/Санкт-Петербург", "volgograd--saint-petersburg"),
  ("Волгоград/Саратов", "volgograd--saratov"),
  ("Волгоград/Ставрополь", "volgograd--stavropol"),
  ("Волгоград/Тамбов", "volgograd--tambov"),
  ("Волгоград/Элиста", "volgograd--elista"),
  ("Волгодонск/Курчатов", "volgodonsk--kurchatov"),
  ("Волгодонск/Москва", "volgodonsk--moscow"),
  ("Волжский/Москва", "volzhskiy--moscow"),
  ("Вологда", "vologda"),
  ("Вологда/Вытегра", "vologda--vytegra"),
  ("Вологда/Москва", "vologda--moscow"),
  ("Вологда/Нижний Новгород", "vologda--nizhny-novgorod"),
  ("Вологда/Петрозаводск", "vologda--petrozavodsk"),
  ("Вологда/Санкт-Петербург", "vologda--saint-petersburg"),
  ("Вологда/Череповец", "vologda--cherepovets"),
  ("Вологда/Ярославль", "vologda--yaroslavl"),
  ("Воронеж", "voronezh"),
  ("Воронеж/Белгород", "voronezh--belgorod"),
  ("Воронеж/Борисоглебск", "voronezh--borisoglebsk"),
  ("Воронеж/Волгоград", "voronezh--volgograd"),
  ("Воронеж/Домодедово", "voronezh--domodedovo"),
  ("Воронеж/Краснодар", "voronezh--krasnodar"),
  ("Воронеж/Москва", "voronezh--moscow"),
  ("Воронеж/Орёл", "voronezh--orel"),
  ("Воронеж/Ростов-на-Дону", "voronezh--rostov-on-don"),
  ("Воронеж/Саратов", "voronezh--saratov"),
  ("Воронеж/Ставрополь", "voronezh--stavropol"),
  ("Воронеж/Тамбов", "voronezh--tambov"),
  ("Воронеж/Тула", "voronezh--tula"),
  ("Воткинск", "votkinsk"),
  ("Вытегра/Санкт-Петербург", "vytegra--saint-petersburg"),
  ("Геленджик", "gelendgik"),
  ("Геленджик/Горячий Ключ", "gelendgik--goryachiy-kluch"),
  ("Геленджик/Оренбург", "gelendgik--orenburg"),
  ("Гомель/Варшава", "gomel--warsaw"),
  ("Гомель/Москва", "gomel--moscow"),
  ("Горно-Алтайск/Новосибирск", "gorno-altaysk--novosibirsk"),
  ("Грозный/Краснодар", "grozniy--krasnodar"),
  ("Гюмри", "gyumri"),
  ("Дятьково/Москва", "diatikovo--moscow"),
  ("Егорьевск/Москва", "egorievsk--moscow"),
  ("Екатеринбург", "yekaterinburg"),
  ("Екатеринбург/Березники", "yekaterinburg--berezniki-perm-district"),
  ("Екатеринбург/Большеустьикинское", "yekaterinburg--bolsheustjikinskoe"),
  ("Екатеринбург/Верхотурье", "yekaterinburg--verhoturie"),
  ("Екатеринбург/Ирбит", "yekaterinburg--irbit"),
  ("Екатеринбург/Каменск-Уральский", "yekaterinburg--kamensk-uralskiy"),
  ("Екатеринбург/Каргаполье", "yekaterinburg--kargapolje"),
  ("Екатеринбург/Качканар", "yekaterinburg--kachkanar"),
  ("Екатеринбург/Красноуральск", "yekaterinburg--krasnouralsk"),
  ("Екатеринбург/Курган", "yekaterinburg--kurgan"),
  ("Екатеринбург/Лесной", "yekaterinburg--lesnoy-sverdlov-district"),
  ("Екатеринбург/Магнитогорск", "yekaterinburg--magnitogorsk"),
  ("Екатеринбург/Миасс", "yekaterinburg--miass"),
  ("Екатеринбург/Новая Ляля", "yekaterinburg--novaya-lyalya"),
  ("Екатеринбург/Оренбург", "yekaterinburg--orenburg"),
  ("Екатеринбург/Пермь", "yekaterinburg--perm"),
  ("Екатеринбург/Реж", "yekaterinburg--rezh"),
  ("Екатеринбург/Североуральск", "yekaterinburg--severouralsk"),
  ("Екатеринбург/Серов", "yekaterinburg--serov"),
  ("Екатеринбург/Тавда", "yekaterinburg--tavda"),
  ("Екатеринбург/Тюмень", "yekaterinburg--tyumen"),
  ("Екатеринбург/Уфа", "yekaterinburg--ufa"),
  ("Екатеринбург/Челябинск", "yekaterinburg--chelyabinsk"),
  ("Екатеринбург/Чусовой", "yekaterinburg--chusovoy"),
  ("Екатеринбург/Янгантау", "yekaterinburg--yangantau"),
  ("Елец/Москва", "yelets--moscow"),
  ("Ереван", "yerevan"),
  ("Ереван/Тбилиси", "yerevan--tbilisi"),
  ("Ефремов/Москва", "efremov--moscow"),
  ("Ивангород/Санкт-Петербург", "ivangorod--saint-petersburg"),
  ("Иваново", "ivanovo"),
  ("Иваново/Владимир", "ivanovo--vladimir"),
  ("Иваново/Москва", "ivanovo--moscow"),
  ("Иваново/Нижний Новгород", "ivanovo--nizhny-novgorod"),
  ("Иваново/Ярославль", "ivanovo--yaroslavl"),
  ("Ижевск", "izhevsk"),
  ("Ижевск/Дзержинск", "izhevsk--dzerzhinsk-nizhny-novgorod-district"),
  ("Ижевск/Казань", "izhevsk--kazan"),
  ("Ижевск/Набережные Челны", "izhevsk--naberezhnie-chelny"),
  ("Ижевск/Нефтекамск", "izhevsk--nephtekamsk"),
  ("Ижевск/Пермь", "izhevsk--perm"),
  ("Ижевск/Самара", "izhevsk--samara"),
  ("Ижевск/Уфа", "izhevsk--ufa"),
  ("Иркутск", "irkutsk"),
  ("Иркутск/Братск", "irkutsk--bratsk"),
  ("Иркутск/Саянск", "irkutsk--sayansk"),
  ("Иркутск/Тулун", "irkutsk--tulun"),
  ("Иркутск/Усть-Илимск", "irkutsk--ust-ilimsk"),
  ("Иркутск/Усть-Кут", "irkutsk--ust-kut"),
  ("Казань", "kazan"),
  ("Казань/Альметьевск", "kazan--almetyevsk"),
  ("Казань/Бугульма", "kazan--bugulma"),
  ("Казань/Ижевск", "kazan--izhevsk"),
  ("Казань/Йошкар-Ола", "kazan--yoshkar-ola"),
  ("Казань/Киров", "kazan--kirov"),
  ("Казань/Москва", "kazan--moscow"),
  ("Казань/Набережные Челны", "kazan--naberezhnie-chelny"),
  ("Казань/Нижнекамск", "kazan--nizhnekamsk"),
  ("Казань/Нижний Новгород", "kazan--nizhny-novgorod"),
  ("Казань/Нурлат", "kazan--nurlat"),
  ("Казань/Оренбург", "kazan--orenburg"),
  ("Казань/Пермь", "kazan--perm"),
  ("Казань/Салават", "kazan--salavat"),
  ("Казань/Самара", "kazan--samara"),
  ("Казань/Санкт-Петербург", "kazan--saint-petersburg"),
  ("Казань/Стерлитамак", "kazan--sterlitamak"),
  ("Казань/Тольятти", "kazan--togliatti"),
  ("Казань/Туймазы", "kazan--tuymazy"),
  ("Казань/Ульяновск", "kazan--ulyanovsk"),
  ("Казань/Уфа", "kazan--ufa"),
  ("Казань/Челябинск", "kazan--chelyabinsk"),
  ("Калининград", "kaliningrad"),
  ("Калининград/Варшава", "kaliningrad--warsaw"),
  ("Калининград/Рига", "kaliningrad--riga"),
  ("Калининград/Советск", "kaliningrad--sovetsk-kaliningrad-district"),
  ("Калуга/Москва", "kaluga--moscow"),
  ("Калязин/Москва", "kalyazin--moscow"),
  ("Камышин/Волгоград", "kamishin--volgograd"),
  ("Карпинск/Екатеринбург", "karpinsk--yekaterinburg"),
  ("Кемерово/Новокузнецк", "kemerovo--novokuznetsk"),
  ("Кемерово/Новосибирск", "kemerovo--novosibirsk"),
  ("Керчь/Краснодар", "kerch--krasnodar"),
  ("Керчь/Москва", "kerch--moscow"),
  ("Керчь/Ростов-на-Дону", "kerch--rostov-on-don"),
  ("Киржач/Москва", "kirzach--moscow"),
  ("Киров/Йошкар-Ола", "kirov--yoshkar-ola"),
  ("Когалым", "kogalym"),
  ("Когалым/Сургут", "kogalym--surgut-khanty-mansi-autonomous-okrug"),
  ("Краснодар", "krasnodar"),
  ("Краснодар/Алушта", "krasnodar--alushta"),
  ("Краснодар/Анапа", "krasnodar--anapa"),
  ("Краснодар/Астрахань", "krasnodar--astrahan"),
  ("Краснодар/Воронеж", "krasnodar--voronezh"),
  ("Краснодар/Геленджик", "krasnodar--gelendgik"),
  ("Краснодар/Керчь", "krasnodar--kerch"),
  ("Краснодар/Москва", "krasnodar--moscow"),
  ("Краснодар/Новороссийск", "krasnodar--novorossiysk"),
  ("Краснодар/Пятигорск", "krasnodar--pyatigorsk"),
  ("Краснодар/Ростов-на-Дону", "krasnodar--rostov-on-don"),
  ("Краснодар/Севастополь", "krasnodar--sevastopol"),
  ("Краснодар/Симферополь", "krasnodar--simferopol"),
  ("Краснодар/Сочи", "krasnodar--sochi"),
  ("Краснодар/Ставрополь", "krasnodar--stavropol"),
  ("Краснодар/Феодосия", "krasnodar--feodosia"),
  ("Краснодар/Ялта", "krasnodar--yalta"),
  ("Красноярск", "krasnoyarsk"),
  ("Красноярск/Абакан", "krasnoyarsk--abakan"),
  ("Красноярск/Абан", "krasnoyarsk--aban"),
  ("Красноярск/Ачинск", "krasnoyarsk--achinsk"),
  ("Красноярск/Балахта", "krasnoyarsk--balakhta"),
  ("Красноярск/Боготол", "krasnoyarsk--bogotol"),
  ("Красноярск/Братск", "krasnoyarsk--bratsk"),
  ("Красноярск/Ирбейское", "krasnoyarsk--irbeyskoe"),
  ("Красноярск/Канск", "krasnoyarsk--kansk"),
  ("Красноярск/Кемерово", "krasnoyarsk--kemerovo"),
  ("Красноярск/Кызыл", "krasnoyarsk--kyzyl"),
  ("Красноярск/Лесосибирск", "krasnoyarsk--lesosibirsk"),
  ("Красноярск/Минусинск", "krasnoyarsk--minusinsk"),
  ("Красноярск/Назарово", "krasnoyarsk--nazarovo-krasnoyarsk-krai"),
  ("Красноярск/Новобирилюссы", "krasnoyarsk--novobirilyussi"),
  ("Красноярск/Новокузнецк", "krasnoyarsk--novokuznetsk"),
  ("Красноярск/Саяногорск", "krasnoyarsk--sayanogorsk"),
  ("Красноярск/Томск", "krasnoyarsk--tomsk"),
  ("Красноярск/Тяжинский", "krasnoyarsk--tyazginskiy"),
  ("Красноярск/Ужур", "krasnoyarsk--ujur"),
  ("Красноярск/Черногорск", "krasnoyarsk--chernogorsk"),
  ("Красноярск/Шарыпово", "krasnoyarsk--sharypovo"),
  ("Красноярск/Шира", "krasnoyarsk--shira"),
  ("Красноярск/Шушенское", "krasnoyarsk--shushenskoe"),
  ("Кумертау", "kumertau"),
  ("Курган", "kurgan"),
  ("Курган/Екатеринбург", "kurgan--yekaterinburg"),
  ("Курган/Сургут", "kurgan--surgut-khanty-mansi-autonomous-okrug"),
  ("Курган/Тобольск", "kurgan--tobolsk"),
  ("Курган/Тюмень", "kurgan--tyumen"),
  ("Курган/Челябинск", "kurgan--chelyabinsk"),
  ("Курск", "kursk"),
  ("Курск/Брянск", "kursk--bryansk"),
  ("Курск/Воронеж", "kursk--voronezh"),
  ("Курск/Москва", "kursk--moscow"),
  ("Курск/Симферополь", "kursk--simferopol"),
  ("Курчатов/Волгодонск", "kurchatov--volgodonsk"),
  ("Кызыл", "kyzyl"),
  ("Кызыл/Красноярск", "kyzyl--krasnoyarsk"),
  ("Липецк/Москва", "lipetsk--moscow"),
  ("Лодейное Поле/Санкт-Петербург", "lodeynoe-pole--saint-petersburg"),
  ("Магнитогорск", "magnitogorsk"),
  ("Магнитогорск/Екатеринбург", "magnitogorsk--yekaterinburg"),
  ("Магнитогорск/Орск", "magnitogorsk--orsk"),
  ("Магнитогорск/Уфа", "magnitogorsk--ufa"),
  ("Магнитогорск/Челябинск", "magnitogorsk--chelyabinsk"),
  ("Майкоп/Москва", "maykop--moscow"),
  ("Махачкала/Москва", "makhachkala--moscow"),
  ("Миасс/Челябинск", "miass--chelyabinsk"),
  ("Минеральные Воды/Анапа", "mineralniye-vodi--anapa"),
  ("Минеральные Воды/Архыз", "mineralniye-vodi--arkhyz-ru"),
  ("Минеральные Воды/Владикавказ", "mineralniye-vodi--vladikavkaz"),
  ("Минеральные Воды/Краснодар", "mineralniye-vodi--krasnodar"),
  ("Минеральные Воды/Махачкала", "mineralniye-vodi--makhachkala"),
  ("Минеральные Воды/Симферополь", "mineralniye-vodi--simferopol"),
  ("Минеральные Воды/Ставрополь", "mineralniye-vodi--stavropol"),
  ("Минск/Варшава", "minsk--warsaw"),
  ("Минск/Вильнюс", "minsk--vilnius"),
  ("Минск/Витебск", "minsk--vitebsk"),
  ("Минск/Гомель", "minsk--gomel"),
  ("Минск/Гродно", "minsk--grodno"),
  ("Минск/Москва", "minsk--moscow"),
  ("Минск/Рига", "minsk--riga"),
  ("Минск/Санкт-Петербург", "minsk--saint-petersburg"),
  ("Минусинск/Красноярск", "minusinsk--krasnoyarsk"),
  ("Мончегорск", "monchegorsk"),
  ("Москва", "moscow"),
  ("Москва/Алексин", "moscow--aleksin"),
  ("Москва/Алушта", "moscow--alushta"),
  ("Москва/Анапа", "moscow--anapa"),
  ("Москва/Армавир", "moscow--armavir-ru"),
  ("Москва/Астрахань", "moscow--astrahan"),
  ("Москва/Балаково", "moscow--balakovo"),
  ("Москва/Балашов", "moscow--balashev"),
  ("Москва/Белая Калитва", "moscow--belaya-kalitva"),
  ("Москва/Белгород", "moscow--belgorod"),
  ("Москва/Белёв", "moscow--belyov"),
  ("Москва/Бобруйск", "moscow--bobruisk"),
  ("Москва/Богородицк", "moscow--bogoroditsk"),
  ("Москва/Богучар", "moscow--boguchar"),
  ("Москва/Борисоглебск", "moscow--borisoglebsk"),
  ("Москва/Бронницы", "moscow--bronnizi"),
  ("Москва/Брянск", "moscow--bryansk"),
  ("Москва/Валуйки", "moscow--valuyki"),
  ("Москва/Варшава", "moscow--warsaw"),
  ("Москва/Великие Луки", "moscow--velikie-luky"),
  ("Москва/Великий Новгород", "moscow--veliky-novgorod"),
  ("Москва/Верея", "moscow--vereya-moscow-and-moscow-region-c24453"),
  ("Москва/Витебск", "moscow--vitebsk"),
  ("Москва/Владикавказ", "moscow--vladikavkaz"),
  ("Москва/Владимир", "moscow--vladimir"),
  ("Москва/Волгоград", "moscow--volgograd"),
  ("Москва/Волгодонск", "moscow--volgodonsk"),
  ("Москва/Волжский", "moscow--volzhskiy"),
  ("Москва/Вологда", "moscow--vologda"),
  ("Москва/Волоколамск", "moscow--volokolamsk"),
  ("Москва/Вольск", "moscow--volsk"),
  ("Москва/Воронеж", "moscow--voronezh"),
  ("Москва/Выкса", "moscow--vyksa"),
  ("Москва/Вязьма", "moscow--vyazma"),
  ("Москва/Гомель", "moscow--gomel"),
  ("Москва/Грозный", "moscow--grozniy"),
  ("Москва/Гуково", "moscow--gukovo"),
  ("Москва/Даниловка", "moscow--danilovka"),
  ("Москва/Данков", "moscow--dankov"),
  ("Москва/Дербент", "moscow--derbent"),
  ("Москва/Дивеево", "moscow--diveevo"),
  ("Москва/Донецк", "moscow--donetsk"),
  ("Москва/Дятьково", "moscow--diatikovo"),
  ("Москва/Егорьевск", "moscow--egorievsk"),
  ("Москва/Ейск", "moscow--yesk"),
  ("Москва/Елец", "moscow--yelets"),
  ("Москва/Ельня", "moscow--elnya-smolensk-district"),
  ("Москва/Ефремов", "moscow--efremov"),
  ("Москва/Жирновск", "moscow--zhirnovsk"),
  ("Москва/Зверево", "moscow--zverevo"),
  ("Москва/Зубцов", "moscow--zubtsov"),
  ("Москва/Иваново", "moscow--ivanovo"),
  ("Москва/Йошкар-Ола", "moscow--yoshkar-ola"),
  ("Москва/Казань", "moscow--kazan"),
  ("Москва/Калуга", "moscow--kaluga"),
  ("Москва/Калязин", "moscow--kalyazin"),
  ("Москва/Каменск-Шахтинский", "moscow--kamensk-shakhtinsky"),
  ("Москва/Камышин", "moscow--kamishin"),
  ("Москва/Касимов", "moscow--kasimov"),
  ("Москва/Кашин", "moscow--kashin"),
  ("Москва/Керчь", "moscow--kerch"),
  ("Москва/Киев", "moscow--kiev"),
  ("Москва/Кимовск", "moscow--kimovsk"),
  ("Москва/Кинешма", "moscow--kineshma"),
  ("Москва/Кисловодск", "moscow--kislovodsk"),
  ("Москва/Кишинев", "moscow--kishinev"),
  ("Москва/Ковров", "moscow--kovrov"),
  ("Москва/Коломна", "moscow--kolomna"),
  ("Москва/Кольчугино", "moscow--kolchugino"),
  ("Москва/Константиновск", "moscow--konstantinovsk"),
  ("Москва/Кострома", "moscow--kostroma"),
  ("Москва/Краснодар", "moscow--krasnodar"),
  ("Москва/Красный Сулин", "moscow--krasny-sulin"),
  ("Москва/Кропоткин", "moscow--kropotkin"),
  ("Москва/Кузнецк", "moscow--kuznetsk"),
  ("Москва/Курск", "moscow--kursk"),
  ("Москва/Лебедянь", "moscow--lebedyan"),
  ("Москва/Левокумское", "moscow--levokumskoe"),
  ("Москва/Ливны", "moscow--livny"),
  ("Москва/Липецк", "moscow--lipetsk"),
  ("Москва/Лотошино", "moscow--lotoshino"),
  ("Москва/Луганск", "moscow--lugansk"),
  ("Москва/Луховицы", "moscow--luhovicy"),
  ("Москва/Людиново", "moscow--ljudinovo"),
  ("Москва/Майкоп", "moscow--maykop"),
  ("Москва/Махачкала", "moscow--makhachkala"),
  ("Москва/Миллерово", "moscow--millerovo"),
  ("Москва/Минеральные Воды", "moscow--mineralniye-vodi"),
  ("Москва/Минск", "moscow--minsk"),
  ("Москва/Мичуринск", "moscow--michurinsk"),
  ("Москва/Моршанск", "moscow--morshansk"),
  ("Москва/Мосальск", "moscow--mosalsk"),
  ("Москва/Муром", "moscow--murom"),
  ("Москва/Мценск", "moscow--mtsensk"),
  ("Москва/Навашино", "moscow--navashino"),
  ("Москва/Нальчик", "moscow--nalchik"),
  ("Москва/Нелидово", "moscow--nelidovo-tver-district"),
  ("Москва/Нижний Новгород", "moscow--nizhny-novgorod"),
  ("Москва/Новомичуринск", "moscow--novomichurinsk"),
  ("Москва/Новомосковск", "moscow--novomoskovsk-ru"),
  ("Москва/Новороссийск", "moscow--novorossiysk"),
  ("Москва/Новошахтинск", "moscow--novomichurinsk"),
  ("Москва/Оренбург", "moscow--orenburg"),
  ("Москва/Орёл", "moscow--orel"),
  ("Москва/Осташков", "moscow--ostashkov"),
  ("Москва/Павловск", "moscow--pavlovsk-voronezh-district"),
  ("Москва/Павловская", "moscow--pavlovskaya"),
  ("Москва/Пенза", "moscow--penza"),
  ("Москва/Переславль-Залесский", "moscow--pereslavl-zalesskiy"),
  ("Москва/Пермь", "moscow--perm"),
  ("Москва/Петровск", "moscow--petrovsk"),
  ("Москва/Плавск", "moscow--plavsk"),
  ("Москва/Поворино", "moscow--povorino"),
  ("Москва/Псков", "moscow--pskov"),
  ("Москва/Пятигорск", "moscow--pyatigorsk"),
  ("Москва/Рассказово", "moscow--rasskazovo"),
  ("Москва/Ржев", "moscow--rzhev"),
  ("Москва/Рига", "moscow--riga"),
  ("Москва/Ростов", "moscow--rostov"),
  ("Москва/Ростов-на-Дону", "moscow--rostov-on-don"),
  ("Москва/Рошаль", "moscow--roshal"),
  ("Москва/Рыбинск", "moscow--rybinsk"),
  ("Москва/Рязань", "moscow--ryazan"),
  ("Москва/Санкт-Петербург", "moscow--saint-petersburg"),
  ("Москва/Саранск", "moscow--saransk"),
  ("Москва/Саратов", "moscow--saratov"),
  ("Москва/Саров", "moscow--sarov"),
  ("Москва/Сафоново", "moscow--safonovo-smolensk-district"),
  ("Москва/Светлоград", "moscow--svetlograd"),
  ("Москва/Севастополь", "moscow--sevastopol"),
  ("Москва/Селижарово", "moscow--selizharovo"),
  ("Москва/Серпухов", "moscow--serpuhov"),
  ("Москва/Симферополь", "moscow--simferopol"),
  ("Москва/Скопин", "moscow--skopin"),
  ("Москва/Славянск-на-Кубани", "moscow--slavyansk-na-kubani"),
  ("Москва/Смоленск", "moscow--smolensk"),
  ("Москва/Спас-Клепики", "moscow--spas-klepiki"),
  ("Москва/Ставрополь", "moscow--stavropol"),
  ("Москва/Старый Оскол", "moscow--stariy-oskol"),
  ("Москва/Суздаль", "moscow--suzdal"),
  ("Москва/Сухиничи", "moscow--suhinichi"),
  ("Москва/Таганрог", "moscow--taganrog"),
  ("Москва/Талдом", "moscow--taldom"),
  ("Москва/Тамбов", "moscow--tambov"),
  ("Москва/Таруса", "moscow--tarusa"),
  ("Москва/Тацинская", "moscow--tatsinskaya"),
  ("Москва/Тверь", "moscow--tver"),
  ("Москва/Тольятти", "moscow--togliatti"),
  ("Москва/Торецк", "moscow--toretsk"),
  ("Москва/Тула", "moscow--tula"),
  ("Москва/Углич", "moscow--uglich"),
  ("Москва/Узловая", "moscow--uzlovaya"),
  ("Москва/Ульяновск", "moscow--ulyanovsk"),
  ("Москва/Унеча", "moscow--unecha"),
  ("Москва/Уфа", "moscow--ufa"),
  ("Москва/Феодосия", "moscow--feodosia"),
  ("Москва/Хельсинки", "moscow--helsinki"),
  ("Москва/Чебоксары", "moscow--cheboksary"),
  ("Москва/Черкесск", "moscow--cherkessk"),
  ("Москва/Шаховская", "moscow--shahovskaya"),
  ("Москва/Шахты", "moscow--shakhty"),
  ("Москва/Шацк", "moscow--shatsk-ru"),
  ("Москва/Шемурша", "moscow--shemursha"),
  ("Москва/Шилово", "moscow--shilovo-ryazhan-district"),
  ("Москва/Элиста", "moscow--elista"),
  ("Москва/Юхнов", "moscow--juhnov"),
  ("Москва/Ялта", "moscow--yalta"),
  ("Москва/Ярославль", "moscow--yaroslavl"),
  ("Москва/Ярцево", "moscow--yartsevo-smolensk-district"),
  ("Муром", "murom"),
  ("Набережные Челны/Казань", "naberezhnie-chelny--kazan"),
  ("Набережные Челны/Киров", "naberezhnie-chelny--kirov"),
  ("Набережные Челны/Москва", "naberezhnie-chelny--moscow"),
  ("Набережные Челны/Самара", "naberezhnie-chelny--samara"),
  ("Набережные Челны/Уфа", "naberezhnie-chelny--ufa"),
  ("Нефтекамск", "nephtekamsk"),
  ("Нефтекамск/Ижевск", "nephtekamsk--izhevsk"),
  ("Нефтекамск/Уфа", "nephtekamsk--ufa"),
  ("Нефтеюганск", "nefteugansk"),
  ("Нефтеюганск/Нижневартовск", "nefteugansk--nizhnevartovsk"),
  ("Нефтеюганск/Омск", "nefteugansk--omsk"),
  ("Нефтеюганск/Сургут", "nefteugansk--surgut-khanty-mansi-autonomous-okrug"),
  ("Нефтеюганск/Тобольск", "nefteugansk--tobolsk"),
  ("Нефтеюганск/Ханты-Мансийск", "nefteugansk--khanty-mansiysk"),
  ("Нижневартовск/Нефтеюганск", "nizhnevartovsk--nefteugansk"),
  ("Нижневартовск/Радужный", "nizhnevartovsk--radugniy"),
  ("Нижневартовск/Сургут", "nizhnevartovsk--surgut-khanty-mansi-autonomous-okrug"),
  ("Нижневартовск/Тюмень", "nizhnevartovsk--tyumen"),
  ("Нижневартовск/Ханты-Мансийск", "nizhnevartovsk--khanty-mansiysk"),
  ("Нижний Новгород", "nizhny-novgorod"),
  ("Нижний Новгород/Волгоград", "nizhny-novgorod--volgograd"),
  ("Нижний Новгород/Дивеево", "nizhny-novgorod--diveevo"),
  ("Нижний Новгород/Иваново", "nizhny-novgorod--ivanovo"),
  ("Нижний Новгород/Казань", "nizhny-novgorod--kazan"),
  ("Нижний Новгород/Кинешма", "nizhny-novgorod--kineshma"),
  ("Нижний Новгород/Кострома", "nizhny-novgorod--kostroma"),
  ("Нижний Новгород/Москва", "nizhny-novgorod--moscow"),
  ("Нижний Новгород/Муром", "nizhny-novgorod--murom"),
  ("Нижний Новгород/Набережные Челны", "nizhny-novgorod--naberezhnie-chelny"),
  ("Нижний Новгород/Пенза", "nizhny-novgorod--penza"),
  ("Нижний Новгород/Самара", "nizhny-novgorod--samara"),
  ("Нижний Новгород/Саранск", "nizhny-novgorod--saransk"),
  ("Нижний Новгород/Саратов", "nizhny-novgorod--saratov"),
  ("Нижний Новгород/Сергач", "nizhny-novgorod--sergach"),
  ("Нижний Новгород/Тольятти", "nizhny-novgorod--togliatti"),
  ("Нижний Новгород/Ульяновск", "nizhny-novgorod--ulyanovsk"),
  ("Нижний Новгород/Уфа", "nizhny-novgorod--ufa"),
  ("Нижний Новгород/Чебоксары", "nizhny-novgorod--cheboksary"),
  ("Нижний Новгород/Ялта", "nizhny-novgorod--yalta"),
  ("Нижний Новгород/Ярославль", "nizhny-novgorod--yaroslavl"),
  ("Нижний Тагил", "nizhniy-tagil"),
  ("Новокузнецк/Барнаул", "novokuznetsk--barnaul"),
  ("Новокузнецк/Белокуриха", "novokuznetsk--belokurikha"),
  ("Новокузнецк/Бийск", "novokuznetsk--biysk"),
  ("Новокузнецк/Кемерово", "novokuznetsk--kemerovo"),
  ("Новокузнецк/Красноярск", "novokuznetsk--krasnoyarsk"),
  ("Новокузнецк/Новосибирск", "novokuznetsk--novosibirsk"),
  ("Новокузнецк/Таштагол", "novokuznetsk--tashtagol"),
  ("Новокузнецк/Томск", "novokuznetsk--tomsk"),
  ("Новомосковск/Москва", "novomoskovsk-ru--moscow"),
  ("Новомосковск/Рязань", "novomoskovsk-ru--ryazan"),
  ("Новомосковск/Тула", "novomoskovsk-ru--tula"),
  ("Новороссийск/Краснодар", "novomoskovsk-ru--krasnodar"),
  ("Новороссийск/Севастополь", "novomoskovsk-ru--sevastopol"),
  ("Новосибирск", "novosibirsk"),
  ("Новосибирск/Баган", "novosibirsk--bagan-ru"),
  ("Новосибирск/Барнаул", "novosibirsk--barnaul"),
  ("Новосибирск/Белово", "novosibirsk--belovo"),
  ("Новосибирск/Белокуриха", "novosibirsk--belokurikha"),
  ("Новосибирск/Бийск", "novosibirsk--biysk"),
  ("Новосибирск/Горно-Алтайск", "novosibirsk--gorno-altaysk"),
  ("Новосибирск/Довольное", "novosibirsk--dovolnoe"),
  ("Новосибирск/Завьялово", "novosibirsk--zavjyalovo-altai-krai"),
  ("Новосибирск/Камень-на-Оби", "novosibirsk--kamen-na-obi"),
  ("Новосибирск/Карасук", "novosibirsk--karasuk"),
  ("Новосибирск/Кемерово", "novosibirsk--kemerovo"),
  ("Новосибирск/Купино", "novosibirsk--kupino"),
  ("Новосибирск/Манжерок", "novosibirsk--manzherok"),
  ("Новосибирск/Междуреченск", "novosibirsk--mezgdurechensk"),
  ("Новосибирск/Новокузнецк", "novosibirsk--novokuznetsk"),
  ("Новосибирск/Павлодар", "novosibirsk--pavlodar"),
  ("Новосибирск/Рубцовск", "novosibirsk--rubtsovsk"),
  ("Новосибирск/Семей", "novosibirsk--semey"),
  ("Новосибирск/Славгород", "novosibirsk--slavgorod-ru"),
  ("Новосибирск/Сузун", "novosibirsk--suzun"),
  ("Новосибирск/Томск", "novosibirsk--tomsk"),
  ("Новосибирск/Хабары", "novosibirsk--khabari"),
  ("Новосибирск/Чемал", "novosibirsk--chemal"),
  ("Новосибирск/Шерегеш", "novosibirsk--sheregesh"),
  ("Новосибирск/Яровое", "novosibirsk--yarovoe"),
  ("Нягань", "nyagan"),
  ("Октябрьский", "oktyabrsky-bashkortostan"),
  ("Октябрьский/Казань", "oktyabrsky-bashkortostan--kazan"),
  ("Омск", "omsk"),
  ("Омск/Сургут", "omsk--surgut-khanty-mansi-autonomous-okrug"),
  ("Омск/Тара", "omsk--tara"),
  ("Омск/Тобольск", "omsk--tobolsk"),
  ("Омск/Ханты-Мансийск", "omsk--khanty-mansiysk"),
  ("Оренбург", "orenburg"),
  ("Оренбург/Бузулук", "orenburg--buzuluk"),
  ("Оренбург/Казань", "orenburg--kazan"),
  ("Оренбург/Краснодар", "orenburg--krasnodar"),
  ("Оренбург/Москва", "orenburg--moscow"),
  ("Оренбург/Набережные Челны", "orenburg--naberezhnie-chelny"),
  ("Оренбург/Нижний Новгород", "orenburg--nizhny-novgorod"),
  ("Оренбург/Орск", "orenburg--orsk"),
  ("Оренбург/Пермь", "orenburg--perm"),
  ("Оренбург/Самара", "orenburg--samara"),
  ("Оренбург/Стерлитамак", "orenburg--sterlitamak"),
  ("Оренбург/Уфа", "orenburg--ufa"),
  ("Оренбург/Челябинск", "orenburg--chelyabinsk"),
  ("Орск", "orsk"),
  ("Орёл", "orel"),
  ("Орёл/Брянск", "orel--bryansk"),
  ("Орёл/Воронеж", "orel--voronezh"),
  ("Орёл/Железногорск", "orel--zheleznogorsk-kursk-district"),
  ("Орёл/Краснодар", "orel--krasnodar"),
  ("Орёл/Москва", "orel--moscow"),
  ("Орёл/Ростов-на-Дону", "orel--rostov-on-don"),
  ("Орёл/Смоленск", "orel--smolensk"),
  ("Орёл/Тула", "orel--tula"),
  ("Павловск/Воронеж", "pavlovsk-saint-petersburg-and-leningradskaya-oblast--voronezh"),
  ("Пенза", "penza"),
  ("Пенза/Волгоград", "penza--volgograd"),
  ("Пенза/Москва", "penza--moscow"),
  ("Пенза/Нижний Новгород", "penza--nizhny-novgorod"),
  ("Пенза/Саранск", "penza--saransk"),
  ("Пенза/Саратов", "penza--saratov"),
  ("Пенза/Ульяновск", "penza--ulyanovsk"),
  ("Пермь", "perm"),
  ("Пермь/Березники", "perm--berezniki-perm-district"),
  ("Пермь/Верещагино", "perm--vereschagino"),
  ("Пермь/Воткинск", "perm--votkinsk"),
  ("Пермь/Екатеринбург", "perm--yekaterinburg"),
  ("Пермь/Ижевск", "perm--izhevsk"),
  ("Пермь/Казань", "perm--kazan"),
  ("Пермь/Карагай", "perm--karagay"),
  ("Пермь/Красновишерск", "perm--krasnovishersk"),
  ("Пермь/Кунгур", "perm--kungur"),
  ("Пермь/Лысьва", "perm--lysva"),
  ("Пермь/Москва", "perm--moscow"),
  ("Пермь/Набережные Челны", "perm--naberezhnie-chelny"),
  ("Пермь/Оренбург", "perm--orenburg"),
  ("Пермь/Самара", "perm--samara"),
  ("Пермь/Соликамск", "perm--solikamsk"),
  ("Пермь/Усть-Качка", "perm--ust-kachka"),
  ("Пермь/Уфа", "perm--ufa"),
  ("Пермь/Чайковский", "perm--chaikovsky"),
  ("Пермь/Челябинск", "perm--chelyabinsk"),
  ("Пермь/Чернушка", "perm--chernushka"),
  ("Петрозаводск/Беломорск", "petrozavodsk--belomorsk"),
  ("Петрозаводск/Кемь", "petrozavodsk--kem"),
  ("Петрозаводск/Кондопога", "petrozavodsk--kondopoga"),
  ("Петрозаводск/Костомукша", "petrozavodsk--kostomucsha"),
  ("Петрозаводск/Медвежьегорск", "petrozavodsk--medvezhyegorsk"),
  ("Петрозаводск/Санкт-Петербург", "petrozavodsk--saint-petersburg"),
  ("Петрозаводск/Сегежа", "petrozavodsk--segezha"),
  ("Петрозаводск/Сортавала", "petrozavodsk--sortavala"),
  ("Протвино/Москва", "protvino--moscow"),
  ("Псков", "pskov"),
  ("Псков/Великие Луки", "pskov--velikie-luky"),
  ("Псков/Санкт-Петербург", "pskov--saint-petersburg"),
  ("Псков/Себеж", "pskov--sebezh"),
  ("Пущино", "pushino--moscow"),
  ("Речица", "rechitsa"),
  ("Ржев/Москва", "rzhev--moscow"),
  ("Россошь/Воронеж", "rossosh--voronezh"),
  ("Ростов-на-Дону", "rostov-on-don"),
  ("Ростов-на-Дону/Астрахань", "rostov-on-don--astrahan"),
  ("Ростов-на-Дону/Волгоград", "rostov-on-don--volgograd"),
  ("Ростов-на-Дону/Волгодонск", "rostov-on-don--volgodonsk"),
  ("Ростов-на-Дону/Ейск", "rostov-on-don--yesk"),
  ("Ростов-на-Дону/Керчь", "rostov-on-don--kerch"),
  ("Ростов-на-Дону/Краснодар", "rostov-on-don--krasnodar"),
  ("Ростов-на-Дону/Махачкала", "rostov-on-don--makhachkala"),
  ("Ростов-на-Дону/Минеральные Воды", "rostov-on-don--mineralniye-vodi"),
  ("Ростов-на-Дону/Москва", "rostov-on-don--moscow"),
  ("Ростов-на-Дону/Самара", "rostov-on-don--samara"),
  ("Ростов-на-Дону/Санкт-Петербург", "rostov-on-don--saint-petersburg"),
  ("Ростов-на-Дону/Севастополь", "rostov-on-don--sevastopol"),
  ("Ростов-на-Дону/Симферополь", "rostov-on-don--simferopol"),
  ("Ростов-на-Дону/Тула", "rostov-on-don--tula"),
  ("Рыбинск/Москва", "rybinsk--moscow"),
  ("Рязань/Москва", "ryazan--moscow"),
  ("Салават", "salavat"),
  ("Салават/Уфа", "salavat--ufa"),
  ("Самара", "samara"),
  ("Самара/Альметьевск", "samara--almetyevsk"),
  ("Самара/Балаково", "samara--balakovo"),
  ("Самара/Бузулук", "samara--buzuluk"),
  ("Самара/Ижевск", "samara--izhevsk"),
  ("Самара/Казань", "samara--kazan"),
  ("Самара/Клявлино", "samara--klyavlino"),
  ("Самара/Москва", "samara--moscow"),
  ("Самара/Набережные Челны", "samara--naberezhnie-chelny"),
  ("Самара/Нижнекамск", "samara--nizhnekamsk"),
  ("Самара/Нижний Новгород", "samara--nizhny-novgorod"),
  ("Самара/Оренбург", "samara--orenburg"),
  ("Самара/Пугачев", "samara--pugachev"),
  ("Самара/Саратов", "samara--saratov"),
  ("Самара/Сочи", "samara--sochi"),
  ("Самара/Ульяновск", "samara--ulyanovsk"),
  ("Самара/Чебоксары", "samara--cheboksary"),
  ("Санкт-Петербург", "saint-petersburg"),
  ("Санкт-Петербург/Брянск", "saint-petersburg--bryansk"),
  ("Санкт-Петербург/Витебск", "saint-petersburg--vitebsk"),
  ("Санкт-Петербург/Волгоград", "saint-petersburg--volgograd"),
  ("Санкт-Петербург/Ивангород", "saint-petersburg--ivangorod"),
  ("Санкт-Петербург/Махачкала", "saint-petersburg--makhachkala"),
  ("Санкт-Петербург/Минск", "saint-petersburg--minsk"),
  ("Санкт-Петербург/Могилёв", "saint-petersburg--mogilev"),
  ("Санкт-Петербург/Москва", "saint-petersburg--moscow"),
  ("Санкт-Петербург/Нарва", "saint-petersburg--narva"),
  ("Санкт-Петербург/Невель", "saint-petersburg--nevel"),
  ("Санкт-Петербург/Олонец", "saint-petersburg--olonets"),
  ("Санкт-Петербург/Петрозаводск", "saint-petersburg--petrozavodsk"),
  ("Санкт-Петербург/Псков", "saint-petersburg--pskov"),
  ("Санкт-Петербург/Пудож", "saint-petersburg--pudozh"),
  ("Санкт-Петербург/Пустошка", "saint-petersburg--pustoshka"),
  ("Санкт-Петербург/Себеж", "saint-petersburg--sebezh"),
  ("Санкт-Петербург/Смоленск", "saint-petersburg--smolensk"),
  ("Санкт-Петербург/Старая Русса", "saint-petersburg--staraya-russa"),
  ("Санкт-Петербург/Таллин", "saint-petersburg--tallin"),
  ("Санкт-Петербург/Тихвин", "saint-petersburg--tixvin"),
  ("Санкт-Петербург/Хельсинки", "saint-petersburg--helsinki"),
  ("Санкт-Петербург/Череповец", "saint-petersburg--cherepovets"),
  ("Саранск/Нижний Новгород", "saransk--nizhny-novgorod"),
  ("Саратов", "saratov"),
  ("Саратов/Волгоград", "saratov--volgograd"),
  ("Саратов/Москва", "saratov--moscow"),
  ("Саратов/Хвалынск", "protvino--hvalynsk"),
  ("Севастополь", "sevastopol"),
  ("Севастополь/Краснодар", "sevastopol--krasnodar"),
  ("Серпухов", "serpuhov"),
  ("Симферополь", "simferopol"),
  ("Симферополь/Краснодар", "simferopol--krasnodar"),
  ("Симферополь/Москва", "simferopol--moscow"),
  ("Симферополь/Сочи", "simferopol--sochi"),
  ("Симферополь/Ставрополь", "simferopol--stavropol"),
  ("Смоленск/Минск", "smolensk--minsk"),
  ("Смоленск/Москва", "smolensk--moscow"),
  ("Смоленск/Орша", "smolensk--orsha"),
  ("Смоленск/Санкт-Петербург", "smolensk--saint-petersburg"),
  ("Соликамск/Екатеринбург", "solikamsk--yekaterinburg"),
  ("Соликамск/Пермь", "solikamsk--perm"),
  ("Сочи", "sochi"),
  ("Сочи/Симферополь", "sochi--simferopol"),
  ("Ставрополь", "stavropol"),
  ("Ставрополь/Кисловодск", "stavropol--kislovodsk"),
  ("Ставрополь/Севастополь", "stavropol--sevastopol"),
  ("Ставрополь/Симферополь", "stavropol--simferopol"),
  ("Старый Оскол/Москва", "stariy-oskol--moscow"),
  ("Стерлитамак/Уфа", "sterlitamak--ufa"),
  ("Сургут", "surgut-khanty-mansi-autonomous-okrug"),
  ("Сургут/Нижневартовск", "surgut-khanty-mansi-autonomous-okrug--nizhnevartovsk"),
  ("Сургут/Ханты-Мансийск", "surgut-khanty-mansi-autonomous-okrug--khanty-mansiysk"),
  ("Сыктывкар/Ухта", "syktyvkar--uhta"),
  ("Таганрог", "taganrog"),
  ("Таганрог/Москва", "taganrog--moscow"),
  ("Тамбов", "tambov"),
  ("Тамбов/Воронеж", "tambov--voronezh"),
  ("Тамбов/Москва", "tambov--moscow"),
  ("Тверь", "tver"),
  ("Тверь/Санкт-Петербург", "tver--saint-petersburg"),
  ("Тобольск/Тюмень", "tobolsk--tyumen"),
  ("Тольятти", "togliatti"),
  ("Тольятти/Казань", "togliatti--kazan"),
  ("Тольятти/Нижний Новгород", "togliatti--nizhny-novgorod"),
  ("Томск/Красноярск", "tomsk--krasnoyarsk"),
  ("Туймазы/Казань", "tuymazy--kazan"),
  ("Тула/Краснодар", "tula--krasnodar"),
  ("Тула/Москва", "tula--moscow"),
  ("Тула/Рязань", "tula--ryazan"),
  ("Тюмень", "tyumen"),
  ("Тюмень/Курган", "tyumen--kurgan"),
  ("Тюмень/Нижний Тагил", "tyumen--nizhniy-tagil"),
  ("Тюмень/Тобольск", "tyumen--tobolsk"),
  ("Тюмень/Ханты-Мансийск", "tyumen--khanty-mansiysk"),
  ("Тюмень/Челябинск", "tyumen--chelyabinsk"),
  ("Устюжна/Санкт-Петербург", "ustugna--saint-petersburg"),
  ("Уфа", "ufa"),
  ("Уфа/Аша", "ufa--asha"),
  ("Уфа/Белорецк", "ufa--beloretsk"),
  ("Уфа/Бирск", "ufa--birsk"),
  ("Уфа/Давлеканово", "ufa--davlekanovo"),
  ("Уфа/Дюртюли", "ufa--dyurtyuli"),
  ("Уфа/Екатеринбург", "ufa--yekaterinburg"),
  ("Уфа/Ижевск", "ufa--izhevsk"),
  ("Уфа/Ишимбай", "ufa--ishimbay"),
  ("Уфа/Казань", "ufa--kazan"),
  ("Уфа/Киров", "ufa--kirov"),
  ("Уфа/Магнитогорск", "ufa--magnitogorsk"),
  ("Уфа/Мелеуз", "ufa--meleuz"),
  ("Уфа/Месягутово", "ufa--mesyagutovo"),
  ("Уфа/Москва", "ufa--moscow"),
  ("Уфа/Набережные Челны", "ufa--naberezhnie-chelny"),
  ("Уфа/Нефтекамск", "ufa--nephtekamsk"),
  ("Уфа/Нижний Новгород", "ufa--nizhny-novgorod"),
  ("Уфа/Оренбург", "ufa--orenburg"),
  ("Уфа/Пермь", "ufa--perm"),
  ("Уфа/Сургут", "ufa--surgut-khanty-mansi-autonomous-okrug"),
  ("Уфа/Чебоксары", "ufa--cheboksary"),
  ("Уфа/Челябинск", "ufa--chelyabinsk"),
  ("Ухта/Киров", "uhta--kirov"),
  ("Феодосия", "feodosia"),
  ("Феодосия/Москва", "feodosia--moscow"),
  ("Ханты-Мансийск/Сургут", "khanty-mansiysk--surgut-khanty-mansi-autonomous-okrug"),
  ("Хельсинки/Санкт-Петербург", "helsinki--saint-petersburg"),
  ("Чайковский", "chaikovsky"),
  ("Чайковский/Пермь", "chaikovsky--perm"),
  ("Чебоксары/Казань", "cheboksary--kazan"),
  ("Чебоксары/Москва", "cheboksary--moscow"),
  ("Челябинск", "chelyabinsk"),
  ("Челябинск/Екатеринбург", "chelyabinsk--yekaterinburg"),
  ("Челябинск/Златоуст", "chelyabinsk--zlatoust"),
  ("Челябинск/Казань", "chelyabinsk--kazan"),
  ("Челябинск/Карталы", "chelyabinsk--kartaly"),
  ("Челябинск/Кунгур", "chelyabinsk--kungur"),
  ("Челябинск/Курган", "chelyabinsk--kurgan"),
  ("Челябинск/Магнитогорск", "chelyabinsk--magnitogorsk"),
  ("Челябинск/Миасс", "chelyabinsk--miass"),
  ("Челябинск/Оренбург", "chelyabinsk--orenburg"),
  ("Челябинск/Пермь", "chelyabinsk--perm"),
  ("Челябинск/Сатка", "chelyabinsk--satka"),
  ("Челябинск/Тюмень", "chelyabinsk--tyumen"),
  ("Челябинск/Учалы", "chelyabinsk--uchaly"),
  ("Череповец", "cherepovets"),
  ("Череповец/Москва", "cherepovets--moscow"),
  ("Череповец/Санкт-Петербург", "cherepovets--saint-petersburg"),
  ("Чита/Забайкальск", "chita--zabaykalsk"),
  ("Чита/Могоча", "chita--mogocha"),
  ("Чита/Улан-Удэ", "chita--ulan-ude"),
  ("Шахты/Москва", "shakhty--moscow"),
  ("Шерегеш", "sheregesh"),
  ("Юрга/Новосибирск", "urga-kemerovo-district--novosibirsk"),
  ("Ялта/Москва", "yalta--moscow"),
  ("Ялта/Севастополь", "yalta--sevastopol"),
  ("Яровое/Новосибирск", "yarovoe--novosibirsk"),
  ("Ярославль/Москва", "yaroslavl--moscow"),
  ("Ярославль/Рыбинск", "yaroslavl--rybinsk"),
]


def gen_minotaur3120():
    res = []

    for prefix in ['www.', '']:
        for tld in ['ru', 'by']:
            res += [
                permanent(
                    '%syandex.%s/bus/search/*' % (prefix, tld),
                    'https://travel.yandex.ru/buses/'
                )
            ]

    for prefix in ['www.', '']:
        for tld in ['ru', 'by']:
            for src_path, dst_path in PATH_PAIRS:
                res += [
                    permanent(
                        '%syandex.%s/bus/%s' % (prefix, tld, requote_uri(src_path)),
                        'https://travel.yandex.ru/buses/%s/' % requote_uri(dst_path)
                    )
                ]

    for prefix in ['www.', '']:
        for tld in ALL_YANDEX_ZONES:
            res += [
                permanent(
                    '%syandex.%s/bus/*' % (prefix, tld),
                    'https://travel.yandex.ru/buses/'
                )
            ]

    return res
