#!/usr/bin/env bash

source `dirname "${BASH_SOURCE[0]}"`/../scripts/run.sh

if [ "$#" -eq 0 ] || [ "$#" -ge 2 ]; then
    echo "Usage: $0 (build|clean)"
    exit 1
fi

MODE=$1
DESTDIR="w-generated/all"
WEB_DIR="w-generated/web"
VIDEO_DIR="w-generated/video"

run ./tools/cfggen/main.py --action ${MODE} --output-dir ${DESTDIR} --workers 5 --apply --groups ALL
run ./tools/cfggen/main.py --action ${MODE} --output-dir ${WEB_DIR} --workers 5 --apply --groups MAN_WEB_PLATINUM_JUPITER_BASE,MAN_WEB_PLATINUM_JUPITER_BASE_HAMSTER,MAN_WEB_PLATINUM_JUPITER_BASE_MULTI,MAN_WEB_TIER0_ATTRIBUTE_BASE,MAN_WEB_TIER0_ATTRIBUTE_BASE_HAMSTER,MAN_WEB_TIER0_ATTRIBUTE_BASE_MULTI,MAN_WEB_TIER0_BASE,MAN_WEB_TIER0_BASE_HAMSTER,MAN_WEB_TIER0_BASE_MULTI,MAN_WEB_TIER0_EMBEDDING,MAN_WEB_TIER0_INVERTED_INDEX,MAN_WEB_TIER0_KEYINV,SAS_WEB_PLATINUM_BASE,SAS_WEB_TIER0_ATTRIBUTE_BASE,SAS_WEB_TIER0_ATTRIBUTE_BASE_HAMSTER,SAS_WEB_TIER0_ATTRIBUTE_BASE_MULTI,SAS_WEB_TIER0_BASE,SAS_WEB_TIER0_BASE_HAMSTER,SAS_WEB_TIER0_BASE_MULTI,SAS_WEB_TIER0_EMBEDDING,SAS_WEB_TIER0_INVERTED_INDEX,SAS_WEB_TIER0_KEYINV,VLA_WEB_PLATINUM_JUPITER_BASE,VLA_WEB_PLATINUM_JUPITER_BASE_HAMSTER,VLA_WEB_PLATINUM_JUPITER_BASE_MULTI,VLA_WEB_TIER0_ATTRIBUTE_BASE,VLA_WEB_TIER0_ATTRIBUTE_BASE_HAMSTER,VLA_WEB_TIER0_ATTRIBUTE_BASE_MULTI,VLA_WEB_TIER0_BASE,VLA_WEB_TIER0_BASE_HAMSTER,VLA_WEB_TIER0_BASE_MULTI,VLA_WEB_TIER0_EMBEDDING,VLA_WEB_TIER0_INVERTED_INDEX,VLA_WEB_TIER0_KEYINV,VLA_WEB_TIER0_BASE_PIP
run ./tools/cfggen/main.py --action ${MODE} --output-dir ${VIDEO_DIR} --workers 5 --apply --groups MAN_VIDEO_PLATINUM_BASE,MAN_VIDEO_PLATINUM_BASE_HAMSTER,MAN_VIDEO_PLATINUM_EMBEDDING,MAN_VIDEO_PLATINUM_INVERTED_INDEX,MAN_VIDEO_TIER0_BASE,MAN_VIDEO_TIER0_BASE_HAMSTER,MAN_VIDEO_TIER0_EMBEDDING,MAN_VIDEO_TIER0_INVERTED_INDEX,SAS_VIDEO_PLATINUM_BASE,SAS_VIDEO_PLATINUM_BASE_HAMSTER,SAS_VIDEO_PLATINUM_EMBEDDING,SAS_VIDEO_PLATINUM_EMBEDDING,SAS_VIDEO_PLATINUM_INVERTED_INDEX,SAS_VIDEO_TIER0_BASE,SAS_VIDEO_TIER0_BASE_HAMSTER,SAS_VIDEO_TIER0_EMBEDDING,SAS_VIDEO_TIER0_EMBEDDING,SAS_VIDEO_TIER0_INVERTED_INDEX,VLA_VIDEO_PLATINUM_BASE,VLA_VIDEO_PLATINUM_BASE_HAMSTER,VLA_VIDEO_TIER0_BASE,VLA_VIDEO_TIER0_BASE_HAMSTER,VLA_VIDEO_PLATINUM_EMBEDDING,VLA_VIDEO_PLATINUM_INVERTED_INDEX,VLA_VIDEO_TIER0_EMBEDDING,VLA_VIDEO_TIER0_INVERTED_INDEX
