"""
    List of generators
"""


class IGenerator(object):
    """
        Interface for all generators. Every generator should implement function from this interface class
    """

    def __init__(self):
        pass

    def build(self, group):
        """
            Build configs for specified group.

            :type group: core.igroups.IGroup

            :param group: group to generate config for
        """

        raise NotImplementedError("Method <build> is not implemented")

    def gennames(self, group):
        """
            Generate file names for group configs
        """

        raise NotImplementedError("Method <gennames> is not implemented")


class TBuildReportEntry(object):
    """
        Information of single result config (config generator can generate a lot of different configs, each
        corresponds to one or several instances and one or several file names on file system
    """

    __slots__ = ('content', 'fnames',)

    def __init__(self, content, fnames):
        self.content = content
        self.fnames = fnames


class TBuildReport(object):
    """
        Content of everything generated by <IGenerator>
    """

    __slots__ = ('group_name', 'report_entries',)

    def __init__(self, group):
        self.group_name = group.card.name
        self.report_entries = []
