#!/skynet/python/bin/python

import os
import sys

sys.path.append(os.path.abspath(os.path.join(os.path.dirname(__file__), '..', '..')))

from argparse import ArgumentParser
import itertools

import gencfg
import ezodf


class Project(object):
    def __init__(self, data):
        self.name = data.split(';')[0]
        self.metaprj = data.split(';')[1]
        self.cpu = float(data.split(';')[2])
        self.memory = float(data.split(';')[3])


def parse_cmd():
    parser = ArgumentParser(description="Create ods from csv generated by show_metagroups_power")
    parser.add_argument("-i", "--input-file", type=str, required=True,
                        help="Obligatory. Input csv file")
    parser.add_argument("-o", "--output-file", type=str, required=True,
                        help="Obligatory. Output ods faile")

    if len(sys.argv) == 1:
        sys.argv.append('-h')
    options = parser.parse_args()

    return options


# convert index to column name
def _CN(i):
    alphabet = 'ABCDEFGHIJKLMNOPQRSTUVXZ'
    if i <= len(alphabet):
        return alphabet[i]
    return _CN(i / len(alphabet)) + alphabet[i % len(alphabet)]


def main(options):
    projects = map(lambda x: Project(x.strip()), open(options.input_file).readlines())
    projects = filter(lambda x: x.name != 'All', projects)  # cacluate total myself

    all_names = []
    all_metaprjs = []
    for project in projects:
        if project.name not in all_names:
            all_names.append(project.name)
        if project.metaprj not in all_metaprjs:
            all_metaprjs.append(project.metaprj)
    all_names.append("All")
    all_metaprjs.append("TOTAL")

    projects = dict(map(lambda x: ((x.name, x.metaprj), x), projects))
    for name, metaprj in itertools.product(all_names, all_metaprjs):
        if (name, metaprj) not in projects:
            projects[(name, metaprj)] = Project('%s;%s;0;0' % (str(name), str(metaprj)))

    n_rows = 2 + len(all_names)
    n_columns = 1 + 4 * len(all_metaprjs)

    ods = ezodf.newdoc(doctype='ods', filename=options.output_file)
    sheet = ezodf.Sheet('SHEET', size=(n_rows, n_columns))
    ods.sheets += sheet

    # fill first column
    for i in range(len(all_names)):
        sheet[(i + 2, 0)].set_value(unicode(all_names[i], "utf-8"))

    # fill first rows
    for i in range(len(all_metaprjs)):
        sheet[(0, i * 4 + 1)].set_value(unicode(all_metaprjs[i], "utf-8"))
        sheet.set_cell_span((0, i * 4 + 1), (1, 4))

        sheet[(1, i * 4 + 1)].set_value("CPU abs")
        sheet[(1, i * 4 + 2)].set_value("MEM abs")
        sheet[(1, i * 4 + 3)].set_value("CPU %")
        sheet[(1, i * 4 + 4)].set_value("MEM %")

    # fill common data
    for i, metaprj in enumerate(all_metaprjs):
        for j, name in enumerate(all_names):
            posX = i * 4 + 1
            posY = j + 2

            sheet[(posY, posX)].set_value(int(projects[(name, metaprj)].cpu))
            sheet[(posY, posX + 2)] = ezodf.Cell(value_type='percentage')
            sheet[(posY, posX + 2)].formula = "of:=%s%s/$%s$%s" % (_CN(posX), posY + 1, _CN(n_columns - 4), n_rows)

            sheet[(posY, posX + 1)].set_value(int(projects[(name, metaprj)].memory))
            sheet[(posY, posX + 3)] = ezodf.Cell(value_type='percentage')
            sheet[(posY, posX + 3)].formula = "of:=%s%s/$%s$%s" % (_CN(posX + 1), posY + 1, _CN(n_columns - 3), n_rows)

    # fill last column
    for j, name in enumerate(all_names):
        posX = 1 + 4 * (len(all_metaprjs) - 1)
        posY = 2 + j

        value = '; '.join(map(lambda x: '%s%s' % (_CN(1 + x * 4), posY + 1), range(len(all_metaprjs) - 1)))
        sheet[(posY, posX)].formula = "of:=SUM(%s)" % value

        value = '; '.join(map(lambda x: '%s%s' % (_CN(2 + x * 4), posY + 1), range(len(all_metaprjs) - 1)))
        sheet[(posY, posX + 1)].formula = "of:=SUM(%s)" % value

    # fill last row
    for i, metaprj in enumerate(all_metaprjs):
        posX = i * 4 + 1
        posY = n_rows - 1
        sheet[(posY, posX)].formula = "of:=SUM(%s%s:%s%s)" % (_CN(posX), 3, _CN(posX), posY)
        sheet[(posY, posX + 1)].formula = "of:=SUM(%s%s:%s%s)" % (_CN(posX + 1), 3, _CN(posX + 1), posY)

    ods.save()


if __name__ == '__main__':
    options = parse_cmd()
    main(options)
