import toml
import os
import re
import functools

import yatest.common
# from yalibrary.yandex import staff


MEMBER_RE = re.compile(r'\w+')
# STAFF_CLIENT = staff.Staff()


def do_test_format(groups_dir, group_name):
    if 1:
        try:
            with open(os.path.join(groups_dir, group_name)) as group_file:
                group_info = toml.loads(group_file.read())
        except UnicodeDecodeError as e:
            raise UnicodeDecodeError(f'{group_name}: {e}')
        except toml.TomlDecodeError as e:
            raise toml.TomlDecodeError(
                'Can\'t read toml file for {}. Probably, you should read about expected file format '
                'https://a.yandex-team.ru/arc/trunk/arcadia/groups/readme.md'.format(group_name),
                e.doc,
                e.pos,
            )

        assert group_info.get('members'), f'{group_name}: empty group not allowed'
        logins = group_info['members']

        for login in logins:
            assert MEMBER_RE.match(login), f'{group_name}: login not valid {login}'

        # answ = STAFF_CLIENT.check_login_exists(logins)
        # for login in answ:
            # assert answ[login], '{}: no bro with login {}'.format(group_name, login)

        if 'mail' in group_info:
            assert group_info['mail'].endswith('@yandex-team.ru'), f'{group_name}: mail not at yandex-team'
            assert is_ascii(group_info['mail']), f'{group_name}: non-ascii symbols not allowed in mail'

        if 'display_name' in group_info:
            assert is_ascii(group_info['display_name']), f'{group_name}: non-ascii symbols not allowed in display_name'


def is_ascii(text):
    try:
        text.encode('ascii', errors='strict')
    except UnicodeEncodeError:
        return False

    return bool(text.replace('?', ''))


def prepare_tests():
    groups_dir = yatest.common.test_source_path()

    for group_name in os.listdir(groups_dir):
        group_file_name = os.path.join(groups_dir, group_name)

        if os.path.islink(group_file_name) or '.' in group_name or not os.path.isfile(group_file_name):
            continue

        globals()[f'test_{group_name}'] = functools.partial(do_test_format, groups_dir, group_name)


prepare_tests()
