package main

import (
	"log"
	"net/http"
	"time"

	"github.com/go-chi/chi/v5"
	"github.com/go-chi/chi/v5/middleware"
)

func webAPI(env *Env, port string) {
	r := chi.NewRouter()
	r.Use(middleware.RequestID)
	r.Use(middleware.RealIP)
	r.Use(middleware.Logger)
	r.Use(middleware.Recoverer)
	r.Use(middleware.Timeout(60 * time.Second))

	r.Route("/v1", func(r chi.Router) {
		r.Route("/key_escrow", func(r chi.Router) {
			r.Post("/", env.keyEscrow)
		})
		r.Route("/ipxe", func(r chi.Router) {
			r.Get("/", env.ipxeGenStartupScript)
			r.Post("/", env.ipxeGenBootScript)
		})
		r.Route("/preseed", func(r chi.Router) {
			r.Get("/", env.preseedGenScript)
		})
		r.Route("/task", func(r chi.Router) {
			r.Post("/close", env.taskClose)
		})
		r.Route("/version", func(r chi.Router) {
			r.Get("/", env.printVersion)
		})
		r.Route("/wimboot", func(r chi.Router) {
			r.Get("/config.xml", env.deployConfig)
			r.Get("/bootstrap.ini", env.bootstrapIni)
		})
	})
	r.Route("/ping", func(r chi.Router) {
		r.Get("/", ping)
	})

	err := http.ListenAndServe(":"+port, r)
	if err != nil {
		log.Fatal(err.Error())
	}
}
