package main

import (
	"fmt"
	"log"
	"os"
	"time"

	"a.yandex-team.ru/helpdesk/infra/baldr/internal/models"
	"a.yandex-team.ru/library/go/yandex/yav/httpyav"
)

var token chan interface{}

func main() {
	yavOAuthToken := os.Getenv("YAV_TOKEN")

	yc := NewYAVClient(yavOAuthToken)

	config := models.DBConfig{
		User:                 os.Getenv("DB_USER"),
		Password:             os.Getenv("DB_PASSWORD"),
		DBName:               os.Getenv("DB_DATABASE"),
		Hosts:                os.Getenv("DB_HOSTS"),
		Port:                 os.Getenv("DB_PORT"),
		SSLMode:              "verify-full",
		PreferSimpleProtocol: true,
	}

	db, err := models.NewDB(config)
	if err != nil {
		fmt.Printf("fatal error: %v", err)
		return
	}

	env := &Env{
		db: db,
		smb: smb{
			username: os.Getenv("SMB_USERNAME"),
			password: os.Getenv("SMB_PASSWORD"),
			domain:   os.Getenv("SMB_DOMAIN"),
		},
		bot: bot{
			baseURL: os.Getenv("BOT_BASE_URL"),
			token:   os.Getenv("BOT_TOKEN"),
		},
		yt: ytConfig{
			proxy:     os.Getenv("YT_PROXY"),
			tablePath: os.Getenv("YT_TABLE_PATH"),
			token:     os.Getenv("YT_TOKEN"),
		},
		yav: yc,
		ad: ad{
			robotName:          os.Getenv("ROBOT_AD_NAME"),
			robotPassword:      os.Getenv("ROBOT_AD_PASSWORD"),
			domain:             os.Getenv("ROBOT_AD_DOMAIN"),
			localAdminPassword: os.Getenv("LOCAL_ADMIN_PASSWORD"),
		},
		apiProdURL: os.Getenv("API_PROD_URL"),
		apiTestURL: os.Getenv("API_TEST_URL"),
		currentEnv: os.Getenv("APP_ENV"),
	}

	go webAPI(env, os.Getenv("APP_PORT"))
	go closeByTimeout(env)

	<-token
}

func NewYAVClient(token string) *httpyav.Client {
	const timeout = 5
	for {
		yc, err := httpyav.NewClient(
			httpyav.WithOAuthToken(token),
		)
		if err != nil {
			log.Printf("NewYAVClient(): %s; try again after %d seconds", err, timeout)
		} else {
			return yc
		}

		time.Sleep(timeout * time.Second)
	}
}
