/* Языковые профили */
BEGIN;
  SET SCHEMA 'deploy';

  INSERT INTO locale_profiles ("profile_name", "ms_system_locale", "ms_user_locale",
                               "ms_keyboard_locale", "ms_ui_language", "di_language", "di_country",
                               "di_locale", "di_supported_locales", "di_keymap", "di_toggle")
    VALUES
    ('en_ru',
     '0409:00000409',
     'ru-ru',
     '0409:00000409;0419:00000419',
     'en-us',
     'en',
     'RU',
     'en_US.UTF-8',
     'ru_RU.UTF-8',
     'ru',
     'Alt+Shift');
  INSERT INTO locale_profiles ("profile_name", "ms_system_locale", "ms_user_locale",
                               "ms_keyboard_locale", "ms_ui_language", "di_language", "di_country",
                               "di_locale", "di_supported_locales", "di_keymap", "di_toggle")
    VALUES
    ('en_us',
     '0409:00000409',
     'en-us',
     '0409:00000409',
     'en-us',
     'us',
     'US',
     'en_US.UTF-8',
     '',
     'us',
     'No toggling');
  INSERT INTO locale_profiles ("profile_name", "ms_system_locale", "ms_user_locale",
                               "ms_keyboard_locale", "ms_ui_language", "di_language", "di_country",
                               "di_locale", "di_supported_locales", "di_keymap", "di_toggle")
    VALUES
    ('en_by',
     '0409:00000409',
     'be-by',
     '0409:00000409;0423:00000423',
     'en-us',
     'en',
     'BY',
     'en_US.UTF-8',
     'be_BY.UTF-8',
     'by',
     'Alt+Shift');
  INSERT INTO locale_profiles ("profile_name", "ms_system_locale", "ms_user_locale",
                               "ms_keyboard_locale", "ms_ui_language", "di_language", "di_country",
                               "di_locale", "di_supported_locales", "di_keymap", "di_toggle")
    VALUES
    ('en_tr',
     '0409:00000409',
     'tr-tr',
     '0409:00000409;041f:0000041f',
     'en-us',
     'en',
     'TR',
     'en_US.UTF-8',
     'tr_TR.UTF-8',
     'tr',
     'Alt+Shift');
  INSERT INTO locale_profiles ("profile_name", "ms_system_locale", "ms_user_locale",
                               "ms_keyboard_locale", "ms_ui_language", "di_language", "di_country",
                               "di_locale", "di_supported_locales", "di_keymap", "di_toggle")
    VALUES
    ('en_fi',
     '0409:00000409',
     'fi-fi',
     '0409:00000409;040b:0000040b',
     'en-us',
     'en',
     'FI',
     'en_US.UTF-8',
     'fi_FI.UTF-8',
     'fi',
     'Alt+Shift');
  INSERT INTO locale_profiles ("profile_name", "ms_system_locale", "ms_user_locale",
                               "ms_keyboard_locale", "ms_ui_language", "di_language", "di_country",
                               "di_locale", "di_supported_locales", "di_keymap", "di_toggle")
    VALUES
    ('en_nl',
     '0409:00000409',
     'nl-nl',
     '0409:00000409;0413:00020409',
     'en-us',
     'en',
     'NL',
     'en_US.UTF-8',
     'nl_NL.UTF-8',
     'nl',
     'Alt+Shift');
  INSERT INTO locale_profiles ("profile_name", "ms_system_locale", "ms_user_locale",
                               "ms_keyboard_locale", "ms_ui_language", "di_language", "di_country",
                               "di_locale", "di_supported_locales", "di_keymap", "di_toggle")
    VALUES
    ('en_ch',
     '0409:00000409',
     'de-ch',
     '0409:00000409;0807:00000807',
     'en-us',
     'en',
     'CH',
     'en_US.UTF-8',
     'de_CH.UTF-8',
     'ch',
     'Alt+Shift');
  INSERT INTO locale_profiles ("profile_name", "ms_system_locale", "ms_user_locale",
                               "ms_keyboard_locale", "ms_ui_language", "di_language", "di_country",
                               "di_locale", "di_supported_locales", "di_keymap", "di_toggle")
    VALUES
    ('en_de',
     '0409:00000409',
     'de-de',
     '0409:00000409;0407:00000407',
     'en-us',
     'en',
     'DE',
     'en_US.UTF-8',
     'de_DE.UTF-8',
     'de',
     'Alt+Shift');
  INSERT INTO locale_profiles ("profile_name", "ms_system_locale", "ms_user_locale",
                               "ms_keyboard_locale", "ms_ui_language", "di_language", "di_country",
                               "di_locale", "di_supported_locales", "di_keymap", "di_toggle")
    VALUES
    ('en_cn',
     '0409:00000409',
     'zh-cn',
     '0409:00000409;0804:{81D4E9C9-1D3B-41BC-9E6C-4B40BF79E35E}{FA550B04-5AD7-411f-A5AC-CA038EC515D7}',
     'en-us',
     'en',
     'CH',
     'en_US.UTF-8',
     'zh_CH.UTF-8',
     'cn',
     'Alt+Shift');
  INSERT INTO locale_profiles ("profile_name", "ms_system_locale", "ms_user_locale",
                               "ms_keyboard_locale", "ms_ui_language", "di_language", "di_country",
                               "di_locale", "di_supported_locales", "di_keymap", "di_toggle")
    VALUES
    ('en_kz',
     '0409:00000409',
     'kk-kz',
     '0409:00000409;043f:0000043f',
     'en-us',
     'en',
     'KZ',
     'en_US.UTF-8',
     'kk_KZ.UTF-8',
     'kz',
     'Alt+Shift');
  INSERT INTO locale_profiles ("profile_name", "ms_system_locale", "ms_user_locale",
                               "ms_keyboard_locale", "ms_ui_language", "di_language", "di_country",
                               "di_locale", "di_supported_locales", "di_keymap", "di_toggle")
    VALUES
    ('en_il',
     '0409:00000409',
     'he-il',
     '0409:00000409;040d:0002040d',
     'en-us',
     'en',
     'IL',
     'en_US.UTF-8',
     'he_IL.UTF-8',
     'il',
     'Alt+Shift');

COMMIT;

/* Страны, города и офисы */
BEGIN;
  SET SCHEMA 'deploy';

  INSERT INTO countries ("country_name", "default_locale", "code")
    SELECT 'Russia', id, 'RU' FROM locale_profiles WHERE profile_name = 'en_ru';
  INSERT INTO countries ("country_name", "default_locale", "code")
    SELECT 'Belarus', id, 'BY' FROM locale_profiles WHERE profile_name = 'en_by';
  INSERT INTO countries ("country_name", "default_locale", "code")
    SELECT 'Turkey', id, 'TR' FROM locale_profiles WHERE profile_name = 'en_tr';
  INSERT INTO countries ("country_name", "default_locale", "code")
    SELECT 'Finland', id, 'FI' FROM locale_profiles WHERE profile_name = 'en_fi';
  INSERT INTO countries ("country_name", "default_locale", "code")
    SELECT 'USA', id, 'US' FROM locale_profiles WHERE profile_name = 'en_us';
  INSERT INTO countries ("country_name", "default_locale", "code")
    SELECT 'Netherlands', id, 'NL' FROM locale_profiles WHERE profile_name = 'en_nl';
  INSERT INTO countries ("country_name", "default_locale", "code")
    SELECT 'Germany', id, 'DE' FROM locale_profiles WHERE profile_name = 'en_de';
  INSERT INTO countries ("country_name", "default_locale", "code")
    SELECT 'Switzerland', id, 'CH' FROM locale_profiles WHERE profile_name = 'en_ch';
  INSERT INTO countries ("country_name", "default_locale", "code")
    SELECT 'China', id, 'CN' FROM locale_profiles WHERE profile_name = 'en_cn';
  INSERT INTO countries ("country_name", "default_locale", "code")
    SELECT 'Kazakhstan', id, 'KZ' FROM locale_profiles WHERE profile_name = 'en_kz';
  INSERT INTO countries ("country_name", "default_locale", "code")
    SELECT 'Israel', id, 'IL' FROM locale_profiles WHERE profile_name = 'en_il';

  INSERT INTO cities ("city_name", "country", "timezone_ms", "timezone_unix")
    SELECT 'Moscow', id, 'Russian Standard Time', 'Europe/Moscow' FROM countries WHERE country_name = 'Russia';
  INSERT INTO cities ("city_name", "country", "timezone_ms", "timezone_unix")
    SELECT 'Saint Petersburg', id, 'Russian Standard Time', 'Europe/Moscow' FROM countries WHERE country_name = 'Russia';
  INSERT INTO cities ("city_name", "country", "timezone_ms", "timezone_unix")
    SELECT 'Bugrovskoe', id, 'Russian Standard Time', 'Europe/Moscow' FROM countries WHERE country_name = 'Russia';
  INSERT INTO cities ("city_name", "country", "timezone_ms", "timezone_unix")
    SELECT 'Yekaterinburg', id, 'Ekaterinburg Standard Time', 'Asia/Yekaterinburg' FROM countries WHERE country_name = 'Russia';
  INSERT INTO cities ("city_name", "country", "timezone_ms", "timezone_unix")
    SELECT 'Nizhny Novgorod', id, 'Russian Standard Time', 'Europe/Moscow' FROM countries WHERE country_name = 'Russia';
  INSERT INTO cities ("city_name", "country", "timezone_ms", "timezone_unix")
    SELECT 'Kstovo', id, 'Russian Standard Time', 'Europe/Moscow' FROM countries WHERE country_name = 'Russia';
  INSERT INTO cities ("city_name", "country", "timezone_ms", "timezone_unix")
    SELECT 'Novosibirsk', id, 'N. Central Asia Standard Time', 'Asia/Novosibirsk' FROM countries WHERE country_name = 'Russia';
  INSERT INTO cities ("city_name", "country", "timezone_ms", "timezone_unix")
    SELECT 'Kazan', id, 'Russian Standard Time', 'Europe/Moscow' FROM countries WHERE country_name = 'Russia';
  INSERT INTO cities ("city_name", "country", "timezone_ms", "timezone_unix")
    SELECT 'Sochi', id, 'Russian Standard Time', 'Europe/Moscow' FROM countries WHERE country_name = 'Russia';
  INSERT INTO cities ("city_name", "country", "timezone_ms", "timezone_unix")
    SELECT 'Voronezh', id, 'Russian Standard Time', 'Europe/Moscow' FROM countries WHERE country_name = 'Russia';
  INSERT INTO cities ("city_name", "country", "timezone_ms", "timezone_unix")
    SELECT 'Simferopol', id, 'Russian Standard Time', 'Europe/Simferopol' FROM countries WHERE country_name = 'Russia';
  INSERT INTO cities ("city_name", "country", "timezone_ms", "timezone_unix")
    SELECT 'Mytischi', id, 'Russian Standard Time', 'Europe/Moscow' FROM countries WHERE country_name = 'Russia';
  INSERT INTO cities ("city_name", "country", "timezone_ms", "timezone_unix")
    SELECT 'Ivanteevka', id, 'Russian Standard Time', 'Europe/Moscow' FROM countries WHERE country_name = 'Russia';
  INSERT INTO cities ("city_name", "country", "timezone_ms", "timezone_unix")
    SELECT 'Vladimir', id, 'Russian Standard Time', 'Europe/Moscow' FROM countries WHERE country_name = 'Russia';
  INSERT INTO cities ("city_name", "country", "timezone_ms", "timezone_unix")
    SELECT 'Sasovo', id, 'Russian Standard Time', 'Europe/Moscow' FROM countries WHERE country_name = 'Russia';
  INSERT INTO cities ("city_name", "country", "timezone_ms", "timezone_unix")
    SELECT 'Rostov-on-Don', id, 'Russian Standard Time', 'Europe/Moscow' FROM countries WHERE country_name = 'Russia';
  INSERT INTO cities ("city_name", "country", "timezone_ms", "timezone_unix")
    SELECT 'Krasnoyarsk', id, 'North Asia Standard Time', 'Asia/Krasnoyarsk' FROM countries WHERE country_name = 'Russia';
  INSERT INTO cities ("city_name", "country", "timezone_ms", "timezone_unix")
    SELECT 'Vladivostok', id, 'Vladivostok Standard Time', 'Asia/Vladivostok' FROM countries WHERE country_name = 'Russia';
  INSERT INTO cities ("city_name", "country", "timezone_ms", "timezone_unix")
    SELECT 'Perm', id, 'Ekaterinburg Standard Time', 'Asia/Yekaterinburg' FROM countries WHERE country_name = 'Russia';
  INSERT INTO cities ("city_name", "country", "timezone_ms", "timezone_unix")
    SELECT 'Ufa', id, 'Ekaterinburg Standard Time', 'Asia/Yekaterinburg' FROM countries WHERE country_name = 'Russia';
  INSERT INTO cities ("city_name", "country", "timezone_ms", "timezone_unix")
    SELECT 'Chelyabinsk', id, 'Ekaterinburg Standard Time', 'Asia/Yekaterinburg' FROM countries WHERE country_name = 'Russia';
  INSERT INTO cities ("city_name", "country", "timezone_ms", "timezone_unix")
    SELECT 'Samara', id, 'Russia Time Zone 3', 'Europe/Samara' FROM countries WHERE country_name = 'Russia';
  INSERT INTO cities ("city_name", "country", "timezone_ms", "timezone_unix")
    SELECT 'Tula', id, 'Russian Standard Time', 'Europe/Moscow' FROM countries WHERE country_name = 'Russia';
  INSERT INTO cities ("city_name", "country", "timezone_ms", "timezone_unix")
    SELECT 'Saratov', id, 'Saratov Standard Time', 'Europe/Saratov' FROM countries WHERE country_name = 'Russia';
  INSERT INTO cities ("city_name", "country", "timezone_ms", "timezone_unix")
    SELECT 'Tyumen', id, 'Ekaterinburg Standard Time', 'Asia/Yekaterinburg' FROM countries WHERE country_name = 'Russia';
  INSERT INTO cities ("city_name", "country", "timezone_ms", "timezone_unix")
    SELECT 'Krasnodar', id, 'Russian Standard Time', 'Europe/Moscow' FROM countries WHERE country_name = 'Russia';
  INSERT INTO cities ("city_name", "country", "timezone_ms", "timezone_unix")
    SELECT 'Istanbul', id, 'Turkey Standard Time', 'Europe/Istanbul' FROM countries WHERE country_name = 'Turkey';
  INSERT INTO cities ("city_name", "country", "timezone_ms", "timezone_unix")
    SELECT 'Mäntsälä', id, 'FLE Standard Time', 'Europe/Helsinki' FROM countries WHERE country_name = 'Finland';
  INSERT INTO cities ("city_name", "country", "timezone_ms", "timezone_unix")
    SELECT 'Lucerne', id, 'W. Europe Standard Time', 'Europe/Zurich' FROM countries WHERE country_name = 'Switzerland';
  INSERT INTO cities ("city_name", "country", "timezone_ms", "timezone_unix")
    SELECT 'Berlin', id, 'W. Europe Standard Time', 'Europe/Berlin' FROM countries WHERE country_name = 'Germany';
  INSERT INTO cities ("city_name", "country", "timezone_ms", "timezone_unix")
    SELECT 'Newburyport', id, 'Eastern Standard Time', 'America/New_York' FROM countries WHERE country_name = 'USA';
  INSERT INTO cities ("city_name", "country", "timezone_ms", "timezone_unix")
    SELECT 'Minsk', id, 'Belarus Standard Time', 'Europe/Minsk' FROM countries WHERE country_name = 'Belarus';
  INSERT INTO cities ("city_name", "country", "timezone_ms", "timezone_unix")
    SELECT 'Amsterdam', id, 'W. Europe Standard Time', 'Europe/Amsterdam' FROM countries WHERE country_name = 'Netherlands';
  INSERT INTO cities ("city_name", "country", "timezone_ms", "timezone_unix")
    SELECT 'Shanghai', id, 'China Standard Time', 'Asia/Shanghai' FROM countries WHERE country_name = 'China';
  INSERT INTO cities ("city_name", "country", "timezone_ms", "timezone_unix")
    SELECT 'Almaty', id, 'N. Central Asia Standard Time', 'Asia/Almaty' FROM countries WHERE country_name = 'Kazakhstan';
  INSERT INTO cities ("city_name", "country", "timezone_ms", "timezone_unix")
    SELECT 'Izhevsk', id, 'Russia Time Zone 3', 'Europe/Samara' FROM countries WHERE country_name = 'Russia';

  INSERT INTO offices ("office_name", "city")
    SELECT 'VPN', id FROM cities WHERE city_name = 'Moscow';
  INSERT INTO offices ("office_name", "city")
    SELECT 'Morozov BC', id FROM cities WHERE city_name = 'Moscow';
  INSERT INTO offices ("office_name", "city")
    SELECT 'Mamontov NOC Lab', id FROM cities WHERE city_name = 'Moscow';
  INSERT INTO offices ("office_name", "city")
    SELECT 'Mamontov BC', id FROM cities WHERE city_name = 'Moscow';
  INSERT INTO offices ("office_name", "city")
    SELECT 'Stroganov BC', id FROM cities WHERE city_name = 'Moscow';
  INSERT INTO offices ("office_name", "city")
    SELECT 'Aurora BC', id FROM cities WHERE city_name = 'Moscow';
  INSERT INTO offices ("office_name", "city")
    SELECT 'Zubovsky BC (Workki)', id FROM cities WHERE city_name = 'Moscow';
  INSERT INTO offices ("office_name", "city")
    SELECT 'City', id FROM cities WHERE city_name = 'Moscow';
  INSERT INTO offices ("office_name", "city")
    SELECT 'Neva BC', id FROM cities WHERE city_name = 'Moscow';
  INSERT INTO offices ("office_name", "city")
    SELECT 'Usacheva (Study)', id FROM cities WHERE city_name = 'Moscow';
  INSERT INTO offices ("office_name", "city")
    SELECT 'Zeleny TC', id FROM cities WHERE city_name = 'Moscow';
  INSERT INTO offices ("office_name", "city")
    SELECT 'Marata (Uber GLH)', id FROM cities WHERE city_name = 'Moscow';
  INSERT INTO offices ("office_name", "city")
    SELECT 'Mozhayka (Auto.ru)', id FROM cities WHERE city_name = 'Moscow';
  INSERT INTO offices ("office_name", "city")
    SELECT 'Berezhkovskaya (Taxi)', id FROM cities WHERE city_name = 'Moscow';
  INSERT INTO offices ("office_name", "city")
    SELECT 'Tomilino WH (Market)', id FROM cities WHERE city_name = 'Moscow';
  INSERT INTO offices ("office_name", "city")
    SELECT 'Sofino WH (Market)', id FROM cities WHERE city_name = 'Moscow';
  INSERT INTO offices ("office_name", "city")
    SELECT 'Sofino Super WH (A-B block)', id FROM cities WHERE city_name = 'Moscow';
  INSERT INTO offices ("office_name", "city")
    SELECT 'Sharapovo WH', id FROM cities WHERE city_name = 'Moscow';
  INSERT INTO offices ("office_name", "city")
    SELECT 'Shushary WH (Market)', id FROM cities WHERE city_name = 'Saint Petersburg';
  INSERT INTO offices ("office_name", "city")
    SELECT 'Mytischi DC', id FROM cities WHERE city_name = 'Mytischi';
  INSERT INTO offices ("office_name", "city")
    SELECT 'Ivanteevka DC', id FROM cities WHERE city_name = 'Ivanteevka';
  INSERT INTO offices ("office_name", "city")
    SELECT 'Vladimir DC', id FROM cities WHERE city_name = 'Vladimir';
  INSERT INTO offices ("office_name", "city")
    SELECT 'Sasovo DC', id FROM cities WHERE city_name = 'Sasovo';
  INSERT INTO offices ("office_name", "city")
    SELECT 'Mäntsälä DC', id FROM cities WHERE city_name = 'Mäntsälä';
  INSERT INTO offices ("office_name", "city")
    SELECT 'Benua BC', id FROM cities WHERE city_name = 'Saint Petersburg';
  INSERT INTO offices ("office_name", "city")
    SELECT 'Ferrum BC', id FROM cities WHERE city_name = 'Saint Petersburg';
  INSERT INTO offices ("office_name", "city")
    SELECT 'Palladium BC', id FROM cities WHERE city_name = 'Yekaterinburg';
  INSERT INTO offices ("office_name", "city")
    SELECT 'Greenwich BC', id FROM cities WHERE city_name = 'Novosibirsk';
  INSERT INTO offices ("office_name", "city")
    SELECT 'Technopark BC', id FROM cities WHERE city_name = 'Novosibirsk';
  INSERT INTO offices ("office_name", "city")
    SELECT 'Balance BC', id FROM cities WHERE city_name = 'Krasnoyarsk';
  INSERT INTO offices ("office_name", "city")
    SELECT 'Lobachevsky Plaza BC', id FROM cities WHERE city_name = 'Nizhny Novgorod';
  INSERT INTO offices ("office_name", "city")
    SELECT 'Suvar Plaza BC', id FROM cities WHERE city_name = 'Kazan';
  INSERT INTO offices ("office_name", "city")
    SELECT 'Innopolis', id FROM cities WHERE city_name = 'Kazan';
  INSERT INTO offices ("office_name", "city")
    SELECT 'Triumphal BC', id FROM cities WHERE city_name = 'Sochi';
  INSERT INTO offices ("office_name", "city")
    SELECT 'Galeon BC', id FROM cities WHERE city_name = 'Voronezh';
  INSERT INTO offices ("office_name", "city")
    SELECT 'Megion BC', id FROM cities WHERE city_name = 'Voronezh';
  INSERT INTO offices ("office_name", "city")
    SELECT 'Moskovskiy BC', id FROM cities WHERE city_name = 'Voronezh';
  INSERT INTO offices ("office_name", "city")
    SELECT 'Kazanskaya', id FROM cities WHERE city_name = 'Simferopol';
  INSERT INTO offices ("office_name", "city")
    SELECT 'Rubin Plaza BC', id FROM cities WHERE city_name = 'Minsk';
  INSERT INTO offices ("office_name", "city")
    SELECT 'Guards BC', id FROM cities WHERE city_name = 'Rostov-on-Don';
  INSERT INTO offices ("office_name", "city")
    SELECT 'Rostov-on-Don WH (Market)', id FROM cities WHERE city_name = 'Rostov-on-Don';
  INSERT INTO offices ("office_name", "city")
    SELECT 'Fresh Plaza BC', id FROM cities WHERE city_name = 'Vladivostok';
  INSERT INTO offices ("office_name", "city")
    SELECT 'Millennium BC', id FROM cities WHERE city_name = 'Samara';
  INSERT INTO offices ("office_name", "city")
    SELECT 'Samara SC', id FROM cities WHERE city_name = 'Samara';
  INSERT INTO offices ("office_name", "city")
    SELECT 'Bovid BC', id FROM cities WHERE city_name = 'Chelyabinsk';
  INSERT INTO offices ("office_name", "city")
    SELECT 'Admiral', id FROM cities WHERE city_name = 'Krasnodar';
  INSERT INTO offices ("office_name", "city")
    SELECT 'Alexandrovsky Passage BC', id FROM cities WHERE city_name = 'Ufa';
  INSERT INTO offices ("office_name", "city")
    SELECT 'Kolectif House Levent', id FROM cities WHERE city_name = 'Istanbul';
  INSERT INTO offices ("office_name", "city")
    SELECT 'Lucerne', id FROM cities WHERE city_name = 'Lucerne';
  INSERT INTO offices ("office_name", "city")
    SELECT 'Technology GmbH', id FROM cities WHERE city_name = 'Berlin';
  INSERT INTO offices ("office_name", "city")
    SELECT 'Newburyport', id FROM cities WHERE city_name = 'Newburyport';
  INSERT INTO offices ("office_name", "city")
    SELECT 'Dostyk BC', id FROM cities WHERE city_name = 'Almaty';
  INSERT INTO offices ("office_name", "city")
    SELECT 'Alliance BC', id FROM cities WHERE city_name = 'Tyumen';
  INSERT INTO offices ("office_name", "city")
    SELECT 'Troitskiy BC', id FROM cities WHERE city_name = 'Tula';
  INSERT INTO offices ("office_name", "city")
    SELECT 'Ulyanova', id FROM cities WHERE city_name = 'Nizhny Novgorod';
  INSERT INTO offices ("office_name", "city")
    SELECT 'Orbita BC', id FROM cities WHERE city_name = 'Nizhny Novgorod';
  INSERT INTO offices ("office_name", "city")
    SELECT 'Lotte Plaza', id FROM cities WHERE city_name = 'Moscow';
  INSERT INTO offices ("office_name", "city")
    SELECT 'Oko BC', id FROM cities WHERE city_name = 'Moscow';
  INSERT INTO offices ("office_name", "city")
    SELECT 'Amaltea BC', id FROM cities WHERE city_name = 'Moscow';
  INSERT INTO offices ("office_name", "city")
    SELECT 'Magnitogorskaya 21 SC', id FROM cities WHERE city_name = 'Saint Petersburg';
  INSERT INTO offices ("office_name", "city")
    SELECT 'Yekaterinburg WH', id FROM cities WHERE city_name = 'Yekaterinburg';
  INSERT INTO offices ("office_name", "city")
    SELECT 'Chertanovo Sorting Center', id FROM cities WHERE city_name = 'Moscow';
  INSERT INTO offices ("office_name", "city")
    SELECT 'Krasnodar Sorting Center', id FROM cities WHERE city_name = 'Krasnodar';
  INSERT INTO offices ("office_name", "city")
    SELECT 'Aspen Grove WH', id FROM cities WHERE city_name = 'Saint Petersburg';
  INSERT INTO offices ("office_name", "city")
    SELECT 'Samara WH', id FROM cities WHERE city_name = 'Samara';
  INSERT INTO offices ("office_name", "city")
    SELECT 'Novosibirsk WH', id FROM cities WHERE city_name = 'Novosibirsk';
  INSERT INTO offices ("office_name", "city")
    SELECT 'Kstovo SC', id FROM cities WHERE city_name = 'Kstovo';
  INSERT INTO offices ("office_name", "city")
    SELECT 'Bugry SC', id FROM cities WHERE city_name = 'Bugrovskoe';
  INSERT INTO offices ("office_name", "city")
    SELECT 'Skladochnaya SC', id FROM cities WHERE city_name = 'Moscow';
  INSERT INTO offices ("office_name", "city")
    SELECT 'Rostov-on-Don SC', id FROM cities WHERE city_name = 'Rostov-on-Don';
COMMIT;

/* Сети и серверы */
BEGIN;
  SET SCHEMA 'deploy';

  INSERT INTO networks ("net", "office")
    SELECT '2a02:6b8:0:410::/64', id FROM offices WHERE office_name = 'Morozov BC';
  INSERT INTO networks ("net", "office")
    SELECT '2a02:6b8:0:3200::/64', id FROM offices WHERE office_name = 'Mamontov BC';
  INSERT INTO networks ("net", "office")
    SELECT '2a02:6b8:0:d309::/64', id FROM offices WHERE office_name = 'Mamontov NOC Lab';
  INSERT INTO networks ("net", "office")
    SELECT '2a02:6b8:0:104::/64', id FROM offices WHERE office_name = 'Stroganov BC';
  INSERT INTO networks ("net", "office")
    SELECT '2a02:6b8:0:50e::/64', id FROM offices WHERE office_name = 'Aurora BC';
  INSERT INTO networks ("net", "office")
    SELECT '2a02:6b8:0:4d09::/64', id FROM offices WHERE office_name = 'Zubovsky BC (Workki)';
  INSERT INTO networks ("net", "office")
    SELECT '2a02:6b8:0:2f08::/64', id FROM offices WHERE office_name = 'Usacheva (Study)';
  INSERT INTO networks ("net", "office")
    SELECT '2a02:6b8:0:460a::/64', id FROM offices WHERE office_name = 'Usacheva (Study)';
  INSERT INTO networks ("net", "office")
    SELECT '2a02:6b8:0:2d0e::/64', id FROM offices WHERE office_name = 'Zeleny TC';
  INSERT INTO networks ("net", "office")
    SELECT '2a02:6b8:0:2609::/64', id FROM offices WHERE office_name = 'Marata (Uber GLH)';
  INSERT INTO networks ("net", "office")
    SELECT '2a02:6b8:0:2109::/64', id FROM offices WHERE office_name = 'Mozhayka (auto.ru)';
  INSERT INTO networks ("net", "office")
    SELECT '2a02:6b8:0:480a::/64', id FROM offices WHERE office_name = 'Berezhkovskaya (taxi)';
  INSERT INTO networks ("net", "office")
    SELECT '2a02:6b8:0:4f04::/64', id FROM offices WHERE office_name = 'Tomilino WH (Market)';
  INSERT INTO networks ("net", "office")
    SELECT '2a02:6b8:0:5419::/64', id FROM offices WHERE office_name = 'Sofino WH (Market)';
   INSERT INTO networks ("net", "office")
    SELECT '2a02:6b8:0:d610::/64', id FROM offices WHERE office_name = 'Sofino Super WH (A-B block)';
  INSERT INTO networks ("net", "office")
    SELECT '2a02:6b8:82:7b0a::/64', id FROM offices WHERE office_name = 'Sharapovo WH';
  INSERT INTO networks ("net", "office")
    SELECT '2a02:6b8:82:770a::/64', id FROM offices WHERE office_name = 'Shushary WH (Market)';
  INSERT INTO networks ("net", "office")
    SELECT '2a02:6b8:b010:e007::/64', id FROM offices WHERE office_name = 'Mytischi DC';
  INSERT INTO networks ("net", "office")
    SELECT '2a02:6b8:b012:1003::/64', id FROM offices WHERE office_name = 'Ivanteevka DC';
  INSERT INTO networks ("net", "office")
    SELECT '2a02:6b8:0:c006::/64', id FROM offices WHERE office_name = 'Vladimir DC';
  INSERT INTO networks ("net", "office")
    SELECT '2a02:6b8:0:2e0b::/64', id FROM offices WHERE office_name = 'Sasovo DC';
  INSERT INTO networks ("net", "office")
    SELECT '2a02:6b8:b010:c00a::/64', id FROM offices WHERE office_name = 'Mäntsälä DC';
  INSERT INTO networks ("net", "office")
    SELECT '2a02:6b8:0:2304::/64', id FROM offices WHERE office_name = 'Benua BC';
  INSERT INTO networks ("net", "office")
    SELECT '2a02:6b8:81:1105::/64', id FROM offices WHERE office_name = 'Ferrum BC';
  INSERT INTO networks ("net", "office")
    SELECT '2a02:6b8:81:1205::/64', id FROM offices WHERE office_name = 'Ferrum BC';
  INSERT INTO networks ("net", "office")
    SELECT '2a02:6b8:81:1305::/64', id FROM offices WHERE office_name = 'Ferrum BC';
  INSERT INTO networks ("net", "office")
    SELECT '2a02:6b8:81:1405::/64', id FROM offices WHERE office_name = 'Ferrum BC';
  INSERT INTO networks ("net", "office")
    SELECT '2a02:6b8:0:2801::/64', id FROM offices WHERE office_name = 'Palladium BC';
  INSERT INTO networks ("net", "office")
    SELECT '2a02:6b8:0:3309::/64', id FROM offices WHERE office_name = 'Greenwich BC';
  INSERT INTO networks ("net", "office")
    SELECT '2a02:6b8:0:3a06::/64', id FROM offices WHERE office_name = 'Technopark BC';
  INSERT INTO networks ("net", "office")
    SELECT '2a02:6b8:0:5309::/64', id FROM offices WHERE office_name = 'Balance BC';
  INSERT INTO networks ("net", "office")
    SELECT '2a02:6b8:0:3908::/64', id FROM offices WHERE office_name = 'Lobachevsky Plaza BC';
  INSERT INTO networks ("net", "office")
    SELECT '2a02:6b8:0:2703::/64', id FROM offices WHERE office_name = 'Suvar Plaza BC';
  INSERT INTO networks ("net", "office")
    SELECT '2a02:6b8:0:5209::/64', id FROM offices WHERE office_name = 'Innopolis';
  INSERT INTO networks ("net", "office")
    SELECT '2a02:6b8:0:450a::/64', id FROM offices WHERE office_name = 'Triumphal BC';
  INSERT INTO networks ("net", "office")
    SELECT '2a02:6b8:0:4408::/64', id FROM offices WHERE office_name = 'Galeon BC';
  INSERT INTO networks ("net", "office")
    SELECT '2a02:6b8:0:4609::/64', id FROM offices WHERE office_name = 'Megion BC';
  INSERT INTO networks ("net", "office")
    SELECT '2a02:6b8:0:5809::/64', id FROM offices WHERE office_name = 'Moskovskiy BC';
  INSERT INTO networks ("net", "office")
    SELECT '2a02:6b8:0:2904::/64', id FROM offices WHERE office_name = 'Kazanskaya';
  INSERT INTO networks ("net", "office")
    SELECT '2a02:6b8:0:3606::/64', id FROM offices WHERE office_name = 'Guards BC';
  INSERT INTO networks ("net", "office")
    SELECT '2a02:6b8:0:3509::/64', id FROM offices WHERE office_name = 'Rubin Plaza BC';
  INSERT INTO networks ("net", "office")
    SELECT '2a02:6b8:0:4904::/64', id FROM offices WHERE office_name = 'Rostov-on-Don WH (Market)';
  INSERT INTO networks ("net", "office")
    SELECT '2a02:6b8:0:4a0a::/64', id FROM offices WHERE office_name = 'Fresh Plaza BC';
  INSERT INTO networks ("net", "office")
    SELECT '2a02:6b8:0:4b09::/64', id FROM offices WHERE office_name = 'Millennium BC';
  INSERT INTO networks ("net", "office")
    SELECT '2a02:6b8:0:4c0a::/64', id FROM offices WHERE office_name = 'Bovid BC';
  INSERT INTO networks ("net", "office")
    SELECT '2a02:6b8:0:5009::/64', id FROM offices WHERE office_name = 'Admiral';
  INSERT INTO networks ("net", "office")
    SELECT '2a02:6b8:0:5109::/64', id FROM offices WHERE office_name = 'Alexandrovsky Passage BC';
  INSERT INTO networks ("net", "office")
    SELECT '2a02:6b8:0:2a0e::/64', id FROM offices WHERE office_name = 'Kolectif House Levent';
  INSERT INTO networks ("net", "office")
    SELECT '2a02:6b8:0:3805::/64', id FROM offices WHERE office_name = 'Lucerne';
  INSERT INTO networks ("net", "office")
    SELECT '2a02:6b8:0:3b07::/64', id FROM offices WHERE office_name = 'Technology GmbH';
  INSERT INTO networks ("net", "office")
    SELECT '2620:10f:d000:306::/64', id FROM offices WHERE office_name = 'Newburyport';
  INSERT INTO networks ("net", "office")
    SELECT '2a02:6b8:0:4e09::/64', id FROM offices WHERE office_name = 'Dostyk BC';
  INSERT INTO networks ("net", "office")
    SELECT '2a02:6b8:0:5508::/64', id FROM offices WHERE office_name = 'Alliance BC';
  INSERT INTO networks ("net", "office")
    SELECT '2a02:6b8:0:5709::/64', id FROM offices WHERE office_name = 'Troitskiy BC';
  INSERT INTO networks ("net", "office")
    SELECT '2a02:6b8:0:5a09::/64', id FROM offices WHERE office_name = 'City';
  INSERT INTO networks ("net", "office")
    SELECT '2a02:6b8:82:d008::/64', id FROM offices WHERE office_name = 'Neva BC';
  INSERT INTO networks ("net", "office")
    SELECT '2a02:6b8:82:d108::/64', id FROM offices WHERE office_name = 'Neva BC';
  INSERT INTO networks ("net", "office")
    SELECT '2a02:6b8:82:d208::/64', id FROM offices WHERE office_name = 'Neva BC';
  INSERT INTO networks ("net", "office")
    SELECT '2a02:6b8:82:d308::/64', id FROM offices WHERE office_name = 'Neva BC';
  INSERT INTO networks ("net", "office")
    SELECT '2a02:6b8:82:d408::/64', id FROM offices WHERE office_name = 'Neva BC';
  INSERT INTO networks ("net", "office")
    SELECT '2a02:6b8:b080::/44', id FROM offices WHERE office_name = 'VPN';
  INSERT INTO networks ("net", "office")
    SELECT '2a02:6b8:0:f09::/64', id FROM offices WHERE office_name = 'Ulyanova';
  INSERT INTO networks ("net", "office")
    SELECT '2a02:6b8:0:5c09::/64', id FROM offices WHERE office_name = 'Orbita BC';
  INSERT INTO networks ("net", "office")
    SELECT '2a02:6b8:0:6105::/64', id FROM offices WHERE office_name = 'Lotte Plaza';
  INSERT INTO networks ("net", "office")
    SELECT '2a02:6b8:0:6205::/64', id FROM offices WHERE office_name = 'Lotte Plaza';
  INSERT INTO networks ("net", "office")
    SELECT '2a02:6b8:0:6305::/64', id FROM offices WHERE office_name = 'Lotte Plaza';
  INSERT INTO networks ("net", "office")
    SELECT '2a02:6b8:0:6405::/64', id FROM offices WHERE office_name = 'Lotte Plaza';
  INSERT INTO networks ("net", "office")
    SELECT '2a02:6b8:0:6505::/64', id FROM offices WHERE office_name = 'Lotte Plaza';
  INSERT INTO networks ("net", "office")
    SELECT '2a02:6b8:0:6005::/64', id FROM offices WHERE office_name = 'Lotte Plaza';
  INSERT INTO networks ("net", "office")
    SELECT '2a02:6b8:0:7008::/64', id FROM offices WHERE office_name = 'Oko BC';
  INSERT INTO networks ("net", "office")
    SELECT '2a02:6b8:0:7108::/64', id FROM offices WHERE office_name = 'Oko BC';
  INSERT INTO networks ("net", "office")
    SELECT '2a02:6b8:0:7208::/64', id FROM offices WHERE office_name = 'Oko BC';
  INSERT INTO networks ("net", "office")
    SELECT '2a02:6b8:0:7308::/64', id FROM offices WHERE office_name = 'Oko BC';
  INSERT INTO networks ("net", "office")
    SELECT '2a02:6b8:0:7408::/64', id FROM offices WHERE office_name = 'Oko BC';
  INSERT INTO networks ("net", "office")
    SELECT '2a02:6b8:0:7508::/64', id FROM offices WHERE office_name = 'Oko BC';
  INSERT INTO networks ("net", "office")
    SELECT '2a02:6b8:0:e005::/64', id FROM offices WHERE office_name = 'Amaltea BC';
  INSERT INTO networks ("net", "office")
    SELECT '2a02:6b8:0:e105::/64', id FROM offices WHERE office_name = 'Amaltea BC';
  INSERT INTO networks ("net", "office")
    SELECT '2a02:6b8:0:e205::/64', id FROM offices WHERE office_name = 'Amaltea BC';
  INSERT INTO networks ("net", "office")
    SELECT '2a02:6b8:0:5b09::/64', id FROM offices WHERE office_name = 'Magnitogorskaya 21 SC';
  INSERT INTO networks ("net", "office")
    SELECT '2a02:6b8:0:d20d::/64', id FROM offices WHERE office_name = 'Yekaterinburg WH';
  INSERT INTO networks ("net", "office")
    SELECT '2a02:6b8:0:2a0b::/64', id FROM offices WHERE office_name = 'Chertanovo Sorting Center';
  INSERT INTO networks ("net", "office")
    SELECT '2a02:6b8:0:4d0d::/64', id FROM offices WHERE office_name = 'Krasnodar Sorting Center';
  INSERT INTO networks ("net", "office")
    SELECT '2a02:6b8:0:d508::/64', id FROM offices WHERE office_name = 'Aspen Grove WH';
  INSERT INTO networks ("net", "office")
    SELECT '2a02:6b8:0:d40d::/64', id FROM offices WHERE office_name = 'Samara WH';
  INSERT INTO networks ("net", "office")
    SELECT '2a02:6b8:82:30a::/64', id FROM offices WHERE office_name = 'Samara SC';
  INSERT INTO networks ("net", "office")
    SELECT '2a02:6b8:0:dd0d::/64', id FROM offices WHERE office_name = 'Novosibirsk WH';
  INSERT INTO networks ("net", "office")
    SELECT '2a02:6b8:0:2f0a::/64', id FROM offices WHERE office_name = 'Kstovo SC';
  INSERT INTO networks ("net", "office")
    SELECT '2a02:6b8:82:7908::/64', id FROM offices WHERE office_name = 'Skladochnaya SC';
  INSERT INTO networks ("net", "office")
    SELECT '2a02:6b8:0:4108::/64', id FROM offices WHERE office_name = 'Rostov-on-Don SC';
  INSERT INTO networks ("net", "office")
    SELECT '2a02:6b8:82:7a0a::/64', id FROM offices WHERE office_name = 'Bugry SC';


  INSERT INTO servers ("id", "fqdn", "share_path", "is_enabled")
    VALUES (DEFAULT, 'dp-msk-kr01.baldr.yandex.net', 'ds$', true);
  INSERT INTO servers ("id", "fqdn", "share_path", "is_enabled")
    VALUES (DEFAULT, 'baldr-spb.yandex-team.ru', 'ds$', true);
  INSERT INTO servers ("id", "fqdn", "share_path", "is_enabled")
    VALUES (DEFAULT, 'baldr-ekb2.yandex-team.ru', 'ds$', true);
  INSERT INTO servers ("id", "fqdn", "share_path", "is_enabled")
    VALUES (DEFAULT, 'baldr-nnov2.yandex-team.ru', 'ds$', true);
  INSERT INTO servers ("id", "fqdn", "share_path", "is_enabled")
    VALUES (DEFAULT, 'dp-minsk-01.baldr.yandex.net', 'ds$', true);
  INSERT INTO servers ("id", "fqdn", "share_path", "is_enabled")
    VALUES (DEFAULT, 'baldr-simf.yandex-team.ru', 'ds$', true);
  INSERT INTO servers ("id", "fqdn", "share_path", "is_enabled")
    VALUES (DEFAULT, 'baldr-nsk.yandex-team.ru', 'ds$', true);
  INSERT INTO servers ("id", "fqdn", "share_path", "is_enabled")
    VALUES (DEFAULT, 'baldr-sochi.yandex-team.ru', 'ds$', true);
  INSERT INTO servers ("id", "fqdn", "share_path", "is_enabled")
    VALUES (DEFAULT, 'baldr-vrn.yandex-team.ru', 'ds$', true);
  INSERT INTO servers ("id", "fqdn", "share_path", "is_enabled")
    VALUES (DEFAULT, 'baldr-kazan.yandex-team.ru', 'ds$', true);
  INSERT INTO servers ("id", "fqdn", "share_path", "is_enabled")
    VALUES (DEFAULT, 'rostov.baldr.yandex.net', 'ds$', true);
  INSERT INTO servers ("id", "fqdn", "share_path", "is_enabled")
    VALUES (DEFAULT, 'technopark.baldr.yandex.net', 'ds$', true);
  INSERT INTO servers ("id", "fqdn", "share_path", "is_enabled")
    VALUES (DEFAULT, 'dev-msk.baldr.yandex.net', 'ds$', true);
  INSERT INTO servers ("id", "fqdn", "share_path", "is_enabled")
    VALUES (DEFAULT, 'baldr1.yandex-team.ru', 'DeploymentShare$', false);
  INSERT INTO servers ("id", "fqdn", "share_path", "is_enabled")
    VALUES (DEFAULT, 'dp-nnov-ulyanova-01.baldr.yandex.net', 'ds$', true);
  INSERT INTO servers ("id", "fqdn", "share_path", "is_enabled")
    VALUES (DEFAULT, 'dp-nnov-orbita-01.baldr.yandex.net', 'ds$', true);
  INSERT INTO servers ("id", "fqdn", "share_path", "is_enabled")
    VALUES (DEFAULT, 'dp-vrn-megion.baldr.yandex.net', 'ds$', true);
  INSERT INTO servers ("id", "fqdn", "share_path", "is_enabled")
    VALUES (DEFAULT, 'dp-tula-troitsky01.baldr.yandex.net', 'ds$', true);
  INSERT INTO servers ("id", "fqdn", "share_path", "is_enabled")
    VALUES (DEFAULT, 'dp-sharapovo-wh01.baldr.yandex.net', 'ds$', true);
  INSERT INTO servers ("id", "fqdn", "share_path", "is_enabled")
    VALUES (DEFAULT, 'dp-myt-dc01.baldr.yandex.net', 'ds$', true);
COMMIT;

BEGIN;
  SET SCHEMA 'deploy';

  INSERT INTO offices_servers(office, server)
    SELECT o.id, s.id FROM offices AS o, servers AS s
    WHERE o.office_name = 'Morozov BC' AND s.fqdn = 'dp-msk-kr01.baldr.yandex.net';
  INSERT INTO offices_servers(office, server)
    SELECT o.id, s.id FROM offices AS o, servers AS s
    WHERE o.office_name = 'Mamontov BC' AND s.fqdn = 'dp-msk-kr01.baldr.yandex.net';
  INSERT INTO offices_servers(office, server)
    SELECT o.id, s.id FROM offices AS o, servers AS s
    WHERE o.office_name = 'Mamontov NOC Lab' AND s.fqdn = 'dp-msk-kr01.baldr.yandex.net';
  INSERT INTO offices_servers(office, server)
    SELECT o.id, s.id FROM offices AS o, servers AS s
    WHERE o.office_name = 'Stroganov BC' AND s.fqdn = 'dp-msk-kr01.baldr.yandex.net';
  INSERT INTO offices_servers(office, server)
    SELECT o.id, s.id FROM offices AS o, servers AS s
    WHERE o.office_name = 'Aurora BC' AND s.fqdn = 'dp-msk-kr01.baldr.yandex.net';
  INSERT INTO offices_servers(office, server)
    SELECT o.id, s.id FROM offices AS o, servers AS s
    WHERE o.office_name = 'Lotte Plaza' AND s.fqdn = 'dp-msk-kr01.baldr.yandex.net';
  INSERT INTO offices_servers(office, server)
    SELECT o.id, s.id FROM offices AS o, servers AS s
    WHERE o.office_name = 'Oko BC' AND s.fqdn = 'dp-msk-kr01.baldr.yandex.net';
  INSERT INTO offices_servers(office, server)
    SELECT o.id, s.id FROM offices AS o, servers AS s
    WHERE o.office_name = 'City' AND s.fqdn = 'dp-msk-kr01.baldr.yandex.net';
  INSERT INTO offices_servers(office, server)
    SELECT o.id, s.id FROM offices AS o, servers AS s
    WHERE o.office_name = 'Neva BC' AND s.fqdn = 'dp-msk-kr01.baldr.yandex.net';
  INSERT INTO offices_servers(office, server)
    SELECT o.id, s.id FROM offices AS o, servers AS s
    WHERE o.office_name = 'Amaltea BC' AND s.fqdn = 'dp-msk-kr01.baldr.yandex.net';
  INSERT INTO offices_servers(office, server)
    SELECT o.id, s.id FROM offices AS o, servers AS s
    WHERE o.office_name = 'Sasovo DC' AND s.fqdn = 'dp-msk-kr01.baldr.yandex.net';
  INSERT INTO offices_servers(office, server)
    SELECT o.id, s.id FROM offices AS o, servers AS s
    WHERE o.office_name = 'Vladimir DC' AND s.fqdn = 'dp-msk-kr01.baldr.yandex.net';
  INSERT INTO offices_servers(office, server)
    SELECT o.id, s.id FROM offices AS o, servers AS s
    WHERE o.office_name = 'Mytischi DC' AND s.fqdn = 'dp-myt-dc01.baldr.yandex.net';
  INSERT INTO offices_servers(office, server)
    SELECT o.id, s.id FROM offices AS o, servers AS s
    WHERE o.office_name = 'Zubovsky BC (Workki)' AND s.fqdn = 'dp-msk-kr01.baldr.yandex.net';
  INSERT INTO offices_servers(office, server)
    SELECT o.id, s.id FROM offices AS o, servers AS s
    WHERE o.office_name = 'Zeleny TC' AND s.fqdn = 'dp-msk-kr01.baldr.yandex.net';
  INSERT INTO offices_servers(office, server)
    SELECT o.id, s.id FROM offices AS o, servers AS s
    WHERE o.office_name = 'Yekaterinburg WH' AND s.fqdn = 'dp-msk-kr01.baldr.yandex.net';
  INSERT INTO offices_servers(office, server)
    SELECT o.id, s.id FROM offices AS o, servers AS s
    WHERE o.office_name = 'Tomilino WH (Market)' AND s.fqdn = 'dp-msk-kr01.baldr.yandex.net';
  INSERT INTO offices_servers(office, server)
    SELECT o.id, s.id FROM offices AS o, servers AS s
    WHERE o.office_name = 'Sofino WH (Market)' AND s.fqdn = 'dp-msk-kr01.baldr.yandex.net';
  INSERT INTO offices_servers(office, server)
    SELECT o.id, s.id FROM offices AS o, servers AS s
    WHERE o.office_name = 'Sofino Super WH (A-B block)' AND s.fqdn = 'dp-msk-kr01.baldr.yandex.net';
  INSERT INTO offices_servers(office, server)
    SELECT o.id, s.id FROM offices AS o, servers AS s
    WHERE o.office_name = 'Sharapovo WH' AND s.fqdn = 'dp-sharapovo-wh01.baldr.yandex.net';
  INSERT INTO offices_servers(office, server)
    SELECT o.id, s.id FROM offices AS o, servers AS s
    WHERE o.office_name = 'Dostyk BC' AND s.fqdn = 'dp-msk-kr01.baldr.yandex.net';
  INSERT INTO offices_servers(office, server)
    SELECT o.id, s.id FROM offices AS o, servers AS s
    WHERE o.office_name = 'Magnitogorskaya 21 SC' AND s.fqdn = 'baldr-spb.yandex-team.ru';
  INSERT INTO offices_servers(office, server)
    SELECT o.id, s.id FROM offices AS o, servers AS s
    WHERE o.office_name = 'Shushary WH (Market)' AND s.fqdn = 'baldr-spb.yandex-team.ru';
  INSERT INTO offices_servers(office, server)
    SELECT o.id, s.id FROM offices AS o, servers AS s
    WHERE o.office_name = 'Benua BC' AND s.fqdn = 'baldr-spb.yandex-team.ru';
  INSERT INTO offices_servers(office, server)
    SELECT o.id, s.id FROM offices AS o, servers AS s
    WHERE o.office_name = 'Ferrum BC' AND s.fqdn = 'baldr-spb.yandex-team.ru';
  INSERT INTO offices_servers(office, server)
    SELECT o.id, s.id FROM offices AS o, servers AS s
    WHERE o.office_name = 'Mäntsälä DC' AND s.fqdn = 'baldr-spb.yandex-team.ru';
  INSERT INTO offices_servers(office, server)
    SELECT o.id, s.id FROM offices AS o, servers AS s
    WHERE o.office_name = 'Rubin Plaza BC' AND s.fqdn = 'dp-minsk-01.baldr.yandex.net';
  INSERT INTO offices_servers(office, server)
    SELECT o.id, s.id FROM offices AS o, servers AS s
    WHERE o.office_name = 'Palladium BC' AND s.fqdn = 'baldr-ekb2.yandex-team.ru';
  INSERT INTO offices_servers(office, server)
    SELECT o.id, s.id FROM offices AS o, servers AS s
    WHERE o.office_name = 'Lobachevsky Plaza BC' AND s.fqdn = 'baldr-nnov2.yandex-team.ru';
  INSERT INTO offices_servers(office, server)
    SELECT o.id, s.id FROM offices AS o, servers AS s
    WHERE o.office_name = 'Ulyanova' AND s.fqdn = 'dp-nnov-ulyanova-01.baldr.yandex.net';
  INSERT INTO offices_servers(office, server)
    SELECT o.id, s.id FROM offices AS o, servers AS s
    WHERE o.office_name = 'Orbita BC' AND s.fqdn = 'dp-nnov-orbita-01.baldr.yandex.net';
  INSERT INTO offices_servers(office, server)
    SELECT o.id, s.id FROM offices AS o, servers AS s
    WHERE o.office_name = 'Triumphal BC' AND s.fqdn = 'baldr-sochi.yandex-team.ru';
  INSERT INTO offices_servers(office, server)
    SELECT o.id, s.id FROM offices AS o, servers AS s
    WHERE o.office_name = 'Galeon BC' AND s.fqdn = 'baldr-vrn.yandex-team.ru';
  INSERT INTO offices_servers(office, server)
    SELECT o.id, s.id FROM offices AS o, servers AS s
    WHERE o.office_name = 'Megion BC' AND s.fqdn = 'dp-vrn-megion.baldr.yandex.net';
  INSERT INTO offices_servers(office, server)
    SELECT o.id, s.id FROM offices AS o, servers AS s
    WHERE o.office_name = 'Moskovskiy BC' AND s.fqdn = 'baldr-vrn.yandex-team.ru';
  INSERT INTO offices_servers(office, server)
    SELECT o.id, s.id FROM offices AS o, servers AS s
    WHERE o.office_name = 'Suvar Plaza BC' AND s.fqdn = 'baldr-kazan.yandex-team.ru';
  INSERT INTO offices_servers(office, server)
    SELECT o.id, s.id FROM offices AS o, servers AS s
    WHERE o.office_name = 'Greenwich BC' AND s.fqdn = 'baldr-nsk.yandex-team.ru';
  INSERT INTO offices_servers(office, server)
    SELECT o.id, s.id FROM offices AS o, servers AS s
    WHERE o.office_name = 'Technopark BC' AND s.fqdn = 'technopark.baldr.yandex.net';
  INSERT INTO offices_servers(office, server)
    SELECT o.id, s.id FROM offices AS o, servers AS s
    WHERE o.office_name = 'Kazanskaya' AND s.fqdn = 'baldr-simf.yandex-team.ru';
  INSERT INTO offices_servers(office, server)
    SELECT o.id, s.id FROM offices AS o, servers AS s
    WHERE o.office_name = 'Guards BC' AND s.fqdn = 'rostov.baldr.yandex.net';
  INSERT INTO offices_servers(office, server)
    SELECT o.id, s.id FROM offices AS o, servers AS s
    WHERE o.office_name = 'Rostov-on-Don WH (Market)' AND s.fqdn = 'rostov.baldr.yandex.net';
  INSERT INTO offices_servers(office, server)
    SELECT o.id, s.id FROM offices AS o, servers AS s
    WHERE o.office_name = 'Chertanovo Sorting Center' AND s.fqdn = 'dp-msk-kr01.baldr.yandex.net';
  INSERT INTO offices_servers(office, server)
    SELECT o.id, s.id FROM offices AS o, servers AS s
    WHERE o.office_name = 'Krasnodar Sorting Center' AND s.fqdn = 'dp-msk-kr01.baldr.yandex.net';
  INSERT INTO offices_servers(office, server)
    SELECT o.id, s.id FROM offices AS o, servers AS s
    WHERE o.office_name = 'Aspen Grove WH' AND s.fqdn = 'baldr-spb.yandex-team.ru';
  INSERT INTO offices_servers(office, server)
    SELECT o.id, s.id FROM offices AS o, servers AS s
    WHERE o.office_name = 'Samara WH' AND s.fqdn = 'dp-msk-kr01.baldr.yandex.net';
  INSERT INTO offices_servers(office, server)
    SELECT o.id, s.id FROM offices AS o, servers AS s
    WHERE o.office_name = 'Samara SC' AND s.fqdn = 'dp-msk-kr01.baldr.yandex.net';
  INSERT INTO offices_servers(office, server)
    SELECT o.id, s.id FROM offices AS o, servers AS s
    WHERE o.office_name = 'Novosibirsk WH' AND s.fqdn = 'dp-msk-kr01.baldr.yandex.net';
  INSERT INTO offices_servers(office, server)
    SELECT o.id, s.id FROM offices AS o, servers AS s
    WHERE o.office_name = 'Kstovo SC' AND s.fqdn = 'dp-msk-kr01.baldr.yandex.net';
  INSERT INTO offices_servers(office, server)
    SELECT o.id, s.id FROM offices AS o, servers AS s
    WHERE o.office_name = 'Skladochnaya SC' AND s.fqdn = 'dp-msk-kr01.baldr.yandex.net';
  INSERT INTO offices_servers(office, server)
    SELECT o.id, s.id FROM offices AS o, servers AS s
    WHERE o.office_name = 'Bugry SC' AND s.fqdn = 'baldr-spb.yandex-team.ru';
  INSERT INTO offices_servers(office, server)
    SELECT o.id, s.id FROM offices AS o, servers AS s
    WHERE o.office_name = 'Troitskiy BC' AND s.fqdn = 'dp-tula-troitsky01.baldr.yandex.net';
  INSERT INTO offices_servers(office, server)
    SELECT o.id, s.id FROM offices AS o, servers AS s
    WHERE o.office_name = 'Rostov-on-Don SC' AND s.fqdn = 'rostov.baldr.yandex.net';
  INSERT INTO offices_servers(office, server)
    SELECT o.id, s.id FROM offices AS o, servers AS s
    WHERE o.office_name = 'VPN' AND s.fqdn = 'dp-msk-kr01.baldr.yandex.net';

COMMIT;

/* Операционные системы и их версии */
BEGIN;
  SET SCHEMA 'deploy';

  INSERT INTO supported_os ("id", "os_name")
    VALUES (DEFAULT, 'Linux');
  INSERT INTO supported_os ("id", "os_name")
    VALUES (DEFAULT, 'Windows 7');
  INSERT INTO supported_os ("id", "os_name")
    VALUES (DEFAULT, 'Windows 8.1');
  INSERT INTO supported_os ("id", "os_name")
    VALUES (DEFAULT, 'Windows 10');
  INSERT INTO supported_os ("id", "os_name")
    VALUES (DEFAULT, 'Windows 11');
COMMIT;

BEGIN;
  SET SCHEMA 'deploy';

  INSERT INTO os_versions (os, os_build, os_updated, os_edition, os_version, os_arch, release_date, is_default, product_key)
    SELECT id, 'SP1', 'May 2011', 'Enterprise', '6.1.7601.17514', 'amd64', '2011-05-12', true , '33PXH-7Y6KF-2VJC9-XBBR8-HVTHH'
      FROM supported_os WHERE os_name = 'Windows 7';
  INSERT INTO os_versions (os, os_build, os_updated, os_edition, os_version, os_arch, release_date, is_default, product_key)
    SELECT id, 'with Update', 'Dec 2014', 'Enterprise', '6.3.9600.17415', 'amd64', '2014-12-15', true , 'MHF9N-XY6XB-WVXMC-BTDCT-MKKG7'
      FROM supported_os WHERE os_name = 'Windows 8.1';
  INSERT INTO os_versions (os, os_build, os_updated, os_edition, os_version, os_arch, release_date, is_default, product_key)
    SELECT id, '1507', 'Jul 2015', 'Enterprise', '10.0.10240.16384', 'amd64', '2015-07-28', false , 'NPPR9-FWDCX-D2C8J-H872K-2YT43'
      FROM supported_os WHERE os_name = 'Windows 10';
  INSERT INTO os_versions (os, os_build, os_updated, os_edition, os_version, os_arch, release_date, is_default, product_key)
    SELECT id, '1511', 'Nov 2015', 'Enterprise', '10.0.10586.0', 'amd64', '2015-11-12', false , 'NPPR9-FWDCX-D2C8J-H872K-2YT43'
      FROM supported_os WHERE os_name = 'Windows 10';
  INSERT INTO os_versions (os, os_build, os_updated, os_edition, os_version, os_arch, release_date, is_default, product_key)
    SELECT id, '1511', 'Feb 2016', 'Enterprise', '10.0.10586.104', 'amd64', '2016-03-04', false , 'NPPR9-FWDCX-D2C8J-H872K-2YT43'
      FROM supported_os WHERE os_name = 'Windows 10';
  INSERT INTO os_versions (os, os_build, os_updated, os_edition, os_version, os_arch, release_date, is_default, product_key)
    SELECT id, '1511', 'Apr 2016', 'Enterprise', '10.0.10586.164', 'amd64', '2016-05-23', false , 'NPPR9-FWDCX-D2C8J-H872K-2YT43'
      FROM supported_os WHERE os_name = 'Windows 10';
  INSERT INTO os_versions (os, os_build, os_updated, os_edition, os_version, os_arch, release_date, is_default, product_key)
    SELECT id, '1607', 'Jan 2017', 'Enterprise', '10.0.14393.447', 'amd64', '2017-01-19', false , 'NPPR9-FWDCX-D2C8J-H872K-2YT43'
      FROM supported_os WHERE os_name = 'Windows 10';
  INSERT INTO os_versions (os, os_build, os_updated, os_edition, os_version, os_arch, release_date, is_default, product_key)
    SELECT id, '1703', 'Mar 2017', 'Enterprise', '10.0.15063.0', 'amd64', '2017-04-05', false , 'NPPR9-FWDCX-D2C8J-H872K-2YT43'
      FROM supported_os WHERE os_name = 'Windows 10';
  INSERT INTO os_versions (os, os_build, os_updated, os_edition, os_version, os_arch, release_date, is_default, product_key)
    SELECT id, '1703', 'Jun 2017', 'Enterprise', '10.0.15063.413', 'amd64', '2017-06-22', false , 'NPPR9-FWDCX-D2C8J-H872K-2YT43'
      FROM supported_os WHERE os_name = 'Windows 10';
  INSERT INTO os_versions (os, os_build, os_updated, os_edition, os_version, os_arch, release_date, is_default, product_key)
    SELECT id, '1703', 'Jul 2017', 'Enterprise', '10.0.15063.483', 'amd64', '2017-07-27', false , 'NPPR9-FWDCX-D2C8J-H872K-2YT43'
      FROM supported_os WHERE os_name = 'Windows 10';
  INSERT INTO os_versions (os, os_build, os_updated, os_edition, os_version, os_arch, release_date, is_default, product_key)
    SELECT id, '1709', 'Sep 2017', 'Enterprise', '10.0.16299.15', 'amd64', '2017-10-17', false , 'NPPR9-FWDCX-D2C8J-H872K-2YT43'
      FROM supported_os WHERE os_name = 'Windows 10';
  INSERT INTO os_versions (os, os_build, os_updated, os_edition, os_version, os_arch, release_date, is_default, product_key)
    SELECT id, '1709', 'Nov 2017', 'Enterprise', '10.0.16299.64', 'amd64', '2017-11-28', false , 'NPPR9-FWDCX-D2C8J-H872K-2YT43'
      FROM supported_os WHERE os_name = 'Windows 10';
  INSERT INTO os_versions (os, os_build, os_updated, os_edition, os_version, os_arch, release_date, is_default, product_key)
    SELECT id, '1709', 'Dec 2017', 'Enterprise', '10.0.16299.125', 'amd64', '2017-12-19', false , 'NPPR9-FWDCX-D2C8J-H872K-2YT43'
      FROM supported_os WHERE os_name = 'Windows 10';
  INSERT INTO os_versions (os, os_build, os_updated, os_edition, os_version, os_arch, release_date, is_default, product_key)
    SELECT id, '1803', 'Mar 2018', 'Enterprise', '10.0.17134.1', 'amd64', '2018-04-30', false , 'NPPR9-FWDCX-D2C8J-H872K-2YT43'
      FROM supported_os WHERE os_name = 'Windows 10';
  INSERT INTO os_versions (os, os_build, os_updated, os_edition, os_version, os_arch, release_date, is_default, product_key)
    SELECT id, '1803', 'Jul 2018', 'Enterprise', '10.0.17134.112', 'amd64', '2018-07-10', false , 'NPPR9-FWDCX-D2C8J-H872K-2YT43'
      FROM supported_os WHERE os_name = 'Windows 10';
  INSERT INTO os_versions (os, os_build, os_updated, os_edition, os_version, os_arch, release_date, is_default, product_key)
    SELECT id, '1803', 'Aug 2018', 'Enterprise', '10.0.17134.228', 'amd64', '2018-08-22', false , 'NPPR9-FWDCX-D2C8J-H872K-2YT43'
      FROM supported_os WHERE os_name = 'Windows 10';
  INSERT INTO os_versions (os, os_build, os_updated, os_edition, os_version, os_arch, release_date, is_default, product_key)
    SELECT id, '1803', 'Sep 2018', 'Enterprise', '10.0.17134.285', 'amd64', '2018-09-19', false , 'NPPR9-FWDCX-D2C8J-H872K-2YT43'
      FROM supported_os WHERE os_name = 'Windows 10';
  INSERT INTO os_versions (os, os_build, os_updated, os_edition, os_version, os_arch, release_date, is_default, product_key)
    SELECT id, '1803', 'Jan 2019', 'Enterprise', '10.0.17134.523', 'amd64', '2019-01-15', false , 'NPPR9-FWDCX-D2C8J-H872K-2YT43'
      FROM supported_os WHERE os_name = 'Windows 10';
  INSERT INTO os_versions (os, os_build, os_updated, os_edition, os_version, os_arch, release_date, is_default, product_key)
    SELECT id, '1803', 'Mar 2019', 'Enterprise', '10.0.17134.648', 'amd64', '2019-03-20', false , 'NPPR9-FWDCX-D2C8J-H872K-2YT43'
      FROM supported_os WHERE os_name = 'Windows 10';
  INSERT INTO os_versions (os, os_build, os_updated, os_edition, os_version, os_arch, release_date, is_default, product_key)
    SELECT id, '1803', 'Apr 2019', 'Enterprise', '10.0.17134.706', 'amd64', '2019-04-16', false , 'NPPR9-FWDCX-D2C8J-H872K-2YT43'
      FROM supported_os WHERE os_name = 'Windows 10';
  INSERT INTO os_versions (os, os_build, os_updated, os_edition, os_version, os_arch, release_date, is_default, product_key)
    SELECT id, '1803', 'May 2019', 'Enterprise', '10.0.17134.766', 'amd64', '2019-05-27', false , 'NPPR9-FWDCX-D2C8J-H872K-2YT43'
      FROM supported_os WHERE os_name = 'Windows 10';
  INSERT INTO os_versions (os, os_build, os_updated, os_edition, os_version, os_arch, release_date, is_default, product_key)
    SELECT id, '1803', 'Jun 2019', 'Enterprise', '10.0.17134.829', 'amd64', '2019-06-19', false , 'NPPR9-FWDCX-D2C8J-H872K-2YT43'
      FROM supported_os WHERE os_name = 'Windows 10';
  INSERT INTO os_versions (os, os_build, os_updated, os_edition, os_version, os_arch, release_date, is_default, product_key)
    SELECT id, '1809', 'Nov 2018', 'Enterprise', '10.0.17763.1', 'amd64', '2018-11-13', false , 'NPPR9-FWDCX-D2C8J-H872K-2YT43'
      FROM supported_os WHERE os_name = 'Windows 10';
  INSERT INTO os_versions (os, os_build, os_updated, os_edition, os_version, os_arch, release_date, is_default, product_key)
    SELECT id, '1809', 'Dec 2018', 'Enterprise', '10.0.17763.194', 'amd64', '2018-12-19', false , 'NPPR9-FWDCX-D2C8J-H872K-2YT43'
      FROM supported_os WHERE os_name = 'Windows 10';
  INSERT INTO os_versions (os, os_build, os_updated, os_edition, os_version, os_arch, release_date, is_default, product_key)
    SELECT id, '1809', 'Jan 2019', 'Enterprise', '10.0.17763.253', 'amd64', '2019-01-15', false , 'NPPR9-FWDCX-D2C8J-H872K-2YT43'
      FROM supported_os WHERE os_name = 'Windows 10';
  INSERT INTO os_versions (os, os_build, os_updated, os_edition, os_version, os_arch, release_date, is_default, product_key)
    SELECT id, '1809', 'Feb 2019', 'Enterprise', '10.0.17763.316', 'amd64', '2019-02-19', false , 'NPPR9-FWDCX-D2C8J-H872K-2YT43'
      FROM supported_os WHERE os_name = 'Windows 10';
  INSERT INTO os_versions (os, os_build, os_updated, os_edition, os_version, os_arch, release_date, is_default, product_key)
    SELECT id, '1809', 'Mar 2019', 'Enterprise', '10.0.17763.379', 'amd64', '2019-03-28', false , 'NPPR9-FWDCX-D2C8J-H872K-2YT43'
      FROM supported_os WHERE os_name = 'Windows 10';
  INSERT INTO os_versions (os, os_build, os_updated, os_edition, os_version, os_arch, release_date, is_default, product_key)
    SELECT id, '1809', 'Apr 2019', 'Enterprise', '10.0.17763.437', 'amd64', '2019-04-16', false , 'NPPR9-FWDCX-D2C8J-H872K-2YT43'
      FROM supported_os WHERE os_name = 'Windows 10';
  INSERT INTO os_versions (os, os_build, os_updated, os_edition, os_version, os_arch, release_date, is_default, product_key)
    SELECT id, '1809', 'May 2019', 'Enterprise', '10.0.17763.504', 'amd64', '2019-05-27', false , 'NPPR9-FWDCX-D2C8J-H872K-2YT43'
      FROM supported_os WHERE os_name = 'Windows 10';
  INSERT INTO os_versions (os, os_build, os_updated, os_edition, os_version, os_arch, release_date, is_default, product_key)
    SELECT id, '1809', 'Jun 2019', 'Enterprise', '10.0.17763.557', 'amd64', '2019-06-19', false , 'NPPR9-FWDCX-D2C8J-H872K-2YT43'
      FROM supported_os WHERE os_name = 'Windows 10';
  INSERT INTO os_versions (os, os_build, os_updated, os_edition, os_version, os_arch, release_date, is_default, product_key)
    SELECT id, '1903', 'Apr 2019', 'Enterprise', '10.0.18362.30', 'amd64', '2019-04-16', false , 'NPPR9-FWDCX-D2C8J-H872K-2YT43'
      FROM supported_os WHERE os_name = 'Windows 10';
  INSERT INTO os_versions (os, os_build, os_updated, os_edition, os_version, os_arch, release_date, is_default, product_key)
    SELECT id, '1903', 'Jun 2019', 'Enterprise', '10.0.18362.175', 'amd64', '2019-06-19', false , 'NPPR9-FWDCX-D2C8J-H872K-2YT43'
      FROM supported_os WHERE os_name = 'Windows 10';
  INSERT INTO os_versions (os, os_build, os_updated, os_edition, os_version, os_arch, release_date, is_default, product_key)
    SELECT id, '1903', 'Oct 2019', 'Enterprise', '10.0.18362.418', 'amd64', '2019-10-21', false , 'NPPR9-FWDCX-D2C8J-H872K-2YT43'
      FROM supported_os WHERE os_name = 'Windows 10';
  INSERT INTO os_versions (os, os_build, os_updated, os_edition, os_version, os_arch, release_date, is_default, product_key)
    SELECT id, '1903', 'Nov 2019', 'Enterprise', '10.0.18362.476', 'amd64', '2019-11-19', false , 'NPPR9-FWDCX-D2C8J-H872K-2YT43'
      FROM supported_os WHERE os_name = 'Windows 10';
  INSERT INTO os_versions (os, os_build, os_updated, os_edition, os_version, os_arch, release_date, is_default, product_key)
    SELECT id, '1903', 'Dec 2019', 'Enterprise', '10.0.18362.535', 'amd64', '2019-12-17', false , 'NPPR9-FWDCX-D2C8J-H872K-2YT43'
      FROM supported_os WHERE os_name = 'Windows 10';
  INSERT INTO os_versions (os, os_build, os_updated, os_edition, os_version, os_arch, release_date, is_default, product_key)
    SELECT id, '1903', 'Jan 2020', 'Enterprise', '10.0.18362.592', 'amd64', '2020-01-21', false , 'NPPR9-FWDCX-D2C8J-H872K-2YT43'
      FROM supported_os WHERE os_name = 'Windows 10';
  INSERT INTO os_versions (os, os_build, os_updated, os_edition, os_version, os_arch, release_date, is_default, product_key)
    SELECT id, '1909', 'Oct 2019', 'Enterprise', '10.0.18363.418', 'amd64', '2019-10-16', false , 'NPPR9-FWDCX-D2C8J-H872K-2YT43'
      FROM supported_os WHERE os_name = 'Windows 10';
  INSERT INTO os_versions (os, os_build, os_updated, os_edition, os_version, os_arch, release_date, is_default, product_key)
    SELECT id, '1909', 'Dec 2019', 'Enterprise', '10.0.18363.535', 'amd64', '2019-12-17', false , 'NPPR9-FWDCX-D2C8J-H872K-2YT43'
      FROM supported_os WHERE os_name = 'Windows 10';
  INSERT INTO os_versions (os, os_build, os_updated, os_edition, os_version, os_arch, release_date, is_default, product_key)
    SELECT id, '1909', 'Jan 2020', 'Enterprise', '10.0.18363.592', 'amd64', '2019-12-17', false , 'NPPR9-FWDCX-D2C8J-H872K-2YT43'
      FROM supported_os WHERE os_name = 'Windows 10';
  INSERT INTO os_versions (os, os_build, os_updated, os_edition, os_version, os_arch, release_date, is_default, product_key)
    SELECT id, '1909', 'Feb 2020', 'Enterprise', '10.0.18363.657', 'amd64', '2020-02-18', false , 'NPPR9-FWDCX-D2C8J-H872K-2YT43'
      FROM supported_os WHERE os_name = 'Windows 10';
  INSERT INTO os_versions (os, os_build, os_updated, os_edition, os_version, os_arch, release_date, is_default, product_key)
    SELECT id, '1909', 'Apr 2020', 'Enterprise', '10.0.18363.778', 'amd64', '2020-04-21', false , 'NPPR9-FWDCX-D2C8J-H872K-2YT43'
      FROM supported_os WHERE os_name = 'Windows 10';
  INSERT INTO os_versions (os, os_build, os_updated, os_edition, os_version, os_arch, release_date, is_default, product_key)
    SELECT id, '1909', 'May 2020', 'Enterprise', '10.0.18363.836', 'amd64', '2020-05-21', false , 'NPPR9-FWDCX-D2C8J-H872K-2YT43'
      FROM supported_os WHERE os_name = 'Windows 10';
  INSERT INTO os_versions (os, os_build, os_updated, os_edition, os_version, os_arch, release_date, is_default, product_key)
    SELECT id, '1909', 'May 2020', 'Professional', '10.0.18363.836', 'amd64', '2020-05-21', false , 'W269N-WFGWX-YVC9B-4J6C9-T83GX'
      FROM supported_os WHERE os_name = 'Windows 10';
  INSERT INTO os_versions (os, os_build, os_updated, os_edition, os_version, os_arch, release_date, is_default, product_key)
    SELECT id, '1909', 'Sep 2020', 'Enterprise', '10.0.18363.1082', 'amd64', '2020-09-15', false , 'NPPR9-FWDCX-D2C8J-H872K-2YT43'
      FROM supported_os WHERE os_name = 'Windows 10';
  INSERT INTO os_versions (os, os_build, os_updated, os_edition, os_version, os_arch, release_date, is_default, product_key)
    SELECT id, '1909', 'Sep 2020', 'Professional', '10.0.18363.1082', 'amd64', '2020-09-15', false , 'W269N-WFGWX-YVC9B-4J6C9-T83GX'
      FROM supported_os WHERE os_name = 'Windows 10';
  INSERT INTO os_versions (os, os_build, os_updated, os_edition, os_version, os_arch, release_date, is_default, product_key)
    SELECT id, '1909', 'Mar 2021', 'Enterprise', '10.0.18363.1440', 'amd64', '2021-03-18', false , 'NPPR9-FWDCX-D2C8J-H872K-2YT43'
      FROM supported_os WHERE os_name = 'Windows 10';
  INSERT INTO os_versions (os, os_build, os_updated, os_edition, os_version, os_arch, release_date, is_default, product_key)
    SELECT id, '1909', 'May 2021', 'Enterprise', '10.0.18363.1556', 'amd64', '2021-05-18', false , 'NPPR9-FWDCX-D2C8J-H872K-2YT43'
      FROM supported_os WHERE os_name = 'Windows 10';
  INSERT INTO os_versions (os, os_build, os_updated, os_edition, os_version, os_arch, release_date, is_default, product_key)
    SELECT id, '1909', 'Mar 2021', 'Professional', '10.0.18363.1440', 'amd64', '2021-03-18', false , 'W269N-WFGWX-YVC9B-4J6C9-T83GX'
      FROM supported_os WHERE os_name = 'Windows 10';
  INSERT INTO os_versions (os, os_build, os_updated, os_edition, os_version, os_arch, release_date, is_default, product_key)
    SELECT id, '1909', 'May 2021', 'Professional', '10.0.18363.1556', 'amd64', '2021-05-18', false , 'W269N-WFGWX-YVC9B-4J6C9-T83GX'
      FROM supported_os WHERE os_name = 'Windows 10';
  INSERT INTO os_versions (os, os_build, os_updated, os_edition, os_version, os_arch, release_date, is_default, product_key)
    SELECT id, '1909', 'Jun 2021', 'Enterprise', '10.0.18363.1621', 'amd64', '2021-06-21', false , 'NPPR9-FWDCX-D2C8J-H872K-2YT43'
      FROM supported_os WHERE os_name = 'Windows 10';
  INSERT INTO os_versions (os, os_build, os_updated, os_edition, os_version, os_arch, release_date, is_default, product_key)
    SELECT id, '1909', 'Jun 2021', 'Professional', '10.0.18363.1621', 'amd64', '2021-06-21', false , 'W269N-WFGWX-YVC9B-4J6C9-T83GX'
      FROM supported_os WHERE os_name = 'Windows 10';
  INSERT INTO os_versions (os, os_build, os_updated, os_edition, os_version, os_arch, release_date, is_default, product_key)
    SELECT id, '2004', 'May 2020', 'Professional', '10.0.19041.264', 'amd64', '2020-05-21', false , 'W269N-WFGWX-YVC9B-4J6C9-T83GX'
      FROM supported_os WHERE os_name = 'Windows 10';
  INSERT INTO os_versions (os, os_build, os_updated, os_edition, os_version, os_arch, release_date, is_default, product_key)
    SELECT id, '2004', 'May 2020', 'Enterprise', '10.0.19041.264', 'amd64', '2020-05-21', false , 'NPPR9-FWDCX-D2C8J-H872K-2YT43'
      FROM supported_os WHERE os_name = 'Windows 10';
  INSERT INTO os_versions (os, os_build, os_updated, os_edition, os_version, os_arch, release_date, is_default, product_key)
    SELECT id, '20H2', 'Mar 2021', 'Professional', '10.0.19042.867', 'amd64', '2021-03-18', false , 'W269N-WFGWX-YVC9B-4J6C9-T83GX'
      FROM supported_os WHERE os_name = 'Windows 10';
  INSERT INTO os_versions (os, os_build, os_updated, os_edition, os_version, os_arch, release_date, is_default, product_key)
    SELECT id, '20H2', 'Mar 2021', 'Enterprise', '10.0.19042.867', 'amd64', '2021-03-18', false , 'NPPR9-FWDCX-D2C8J-H872K-2YT43'
      FROM supported_os WHERE os_name = 'Windows 10';
  INSERT INTO os_versions (os, os_build, os_updated, os_edition, os_version, os_arch, release_date, is_default, product_key)
    SELECT id, '20H2', 'May 2021', 'Professional', '10.0.19042.985', 'amd64', '2021-05-18', false , 'W269N-WFGWX-YVC9B-4J6C9-T83GX'
      FROM supported_os WHERE os_name = 'Windows 10';
  INSERT INTO os_versions (os, os_build, os_updated, os_edition, os_version, os_arch, release_date, is_default, product_key)
    SELECT id, '20H2', 'May 2021', 'Enterprise', '10.0.19042.985', 'amd64', '2021-05-18', false , 'NPPR9-FWDCX-D2C8J-H872K-2YT43'
      FROM supported_os WHERE os_name = 'Windows 10';
  INSERT INTO os_versions (os, os_build, os_updated, os_edition, os_version, os_arch, release_date, is_default, product_key)
    SELECT id, '20H2', 'Jun 2021', 'Professional', '10.0.19042.1052', 'amd64', '2021-06-21', false , 'W269N-WFGWX-YVC9B-4J6C9-T83GX'
      FROM supported_os WHERE os_name = 'Windows 10';
  INSERT INTO os_versions (os, os_build, os_updated, os_edition, os_version, os_arch, release_date, is_default, product_key)
    SELECT id, '20H2', 'Jun 2021', 'Enterprise', '10.0.19042.1052', 'amd64', '2021-06-21', false , 'NPPR9-FWDCX-D2C8J-H872K-2YT43'
      FROM supported_os WHERE os_name = 'Windows 10';
  INSERT INTO os_versions (os, os_build, os_updated, os_edition, os_version, os_arch, release_date, is_default, product_key)
    SELECT id, '20H2', 'Aug 2021', 'Enterprise', '10.0.19042.1165', 'amd64', '2021-08-17', false , 'NPPR9-FWDCX-D2C8J-H872K-2YT43'
      FROM supported_os WHERE os_name = 'Windows 10';
  INSERT INTO os_versions (os, os_build, os_updated, os_edition, os_version, os_arch, release_date, is_default, product_key)
    SELECT id, '20H2', 'Aug 2021', 'Professional', '10.0.19042.1165', 'amd64', '2021-08-17', false , 'W269N-WFGWX-YVC9B-4J6C9-T83GX'
      FROM supported_os WHERE os_name = 'Windows 10';
  INSERT INTO os_versions (os, os_build, os_updated, os_edition, os_version, os_arch, release_date, is_default, product_key)
    SELECT id, '20H2', 'Sep 2021', 'Enterprise', '10.0.19042.1237', 'amd64', '2021-09-22', false , 'NPPR9-FWDCX-D2C8J-H872K-2YT43'
    FROM supported_os WHERE os_name = 'Windows 10';
  INSERT INTO os_versions (os, os_build, os_updated, os_edition, os_version, os_arch, release_date, is_default, product_key)
    SELECT id, '20H2', 'Sep 2021', 'Professional', '10.0.19042.1237', 'amd64', '2021-09-22', false , 'W269N-WFGWX-YVC9B-4J6C9-T83GX'
    FROM supported_os WHERE os_name = 'Windows 10';
  INSERT INTO os_versions (os, os_build, os_updated, os_edition, os_version, os_arch, release_date, is_default, product_key)
    SELECT id, '20H2', 'Oct 2021', 'Enterprise', '10.0.19042.1288', 'amd64', '2021-10-19', false , 'NPPR9-FWDCX-D2C8J-H872K-2YT43'
    FROM supported_os WHERE os_name = 'Windows 10';
  INSERT INTO os_versions (os, os_build, os_updated, os_edition, os_version, os_arch, release_date, is_default, product_key)
    SELECT id, '20H2', 'Oct 2021', 'Professional', '10.0.19042.1288', 'amd64', '2021-10-19', false , 'W269N-WFGWX-YVC9B-4J6C9-T83GX'
    FROM supported_os WHERE os_name = 'Windows 10';
  INSERT INTO os_versions (os, os_build, os_updated, os_edition, os_version, os_arch, release_date, is_default, product_key)
    SELECT id, '20H2', 'Jan 2022', 'Enterprise', '10.0.19042.1466', 'amd64', '2022-01-18', false , 'NPPR9-FWDCX-D2C8J-H872K-2YT43'
    FROM supported_os WHERE os_name = 'Windows 10';
  INSERT INTO os_versions (os, os_build, os_updated, os_edition, os_version, os_arch, release_date, is_default, product_key)
    SELECT id, '20H2', 'Jan 2022', 'Professional', '10.0.19042.1466', 'amd64', '2022-01-18', false , 'W269N-WFGWX-YVC9B-4J6C9-T83GX'
    FROM supported_os WHERE os_name = 'Windows 10';
  INSERT INTO os_versions (os, os_build, os_updated, os_edition, os_version, os_arch, release_date, is_default, product_key)
    SELECT id, '21H1', 'May 2021', 'Enterprise', '10.0.19043.928', 'amd64', '2021-05-19', false , 'NPPR9-FWDCX-D2C8J-H872K-2YT43'
      FROM supported_os WHERE os_name = 'Windows 10';
  INSERT INTO os_versions (os, os_build, os_updated, os_edition, os_version, os_arch, release_date, is_default, product_key)
    SELECT id, '21H1', 'May 2021', 'Professional', '10.0.19043.928', 'amd64', '2021-05-19', false , 'W269N-WFGWX-YVC9B-4J6C9-T83GX'
      FROM supported_os WHERE os_name = 'Windows 10';
  INSERT INTO os_versions (os, os_build, os_updated, os_edition, os_version, os_arch, release_date, is_default, product_key)
    SELECT id, '21H1', 'Jun 2021', 'Enterprise', '10.0.19043.1052', 'amd64', '2021-06-21', false , 'NPPR9-FWDCX-D2C8J-H872K-2YT43'
      FROM supported_os WHERE os_name = 'Windows 10';
  INSERT INTO os_versions (os, os_build, os_updated, os_edition, os_version, os_arch, release_date, is_default, product_key)
    SELECT id, '21H1', 'Jun 2021', 'Professional', '10.0.19043.1052', 'amd64', '2021-06-21', false , 'W269N-WFGWX-YVC9B-4J6C9-T83GX'
      FROM supported_os WHERE os_name = 'Windows 10';
  INSERT INTO os_versions (os, os_build, os_updated, os_edition, os_version, os_arch, release_date, is_default, product_key)
    SELECT id, '21H1', 'Aug 2021', 'Enterprise', '10.0.19043.1165', 'amd64', '2021-08-17', false , 'NPPR9-FWDCX-D2C8J-H872K-2YT43'
      FROM supported_os WHERE os_name = 'Windows 10';
  INSERT INTO os_versions (os, os_build, os_updated, os_edition, os_version, os_arch, release_date, is_default, product_key)
    SELECT id, '21H1', 'Aug 2021', 'Professional', '10.0.19043.1165', 'amd64', '2021-08-17', false , 'W269N-WFGWX-YVC9B-4J6C9-T83GX'
      FROM supported_os WHERE os_name = 'Windows 10';
  INSERT INTO os_versions (os, os_build, os_updated, os_edition, os_version, os_arch, release_date, is_default, product_key)
    SELECT id, '21H1', 'Sep 2021', 'Enterprise', '10.0.19043.1237', 'amd64', '2021-09-22', false , 'NPPR9-FWDCX-D2C8J-H872K-2YT43'
    FROM supported_os WHERE os_name = 'Windows 10';
  INSERT INTO os_versions (os, os_build, os_updated, os_edition, os_version, os_arch, release_date, is_default, product_key)
    SELECT id, '21H1', 'Sep 2021', 'Professional', '10.0.19043.1237', 'amd64', '2021-09-22', false , 'W269N-WFGWX-YVC9B-4J6C9-T83GX'
    FROM supported_os WHERE os_name = 'Windows 10';
  INSERT INTO os_versions (os, os_build, os_updated, os_edition, os_version, os_arch, release_date, is_default, product_key)
    SELECT id, '21H1', 'Oct 2021', 'Enterprise', '10.0.19043.1288', 'amd64', '2021-10-19', false , 'NPPR9-FWDCX-D2C8J-H872K-2YT43'
    FROM supported_os WHERE os_name = 'Windows 10';
  INSERT INTO os_versions (os, os_build, os_updated, os_edition, os_version, os_arch, release_date, is_default, product_key)
    SELECT id, '21H1', 'Oct 2021', 'Professional', '10.0.19043.1288', 'amd64', '2021-10-19', false , 'W269N-WFGWX-YVC9B-4J6C9-T83GX'
    FROM supported_os WHERE os_name = 'Windows 10';
  INSERT INTO os_versions (os, os_build, os_updated, os_edition, os_version, os_arch, release_date, is_default, product_key)
    SELECT id, '21H1', 'Jan 2022', 'Enterprise', '10.0.19043.1466', 'amd64', '2022-01-18', false , 'NPPR9-FWDCX-D2C8J-H872K-2YT43'
    FROM supported_os WHERE os_name = 'Windows 10';
  INSERT INTO os_versions (os, os_build, os_updated, os_edition, os_version, os_arch, release_date, is_default, product_key)
    SELECT id, '21H1', 'Jan 2022', 'Professional', '10.0.19043.1466', 'amd64', '2022-01-18', false , 'W269N-WFGWX-YVC9B-4J6C9-T83GX'
    FROM supported_os WHERE os_name = 'Windows 10';
  INSERT INTO os_versions (os, os_build, os_updated, os_edition, os_version, os_arch, release_date, is_default, product_key)
    SELECT id, '21H2', 'Jan 2022', 'Enterprise', '10.0.19044.1466', 'amd64', '2022-01-18', true , 'NPPR9-FWDCX-D2C8J-H872K-2YT43'
    FROM supported_os WHERE os_name = 'Windows 10';
  INSERT INTO os_versions (os, os_build, os_updated, os_edition, os_version, os_arch, release_date, is_default, product_key)
    SELECT id, '21H2', 'Jan 2022', 'Professional', '10.0.19044.1466', 'amd64', '2022-01-18', false , 'W269N-WFGWX-YVC9B-4J6C9-T83GX'
    FROM supported_os WHERE os_name = 'Windows 10';
  INSERT INTO os_versions (os, os_build, os_updated, os_edition, os_version, os_arch, release_date, is_default, product_key)
    SELECT id, '21H2', 'Oct 2021', 'Enterprise', '10.0.22000.258', 'amd64', '2021-10-04', false , 'NPPR9-FWDCX-D2C8J-H872K-2YT43'
    FROM supported_os WHERE os_name = 'Windows 11';
  INSERT INTO os_versions (os, os_build, os_updated, os_edition, os_version, os_arch, release_date, is_default, product_key)
    SELECT id, '21H2', 'Jan 2022', 'Enterprise', '10.0.22000.434', 'amd64', '2022-01-18', true , 'NPPR9-FWDCX-D2C8J-H872K-2YT43'
    FROM supported_os WHERE os_name = 'Windows 11';
COMMIT;

/* OU-шки и их связи с различными странами и операционными системами */
BEGIN;
  SET SCHEMA 'deploy';

  INSERT INTO ou ("id", "ou_path", "is_default")
    VALUES (DEFAULT, 'CN=Computers,DC=ld,DC=yandex,DC=ru', true);
  INSERT INTO ou ("id", "ou_path", "is_default")
    VALUES (DEFAULT, 'OU=Yandex.Computers,OU=Windows7,OU=WinWorkstations,OU=AllWinWorkstations,DC=ld,DC=yandex,DC=ru', false);
  INSERT INTO ou ("id", "ou_path", "is_default")
    VALUES (DEFAULT, 'OU=Yandex.Computers,OU=Windows8,OU=WinWorkstations,OU=AllWinWorkstations,DC=ld,DC=yandex,DC=ru', false);
  INSERT INTO ou ("id", "ou_path", "is_default")
    VALUES (DEFAULT, 'OU=Yandex.Computers,OU=Windows10,OU=WinWorkstations,OU=AllWinWorkstations,DC=ld,DC=yandex,DC=ru', false);
  INSERT INTO ou ("id", "ou_path", "is_default")
    VALUES (DEFAULT, 'OU=Belarus.Computers,OU=Windows7,OU=WinWorkstations,OU=AllWinWorkstations,DC=ld,DC=yandex,DC=ru', false);
  INSERT INTO ou ("id", "ou_path", "is_default")
    VALUES (DEFAULT, 'OU=Belarus.Computers,OU=Windows8,OU=WinWorkstations,OU=AllWinWorkstations,DC=ld,DC=yandex,DC=ru', false);
  INSERT INTO ou ("id", "ou_path", "is_default")
    VALUES (DEFAULT, 'OU=Belarus.Computers,OU=Windows10,OU=WinWorkstations,OU=AllWinWorkstations,DC=ld,DC=yandex,DC=ru', false);
  INSERT INTO ou ("id", "ou_path", "is_default")
    VALUES (DEFAULT, 'OU=Turkey.Computers,OU=Windows7,OU=WinWorkstations,OU=AllWinWorkstations,DC=ld,DC=yandex,DC=ru', false);
  INSERT INTO ou ("id", "ou_path", "is_default")
    VALUES (DEFAULT, 'OU=Turkey.Computers,OU=Windows8,OU=WinWorkstations,OU=AllWinWorkstations,DC=ld,DC=yandex,DC=ru', false);
  INSERT INTO ou ("id", "ou_path", "is_default")
    VALUES (DEFAULT, 'OU=Turkey.Computers,OU=Windows10,OU=WinWorkstations,OU=AllWinWorkstations,DC=ld,DC=yandex,DC=ru', false);
  INSERT INTO ou ("id", "ou_path", "is_default")
    VALUES (DEFAULT, 'OU=Finland.Computers,OU=Windows7,OU=WinWorkstations,OU=AllWinWorkstations,DC=ld,DC=yandex,DC=ru', false);
  INSERT INTO ou ("id", "ou_path", "is_default")
    VALUES (DEFAULT, 'OU=Finland.Computers,OU=Windows8,OU=WinWorkstations,OU=AllWinWorkstations,DC=ld,DC=yandex,DC=ru', false);
  INSERT INTO ou ("id", "ou_path", "is_default")
    VALUES (DEFAULT, 'OU=Finland.Computers,OU=Windows10,OU=WinWorkstations,OU=AllWinWorkstations,DC=ld,DC=yandex,DC=ru', false);
COMMIT;

BEGIN;
  SET SCHEMA 'deploy';

  INSERT INTO os_ou_countries (country_name, os_name, ou_path)
    SELECT cn.id, os.id, ou.id FROM supported_os AS os, countries AS cn, ou
      WHERE cn.country_name = 'Russia'
        AND os.os_name = 'Windows 7'
        AND ou.ou_path = 'OU=Yandex.Computers,OU=Windows7,OU=WinWorkstations,OU=AllWinWorkstations,DC=ld,DC=yandex,DC=ru';
  INSERT INTO os_ou_countries (country_name, os_name, ou_path)
    SELECT cn.id, os.id, ou.id FROM supported_os AS os, countries AS cn, ou
      WHERE cn.country_name = 'Russia'
        AND os.os_name = 'Windows 8.1'
        AND ou.ou_path = 'OU=Yandex.Computers,OU=Windows8,OU=WinWorkstations,OU=AllWinWorkstations,DC=ld,DC=yandex,DC=ru';
  INSERT INTO os_ou_countries (country_name, os_name, ou_path)
    SELECT cn.id, os.id, ou.id FROM supported_os AS os, countries AS cn, ou
      WHERE cn.country_name = 'Russia'
        AND os.os_name = 'Windows 10'
        AND ou.ou_path = 'OU=Yandex.Computers,OU=Windows10,OU=WinWorkstations,OU=AllWinWorkstations,DC=ld,DC=yandex,DC=ru';
  INSERT INTO os_ou_countries (country_name, os_name, ou_path)
    SELECT cn.id, os.id, ou.id FROM supported_os AS os, countries AS cn, ou
      WHERE cn.country_name = 'Russia'
        AND os.os_name = 'Windows 11'
        AND ou.ou_path = 'OU=Yandex.Computers,OU=Windows10,OU=WinWorkstations,OU=AllWinWorkstations,DC=ld,DC=yandex,DC=ru';
  INSERT INTO os_ou_countries (country_name, os_name, ou_path)
    SELECT cn.id, os.id, ou.id FROM supported_os AS os, countries AS cn, ou
      WHERE cn.country_name = 'Belarus'
        AND os.os_name = 'Windows 7'
        AND ou.ou_path = 'OU=Belarus.Computers,OU=Windows7,OU=WinWorkstations,OU=AllWinWorkstations,DC=ld,DC=yandex,DC=ru';
  INSERT INTO os_ou_countries (country_name, os_name, ou_path)
    SELECT cn.id, os.id, ou.id FROM supported_os AS os, countries AS cn, ou
      WHERE cn.country_name = 'Belarus'
        AND os.os_name = 'Windows 8.1'
        AND ou.ou_path = 'OU=Belarus.Computers,OU=Windows8,OU=WinWorkstations,OU=AllWinWorkstations,DC=ld,DC=yandex,DC=ru';
  INSERT INTO os_ou_countries (country_name, os_name, ou_path)
    SELECT cn.id, os.id, ou.id FROM supported_os AS os, countries AS cn, ou
      WHERE cn.country_name = 'Belarus'
        AND os.os_name = 'Windows 10'
        AND ou.ou_path = 'OU=Belarus.Computers,OU=Windows10,OU=WinWorkstations,OU=AllWinWorkstations,DC=ld,DC=yandex,DC=ru';
  INSERT INTO os_ou_countries (country_name, os_name, ou_path)
    SELECT cn.id, os.id, ou.id FROM supported_os AS os, countries AS cn, ou
      WHERE cn.country_name = 'Belarus'
        AND os.os_name = 'Windows 11'
        AND ou.ou_path = 'OU=Belarus.Computers,OU=Windows10,OU=WinWorkstations,OU=AllWinWorkstations,DC=ld,DC=yandex,DC=ru';
  INSERT INTO os_ou_countries (country_name, os_name, ou_path)
    SELECT cn.id, os.id, ou.id FROM supported_os AS os, countries AS cn, ou
      WHERE cn.country_name = 'Turkey'
        AND os.os_name = 'Windows 7'
        AND ou.ou_path = 'OU=Turkey.Computers,OU=Windows7,OU=WinWorkstations,OU=AllWinWorkstations,DC=ld,DC=yandex,DC=ru';
  INSERT INTO os_ou_countries (country_name, os_name, ou_path)
    SELECT cn.id, os.id, ou.id FROM supported_os AS os, countries AS cn, ou
      WHERE cn.country_name = 'Turkey'
        AND os.os_name = 'Windows 8.1'
        AND ou.ou_path = 'OU=Turkey.Computers,OU=Windows8,OU=WinWorkstations,OU=AllWinWorkstations,DC=ld,DC=yandex,DC=ru';
  INSERT INTO os_ou_countries (country_name, os_name, ou_path)
    SELECT cn.id, os.id, ou.id FROM supported_os AS os, countries AS cn, ou
      WHERE cn.country_name = 'Turkey'
        AND os.os_name = 'Windows 10'
        AND ou.ou_path = 'OU=Turkey.Computers,OU=Windows10,OU=WinWorkstations,OU=AllWinWorkstations,DC=ld,DC=yandex,DC=ru';
  INSERT INTO os_ou_countries (country_name, os_name, ou_path)
    SELECT cn.id, os.id, ou.id FROM supported_os AS os, countries AS cn, ou
      WHERE cn.country_name = 'Turkey'
        AND os.os_name = 'Windows 11'
        AND ou.ou_path = 'OU=Turkey.Computers,OU=Windows10,OU=WinWorkstations,OU=AllWinWorkstations,DC=ld,DC=yandex,DC=ru';
  INSERT INTO os_ou_countries (country_name, os_name, ou_path)
    SELECT cn.id, os.id, ou.id FROM supported_os AS os, countries AS cn, ou
      WHERE cn.country_name = 'Finland'
        AND os.os_name = 'Windows 7'
        AND ou.ou_path = 'OU=Finland.Computers,OU=Windows7,OU=WinWorkstations,OU=AllWinWorkstations,DC=ld,DC=yandex,DC=ru';
  INSERT INTO os_ou_countries (country_name, os_name, ou_path)
    SELECT cn.id, os.id, ou.id FROM supported_os AS os, countries AS cn, ou
      WHERE cn.country_name = 'Finland'
        AND os.os_name = 'Windows 8.1'
        AND ou.ou_path = 'OU=Finland.Computers,OU=Windows8,OU=WinWorkstations,OU=AllWinWorkstations,DC=ld,DC=yandex,DC=ru';
  INSERT INTO os_ou_countries (country_name, os_name, ou_path)
    SELECT cn.id, os.id, ou.id FROM supported_os AS os, countries AS cn, ou
      WHERE cn.country_name = 'Finland'
        AND os.os_name = 'Windows 10'
        AND ou.ou_path = 'OU=Finland.Computers,OU=Windows10,OU=WinWorkstations,OU=AllWinWorkstations,DC=ld,DC=yandex,DC=ru';
  INSERT INTO os_ou_countries (country_name, os_name, ou_path)
    SELECT cn.id, os.id, ou.id FROM supported_os AS os, countries AS cn, ou
      WHERE cn.country_name = 'Finland'
        AND os.os_name = 'Windows 11'
        AND ou.ou_path = 'OU=Finland.Computers,OU=Windows10,OU=WinWorkstations,OU=AllWinWorkstations,DC=ld,DC=yandex,DC=ru';
COMMIT;


/* Поддерживаемые модели */
BEGIN;
  SET SCHEMA 'deploy';

  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('LENOVO', '20A8A093RT', 'Lenovo Thinkpad X1 Carbon 2nd', false);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('LENOVO', '20BS006NRT', 'Lenovo Thinkpad X1 Carbon 3rd', false);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('LENOVO', '20CK001WRT', 'Lenovo Thinkpad T550', false);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('LENOVO', '20FCS1DW00', 'Lenovo Thinkpad X1 Carbon 4th', false);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('LENOVO', '20FCS52M00', 'Lenovo Thinkpad X1 Carbon 4th', false);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('LENOVO', '20FD002TRT', 'Lenovo Thinkpad Yoga 260', true);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('LENOVO', '20LF000TRT', 'Lenovo Thinkpad Yoga 3rd', false);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('LENOVO', '20QF0024RT', 'Lenovo Thinkpad X1 Yoga 4th', false);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('LENOVO', '20UB003XRT', 'Lenovo Thinkpad X1 Yoga 5th', false);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('LENOVO', '20FH001BRT', 'Lenovo Thinkpad T560', false);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('LENOVO', '20FJS12X00', 'Lenovo Thinkpad T560', false);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('LENOVO', '20FJS3H100', 'Lenovo Thinkpad T560', false);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('LENOVO', '20H5S00400', 'Lenovo Thinkpad E570', true);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('LENOVO', '20HAS20T00', 'Lenovo Thinkpad T570', false);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('LENOVO', '20HQS47H00', 'Lenovo Thinkpad X1 Carbon 5th', false);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('LENOVO', '20HQS6Y800', 'Lenovo Thinkpad X1 Carbon 5th', false);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('LENOVO', '20HR0021RT', 'Lenovo Thinkpad X1 Carbon 5th', false);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('LENOVO', '20HR002NRT', 'Lenovo Thinkpad X1 Carbon 5th', false);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('LENOVO', '20HR005BRT', 'Lenovo Thinkpad X1 Carbon 5th', false);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('LENOVO', '20KGS4JC00', 'Lenovo Thinkpad X1 Carbon 6th', false);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('LENOVO', '20KGS6PC00', 'Lenovo Thinkpad X1 Carbon 6th', false);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('LENOVO', '20KH006JRT', 'Lenovo Thinkpad X1 Carbon 6th', false);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('LENOVO', '20KGSBUL00', 'Lenovo Thinkpad X1 Carbon 6th', false);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('LENOVO', '20KGSBUK00', 'Lenovo Thinkpad X1 Carbon 6th', false);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('LENOVO', '20QES1F100', 'Lenovo Thinkpad X1 Carbon 7th', false);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('LENOVO', '20UAS89500', 'Lenovo Thinkpad X1 Carbon 8th', false);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('LENOVO', '20U90003RT', 'Lenovo Thinkpad X1 Carbon 8th', false);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('LENOVO', '20UASDDS00', 'Lenovo Thinkpad X1 Carbon 8th', false);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('LENOVO', '20U90001RT', 'Lenovo Thinkpad X1 Carbon 8th', false);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('LENOVO', '20XXS0PS00', 'Lenovo Thinkpad X1 Carbon 9th gen', false);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('LENOVO', '20XW005GRT', 'Lenovo Thinkpad X1 Carbon 9th gen', false);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('LENOVO', '20XW0026RT', 'Lenovo Thinkpad X1 Carbon 9th gen', false);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('LENOVO', '20UN005LRT', 'Lenovo Thinkpad X1 Nano 1st gen (Intel)', false);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('LENOVO', '20T2003JRT', 'Lenovo Thinkpad X13 1st gen (Intel)', false);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('LENOVO', '20T20032RT', 'Lenovo Thinkpad X13 1st gen (Intel)', false);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('LENOVO', '20UF0038RT', 'Lenovo Thinkpad X13 1st gen (AMD)', false);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('LENOVO', '20ST006RRT', 'Lenovo Thinkpad P15 1st gen', false);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('LENOVO', '20T1S6K100', 'Lenovo Thinkpad T14s 1st gen (Intel)', false);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('LENOVO', '20T0004PRT', 'Lenovo Thinkpad T14s 1st gen (Intel)', false);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('LENOVO', '20T0004RRT', 'Lenovo Thinkpad T14s 1st gen (Intel)', false);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('LENOVO', '20T00041RT', 'Lenovo Thinkpad T14s 1st gen (Intel)', false);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('LENOVO', '20T00047RT', 'Lenovo Thinkpad T14s 1st gen (Intel)', false);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('LENOVO', '20T0001CRT', 'Lenovo Thinkpad T14s 1st gen (Intel)', false);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('LENOVO', '20T0001DRT', 'Lenovo Thinkpad T14s 1st gen (Intel)', false);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('LENOVO', '20T0001ERT', 'Lenovo Thinkpad T14s 1st gen (Intel)', false);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('LENOVO', '20UH000GUS', 'Lenovo Thinkpad T14s 1st gen (AMD)', false);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('LENOVO', '20UH0017RT', 'Lenovo Thinkpad T14s 1st gen (AMD)', false);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('LENOVO', '20UH0033RT', 'Lenovo Thinkpad T14s 1st gen (AMD)', false);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('LENOVO', '20UH0035RT', 'Lenovo Thinkpad T14s 1st gen (AMD)', false);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('LENOVO', '20UH0036RT', 'Lenovo Thinkpad T14s 1st gen (AMD)', false);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('LENOVO', '20UH0038RT', 'Lenovo Thinkpad T14s 1st gen (AMD)', false);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('LENOVO', '20UH003BRT', 'Lenovo Thinkpad T14s 1st gen (AMD)', false);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('LENOVO', '20UH003FRT', 'Lenovo Thinkpad T14s 1st gen (AMD)', false);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('LENOVO', '20UH003HRT', 'Lenovo Thinkpad T14s 1st gen (AMD)', false);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('LENOVO', '20UH002CRT', 'Lenovo Thinkpad T14s 1st gen (AMD)', false);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('LENOVO', '20UH0032RT', 'Lenovo Thinkpad T14s 1st gen (AMD)', false);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('LENOVO', '20UH001JRT', 'Lenovo Thinkpad T14s 1st gen (AMD)', false);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('LENOVO', '20UH001HRT', 'Lenovo Thinkpad T14s 1st gen (AMD)', false);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('LENOVO', '20UH001RRT', 'Lenovo Thinkpad T14s 1st gen (AMD)', false);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('LENOVO', '20WM009SRT', 'Lenovo Thinkpad T14s 2nd gen (Intel)', false);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('LENOVO', '20WM009RRT', 'Lenovo Thinkpad T14s 2nd gen (Intel)', false);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('LENOVO', '20W0000ERT', 'Lenovo Thinkpad T14 2nd gen (Intel)', false);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('LENOVO', '20LAS0VY00', 'Lenovo Thinkpad T580', false);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('LENOVO', '20LAS5V100', 'Lenovo Thinkpad T580', false);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('LENOVO', '20N5S48K00', 'Lenovo Thinkpad T590', false);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('LENOVO', '23924SG', 'Lenovo Thinkpad T530', true);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('LENOVO', '24298W3', 'Lenovo Thinkpad T530', true);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('LENOVO', '2465BC6', 'Lenovo L430', true);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('LENOVO', '24791Q3', 'Lenovo L530', true);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('LENOVO', '2479B96', 'Lenovo L530', true);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('LENOVO', '34482E7', 'Lenovo Thinkpad X1 Carbon', true);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('LENOVO', '3448AWG', 'Lenovo Thinkpad X1 Carbon', true);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('LENOVO', '34606E8', 'Lenovo Thinkpad X1 Carbon', true);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('LENOVO', '34609C0', 'Lenovo Thinkpad X1 Carbon', true);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('LENOVO', '3460AS2', 'Lenovo Thinkpad X1 Carbon', true);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('LENOVO', '42403FG', 'Lenovo Thinkpad T520', true);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('LENOVO', '42406EG', 'Lenovo Thinkpad T520', true);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('LENOVO', '42406FG', 'Lenovo Thinkpad T520', true);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('LENOVO', '4243R67', 'Lenovo Thinkpad T520', true);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('LENOVO', '4290RW1', 'Lenovo Thinkpad X220', true);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('LENOVO', '4291E57', 'Lenovo Thinkpad X220', true);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('LENOVO', '4291IY3', 'Lenovo Thinkpad X220', true);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('LENOVO', '43146AG', 'Lenovo Thinkpad T510i', true);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('LENOVO', '43146BG', 'Lenovo Thinkpad T510i', true);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('LENOVO', '4349NV5', 'Lenovo Thinkpad T510', true);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('LENOVO', '4349PQ9', 'Lenovo Thinkpad T510i', true);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('LENOVO', '4349PZ8', 'Lenovo Thinkpad T510i', true);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('LENOVO', '4384HK8', 'Lenovo Thinkpad T510', true);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('SAMSUNG ELECTRONICS CO., LTD.', '900X3C/900X3D/900X3E/900X4C/900X4D', 'Samsung NP900X', true);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('SAMSUNG ELECTRONICS CO., LTD.', '900X3C/900X3D/900X4C/900X4D', 'Samsung NP900X', true);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('Aquarius', 'Aquarius Pro P30 S67', 'Aquarius Pro P30 S67 (Q67)', true);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('Aquarius', 'Aquarius Pro, Std, Elt Series', 'Aquarius QDL-E50S871B3418M150D99NLNWTYN3', true);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('Aquarius', 'Aquarius Server', 'Aquarius G40 S42', true);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('Aquarius', 'Aquarius Std S20 S61', 'Aquarius Std S20 S61', true);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('Aquarius', 'Aquarius Std, Pro, Elt', 'Aquarius Elt E50 S66 (Q67)', true);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('Aquarius', 'P30 S85 BUY-866', 'Aquarius P30 S85 BUY-866', true);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('Aquarius', 'Pro G40 S48 BUY-1951', 'Aquarius Pro G40 S48 BUY-1951', true);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('Aquarius', 'Pro G40 S48 BUY-4146', 'Aquarius Pro G40 S48 BUY-4146', true);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('Aquarius', 'Pro G40 S48 SRVBUY-163', 'Aquarius Pro G40 S48 SRVBUY-163', true);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('Aquarius', 'Pro G40 S58 BUY-8324', 'Aquarius Pro G40 S58 BUY-8324', true);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('Aquarius', 'Pro G40 S58 BUY-10355', 'Aquarius Pro G40 S58 BUY-10355', true);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('Aquarius', 'Pro G40 S58 BUY-12348', 'Aquarius Pro G40 S58 BUY-12348', true);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('Aquarius', 'Pro P30 K15 BUY-2538', 'Aquarius Pro P30 K15 BUY-2538', true);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('Aquarius', 'Pro P30 K15 BUY-3535', 'Aquarius Pro P30 K15 BUY-3535', true);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('Aquarius', 'Pro P30 K15 BUY-5322', 'Aquarius Pro P30 K15 BUY-5322', true);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('Aquarius', 'Pro P30 K15 BUY-8477', 'Aquarius Pro P30 K15 BUY-8477', true);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('Aquarius', 'Pro P30 K15 BUY-10931', 'Aquarius Pro P30 K15 BUY-10931', true);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('Aquarius', 'Pro P30 K15 BUY-112348', 'Aquarius Pro P30 K15 BUY-112348', true);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('Aquarius', 'Pro P30 S85 BUY-866', 'Aquarius P30 S85 BUY-866', true);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('Aquarius', 'Std S20 S61 BUY-1305', 'Aquarius Std S20 S61 BUY-1305', true);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('Panasonic Corporation', 'CF-53SAWZYM1', 'Panasonic Toughbook CF-53', true);

  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('FUJITSU', 'LIFEBOOK P771', 'Fujitsu Lifebook P771', true);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('FUJITSU', 'LIFEBOOK P772', 'Fujitsu Lifebook P772', true);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('FUJITSU', 'LIFEBOOK S761', 'Fujitsu Lifebook S761', true);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('FUJITSU', 'LIFEBOOK S762', 'Fujitsu Lifebook S762', true);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('FUJITSU', 'LIFEBOOK S792', 'Fujitsu Lifebook S792', true);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('FUJITSU CLIENT COMPUTING LIMITED', 'LIFEBOOK U7411', 'Fujitsu Lifebook U7411', true);

  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('Dell Inc.', 'Latitude 5480', 'Dell Latitude 5480', false);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('Dell Inc.', 'Latitude 5501', 'Dell Latitude 5501', false);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('Dell Inc.', 'Latitude 3410', 'Dell Latitude 3410', false);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('Dell Inc.', 'Latitude 7280', 'Dell Latitude 7280', false);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('Dell Inc.', 'Latitude 7380', 'Dell Latitude 7380', false);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('Dell Inc.', 'Latitude 7480', 'Dell Latitude 7480', false);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('Dell Inc.', 'Latitude 7400', 'Dell Latitude 7400', false);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('Dell Inc.', 'Latitude E4200', 'Dell Latitude E4200', true);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('Dell Inc.', 'Latitude E4300', 'Dell Latitude E4300', true);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('Dell Inc.', 'Latitude E4310', 'Dell Latitude E4310', true);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('Dell Inc.', 'Latitude E5470', 'Dell Latitude E5470', false);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('Dell Inc.', 'Latitude E5530 non-vPro', 'Dell Latitude E5530 non-vPro', false);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('Dell Inc.', 'Latitude E6220', 'Dell Latitude E6220', true);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('Dell Inc.', 'Latitude E6230', 'Dell Latitude E6230', true);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('Dell Inc.', 'Latitude E6320', 'Dell Latitude E6320', true);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('Dell Inc.', 'Latitude E6330', 'Dell Latitude E6330', true);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('Dell Inc.', 'Latitude E6530', 'Dell Latitude E6530', true);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('Dell Inc.', 'Latitude E7240', 'Dell Latitude E7240', true);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('Dell Inc.', 'Latitude E7250', 'Dell Latitude E7250', true);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('Dell Inc.', 'Latitude E7270', 'Dell Latitude E7270', false);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('Dell Inc.', 'Latitude E7440', 'Dell Latitude E7440', true);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('Dell Inc.', 'Latitude E7470', 'Dell Latitude E7470', false);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('Dell Inc.', 'Latitude 7410', 'Dell Latitude 7410', false);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('Dell Inc.', 'Latitude 7420', 'Dell Latitude 7420', false);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('Dell Inc.', 'Latitude 7520', 'Dell Latitude 7520', false);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('Dell Inc.', 'Latitude 5510', 'Dell Latitude 5510', false);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('Dell Inc.', 'Latitude 5511', 'Dell Latitude 5511', false);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('Dell Inc.', 'Latitude 5520', 'Dell Latitude 5520', false);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('Dell Inc.', 'Latitude 5521', 'Dell Latitude 5521', false);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('Dell Inc.', 'OptiPlex 7040', 'Dell OptiPlex 7040', false);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('Dell Inc.', 'OptiPlex 7050', 'Dell OptiPlex 7050', false);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('Dell Inc.', 'Precision 5510', 'Dell Precision 5510', false);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('Dell Inc.', 'Precision 5750', 'Dell Precision 5750', false);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('Dell Inc.', 'Precision M4800', 'Dell Precision M4800', true);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('Dell Inc.', 'Precision 7550', 'Dell Precision 7550', false);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('Dell Inc.', 'Precision 7560', 'Dell Precision 7560', false);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('Dell Inc.', 'Vostro 1320', 'Dell Vostro 1320', true);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('Dell Inc.', 'XPS 15 9560', 'Dell XPS 15 9560', false);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('Dell Inc.', 'XPS 15 9570', 'Dell XPS 15 9570', false);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('Dell Inc.', 'XPS 15 9575', 'Dell XPS 15 9575', false);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('Dell Inc.', 'Latitude 9420', 'Dell Latitude 9420', false);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('HP', 'HP ProBook 430 G6', 'HP ProBook 430 G6', false);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('HP', 'HP ProBook 430 G7', 'HP ProBook 430 G7', false);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('HP', 'HP ProBook 430 G8 Notebook PC', 'HP ProBook 430 G8', false);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('HP', 'HP ProDesk 400 G5 Desktop Mini', 'HP ProDesk 400 G5 Desktop Mini', false);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('HP', 'HP 245 G8 Notebook PC', 'HP 245 G8', false);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('CRABBIT', 'ENCODER BUY-7695', 'Crabbit Encoder BUY-7695', true);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('Gigabyte Technology Co., Ltd.', 'Z390 DESIGNARE', 'Regard RDCP - 001958/001753', true);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('Gigabyte Technology Co., Ltd.', 'X299 DESIGNARE EX', 'Regard RDCP - 001752', true);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('To Be Filled By O.E.M.', 'To Be Filled By O.E.M.', 'Trinity M2004174', false);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('ASUSTeK COMPUTER INC.', 'PN40', 'Asus PN40', false);
  INSERT INTO supported_products ("manufacturer", "product_name", "description", "support_booting_from_legacy_bios")
    VALUES ('HUAWEI', 'KLVL-WXXW', 'Huawei MateBook 14 (AMD)', false);
COMMIT;


/* Профили драйверов */
BEGIN;
  SET SCHEMA 'deploy';

  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Samsung NP900X W7}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'SAMSUNG ELECTRONICS CO., LTD.' AND sp.product_name = '900X3C/900X3D/900X4C/900X4D'
      AND sos.os_name = 'Windows 7';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Samsung NP900X W7}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'SAMSUNG ELECTRONICS CO., LTD.' AND sp.product_name = '900X3C/900X3D/900X3E/900X4C/900X4D'
      AND sos.os_name = 'Windows 7';

  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Fujitsu Lifebook P771 W7}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'FUJITSU' AND sp.product_name = 'LIFEBOOK P771' AND sos.os_name = 'Windows 7';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Fujitsu Lifebook P771 W10}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'FUJITSU' AND sp.product_name = 'LIFEBOOK P771' AND sos.os_name = 'Windows 10';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Fujitsu Lifebook P772 W7}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'FUJITSU' AND sp.product_name = 'LIFEBOOK P772' AND sos.os_name = 'Windows 7';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Fujitsu Lifebook P772 W8.1}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'FUJITSU' AND sp.product_name = 'LIFEBOOK P772' AND sos.os_name = 'Windows 8.1';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Fujitsu Lifebook P772 W10}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'FUJITSU' AND sp.product_name = 'LIFEBOOK P772' AND sos.os_name = 'Windows 10';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Fujitsu Lifebook S761 W7}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'FUJITSU' AND sp.product_name = 'LIFEBOOK S761' AND sos.os_name = 'Windows 7';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Fujitsu Lifebook S761 W10}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'FUJITSU' AND sp.product_name = 'LIFEBOOK S761' AND sos.os_name = 'Windows 10';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Fujitsu Lifebook S762 W7}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'FUJITSU' AND sp.product_name = 'LIFEBOOK S762' AND sos.os_name = 'Windows 7';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Fujitsu Lifebook S762 W8.1}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'FUJITSU' AND sp.product_name = 'LIFEBOOK S762' AND sos.os_name = 'Windows 8.1';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Fujitsu Lifebook S762 W10}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'FUJITSU' AND sp.product_name = 'LIFEBOOK S762' AND sos.os_name = 'Windows 10';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Fujitsu Lifebook S792 W7}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'FUJITSU' AND sp.product_name = 'LIFEBOOK S792' AND sos.os_name = 'Windows 7';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Fujitsu Lifebook S792 W8.1}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'FUJITSU' AND sp.product_name = 'LIFEBOOK S792' AND sos.os_name = 'Windows 8.1';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Fujitsu Lifebook S792 W10}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'FUJITSU' AND sp.product_name = 'LIFEBOOK S792' AND sos.os_name = 'Windows 10';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Fujitsu Lifebook U7411 W10}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'FUJITSU CLIENT COMPUTING LIMITED' AND sp.product_name = 'LIFEBOOK U7411' AND sos.os_name = 'Windows 10';

  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Crabbit Encoder BUY-7695 W10}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'CRABBIT' AND sp.product_name = 'ENCODER BUY-7695' AND sos.os_name = 'Windows 10';

  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Panasonic Toughbook CF-53 W10}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'Panasonic Corporation' AND sp.product_name = 'CF-53SAWZYM1' AND sos.os_name = 'Windows 10';

  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Dell Latitude E4200 W7}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'Dell Inc.' AND sp.product_name = 'Latitude E4200' AND sos.os_name = 'Windows 7';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Dell Latitude E4300 W7}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'Dell Inc.' AND sp.product_name = 'Latitude E4300' AND sos.os_name = 'Windows 7';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Dell Latitude E4310 W7}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'Dell Inc.' AND sp.product_name = 'Latitude E4310' AND sos.os_name = 'Windows 7';

  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Dell Latitude E5530 W7}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'Dell Inc.' AND sp.product_name = 'Latitude E5530 non-vPro' AND sos.os_name = 'Windows 7';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Dell Latitude E5530 W8.1}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'Dell Inc.' AND sp.product_name = 'Latitude E5530 non-vPro' AND sos.os_name = 'Windows 8.1';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Dell Latitude E5530 W10}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'Dell Inc.' AND sp.product_name = 'Latitude E5530 non-vPro' AND sos.os_name = 'Windows 10';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Dell Latitude E5470 W10}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'Dell Inc.' AND sp.product_name = 'Latitude E5470' AND sos.os_name = 'Windows 10';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Dell Latitude 5480 W10}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'Dell Inc.' AND sp.product_name = 'Latitude 5480' AND sos.os_name = 'Windows 10';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Dell Latitude 5510 W10}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'Dell Inc.' AND sp.product_name = 'Latitude 5510' AND sos.os_name = 'Windows 10';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Dell Latitude 5511 W10}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'Dell Inc.' AND sp.product_name = 'Latitude 5511' AND sos.os_name = 'Windows 10';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Dell Latitude 5520 W10}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'Dell Inc.' AND sp.product_name = 'Latitude 5520' AND sos.os_name = 'Windows 10';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Dell Latitude 5521 W10}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'Dell Inc.' AND sp.product_name = 'Latitude 5521' AND sos.os_name = 'Windows 10';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Dell Latitude 5521 W11}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'Dell Inc.' AND sp.product_name = 'Latitude 5521' AND sos.os_name = 'Windows 11';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Dell Latitude 3410 W10}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'Dell Inc.' AND sp.product_name = 'Latitude 3410' AND sos.os_name = 'Windows 10';

  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Dell Latitude E6220 W7}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'Dell Inc.' AND sp.product_name = 'Latitude E6220' AND sos.os_name = 'Windows 7';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Dell Latitude E6220 W10}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'Dell Inc.' AND sp.product_name = 'Latitude E6220' AND sos.os_name = 'Windows 10';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Dell Latitude E6320 W7}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'Dell Inc.' AND sp.product_name = 'Latitude E6320' AND sos.os_name = 'Windows 7';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Dell Latitude E6230 W7}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'Dell Inc.' AND sp.product_name = 'Latitude E6230' AND sos.os_name = 'Windows 7';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Dell Latitude E6230 W8.1}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'Dell Inc.' AND sp.product_name = 'Latitude E6230' AND sos.os_name = 'Windows 8.1';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Dell Latitude E6230 W10}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'Dell Inc.' AND sp.product_name = 'Latitude E6230' AND sos.os_name = 'Windows 10';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Dell Latitude E6330 W7}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'Dell Inc.' AND sp.product_name = 'Latitude E6330' AND sos.os_name = 'Windows 7';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Dell Latitude E6330 W8.1}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'Dell Inc.' AND sp.product_name = 'Latitude E6330' AND sos.os_name = 'Windows 8.1';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Dell Latitude E6330 W10}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'Dell Inc.' AND sp.product_name = 'Latitude E6330' AND sos.os_name = 'Windows 10';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Dell Latitude E6530 W7}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'Dell Inc.' AND sp.product_name = 'Latitude E6530' AND sos.os_name = 'Windows 7';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Dell Latitude E6530 W8.1}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'Dell Inc.' AND sp.product_name = 'Latitude E6530' AND sos.os_name = 'Windows 8.1';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Dell Latitude E6530 W10}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'Dell Inc.' AND sp.product_name = 'Latitude E6530' AND sos.os_name = 'Windows 10';

  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Dell Latitude E7240 W7}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'Dell Inc.' AND sp.product_name = 'Latitude E7240' AND sos.os_name = 'Windows 7';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Dell Latitude E7240 W8.1}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'Dell Inc.' AND sp.product_name = 'Latitude E7240' AND sos.os_name = 'Windows 8.1';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Dell Latitude E7240 W10}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'Dell Inc.' AND sp.product_name = 'Latitude E7240' AND sos.os_name = 'Windows 10';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Dell Latitude E7440 W7}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'Dell Inc.' AND sp.product_name = 'Latitude E7440' AND sos.os_name = 'Windows 7';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Dell Latitude E7440 W8.1}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'Dell Inc.' AND sp.product_name = 'Latitude E7440' AND sos.os_name = 'Windows 8.1';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Dell Latitude E7440 W10}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'Dell Inc.' AND sp.product_name = 'Latitude E7440' AND sos.os_name = 'Windows 10';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Dell Latitude E7250 W7}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'Dell Inc.' AND sp.product_name = 'Latitude E7250' AND sos.os_name = 'Windows 7';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Dell Latitude E7250 W8.1}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'Dell Inc.' AND sp.product_name = 'Latitude E7250' AND sos.os_name = 'Windows 8.1';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Dell Latitude E7250 W10}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'Dell Inc.' AND sp.product_name = 'Latitude E7250' AND sos.os_name = 'Windows 10';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Dell Latitude E7270 W7}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'Dell Inc.' AND sp.product_name = 'Latitude E7270' AND sos.os_name = 'Windows 7';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Dell Latitude E7270 W8.1}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'Dell Inc.' AND sp.product_name = 'Latitude E7270' AND sos.os_name = 'Windows 8.1';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Dell Latitude E7270 W10}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'Dell Inc.' AND sp.product_name = 'Latitude E7270' AND sos.os_name = 'Windows 10';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Dell Latitude E7470 W7}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'Dell Inc.' AND sp.product_name = 'Latitude E7470' AND sos.os_name = 'Windows 7';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Dell Latitude E7470 W8.1}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'Dell Inc.' AND sp.product_name = 'Latitude E7470' AND sos.os_name = 'Windows 8.1';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Dell Latitude E7470 W10}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'Dell Inc.' AND sp.product_name = 'Latitude E7470' AND sos.os_name = 'Windows 10';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Dell Latitude 7280 W10}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'Dell Inc.' AND sp.product_name = 'Latitude 7280' AND sos.os_name = 'Windows 10';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Dell Latitude 7380 W10}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'Dell Inc.' AND sp.product_name = 'Latitude 7380' AND sos.os_name = 'Windows 10';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Dell Latitude 7480 W10}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'Dell Inc.' AND sp.product_name = 'Latitude 7480' AND sos.os_name = 'Windows 10';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Dell Latitude 7410 W10}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'Dell Inc.' AND sp.product_name = 'Latitude 7410' AND sos.os_name = 'Windows 10';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Dell Latitude 7420 W10}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'Dell Inc.' AND sp.product_name = 'Latitude 7420' AND sos.os_name = 'Windows 10';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Dell Latitude 7520 W10}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'Dell Inc.' AND sp.product_name = 'Latitude 7520' AND sos.os_name = 'Windows 10';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Dell Latitude 7520 W11}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'Dell Inc.' AND sp.product_name = 'Latitude 7520' AND sos.os_name = 'Windows 11';

  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Dell Latitude 7400 W10}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'Dell Inc.' AND sp.product_name = 'Latitude 7400' AND sos.os_name = 'Windows 10';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Dell Latitude 5501 W10}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'Dell Inc.' AND sp.product_name = 'Latitude 5501' AND sos.os_name = 'Windows 10';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Dell Latitude 9420 W10}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'Dell Inc.' AND sp.product_name = 'Latitude 9420' AND sos.os_name = 'Windows 10';

  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Dell OptiPlex 7040 W10}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'Dell Inc.' AND sp.product_name = 'OptiPlex 7040' AND sos.os_name = 'Windows 10';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Dell OptiPlex 7050 W10}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'Dell Inc.' AND sp.product_name = 'OptiPlex 7050' AND sos.os_name = 'Windows 10';

  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Dell XPS 15 9560 W10}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'Dell Inc.' AND sp.product_name = 'XPS 15 9560' AND sos.os_name = 'Windows 10';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Dell XPS 15 9570 W10}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'Dell Inc.' AND sp.product_name = 'XPS 15 9570' AND sos.os_name = 'Windows 10';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Dell XPS 15 9575 W10}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'Dell Inc.' AND sp.product_name = 'XPS 15 9575' AND sos.os_name = 'Windows 10';

  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Dell Vostro 1320 W7}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'Dell Inc.' AND sp.product_name = 'Vostro 1320' AND sos.os_name = 'Windows 7';

  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Dell Precision M4800 W7}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'Dell Inc.' AND sp.product_name = 'Precision M4800' AND sos.os_name = 'Windows 7';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Dell Precision M4800 W8.1}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'Dell Inc.' AND sp.product_name = 'Precision M4800' AND sos.os_name = 'Windows 8.1';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Dell Precision M4800 W10}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'Dell Inc.' AND sp.product_name = 'Precision M4800' AND sos.os_name = 'Windows 10';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Dell Precision 5510 W10}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'Dell Inc.' AND sp.product_name = 'Precision 5510' AND sos.os_name = 'Windows 10';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Dell Precision 5750 W10}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'Dell Inc.' AND sp.product_name = 'Precision 5750' AND sos.os_name = 'Windows 10';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Dell Precision 7550 W10}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'Dell Inc.' AND sp.product_name = 'Precision 7550' AND sos.os_name = 'Windows 10';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Dell Precision 7560 W10}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'Dell Inc.' AND sp.product_name = 'Precision 7560' AND sos.os_name = 'Windows 10';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Dell Precision 7560 W11}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'Dell Inc.' AND sp.product_name = 'Precision 7560' AND sos.os_name = 'Windows 11';

  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Lenovo Thinkpad X220 W7}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'LENOVO' AND sp.product_name = '4290RW1' AND sos.os_name = 'Windows 7';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Lenovo Thinkpad X220 W7}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'LENOVO' AND sp.product_name = '4291E57' AND sos.os_name = 'Windows 7';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Lenovo Thinkpad X220 W7}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'LENOVO' AND sp.product_name = '4291IY3' AND sos.os_name = 'Windows 7';

  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Lenovo Thinkpad E570 W10}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'LENOVO' AND sp.product_name = '20H5S00400' AND sos.os_name = 'Windows 10';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Lenovo Thinkpad L430 W7}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'LENOVO' AND sp.product_name = '2465BC6' AND sos.os_name = 'Windows 7';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Lenovo Thinkpad L530 W7}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'LENOVO' AND sp.product_name = '24791Q3' AND sos.os_name = 'Windows 7';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Lenovo Thinkpad L530 W7}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'LENOVO' AND sp.product_name = '2479B96' AND sos.os_name = 'Windows 7';

  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Lenovo Thinkpad T510(i) W7}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'LENOVO' AND sp.product_name = '4384HK8' AND sos.os_name = 'Windows 7';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Lenovo Thinkpad T510(i) W7}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'LENOVO' AND sp.product_name = '4349NV5' AND sos.os_name = 'Windows 7';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Lenovo Thinkpad T510(i) W7}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'LENOVO' AND sp.product_name = '4349PQ9' AND sos.os_name = 'Windows 7';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Lenovo Thinkpad T510(i) W7}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'LENOVO' AND sp.product_name = '43146AG' AND sos.os_name = 'Windows 7';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Lenovo Thinkpad T510(i) W7}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'LENOVO' AND sp.product_name = '43146BG' AND sos.os_name = 'Windows 7';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Lenovo Thinkpad T510(i) W7}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'LENOVO' AND sp.product_name = '4349PZ8' AND sos.os_name = 'Windows 7';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Lenovo Thinkpad T520 W7}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'LENOVO' AND sp.product_name = '42406FG' AND sos.os_name = 'Windows 7';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Lenovo Thinkpad T520 W7}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'LENOVO' AND sp.product_name = '42403FG' AND sos.os_name = 'Windows 7';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Lenovo Thinkpad T520 W7}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'LENOVO' AND sp.product_name = '4243R67' AND sos.os_name = 'Windows 7';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Lenovo Thinkpad T520 W7}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'LENOVO' AND sp.product_name = '42406EG' AND sos.os_name = 'Windows 7';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Lenovo Thinkpad T530 W7}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'LENOVO' AND sp.product_name = '23924SG' AND sos.os_name = 'Windows 7';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Lenovo Thinkpad T530 W7}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'LENOVO' AND sp.product_name = '24298W3' AND sos.os_name = 'Windows 7';

  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Lenovo Thinkpad T550 W7}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'LENOVO' AND sp.product_name = '20CK001WRT' AND sos.os_name = 'Windows 7';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Lenovo Thinkpad T550 W8.1}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'LENOVO' AND sp.product_name = '20CK001WRT' AND sos.os_name = 'Windows 8.1';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Lenovo Thinkpad T550 W10}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'LENOVO' AND sp.product_name = '20CK001WRT' AND sos.os_name = 'Windows 10';

  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Lenovo Thinkpad T560 W7}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'LENOVO' AND sp.product_name = '20FH001BRT' AND sos.os_name = 'Windows 7';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Lenovo Thinkpad T560 W8.1}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'LENOVO' AND sp.product_name = '20FH001BRT' AND sos.os_name = 'Windows 8.1';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Lenovo Thinkpad T560 W10}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'LENOVO' AND sp.product_name = '20FH001BRT' AND sos.os_name = 'Windows 10';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Lenovo Thinkpad T560 W7}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'LENOVO' AND sp.product_name = '20FJS12X00' AND sos.os_name = 'Windows 7';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Lenovo Thinkpad T560 W8.1}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'LENOVO' AND sp.product_name = '20FJS12X00' AND sos.os_name = 'Windows 8.1';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Lenovo Thinkpad T560 W10}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'LENOVO' AND sp.product_name = '20FJS12X00' AND sos.os_name = 'Windows 10';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Lenovo Thinkpad T560 W7}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'LENOVO' AND sp.product_name = '20FJS3H100' AND sos.os_name = 'Windows 7';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Lenovo Thinkpad T560 W8.1}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'LENOVO' AND sp.product_name = '20FJS3H100' AND sos.os_name = 'Windows 8.1';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Lenovo Thinkpad T560 W10}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'LENOVO' AND sp.product_name = '20FJS3H100' AND sos.os_name = 'Windows 10';

  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Lenovo Thinkpad T570 W10}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'LENOVO' AND sp.product_name = '20HAS20T00' AND sos.os_name = 'Windows 10';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Lenovo Thinkpad T580 W10}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'LENOVO' AND sp.product_name = '20LAS0VY00' AND sos.os_name = 'Windows 10';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Lenovo Thinkpad T580 W10}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'LENOVO' AND sp.product_name = '20LAS5V100' AND sos.os_name = 'Windows 10';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Lenovo Thinkpad T590 W10}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'LENOVO' AND sp.product_name = '20N5S48K00' AND sos.os_name = 'Windows 10';

  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Lenovo Thinkpad Yoga 260 W7}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'LENOVO' AND sp.product_name = '20FD002TRT' AND sos.os_name = 'Windows 7';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Lenovo Thinkpad Yoga 260 W8.1}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'LENOVO' AND sp.product_name = '20FD002TRT' AND sos.os_name = 'Windows 8.1';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Lenovo Thinkpad Yoga 260 W10}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'LENOVO' AND sp.product_name = '20FD002TRT' AND sos.os_name = 'Windows 10';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Lenovo Thinkpad Yoga 3rd gen W10}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'LENOVO' AND sp.product_name = '20LF000TRT' AND sos.os_name = 'Windows 10';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Lenovo Thinkpad X1 Yoga 4th gen W10}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'LENOVO' AND sp.product_name = '20QF0024RT' AND sos.os_name = 'Windows 10';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Lenovo Thinkpad X1 Yoga 5th gen W10}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'LENOVO' AND sp.product_name = '20UB003XRT' AND sos.os_name = 'Windows 10';


  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Lenovo Thinkpad X1 Carbon 1st gen W7}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'LENOVO' AND sp.product_name = '34609C0' AND sos.os_name = 'Windows 7';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Lenovo Thinkpad X1 Carbon 1st gen W7}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'LENOVO' AND sp.product_name = '3460AS2' AND sos.os_name = 'Windows 7';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Lenovo Thinkpad X1 Carbon 1st gen W7}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'LENOVO' AND sp.product_name = '34482E7' AND sos.os_name = 'Windows 7';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Lenovo Thinkpad X1 Carbon 1st gen W7}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'LENOVO' AND sp.product_name = '34606E8' AND sos.os_name = 'Windows 7';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Lenovo Thinkpad X1 Carbon 1st gen W7}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'LENOVO' AND sp.product_name = '3448AWG' AND sos.os_name = 'Windows 7';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Lenovo Thinkpad X1 Carbon 2nd gen W7}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'LENOVO' AND sp.product_name = '20A8A093RT' AND sos.os_name = 'Windows 7';

  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Lenovo Thinkpad X1 Carbon 3rd gen W7}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'LENOVO' AND sp.product_name = '20BS006NRT' AND sos.os_name = 'Windows 7';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Lenovo Thinkpad X1 Carbon 3rd gen W8.1}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'LENOVO' AND sp.product_name = '20BS006NRT' AND sos.os_name = 'Windows 8.1';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Lenovo Thinkpad X1 Carbon 3rd gen W10}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'LENOVO' AND sp.product_name = '20BS006NRT' AND sos.os_name = 'Windows 10';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Lenovo Thinkpad X1 Carbon 4th gen W7}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'LENOVO' AND sp.product_name = '20FCS1DW00' AND sos.os_name = 'Windows 7';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Lenovo Thinkpad X1 Carbon 4th gen W8.1}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'LENOVO' AND sp.product_name = '20FCS1DW00' AND sos.os_name = 'Windows 8.1';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Lenovo Thinkpad X1 Carbon 4th gen W10}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'LENOVO' AND sp.product_name = '20FCS1DW00' AND sos.os_name = 'Windows 10';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Lenovo Thinkpad X1 Carbon 4th gen W7}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'LENOVO' AND sp.product_name = '20FCS52M00' AND sos.os_name = 'Windows 7';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Lenovo Thinkpad X1 Carbon 4th gen W8.1}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'LENOVO' AND sp.product_name = '20FCS52M00' AND sos.os_name = 'Windows 8.1';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Lenovo Thinkpad X1 Carbon 4th gen W10}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'LENOVO' AND sp.product_name = '20FCS52M00' AND sos.os_name = 'Windows 10';

  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Lenovo Thinkpad X1 Carbon 5th gen W10}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'LENOVO' AND sp.product_name = '20HQS6Y800' AND sos.os_name = 'Windows 10';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Lenovo Thinkpad X1 Carbon 5th gen W10}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'LENOVO' AND sp.product_name = '20HR002NRT' AND sos.os_name = 'Windows 10';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Lenovo Thinkpad X1 Carbon 5th gen W10}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'LENOVO' AND sp.product_name = '20HR005BRT' AND sos.os_name = 'Windows 10';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Lenovo Thinkpad X1 Carbon 5th gen W10}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'LENOVO' AND sp.product_name = '20HQS47H00' AND sos.os_name = 'Windows 10';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Lenovo Thinkpad X1 Carbon 5th gen W10}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'LENOVO' AND sp.product_name = '20HR0021RT' AND sos.os_name = 'Windows 10';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Lenovo Thinkpad X1 Carbon 6th gen W10}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'LENOVO' AND sp.product_name = '20KH006JRT' AND sos.os_name = 'Windows 10';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Lenovo Thinkpad X1 Carbon 6th gen W10}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'LENOVO' AND sp.product_name = '20KGS4JC00' AND sos.os_name = 'Windows 10';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Lenovo Thinkpad X1 Carbon 6th gen W10}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'LENOVO' AND sp.product_name = '20KGS6PC00' AND sos.os_name = 'Windows 10';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Lenovo Thinkpad X1 Carbon 6th gen W10}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'LENOVO' AND sp.product_name = '20KGSBUL00' AND sos.os_name = 'Windows 10';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Lenovo Thinkpad X1 Carbon 6th gen W10}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'LENOVO' AND sp.product_name = '20KGSBUK00' AND sos.os_name = 'Windows 10';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Lenovo Thinkpad X1 Carbon 7th gen W10}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'LENOVO' AND sp.product_name = '20QES1F100' AND sos.os_name = 'Windows 10';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Lenovo Thinkpad X1 Carbon 8th gen W10}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'LENOVO' AND sp.product_name = '20UAS89500' AND sos.os_name = 'Windows 10';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Lenovo Thinkpad X1 Carbon 8th gen W10}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'LENOVO' AND sp.product_name = '20U90003RT' AND sos.os_name = 'Windows 10';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Lenovo Thinkpad X1 Carbon 8th gen W10}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'LENOVO' AND sp.product_name = '20UASDDS00' AND sos.os_name = 'Windows 10';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Lenovo Thinkpad X1 Carbon 8th gen W10}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'LENOVO' AND sp.product_name = '20U90001RT' AND sos.os_name = 'Windows 10';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Lenovo Thinkpad X1 Carbon 9th gen W10}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'LENOVO' AND sp.product_name = '20XXS0PS00' AND sos.os_name = 'Windows 10';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Lenovo Thinkpad X1 Carbon 9th gen W10}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'LENOVO' AND sp.product_name = '20XW005GRT' AND sos.os_name = 'Windows 10';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Lenovo Thinkpad X1 Carbon 9th gen W10}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'LENOVO' AND sp.product_name = '20XW0026RT' AND sos.os_name = 'Windows 10';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Lenovo Thinkpad X1 Nano 1st gen (Intel) W10}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'LENOVO' AND sp.product_name = '20UN005LRT' AND sos.os_name = 'Windows 10';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Lenovo Thinkpad X13 1st gen (Intel) W10}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'LENOVO' AND sp.product_name = '20T2003JRT' AND sos.os_name = 'Windows 10';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Lenovo Thinkpad X13 1st gen (Intel) W10}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'LENOVO' AND sp.product_name = '20T20032RT' AND sos.os_name = 'Windows 10';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Lenovo Thinkpad X13 1st gen (AMD) W10}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'LENOVO' AND sp.product_name = '20UF0038RT' AND sos.os_name = 'Windows 10';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Lenovo Thinkpad T14s 1st gen (Intel) W10}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'LENOVO' AND sp.product_name = '20T1S6K100' AND sos.os_name = 'Windows 10';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Lenovo Thinkpad T14s 1st gen (Intel) W10}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'LENOVO' AND sp.product_name = '20T0004PRT' AND sos.os_name = 'Windows 10';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Lenovo Thinkpad T14s 1st gen (Intel) W10}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'LENOVO' AND sp.product_name = '20T0004RRT' AND sos.os_name = 'Windows 10';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Lenovo Thinkpad T14s 1st gen (Intel) W10}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'LENOVO' AND sp.product_name = '20T00041RT' AND sos.os_name = 'Windows 10';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Lenovo Thinkpad T14s 1st gen (Intel) W10}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'LENOVO' AND sp.product_name = '20T00047RT' AND sos.os_name = 'Windows 10';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Lenovo Thinkpad T14s 1st gen (Intel) W10}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'LENOVO' AND sp.product_name = '20T0001CRT' AND sos.os_name = 'Windows 10';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Lenovo Thinkpad T14s 1st gen (Intel) W10}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'LENOVO' AND sp.product_name = '20T0001DRT' AND sos.os_name = 'Windows 10';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Lenovo Thinkpad T14s 1st gen (Intel) W10}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'LENOVO' AND sp.product_name = '20T0001ERT' AND sos.os_name = 'Windows 10';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Lenovo Thinkpad T14s 1st gen (AMD) W10}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'LENOVO' AND sp.product_name = '20UH000GUS' AND sos.os_name = 'Windows 10';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Lenovo Thinkpad T14s 1st gen (AMD) W10}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'LENOVO' AND sp.product_name = '20UH0017RT' AND sos.os_name = 'Windows 10';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Lenovo Thinkpad T14s 1st gen (AMD) W10}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'LENOVO' AND sp.product_name = '20UH0033RT' AND sos.os_name = 'Windows 10';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Lenovo Thinkpad T14s 1st gen (AMD) W10}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'LENOVO' AND sp.product_name = '20UH0035RT' AND sos.os_name = 'Windows 10';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Lenovo Thinkpad T14s 1st gen (AMD) W10}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'LENOVO' AND sp.product_name = '20UH0036RT' AND sos.os_name = 'Windows 10';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Lenovo Thinkpad T14s 1st gen (AMD) W10}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'LENOVO' AND sp.product_name = '20UH0038RT' AND sos.os_name = 'Windows 10';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Lenovo Thinkpad T14s 1st gen (AMD) W10}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'LENOVO' AND sp.product_name = '20UH003BRT' AND sos.os_name = 'Windows 10';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Lenovo Thinkpad T14s 1st gen (AMD) W10}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'LENOVO' AND sp.product_name = '20UH003FRT' AND sos.os_name = 'Windows 10';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Lenovo Thinkpad T14s 1st gen (AMD) W10}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'LENOVO' AND sp.product_name = '20UH003HRT' AND sos.os_name = 'Windows 10';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Lenovo Thinkpad T14s 1st gen (AMD) W10}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'LENOVO' AND sp.product_name = '20UH002CRT' AND sos.os_name = 'Windows 10';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Lenovo Thinkpad T14s 1st gen (AMD) W10}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'LENOVO' AND sp.product_name = '20UH0032RT' AND sos.os_name = 'Windows 10';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Lenovo Thinkpad T14s 1st gen (AMD) W10}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'LENOVO' AND sp.product_name = '20UH001JRT' AND sos.os_name = 'Windows 10';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Lenovo Thinkpad T14s 1st gen (AMD) W10}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'LENOVO' AND sp.product_name = '20UH001HRT' AND sos.os_name = 'Windows 10';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Lenovo Thinkpad T14s 1st gen (AMD) W10}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'LENOVO' AND sp.product_name = '20UH001RRT' AND sos.os_name = 'Windows 10';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Lenovo Thinkpad T14s 2nd gen (Intel) W10}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'LENOVO' AND sp.product_name = '20WM009SRT' AND sos.os_name = 'Windows 10';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Lenovo Thinkpad T14s 2nd gen (Intel) W10}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'LENOVO' AND sp.product_name = '20WM009RRT' AND sos.os_name = 'Windows 10';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Lenovo Thinkpad T14 2nd gen (Intel) W10}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'LENOVO' AND sp.product_name = '20W0000ERT' AND sos.os_name = 'Windows 10';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Lenovo Thinkpad P15 1st gen W10}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'LENOVO' AND sp.product_name = '20ST006RRT' AND sos.os_name = 'Windows 10';

  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{HP ProBook 430 G6 W10}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'HP' AND sp.product_name = 'HP ProBook 430 G6' AND sos.os_name = 'Windows 10';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{HP ProBook 430 G7 W10}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'HP' AND sp.product_name = 'HP ProBook 430 G7' AND sos.os_name = 'Windows 10';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{HP ProBook 430 G8 W10}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'HP' AND sp.product_name = 'HP ProBook 430 G8 Notebook PC' AND sos.os_name = 'Windows 10';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{HP ProDesk 400 G5 Desktop Mini W10}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'HP' AND sp.product_name = 'HP ProDesk 400 G5 Desktop Mini' AND sos.os_name = 'Windows 10';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{HP 245 G8 W10}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'HP' AND sp.product_name = 'HP 245 G8 Notebook PC' AND sos.os_name = 'Windows 10';

  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Aquarius Pro P30 S67, Elt E50 S66 (Q67) W7}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'Aquarius' AND sp.product_name = 'Aquarius Std, Pro, Elt' AND sos.os_name = 'Windows 7';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Aquarius Pro P30 S67, Elt E50 S66 (Q67) W8.1}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'Aquarius' AND sp.product_name = 'Aquarius Std, Pro, Elt' AND sos.os_name = 'Windows 8.1';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Aquarius Pro P30 S67, Elt E50 S66 (Q67) W7}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'Aquarius' AND sp.product_name = 'Aquarius Pro P30 S67' AND sos.os_name = 'Windows 7';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Aquarius Pro P30 S67, Elt E50 S66 (Q67) W8.1}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'Aquarius' AND sp.product_name = 'Aquarius Pro P30 S67' AND sos.os_name = 'Windows 8.1';

  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Aquarius G40 S42 W7}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'Aquarius' AND sp.product_name = 'Aquarius Server' AND sos.os_name = 'Windows 7';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Aquarius G40 S42 W8.1}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'Aquarius' AND sp.product_name = 'Aquarius Server' AND sos.os_name = 'Windows 8.1';

  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Aquarius Pro G40 S48 SRVBUY-163 W10}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'Aquarius' AND sp.product_name = 'Pro G40 S48 SRVBUY-163' AND sos.os_name = 'Windows 10';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Aquarius Pro G40 S58 (BUY-8324, 10355, 12348) W10}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'Aquarius' AND sp.product_name = 'Pro G40 S58 BUY-8324' AND sos.os_name = 'Windows 10';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Aquarius Pro G40 S58 (BUY-8324, 10355, 12348) W10}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'Aquarius' AND sp.product_name = 'Pro G40 S58 BUY-10355' AND sos.os_name = 'Windows 10';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Aquarius Pro G40 S58 (BUY-8324, 10355, 12348) W10}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'Aquarius' AND sp.product_name = 'Pro G40 S58 BUY-12348' AND sos.os_name = 'Windows 10';

  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Aquarius Pro P30 K15 (BUY-2538, 3535) W7}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'Aquarius' AND sp.product_name = 'Pro P30 K15 BUY-2538' AND sos.os_name = 'Windows 7';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Aquarius Pro P30 K15 (BUY-2538, 3535) W8.1}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'Aquarius' AND sp.product_name = 'Pro P30 K15 BUY-2538' AND sos.os_name = 'Windows 8.1';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Aquarius Pro P30 K15 (BUY-2538, 3535) W10}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'Aquarius' AND sp.product_name = 'Pro P30 K15 BUY-2538' AND sos.os_name = 'Windows 10';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Aquarius Pro P30 K15 (BUY-2538, 3535) W7}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'Aquarius' AND sp.product_name = 'Pro P30 K15 BUY-3535' AND sos.os_name = 'Windows 7';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Aquarius Pro P30 K15 (BUY-2538, 3535) W8.1}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'Aquarius' AND sp.product_name = 'Pro P30 K15 BUY-3535' AND sos.os_name = 'Windows 8.1';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Aquarius Pro P30 K15 (BUY-2538, 3535) W10}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'Aquarius' AND sp.product_name = 'Pro P30 K15 BUY-3535' AND sos.os_name = 'Windows 10';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Aquarius Pro P30 K15 (BUY-5322, 8477, 9160) W7}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'Aquarius' AND sp.product_name = 'Pro P30 K15 BUY-5322' AND sos.os_name = 'Windows 7';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Aquarius Pro P30 K15 (BUY-5322, 8477, 9160) W8.1}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'Aquarius' AND sp.product_name = 'Pro P30 K15 BUY-5322' AND sos.os_name = 'Windows 8.1';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Aquarius Pro P30 K15 (BUY-5322, 8477, 9160) W10}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'Aquarius' AND sp.product_name = 'Pro P30 K15 BUY-5322' AND sos.os_name = 'Windows 10';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Aquarius Pro P30 K15 (BUY-5322, 8477, 9160) W10}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'Aquarius' AND sp.product_name = 'Pro P30 K15 BUY-112348' AND sos.os_name = 'Windows 10';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Aquarius Pro P30 K15 (BUY-5322, 8477, 9160) W10}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'Aquarius' AND sp.product_name = 'Pro P30 K15 BUY-10931' AND sos.os_name = 'Windows 10';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Aquarius Pro P30 K15 (BUY-5322, 8477, 9160) W7}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'Aquarius' AND sp.product_name = 'Pro P30 K15 BUY-8477' AND sos.os_name = 'Windows 7';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Aquarius Pro P30 K15 (BUY-5322, 8477, 9160) W8.1}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'Aquarius' AND sp.product_name = 'Pro P30 K15 BUY-8477' AND sos.os_name = 'Windows 8.1';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Aquarius Pro P30 K15 (BUY-5322, 8477, 9160) W10}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'Aquarius' AND sp.product_name = 'Pro P30 K15 BUY-8477' AND sos.os_name = 'Windows 10';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Aquarius Pro P30 K15 (BUY-5322, 8477, 9160) W7}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'Aquarius' AND sp.product_name = 'Pro P30 K15 BUY-9160' AND sos.os_name = 'Windows 7';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Aquarius Pro P30 K15 (BUY-5322, 8477, 9160) W8.1}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'Aquarius' AND sp.product_name = 'Pro P30 K15 BUY-9160' AND sos.os_name = 'Windows 8.1';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Aquarius Pro P30 K15 (BUY-5322, 8477, 9160) W10}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'Aquarius' AND sp.product_name = 'Pro P30 K15 BUY-9160' AND sos.os_name = 'Windows 10';

  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Aquarius QDL E50 S87 W7}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'Aquarius' AND sp.product_name = 'Aquarius Pro, Std, Elt Series' AND sos.os_name = 'Windows 7';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Aquarius QDL E50 S87 W8.1}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'Aquarius' AND sp.product_name = 'Aquarius Pro, Std, Elt Series' AND sos.os_name = 'Windows 8.1';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Aquarius QDL E50 S87 W10}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'Aquarius' AND sp.product_name = 'Aquarius Pro, Std, Elt Series' AND sos.os_name = 'Windows 10';

  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Aquarius Pro G40 S48 BUY-1951 W7}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'Aquarius' AND sp.product_name = 'Pro G40 S48 BUY-1951' AND sos.os_name = 'Windows 7';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Aquarius Pro G40 S48 BUY-1951 W8.1}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'Aquarius' AND sp.product_name = 'Pro G40 S48 BUY-1951' AND sos.os_name = 'Windows 8.1';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Aquarius Pro G40 S48 BUY-1951 W10}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'Aquarius' AND sp.product_name = 'Pro G40 S48 BUY-1951' AND sos.os_name = 'Windows 10';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Aquarius Pro G40 S48 BUY-4146 W7}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'Aquarius' AND sp.product_name = 'Pro G40 S48 BUY-4146' AND sos.os_name = 'Windows 7';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Aquarius Pro G40 S48 BUY-4146 W8.1}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'Aquarius' AND sp.product_name = 'Pro G40 S48 BUY-4146' AND sos.os_name = 'Windows 8.1';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Aquarius Pro G40 S48 BUY-4146 W10}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'Aquarius' AND sp.product_name = 'Pro G40 S48 BUY-4146' AND sos.os_name = 'Windows 10';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Aquarius Pro G40 S48 BUY-5395 W10}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'Aquarius' AND sp.product_name = 'Pro G40 S48 BUY-5395' AND sos.os_name = 'Windows 10';

  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Aquarius Pro P30 S85 BUY-866 W7}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'Aquarius' AND sp.product_name = 'P30 S85 BUY-866' AND sos.os_name = 'Windows 7';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Aquarius Pro P30 S85 BUY-866 W8.1}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'Aquarius' AND sp.product_name = 'P30 S85 BUY-866' AND sos.os_name = 'Windows 8.1';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Aquarius Pro P30 S85 BUY-866 W10}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'Aquarius' AND sp.product_name = 'P30 S85 BUY-866' AND sos.os_name = 'Windows 10';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Aquarius Pro P30 S85 BUY-866 W7}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'Aquarius' AND sp.product_name = 'Pro P30 S85 BUY-866' AND sos.os_name = 'Windows 7';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Aquarius Pro P30 S85 BUY-866 W8.1}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'Aquarius' AND sp.product_name = 'Pro P30 S85 BUY-866' AND sos.os_name = 'Windows 8.1';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Aquarius Pro P30 S85 BUY-866 W10}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'Aquarius' AND sp.product_name = 'Pro P30 S85 BUY-866' AND sos.os_name = 'Windows 10';

  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Aquarius Std S20 S61 W7}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'Aquarius' AND sp.product_name = 'Aquarius Std S20 S61' AND sos.os_name = 'Windows 7';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Aquarius Std S20 S61 W8.1}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'Aquarius' AND sp.product_name = 'Aquarius Std S20 S61' AND sos.os_name = 'Windows 8.1';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Aquarius Std S20 S61 BUY-1305 W7}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'Aquarius' AND sp.product_name = 'Std S20 S61 BUY-1305' AND sos.os_name = 'Windows 7';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Aquarius Std S20 S61 BUY-1305 W8.1}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'Aquarius' AND sp.product_name = 'Std S20 S61 BUY-1305' AND sos.os_name = 'Windows 8.1';

  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Regard RDCP - 001958 001753 W10}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'Gigabyte Technology Co., Ltd.' AND sp.product_name = 'Z390 DESIGNARE' AND sos.os_name = 'Windows 10';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Regard RDCP - 001752 W10}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'Gigabyte Technology Co., Ltd.' AND sp.product_name = 'X299 DESIGNARE EX' AND sos.os_name = 'Windows 10';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Trinity M2004174 W10}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'To Be Filled By O.E.M.' AND sp.product_name = 'To Be Filled By O.E.M.' AND sos.os_name = 'Windows 10';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Asus PN40 W10}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'ASUSTeK COMPUTER INC.' AND sp.product_name = 'PN40' AND sos.os_name = 'Windows 10';
  INSERT INTO drivers_profiles(profile_name, product_name, os, os_version)
    SELECT '{Huawei MateBook 14 (AMD) W10}', sp.id, sos.id, NULL FROM supported_products AS sp, supported_os AS sos
    WHERE sp.manufacturer = 'HUAWEI' AND sp.product_name = 'KLVL-WXXW' AND sos.os_name = 'Windows 10';
COMMIT;

BEGIN;
  SET SCHEMA 'deploy';

  INSERT INTO templates(template_name, template_data)
    VALUES (
            'animals',
            '{"deploy-type": "Animals", "computername": "", "username": "", "os": "Linux", "os-version": "",
                "os-edition": "", "build": "", "os-updated": "", "product-key": "", "with-domain": "", "with-office": "",
                "default-language-profile": "", "language-profile": "", "ou": "", "drivers-profile": "", "template": "animals"}'
           );
  INSERT INTO templates(template_name, template_data)
    VALUES (
           'animals_test',
           '{"deploy-type": "AnimalsTest", "computername": "", "username": "", "os": "Linux", "os-version": "",
               "os-edition": "", "build": "", "os-updated": "", "product-key": "", "with-domain": "", "with-office": "",
               "default-language-profile": "", "language-profile": "", "ou": "", "drivers-profile": "",
               "template": "animals_test"}'
           );
  INSERT INTO templates(template_name, template_data)
    VALUES (
           'wipe',
           '{"deploy-type": "Wipe", "computername": "", "username": "", "os": "Linux", "os-version": "", "os-edition": "",
               "build": "", "os-updated": "", "product-key": "", "with-domain": "", "with-office": "",
               "default-language-profile": "", "language-profile": "", "ou": "", "drivers-profile": "", "template": "wipe"}'
           );
  INSERT INTO templates(template_name, template_data)
    VALUES (
           'market_warehouse',
           '{"ou": "OU=Warehouse,OU=Market,OU=Yandex.Computers,OU=Windows10,OU=WinWorkstations,OU=AllWinWorkstations,DC=ld,DC=yandex,DC=ru",
               "template": "market_warehouse"}'
           );
  INSERT INTO templates(template_name, template_data)
    VALUES (
           'market_standard',
           '{"ou": "OU=Market,OU=Yandex.Computers,OU=Windows10,OU=WinWorkstations,OU=AllWinWorkstations,DC=ld,DC=yandex,DC=ru",
               "template": "market_standard"}'
           );
  INSERT INTO templates(template_name, template_data)
    VALUES (
           'windows_pro',
           '{"os-edition": "Professional", "template": "windows_pro"}'
           );
  INSERT INTO templates(template_name, template_data)
    VALUES (
           'windows_20h2',
           '{"os-edition": "Enterprise", "build": "20H2", "os-updated": "Jan 2022", "template": "windows_20h2"}'
           );
  INSERT INTO templates(template_name, template_data)
    VALUES (
           'windows_21h1',
           '{"os-edition": "Enterprise", "build": "21H1", "os-updated": "Jan 2022", "template": "windows_21h1"}'
           );
  INSERT INTO templates(template_name, template_data)
    VALUES (
           'windows_11_21h2',
           '{"os-edition": "Enterprise", "build": "21H2", "os": "Windows 11", "os-updated": "Jan 2022", "template": "windows_11_21h2"}'
           );
  INSERT INTO templates(template_name, template_data)
    VALUES (
           'linux_pre_deploy',
           '{"computername": "changeme", "username": "changeme", "os": "Linux", "os-version": "20.04", "os-edition": "",
               "build": "", "os-updated": "", "os-release-name": "focal", "product-key": "", "with-domain": "",
               "with-office": "", "default-language-profile": "", "language-profile": "", "ou": "", "drivers-profile": "",
               "template": "linux_pre_deploy"}'
           );
COMMIT;
