/* ROLLBACK; */

BEGIN;
	DROP SCHEMA IF EXISTS deploy CASCADE;
	CREATE SCHEMA deploy;
	SET SCHEMA 'deploy';

	CREATE TYPE uefi_mode AS ENUM ('pcbios', 'efi', 'undefined');

	CREATE TYPE arch AS ENUM ('amd64', 'x86');

	CREATE TABLE templates
    (
        template_name TEXT,
        template_data JSONB
    );

    CREATE UNIQUE INDEX templates_template_name_uindex
        ON templates (template_name);

    ALTER TABLE templates
        ADD CONSTRAINT templates_pk
            PRIMARY KEY (template_name);

    CREATE INDEX templates_data_gindex ON templates USING GIN (template_data JSONB_PATH_OPS);

    CREATE TABLE locale_profiles
	(
		id SERIAL NOT NULL,
		profile_name TEXT NOT NULL,
		ms_system_locale TEXT NOT NULL,
		ms_user_locale TEXT NOT NULL,
		ms_keyboard_locale TEXT NOT NULL,
		ms_ui_language TEXT NOT NULL,
		di_language TEXT NOT NULL,
		di_country TEXT NOT NULL,
		di_locale TEXT NOT NULL,
		di_supported_locales TEXT,
		di_keymap TEXT NOT NULL,
		di_toggle TEXT NOT NULL
	);

	CREATE UNIQUE INDEX locale_profiles_id_uindex
		ON locale_profiles (id);

	CREATE UNIQUE INDEX locale_profiles_profile_name_uindex
		ON locale_profiles (profile_name);

	ALTER TABLE locale_profiles
		ADD CONSTRAINT locale_profiles_pk
			PRIMARY KEY (id);

	CREATE TABLE countries
	(
		id SERIAL NOT NULL,
		country_name TEXT NOT NULL,
		default_locale INTEGER NOT NULL
			CONSTRAINT countries_locale_profiles_id_fk
				REFERENCES locale_profiles,
		code CHAR(2) NOT NULL
	);

	CREATE UNIQUE INDEX countries_country_name_uindex
		ON countries (country_name);

	CREATE UNIQUE INDEX countries_id_uindex
		ON countries (id);

	ALTER TABLE countries
		ADD CONSTRAINT countries_pk
			PRIMARY KEY (id);

	CREATE TABLE cities
	(
		id SERIAL NOT NULL,
		city_name TEXT NOT NULL,
		country INTEGER NOT NULL
			CONSTRAINT cities_countries_id_fk
				REFERENCES countries,
		timezone_ms TEXT NOT NULL,
		timezone_unix TEXT NOT NULL
	);

	CREATE UNIQUE INDEX cities_city_name_uindex
		ON cities (city_name);

	CREATE UNIQUE INDEX cities_id_uindex
		ON cities (id);

	ALTER TABLE cities
		ADD CONSTRAINT cities_pk
			PRIMARY KEY (id);

	CREATE TABLE offices
	(
		id SERIAL NOT NULL,
		office_name TEXT NOT NULL,
		city INTEGER NOT NULL
			CONSTRAINT offices_cities_id_fk
				REFERENCES cities
	);

	CREATE UNIQUE INDEX offices_id_uindex
		ON offices (id);

	CREATE UNIQUE INDEX offices_office_name_uindex
		ON offices (office_name);

	ALTER TABLE offices
		ADD CONSTRAINT offices_pk
			PRIMARY KEY (id);

	CREATE TABLE networks
	(
		id SERIAL NOT NULL,
		net cidr NOT NULL,
		office INTEGER NOT NULL
			CONSTRAINT networks_offices_id_fk
				REFERENCES offices (id)
	);

	CREATE UNIQUE INDEX networks_id_uindex
		ON networks (id);

	CREATE UNIQUE INDEX networks_net_uindex
		ON networks (net);

	ALTER TABLE networks
		ADD CONSTRAINT networks_pk
			PRIMARY KEY (id);

	CREATE TABLE servers
	(
		id SERIAL NOT NULL,
		fqdn TEXT NOT NULL,
		share_path TEXT NOT NULL,
		is_enabled BOOLEAN default false NOT NULL
	);

	CREATE UNIQUE INDEX servers_fqdn_uindex
		ON servers (fqdn);

	CREATE UNIQUE INDEX servers_id_uindex
		ON servers (id);

	ALTER TABLE servers
		ADD CONSTRAINT servers_pk
			PRIMARY KEY (id);

	CREATE TABLE offices_servers
	(
		id SERIAL NOT NULL,
		office INTEGER NOT NULL
			CONSTRAINT offices_servers_offices_id_fk
				REFERENCES deploy.offices,
		server INTEGER NOT NULL
			CONSTRAINT offices_servers_servers_id_fk
				REFERENCES deploy.servers,
		UNIQUE (office, server)
	);

	CREATE UNIQUE INDEX offices_servers_id_uindex
		ON offices_servers (id);

	ALTER TABLE offices_servers
		ADD CONSTRAINT offices_servers_pk
			PRIMARY KEY (id);

	CREATE TABLE supported_os
	(
		id SERIAL NOT NULL,
		os_name TEXT NOT NULL,
		UNIQUE (os_name)
	);

	CREATE UNIQUE INDEX supported_os_id_uindex
		ON supported_os (id);

	ALTER TABLE supported_os
		ADD CONSTRAINT supported_os_pk
			PRIMARY KEY (id);

	CREATE TABLE os_versions
	(
		id SERIAL NOT NULL,
		os INTEGER NOT NULL,
		os_edition TEXT NOT NULL,
		os_build TEXT NOT NULL,
        os_updated TEXT NOT NULL,
        os_version TEXT NOT NULL,
		os_arch arch NOT NULL,
		release_date DATE NOT NULL,
		is_default BOOLEAN NOT NULL,
		product_key TEXT NOT NULL,
		CONSTRAINT os_versions_supported_os_os_name_id_fk
			FOREIGN KEY (os) REFERENCES supported_os (id)
	);

	CREATE UNIQUE INDEX os_versions_id_uindex
		ON os_versions (id);

	ALTER TABLE os_versions
		ADD CONSTRAINT os_pk
			PRIMARY KEY (id);

	CREATE UNIQUE INDEX os_versions_is_default_uindex
		ON os_versions (os) where is_default;

	CREATE TABLE supported_products
	(
		id SERIAL NOT NULL,
		manufacturer TEXT NOT NULL,
		product_name TEXT NOT NULL,
		description TEXT,
		support_booting_from_legacy_bios BOOLEAN,
		UNIQUE (manufacturer, product_name)
	);

	CREATE UNIQUE INDEX supported_products_id_uindex
		ON supported_products (id);

	ALTER TABLE supported_products
		ADD CONSTRAINT supported_products_pk
			PRIMARY KEY (id);

	CREATE TABLE drivers_profiles
	(
		id SERIAL NOT NULL,
		profile_name TEXT NOT NULL,
		product_name INTEGER NOT NULL,
		os INTEGER NOT NULL,
		os_version INTEGER,
		CONSTRAINT drivers_profiles_supported_os_fk
			FOREIGN KEY (os) REFERENCES supported_os (id),
		CONSTRAINT drivers_profiles_os_versions_fk
			FOREIGN KEY (os_version) REFERENCES os_versions (id)
	);

	CREATE UNIQUE INDEX drivers_profiles_id_uindex
		ON drivers_profiles (id);

	CREATE UNIQUE INDEX drivers_profiles_profile_name_uindex
		ON drivers_profiles (profile_name, product_name, os, os_version);

	ALTER TABLE drivers_profiles
		ADD CONSTRAINT drivers_profiles_pk
			PRIMARY KEY (id);

  CREATE TABLE ou
	(
	  id SERIAL NOT NULL,
	  ou_path TEXT,
	  is_default BOOLEAN
	);

  CREATE UNIQUE INDEX ou_id_uindex
    ON ou (id);

  CREATE UNIQUE INDEX ou_ou_path_uindex
    ON ou (ou_path);

  CREATE UNIQUE INDEX ou_ou_is_default_uindex
    ON ou (is_default) WHERE is_default;

  ALTER TABLE ou
    ADD CONSTRAINT ou_pk
      PRIMARY KEY (id);

  CREATE TABLE os_ou_countries
    (
	    id SERIAL NOT NULL,
	    country_name INTEGER
		    CONSTRAINT os_ou_countries_countries_id_fk
			    REFERENCES countries,
	    os_name INTEGER
		    CONSTRAINT os_ou_countries_supported_os_id_fk
			    REFERENCES deploy.supported_os,
	    ou_path INTEGER
		    CONSTRAINT os_ou_countries_ou_id_fk
			    REFERENCES deploy.ou
  );

  CREATE UNIQUE INDEX os_ou_countries_id_uindex
	  ON deploy.os_ou_countries (id);

  ALTER TABLE deploy.os_ou_countries
	  ADD CONSTRAINT os_ou_countries_pk
		  PRIMARY KEY (id);

COMMIT;
