/* ROLLBACK; */

BEGIN;
DROP SCHEMA IF EXISTS ops CASCADE;
CREATE SCHEMA ops;
SET SCHEMA 'ops';

CREATE TYPE status_code AS ENUM ('closed', 'open');

CREATE TABLE deploy
(
    id UUID NOT NULL,
    creation_time TIMESTAMPTZ NOT NULL,
    mac_addresses MACADDR[],
    ip_address INET,
    serial_number TEXT,
    next_server TEXT,
    inventory_number VARCHAR(9),
    deploy_options JSONB,
    close_time TIMESTAMPTZ,
    status status_code NOT NULL,
    error_code INTEGER DEFAULT 0 NOT NULL,
    message TEXT
);

CREATE UNIQUE INDEX deploy_id_uindex
    ON deploy (id);

ALTER TABLE deploy
    ADD CONSTRAINT deploy_pk
        PRIMARY KEY (id);

CREATE INDEX deploy_options_gindex ON deploy USING GIN (deploy_options JSONB_PATH_OPS);

COMMIT;
