package main

import (
	"fmt"

	"a.yandex-team.ru/helpdesk/infra/baldr/internal/baldrerrors"
	"a.yandex-team.ru/helpdesk/infra/baldr/internal/models"
)

func (env *Env) locationData(dep *models.Deploy) error {
	numberOfResults, err := env.db.DefineLocation(dep)
	if err != nil {
		dep.ErrorCode = baldrerrors.CodeDBError
		dep.Message = fmt.Sprintf("Server internal error (code: %s)", dep.ErrorCode)
		return fmt.Errorf("LocationData: %w", err)
	}

	if numberOfResults == 0 {
		dep.ErrorCode = baldrerrors.CodeLocationNotDefined
		dep.Message = "Unknown location"
		return fmt.Errorf("LocationData: location is not defined for %s", dep.IPAddress)
	} else if numberOfResults > 1 {
		dep.ErrorCode = baldrerrors.CodeMoreThanOneLocationFound
		dep.Message = fmt.Sprintf("Server internal error (code: %d)", dep.ErrorCode)
		return fmt.Errorf("LocationData: more than one location found for %s", dep.IPAddress)
	}

	return nil
}

func (env *Env) findDeployServer(dep *models.Deploy) error {
	if err := env.db.SelectServer(dep); err != nil {
		dep.Options[models.OptionDistributionPoint] = models.NoDeployServer
		dep.Options[models.OptionDeploymentShare] = models.NoDeploymentShare
		dep.ErrorCode = baldrerrors.CodeDBError
		dep.Message = dep.ErrorCode.String()
		return fmt.Errorf("FindDeployServer: %w", err)
	}

	if dep.Options[models.OptionDistributionPoint] == models.NoDeployServer {
		dep.Message = "Deploy server not found"
		dep.ErrorCode = baldrerrors.CodeDeployServerNotFound
		return fmt.Errorf("FindDeployServer: %s", dep.ErrorCode)
	}

	return nil
}
