package main

import (
	"fmt"
	"io"
	"text/template"
)

const ipxeStartupTemplate = `#!ipxe

set api_host {{ if eq (index .Options "environment") "prod" -}}
{{ index .Options "prod-api-host" }}
{{ else -}}
{{ index .Options "test-api-host" }}
{{ end -}}
set handler_url https://${api_host}/v1/ipxe

:netboot
menu iPXE boot menu
  item --gap -- -------------------------------{{ if eq (index .Options "environment") "prod" -}}
- Production ---{{ else -}}
---- Testing ---{{ end }}-------------------------------
  item --gap -- ------------------------------ Standard workflow -----------------------------
  item auto-deploy   Automatic deploy system
  item --gap -- ----------------------------- Additional workflow ----------------------------
  item market-wh     Market Warehouse
  item market-std    Market Standard
  item win-11        Windows 11 Enterprise 21H2
  item win-pro       Windows 10 Professional
  item win21h1       Windows 10 Enterprise 21H1
  item win20h2       Windows 10 Enterprise 20H2
  item animals       Animals
  item animals-test  Animals (Test)
  item wipe          Wipe
  item linux         Linux Pre-deployment
  item --gap --	----------------------------- Change environment -----------------------------
  item change-env    Go to {{ if eq (index .Options "environment") "prod" }}Testing{{ else }}Production{{ end }}
  choose --default autodeploy --timeout 5000 target && goto ${target} || goto netboot

:auto-deploy
params
set idx:int32 0
  :loop isset ${net${idx}/mac} || goto loop_done
    isset ${macs} || set macs ${net${idx}/mac:hexhyp} && inc idx && goto loop
    set macs ${macs},${net${idx}/mac:hexhyp}
    inc idx && goto loop
  :loop_done
param mac ${macs}
param serialnumber ${serial}
param uuid ${uuid}
param platform ${platform}
param manufacturer ${manufacturer}
param product ${product}
param nextserver ${next-server}
param filename ${filename}
param hostname ${hostname}
param user_class ${user-class}
param asset ${asset}

chain --timeout 30000 ${handler_url}##params || goto auto-deploy

:market-wh
set handler_url https://${api_host}/v1/ipxe?template=market_warehouse
goto auto-deploy

:market-std
set handler_url https://${api_host}/v1/ipxe?template=market_standard
goto auto-deploy

:win-11
set handler_url https://${api_host}/v1/ipxe?template=windows_11_21h2
goto auto-deploy

:win-pro
set handler_url https://${api_host}/v1/ipxe?template=windows_pro
goto auto-deploy

:win21h1
set handler_url https://${api_host}/v1/ipxe?template=windows_21h1
goto auto-deploy

:win20h2
set handler_url https://${api_host}/v1/ipxe?template=windows_20h2
goto auto-deploy

:animals
set handler_url https://${api_host}/v1/ipxe?template=animals
goto auto-deploy

:animals-test
set handler_url https://${api_host}/v1/ipxe?template=animals_test
goto auto-deploy

:wipe
set handler_url https://${api_host}/v1/ipxe?template=wipe
goto auto-deploy

:linux
set handler_url https://${api_host}/v1/ipxe?template=linux_pre_deploy
goto auto-deploy

:change-env
set api_host {{ if eq (index .Options "environment") "prod" -}}
{{ index .Options "test-api-host" }}
{{ else -}}
{{ index .Options "prod-api-host" }}
{{ end -}}
chain https://${api_host}/v1/ipxe || goto change-env`

const ipxeTemplate = `#!ipxe

set server {{ index .Options "distribution-point" }}
set api_host {{ if eq (index .Options "environment") "prod" -}}
{{ index .Options "prod-api-host" }}
{{ else -}}
{{ index .Options "test-api-host" }}
{{ end -}}
set ulid {{ .ID }}

{{ if .Message -}}
:menu
menu iPXE boot menu
{{ if (index .Options "deployment-task-is-open") -}}
item --gap --         ----------------------------------- Warning ----------------------------------
{{ else -}}
item --gap --         ------------------------------------ Error -----------------------------------
{{ end -}}
{{ range split .Message 74 }}item --gap --         {{ . }}
{{ end -}}
item --gap --         ------------------------------------------------------------------------------
item --gap --         Inventory number: {{ .InventoryNumber }}
item --gap --         Serial number: {{ index .Options "hw-serialnumber" }}
{{ range $index, $mac := .MACAddresses -}}
item --gap --         MAC address {{ $index }}: {{ $mac }}
{{ end -}}
item --gap --         Manufacturer: {{ index .Options "hw-manufacturer" }}
item --gap --         Product: {{ index .Options "hw-model" }}
item --gap --         UEFI mode: {{ index .Options "uefi-mode" }}
item --gap --         IP: {{ .IPAddress }}
item --gap --         UUID: {{ index .Options "hw-uuid" }}
item --gap --         ID: {{ .ID }}
item --gap --         ------------------------------------------------------------------------------
item continue         {{ if (index .Options "deployment-task-is-open") }}Continue{{ else }}Try again{{ end }}
item --gap --         ------------------------------------------------------------------------------
item sh               iPXE shell
item reset            Reboot
item shutdown         Shutdown
choose target && goto ${target} || goto menu

:sh
shell

:reset
reboot

:shutdown
poweroff

:continue
{{ if not (index .Options "deployment-task-is-open") -}}
set handler_url https://${api_host}/v1/ipxe{{ if (index .Options "template") }}?template={{ index .Options "template" }}{{ end }}
params
set idx:int32 0
  :loop isset ${net${idx}/mac} || goto loop_done
    isset ${macs} || set macs ${net${idx}/mac:hexhyp} && inc idx && goto loop
    set macs ${macs},${net${idx}/mac:hexhyp}
    inc idx && goto loop
  :loop_done
param mac ${macs}
param serialnumber ${serial}
param uuid ${uuid}
param platform ${platform}
param manufacturer ${manufacturer}
param product ${product}
param nextserver ${next-server}
param filename ${filename}
param hostname ${hostname}
param user_class ${user-class}
param asset ${asset}
chain ${handler_url}##params || shell
{{ end -}}
{{ end -}}
{{ if not (and .Message (not (index .Options "deployment-task-is-open"))) -}}
{{ if or (eq (index .Options "template") "animals") (eq (index .Options "template") "animals_test") -}}
echo -n Enter homer number: && read number
{{ if eq (index .Options "template") "animals" -}}
set animals_api_path proxy.yandex-team.ru/api/homer_preseed/
{{ else -}}
set animals_api_path proxy.yandex-team.ru/api/homer_preseed_test/
{{ end -}}
kernel https://${server}/linux/installer/18.04/amd64/linux
imgargs linux biosdevname=0 initrd=initrd.gz auto=true url=https://${animals_api_path}?homer=${number} priority=critical \
interface=auto debian-installer/locale=en_US.UTF-8 console-setup/layoutcode=en localechooser/translation/warn-light=true \
localechooser/translation/warn-severe=true console-setup/toggle=Alt+Shift
initrd https://${server}/linux/installer/18.04/amd64/initrd.gz
boot || shell
{{ else if eq (index .Options "template") "wipe" -}}
kernel https://${server}/linux/wiper/vmlinuz
initrd https://${server}/linux/wiper/wiper
imgargs vmlinuz quiet initrd=wiper fb=false priority=critical
boot || shell
{{ else if HasPrefix (index .Options "os") "Windows" -}}
kernel https://${server}/boot/wimboot/2.7.3/wimboot
initrd https://${server}/boot/bcd                                   BCD
initrd https://${server}/boot/boot.sdi                              boot.sdi
initrd https://${api_host}/v1/wimboot/config.xml?id=${ulid}         config.xml
initrd https://${api_host}/v1/wimboot/bootstrap.ini?id=${ulid}      bootstrap.ini
initrd https://${server}/boot/deploy/winpeshl.ini                   winpeshl.ini
initrd https://${server}/boot/deploy/deploy-util/v1/deploy-util.exe deploy-util.exe
initrd https://${server}/boot/deploy/wallpaper/{{ index .Options "environment" }}/winpe.jpg       winpe.jpg
initrd https://${server}/boot/deploy/wim/10.0.22000.1-01/boot.wim   boot.wim

sync --timeout 15000
boot || shell
{{ else -}}
set base-url-focal https://${server}/linux/installer/20.04/amd64
set base-url-bionic https://${server}/linux/installer/18.04/amd64
{{ if eq (index .Options "deploy-type") "Zombie" -}}
:menu-zombie
menu Zombie
item --gap --          ------------------------------- Select zombie --------------------------------
item zombie-focal      Ubuntu 20.04 (Focal)
item zombie-focal-gpu  Ubuntu Server 20.04 (Focal)
item --gap --          ------------------- Legacy versions ONLY for old hardware --------------------
item zombie-bionic     Ubuntu 18.04 (Bionic)
item zombie-bionic-gpu Ubuntu Server 18.04 (Bionic)
choose --default zombie-focal --timeout 5000 target && goto ${target} || goto menu-zombie

:zombie-focal-gpu
kernel ${base-url-focal}/linux
initrd ${base-url-focal}/initrd.gz
imgargs linux auto=true initrd=initrd.gz fb=false priority=critical preseed/locale=en_US.UTF-8 kbd-chooser/method=gb \
preseed/url=https://${api_host}/v1/preseed/?id=${ulid}&type=zombie-gpu&os_release=focal netcfg/get_domain=unassigned-domain \
netcfg/choose_interface=auto
boot || shell

:zombie-bionic-gpu
kernel ${base-url-bionic}/linux
initrd ${base-url-bionic}/initrd.gz
imgargs linux auto=true initrd=initrd.gz fb=false priority=critical preseed/locale=en_US.UTF-8 kbd-chooser/method=gb \
preseed/url=https://${api_host}/v1/preseed/?id=${ulid}&type=zombie-gpu&os_release=bionic netcfg/get_domain=unassigned-domain \
netcfg/choose_interface=auto
boot || shell

:zombie-focal
kernel ${base-url-focal}/linux
initrd ${base-url-focal}/initrd.gz
imgargs linux auto=true initrd=initrd.gz fb=false priority=critical preseed/locale=en_US.UTF-8 kbd-chooser/method=gb \
preseed/url=https://${api_host}/v1/preseed/?id=${ulid}&type=zombie&os_release=focal netcfg/get_domain=unassigned-domain \
netcfg/choose_interface=auto
boot || shell

:zombie-bionic
kernel ${base-url-bionic}/linux
initrd ${base-url-bionic}/initrd.gz
imgargs linux auto=true initrd=initrd.gz fb=false priority=critical preseed/locale=en_US.UTF-8 kbd-chooser/method=gb \
preseed/url=https://${api_host}/v1/preseed/?id=${ulid}&type=zombie&os_release=bionic netcfg/get_domain=unassigned-domain \
netcfg/choose_interface=auto
boot || shell
{{ else -}}
{{ if eq (index .Options "os-release-name") "focal" -}}
goto user-focal
{{ else if eq (index .Options "os-release-name") "bionic" -}}
goto user-bionic
{{ end -}}
:menu-linux-user
menu Linux
item --gap --       ------------------------------- Select version -------------------------------
item user-focal     Ubuntu 20.04 (Focal)
item --gap --       ------------------- Legacy versions ONLY for old hardware --------------------
item user-bionic    Ubuntu 18.04 (Bionic)
choose --default user-focal --timeout 5000 target && goto ${target} || goto menu-linux-user

:user-bionic
kernel ${base-url-bionic}/linux
initrd ${base-url-bionic}/initrd.gz
imgargs linux auto=true initrd=initrd.gz fb=false priority=critical preseed/locale=en_US.UTF-8 kbd-chooser/method=gb \
preseed/url=https://${api_host}/v1/preseed/?id=${ulid}&type=user&os_release=bionic netcfg/get_domain=unassigned-domain \
netcfg/choose_interface=auto
boot || shell

:user-focal
kernel ${base-url-focal}/linux
initrd ${base-url-focal}/initrd.gz
imgargs linux auto=true initrd=initrd.gz fb=false priority=critical preseed/locale=en_US.UTF-8 kbd-chooser/method=gb \
preseed/url=https://${api_host}/v1/preseed/?id=${ulid}&type=user&os_release=focal netcfg/get_domain=unassigned-domain \
netcfg/choose_interface=auto
boot || shell
{{ end -}}
{{ end -}}
{{ end -}}`

const bootstrapIniTemplate = `[Settings]
Priority=Default

[Default]
DeployRoot=\\{{ .Hostname }}\{{ .SharePath }}
UserID={{ .Username }}
UserDomain={{ .Domain }}
UserPassword={{ .Password }}
KeyboardLocale=en-US
SkipBDDWelcome=YES`

const userPreseedTemplate = `#### Contents of the preconfiguration file (for {{ index .Options "os-release-name" }})

# Locales
d-i debian-installer/language string en
d-i debian-installer/country string RU
d-i debian-installer/locale string en_US
d-i debian-installer/locale select en_US.UTF-8
d-i debian-installer/keymap string us
d-i debconf/language string en
d-i localechooser/languagelist select en

# Keyboard
d-i localechooser/shortlist/en select
d-i localechooser/shortlist select EN
d-i console-setup/ask_detect boolean false
d-i console-setup/layoutcode string en
d-i console-setup/variant select USA
d-i console-setup/toggle select Alt+Shift
d-i localechooser/preferred-locale select en_US.UTF-8
d-i console-keymaps-at/keymap select en
d-i keyboard-configuration/xkb-keymap select en

# Network
d-i netcfg/choose_interface select auto
d-i netcfg/get_hostname string unassigned-hostname
d-i netcfg/hostname string {{ index .Options "computername" }}

### Mirror and apt settings
d-i mirror/country string manual
d-i mirror/http/hostname string mirror.yandex.ru
d-i mirror/http/directory string /ubuntu
d-i mirror/suite string {{ index .Options "os-release-name" }}
d-i apt-setup/restricted boolean true
d-i apt-setup/universe boolean true
d-i apt-setup/multiverse boolean true
d-i apt-setup/backports boolean true
d-i apt-setup/services-select multiselect security
d-i apt-setup/security_host string mirror.yandex.ru
d-i apt-setup/security_path string /ubuntu

#kernel select and options
d-i base-installer/kernel/image string linux-generic-hwe-{{ index .Options "os-version" }}
d-i debian-installer/add-kernel-opts string mem_sleep_default=deep

### Clock and time zone setup
d-i clock-setup/utc boolean true
d-i time/zone string Europe/Moscow
d-i clock-setup/ntp-server string ntp.yandex.net

### Account setup
d-i passwd/make-user boolean true
d-i passwd/user-fullname string {{ index .Options "username" }}
d-i passwd/username string {{ index .Options "username" }}
d-i passwd/user-password-crypted password $1$fENO7/iN$keuIeFNVdf7qIkzRNOd8/1
d-i passwd/auto-login boolean false
d-i user-setup/allow-password-weak boolean true
d-i user-setup/encrypt-home boolean false

{{ if eq (index .Options "os-release-name") "focal" -}}
d-i preseed/early_command string \
wget -q https://{{ index .Options "distribution-point" }}/linux/files/packages/partman-crypto_101ubuntu4+luksopts1_amd64.udeb ; \
udpkg -i partman-crypto_101ubuntu4\+luksopts1_amd64.udeb
{{ end -}}
### Partitioning
d-i partman/choose_partition select finish
d-i partman/confirm boolean true
d-i partman/confirm_nooverwrite boolean true{{ if eq (index .Options "os-release-name") "focal" }}
d-i partman-auto/method string crypto{{ else }}
d-i partman-auto/method string lvm{{ end }}
d-i partman-lvm/device_remove_lvm boolean true
d-i partman-lvm/confirm boolean true
d-i partman-lvm/confirm_nooverwrite boolean true
d-i partman-auto-lvm/no_boot boolean true
d-i partman-md/device_remove_md boolean true
d-i partman-partitioning/confirm_write_new_label boolean true

{{ if eq (index .Options "os-release-name") "focal" -}}
d-i partman-crypto/passphrase password fJq6dAtU3maaT-X
d-i partman-crypto/passphrase-again password fJq6dAtU3maaT-X
d-i partman-crypto/luksformat_options string --type luks1
{{ end -}}
{{ if eq ( index .Options "uefi-mode" ) "efi" -}}
### Force uefi installation(sic!)
d-i partman-efi/non_efi_system boolean true

### enforce usage of GPT
d-i partman-basicfilesystems/choose_label string gpt
d-i partman-basicfilesystems/default_label string gpt
d-i partman-partitioning/choose_label string gpt
d-i partman-partitioning/default_label string gpt
d-i partman/choose_label string gpt
d-i partman/default_label string gpt

d-i partman-auto/expert_recipe string                           \
        user-efi-parts ::                                       \
                550 550 550 free                                \
                        $iflabel{ gpt }                         \
                        $reusemethod{ }                         \
                        method{ efi }                           \
                        format{ }                               \
                        options/discard{ discard }              \
                .                                               \{{ if eq (index .Options "os-release-name") "focal" }}
                4096 4096 4096 ext4                             \
                        $primary{ }                             \
                        $bootable{ }                            \
                        method{ format } format{ }              \
                        use_filesystem{ } filesystem{ ext4 }    \
                        mountpoint{ /boot }                     \
                        options/discard{ discard }              \
                .                                               \{{ end }}
                51200 51300 -1 ext4                             \
                        lv_name{ root }                         \
                        method{ lvm } format{ }                 \
                        use_filesystem{ } filesystem{ ext4 }    \
                        mountpoint{ / }                         \
                        $lvmok{ }                               \
                        options/discard{ discard }              \
                .                                               \
                16384 16384 16384 linux-swap                    \
                        lv_name{ swap }                         \
                        method{ swap } format{ }                \
                        $lvmok{ }                               \
                        options/discard{ discard }              \
                .
d-i     partman-auto/choose_recipe select user-efi-parts
{{ else -}}
d-i partman-auto/expert_recipe string                           \
        user-legacy-parts ::                                    \{{ if eq (index .Options "os-release-name") "focal" }}
                4096 4096 4096 ext4                             \
                        $primary{ }                             \
                        $bootable{ }                            \
                        method{ format } format{ }              \
                        use_filesystem{ } filesystem{ ext4 }    \
                        mountpoint{ /boot }                     \
                        options/discard{ discard }              \
                .                                               \{{ end }}
                51200 51300 -1 ext4                             \
                        lv_name{ root }                         \
                        method{ lvm } format{ }                 \
                        use_filesystem{ } filesystem{ ext4 }    \
                        mountpoint{ / }                         \
                        $lvmok{ }                               \
                        options/discard{ discard }              \
                .                                               \
                16384 16384 16384 linux-swap                    \
                        lv_name{ swap }                         \
                        method{ swap } format{ }                \
                        $lvmok{ }                               \
                        options/discard{ discard }              \
                .
d-i     partman-auto/choose_recipe select user-legacy-parts
{{ end -}}

d-i     partman-partitioning/confirm_write_new_label boolean true
d-i     partman/choose_partition select finish
d-i     partman/confirm boolean true
d-i     partman/confirm_nooverwrite boolean true

### Base system installation
tasksel tasksel/first multiselect standard system utilities, ubuntu-desktop
{{ if eq (index .Options "os-release-name") "bionic" }}
d-i pkgsel/include string acpi traceroute python-pip network-manager-openvpn network-manager-openvpn-gnome wget libnss3-tools gnome-calculator gnome-characters gnome-logs gnome-system-monitor intel-microcode ubuntu-restricted-addons libavcodec-extra unrar
{{ else if eq (index .Options "os-release-name") "focal" }}
d-i pkgsel/include string acpi traceroute python3-pip network-manager-openvpn network-manager-openvpn-gnome wget libnss3-tools gnome-calculator gnome-characters gnome-logs gnome-system-monitor intel-microcode ubuntu-software ubuntu-restricted-addons libavcodec-extra unrar
{{ end -}}
### Boot loader installation
d-i grub-installer/only_debian boolean true
d-i grub-installer/with_other_os boolean true

## Post install customization
d-i preseed/late_command string \
# fix hostname(this fixes dns issues)
sed -i "/127.0.1.1/c\127.0.1.1  {{ index .Options "computername" }}" /target/etc/hosts ; \
{{ if eq (index .Options "os-release-name") "bionic" -}}
# Install HWE graphical stack
in-target apt-get install --install-recommends -y xserver-xorg-hwe-{{ index .Options "os-version" }} ; \
{{ end -}}
# Install proprietary video drivers, if needed.
{{ if eq (index .Options "os-release-name") "focal" -}}
in-target ubuntu-drivers autoinstall --no-oem ; \
{{ else -}}
in-target ubuntu-drivers autoinstall ; \
{{ end -}}
# Requirements for password quality
in-target mkdir -p /etc/security/pwquality.conf.d/ ; \
echo "minlen = 10" > /target/etc/security/pwquality.conf.d/10minlen.conf ; \
echo "ucredit = -1" > /target/etc/security/pwquality.conf.d/10credit.conf ; \
echo "dcredit = -1" >> /target/etc/security/pwquality.conf.d/10credit.conf ; \
echo "ocredit = -1" >> /target/etc/security/pwquality.conf.d/10credit.conf ; \
# Add Yandex Browser repo and install it
in-target add-apt-repository -n 'deb [arch=amd64] http://repo.yandex.ru/yandex-browser/deb beta main' ; \
in-target apt-key adv --fetch-keys http://repo.yandex.ru/yandex-browser/YANDEX-BROWSER-KEY.GPG ; \
# Add salt repo
{{ if eq (index .Options "os-release-name") "bionic" -}}
in-target add-apt-repository -n 'deb [arch=amd64] http://mirror.yandex.ru/mirrors/repo.saltstack.com/apt/ubuntu/18.04/amd64/2019.2 bionic main' ; \
in-target apt-key adv --fetch-keys http://mirror.yandex.ru/mirrors/repo.saltstack.com/apt/ubuntu/18.04/amd64/2019.2/SALTSTACK-GPG-KEY.pub  ; \
{{ else -}}
in-target add-apt-repository -n 'deb [arch=amd64] http://mirror.yandex.ru/mirrors/repo.saltstack.com/py3/ubuntu/20.04/amd64/3001 focal main' ; \
in-target apt-key adv --fetch-keys http://mirror.yandex.ru/mirrors/repo.saltstack.com/py3/ubuntu/20.04/amd64/latest/SALTSTACK-GPG-KEY.pub  ; \
{{ end -}}
# Add common.dist.yandex.ru/common (all/amd64)
in-target add-apt-repository -n 'deb http://common.dist.yandex.ru/common stable/all/' ; \
in-target add-apt-repository -n 'deb http://common.dist.yandex.ru/common stable/amd64/' ; \
in-target apt-key adv --keyserver keyserver.ubuntu.com --recv-key 7FCD11186050CD1A ; \
wget -q https://{{ index .Options "distribution-point" }}/linux/files/etc/{{ index .Options "os-release-name" }}_apt_preferences -O /target/etc/apt/preferences ; \
in-target apt update ; \
in-target apt install -y yandex-browser-beta salt-minion osquery-yandex-fleet-workstations-config yandex-archive-keyring ; \
sed -i "/yandex-browser/d" /target/etc/apt/sources.list ; \
# Add Skotty
in-target apt install -y libccid pcscd ; \
in-target systemctl enable pcscd.socket ; \
in-target systemctl restart pcscd.socket ; \
in-target apt install -y yandex-skotty ; \
#enable osqueryd service
in-target /lib/systemd/systemd-sysv-install enable osqueryd ; \
in-target ln -s /lib/systemd/system/osqueryd.service /etc/systemd/system/multi-user.target.wants/osqueryd.service ; \
{{ if eq (index .Options "os-release-name") "focal" -}}
# Install and configure pam-cryptsetup(sync user password and luks passphrase)
wget -q https://{{ index .Options "distribution-point" }}/linux/files/packages/libpam-cryptsetup_0.1_amd64.deb https://{{ index .Options "distribution-point" }}/linux/files/packages/pam-cryptsetup-tools_0.1_amd64.deb -P /target/tmp/ ; \
in-target apt install -y /tmp/libpam-cryptsetup_0.1_amd64.deb /tmp/pam-cryptsetup-tools_0.1_amd64.deb ; \
echo "password [default=ignore] pam_cryptsetup.so crypt_name=$(dmsetup ls --target crypt | cut -f1)" >> /target/etc/pam.d/common-password ; \
# Install custom luks unlock password script for inital setup
sed -i '${s/$/,tries=7,keyscript=\/lib\/cryptsetup\/scripts\/unlock/}' /target/etc/crypttab ; \
wget -q https://{{ index .Options "distribution-point" }}/linux/files/scripts/unlock -O /target/lib/cryptsetup/scripts/unlock ; \
chmod +x /target/lib/cryptsetup/scripts/unlock ; \
wget -q https://{{ index .Options "distribution-point" }}/linux/files/hdluks/hdluksescrow -O /target/tmp/hdluksescrow ; \
chmod +x /target/tmp/hdluksescrow ; \
/target/tmp/hdluksescrow --id {{ .ID }} -i "{{ index .Options "inventory-number" }}" -S "{{ index .Options "hw-serialnumber" }}" -s https://{{ if eq (index .Options "environment") "prod" -}}
{{ index .Options "prod-api-host" -}}
{{ else -}}
{{ index .Options "test-api-host" -}}
{{ end }}/v1/key_escrow -d /dev/$(dmsetup ls --target crypt | cut -d '_' -f1) -k "fJq6dAtU3maaT-X" ; \
in-target update-initramfs -u -k all ; \
{{ end -}}
# Fix nvidia s3 issues on xps
wget -q https://{{ index .Options "distribution-point" }}/linux/files/etc/nvidia-no-msi.conf -O /target/etc/modprobe.d/nvidia-no-msi.conf ; \
# Use intel graphics on Dell XPS
if grep -q 'XPS 15 9570' /sys/devices/virtual/dmi/id/product_name ; then in-target prime-select
{{- if eq (index .Options "os-release-name") "bionic" }} intel
{{- else if eq (index .Options "os-release-name") "focal" }} on-demand
{{- end }} ; fi ; \
# Setup NTP
mkdir -p /target/etc/systemd/timesyncd.conf.d/ ; \
wget -q https://{{ index .Options "distribution-point" }}/linux/files/etc/ntp.conf -O /target/etc/systemd/timesyncd.conf.d/local.conf ; \
# Configure salt-minion
wget -q https://{{ index .Options "distribution-point" }}/linux/files/etc/minion-user -O /target/etc/salt/minion ; \
mkdir -p /target/etc/salt/pki/minion/ ; \
wget -q https://{{ index .Options "distribution-point" }}/linux/files/etc/salt.baldr.yandex.net.master_sign.pub -O /target/etc/salt/pki/minion/master_sign.pub ; \
# Autorestart salt-minion
mkdir -p /target/etc/systemd/system/salt-minion.service.d/ ; \
wget -q https://{{ index .Options "distribution-point" }}/linux/files/etc/salt-override.conf -O /target/etc/systemd/system/salt-minion.service.d/override.conf ; \
# Setup YandexInternalCA for Firefox and YaBro
mkdir -p /target/usr/local/share/ca-certificates/yandex/ ; \
wget -q https://{{ index .Options "distribution-point" }}/linux/files/YandexInternalCA.crt -O /target/usr/local/share/ca-certificates/yandex/YandexInternalCA.crt ; \
in-target update-ca-certificates ; \
wget -q https://{{ index .Options "distribution-point" }}/linux/files/etc/firefox-policies.json -O /target/usr/lib/firefox/distribution/policies.json ; \
{{ if eq (index .Options "template") "linux_pre_deploy" -}}
in-target mkdir -p --mode 700 /etc/skel/.pki/nssdb/ ; \
in-target modutil -dbdir sql:/etc/skel/.pki/nssdb/ -add "P11KIT-trust" -libfile /usr/lib/x86_64-linux-gnu/pkcs11/p11-kit-trust.so -force ; \
{{ else -}}
in-target mkdir -p --mode 700 /home/{{ index .Options "username" }}/.pki/nssdb/ ; \
in-target modutil -dbdir sql:/home/{{ index .Options "username" }}/.pki/nssdb/ -add "P11KIT-trust" -libfile /usr/lib/x86_64-linux-gnu/pkcs11/p11-kit-trust.so -force ; \
in-target chown {{ index .Options "username" }}:{{ index .Options "username" }} -R /home/{{ index .Options "username" }}/.pki/ ; \
{{ end -}}
# Install dconf profiles
wget -q https://{{ index .Options "distribution-point" }}/linux/files/dconf-{{ index .Options "os-release-name" }}/user -O /target/etc/dconf/profile/user ; \
mkdir -p /target/etc/dconf/db/local.d/ ; \
wget -q -r -np -nH --cut-dirs=4 -R "index.html*" https://{{ index .Options "distribution-point" }}/linux/files/dconf-{{ index .Options "os-release-name" }}/all/. -P /target/etc/dconf/db/local.d/ ; \
wget -q -r -np -nH --cut-dirs=4 -R "index.html*" https://{{ index .Options "distribution-point" }}/linux/files/dconf-{{ index .Options "os-release-name" }}/users/. -P /target/etc/dconf/db/local.d/ ; \
in-target dconf update ; \
# Disable netplan
rm /target/etc/netplan/01-netcfg.yaml ; \
# Copy password change instructions
{{ if eq (index .Options "template") "linux_pre_deploy" -}}
mkdir /target/etc/skel/Desktop ; \
wget -q -O /target/etc/skel/Desktop/Changing\ Password\ Manual.pdf https://s3.mds.yandex.net/helpdesk/New%20user%20manual.pdf ; \
{{ else -}}
mkdir /target/home/{{ index .Options "username" }}/Desktop ; \
wget -q -O /target/home/{{ index .Options "username" }}/Desktop/Changing\ Password\ Manual.pdf https://s3.mds.yandex.net/helpdesk/New%20user%20manual.pdf ; \
in-target chown {{ index .Options "username" }}:{{ index .Options "username" }} -R /home/{{ index .Options "username" }}/Desktop ; \
{{ end -}}
# Install firmware update service and scripts(uses lvfs)
{{ if eq ( index .Options "uefi-mode") "efi" -}}
wget -q https://{{ index .Options "distribution-point" }}/linux/files/fwupdater/fwupdater-{{ index .Options "os-release-name" }}.sh -O /target/opt/yandex/fwupdater.sh ; \
chmod +x /target/opt/yandex/fwupdater.sh ; \
wget -q https://{{ index .Options "distribution-point" }}/linux/files/fwupdater/fwupdater.service -O /target/etc/systemd/system/fwupdater.service ; \
in-target ln -s /etc/systemd/system/fwupdater.service /etc/systemd/system/multi-user.target.wants/fwupdater.service ; \
{{ end -}}
# Install get_cert
wget -q https://{{ index .Options "distribution-point" }}/linux/files/get-cert/python3-get-cert_0.3.2-1_all.deb -O /target/tmp/get-cert.deb ; \
in-target apt install -y /tmp/get-cert.deb ; \
{{ if eq (index .Options "template") "linux_pre_deploy" -}}
# install post-install script
wget -q https://{{ index .Options "distribution-point" }}/linux/files/ya-postinstall-user -O /target/usr/local/bin/ya-postinstall ; \
chmod +x /target/usr/local/bin/ya-postinstall ; \
{{ end -}}
# Fix grub timeout
echo "GRUB_RECORDFAIL_TIMEOUT=0" >> /target/etc/default/grub ; \
{{ if eq (index .Options "os-release-name") "focal" -}}
sed -i '/GRUB_CMDLINE_LINUX_DEFAULT/c\GRUB_CMDLINE_LINUX_DEFAULT="quiet splash"' /target/etc/default/grub ; \
{{ end -}}
in-target update-grub ; \
wget -q --post-data='id={{ .ID }}' https://
{{- if eq (index .Options "environment") "prod" -}}
{{ index .Options "prod-api-host" -}}
{{ else -}}
{{ index .Options "test-api-host" -}}
{{ end -}}
/v1/task/close ; \
exit 0
### Finishing up the installation
d-i finish-install/reboot_in_progress note
`

const zombiePreseedTemplate = `#### Contents of the preconfiguration file (for {{ index .Options "os-release-name" }})

# Locales
d-i debian-installer/language string en
d-i debian-installer/country string RU
d-i debian-installer/locale string en_US
d-i debian-installer/locale select en_US.UTF-8
d-i debian-installer/keymap string us
d-i debconf/language string en
d-i localechooser/languagelist select en

# Keyboard
d-i localechooser/shortlist/en select
d-i localechooser/shortlist select EN
d-i console-setup/ask_detect boolean false
d-i console-setup/layoutcode string en
d-i console-setup/variant select USA
d-i console-setup/toggle select Alt+Shift
d-i localechooser/preferred-locale select en_US.UTF-8
d-i console-keymaps-at/keymap select en
d-i keyboard-configuration/xkb-keymap select en

# Network
d-i netcfg/choose_interface select auto
d-i netcfg/get_hostname string unassigned-hostname
d-i netcfg/hostname string {{ if ( index .Options "fqdn" ) }}{{ index .Options "fqdn" }}{{ else }}{{ index .Options "computername" }}{{ end }}

### Mirror and apt settings
d-i mirror/country string manual
d-i mirror/http/hostname string mirror.yandex.ru
d-i mirror/http/directory string /ubuntu
d-i mirror/suite string {{ index .Options "os-release-name" }}
d-i apt-setup/restricted boolean true
d-i apt-setup/universe boolean true
d-i apt-setup/multiverse boolean true
d-i apt-setup/backports boolean true
d-i apt-setup/services-select multiselect security
d-i apt-setup/security_host string mirror.yandex.ru
d-i apt-setup/security_path string /ubuntu

#kernel select
d-i base-installer/kernel/image string linux-generic-hwe-{{ index .Options "os-version" }}

#enable unattended-upgrades
d-i pkgsel/update-policy select unattended-upgrades

### Clock and time zone setup
d-i clock-setup/utc boolean true
d-i time/zone string Europe/Moscow
d-i clock-setup/ntp-server string ntp.yandex.net

### Account setup
d-i passwd/make-user boolean true
d-i passwd/user-fullname string {{ index .Options "username" }}
d-i passwd/username string {{ index .Options "username" }}
d-i passwd/user-password-crypted password $1$1cjJured$Kgj03GwBZIyqDUfvvgL0Q.
d-i passwd/auto-login boolean true
d-i user-setup/allow-password-weak boolean true
d-i user-setup/encrypt-home boolean false

### Partitioning
d-i partman/choose_partition select finish
d-i partman/confirm boolean true
d-i partman/confirm_nooverwrite boolean true
d-i partman-auto/method string lvm
d-i partman-lvm/device_remove_lvm boolean true
d-i partman-lvm/confirm boolean true
d-i partman-lvm/confirm_nooverwrite boolean true
d-i partman-auto-lvm/no_boot boolean true
d-i partman-md/device_remove_md boolean true
d-i partman-partitioning/confirm_write_new_label boolean true

{{ if eq ( index .Options "uefi-mode" ) "efi" -}}
### Force uefi installation(sic!)
d-i partman-efi/non_efi_system boolean true

### enforce usage of GPT
d-i partman-basicfilesystems/choose_label string gpt
d-i partman-basicfilesystems/default_label string gpt
d-i partman-partitioning/choose_label string gpt
d-i partman-partitioning/default_label string gpt
d-i partman/choose_label string gpt
d-i partman/default_label string gpt

d-i partman-auto/expert_recipe string                           \
        zombie-efi-parts ::                                     \
                550 550 550 free                                \
                        $iflabel{ gpt }                         \
                        $reusemethod{ }                         \
                        method{ efi }                           \
                        format{ }                               \
                        options/discard{ discard }              \
                .                                               \
                51200 51300 -1 ext4                             \
                        lv_name{ root }                         \
                        method{ lvm } format{ }                 \
                        use_filesystem{ } filesystem{ ext4 }    \
                        mountpoint{ / }                         \
                        $lvmok{ }                               \
                        options/discard{ discard }              \
                .                                               \
                4096 4096 4096 linux-swap                       \
                        lv_name{ swap }                         \
                        method{ swap } format{ }                \
                        $lvmok{ }                               \
                        options/discard{ discard }              \
                .
d-i     partman-auto/choose_recipe select zombie-efi-parts
{{ else -}}
d-i partman-auto/expert_recipe string                           \
        zombie-legacy-parts ::                                  \
                51200 51300 -1 ext4                             \
                        lv_name{ root }                         \
                        method{ lvm } format{ }                 \
                        use_filesystem{ } filesystem{ ext4 }    \
                        mountpoint{ / }                         \
                        $lvmok{ }                               \
                        options/discard{ discard }              \
                .                                               \
                4096 4096 4096 linux-swap                       \
                        lv_name{ swap }                         \
                        method{ swap } format{ }                \
                        $lvmok{ }                               \
                        options/discard{ discard }              \
                .
d-i     partman-auto/choose_recipe select zombie-legacy-parts
{{ end -}}
d-i     partman-partitioning/confirm_write_new_label boolean true
d-i     partman/choose_partition select finish
d-i     partman/confirm boolean true
d-i     partman/confirm_nooverwrite boolean true

### Base system installation
{{ if eq (index .Options "os-release-name") "bionic" -}}
tasksel tasksel/first multiselect standard system utilities, ubuntu-desktop

d-i pkgsel/include string chromium-browser acpi traceroute python-pip network-manager-openvpn network-manager-openvpn-gnome wget openssh-server libnss3-tools intel-microcode libavcodec-extra ubuntu-restricted-extras chromium-codecs-ffmpeg-extra
{{ else if eq (index .Options "os-release-name") "focal" -}}
tasksel tasksel/first multiselect standard system utilities, ubuntu-desktop-minimal

d-i pkgsel/include string acpi traceroute network-manager-openvpn network-manager-openvpn-gnome wget openssh-server libnss3-tools intel-microcode ubuntu-software vino libavcodec-extra ubuntu-restricted-extras chromium-codecs-ffmpeg-extra
{{ end }}
### Boot loader installation
d-i grub-installer/only_debian boolean true
d-i grub-installer/with_other_os boolean true

## Post install customization
d-i preseed/late_command string \
# fix hostname(this fixes dns issues)
sed -i "/127.0.1.1/c\127.0.1.1  {{ if ( index .Options "fqdn" ) }}{{ index .Options "fqdn" }}{{ else }}{{ index .Options "computername" }}{{ end }}" /target/etc/hosts ; \
{{ if eq (index .Options "os-release-name") "bionic" -}}
# Install HWE graphical stack
in-target apt-get install --install-recommends -y xserver-xorg-hwe-{{ index .Options "os-version" }} ; \
{{ end -}}
# Add 3-rd party repos
in-target add-apt-repository -n 'deb [arch=amd64] http://repo.yandex.ru/yandex-browser/deb beta main' ; \
in-target apt-key adv --fetch-keys http://repo.yandex.ru/yandex-browser/YANDEX-BROWSER-KEY.GPG ; \
{{ if eq (index .Options "os-release-name") "bionic" -}}
in-target add-apt-repository -n 'deb [arch=amd64] http://mirror.yandex.ru/mirrors/repo.saltstack.com/apt/ubuntu/18.04/amd64/2019.2 bionic main' ; \
in-target apt-key adv --fetch-keys http://mirror.yandex.ru/mirrors/repo.saltstack.com/apt/ubuntu/18.04/amd64/2019.2/SALTSTACK-GPG-KEY.pub  ; \
{{ else -}}
in-target add-apt-repository -n 'deb [arch=amd64] http://mirror.yandex.ru/mirrors/repo.saltstack.com/py3/ubuntu/20.04/amd64/3001 focal main' ; \
in-target apt-key adv --fetch-keys http://mirror.yandex.ru/mirrors/repo.saltstack.com/py3/ubuntu/20.04/amd64/latest/SALTSTACK-GPG-KEY.pub  ; \
{{ end -}}
in-target apt update ; \
# Install additional software(YaBro and salt-minion)
in-target apt install -y yandex-browser-beta salt-minion {{ if eq (index .Options "os-release-name") "bionic" }}python-m2crypto python-croniter {{ else }}python3-m2crypto python3-croniter {{ end }}; \
sed -i "/yandex-browser/d" /target/etc/apt/sources.list ; \
# Remove ubuntu welcome screen
in-target apt remove -y gnome-initial-setup ; \
# Setup NTP
mkdir -p /target/etc/systemd/timesyncd.conf.d/ ; \
wget -q https://{{ index .Options "distribution-point" }}/linux/files/etc/ntp.conf -O /target/etc/systemd/timesyncd.conf.d/local.conf ; \
# Enable unattended-upgrades
wget -q https://{{ index .Options "distribution-point" }}/linux/files/etc/60unattended-upgrades -O /target/etc/apt/apt.conf.d/60unattended-upgrades ; \
# Configure salt-minion
wget -q https://{{ index .Options "distribution-point" }}/linux/files/etc/minion -O /target/etc/salt/minion ; \
# Autorestart salt-minion
mkdir -p /target/etc/systemd/system/salt-minion.service.d/ ; \
wget -q https://{{ index .Options "distribution-point" }}/linux/files/etc/salt-override.conf -O /target/etc/systemd/system/salt-minion.service.d/override.conf ; \
# eGalax touch fix
wget -q https://{{ index .Options "distribution-point" }}/linux/files/etc/91-libinput-egalax.rules -O /target/etc/udev/rules.d/91-libinput-egalax.rules ; \
# Setup YandexInternalCA for Firefox and YaBro
mkdir -p /target/usr/local/share/ca-certificates/yandex/ ; \
wget -q https://{{ index .Options "distribution-point" }}/linux/files/YandexInternalCA.crt -O /target/usr/local/share/ca-certificates/yandex/YandexInternalCA.crt ; \
in-target update-ca-certificates ; \
wget -q https://{{ index .Options "distribution-point" }}/linux/files/etc/firefox-policies-zmb.json -O /target/usr/lib/firefox/distribution/policies.json ; \
in-target mkdir -p --mode 700 /home/{{ index .Options "username" }}/.pki/nssdb/ ; \
in-target modutil -dbdir sql:/home/{{ index .Options "username" }}/.pki/nssdb/ -add "P11KIT-trust" -libfile /usr/lib/x86_64-linux-gnu/pkcs11/p11-kit-trust.so -force ; \
in-target chown {{ index .Options "username" }}:{{ index .Options "username" }} -R /home/{{ index .Options "username" }}/.pki/ ; \
# Install tab rotate addons into Firefox and YaBro
wget -q https://{{ index .Options "distribution-point" }}/linux/files/browser-extensions/tabrotator.xpi -O /target/usr/lib/firefox/distribution/extensions/tabrotator@davidfichtmueller.de.xpi ; \
wget -q https://{{ index .Options "distribution-point" }}/linux/files/browser-extensions/extension_0_4_1_0.crx -O /target//opt/yandex/browser-beta/Extensions/extension_0_4_1_0.crx ; \
wget -q https://{{ index .Options "distribution-point" }}/linux/files/browser-extensions/pjgjpabbgnnoohijnillgbckikfkbjed.json -O /target/opt/yandex/browser-beta/Extensions/pjgjpabbgnnoohijnillgbckikfkbjed.json ; \
# Install dconf profiles
wget -q https://{{ index .Options "distribution-point" }}/linux/files/dconf-{{ index .Options "os-release-name" }}/user -O /target/etc/dconf/profile/user ; \
mkdir -p /target/etc/dconf/db/local.d/ ; \
wget -q -r -np -nH --cut-dirs=4 -R "index.html*" https://{{ index .Options "distribution-point" }}/linux/files/dconf-{{ index .Options "os-release-name" }}/all/. -P /target/etc/dconf/db/local.d/ ; \
wget -q -r -np -nH --cut-dirs=4 -R "index.html*" https://{{ index .Options "distribution-point" }}/linux/files/dconf-{{ index .Options "os-release-name" }}/zombie/. -P /target/etc/dconf/db/local.d/ ; \
in-target dconf update ; \
# Disable network connectivity checks and netplan
touch /target/etc/NetworkManager/conf.d/20-connectivity-ubuntu.conf ; \
rm /target/etc/netplan/01-netcfg.yaml ; \
# Disable error reporing
echo 'enabled=0' > /target/etc/default/apport ; \
rm /target/etc/systemd/system/multi-user.target.wants/whoopsie.service ; \
# Fix autologin issue
printf "[daemon]\nTimedLoginEnable = true\nTimedLoginDelay = 0" >> /target/etc/gdm3/custom.conf ; \
# Enable VNC server for all conntions
in-target ln -s /usr/share/applications/vino-server.desktop /etc/xdg/autostart/vino-server.desktop ; \
{{ if eq (index .Options "os-release-name") "bionic" -}}
# intel flicker fix
mkdir -p /target/etc/X11/xorg.conf.d ; \
wget -q https://{{ index .Options "distribution-point" }}/linux/files/etc/20-intel_flicker_fix.conf -O /target/etc/X11/xorg.conf.d/20-intel_flicker_fix.conf ; \
{{ end -}}
# Install get_cert
wget -q https://{{ index .Options "distribution-point" }}/linux/files/get-cert/python3-get-cert_0.3.2-1_all.deb -O /target/tmp/get-cert.deb ; \
in-target apt install -y /tmp/get-cert.deb ; \
{{ if eq (index .Options "os-release-name") "focal" -}}
# Disable new release checks
sed -i '/Prompt/c\Prompt=never' /target/etc/update-manager/release-upgrades ; \
{{ end -}}
# Fix grub timeout
echo "GRUB_RECORDFAIL_TIMEOUT=0" >> /target/etc/default/grub ; \
{{ if eq (index .Options "os-release-name") "focal" -}}
sed -i '/GRUB_CMDLINE_LINUX_DEFAULT/c\GRUB_CMDLINE_LINUX_DEFAULT="quiet splash"' /target/etc/default/grub ; \
{{ end -}}
in-target update-grub ; \
wget -q --post-data='id={{ .ID }}' https://
{{- if eq (index .Options "environment") "prod" -}}
{{ index .Options "prod-api-host" -}}
{{ else -}}
{{ index .Options "test-api-host" -}}
{{ end -}}
/v1/task/close ; \
exit 0
### Finishing up the installation
d-i finish-install/reboot_in_progress note
`

const zombieGPUPreseedTemplate = `#### Contents of the preconfiguration file (for {{ index .Options "os-release-name" }})

# Locales
d-i debian-installer/language string en
d-i debian-installer/country string RU
d-i debian-installer/locale string en_US
d-i debian-installer/locale select en_US.UTF-8
d-i debian-installer/keymap string us
d-i debconf/language string en
d-i localechooser/languagelist select en

# Keyboard
d-i localechooser/shortlist/en select
d-i localechooser/shortlist select EN
d-i console-setup/ask_detect boolean false
d-i console-setup/layoutcode string en
d-i console-setup/variant select USA
d-i console-setup/toggle select Alt+Shift
d-i localechooser/preferred-locale select en_US.UTF-8
d-i console-keymaps-at/keymap select en
d-i keyboard-configuration/xkb-keymap select en

# Network
d-i netcfg/choose_interface select auto
d-i netcfg/get_hostname string unassigned-hostname
d-i netcfg/hostname string {{ if ( index .Options "fqdn" ) }}{{ index .Options "fqdn" }}{{ else }}{{ index .Options "computername" }}{{ end }}

### Mirror and apt settings
d-i mirror/country string manual
d-i mirror/http/hostname string mirror.yandex.ru
d-i mirror/http/directory string /ubuntu
d-i mirror/suite string {{ index .Options "os-release-name" }}
d-i apt-setup/restricted boolean true
d-i apt-setup/universe boolean true
d-i apt-setup/multiverse boolean true
d-i apt-setup/backports boolean true
d-i apt-setup/services-select multiselect security
d-i apt-setup/security_host string mirror.yandex.ru
d-i apt-setup/security_path string /ubuntu

#kernel select
d-i base-installer/kernel/image string linux-generic-hwe-{{ index .Options "os-version" }}

#enable unattended-upgrades
d-i pkgsel/update-policy select unattended-upgrades

### Clock and time zone setup
d-i clock-setup/utc boolean true
d-i time/zone string Europe/Moscow
d-i clock-setup/ntp-server string ntp.yandex.net

### Account setup
d-i passwd/make-user boolean true
d-i passwd/user-fullname string {{ index .Options "username" }}
d-i passwd/username string {{ index .Options "username" }}
d-i passwd/user-password-crypted password $1$1cjJured$Kgj03GwBZIyqDUfvvgL0Q.
d-i passwd/auto-login boolean true
d-i user-setup/allow-password-weak boolean true
d-i user-setup/encrypt-home boolean false


### Partitioning
d-i partman/choose_partition select finish
d-i partman/confirm boolean true
d-i partman/confirm_nooverwrite boolean true
d-i partman-auto/method string lvm
d-i partman-lvm/device_remove_lvm boolean true
d-i partman-lvm/confirm boolean true
d-i partman-lvm/confirm_nooverwrite boolean true
d-i partman-auto-lvm/no_boot boolean true
d-i partman-md/device_remove_md boolean true
d-i partman-partitioning/confirm_write_new_label boolean true

{{ if eq ( index .Options "uefi-mode" ) "efi" -}}
### Force uefi installation(sic!)
d-i partman-efi/non_efi_system boolean true

### enforce usage of GPT
d-i partman-basicfilesystems/choose_label string gpt
d-i partman-basicfilesystems/default_label string gpt
d-i partman-partitioning/choose_label string gpt
d-i partman-partitioning/default_label string gpt
d-i partman/choose_label string gpt
d-i partman/default_label string gpt

d-i partman-auto/expert_recipe string                           \
        gpu-efi-parts ::                                        \
                550 550 550 free                                \
                        $iflabel{ gpt }                         \
                        $reusemethod{ }                         \
                        method{ efi }                           \
                        format{ }                               \
                        options/discard{ discard }              \
                .                                               \
                51200 51300 -1 ext4                             \
                        lv_name{ root }                         \
                        method{ lvm } format{ }                 \
                        use_filesystem{ } filesystem{ ext4 }    \
                        mountpoint{ / }                         \
                        $lvmok{ }                               \
                        options/discard{ discard }              \
                .                                               \
                16384 16384 16384 linux-swap                    \
                        lv_name{ swap }                         \
                        method{ swap } format{ }                \
                        $lvmok{ }                               \
                        options/discard{ discard }              \
                .
d-i     partman-auto/choose_recipe select gpu-efi-parts
{{ else -}}
d-i partman-auto/expert_recipe string                           \
        gpu-legacy-parts ::                                     \
                51200 51300 -1 ext4                             \
                        lv_name{ root }                         \
                        method{ lvm } format{ }                 \
                        use_filesystem{ } filesystem{ ext4 }    \
                        mountpoint{ / }                         \
                        $lvmok{ }                               \
                        options/discard{ discard }              \
                .                                               \
                16384 16384 16384 linux-swap                    \
                        lv_name{ swap }                         \
                        method{ swap } format{ }                \
                        $lvmok{ }                               \
                        options/discard{ discard }              \
                .
d-i     partman-auto/choose_recipe select gpu-legacy-parts
{{ end -}}
d-i     partman-partitioning/confirm_write_new_label boolean true
d-i     partman/choose_partition select finish
d-i     partman/confirm boolean true
d-i     partman/confirm_nooverwrite boolean true

### Base system installation
tasksel tasksel/first multiselect standard system utilities, Basic Ubuntu server
{{ if eq (index .Options "os-release-name") "bionic" }}
d-i pkgsel/include string python-m2crypto acpi traceroute wget openssh-server network-manager ubuntu-drivers-common software-properties-common intel-microcode{{ else }}
d-i pkgsel/include string acpi traceroute wget openssh-server network-manager ubuntu-drivers-common software-properties-common intel-microcode{{ end }}

### Boot loader installation
d-i grub-installer/only_debian boolean true
d-i grub-installer/with_other_os boolean true

## Post install customization
d-i preseed/late_command string \
# fix hostname(this fixes dns issues)
sed -i "/127.0.1.1/c\127.0.1.1  {{ if ( index .Options "fqdn" ) }}{{ index .Options "fqdn" }}{{ else }}{{ index .Options "computername" }}{{ end }}" /target/etc/hosts ; \
# Add 3-rd party repos{{ if eq (index .Options "os-release-name") "bionic" }}
in-target add-apt-repository -n 'deb [ arch=amd64 ] http://mirror.yandex.ru/mirrors/repo.saltstack.com/apt/ubuntu/18.04/amd64/2019.2 bionic main' ; \
in-target apt-key adv --fetch-keys http://mirror.yandex.ru/mirrors/repo.saltstack.com/apt/ubuntu/18.04/amd64/2019.2/SALTSTACK-GPG-KEY.pub ; \{{ else }}
in-target add-apt-repository -n 'deb [arch=amd64] http://mirror.yandex.ru/mirrors/repo.saltstack.com/py3/ubuntu/20.04/amd64/3001 focal main' ; \
in-target apt-key adv --fetch-keys http://mirror.yandex.ru/mirrors/repo.saltstack.com/py3/ubuntu/20.04/amd64/latest/SALTSTACK-GPG-KEY.pub ; \{{ end }}
in-target add-apt-repository -n 'deb http://common.dist.yandex.ru/common stable/all/' ; \
in-target apt-key adv --keyserver keyserver.ubuntu.com --recv-key 7FCD11186050CD1A ; \{{ if eq (index .Options "os-release-name") "bionic" }}
in-target add-apt-repository -n 'deb http://developer.download.nvidia.com/compute/cuda/repos/ubuntu1804/x86_64 /' ; \
in-target apt-key adv --fetch-keys https://developer.download.nvidia.com/compute/cuda/repos/ubuntu1804/x86_64/7fa2af80.pub ; \{{ else }}
in-target add-apt-repository -n 'deb http://developer.download.nvidia.com/compute/cuda/repos/ubuntu2004/x86_64/ /' ; \
in-target apt-key adv --fetch-keys http://developer.download.nvidia.com/compute/cuda/repos/ubuntu2004/x86_64/7fa2af80.pub ; \{{ end }}
in-target apt update ; \
# Install additional software(cauth and salt-minion){{ if eq (index .Options "os-release-name") "bionic" }}
in-target apt install -y salt-minion yandex-cauth python-m2crypto python-croniter ; \{{ else }}
in-target apt install -y salt-minion yandex-cauth python3-m2crypto python3-croniter ; \{{ end }}
in-target add-apt-repository -r 'deb http://common.dist.yandex.ru/common stable/all/' ; \
# Install proprietary video drivers, if needed.{{ if eq (index .Options "os-release-name") "bionic" }}
in-target ubuntu-drivers autoinstall ; \{{ else }}
in-target ubuntu-drivers install --gpgpu ; \{{ end }}
# Setup NTP
mkdir -p /target/etc/systemd/timesyncd.conf.d/ ; \
wget -q https://{{ index .Options "distribution-point" }}/linux/files/etc/ntp.conf -O /target/etc/systemd/timesyncd.conf.d/local.conf ; \
# Enable unattended-upgrades
wget -q https://{{ index .Options "distribution-point" }}/linux/files/etc/60unattended-upgrades -O /target/etc/apt/apt.conf.d/60unattended-upgrades ; \
# Configure salt-minion
wget -q https://{{ index .Options "distribution-point" }}/linux/files/etc/minion -O /target/etc/salt/minion ; \
# Autorestart salt-minion
mkdir -p /target/etc/systemd/system/salt-minion.service.d/ ; \
wget -q https://{{ index .Options "distribution-point" }}/linux/files/etc/salt-override.conf -O /target/etc/systemd/system/salt-minion.service.d/override.conf ; \
# Disable netplan and use NetworkManager
wget -q https://{{ index .Options "distribution-point" }}/linux/files/etc/01-netcfg.yaml -O /target/etc/netplan/01-netcfg.yaml; \
# Install YandexInternalCA
mkdir -p /target/usr/local/share/ca-certificates/yandex/ ; \
wget -q https://{{ index .Options "distribution-point" }}/linux/files/YandexInternalCA.crt -O /target/usr/local/share/ca-certificates/yandex/YandexInternalCA.crt ; \
in-target update-ca-certificates ; \
# Install get_cert
wget -q https://{{ index .Options "distribution-point" }}/linux/files/get-cert/python3-get-cert_0.3.2-1_all.deb -O /target/tmp/get-cert.deb ; \
in-target apt install -y /tmp/get-cert.deb ; \
# Fix grub timeout
echo "GRUB_RECORDFAIL_TIMEOUT=0" >> /target/etc/default/grub ; \
in-target update-grub ; \
wget -q --post-data='id={{ .ID }}' https://
{{- if eq (index .Options "environment") "prod" -}}
{{ index .Options "prod-api-host" -}}
{{ else -}}
{{ index .Options "test-api-host" -}}
{{ end -}}
/v1/task/close ; \
exit 0
### Finishing up the installation
d-i finish-install/reboot_in_progress note
`

func executeTemplate(data interface{}, funcs template.FuncMap, w io.Writer, tmpl string) error {
	t, err := template.New(tmpl).Funcs(funcs).Parse(tmpl)
	if err != nil {
		return fmt.Errorf("executeTemplate(): %w", err)
	}

	err = t.Execute(w, data)
	if err != nil {
		return fmt.Errorf("executeTemplate(): %w", err)
	}

	return nil
}
