package main

import (
	"log"
	"os"

	"a.yandex-team.ru/helpdesk/infra/baldr/cmd/server/config"
)

func main() {
	// Парсим конфигурацию из флагов и переменных окружения.
	cfg, err := config.NewConfiguration()
	if err != nil {
		log.Printf("Configuration is not valid: %s", err.Error())
		os.Exit(1)
	}

	// Создаем новый сервер.
	server, err := NewServer(cfg)
	if err != nil {
		log.Printf("Server error: %s", err.Error())
		os.Exit(1)
	}

	// Запускаем сервер.
	err = server.Serve()
	if err != nil {
		log.Printf("Server error: %s", err.Error())
		os.Exit(1)
	}
}
