package handler

import (
	"context"
	"fmt"
	"net/http"

	"a.yandex-team.ru/helpdesk/infra/baldr/internal/api/model"
	"a.yandex-team.ru/helpdesk/infra/baldr/internal/api/render"
)

// StartupMenu обрабатывает GET-запрос и возвращает скрипт для iPXE.
// Этот скрипт содержит загрузочное меню, в котором собраны все возможные варианты развертывания ОС.
func (h *DeployHandler) StartupMenu(w http.ResponseWriter, r *http.Request) {
	ctx, cancel := context.WithCancel(context.Background())
	defer cancel()

	// Получаем все шаблоны для развертывания ОС.
	templates, err := h.tm.Templates(ctx)
	if err != nil {
		err = fmt.Errorf("'StartupMenu' handler, service error: %w", err)
		h.handleError(ctx, w, err)
		return
	}

	// Готовим данные для ответа.
	templateData := model.StartupTemplateData{
		ProdEnvName: h.prodEnvName,
		TestEnvName: h.testEnvName,
		CurrentEnv:  h.currentEnv,
		ProdAddress: h.prodAddress,
		TestAddress: h.testAddress,
		Templates:   templates,
	}

	// Пишем ответ по шаблону.
	err = render.ExecuteTemplate(w, render.TemplateIPXEStartup, &templateData)
	if err != nil {
		err = fmt.Errorf("'StartupMenu' handler, service error: %w", err)
		h.handleError(ctx, w, err)
		return
	}

	w.WriteHeader(http.StatusOK)
}
