// Package render формирует тело ответа по шаблону и пишет его в http.ResponseWriter.
package render

import (
	"embed"
	"fmt"
	"net/http"
	"text/template"

	"a.yandex-team.ru/helpdesk/infra/baldr/internal/baldrerrors"
)

// Список файлов шаблонов.
const (
	TemplateIPXEStartup   = "resources/ipxe_startup.gotext"
	TemplateIPXEChainLoad = "resources/ipxe_chain_load.gotext"
)

var (
	// Создаем коллекцию файлов шаблонов, доступную только для чтения.
	//go:embed resources/*
	res embed.FS

	// Создаем список шаблонов.
	templates = map[string]bool{
		TemplateIPXEStartup:   true,
		TemplateIPXEChainLoad: true,
	}
)

// ExecuteTemplate формирует тело ответа по шаблону и пишет его в http.ResponseWriter, либо возвращает ошибку.
func ExecuteTemplate(w http.ResponseWriter, templateName string, data interface{}) error {
	// Проверяем наличие шаблона в списке.
	if ok := templates[templateName]; !ok {
		return fmt.Errorf("the template %q not found: %w", templateName, baldrerrors.ErrNotFound)
	}

	// Ищем и читаем файл шаблона.
	tpl, err := template.ParseFS(res, templateName)
	if err != nil {
		return fmt.Errorf("parse template: %w", err)
	}

	// Выполняем шаблон.
	err = tpl.Execute(w, data)
	if err != nil {
		return fmt.Errorf("execute template: %w", err)
	}

	return nil
}
