package render

import (
	_ "embed"
	"net/http/httptest"
	"testing"

	"a.yandex-team.ru/helpdesk/infra/baldr/cmd/server/config"
	"a.yandex-team.ru/helpdesk/infra/baldr/internal/api/model"
	model2 "a.yandex-team.ru/helpdesk/infra/baldr/internal/model"
	"github.com/stretchr/testify/assert"
)

//go:embed testdata/startup_menu_01.txt
var startupMenu01 string

func TestExecuteTemplate(t *testing.T) {
	tests := []struct {
		name         string
		templateName string
		data         interface{}
		want         string
		wantErr      assert.ErrorAssertionFunc
	}{
		{
			name:         "StartupMenu #1",
			templateName: TemplateIPXEStartup,
			data: model.StartupTemplateData{
				ProdEnvName: config.ApplicationEnvProd,
				TestEnvName: config.ApplicationEnvTest,
				CurrentEnv:  config.ApplicationEnvTest,
				ProdAddress: "api.baldr.yandex.net",
				TestAddress: "test.baldr.yandex.net",
				Templates: []model2.Template{
					{
						Name:        "market_warehouse",
						DisplayName: "Market Warehouse",
						Options:     make(map[string]string),
						Priority:    150,
					},
					{
						Name:        "saratov_call_center",
						DisplayName: "Saratov Call Center",
						Options:     make(map[string]string),
						Priority:    145,
					},
					{
						Name:        "windows_11_21h2",
						DisplayName: "Windows 11 Enterprise 21H2",
						Options:     make(map[string]string),
						Priority:    100,
					},
					{
						Name:        "windows_10_21h1",
						DisplayName: "Windows 10 Enterprise 21H1",
						Options:     make(map[string]string),
						Priority:    95,
					},
					{
						Name:        "windows_10_20h2",
						DisplayName: "Windows 10 Enterprise 20H2",
						Options:     make(map[string]string),
						Priority:    90,
					},
					{
						Name:        "windows_10_20h1",
						DisplayName: "Windows 10 Enterprise 20H1",
						Options:     make(map[string]string),
						Priority:    85,
					},
					{
						Name:        "animals",
						DisplayName: "Animals",
						Options:     make(map[string]string),
						Priority:    50,
					},
					{
						Name:        "animals_test",
						DisplayName: "Animals (Test)",
						Options:     make(map[string]string),
						Priority:    45,
					},
					{
						Name:        "wipe",
						DisplayName: "Wipe",
						Options:     make(map[string]string),
						Priority:    20,
					},
					{
						Name:        "linux_pre_deploy",
						DisplayName: "Linux Pre-deployment",
						Options:     make(map[string]string),
						Priority:    15,
					},
				},
			},
			want:    startupMenu01,
			wantErr: assert.NoError,
		},
	}

	for _, tt := range tests {
		t.Run(tt.name, func(t *testing.T) {
			w := httptest.NewRecorder()
			err := ExecuteTemplate(w, tt.templateName, &tt.data)
			tt.wantErr(t, err)
			assert.Equal(t, tt.want, w.Body.String())
		})
	}
}
