package router

import (
	"time"

	"github.com/go-chi/chi/v5"
	"github.com/go-chi/chi/v5/middleware"

	"a.yandex-team.ru/helpdesk/infra/baldr/internal/api/handler"
)

// NewRouter создает новый роутер.
func NewRouter(handler *handler.DeployHandler) *chi.Mux {
	router := chi.NewRouter()

	router.Use(middleware.RequestID)
	router.Use(middleware.RealIP)
	router.Use(middleware.Logger)
	router.Use(middleware.Recoverer)
	router.Use(middleware.Compress(5))
	router.Use(middleware.Timeout(60 * time.Second))

	router.Route("/v1", func(r chi.Router) {
		r.Route("/key_escrow", func(r chi.Router) {
			r.Post("/", handler.KeyEscrow)
		})
		r.Route("/ipxe", func(r chi.Router) {
			r.Get("/", handler.StartupMenu) // Deprecated. Retained for backward compatibility.
		})
		r.Route("/task", func(r chi.Router) {
			r.Get("/", handler.StartupMenu)
			r.Post("/new", handler.NewTask)
			r.Post("/close", handler.CloseTask)
			r.Route("/linux", func(r chi.Router) {
				r.Get("/preseed", handler.LinuxPreseed)
			})
			r.Route("/windows", func(r chi.Router) {
				r.Get("/config.xml", handler.WindowsConfigXML)
				r.Get("/bootstrap.ini", handler.WindowsBootstrapIni)
			})
		})
	})
	router.Route("/ping", func(r chi.Router) {
		r.Get("/", handler.Ping)
	})

	return router
}
