package baldrerrors

import "fmt"

type ErrorCode int

const (
	CodeOk                         ErrorCode = 0
	CodeDriversProfileNotFound     ErrorCode = 20
	CodeClosedByNewDeploy          ErrorCode = 51
	CodeClosedByTimeout            ErrorCode = 52
	CodeBadRequest                 ErrorCode = 100
	CodeHTTPRequestError           ErrorCode = 101
	CodeHTTPResponseError          ErrorCode = 102
	CodeInventoryNumberNotDefined  ErrorCode = 110
	CodeMoreThanOneInventoryNumber ErrorCode = 111
	CodeLocationNotDefined         ErrorCode = 120
	CodeMoreThanOneLocationFound   ErrorCode = 121
	CodeDeployServerNotFound       ErrorCode = 122
	CodeOFRError                   ErrorCode = 130
	CodeOFRUnmarshalError          ErrorCode = 131
	CodeMoreThanOneOFRFound        ErrorCode = 132
	CodeMoreThanOneOFRTagFound     ErrorCode = 133
	CodeOFRTagNotFound             ErrorCode = 134
	CodeUndefinedOS                ErrorCode = 140
	CodeUnsupportedOS              ErrorCode = 141
	CodeUnsupportedOSBuild         ErrorCode = 142
	CodeParseOSVersionStringError  ErrorCode = 143
	CodeInvalidUserName            ErrorCode = 150
	CodeInvalidComputerName        ErrorCode = 151
	CodeUnsupportedBootMode        ErrorCode = 160
	CodeYTClientError              ErrorCode = 170
	CodeYTRequestError             ErrorCode = 171
	CodeYTScanError                ErrorCode = 172
	CodeBadBattery                 ErrorCode = 180
	CodeBatteryCheckError          ErrorCode = 181
	CodeDBError                    ErrorCode = 200
	CodeDBInvalidData              ErrorCode = 201
)

func (e ErrorCode) String() string {
	switch e {
	case CodeOk:
		return "OK"
	case CodeDriversProfileNotFound:
		return "DriversProfileNotFound"
	case CodeClosedByNewDeploy:
		return "ClosedByNewDeploy"
	case CodeClosedByTimeout:
		return "ClosedByTimeout"
	case CodeBadRequest:
		return "BadRequest"
	case CodeHTTPRequestError:
		return "HTTPRequestError"
	case CodeHTTPResponseError:
		return "HTTPResponseError"
	case CodeInventoryNumberNotDefined:
		return "InventoryNumberNotDefined"
	case CodeMoreThanOneInventoryNumber:
		return "MoreThanOneInventoryNumber"
	case CodeLocationNotDefined:
		return "LocationNotDefined"
	case CodeMoreThanOneLocationFound:
		return "MoreThanOneLocationFound"
	case CodeDeployServerNotFound:
		return "DeployServerNotFound"
	case CodeMoreThanOneOFRFound:
		return "MoreThanOneOFRFound"
	case CodeOFRError:
		return "OFRError"
	case CodeOFRUnmarshalError:
		return "OFRUnmarshalError"
	case CodeMoreThanOneOFRTagFound:
		return "MoreThanOneOFRTagFound"
	case CodeOFRTagNotFound:
		return "OFRTagNotFound"
	case CodeUndefinedOS:
		return "UndefinedOS"
	case CodeUnsupportedOS:
		return "UnsupportedOS"
	case CodeUnsupportedOSBuild:
		return "UnsupportedOSBuild"
	case CodeParseOSVersionStringError:
		return "ParseOSVersionStringError"
	case CodeInvalidUserName:
		return "InvalidUserName"
	case CodeInvalidComputerName:
		return "InvalidComputerName"
	case CodeUnsupportedBootMode:
		return "UnsupportedBootMode"
	case CodeYTClientError:
		return "YTClientError"
	case CodeYTRequestError:
		return "YTRequestError"
	case CodeYTScanError:
		return "YTScanError"
	case CodeBadBattery:
		return "BadBattery"
	case CodeBatteryCheckError:
		return "BatteryCheckError"
	case CodeDBError:
		return "DBError"
	case CodeDBInvalidData:
		return "DBInvalidData"
	default:
		return fmt.Sprintf("UnknownCode%d", int(e))
	}
}
