package datastore

import (
	"a.yandex-team.ru/helpdesk/infra/baldr/internal/baldrerrors"
	"a.yandex-team.ru/helpdesk/infra/baldr/internal/models"
)

type Store interface {
	AddNewEntry(dep *models.Deploy) error
	DefineLocation(dep *models.Deploy) (int, error)
	CloseWithNewDeploy(dep *models.Deploy) error
	CloseByTimeout() error
	CloseTask(id string, errorCode baldrerrors.ErrorCode, message string) error
	SelectServer(dep *models.Deploy) error
	SupportedOS() ([]string, error)
	OSDefaultBuild(dep *models.Deploy) ([]models.OperationSystem, error)
	OSBuild(dep *models.Deploy) ([]models.OperationSystem, error)
	DriversProfile(dep *models.Deploy) ([]string, error)
	SupportBootingFromLegacyBIOS(dep *models.Deploy) ([]bool, error)
	OU(dep *models.Deploy) ([]string, error)
	DefaultOU() ([]string, error)
	DeploymentInfo(id string) (*models.Deploy, error)
	DeploymentData(id string) ([]models.DeployXML, error)
	DeploymentShare(id string) ([]models.DeploymentShare, error)
	DeploymentTemplate(name string) (map[string]string, error)
}
