package main

import (
	"testing"

	"a.yandex-team.ru/helpdesk/infra/ksc/pkg/ksc"
)

func TestIsBrowserComputer(t *testing.T) {
	browserDevelopers := []string{"bro_developer_01", "bro_developer_02", "bro_developer_03"}
	host := Host{
		HostInfo:     ksc.HostInfo{},
		KSCServer:    "server01",
		DN:           "OU=Computers,DC=example,DC=com",
		Tags:         nil,
		Users:        nil,
		Hardware:     Hardware{},
		MarkToDelete: false,
		DeleteReason: "",
	}

	User1 := UserInfo{}
	User1.SAMAccountName = "bro_developer_01"
	User1.Dismissed = false

	User2 := UserInfo{}
	User2.SAMAccountName = "bro_developer_02"
	User2.Dismissed = false

	User3 := UserInfo{}
	User3.SAMAccountName = "bro_developer_03"
	User3.Dismissed = true

	User4 := UserInfo{}
	User4.SAMAccountName = "developer_777"
	User4.Dismissed = false

	User5 := UserInfo{}
	User5.SAMAccountName = "developer_666"
	User5.Dismissed = true

	host.OEBSOwner = "bro_developer_02"
	if !IsBrowserComputer(&host, browserDevelopers) {
		t.Errorf("Test failed")
	}

	host.OEBSOwner = "developer_777"
	host.Users = []UserInfo{User1}
	if !IsBrowserComputer(&host, browserDevelopers) {
		t.Errorf("Test failed")
	}

	host.OEBSOwner = "developer_777"
	host.Users = []UserInfo{User1, User2}
	if !IsBrowserComputer(&host, browserDevelopers) {
		t.Errorf("Test failed")
	}

	host.OEBSOwner = "developer_777"
	host.Users = []UserInfo{User1, User2}
	if !IsBrowserComputer(&host, browserDevelopers) {
		t.Errorf("Test failed")
	}

	host.OEBSOwner = "developer_777"
	host.Users = []UserInfo{User1, User2, User3}
	if !IsBrowserComputer(&host, browserDevelopers) {
		t.Errorf("Test failed")
	}

	host.OEBSOwner = "developer_777"
	host.Users = []UserInfo{User1, User2, User3, User4}
	if IsBrowserComputer(&host, browserDevelopers) {
		t.Errorf("Test failed")
	}

	host.OEBSOwner = "developer_777"
	host.Users = []UserInfo{User1, User2, User3, User5}
	if !IsBrowserComputer(&host, browserDevelopers) {
		t.Errorf("Test failed")
	}

	host.OEBSOwner = "developer_777"
	host.Users = []UserInfo{}
	if IsBrowserComputer(&host, browserDevelopers) {
		t.Errorf("Test failed")
	}

	host.OEBSOwner = "developer_777"
	host.Users = []UserInfo{User3}
	if IsBrowserComputer(&host, browserDevelopers) {
		t.Errorf("Test failed")
	}
}
