package main

import (
	"fmt"
	"log"
	"os"
	"strings"
	"time"

	"a.yandex-team.ru/helpdesk/infra/ksc/pkg/ksc"
	"a.yandex-team.ru/yt/go/yt"
)

func main() {
	log.Printf("Start")
	defer log.Printf("Finish")
	kscServers := os.Getenv("KSC_SERVERS")
	var kscConfigs []kscConfig
	for _, server := range strings.Split(kscServers, ",") {
		config := kscConfig{
			workers:    10,
			serverName: server,
			config: ksc.Config{
				Server:       fmt.Sprintf("https://%s.ld.yandex.ru:13299", server),
				UserName:     "robot-avs-ksc",
				Password:     os.Getenv("KSC_PASSWORD"),
				Domain:       "ld.yandex.ru",
				InternalUser: false,
				VServerName:  "",
				XKscSession:  true,
				Debug:        false,
			},
		}
		kscConfigs = append(kscConfigs, config)
	}

	BotConfig := botConfig{
		workers: 20,
	}

	StaffConfig := staffConfig{
		host:    "https://staff-api.yandex-team.ru/v3/",
		token:   os.Getenv("STAFF_TOKEN"),
		workers: 20,
	}

	LDAPConfig := ldapConfig{
		Server:       "ldap://ld.yandex.ru:389",
		UserDN:       "cn=Robot-baldr Robot-baldr,ou=TechUsers,dc=ld,dc=yandex,dc=ru",
		UserPassword: os.Getenv("LDAP_USER_PASSWORD"),
		BaseDN:       "dc=ld,dc=yandex,dc=ru",
		workers:      20,
	}

	config := envConfig{
		ksc:   kscConfigs,
		bot:   BotConfig,
		staff: StaffConfig,
		ldap:  LDAPConfig,
		yt: yt.Config{
			Proxy:  "hahn",
			UseTLS: true,
			Token:  os.Getenv("YT_TOKEN"),
		},
	}

	var e *env
	var err error
	for {
		e, err = newEnv(config)
		if err != nil {
			log.Printf("main(): %s", err.Error())
			time.Sleep(time.Minute * 10)
			continue
		}
		break
	}

	jobTicker := &jobTicker{
		hourToTick:     1,
		minuteToTick:   0,
		secondToTick:   0,
		intervalPeriod: 10 * time.Minute,
	}

	jobTicker.updateTimer()
	for {
		<-jobTicker.timer.C
		err := e.RunTask()
		if err != nil {
			log.Printf("main(): %s", err.Error())
			jobTicker.intervalPeriod = 1 * time.Hour
		} else {
			jobTicker.intervalPeriod = 24 * time.Hour
		}
		jobTicker.updateTimer()
	}
	//log.Printf("[Debug] exit main()")
}
