package main

import (
	"log"
	"sync"
)

func (e *env) RemoveMarkedHosts(hosts []Host) {
	log.Printf("Start RemoveMarkedHosts")
	defer log.Printf("Finish RemoveMarkedHosts")

	if len(hosts) == 0 {
		return
	}

	MarkedHostsByServer := make(map[string][]string)
	for _, host := range hosts {
		if host.MarkToDelete {
			MarkedHostsByServer[host.KSCServer] = append(MarkedHostsByServer[host.KSCServer], host.ID)
		}
	}

	var wg sync.WaitGroup
	for server, hostIDs := range MarkedHostsByServer {
		wg.Add(1)
		go e.RemoveMarkedHostsFromServer(hostIDs, server, &wg)
	}
	wg.Wait()
}

func (e *env) RemoveMarkedHostsFromServer(id []string, server string, wg *sync.WaitGroup) {
	defer wg.Done()

	kscChan := e.getKscChan(server)
	if !kscChan.ok {
		log.Printf("env::RemoveMarkedHostsFromServer(): the channel to %s not found", server)
		return
	}

	var wgKSC sync.WaitGroup
	wgKSC.Add(1)
	out := make(chan Response)
	req := Request{
		Type: KSCRemoveHosts,
		Data: id,
		wg:   &wgKSC,
		Out:  out,
	}
	kscChan.ch <- req
	resp := <-out
	if resp.err != nil {
		log.Printf("env::RemoveMarkedHostsFromServer(): %v", resp.err)
		return
	}

	wgKSC.Add(1)
	req.Type = KSCRemoveUnassignedHosts
	req.Data = nil
	req.wg = &wgKSC
	req.Out = out

	kscChan.ch <- req
	resp = <-out
	if resp.err != nil {
		log.Printf("env::RemoveMarkedHostsFromServer(): %v", resp.err)
		return
	}
}
