package main

import (
	"time"
)

type jobTicker struct {
	intervalPeriod time.Duration
	hourToTick     int
	minuteToTick   int
	secondToTick   int
	timer          *time.Timer
}

func (t *jobTicker) updateTimer() {
	nextTick := time.Date(time.Now().Year(), time.Now().Month(),
		time.Now().Day(), t.hourToTick, t.minuteToTick, t.secondToTick, 0, time.Local)
	for {
		if !nextTick.After(time.Now()) {
			nextTick = nextTick.Add(t.intervalPeriod)
		} else {
			break
		}
	}

	diff := time.Until(nextTick)
	if t.timer == nil {
		t.timer = time.NewTimer(diff)
	} else {
		t.timer.Reset(diff)
	}
}
