package main

import (
	"fmt"
	"log"
	"sync"

	"a.yandex-team.ru/helpdesk/infra/ksc/pkg/ksc"
)

type RequestType uint

type Response struct {
	Data interface{}
	err  error
}

type Request struct {
	Type RequestType
	Data interface{}
	wg   *sync.WaitGroup
	Out  chan Response
}

const (
	BotFindInvNum RequestType = iota
	KSCGetHosts
	KSCGetHostInfo
	KSCGetHostHW
	KSCGetHostTags
	KSCGetHostUsers
	KSCRemoveHosts
	KSCRemoveUnassignedHosts
	KSCSetHostTags
	LDAPAddComputerToGroup
	LDAPFindComputerDN
	LDAPGetBroGroupMembers
	LDAPRemoveComputerFromGroup
	StaffGetGroupMembers
	StaffGetSubgroups
	StaffGetUserInfo
)

type UserInfo struct {
	ksc.GlobalUsersListView
	StaffUserAttr
}

type Hardware struct {
	Devices                 []ksc.HwInvPCView
	OEBSInventoryNumber     string
	OEBSType                BotOSType
	OEBSFQDN                string
	OEBSStatus              string
	OEBSOwner               string
	OEBSOwnerIsDismissed    bool
	OEBSOwnerDepartmentName string
	OEBSOwnerDepartmentID   int
}

type Host struct {
	ksc.HostInfo
	KSCServer string
	DN        string
	Tags      []ksc.HostTag
	Users     []UserInfo
	Hardware
	MarkToDelete bool
	DeleteReason string
}

func (e *env) RunTask() error {
	log.Printf("[Debug] run RunTask()")
	defer log.Printf("[Debug] exit RunTask()")

	hosts, err := e.gatherData()
	if err != nil {
		return fmt.Errorf("RunTask():%w", err)
	}

	hosts = MarkupHosts(hosts)
	err = e.MarkBrowserDevelopers(hosts)
	if err != nil {
		log.Printf("RunTask(): %s", err.Error())
	}
	e.RemoveMarkedHosts(hosts)

	err = e.WriteHostsData(hosts)
	if err != nil {
		return fmt.Errorf("RunTask():%w", err)
	}

	return nil
}
