package queue

type node struct {
	value int
	next  *node
}

type Queue struct {
	head *node
	size int
}

func (q *Queue) Push(value int) {
	if q.size == 0 {
		q.head = &node{
			value: value,
			next:  nil,
		}
		q.size++
		return
	}

	newNode := &node{
		value: value,
		next:  q.head,
	}

	q.head = newNode
	q.size++
}

func (q *Queue) Pop() (value int, ok bool) {
	if q.size == 0 {
		return 0, false
	}

	if q.size == 1 {
		value = q.head.value
		q.size--
		q.head = nil
		ok = true
		return
	}

	currentNode := q.head
	for currentNode.next.next != nil {
		currentNode = currentNode.next
	}

	value = currentNode.next.value
	ok = true
	currentNode.next = nil
	q.size--

	return
}

func (q *Queue) Size() int {
	return q.size
}
