package ksc

import (
	"context"
	"fmt"
	"net/http"
)

type HostTagsAPI service

const apiMethodHostTagsAPIGetHostTags apiMethod = "/api/v1.0/HostTagsApi.GetHostTags"

type hostTag struct {
	Name         string `json:"KLHST_TagValue"`
	SetByProduct bool   `json:"KLHST_IS_TAG_SET_BY_PRODUCT"`
	SetByTagRule bool   `json:"KLHST_IS_TAG_SET_BY_HOSTTAGRULE"`
}

type HostTag struct {
	Name         string
	SetByProduct bool
	SetByTagRule bool
}

func (t *hostTag) toHostTag() HostTag {
	ht := HostTag{
		Name:         t.Name,
		SetByProduct: t.SetByProduct,
		SetByTagRule: t.SetByTagRule,
	}

	return ht
}

func (hta *HostTagsAPI) GetHostTags(ctx context.Context, hostID string) ([]HostTag, error) {
	tags, err := hta.getHostTags(ctx, hostID)
	if err != nil {
		err = fmt.Errorf("HostTagsApi::GetHostTags(): %w", err)
		return nil, err
	}

	var ht []HostTag
	for _, tag := range tags {
		t := tag.toHostTag()
		ht = append(ht, t)
	}

	return ht, nil
}

func (hta *HostTagsAPI) getHostTags(ctx context.Context, hostID string) ([]hostTag, error) {
	req := hta.client.client.R()
	req.Method = http.MethodPost
	req.URL = apiMethodHostTagsAPIGetHostTags.String()

	var tags []hostTag

	reqData := struct {
		HostID string `json:"szwHostId"`
	}{
		HostID: hostID,
	}

	resp := struct {
		Data []struct {
			Type  string  `json:"type"`
			Value hostTag `json:"value"`
		} `json:"PxgRetVal"`
		Error kscError `json:"PxgError"`
	}{}

	req.Body = reqData

	err := hta.client.do(ctx, req, &resp)
	if err != nil {
		err = fmt.Errorf("HostTagsApi::getHostTags(): %w", err)
		return tags, err
	}

	if resp.Error.Code != 0 {
		return tags, fmt.Errorf("HostTagsApi::getHostTags(): code %d: %s", resp.Error.Code, resp.Error.Message)
	}

	for _, entry := range resp.Data {
		tags = append(tags, entry.Value)
	}

	return tags, nil
}
