awscli-package:
  pkg.installed:
    - name: awscli

s3reader:
  user.present:
    - fullname: S3 Reader
    - shell: /bin/bash
    - home: /home/s3reader
    - password: {{ pillar['s3reader']['password-hash'] | json }}

awscli-config-dir:
  file.directory:
    - name: /home/s3reader/.aws
    - user: s3reader
    - group: s3reader
    - dir_mode: 755
    - require:
      - user: s3reader

awscli-config:
  file.managed:
    - require:
      - file: awscli-config-dir
    - name: /home/s3reader/.aws/config
    - contents: |
        [default]

awscli-credentials:
  file.managed:
    - require:
      - file: awscli-config-dir
    - name: /home/s3reader/.aws/credentials
    - contents: |
        [default]
        aws_access_key_id = {{ pillar['awscli']['access-key-id'] }}
        aws_secret_access_key = {{ pillar['awscli']['access-secret-key'] }}

awscli-sync-root-dir:
  file.directory:
    - name: /var/storage
    - user: s3reader
    - group: s3reader
    - dir_mode: 755
    - require:
      - user: s3reader

awscli-sync-ds-dir:
  file.directory:
    - name: /var/storage/ds
    - user: s3reader
    - group: s3reader
    - dir_mode: 755
    - require:
      - file: awscli-sync-root-dir

awscli-sync-nginx-dir:
  file.directory:
    - name: /var/storage/nginx
    - user: s3reader
    - group: s3reader
    - file_mode: 744
    - dir_mode: 755
    - recurse:
      - user
      - group
      - mode
    - require:
      - file: awscli-sync-root-dir

awscli-sync-tftp-dir:
  file.directory:
    - name: /var/storage/tftp
    - user: s3reader
    - group: s3reader
    - file_mode: 744
    - dir_mode: 755
    - recurse:
      - user
      - group
      - mode
    - require:
      - file: awscli-sync-root-dir

awscli-sync-ds-control-dir:
  file.directory:
    - name: /var/storage/ds/Control
    - user: s3reader
    - group: s3reader
    - file_mode: 744
    - dir_mode: 755
    - recurse:
      - user
      - group
      - mode
    - require:
      - file: awscli-sync-ds-dir

awscli-sync-ds-os-dir:
  file.directory:
    - name: '/var/storage/ds/Operating Systems'
    - user: s3reader
    - group: s3reader
    - file_mode: 744
    - dir_mode: 755
    - recurse:
      - user
      - group
      - mode
    - require:
      - file: awscli-sync-ds-dir

awscli-sync-ds-drivers-dir:
  file.directory:
    - name: '/var/storage/ds/Out-of-Box Drivers'
    - user: s3reader
    - group: s3reader
    - file_mode: 744
    - dir_mode: 755
    - recurse:
      - user
      - group
      - mode
    - require:
      - file: awscli-sync-ds-dir

awscli-sync-ds-pkg-dir:
  file.directory:
    - name: /var/storage/ds/Packages
    - user: s3reader
    - group: s3reader
    - file_mode: 744
    - dir_mode: 755
    - recurse:
      - user
      - group
      - mode
    - require:
      - file: awscli-sync-ds-dir

awscli-sync-ds-scripts-dir:
  file.directory:
    - name: /var/storage/ds/Scripts
    - user: s3reader
    - group: s3reader
    - file_mode: 755
    - dir_mode: 755
    - recurse:
      - user
      - group
      - mode
    - require:
      - file: awscli-sync-ds-dir

awscli-sync-ds-tools-dir:
  file.directory:
    - name: /var/storage/ds/Tools
    - user: s3reader
    - group: s3reader
    - file_mode: 755
    - dir_mode: 755
    - recurse:
      - user
      - group
      - mode
    - require:
      - file: awscli-sync-ds-dir

